/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs1;

import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs1.MGF1;
import iaik.pkcs.pkcs1.MaskGenerationAlgorithm;
import iaik.pkcs.pkcs1.RSAOaepPSourceParameterSpec;
import iaik.security.md.SHA;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class RSAOaepParameterSpec
extends RSAOaepPSourceParameterSpec
implements Cloneable {
    private Boolean e;
    private MaskGenerationAlgorithm b;
    private AlgorithmID a;
    private MessageDigest d;
    private AlgorithmID c;
    public static final AlgorithmID DEFAULT_MASK_GEN_ALGORITHM;
    public static final AlgorithmID DEFAULT_HASH_ALGORITHM;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Hash algorithm: " + this.c + "\n");
        stringBuffer.append("Mask generation algorithm: " + this.a + "\n");
        stringBuffer.append("PSource algorithm: " + this.pSourceAlgorithm_ + "\n");
        return stringBuffer.toString();
    }

    public void setMGFEngine(MaskGenerationAlgorithm maskGenerationAlgorithm) {
        this.b = maskGenerationAlgorithm;
    }

    public void setHashEngine(MessageDigest messageDigest) {
        this.d = messageDigest;
    }

    public void setEncodeDefaultValues(Boolean bl) {
        this.e = bl;
    }

    public int hashCode() {
        return this.c.hashCode() ^ this.a.hashCode() ^ this.pSourceAlgorithm_.hashCode();
    }

    public AlgorithmID getMaskGenAlgorithm() {
        return this.a;
    }

    public MaskGenerationAlgorithm getMGFEngine() throws NoSuchAlgorithmException {
        if (this.b == null) {
            this.b = this.a.getMaskGenerationAlgorithmInstance();
            AlgorithmParameters algorithmParameters = this.a.getAlgorithmParameters();
            try {
                this.b.setParameters(algorithmParameters);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new NoSuchAlgorithmException("Cannot init MGF parameters: " + invalidAlgorithmParameterException.getMessage());
            }
        }
        return this.b;
    }

    public MessageDigest getHashEngine() throws NoSuchAlgorithmException {
        if (this.d == null) {
            try {
                this.d = this.c.getMessageDigestInstance("IAIK");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.d = this.c.getMessageDigestInstance();
            }
        } else {
            this.d.reset();
        }
        return this.d;
    }

    public AlgorithmID getHashAlgorithm() {
        return this.c;
    }

    public Boolean getEncodeDefaultValues() {
        return this.e;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof RSAOaepParameterSpec) {
            RSAOaepParameterSpec rSAOaepParameterSpec = (RSAOaepParameterSpec)object;
            bl = this.c.equals(rSAOaepParameterSpec.c) && this.a.equals(rSAOaepParameterSpec.a, true) && this.pSourceAlgorithm_.equals(rSAOaepParameterSpec.pSourceAlgorithm_, true);
        }
        return bl;
    }

    public Object clone() {
        RSAOaepParameterSpec rSAOaepParameterSpec = null;
        try {
            rSAOaepParameterSpec = (RSAOaepParameterSpec)super.clone();
            rSAOaepParameterSpec.c = (AlgorithmID)this.c.clone();
            rSAOaepParameterSpec.a = (AlgorithmID)this.a.clone();
            rSAOaepParameterSpec.pSourceAlgorithm_ = (AlgorithmID)this.pSourceAlgorithm_.clone();
            if (this.d != null) {
                rSAOaepParameterSpec.d = (MessageDigest)this.d.clone();
            }
            if (this.b != null) {
                rSAOaepParameterSpec.b = (MaskGenerationAlgorithm)this.b.clone();
            }
            if (this.e != null) {
                rSAOaepParameterSpec.e = new Boolean(this.e);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return rSAOaepParameterSpec;
    }

    public RSAOaepParameterSpec(AlgorithmID algorithmID, AlgorithmID algorithmID2, AlgorithmID algorithmID3) {
        super(algorithmID3);
        if (algorithmID == null) {
            throw new IllegalArgumentException("HashAlgorithm id must not be null!");
        }
        this.c = algorithmID;
        if (algorithmID2 == null) {
            throw new IllegalArgumentException("MaskGenAlgorithm id must no be null!");
        }
        this.a = algorithmID2;
    }

    public RSAOaepParameterSpec() {
        this.c = (AlgorithmID)DEFAULT_HASH_ALGORITHM.clone();
        this.d = new SHA();
        this.a = (AlgorithmID)AlgorithmID.mgf1.clone();
        this.a.setParameter(this.c.toASN1Object());
        this.b = new MGF1(this.c, this.d);
    }

    static {
        DEFAULT_HASH_ALGORITHM = (AlgorithmID)AlgorithmID.sha1.clone();
        DEFAULT_MASK_GEN_ALGORITHM = (AlgorithmID)AlgorithmID.mgf1.clone();
        DEFAULT_MASK_GEN_ALGORITHM.setParameter(DEFAULT_HASH_ALGORITHM.toASN1Object());
    }
}

