<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Problmes lis au DNS avec le serveur HTTP Apache - Serveur Apache HTTP Version 2.4</title>
<link href="./style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="./style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="./style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="./style/css/prettify.css" />
<script src="./style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="./images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="./images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="./images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="./">Version 2.4</a></div><div id="page-content"><div id="preamble"><h1>Problmes lis au DNS avec le serveur HTTP Apache</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="./en/dns-caveats.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./fr/dns-caveats.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/dns-caveats.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/dns-caveats.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="./tr/dns-caveats.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>

    <p>Cette page pourrait se rsumer ainsi : configurez le
    serveur HTTP Apache de faon
     ce qu'il n'ait pas besoin de rsolution DNS pour interprter les
    fichiers de configuration. Si httpd doit effectuer des rsolutions
    DNS pour interprter les fichiers de configuration, votre serveur
    pourra prsenter des problmes de fiabilit (en d'autres termes,
    il est possible qu'il refuse de dmarrer), ou d'attaques par dni ou
    usurpation de service (y compris l'attribution de requtes  un
    serveur virtuel autre que le serveur virtuel voulu).</p>
  </div>
<div id="quickview"><ul id="toc"><li><img alt="" src="./images/down.gif" /> <a href="#example">Un exemple simple</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#denial">Dni de service</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#main">L'adresse du "serveur principal"</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#tips">Conseils pour viter ce genre de problme</a></li>
</ul><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="example" id="example">Un exemple simple</a></h2>
    

    <pre class="prettyprint lang-config"># Ceci est un exemple de mauvaise configuration ; ne l'utilisez pas comme base
# de configuration
&lt;VirtualHost www.example.dom&gt;
  ServerAdmin webgirl@example.dom
  DocumentRoot /www/example
&lt;/VirtualHost&gt;</pre>


    <p>Pour fonctionner correctement, le serveur a absolument besoin de deux
    informations  propos de chaque serveur virtuel : le nom du serveur
    dfini par la directive <code class="directive"><a href="./mod/core.html#servername">ServerName</a></code>, et au moins une adresse IP 
    laquelle le serveur va se rattacher et rpondre. L'exemple ci-dessus
    ne comporte pas d'adresse IP, si bien que httpd devra utiliser le
    DNS pour trouver l'adresse IP de <code>www.example.dom</code>. Si pour
    une raison quelconque, le DNS n'est pas disponible au moment o
    votre serveur interprte son fichier de configuration, ce serveur
    virtuel <strong>ne sera pas pris en compte dans la
    configuration</strong>. Il sera incapable de
    rpondre  toute requte pour ce serveur virtuel.</p>

    <p>Supposons que l'adresse de <code>www.example.dom</code> soit
    192.0.2.1, et examinons cet extrait de configuration :</p>

    <pre class="prettyprint lang-config"># Ceci est un exemple de mauvaise configuration ; ne l'utilisez pas comme base
# de configuration
&lt;VirtualHost 192.0.2.1&gt;
  ServerAdmin webgirl@example.dom
  DocumentRoot /www/example
&lt;/VirtualHost&gt;</pre>


    <p>Cette fois, httpd doit effectuer une recherche DNS inverse pour
    trouver le nom <code>ServerName</code> de ce serveur virtuel. Si
    cette recherche inverse choue, le serveur virtuel sera
    partiellement dsactiv. Si le serveur
    virtuel est  base de nom, il sera en fait totalement dsactiv,
    mais s'il est  base d'adresse IP, il fonctionnera probablement.
    Cependant, httpd chouera s'il doit gnrer une URL complte pour
    le serveur qui inclut ce nom de serveur (comme dans le cas d'une
    redirection).</p>

    <p>Voici un extrait de configuration qui permet d'viter ces deux
    types de problmes :</p>

    <pre class="prettyprint lang-config">&lt;VirtualHost 192.0.2.1&gt;
  ServerName www.example.dom
  ServerAdmin webgirl@example.dom
  DocumentRoot /www/example
&lt;/VirtualHost&gt;</pre>

  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="denial" id="denial">Dni de service</a></h2>
    

    <p>Considrons cet extrait de configuration :</p>

    <pre class="prettyprint lang-config">&lt;VirtualHost www.example1.dom&gt;
  ServerAdmin webgirl@example1.dom
  DocumentRoot /www/example1
&lt;/VirtualHost&gt;
&lt;VirtualHost www.example2.dom&gt;
  ServerAdmin webguy@example2.dom
  DocumentRoot /www/example2
&lt;/VirtualHost&gt;</pre>


    <p>Supposons que vous ayez assign 192.0.2.1 
    <code>www.example1.dom</code> et 192.0.2.2  <code>www.example2.dom</code>. En
    outre, supposons que <code>example1.dom</code> gre son propre DNS. Avec
    cette configuration, <code>example1.dom</code> sera en mesure de
    dtourner tout trafic destin  <code>example2.dom</code>. Pour y
    parvenir, tout ce qu'ils ont  faire consiste 
    assigner 192.0.2.2 
    <code>www.example1.dom</code>. Comme ils grent leur propre DNS, vous ne
    pouvez pas les empcher de faire pointer l'enregistrement
    <code>www.example1.dom</code> vers l'adresse qu'ils veulent.</p>

    <p>Les requtes  destination de 192.0.2.2 (y compris toutes celles
    o l'utilisateur  tap une URL de la forme
    <code>http://www.example2.dom/quelquepart</code>), seront toutes servies
    par le serveur virtuel <code>example1.dom</code>. Une meilleur
    comprhension de la raison pour laquelle ceci peut se produire
    ncessite une discussion plus approfondie  propos de la manire
    dont httpd associe les requtes entrantes aux diffrents serveurs
    virtuels qui vont les servir. Un document de base dcrivant ceci <a href="vhosts/details.html">est disponible</a>.</p>
  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="main" id="main">L'adresse du "serveur principal"</a></h2>
    

    <p><a href="vhosts/name-based.html">Le support des
    serveurs virtuels  base de nom</a> oblige httpd 
    connatre la/les adresse(s) IP de l'hte sur
    lequel <code class="program"><a href="./programs/httpd.html">httpd</a></code> s'excute. Pour obtenir cette
    adresse, soit il utilise la directive <code class="directive"><a href="./mod/core.html#servername">ServerName</a></code> globale (si elle est prsente),
    soit il fait appel  la fonction C <code>gethostname</code> (qui
    doit renvoyer le mme nom que la commande shell "hostname"). Il
    effectue ensuite une recherche DNS sur cette adresse. Pour le
    moment, il n'existe aucun moyen d'viter cette recherche DNS.</p>

    <p>Si vous craignez que cette recherche DNS choue parce que votre
    serveur DNS est arrt, vous pouvez insrer le nom d'hte dans le
    fichier <code>/etc/hosts</code> (o il est probablement dj
    enregistr afin que la machine dmarre correctement). Assurez-vous
    ensuite que la machine est configure pour utiliser
    <code>/etc/hosts</code> dans le cas o la recherche DNS choue.
    Suivant le systme d'exploitation que vous utilisez, vous y
    parviendrez en ditant <code>/etc/resolv.conf</code>, ou
    <code>/etc/nsswitch.conf</code>.</p>

    <p>Si votre serveur n'a aucune autre raison d'effectuer des
    recherches DNS, vous pouvez dfinir la variable d'environnement
    <code>HOSTRESORDER</code>  "local", et vous serez alors en mesure
    d'excuter httpd. Tout dpend du systme d'exploitation et des
    bibliothques de rsolution de noms que vous utilisez. Elle affecte
    aussi les programmes CGI,  moins que vous n'utilisiez
    <code class="module"><a href="./mod/mod_env.html">mod_env</a></code> pour contrler l'environnement. Il est
    conseill de consulter les pages de manuel ou les FAQs de votre
    systme d'exploitation.</p>
  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="tips" id="tips">Conseils pour viter ce genre de problme</a></h2>
    

    <ul>
      <li>
        utilisez des adresses IP au sein des <code class="directive"><a href="./mod/core.html#virtualhost">VirtualHost</a></code>
      </li>

      <li>
        utilisez des adresses IP avec la directive <code class="directive"><a href="./mod/mpm_common.html#listen">Listen</a></code>
      </li>

      <li>
        vrifiez que tous les serveurs virtuels possdent un nom
	<code class="directive"><a href="./mod/core.html#servername">ServerName</a></code>	explicite
      </li>

      <li>crez un serveur virtuel <code>&lt;VirtualHost
      _default_:*&gt;</code> qui n'a aucune page  servir</li>
    </ul>
  </div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="./en/dns-caveats.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./fr/dns-caveats.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/dns-caveats.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/dns-caveats.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="./tr/dns-caveats.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="./images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/dns-caveats.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2015 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>