/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 1990 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*	Copyright (c) 1984, 1986, 1987, 1988, 1989 AT&T	*/
/*	  All Rights Reserved  	*/

#ifndef	_HASH_H
#define	_HASH_H

#ifdef	SCHILY_BUILD
#include <schily/mconfig.h>
#endif

#if defined(sun)
#pragma ident	"@(#)hash.h	1.8	05/09/13 SMI"
#endif

/*
 * This file contains modifications Copyright 2008-2012 J. Schilling
 *
 * @(#)hash.h	1.6 12/05/11 2008-2012 J. Schilling
 */

/*
 *	UNIX shell
 */
#ifdef	__cplusplus
extern "C" {
#endif

#define		HASHZAP		0x03FF
#define		CDMARK		0x8000

#define		NOTFOUND	0x0000
#define		BUILTIN		0x0100
#define		FUNCTION	0x0200
#define		COMMAND		0x0400
#define		REL_COMMAND	0x0800
#define		PATH_COMMAND	0x1000
#define		DOT_COMMAND	0x8800	/* CDMARK | REL_COMMAND */

#define		hashtype(x)	(x & 0x1F00)
#define		hashdata(x)	(x & 0x00FF)


typedef struct entry
{
	unsigned char	*key;
	short		data;
	unsigned char	hits;
	unsigned char	cost;
	struct entry	*next;
} ENTRY;

extern ENTRY	*hfind	__PR((unsigned char *));
extern ENTRY	*henter	__PR((ENTRY));
extern void	hcreate	__PR((void));
extern void	hscan	__PR((void (*uscan)(ENTRY *)));

#ifdef	__cplusplus
}
#endif

#endif /* !_HASH_H */
