/****************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the FOO module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/


/******************** Desktop **************************************/
var qt6Init = "qt.qt6"
var qt6Version = "623"
var qt6DisplayVersion = "6.2"

var windowsCompilersInPreferredOrderJSON = '{ "items" : [' +
    '{ "id":"win64_mingw" , "name":"MinGW 11.2.0 64-bit" } ]}';

var desktop6 = qt6Init + "." + qt6Version;
var mobileiOS = desktop6 + ".ios"
var mobileAndroid = desktop6 + ".android"
var desktop6Clang = desktop6 + ".clang_64"
var desktop6GCC = desktop6 + ".gcc_64"

/******************** B2Qt ****************************************/
var qt6EmbeddedInit = "embedded.b2qt"
var qt6EmbeddedVersion = "623"
var qt6EmbeddedDisplayVersion = "6.2"

//name field is just a placeholder, the actual text is read from package DisplayName
var b2qtTargetsInPreferredOrderJSON = '{ "items" : [' +
    '{ "id":"apalisimx6" , "name":"Toradex Apalis iMX6" },' +
    '{ "id":"jetsontx2" , "name":"NVIDIA Jetson TX2" },' +
    '{ "id":"intel" , "name":"Intel NUC" },' +
    '{ "id":"colibriimx6ull" , "name":"Toradex Colibri iMX6 ULL" },' +
    '{ "id":"imx8qmmek" , "name":"NXP i.MX 8QuadMax MEK" },' +
    '{ "id":"imx8mmevk" , "name":"NXP i.MX 8M Mini LPDDR4 EVK" } ]}';

var b2Qt6 = qt6EmbeddedInit + "." + qt6EmbeddedVersion;

/******************** MCU *****************************************/
var mcuInit = "mcu"
var mcuVersion = "0200"
var qtMCUDisplayVersion = "2.0"

//name field is just a placeholder, the actual text is read from package DisplayName
var mcuTargetsInPreferredOrderJSON = '{ "items" : [' +
    '{ "id":"common_files" , "name":"Desktop target and host tools only" },' +
    '{ "id":"tviic2d6m" , "name":"Infineon/Cypress Traveo II kit" },' +
    '{ "id":"mimxrt1050-evk" , "name":"NXP i.MX RT1050 EVK" },' +
    '{ "id":"mimxrt1060-evk" , "name":"NXP i.MX RT1060 EVK" },' +
    '{ "id":"mimxrt1064-evk" , "name":"NXP i.MX RT1064 EVK" },' +
    '{ "id":"mimxrt1170-evk" , "name":"NXP i.MX RT1170 EVK" },' +
    '{ "id":"ek-ra6m3g" , "name":"Renesas EK-RA6M3G" },' +
    '{ "id":"rh850-d1m1a" , "name":"Renesas RH850 D1M1A" },' +
    '{ "id":"stm32f469i-discovery" , "name":"STM32F469I Discovery" },' +
    '{ "id":"stm32f769i-discovery" , "name":"STM32F769I Discovery" },' +
    '{ "id":"stm32h750b-discovery" , "name":"STM32H750B Discovery" } ]}';

var mcu = mcuInit + "." + mcuVersion

/******************** Design Studio *****************************************/
var toolsDesignStudio = "qt.tools.qtdesignstudio"

/******************** GENERAL ***********************************************/
var qt6MingwDescription = QT_TR_NOOP("MinGW toolchain and Qt libraries for MinGW")
var qt6ClangDescription = QT_TR_NOOP("Qt libraries for clang")
var qt6GCCDescription = QT_TR_NOOP("Qt libraries for GCC")
var designStudioDescription = QT_TR_NOOP("Qt Design Studio")
var qt6MobileDescription = QT_TR_NOOP("Qt libraries for Android and iOS - platform restrictions apply")

var desktopDevelopment = QT_TR_NOOP("Qt %1 for desktop development")
var designTools = QT_TR_NOOP("Design Tools")
var embeddedDevelopment = QT_TR_NOOP("Qt %1 for embedded development")
var mcuDevelopment = QT_TR_NOOP("MCU development")
var mobileDevelopment = QT_TR_NOOP("Qt %1 for mobile development")

var mainTargetsJSON = '{ "items" : [' +
    '{ "id": "' + desktop6 + '", "name": "' + qsTranslate("installscript", desktopDevelopment).arg(qt6DisplayVersion) + '", "description": "' + qt6MingwDescription + '" },' +
    '{ "id": "' + desktop6Clang + '", "name": "' + qsTranslate("installscript", desktopDevelopment).arg(qt6DisplayVersion) + '", "description": "' + qt6ClangDescription + '" },' +
    '{ "id": "' + desktop6GCC + '", "name": "' + qsTranslate("installscript", desktopDevelopment).arg(qt6DisplayVersion) + '", "description": "' + qt6GCCDescription + '" },' +
    '{ "id": "' + toolsDesignStudio + '", "name": "' + designTools + '" , "description": "' + designStudioDescription + '" },' +
    '{ "id": "' + b2Qt6 + '", "name": "' + qsTranslate("installscript", embeddedDevelopment).arg(qt6EmbeddedDisplayVersion) + '", "description": "" },' +
    '{ "id": "' + mcu + '" , "name": "' + mcuDevelopment  + '", "description": "" },' +
    '{ "id": "' + mobileiOS + '", "name": "' + qsTranslate("installscript", mobileDevelopment).arg(qt6DisplayVersion) + '", "description": "' + qt6MobileDescription + '" },' +
    '{ "id": "' + mobileAndroid + '", "name": "' + qsTranslate("installscript", mobileDevelopment).arg(qt6DisplayVersion) + '", "description": "' + qt6MobileDescription + '" } ]}';

/******************** INTERNAL *************************************/
function getItemValueForTarget(id, prop){
    for (var i =0; i < mainTargets.items.length; i++){
        if (mainTargets.items[i].id === id) {
            if (mainTargets.items[i].hasOwnProperty(prop) === true)
                return mainTargets.items[i][prop];
            else
                return "";
        }
    }
    return "";
}

var mainTargets = JSON.parse(mainTargetsJSON);
var windowsCompilers = JSON.parse(windowsCompilersInPreferredOrderJSON);
var b2qtTargets = JSON.parse(b2qtTargetsInPreferredOrderJSON);
var mcuTargets = JSON.parse(mcuTargetsInPreferredOrderJSON);

var selectionWidget;
var componentsToInstall = [];

var qt6DesktopComponent;
var qt6MobileComponents = [];
var qt6EmbeddedComponent;
var qtMCUComponent;
var qtDesignStudioComponent;

function Component()
{
    //This repository contains feature that is available only from 4.1.1 onwards (QTIFW-2225)
    var ifwVersion = installer.value("FrameworkVersion");
    if (!installer.isInstaller() || installer.versionMatches(ifwVersion, "<4.1.1"))
        return;

    if (installer.addWizardPageItem(component, "InstallTypeWidget", QInstaller.TargetDirectory, 0)) {
        component.loaded.connect(this, Component.prototype.loaded);
    } else if (installer.isCommandLineDefaultInstall()) {
        var installComponent;
        if (installer.value("os") == "win")
            installComponent = getComponent(desktop6, windowsCompilers);
        else if (installer.value("os") == "mac")
            installComponent = getComponent(desktop6Clang);
        else
            installComponent = getComponent(desktop6GCC);

        if (installComponent != "")
            installer.componentByName(installComponent).setValue("Default", "true");
    }
}

setAvailableTargets = function(qtVersionId, targets, uiFrame, comboBox)
{
    var availableTarget = []
    var components = installer.components(qtVersionId);
    for (i = 0; i < targets.items.length; i++) {
        for (j = 0; j < components.length; j++) {
            var componentName = components[j].name;
            var componentId = componentName.slice(qtVersionId.length + 1);
            if (componentId == targets.items[i].id) {
                if (availableTarget.indexOf(targets.items[i].name) == -1) {
                    targets.items[i].name = components[j].displayName;
                    availableTarget.push(components[j].displayName);
                    break;
                }
            }
        }
    }
    if (availableTarget.length == 0)
        uiFrame.visible = false;
    else
        gui.setTextItems(comboBox, availableTarget);
}

getId = function (combobox, targets)
{
    var currentText = combobox.currentText;
    var id = "";
    for (j = 0; j < targets.items.length; j++) {
        if (currentText === targets.items[j].name) {
            id = targets.items[j].id;
            break;
        }
    }
    return id;
}

b2Qt6TargetChanged = function()
{
    //Select the checkbox, if not already selected, when we change the target
    if (selectionWidget.qt6EmbeddedFrame.qt6EmbeddedCheckBox.checked == false)
        selectionWidget.qt6EmbeddedFrame.qt6EmbeddedCheckBox.checked = true
    var selectedTarget = getId(selectionWidget.qt6EmbeddedFrame.qt6EmbeddedComboBox, b2qtTargets);
    qt6EmbeddedComponent = b2Qt6 + "." + selectedTarget;
    selectComponentForInstall();
}

mcuTargetChanged = function()
{
    //Select the checkbox, if not already selected, when we change the target
    if (selectionWidget.qt6MCUFrame.qt6MCUCheckBox.checked == false)
        selectionWidget.qt6MCUFrame.qt6MCUCheckBox.checked = true
    var selectedTarget = getId(selectionWidget.qt6MCUFrame.qt6MCUComboBox, mcuTargets);
    qtMCUComponent = mcu + "." + selectedTarget;
    selectComponentForInstall();
}

deselectAllComponents = function()
{
    for (i = 0; i < componentsToInstall.length; i++) {
        var component = installer.componentByName(componentsToInstall[i]);
        if (component)
            installer.deselectComponent(componentsToInstall[i]);
    }
    componentsToInstall = [];
}

selectComponentForInstall = function(checked)
{
    deselectAllComponents();
    //Select new components
    if (selectionWidget.qt6MobileFrame.qt6MobileCheckBox.checked == true)
        componentsToInstall = componentsToInstall.concat(qt6MobileComponents);
    if (selectionWidget.qt6DesktopFrame.qt6DesktopCheckBox.checked == true)
        componentsToInstall.push(qt6DesktopComponent);
    if (selectionWidget.qt6EmbeddedFrame.qt6EmbeddedCheckBox.checked == true)
        componentsToInstall.push(qt6EmbeddedComponent);
    if (selectionWidget.qt6MCUFrame.qt6MCUCheckBox.checked == true)
        componentsToInstall.push(qtMCUComponent);
    if (selectionWidget.designStudioFrame.designStudioCheckBox.checked == true)
        componentsToInstall.push(qtDesignStudioComponent);

    if (componentsToInstall.length == 0) {
        selectionWidget.customFrame.customCheckBox.checked = true;
        installer.setDefaultPageVisible(QInstaller.ComponentSelection, true);
    } else {
        selectionWidget.customFrame.customCheckBox.checked = false;
        installer.setDefaultPageVisible(QInstaller.ComponentSelection, false);
    }

    for (j = 0; j < componentsToInstall.length; j++) {
        var component = installer.componentByName(componentsToInstall[j]);
        if (component)
            installer.selectComponent(componentsToInstall[j]);
        else
            console.log("Component not found " + componentsToInstall[j]);
    }

    if ((componentsToInstall.length == 1) && (componentsToInstall[0] == toolsDesignStudio))
        installer.setValue("DesignStudioInstallOnly", true);
    else
        installer.setValue("DesignStudioInstallOnly", false);

    installer.clearComponentsToInstallCalculated();
    installer.calculateComponentsToInstall()
}

customInstallationSelected = function(checked)
{
    if (selectionWidget.customFrame.customCheckBox.checked == true) {
        selectionWidget.qt6MobileFrame.qt6MobileCheckBox.checked = false;
        selectionWidget.qt6DesktopFrame.qt6DesktopCheckBox.checked = false;
        selectionWidget.qt6EmbeddedFrame.qt6EmbeddedCheckBox.checked = false;
        selectionWidget.qt6MCUFrame.qt6MCUCheckBox.checked = false;
        selectionWidget.designStudioFrame.designStudioCheckBox.checked = false;
        deselectAllComponents();
        var designStudioComponent = installer.componentByName(toolsDesignStudio);
        if (designStudioComponent && designStudioComponent.value("Default") == "true")
            installer.selectComponent(toolsDesignStudio);
        installer.clearComponentsToInstallCalculated();
        installer.calculateComponentsToInstall();
        installer.setDefaultPageVisible(QInstaller.ComponentSelection, true);
    }
}

initCheckBox = function(checkBox, label, buttonFrame, qtVersionId, targets)
{
    var selectedComponent = getComponent(qtVersionId, targets);
    //If no component found behind the checkBox, hide the checkBox
    if (selectedComponent == "") {
        buttonFrame.visible = false;
    } else {
        checkBox.text = qsTranslate("installscript", getItemValueForTarget(qtVersionId, "name"));
        if (label)
            label.text = qsTranslate("installscript", getItemValueForTarget(qtVersionId, "description"));
        checkBox.clicked.connect(selectComponentForInstall);
    }
    return selectedComponent;
}

getComponent = function(qtVersionId, targets)
{
    var selectedComponent = "";
    var components = installer.components(qtVersionId);
    if (targets != undefined) {
loop1:
        for (i = 0; i < targets.items.length; i++) {
loop2:
            for (j = 0; j < components.length; j++) {
                var componentName = components[j].name;
                var componentId = componentName.slice(qtVersionId.length + 1);
                if (componentId == targets.items[i].id) {
                    selectedComponent = componentName;
                    break loop1;
                }
            }
        }
    } else if (components.length > 0) {
        selectedComponent = components[0].name;
    }
    return selectedComponent;
}

initMobileCheckBox = function(checkBox, label, buttonFrame, qtVersionIds)
{
    var selectedComponents = [];
    var components = [];
    for (i = 0; i < qtVersionIds.length; i++)
        components = components.concat(installer.components(qtVersionIds[i] + "$"));

    for (j = 0; j < components.length; j++) {
        var componentName = components[j].name;
        selectedComponents.push(componentName);
    }
    //If component not found behind the checkBox, hide the checkBox
    if (selectedComponents.length == 0) {
        buttonFrame.visible = false;
    } else {
        checkBox.text = qsTranslate("installscript", getItemValueForTarget(qtVersionIds[0], "name"));
        if (label)
            label.text = qsTranslate("installscript", getItemValueForTarget(qtVersionIds[0], "description"));
        checkBox.clicked.connect(selectComponentForInstall);
    }
    return selectedComponents;
}

Component.prototype.loaded = function ()
{
    selectionWidget = component.userInterface("InstallTypeWidget").scrollArea.qt_scrollarea_viewport.scrollContents;

    if (selectionWidget != null) {
        var qt6DesktopCheckbox = selectionWidget.qt6DesktopFrame.qt6DesktopCheckBox;
        var qt6DesktopLabel = selectionWidget.qt6DesktopFrame.qt6DesktopLabel;
        if (installer.value("os") == "win")
            qt6DesktopComponent = initCheckBox(qt6DesktopCheckbox, qt6DesktopLabel, selectionWidget.qt6DesktopFrame, desktop6, windowsCompilers);
        else if (installer.value("os") == "mac")
            qt6DesktopComponent = initCheckBox(qt6DesktopCheckbox, qt6DesktopLabel, selectionWidget.qt6DesktopFrame, desktop6Clang);
        else
            qt6DesktopComponent = initCheckBox(qt6DesktopCheckbox, qt6DesktopLabel, selectionWidget.qt6DesktopFrame, desktop6GCC);

        qt6EmbeddedComponent = initCheckBox(selectionWidget.qt6EmbeddedFrame.qt6EmbeddedCheckBox, null, selectionWidget.qt6EmbeddedFrame, b2Qt6, b2qtTargets);
        qtMCUComponent = initCheckBox(selectionWidget.qt6MCUFrame.qt6MCUCheckBox, null, selectionWidget.qt6MCUFrame, mcu, mcuTargets);
        qtDesignStudioComponent = initCheckBox(selectionWidget.designStudioFrame.designStudioCheckBox, selectionWidget.designStudioFrame.designStudioLabel, selectionWidget.designStudioFrame, toolsDesignStudio);

        var mobileTargets = [mobileAndroid, mobileiOS]
        qt6MobileComponents = initMobileCheckBox(selectionWidget.qt6MobileFrame.qt6MobileCheckBox, selectionWidget.qt6MobileFrame.qt6MobileLabel, selectionWidget.qt6MobileFrame, mobileTargets);

        // Comboboxes for MCU and embedded
        var comboBox = selectionWidget.qt6MCUFrame.qt6MCUComboBox;
        setAvailableTargets(mcu, mcuTargets, selectionWidget.qt6MCUFrame, comboBox);
        comboBox.currentIndexChanged.connect(mcuTargetChanged);

        comboBox = selectionWidget.qt6EmbeddedFrame.qt6EmbeddedComboBox;
        setAvailableTargets(b2Qt6, b2qtTargets, selectionWidget.qt6EmbeddedFrame, comboBox);
        comboBox.currentIndexChanged.connect(b2Qt6TargetChanged);

        // Custom installation
        var customCheckbox = selectionWidget.customFrame.customCheckBox;
        customCheckbox.clicked.connect(customInstallationSelected);
    }
}
