import QtQuick
import QtQuick.Studio.DesignEffects
import DesignEffectsDemo

Item {
    id: root
    width: 66
    height: 96

    property color highlight: "Red"
    property real blurFactor: 1
    property string segState: ""

    Rectangle {
        id: segA
        x: 18
        y: 7
        width: 29
        height: 5
        color: root.highlight
        radius: 3
        DesignEffect {
            id: designEffectSeg1
            layerBlurRadius: 5 * root.blurFactor

            effects: [
                DesignDropShadow {
                    id: designDropShadowSeg1
                    blur: 10 * root.blurFactor
                    offsetX: 0
                    offsetY: 0
                    color: root.highlight
                }
            ]
        }
    }

    Rectangle {
        id: segB
        x: 51
        y: 13
        width: 5
        height: 30
        color: root.highlight
        radius: 3
        DesignEffect {
            id: designEffectSeg2
            layerBlurRadius: 5 * root.blurFactor

            effects: [
                DesignDropShadow {
                    id: designDropShadowSeg2
                    blur: 10 * root.blurFactor
                    offsetX: 0
                    offsetY: 0
                    color: root.highlight
                }
            ]
        }
    }

    Rectangle {
        id: segC
        x: 51
        y: 53
        width: 5
        height: 30
        color: root.highlight
        radius: 3
        DesignEffect {
            id: designEffectSeg3
            layerBlurRadius: 5 * root.blurFactor

            effects: [
                DesignDropShadow {
                    id: designDropShadowSeg3
                    blur: 10 * root.blurFactor
                    offsetX: 0
                    offsetY: 0
                    color: root.highlight
                }
            ]
        }
    }

    Rectangle {
        id: segD
        x: 18
        y: 83
        width: 30
        height: 5
        visible: true
        color: root.highlight
        radius: 3
        DesignEffect {
            id: designEffectSeg4
            layerBlurRadius: 5 * root.blurFactor

            effects: [
                DesignDropShadow {
                    id: designDropShadowSeg4
                    blur: 10 * root.blurFactor
                    offsetX: 0
                    offsetY: 0
                    color: root.highlight
                }
            ]
        }
    }

    Rectangle {
        id: segE
        x: 11
        y: 53
        width: 5
        height: 30
        color: root.highlight
        radius: 5
        DesignEffect {
            id: designEffectSeg5
            layerBlurRadius: 5 * root.blurFactor

            effects: [
                DesignDropShadow {
                    id: designDropShadowSeg5
                    blur: 10 * root.blurFactor
                    offsetX: 0
                    offsetY: 0
                    color: root.highlight
                }
            ]
        }
    }

    Rectangle {
        id: segF
        x: 11
        y: 13
        width: 5
        height: 30
        color: root.highlight
        radius: 3
        DesignEffect {
            id: designEffectSeg6
            layerBlurRadius: 5 * root.blurFactor

            effects: [
                DesignDropShadow {
                    id: designDropShadowSeg6
                    blur: 10 * root.blurFactor
                    offsetX: 0
                    offsetY: 0
                    color: root.highlight
                }
            ]
        }
    }

    Rectangle {
        id: segG
        x: 18
        y: 45
        width: 30
        height: 5
        color: root.highlight
        radius: 3
        DesignEffect {
            id: designEffectSeg7
            layerBlurRadius: 5 * root.blurFactor

            effects: [
                DesignDropShadow {
                    id: designDropShadowSeg7
                    blur: 10 * root.blurFactor
                    offsetX: 0
                    offsetY: 0
                    color: root.highlight
                }
            ]
        }
    }

    Rectangle {
        id: segH
        x: 31
        y: 33
        width: 5
        height: 30
        color: root.highlight
        radius: 3
        DesignEffect {
            id: designEffectSeg8
            layerBlurRadius: 5 * root.blurFactor
            effects: [
                DesignDropShadow {
                    id: designDropShadowSeg8
                    offsetY: 0
                    blur: 10 * root.blurFactor
                    offsetX: 0
                    color: root.highlight
                }
            ]
        }
    }

    Rectangle {
        id: segI
        x: 38
        y: 70
        width: 10
        height: 10
        color: root.highlight
        radius: 3
        DesignEffect {
            id: designEffectSeg9
            layerBlurRadius: 5 * root.blurFactor
            effects: [
                DesignDropShadow {
                    id: designDropShadowSeg9
                    offsetY: 0
                    blur: 10 * root.blurFactor
                    offsetX: 0
                    color: root.highlight
                }
            ]
        }
    }
    states: [
        State {
            name: "0"
            when: root.segState == "0"

            PropertyChanges {
                target: segG
                visible: false
            }

            PropertyChanges {
                target: segH
                visible: false
            }

            PropertyChanges {
                target: segI
                visible: false
            }

            PropertyChanges {
                target: segD
                visible: true
            }
        },
        State {
            name: "1"
            when: root.segState == "1"

            PropertyChanges {
                target: segG
                visible: false
            }

            PropertyChanges {
                target: segA
                visible: false
                color: root.highlight
            }

            PropertyChanges {
                target: segD
                visible: false
            }

            PropertyChanges {
                target: segE
                visible: false
            }

            PropertyChanges {
                target: segF
                visible: false
            }

            PropertyChanges {
                target: segH
                visible: false
            }

            PropertyChanges {
                target: segI
                visible: false
            }
        },
        State {
            name: "2"
            when: root.segState == "2"

            PropertyChanges {
                target: segC
                visible: false
            }

            PropertyChanges {
                target: segF
                visible: false
            }

            PropertyChanges {
                target: segI
                visible: false
            }

            PropertyChanges {
                target: segH
                visible: false
            }
        },
        State {
            name: "3"
            when: root.segState == "3"

            PropertyChanges {
                target: segF
                visible: false
            }

            PropertyChanges {
                target: segE
                visible: false
            }

            PropertyChanges {
                target: segH
                visible: false
            }

            PropertyChanges {
                target: segI
                visible: false
            }
        },
        State {
            name: "4"
            when: root.segState == "4"

            PropertyChanges {
                target: segA
                visible: false
            }

            PropertyChanges {
                target: segE
                visible: false
            }

            PropertyChanges {
                target: segD
                visible: false
            }

            PropertyChanges {
                target: segI
                visible: false
            }

            PropertyChanges {
                target: segH
                visible: false
            }
        },
        State {
            name: "5"
            when: root.segState == "5"

            PropertyChanges {
                target: segB
                visible: false
            }

            PropertyChanges {
                target: segE
                visible: false
            }

            PropertyChanges {
                target: segH
                visible: false
            }

            PropertyChanges {
                target: segI
                visible: false
            }

            PropertyChanges {
                target: segD
                visible: true
            }
        },
        State {
            name: "6"
            when: root.segState == "6"

            PropertyChanges {
                target: segB
                visible: false
            }

            PropertyChanges {
                target: segH
                visible: false
            }

            PropertyChanges {
                target: segI
                visible: false
            }

            PropertyChanges {
                target: segD
                visible: true
            }
        },
        State {
            name: "7"
            when: root.segState === "7"

            PropertyChanges {
                target: segF
                visible: false
            }

            PropertyChanges {
                target: segG
                visible: false
            }

            PropertyChanges {
                target: segD
                visible: false
            }

            PropertyChanges {
                target: segE
                visible: false
            }

            PropertyChanges {
                target: segI
                visible: false
            }

            PropertyChanges {
                target: segH
                visible: false
            }
        },
        State {
            name: "8"
            when: root.segState == "8"

            PropertyChanges {
                target: segH
                visible: false
            }

            PropertyChanges {
                target: segI
                visible: false
            }

            PropertyChanges {
                target: segD
                visible: true
            }
        },
        State {
            name: "9"
            when: root.segState == "9"

            PropertyChanges {
                target: segE
                visible: false
            }

            PropertyChanges {
                target: segI
                visible: false
            }

            PropertyChanges {
                target: segH
                visible: false
            }

            PropertyChanges {
                target: segD
                visible: true
            }
        },
        State {
            name: "E"
            when: root.segState == "e"

            PropertyChanges {
                target: segB
                visible: false
            }

            PropertyChanges {
                target: segC
                visible: false
            }

            PropertyChanges {
                target: segH
                visible: false
            }

            PropertyChanges {
                target: segI
                visible: false
            }

            PropertyChanges {
                target: segD
                visible: true
            }
        },
        State {
            name: "plus"
            when: root.segState == "+"
            PropertyChanges {
                target: segI
                visible: false
            }

            PropertyChanges {
                target: segC
                visible: false
            }

            PropertyChanges {
                target: segD
                visible: false
            }

            PropertyChanges {
                target: segE
                visible: false
            }

            PropertyChanges {
                target: segF
                visible: false
            }

            PropertyChanges {
                target: segB
                visible: false
            }

            PropertyChanges {
                target: segA
                visible: false
            }
        },
        State {
            name: "minus"
            when: root.segState == "-"
            PropertyChanges {
                target: segI
                visible: false
            }

            PropertyChanges {
                target: segC
                visible: false
            }

            PropertyChanges {
                target: segD
                visible: false
            }

            PropertyChanges {
                target: segE
                visible: false
            }

            PropertyChanges {
                target: segF
                visible: false
            }

            PropertyChanges {
                target: segB
                visible: false
            }

            PropertyChanges {
                target: segA
                visible: false
            }

            PropertyChanges {
                target: segH
                visible: false
            }
        },
        State {
            name: "dot"

            when: root.segState == "."
            PropertyChanges {
                target: segA
                visible: false
            }

            PropertyChanges {
                target: segB
                visible: false
            }

            PropertyChanges {
                target: segC
                visible: false
            }

            PropertyChanges {
                target: segH
                visible: false
            }

            PropertyChanges {
                target: segG
                visible: false
            }

            PropertyChanges {
                target: segF
                visible: false
            }

            PropertyChanges {
                target: segE
                visible: false
            }

            PropertyChanges {
                target: segD
                visible: false
            }

            PropertyChanges {
                target: segI
                radius: 4
            }
        },
        State {
            name: "N"
            when: root.segState === ("n" || "N")

            PropertyChanges {
                target: segH
                visible: false
            }

            PropertyChanges {
                target: segG
                visible: false
            }

            PropertyChanges {
                target: segI
                visible: false
            }

            PropertyChanges {
                target: segD
                visible: false
            }
        },
        State {
            name: "A"
            when: root.segState === ("a" || "A")

            PropertyChanges {
                target: segD
                visible: false
            }

            PropertyChanges {
                target: segI
                visible: false
            }

            PropertyChanges {
                target: segH
                visible: false
            }
        },
        State {
            name: "I"
            when: root.segState === ("i" || "I")

            PropertyChanges {
                target: segH
                visible: false
            }

            PropertyChanges {
                target: segG
                visible: false
            }

            PropertyChanges {
                target: segB
                visible: true
            }

            PropertyChanges {
                target: segC
                visible: true
            }

            PropertyChanges {
                target: segI
                visible: false
            }

            PropertyChanges {
                target: segD
                visible: false
            }

            PropertyChanges {
                target: segA
                visible: false
            }

            PropertyChanges {
                target: segF
                visible: false
            }

            PropertyChanges {
                target: segE
                visible: false
            }
        },
        State {
            name: "F"
            when: root.segState === ("f" || "F")

            PropertyChanges {
                target: segD
                visible: false
            }

            PropertyChanges {
                target: segC
                visible: false
            }

            PropertyChanges {
                target: segI
                visible: false
            }

            PropertyChanges {
                target: segH
                visible: false
            }

            PropertyChanges {
                target: segB
                visible: false
            }
        }
    ]
}
