import QtQuick
import QtQuick.Controls
import QtQuick.Templates as T
import QtQuick.Studio.DesignEffects

T.Slider {
    id: root
    width: 90
    height: 220
    state: "idle"

    property color highlight: "#C1BDBC"
    property color shadeTone: "#000000"
    property real shadeFactor: 1
    property bool effectsOn: true
    property real aSpread: 0
    property real shadowDepth: 1

    handle: sHandle
    background: groove

    Rectangle {
        id: groove
        width: 13
        color: "#1d1712"
        radius: 7
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.topMargin: 0
        anchors.horizontalCenter: parent.horizontalCenter

        DesignEffect {
            id: designEffectGroove
            visible: root.effectsOn
            layerBlurRadius: 1

            effects: [
                DesignDropShadow {
                    id: designDropShadowGroove
                    blur: 5
                    offsetX: 1
                    offsetY: 1
                    color: "#ffffff"
                },

                DesignInnerShadow {
                    id: designInnerShadowGroove
                    blur: 1
                    offsetX: -1
                    offsetY: 0
                    color: "#a4ffffff"
                }
            ]
        }
    }

    Rectangle {
        id: centerLine1
        x: 7
        y: 109
        width: 30
        height: 2
        color: "#aeaeae"
    }

    Rectangle {
        id: centerLine2
        x: 52
        y: 109
        width: 30
        height: 2
        color: "#aeaeae"
    }

    Rectangle {
        id: sHandle
        x: 21
        y: root.visualPosition * (root.availableHeight - height)
        width: 48
        height: 48
        color: "#7a7977"
        radius: 100

        DesignEffect {
            id: designEffectHandle
            visible: root.effectsOn
            layerBlurRadius: 1

            effects: [
                DesignDropShadow {
                    id: designDropShadowHandle
                    blur: 3
                    offsetX: 2 * root.shadowDepth
                    offsetY: 3 * root.shadowDepth
                    color: "#3e000000"
                },

                DesignDropShadow {
                    id: designDropShadowHandle1
                    blur: 14.8
                    offsetX: 18 * root.shadowDepth
                    offsetY: 31 * root.shadowDepth
                    color: "#84000000"
                    spread: root.aSpread
                },

                DesignInnerShadow {
                    id: designInnerShadowHandle
                    blur: 4
                    offsetX: 0 * root.shadowDepth
                    offsetY: -5 * root.shadowDepth
                    color: "#3f000000"
                },

                DesignInnerShadow {
                    id: designInnerShadowHandle1
                    blur: 2
                    offsetX: 0 * root.shadowDepth
                    offsetY: 0 * root.shadowDepth
                    color: "#61ffffff"
                },

                DesignInnerShadow {
                    id: designInnerShadowHandle2
                    blur: 2
                    offsetX: 1 * root.shadowDepth
                    offsetY: 2 * root.shadowDepth
                    color: "#ffffff"
                }
            ]
        }
    }

    Rectangle {
        id: shadeRect
        width: sHandle.width
        height: sHandle.height
        opacity: 0
        x: sHandle.x
        y: sHandle.y
        color: root.shadeTone
        radius: sHandle.radius
    }
    states: [
        State {
            name: "idle"
            when: !root.pressed && !root.hovered
        },
        State {
            name: "hover"
            when: !root.pressed && root.hovered

            PropertyChanges {
                target: shadeRect
                opacity: 0.05 * root.shadeFactor
            }
        },
        State {
            name: "press"
            when: root.pressed

            PropertyChanges {
                target: shadeRect
                opacity: 0.1 * root.shadeFactor
            }
        }
    ]
}
