import QtQuick
import QtQuick.Controls
import QtQuick.Templates as T
import QtQuick.Studio.DesignEffects

T.Button {
    id: root
    width: 100
    height: 100
    state: "idle"
    property alias buttonKeyFontpixelSize: buttonKey.font.pixelSize
    property alias buttonKeyText: buttonKey.text
    property bool numPressed: false

    background: buttonHole

    property bool effectsOn: true
    property color buttonKeyColor: "Black"
    property color highlightFrontTop: "#C1BDBC"
    property color highlightFrontBottom: "#c0bcbb"
    property color shadeTone: "#000000"
    property real shadeFactor: 1
    property real blurFactor: 1
    property real spreadFactor: 1
    property real shadowDepth: 1

    Rectangle {
        id: buttonHole
        color: "#181614"
        radius: 3
        anchors.fill: parent
    }

    Rectangle {
        id: button
        radius: 9
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 5
        anchors.rightMargin: 5
        anchors.topMargin: 5
        anchors.bottomMargin: 5
        gradient: Gradient {
            GradientStop {
                position: 0
                color: root.highlightFrontTop
            }

            GradientStop {
                position: 1
                color: root.highlightFrontTop
            }
            orientation: Gradient.Vertical
        }
        DesignEffect {
            id: designEffectButtonFront
            visible: root.effectsOn
            layerBlurRadius: 1 * root.blurFactor

            effects: [
                DesignDropShadow {
                    id: designDropShadowButton
                    blur: 18 * root.blurFactor
                    offsetX: 8 * root.shadowDepth
                    offsetY: 11 * root.shadowDepth
                    color: "#6d000000"
                    spread: 1 * root.spreadFactor
                },

                DesignInnerShadow {
                    id: designInnerShadowButton
                    blur: 3 * root.blurFactor
                    offsetX: -2 * root.shadowDepth
                    offsetY: -2 * root.shadowDepth
                    color: "#7a000000"
                    spread: 0
                },
                DesignInnerShadow {
                    id: designInnerShadowButton1
                    blur: 3 * root.blurFactor
                    offsetX: 2 * root.shadowDepth
                    offsetY: 2 * root.shadowDepth
                    color: "#ffffff"
                    spread: 0
                }
            ]
        }
    }

    Text {
        id: buttonKey
        color: root.buttonKeyColor
        text: qsTr("A")
        anchors.fill: parent
        font.pixelSize: 30
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        font.styleName: "Medium"
        font.family: "Victor Mono"

        DesignEffect {
            id: designEffectKeyText
            visible: root.effectsOn
            layerBlurRadius: 1.5 * root.blurFactor

            effects: [
                DesignDropShadow {
                    id: designDropShadowKeyText
                    blur: 3 * root.blurFactor
                    offsetX: 0 * root.shadowDepth
                    offsetY: 0 * root.shadowDepth
                    color: root.buttonKeyColor
                    spread: 0
                }
            ]
        }
    }

    Rectangle {
        id: buttonShade
        opacity: 0
        color: root.shadeTone
        anchors.fill: parent
    }
    states: [
        State {
            name: "idle"
            when: !root.hovered && !root.pressed && !root.checked
                  && !root.numPressed
        },
        State {
            name: "hover"
            when: root.hovered && !root.pressed && !root.checked
                  && !root.numPressed

            PropertyChanges {
                target: buttonShade
                opacity: 0.05 * root.shadeFactor
            }
        },
        State {
            name: "press"
            when: (root.pressed || root.numPressed) && !root.checked

            PropertyChanges {
                target: buttonShade
                opacity: 0.1 * root.shadeFactor
            }

            PropertyChanges {
                target: button
                scale: 0.98
            }
        },
        State {
            name: "check"
            when: root.checked

            PropertyChanges {
                target: buttonShade
                opacity: 0.1 * root.shadeFactor
            }

            PropertyChanges {
                target: button
                scale: 0.98
            }
        }
    ]
}
