import QtQuick
import QtQuick.Controls
import QtQuick.Studio.DesignEffects 1.0

Rectangle {
    id: pressSwitch
    width: 89
    height: 150
    color: "transparent"

    Rectangle {
        id: switchBack
        radius: 46
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.topMargin: 22
        anchors.bottomMargin: 0
        gradient: Gradient {
            id: switchBack_Gradient
            GradientStop {
                id: switchBack_GradientStop_0
                position: 0
                color: "#ff8d8d8d"
            }

            GradientStop {
                id: switchBack_GradientStop_1
                position: 1
                color: "#ffaeaeae"
            }
            orientation: Gradient.Vertical
        }
        DesignEffect {
            id: switchBack_DesignEffect
            visible: true
            layerBlurVisible: true
            layerBlurRadius: 1
            effects: [
                DesignInnerShadow {
                    id: switchBack_DesignInnerShadow_0
                    visible: true
                    color: "#59ffffff"
                    spread: 0
                    offsetY: -1
                    offsetX: 0
                    blur: 1
                },
                DesignInnerShadow {
                    id: switchBack_DesignInnerShadow_1
                    visible: true
                    color: "#1a000000"
                    spread: 0
                    offsetY: 9
                    offsetX: 0
                    blur: 4
                }
            ]
        }
    }

    Rectangle {
        id: switchMid
        color: "#787878"
        radius: 46
        border.color: "#4b4b4b"
        border.width: 1
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 7
        anchors.rightMargin: 7
        anchors.topMargin: 29
        anchors.bottomMargin: 5
        DesignEffect {
            id: switchMid_DesignEffect
            visible: true
            layerBlurVisible: true
            layerBlurRadius: 1
        }
    }

    Rectangle {
        id: switchTop
        radius: 46
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 9
        anchors.rightMargin: 9
        anchors.topMargin: 32
        anchors.bottomMargin: 9
        gradient: Gradient {
            id: switchTop_Gradient
            GradientStop {
                id: switchTop_GradientStop_0
                position: 0
                color: "#ff606060"
            }

            GradientStop {
                id: switchTop_GradientStop_1
                position: 1
                color: "#ffe0e0e0"
            }
            orientation: Gradient.Vertical
        }
        DesignEffect {
            id: switchTop_DesignEffect
            visible: true
            layerBlurVisible: true
            layerBlurRadius: 1
            effects: [
                DesignInnerShadow {
                    id: switchTop_DesignInnerShadow_0
                    visible: true
                    color: "#36000000"
                    spread: 0
                    offsetY: 28
                    offsetX: 0
                    blur: 13
                },
                DesignInnerShadow {
                    id: switchTop_DesignInnerShadow_1
                    visible: true
                    color: "#8c000000"
                    spread: 0
                    offsetY: -1
                    offsetX: 0
                    blur: 2
                },
                DesignInnerShadow {
                    id: switchTop_DesignInnerShadow_2
                    visible: true
                    color: "#ffffffff"
                    spread: 0
                    offsetY: 2
                    offsetX: 0
                    blur: 2
                },
                DesignInnerShadow {
                    id: switchTop_DesignInnerShadow_3
                    visible: true
                    color: "#40000000"
                    spread: 0
                    offsetY: 2
                    offsetX: 0
                    blur: 1
                },
                DesignDropShadow {
                    id: switchTop_DesignDropShadow_4
                    visible: true
                    color: "#80000000"
                    spread: 0
                    offsetY: 22
                    offsetX: 0
                    blur: 8
                }
            ]
        }
    }

    Rectangle {
        id: indicatorOff
        color: "#3d3d3d"
        radius: 14
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 39
        anchors.rightMargin: 40
        anchors.bottomMargin: 140
    }

    Rectangle {
        id: indicatorOn
        color: "#0afed8"
        radius: 14
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 39
        anchors.rightMargin: 40
        anchors.bottomMargin: 140
        DesignEffect {
            id: indicatorOn_DesignEffect
            visible: true
            layerBlurVisible: true
            layerBlurRadius: 3
            effects: [
                DesignDropShadow {
                    id: indicatorOn_DesignDropShadow_0
                    visible: true
                    color: "#b20afed8"
                    spread: 0
                    offsetY: 0
                    offsetX: 0
                    blur: 6
                }
            ]
        }
    }
}

/*##^##
Designer {
    D{i:0;uuid:"4cc38eaa-3122-561d-a755-11be71ebb947"}D{i:1;uuid:"92945c8c-1a7e-5a52-8c03-92607ae116c5"}
D{i:5;uuid:"92945c8c-1a7e-5a52-8c03-92607ae116c5_DesignEffect"}D{i:6;uuid:"92945c8c-1a7e-5a52-8c03-92607ae116c5_DesignInnerShadow_0"}
D{i:7;uuid:"92945c8c-1a7e-5a52-8c03-92607ae116c5_DesignInnerShadow_1"}D{i:2;uuid:"92945c8c-1a7e-5a52-8c03-92607ae116c5_Gradient"}
D{i:3;uuid:"92945c8c-1a7e-5a52-8c03-92607ae116c5_GradientStop_0"}D{i:4;uuid:"92945c8c-1a7e-5a52-8c03-92607ae116c5_GradientStop_1"}
D{i:8;uuid:"f33f5d6a-93fa-529c-8477-a272bb790b02"}D{i:9;uuid:"f33f5d6a-93fa-529c-8477-a272bb790b02_DesignEffect"}
D{i:10;uuid:"61266847-0887-599f-be75-f91db270ed15"}D{i:14;uuid:"61266847-0887-599f-be75-f91db270ed15_DesignEffect"}
D{i:15;uuid:"61266847-0887-599f-be75-f91db270ed15_DesignInnerShadow_0"}D{i:16;uuid:"61266847-0887-599f-be75-f91db270ed15_DesignInnerShadow_1"}
D{i:17;uuid:"61266847-0887-599f-be75-f91db270ed15_DesignInnerShadow_2"}D{i:18;uuid:"61266847-0887-599f-be75-f91db270ed15_DesignInnerShadow_3"}
D{i:19;uuid:"61266847-0887-599f-be75-f91db270ed15_DesignDropShadow_4"}D{i:11;uuid:"61266847-0887-599f-be75-f91db270ed15_Gradient"}
D{i:12;uuid:"61266847-0887-599f-be75-f91db270ed15_GradientStop_0"}D{i:13;uuid:"61266847-0887-599f-be75-f91db270ed15_GradientStop_1"}
D{i:20;uuid:"b4386aa5-7e89-5c7b-bfce-9b187142b012"}D{i:21;uuid:"61cbebe0-4f9b-57ff-abe6-68525e40a820"}
D{i:22;uuid:"61cbebe0-4f9b-57ff-abe6-68525e40a820_DesignEffect"}D{i:23;uuid:"61cbebe0-4f9b-57ff-abe6-68525e40a820_DesignDropShadow_0"}
}
##^##*/

