.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "CREATE DATABASE" "" "2010-03-12" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE DATABASE \- create a new database

.SH SYNOPSIS
.sp
.nf
CREATE DATABASE \fIname\fR
    [ [ WITH ] [ OWNER [=] \fIdbowner\fR ]
           [ TEMPLATE [=] \fItemplate\fR ]
           [ ENCODING [=] \fIencoding\fR ]
           [ TABLESPACE [=] \fItablespace\fR ]
           [ CONNECTION LIMIT [=] \fIconnlimit\fR ] ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCREATE DATABASE\fR creates a new
PostgreSQL database.
.PP
To create a database, you must be a superuser or have the special
CREATEDB privilege.
See CREATE USER [\fBcreate_user\fR(l)].
.PP
Normally, the creator becomes the owner of the new database.
Superusers can create databases owned by other users, by using the
OWNER clause. They can even create databases owned by
users with no special privileges. Non-superusers with CREATEDB
privilege can only create databases owned by themselves.
.PP
By default, the new database will be created by cloning the standard
system database template1. A different template can be
specified by writing TEMPLATE
\fIname\fR. In particular,
by writing TEMPLATE template0, you can create a virgin
database containing only the standard objects predefined by your
version of PostgreSQL. This is useful
if you wish to avoid copying
any installation-local objects that might have been added to
template1.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name of a database to create.
.TP
\fB\fIdbowner\fB\fR
The name of the database user who will own the new database,
or DEFAULT to use the default (namely, the
user executing the command).
.TP
\fB\fItemplate\fB\fR
The name of the template from which to create the new database,
or DEFAULT to use the default template
(template1).
.TP
\fB\fIencoding\fB\fR
Character set encoding to use in the new database. Specify
a string constant (e.g., 'SQL_ASCII'),
or an integer encoding number, or DEFAULT
to use the default encoding (namely, the encoding of the
template database). The character sets supported by the
PostgreSQL server are described in
in the documentation. See below for
additional restrictions.
.TP
\fB\fItablespace\fB\fR
The name of the tablespace that will be associated with the
new database, or DEFAULT to use the
template database's tablespace. This
tablespace will be the default tablespace used for objects
created in this database. See
CREATE TABLESPACE [\fBcreate_tablespace\fR(l)]
for more information.
.TP
\fB\fIconnlimit\fB\fR
How many concurrent connections can be made
to this database. -1 (the default) means no limit.
.PP
Optional parameters can be written in any order, not only the order
illustrated above.
.PP
.SH "NOTES"
.PP
\fBCREATE DATABASE\fR cannot be executed inside a transaction
block.
.PP
Errors along the line of ``could not initialize database directory''
are most likely related to insufficient permissions on the data
directory, a full disk, or other file system problems.
.PP
Use DROP DATABASE [\fBdrop_database\fR(l)] to remove a database.
.PP
The program createdb [\fBcreatedb\fR(1)] is a
wrapper program around this command, provided for convenience.
.PP
Although it is possible to copy a database other than template1
by specifying its name as the template, this is not (yet) intended as
a general-purpose ``\fBCOPY DATABASE\fR'' facility.
The principal limitation is that no other sessions can be connected to
the template database while it is being copied. \fBCREATE
DATABASE\fR will fail if any other connection exists when it starts;
otherwise, new connections to the template database are locked out
until \fBCREATE DATABASE\fR completes.
See in the documentation for more information.
.PP
Any character set encoding specified for the new database must be
compatible with the server's \fBLC_CTYPE\fR locale setting.
If \fBLC_CTYPE\fR is C (or equivalently
POSIX), then all encodings are allowed, but for other
locale settings there is only one encoding that will work properly,
and so the apparent freedom to specify an encoding is illusory if
you didn't initialize the database cluster in C locale.
\fBCREATE DATABASE\fR will allow superusers to specify
SQL_ASCII encoding regardless of the locale setting,
but this choice is deprecated and may result in misbehavior of
character-string functions if data that is not encoding-compatible
with the locale is stored in the database.
.PP
The CONNECTION LIMIT option is only enforced approximately;
if two new sessions start at about the same time when just one
connection ``slot'' remains for the database, it is possible that
both will fail. Also, the limit is not enforced against superusers.
.SH "EXAMPLES"
.PP
To create a new database:
.sp
.nf
CREATE DATABASE lusiadas;
.sp
.fi
.PP
To create a database sales owned by user salesapp
with a default tablespace of salesspace:
.sp
.nf
CREATE DATABASE sales OWNER salesapp TABLESPACE salesspace;
.sp
.fi
.PP
To create a database music which supports the ISO-8859-1 
character set:
.sp
.nf
CREATE DATABASE music ENCODING 'LATIN1';
.sp
.fi
.SH "COMPATIBILITY"
.PP
There is no \fBCREATE DATABASE\fR statement in the SQL
standard. Databases are equivalent to catalogs, whose creation is
implementation-defined.
.SH "SEE ALSO"
ALTER DATABASE [\fBalter_database\fR(l)], DROP DATABASE [\fBdrop_database\fR(l)]
