/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_CONNECTION = 265,
     SQL_CONTINUE = 266,
     SQL_COUNT = 267,
     SQL_CURRENT = 268,
     SQL_DATA = 269,
     SQL_DATETIME_INTERVAL_CODE = 270,
     SQL_DATETIME_INTERVAL_PRECISION = 271,
     SQL_DESCRIBE = 272,
     SQL_DESCRIPTOR = 273,
     SQL_DISCONNECT = 274,
     SQL_ENUM = 275,
     SQL_FOUND = 276,
     SQL_FREE = 277,
     SQL_GO = 278,
     SQL_GOTO = 279,
     SQL_IDENTIFIED = 280,
     SQL_INDICATOR = 281,
     SQL_KEY_MEMBER = 282,
     SQL_LENGTH = 283,
     SQL_LONG = 284,
     SQL_NAME = 285,
     SQL_NULLABLE = 286,
     SQL_OCTET_LENGTH = 287,
     SQL_OPEN = 288,
     SQL_OUTPUT = 289,
     SQL_REFERENCE = 290,
     SQL_RETURNED_LENGTH = 291,
     SQL_RETURNED_OCTET_LENGTH = 292,
     SQL_SCALE = 293,
     SQL_SECTION = 294,
     SQL_SHORT = 295,
     SQL_SIGNED = 296,
     SQL_SQL = 297,
     SQL_SQLERROR = 298,
     SQL_SQLPRINT = 299,
     SQL_SQLWARNING = 300,
     SQL_START = 301,
     SQL_STOP = 302,
     SQL_STRUCT = 303,
     SQL_UNSIGNED = 304,
     SQL_VALUE = 305,
     SQL_VAR = 306,
     SQL_WHENEVER = 307,
     S_ADD = 308,
     S_AND = 309,
     S_ANYTHING = 310,
     S_AUTO = 311,
     S_CONST = 312,
     S_DEC = 313,
     S_DIV = 314,
     S_DOTPOINT = 315,
     S_EQUAL = 316,
     S_EXTERN = 317,
     S_INC = 318,
     S_LSHIFT = 319,
     S_MEMPOINT = 320,
     S_MEMBER = 321,
     S_MOD = 322,
     S_MUL = 323,
     S_NEQUAL = 324,
     S_OR = 325,
     S_REGISTER = 326,
     S_RSHIFT = 327,
     S_STATIC = 328,
     S_SUB = 329,
     S_VOLATILE = 330,
     S_TYPEDEF = 331,
     TYPECAST = 332,
     ABORT_P = 333,
     ABSOLUTE_P = 334,
     ACCESS = 335,
     ACTION = 336,
     ADD = 337,
     AFTER = 338,
     AGGREGATE = 339,
     ALL = 340,
     ALSO = 341,
     ALTER = 342,
     ANALYSE = 343,
     ANALYZE = 344,
     AND = 345,
     ANY = 346,
     ARRAY = 347,
     AS = 348,
     ASC = 349,
     ASSERTION = 350,
     ASSIGNMENT = 351,
     AT = 352,
     AUTHORIZATION = 353,
     BACKWARD = 354,
     BEFORE = 355,
     BEGIN_P = 356,
     BETWEEN = 357,
     BIGINT = 358,
     BINARY = 359,
     BIT = 360,
     BOOLEAN_P = 361,
     BOTH = 362,
     BY = 363,
     CACHE = 364,
     CALLED = 365,
     CASCADE = 366,
     CASE = 367,
     CAST = 368,
     CHAIN = 369,
     CHAR_P = 370,
     CHARACTER = 371,
     CHARACTERISTICS = 372,
     CHECK = 373,
     CHECKPOINT = 374,
     CLASS = 375,
     CLOSE = 376,
     CLUSTER = 377,
     COALESCE = 378,
     COLLATE = 379,
     COLUMN = 380,
     COMMENT = 381,
     COMMIT = 382,
     COMMITTED = 383,
     CONSTRAINT = 384,
     CONSTRAINTS = 385,
     CONVERSION_P = 386,
     CONVERT = 387,
     COPY = 388,
     CREATE = 389,
     CREATEDB = 390,
     CREATEUSER = 391,
     CROSS = 392,
     CSV = 393,
     CURRENT_DATE = 394,
     CURRENT_TIME = 395,
     CURRENT_TIMESTAMP = 396,
     CURRENT_USER = 397,
     CURSOR = 398,
     CYCLE = 399,
     DATABASE = 400,
     DAY_P = 401,
     DEALLOCATE = 402,
     DEC = 403,
     DECIMAL_P = 404,
     DECLARE = 405,
     DEFAULT = 406,
     DEFAULTS = 407,
     DEFERRABLE = 408,
     DEFERRED = 409,
     DEFINER = 410,
     DELETE_P = 411,
     DELIMITER = 412,
     DELIMITERS = 413,
     DESC = 414,
     DISTINCT = 415,
     DO = 416,
     DOMAIN_P = 417,
     DOUBLE_P = 418,
     DROP = 419,
     EACH = 420,
     ELSE = 421,
     ENCODING = 422,
     ENCRYPTED = 423,
     END_P = 424,
     ESCAPE = 425,
     EXCEPT = 426,
     EXCLUSIVE = 427,
     EXCLUDING = 428,
     EXECUTE = 429,
     EXISTS = 430,
     EXPLAIN = 431,
     EXTERNAL = 432,
     EXTRACT = 433,
     FALSE_P = 434,
     FETCH = 435,
     FIRST_P = 436,
     FLOAT_P = 437,
     FOR = 438,
     FORCE = 439,
     FOREIGN = 440,
     FORWARD = 441,
     FREEZE = 442,
     FROM = 443,
     FULL = 444,
     FUNCTION = 445,
     GET = 446,
     GLOBAL = 447,
     GRANT = 448,
     GROUP_P = 449,
     HANDLER = 450,
     HAVING = 451,
     HOLD = 452,
     HOUR_P = 453,
     ILIKE = 454,
     IMMEDIATE = 455,
     IMMUTABLE = 456,
     IMPLICIT_P = 457,
     IN_P = 458,
     INCLUDING = 459,
     INCREMENT = 460,
     INDEX = 461,
     INHERITS = 462,
     INITIALLY = 463,
     INNER_P = 464,
     INOUT = 465,
     INPUT_P = 466,
     INSENSITIVE = 467,
     INSERT = 468,
     INSTEAD = 469,
     INT_P = 470,
     INTEGER = 471,
     INTERSECT = 472,
     INTERVAL = 473,
     INTO = 474,
     INVOKER = 475,
     IS = 476,
     ISNULL = 477,
     ISOLATION = 478,
     JOIN = 479,
     KEY = 480,
     LANCOMPILER = 481,
     LANGUAGE = 482,
     LARGE_P = 483,
     LAST_P = 484,
     LEADING = 485,
     LEFT = 486,
     LEVEL = 487,
     LIKE = 488,
     LIMIT = 489,
     LISTEN = 490,
     LOAD = 491,
     LOCAL = 492,
     LOCATION = 493,
     LOCK_P = 494,
     MATCH = 495,
     MAXVALUE = 496,
     MINUTE_P = 497,
     MINVALUE = 498,
     MODE = 499,
     MONTH_P = 500,
     MOVE = 501,
     NAMES = 502,
     NATIONAL = 503,
     NATURAL = 504,
     NCHAR = 505,
     NEW = 506,
     NEXT = 507,
     NO = 508,
     NOCREATEDB = 509,
     NOCREATEUSER = 510,
     NONE = 511,
     NOT = 512,
     NOTHING = 513,
     NOTIFY = 514,
     NOTNULL = 515,
     NOWAIT = 516,
     NULL_P = 517,
     NULLIF = 518,
     NUMERIC = 519,
     OBJECT_P = 520,
     OF = 521,
     OFF = 522,
     OFFSET = 523,
     OIDS = 524,
     OLD = 525,
     ON = 526,
     ONLY = 527,
     OPERATOR = 528,
     OPTION = 529,
     OR = 530,
     ORDER = 531,
     OUT_P = 532,
     OUTER_P = 533,
     OVERLAPS = 534,
     OVERLAY = 535,
     OWNER = 536,
     PARTIAL = 537,
     PASSWORD = 538,
     PLACING = 539,
     POSITION = 540,
     PRECISION = 541,
     PRESERVE = 542,
     PREPARE = 543,
     PRIMARY = 544,
     PRIOR = 545,
     PRIVILEGES = 546,
     PROCEDURAL = 547,
     PROCEDURE = 548,
     QUOTE = 549,
     READ = 550,
     REAL = 551,
     RECHECK = 552,
     REFERENCES = 553,
     REINDEX = 554,
     RELATIVE_P = 555,
     RELEASE = 556,
     RENAME = 557,
     REPEATABLE = 558,
     REPLACE = 559,
     RESET = 560,
     RESTART = 561,
     RESTRICT = 562,
     RETURNS = 563,
     REVOKE = 564,
     RIGHT = 565,
     ROLLBACK = 566,
     ROW = 567,
     ROWS = 568,
     RULE = 569,
     SAVEPOINT = 570,
     SCHEMA = 571,
     SCROLL = 572,
     SECOND_P = 573,
     SECURITY = 574,
     SELECT = 575,
     SEQUENCE = 576,
     SERIALIZABLE = 577,
     SESSION = 578,
     SESSION_USER = 579,
     SET = 580,
     SETOF = 581,
     SHARE = 582,
     SHOW = 583,
     SIMILAR = 584,
     SIMPLE = 585,
     SMALLINT = 586,
     SOME = 587,
     STABLE = 588,
     START = 589,
     STATEMENT = 590,
     STATISTICS = 591,
     STDIN = 592,
     STDOUT = 593,
     STORAGE = 594,
     STRICT_P = 595,
     SUBSTRING = 596,
     SYSID = 597,
     TABLE = 598,
     TABLESPACE = 599,
     TEMP = 600,
     TEMPLATE = 601,
     TEMPORARY = 602,
     THEN = 603,
     TIME = 604,
     TIMESTAMP = 605,
     TO = 606,
     TOAST = 607,
     TRAILING = 608,
     TRANSACTION = 609,
     TREAT = 610,
     TRIGGER = 611,
     TRIM = 612,
     TRUE_P = 613,
     TRUNCATE = 614,
     TRUSTED = 615,
     TYPE_P = 616,
     UNCOMMITTED = 617,
     UNENCRYPTED = 618,
     UNION = 619,
     UNIQUE = 620,
     UNKNOWN = 621,
     UNLISTEN = 622,
     UNTIL = 623,
     UPDATE = 624,
     USAGE = 625,
     USER = 626,
     USING = 627,
     VACUUM = 628,
     VALID = 629,
     VALUES = 630,
     VARCHAR = 631,
     VARYING = 632,
     VERBOSE = 633,
     VIEW = 634,
     VOLATILE = 635,
     WHEN = 636,
     WHERE = 637,
     WITH = 638,
     WITHOUT = 639,
     WORK = 640,
     WRITE = 641,
     YEAR_P = 642,
     ZONE = 643,
     UNIONJOIN = 644,
     IDENT = 645,
     SCONST = 646,
     Op = 647,
     CSTRING = 648,
     CVARIABLE = 649,
     CPP_LINE = 650,
     IP = 651,
     BCONST = 652,
     XCONST = 653,
     ICONST = 654,
     PARAM = 655,
     FCONST = 656,
     POSTFIXOP = 657,
     UMINUS = 658
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_CONNECTION 265
#define SQL_CONTINUE 266
#define SQL_COUNT 267
#define SQL_CURRENT 268
#define SQL_DATA 269
#define SQL_DATETIME_INTERVAL_CODE 270
#define SQL_DATETIME_INTERVAL_PRECISION 271
#define SQL_DESCRIBE 272
#define SQL_DESCRIPTOR 273
#define SQL_DISCONNECT 274
#define SQL_ENUM 275
#define SQL_FOUND 276
#define SQL_FREE 277
#define SQL_GO 278
#define SQL_GOTO 279
#define SQL_IDENTIFIED 280
#define SQL_INDICATOR 281
#define SQL_KEY_MEMBER 282
#define SQL_LENGTH 283
#define SQL_LONG 284
#define SQL_NAME 285
#define SQL_NULLABLE 286
#define SQL_OCTET_LENGTH 287
#define SQL_OPEN 288
#define SQL_OUTPUT 289
#define SQL_REFERENCE 290
#define SQL_RETURNED_LENGTH 291
#define SQL_RETURNED_OCTET_LENGTH 292
#define SQL_SCALE 293
#define SQL_SECTION 294
#define SQL_SHORT 295
#define SQL_SIGNED 296
#define SQL_SQL 297
#define SQL_SQLERROR 298
#define SQL_SQLPRINT 299
#define SQL_SQLWARNING 300
#define SQL_START 301
#define SQL_STOP 302
#define SQL_STRUCT 303
#define SQL_UNSIGNED 304
#define SQL_VALUE 305
#define SQL_VAR 306
#define SQL_WHENEVER 307
#define S_ADD 308
#define S_AND 309
#define S_ANYTHING 310
#define S_AUTO 311
#define S_CONST 312
#define S_DEC 313
#define S_DIV 314
#define S_DOTPOINT 315
#define S_EQUAL 316
#define S_EXTERN 317
#define S_INC 318
#define S_LSHIFT 319
#define S_MEMPOINT 320
#define S_MEMBER 321
#define S_MOD 322
#define S_MUL 323
#define S_NEQUAL 324
#define S_OR 325
#define S_REGISTER 326
#define S_RSHIFT 327
#define S_STATIC 328
#define S_SUB 329
#define S_VOLATILE 330
#define S_TYPEDEF 331
#define TYPECAST 332
#define ABORT_P 333
#define ABSOLUTE_P 334
#define ACCESS 335
#define ACTION 336
#define ADD 337
#define AFTER 338
#define AGGREGATE 339
#define ALL 340
#define ALSO 341
#define ALTER 342
#define ANALYSE 343
#define ANALYZE 344
#define AND 345
#define ANY 346
#define ARRAY 347
#define AS 348
#define ASC 349
#define ASSERTION 350
#define ASSIGNMENT 351
#define AT 352
#define AUTHORIZATION 353
#define BACKWARD 354
#define BEFORE 355
#define BEGIN_P 356
#define BETWEEN 357
#define BIGINT 358
#define BINARY 359
#define BIT 360
#define BOOLEAN_P 361
#define BOTH 362
#define BY 363
#define CACHE 364
#define CALLED 365
#define CASCADE 366
#define CASE 367
#define CAST 368
#define CHAIN 369
#define CHAR_P 370
#define CHARACTER 371
#define CHARACTERISTICS 372
#define CHECK 373
#define CHECKPOINT 374
#define CLASS 375
#define CLOSE 376
#define CLUSTER 377
#define COALESCE 378
#define COLLATE 379
#define COLUMN 380
#define COMMENT 381
#define COMMIT 382
#define COMMITTED 383
#define CONSTRAINT 384
#define CONSTRAINTS 385
#define CONVERSION_P 386
#define CONVERT 387
#define COPY 388
#define CREATE 389
#define CREATEDB 390
#define CREATEUSER 391
#define CROSS 392
#define CSV 393
#define CURRENT_DATE 394
#define CURRENT_TIME 395
#define CURRENT_TIMESTAMP 396
#define CURRENT_USER 397
#define CURSOR 398
#define CYCLE 399
#define DATABASE 400
#define DAY_P 401
#define DEALLOCATE 402
#define DEC 403
#define DECIMAL_P 404
#define DECLARE 405
#define DEFAULT 406
#define DEFAULTS 407
#define DEFERRABLE 408
#define DEFERRED 409
#define DEFINER 410
#define DELETE_P 411
#define DELIMITER 412
#define DELIMITERS 413
#define DESC 414
#define DISTINCT 415
#define DO 416
#define DOMAIN_P 417
#define DOUBLE_P 418
#define DROP 419
#define EACH 420
#define ELSE 421
#define ENCODING 422
#define ENCRYPTED 423
#define END_P 424
#define ESCAPE 425
#define EXCEPT 426
#define EXCLUSIVE 427
#define EXCLUDING 428
#define EXECUTE 429
#define EXISTS 430
#define EXPLAIN 431
#define EXTERNAL 432
#define EXTRACT 433
#define FALSE_P 434
#define FETCH 435
#define FIRST_P 436
#define FLOAT_P 437
#define FOR 438
#define FORCE 439
#define FOREIGN 440
#define FORWARD 441
#define FREEZE 442
#define FROM 443
#define FULL 444
#define FUNCTION 445
#define GET 446
#define GLOBAL 447
#define GRANT 448
#define GROUP_P 449
#define HANDLER 450
#define HAVING 451
#define HOLD 452
#define HOUR_P 453
#define ILIKE 454
#define IMMEDIATE 455
#define IMMUTABLE 456
#define IMPLICIT_P 457
#define IN_P 458
#define INCLUDING 459
#define INCREMENT 460
#define INDEX 461
#define INHERITS 462
#define INITIALLY 463
#define INNER_P 464
#define INOUT 465
#define INPUT_P 466
#define INSENSITIVE 467
#define INSERT 468
#define INSTEAD 469
#define INT_P 470
#define INTEGER 471
#define INTERSECT 472
#define INTERVAL 473
#define INTO 474
#define INVOKER 475
#define IS 476
#define ISNULL 477
#define ISOLATION 478
#define JOIN 479
#define KEY 480
#define LANCOMPILER 481
#define LANGUAGE 482
#define LARGE_P 483
#define LAST_P 484
#define LEADING 485
#define LEFT 486
#define LEVEL 487
#define LIKE 488
#define LIMIT 489
#define LISTEN 490
#define LOAD 491
#define LOCAL 492
#define LOCATION 493
#define LOCK_P 494
#define MATCH 495
#define MAXVALUE 496
#define MINUTE_P 497
#define MINVALUE 498
#define MODE 499
#define MONTH_P 500
#define MOVE 501
#define NAMES 502
#define NATIONAL 503
#define NATURAL 504
#define NCHAR 505
#define NEW 506
#define NEXT 507
#define NO 508
#define NOCREATEDB 509
#define NOCREATEUSER 510
#define NONE 511
#define NOT 512
#define NOTHING 513
#define NOTIFY 514
#define NOTNULL 515
#define NOWAIT 516
#define NULL_P 517
#define NULLIF 518
#define NUMERIC 519
#define OBJECT_P 520
#define OF 521
#define OFF 522
#define OFFSET 523
#define OIDS 524
#define OLD 525
#define ON 526
#define ONLY 527
#define OPERATOR 528
#define OPTION 529
#define OR 530
#define ORDER 531
#define OUT_P 532
#define OUTER_P 533
#define OVERLAPS 534
#define OVERLAY 535
#define OWNER 536
#define PARTIAL 537
#define PASSWORD 538
#define PLACING 539
#define POSITION 540
#define PRECISION 541
#define PRESERVE 542
#define PREPARE 543
#define PRIMARY 544
#define PRIOR 545
#define PRIVILEGES 546
#define PROCEDURAL 547
#define PROCEDURE 548
#define QUOTE 549
#define READ 550
#define REAL 551
#define RECHECK 552
#define REFERENCES 553
#define REINDEX 554
#define RELATIVE_P 555
#define RELEASE 556
#define RENAME 557
#define REPEATABLE 558
#define REPLACE 559
#define RESET 560
#define RESTART 561
#define RESTRICT 562
#define RETURNS 563
#define REVOKE 564
#define RIGHT 565
#define ROLLBACK 566
#define ROW 567
#define ROWS 568
#define RULE 569
#define SAVEPOINT 570
#define SCHEMA 571
#define SCROLL 572
#define SECOND_P 573
#define SECURITY 574
#define SELECT 575
#define SEQUENCE 576
#define SERIALIZABLE 577
#define SESSION 578
#define SESSION_USER 579
#define SET 580
#define SETOF 581
#define SHARE 582
#define SHOW 583
#define SIMILAR 584
#define SIMPLE 585
#define SMALLINT 586
#define SOME 587
#define STABLE 588
#define START 589
#define STATEMENT 590
#define STATISTICS 591
#define STDIN 592
#define STDOUT 593
#define STORAGE 594
#define STRICT_P 595
#define SUBSTRING 596
#define SYSID 597
#define TABLE 598
#define TABLESPACE 599
#define TEMP 600
#define TEMPLATE 601
#define TEMPORARY 602
#define THEN 603
#define TIME 604
#define TIMESTAMP 605
#define TO 606
#define TOAST 607
#define TRAILING 608
#define TRANSACTION 609
#define TREAT 610
#define TRIGGER 611
#define TRIM 612
#define TRUE_P 613
#define TRUNCATE 614
#define TRUSTED 615
#define TYPE_P 616
#define UNCOMMITTED 617
#define UNENCRYPTED 618
#define UNION 619
#define UNIQUE 620
#define UNKNOWN 621
#define UNLISTEN 622
#define UNTIL 623
#define UPDATE 624
#define USAGE 625
#define USER 626
#define USING 627
#define VACUUM 628
#define VALID 629
#define VALUES 630
#define VARCHAR 631
#define VARYING 632
#define VERBOSE 633
#define VIEW 634
#define VOLATILE 635
#define WHEN 636
#define WHERE 637
#define WITH 638
#define WITHOUT 639
#define WORK 640
#define WRITE 641
#define YEAR_P 642
#define ZONE 643
#define UNIONJOIN 644
#define IDENT 645
#define SCONST 646
#define Op 647
#define CSTRING 648
#define CVARIABLE 649
#define CPP_LINE 650
#define IP 651
#define BCONST 652
#define XCONST 653
#define ICONST 654
#define PARAM 655
#define FCONST 656
#define POSTFIXOP 657
#define UMINUS 658




/* Copy the first part of user declarations.  */
#line 4 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
int ecpg_informix_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	QueryIsRule = 0, FoundInto = 0;
static int	initializer = 0;
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, 0L, NULL, {NULL}};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, 0L, NULL, {NULL}};

static struct inf_compat_col
{
	char *name;
	char *indirection;
	struct inf_compat_col *next;
} *informix_col;

static struct inf_compat_val
{
	char *val;
	struct inf_compat_val *next;
} *informix_val;

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, char * error, ...)
{
	va_list ap;
	
	fprintf(stderr, "%s:%d: ", input_filename, yylineno);
	
	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, "WARNING: ");
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, "ERROR: ");
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);
	
	fprintf(stderr, "\n");
	
	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	return mm_strdup(yytext);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct 
	 * An array is only allowed together with an element argument 
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else 
	 * so we don't have to worry here. */
	
	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
		result = cat2_str(result, make_str("? , "));

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_informix(struct arguments *list)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
 	 * for instance you can declare variables in a function, and then subsequently use them
	 * { 
	 *      declare_vars();
	 *      exec sql ... which uses vars declared in the above function
	 *
	 * This breaks standard and leads to some very dangerous programming. 
	 * Since they do, we have to work around and accept their syntax as well.
	 * But we will do so ONLY in Informix mode.
	 * We have to change the variables to our own struct and just store the pointer instead of the variable 
	 */

	 struct arguments *ptr;
	 char *result = make_str("");

	 for (ptr = list; ptr != NULL; ptr = ptr->next)
	 {
	 	char temp[20]; /* this should be sufficient unless you have 8 byte integers */
		char *original_var;
		
	 	/* change variable name to "ECPG_informix_get_var(<counter>)" */
		original_var = ptr->variable->name;
		sprintf(temp, "%d))", ecpg_informix_var);
		
		if ((ptr->variable->type->type != ECPGt_varchar && ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->variable->type->u.element->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, make_str("1")), ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else if ((ptr->variable->type->type == ECPGt_varchar || ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else
		{
			ptr->variable = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size), 0);
			sprintf(temp, "%d, &(", ecpg_informix_var++);
		}
		
		/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
		result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		
		/* now the indicator if there is one */
		if (ptr->indicator->type->type != ECPGt_NO_INDICATOR)
		{
			/* change variable name to "ECPG_informix_get_var(<counter>)" */
			original_var = ptr->indicator->name;
			sprintf(temp, "%d))", ecpg_informix_var);
			
			/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
			if (atoi(ptr->indicator->type->size) > 1)
			{
				ptr->indicator = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, (", ecpg_informix_var++);
			}
			else
			{
				ptr->indicator = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, &(", ecpg_informix_var++);
			}
			result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		}
	 }

	 return result;
}

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "trying to access an undeclared cursor %s\n", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier 
		 * note that we have to append here but have to keep the existing order */
		for (p = ptr->argsinsert; p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = ptr->argsresult; p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);
	
	return ptr;
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 308 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
} YYSTYPE;
/* Line 186 of yacc.c.  */
#line 1199 "y.tab.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1211 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   51044

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  424
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  514
/* YYNRULES -- Number of rules. */
#define YYNRULES  1941
/* YYNRULES -- Number of states. */
#define YYNSTATES  3188

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   659

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   410,     2,     2,
     415,   416,   408,   406,   421,   407,   417,   409,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   423,   418,
     403,   402,   404,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   413,     2,   414,   411,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   419,     2,   420,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   405,   412,   422
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     6,     9,    14,    18,    21,    23,
      25,    27,    29,    31,    34,    36,    38,    40,    42,    44,
      46,    48,    50,    52,    54,    56,    58,    60,    62,    64,
      66,    68,    70,    72,    74,    76,    78,    80,    82,    84,
      86,    88,    90,    92,    94,    96,    98,   100,   102,   104,
     106,   108,   110,   112,   114,   116,   118,   120,   122,   124,
     126,   128,   130,   132,   134,   136,   138,   140,   142,   144,
     146,   148,   150,   152,   154,   156,   158,   160,   162,   164,
     166,   168,   170,   172,   174,   176,   178,   180,   182,   184,
     186,   188,   190,   192,   194,   196,   198,   200,   202,   204,
     206,   208,   210,   212,   214,   216,   218,   224,   226,   227,
     232,   238,   244,   249,   253,   256,   257,   260,   263,   265,
     267,   269,   271,   275,   279,   283,   285,   290,   296,   299,
     300,   303,   306,   313,   320,   324,   331,   336,   338,   339,
     342,   343,   345,   347,   349,   351,   353,   355,   358,   362,
     366,   370,   374,   378,   381,   387,   390,   394,   398,   400,
     404,   406,   408,   410,   414,   417,   420,   423,   425,   427,
     429,   431,   433,   435,   437,   439,   441,   443,   447,   454,
     456,   458,   460,   462,   463,   465,   467,   470,   474,   479,
     483,   486,   489,   493,   498,   502,   505,   510,   512,   514,
     516,   518,   520,   525,   530,   532,   536,   540,   545,   552,
     559,   566,   573,   578,   585,   588,   593,   597,   601,   605,
     609,   611,   615,   619,   623,   627,   630,   632,   634,   635,
     638,   639,   642,   652,   654,   656,   658,   660,   662,   665,
     666,   668,   670,   674,   678,   680,   684,   688,   692,   697,
     699,   700,   703,   704,   708,   709,   711,   712,   724,   737,
     739,   741,   744,   747,   750,   753,   754,   756,   757,   759,
     763,   765,   767,   769,   773,   776,   777,   781,   783,   785,
     788,   790,   793,   797,   802,   805,   811,   813,   816,   819,
     822,   826,   829,   832,   833,   837,   839,   844,   850,   857,
     869,   873,   874,   878,   880,   882,   885,   888,   889,   891,
     893,   896,   899,   900,   904,   908,   911,   913,   915,   918,
     921,   926,   927,   930,   933,   934,   938,   943,   948,   949,
     952,   953,   958,   959,   960,   969,   973,   977,   979,   983,
     984,   988,   990,   992,   998,  1003,  1006,  1007,  1010,  1012,
    1015,  1019,  1022,  1025,  1028,  1031,  1035,  1039,  1041,  1042,
    1051,  1053,  1054,  1056,  1059,  1062,  1063,  1069,  1071,  1072,
    1079,  1082,  1083,  1087,  1102,  1122,  1124,  1126,  1128,  1132,
    1138,  1140,  1142,  1144,  1148,  1149,  1151,  1152,  1154,  1156,
    1158,  1162,  1163,  1165,  1167,  1168,  1171,  1173,  1176,  1178,
    1181,  1182,  1185,  1187,  1190,  1193,  1200,  1209,  1213,  1218,
    1223,  1228,  1234,  1238,  1242,  1244,  1248,  1252,  1254,  1256,
    1258,  1260,  1273,  1275,  1279,  1284,  1292,  1297,  1300,  1302,
    1303,  1305,  1306,  1314,  1319,  1321,  1323,  1325,  1327,  1329,
    1331,  1333,  1335,  1337,  1341,  1343,  1346,  1349,  1353,  1357,
    1363,  1368,  1373,  1377,  1382,  1386,  1390,  1393,  1398,  1401,
    1403,  1405,  1407,  1409,  1412,  1415,  1417,  1419,  1421,  1424,
    1427,  1429,  1432,  1435,  1437,  1439,  1441,  1448,  1458,  1466,
    1476,  1485,  1494,  1501,  1511,  1519,  1530,  1538,  1540,  1542,
    1544,  1546,  1548,  1550,  1552,  1554,  1556,  1558,  1560,  1562,
    1570,  1579,  1582,  1584,  1586,  1588,  1592,  1594,  1596,  1598,
    1600,  1602,  1604,  1606,  1608,  1610,  1612,  1614,  1616,  1618,
    1621,  1624,  1627,  1630,  1633,  1636,  1638,  1642,  1644,  1647,
    1651,  1652,  1656,  1657,  1659,  1663,  1666,  1679,  1681,  1682,
    1685,  1686,  1688,  1692,  1695,  1698,  1703,  1705,  1708,  1709,
    1719,  1722,  1723,  1727,  1730,  1732,  1736,  1740,  1743,  1745,
    1747,  1749,  1750,  1752,  1756,  1758,  1760,  1762,  1767,  1769,
    1772,  1775,  1778,  1780,  1782,  1784,  1789,  1795,  1797,  1801,
    1805,  1808,  1811,  1814,  1815,  1821,  1829,  1831,  1833,  1841,
    1843,  1847,  1851,  1855,  1857,  1861,  1873,  1884,  1887,  1888,
    1897,  1902,  1907,  1909,  1911,  1913,  1914,  1924,  1931,  1938,
    1946,  1953,  1960,  1970,  1977,  1984,  1991,  2000,  2009,  2016,
    2023,  2025,  2026,  2036,  2043,  2050,  2057,  2065,  2075,  2085,
    2092,  2099,  2106,  2107,  2122,  2124,  2126,  2130,  2134,  2136,
    2138,  2140,  2142,  2144,  2146,  2148,  2149,  2151,  2153,  2155,
    2157,  2159,  2161,  2162,  2169,  2172,  2175,  2178,  2181,  2184,
    2188,  2192,  2195,  2198,  2201,  2204,  2208,  2211,  2217,  2222,
    2224,  2226,  2227,  2231,  2234,  2237,  2239,  2243,  2246,  2248,
    2249,  2257,  2260,  2266,  2270,  2272,  2275,  2279,  2283,  2287,
    2291,  2295,  2299,  2303,  2307,  2311,  2315,  2317,  2318,  2324,
    2329,  2333,  2340,  2345,  2352,  2359,  2365,  2373,  2375,  2376,
    2387,  2392,  2395,  2397,  2402,  2408,  2414,  2417,  2422,  2424,
    2426,  2428,  2429,  2431,  2432,  2434,  2435,  2439,  2440,  2445,
    2447,  2449,  2451,  2453,  2455,  2457,  2458,  2463,  2468,  2471,
    2473,  2481,  2486,  2490,  2492,  2495,  2500,  2506,  2510,  2511,
    2514,  2517,  2520,  2524,  2526,  2530,  2532,  2535,  2537,  2538,
    2545,  2553,  2554,  2557,  2560,  2563,  2567,  2568,  2571,  2574,
    2576,  2578,  2582,  2586,  2588,  2591,  2596,  2601,  2603,  2605,
    2614,  2619,  2624,  2629,  2632,  2634,  2635,  2639,  2643,  2648,
    2653,  2658,  2663,  2666,  2668,  2670,  2671,  2673,  2674,  2676,
    2682,  2684,  2685,  2687,  2688,  2692,  2694,  2698,  2702,  2705,
    2708,  2710,  2715,  2720,  2723,  2726,  2731,  2733,  2734,  2736,
    2738,  2740,  2744,  2745,  2748,  2749,  2753,  2757,  2759,  2760,
    2763,  2764,  2767,  2768,  2772,  2774,  2776,  2779,  2781,  2784,
    2790,  2797,  2803,  2805,  2808,  2810,  2815,  2819,  2824,  2828,
    2834,  2839,  2845,  2850,  2856,  2859,  2864,  2866,  2869,  2872,
    2875,  2877,  2879,  2880,  2885,  2888,  2890,  2893,  2896,  2901,
    2903,  2906,  2907,  2909,  2913,  2916,  2919,  2923,  2929,  2936,
    2940,  2945,  2946,  2948,  2952,  2956,  2960,  2964,  2968,  2972,
    2974,  2976,  2978,  2980,  2982,  2984,  2986,  2989,  2995,  2998,
    3000,  3002,  3004,  3006,  3008,  3010,  3012,  3014,  3016,  3018,
    3020,  3023,  3026,  3029,  3032,  3035,  3037,  3041,  3042,  3048,
    3052,  3053,  3059,  3063,  3064,  3066,  3068,  3070,  3072,  3078,
    3081,  3083,  3085,  3087,  3089,  3095,  3098,  3101,  3104,  3106,
    3110,  3114,  3117,  3119,  3120,  3124,  3125,  3131,  3134,  3140,
    3143,  3145,  3149,  3153,  3154,  3156,  3158,  3160,  3162,  3164,
    3166,  3170,  3174,  3178,  3182,  3186,  3190,  3194,  3195,  3197,
    3201,  3207,  3210,  3213,  3216,  3219,  3222,  3225,  3229,  3233,
    3237,  3241,  3245,  3249,  3253,  3257,  3261,  3265,  3268,  3271,
    3275,  3279,  3282,  3286,  3292,  3297,  3304,  3308,  3314,  3319,
    3326,  3331,  3338,  3344,  3352,  3355,  3359,  3362,  3367,  3371,
    3376,  3380,  3385,  3389,  3394,  3400,  3407,  3415,  3421,  3428,
    3432,  3437,  3442,  3449,  3452,  3454,  3458,  3461,  3464,  3467,
    3470,  3473,  3477,  3481,  3485,  3489,  3493,  3497,  3501,  3505,
    3509,  3513,  3516,  3519,  3525,  3532,  3540,  3542,  3544,  3547,
    3552,  3554,  3556,  3558,  3561,  3564,  3567,  3569,  3573,  3578,
    3584,  3590,  3595,  3597,  3600,  3605,  3608,  3613,  3616,  3619,
    3622,  3629,  3634,  3639,  3644,  3649,  3656,  3662,  3668,  3674,
    3679,  3686,  3691,  3698,  3703,  3708,  3712,  3718,  3720,  3722,
    3724,  3726,  3728,  3730,  3732,  3734,  3736,  3738,  3740,  3742,
    3744,  3746,  3748,  3753,  3755,  3760,  3762,  3767,  3769,  3772,
    3774,  3777,  3779,  3783,  3787,  3788,  3792,  3794,  3796,  3800,
    3804,  3808,  3810,  3812,  3814,  3816,  3818,  3820,  3822,  3824,
    3829,  3833,  3836,  3840,  3841,  3845,  3849,  3852,  3855,  3857,
    3858,  3861,  3864,  3868,  3871,  3873,  3875,  3879,  3885,  3888,
    3890,  3895,  3898,  3899,  3901,  3902,  3904,  3907,  3910,  3913,
    3917,  3923,  3925,  3928,  3929,  3932,  3935,  3936,  3940,  3942,
    3946,  3948,  3950,  3954,  3962,  3964,  3967,  3972,  3974,  3978,
    3983,  3988,  3992,  3994,  3996,  3998,  4000,  4002,  4004,  4008,
    4010,  4013,  4015,  4019,  4021,  4023,  4025,  4027,  4029,  4031,
    4033,  4036,  4038,  4041,  4045,  4052,  4054,  4056,  4058,  4060,
    4062,  4064,  4066,  4068,  4070,  4072,  4074,  4076,  4079,  4081,
    4083,  4085,  4087,  4090,  4093,  4095,  4097,  4099,  4101,  4103,
    4105,  4107,  4109,  4112,  4115,  4117,  4119,  4121,  4123,  4125,
    4127,  4129,  4131,  4133,  4135,  4137,  4139,  4145,  4149,  4152,
    4155,  4159,  4167,  4169,  4172,  4175,  4177,  4178,  4180,  4184,
    4186,  4189,  4190,  4193,  4194,  4197,  4198,  4200,  4204,  4209,
    4213,  4215,  4217,  4219,  4222,  4223,  4231,  4235,  4238,  4240,
    4242,  4244,  4245,  4251,  4252,  4257,  4260,  4262,  4265,  4266,
    4268,  4272,  4276,  4280,  4284,  4285,  4290,  4296,  4302,  4303,
    4305,  4307,  4309,  4312,  4315,  4317,  4320,  4321,  4329,  4330,
    4336,  4337,  4342,  4345,  4348,  4350,  4352,  4354,  4356,  4358,
    4360,  4362,  4364,  4366,  4368,  4370,  4376,  4379,  4381,  4385,
    4388,  4391,  4395,  4396,  4402,  4404,  4405,  4411,  4414,  4417,
    4419,  4421,  4423,  4426,  4429,  4433,  4435,  4438,  4441,  4445,
    4449,  4454,  4457,  4459,  4462,  4464,  4466,  4469,  4472,  4476,
    4478,  4480,  4482,  4484,  4485,  4487,  4491,  4496,  4497,  4500,
    4501,  4503,  4506,  4510,  4513,  4515,  4517,  4519,  4520,  4522,
    4524,  4528,  4529,  4534,  4537,  4540,  4542,  4544,  4545,  4547,
    4549,  4551,  4553,  4556,  4560,  4561,  4563,  4566,  4568,  4573,
    4578,  4579,  4581,  4584,  4586,  4588,  4592,  4594,  4596,  4601,
    4606,  4611,  4616,  4618,  4619,  4623,  4627,  4632,  4634,  4638,
    4642,  4647,  4649,  4653,  4657,  4659,  4666,  4668,  4672,  4676,
    4683,  4685,  4689,  4693,  4695,  4697,  4699,  4701,  4703,  4705,
    4707,  4709,  4711,  4713,  4715,  4717,  4719,  4721,  4723,  4728,
    4733,  4735,  4737,  4742,  4747,  4751,  4752,  4760,  4762,  4763,
    4764,  4772,  4776,  4781,  4785,  4787,  4789,  4791,  4794,  4798,
    4804,  4807,  4813,  4816,  4818,  4820,  4822,  4824,  4826,  4828,
    4830,  4832,  4834,  4836,  4838,  4840,  4842,  4844,  4846,  4848,
    4850,  4852,  4854,  4856,  4858,  4860,  4862,  4864,  4866,  4868,
    4870,  4872,  4874,  4876,  4878,  4880,  4882,  4884,  4886,  4888,
    4890,  4892,  4894,  4896,  4898,  4900,  4902,  4904,  4906,  4908,
    4910,  4912,  4914,  4916,  4918,  4920,  4922,  4924,  4926,  4928,
    4930,  4932,  4934,  4936,  4938,  4940,  4942,  4944,  4946,  4948,
    4950,  4952,  4954,  4956,  4958,  4960,  4962,  4964,  4966,  4968,
    4970,  4972,  4974,  4976,  4978,  4980,  4982,  4984,  4986,  4988,
    4990,  4992,  4994,  4996,  4998,  5000,  5002,  5004,  5006,  5008,
    5010,  5012,  5014,  5016,  5018,  5020,  5022,  5024,  5026,  5028,
    5030,  5032,  5034,  5036,  5038,  5040,  5042,  5044,  5046,  5048,
    5050,  5052,  5054,  5056,  5058,  5060,  5062,  5064,  5066,  5068,
    5070,  5072,  5074,  5076,  5078,  5080,  5082,  5084,  5086,  5088,
    5090,  5092,  5094,  5096,  5098,  5100,  5102,  5104,  5106,  5108,
    5110,  5112,  5114,  5116,  5118,  5120,  5122,  5124,  5126,  5128,
    5130,  5132,  5134,  5136,  5138,  5140,  5142,  5144,  5146,  5148,
    5150,  5152,  5154,  5156,  5158,  5160,  5162,  5164,  5166,  5168,
    5170,  5172,  5174,  5176,  5178,  5180,  5182,  5184,  5186,  5188,
    5190,  5192,  5194,  5196,  5198,  5200,  5202,  5204,  5206,  5208,
    5210,  5212,  5214,  5216,  5218,  5220,  5222,  5224,  5226,  5228,
    5230,  5232,  5234,  5236,  5238,  5240,  5242,  5244,  5246,  5248,
    5250,  5252,  5254,  5256,  5258,  5260,  5262,  5264,  5266,  5268,
    5270,  5272,  5274,  5276,  5278,  5280,  5282,  5284,  5286,  5288,
    5290,  5292,  5294,  5296,  5298,  5300,  5302,  5304,  5306,  5308,
    5310,  5312,  5314,  5316,  5318,  5320,  5322,  5324,  5326,  5328,
    5330,  5332,  5334,  5336,  5338,  5340,  5342,  5344,  5346,  5348,
    5350,  5352,  5354,  5356,  5358,  5360,  5362,  5364,  5366,  5368,
    5370,  5372,  5374,  5376,  5378,  5380,  5382,  5384,  5386,  5388,
    5390,  5392,  5394,  5396,  5398,  5400,  5402,  5404,  5406,  5408,
    5410,  5412,  5414,  5416,  5418,  5420,  5422,  5424,  5426,  5428,
    5430,  5432,  5434,  5436,  5438,  5440,  5442,  5444,  5446,  5448,
    5450,  5452,  5454,  5456,  5458,  5460,  5462,  5464,  5466,  5468,
    5470,  5472,  5474,  5476,  5478,  5480,  5482,  5484,  5486,  5488,
    5490,  5492,  5494,  5496,  5498,  5500,  5502,  5504,  5506,  5508,
    5510,  5512,  5514,  5516,  5518,  5520,  5522,  5524,  5526,  5528,
    5530,  5532,  5534,  5536,  5538,  5540,  5542,  5544,  5546,  5548,
    5550,  5552,  5554,  5556,  5558,  5560,  5562,  5564,  5566,  5568,
    5570,  5572,  5574,  5576,  5578,  5580,  5582,  5586,  5588,  5589,
    5591,  5594,  5596,  5599,  5601,  5603,  5606,  5609,  5611,  5613,
    5615,  5617,  5619,  5621,  5624,  5628,  5630,  5633,  5635,  5639,
    5641,  5645,  5647,  5649,  5651,  5653,  5655,  5657,  5659,  5661,
    5663,  5665,  5667,  5669,  5671,  5673,  5675,  5677,  5679,  5681,
    5683,  5685,  5687,  5689,  5691,  5693,  5695,  5697,  5699,  5701,
    5703,  5705,  5707,  5709,  5711,  5713,  5715,  5717,  5719,  5721,
    5723,  5725,  5727,  5729,  5731,  5733,  5735,  5737,  5739,  5741,
    5743,  5745,  5747,  5749,  5751,  5753,  5755,  5757,  5759,  5761,
    5763,  5765
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     425,     0,    -1,   426,    -1,    -1,   426,   427,    -1,   923,
     428,   429,   418,    -1,   923,   429,   418,    -1,   923,   816,
      -1,   824,    -1,   936,    -1,   395,    -1,   419,    -1,   420,
      -1,    97,   802,    -1,   639,    -1,   642,    -1,   441,    -1,
     615,    -1,   516,    -1,   464,    -1,   433,    -1,   432,    -1,
     647,    -1,   463,    -1,   472,    -1,   645,    -1,   567,    -1,
     460,    -1,   473,    -1,   509,    -1,   543,    -1,   607,    -1,
     644,    -1,   641,    -1,   588,    -1,   438,    -1,   520,    -1,
     551,    -1,   443,    -1,   515,    -1,   482,    -1,   529,    -1,
     526,    -1,   430,    -1,   635,    -1,   666,    -1,   545,    -1,
     660,    -1,   544,    -1,   609,    -1,   442,    -1,   556,    -1,
     524,    -1,   624,    -1,   557,    -1,   528,    -1,   542,    -1,
     434,    -1,   640,    -1,   653,    -1,   563,    -1,   570,    -1,
     582,    -1,   656,    -1,   626,    -1,   634,    -1,   661,    -1,
     625,    -1,   610,    -1,   602,    -1,   604,    -1,   601,    -1,
     613,    -1,   571,    -1,   616,    -1,   669,    -1,   628,    -1,
     562,    -1,   627,    -1,   665,    -1,   646,    -1,   447,    -1,
     458,    -1,   459,    -1,   633,    -1,   878,    -1,   801,    -1,
     814,    -1,   815,    -1,   879,    -1,   856,    -1,   876,    -1,
     857,    -1,   860,    -1,   865,    -1,   887,    -1,   880,    -1,
     866,    -1,   875,    -1,   894,    -1,   896,    -1,   890,    -1,
     883,    -1,   897,    -1,   900,    -1,   902,    -1,   134,   371,
     799,   431,   435,    -1,   383,    -1,    -1,    87,   371,   799,
     435,    -1,    87,   371,   799,   383,   435,    -1,    87,   371,
     799,   325,   448,    -1,    87,   371,   799,   459,    -1,   164,
     371,   437,    -1,   435,   436,    -1,    -1,   283,   789,    -1,
     342,   790,    -1,   135,    -1,   254,    -1,   136,    -1,   255,
      -1,   203,   194,   437,    -1,   374,   368,   789,    -1,   437,
     421,   799,    -1,   799,    -1,   134,   194,   799,   439,    -1,
     134,   194,   799,   383,   439,    -1,   439,   440,    -1,    -1,
     371,   437,    -1,   342,   790,    -1,    87,   194,   799,    82,
     371,   437,    -1,    87,   194,   799,   164,   371,   437,    -1,
     164,   194,   799,    -1,   134,   316,   444,    98,   799,   445,
      -1,   134,   316,   909,   445,    -1,   909,    -1,    -1,   445,
     446,    -1,    -1,   482,    -1,   582,    -1,   515,    -1,   529,
      -1,   570,    -1,   633,    -1,   325,   448,    -1,   325,   237,
     448,    -1,   325,   323,   448,    -1,   449,   351,   450,    -1,
     449,   422,   450,    -1,   349,   388,   455,    -1,   354,   631,
      -1,   323,   117,    93,   354,   631,    -1,   247,   456,    -1,
     323,    98,   457,    -1,   323,    98,   151,    -1,   909,    -1,
     449,   417,   909,    -1,   451,    -1,   151,    -1,   453,    -1,
     451,   421,   453,    -1,   295,   362,    -1,   295,   128,    -1,
     303,   295,    -1,   322,    -1,   454,    -1,   797,    -1,   909,
      -1,   358,    -1,   179,    -1,   271,    -1,   267,    -1,   797,
      -1,   930,    -1,   727,   794,   729,    -1,   727,   415,   790,
     416,   794,   729,    -1,   151,    -1,   237,    -1,   794,    -1,
     151,    -1,    -1,   909,    -1,   794,    -1,   328,   909,    -1,
     328,   349,   388,    -1,   328,   354,   223,   232,    -1,   328,
     323,    98,    -1,   328,    85,    -1,   305,   909,    -1,   305,
     349,   388,    -1,   305,   354,   223,   232,    -1,   305,   323,
      98,    -1,   305,    85,    -1,   325,   130,   461,   462,    -1,
      85,    -1,   776,    -1,   154,    -1,   200,    -1,   119,    -1,
      87,   343,   700,   465,    -1,    87,   206,   700,   467,    -1,
     466,    -1,   465,   421,   466,    -1,    82,   614,   487,    -1,
      87,   614,   909,   469,    -1,    87,   614,   909,   164,   257,
     262,    -1,    87,   614,   909,   325,   257,   262,    -1,    87,
     614,   909,   325,   336,   790,    -1,    87,   614,   909,   325,
     339,   909,    -1,   164,   614,   909,   470,    -1,    87,   614,
     909,   361,   705,   471,    -1,    82,   494,    -1,   164,   129,
     777,   470,    -1,   325,   384,   269,    -1,   134,   352,   343,
      -1,   122,   271,   777,    -1,   325,   384,   122,    -1,   468,
      -1,   467,   421,   468,    -1,   281,   351,   799,    -1,   325,
     344,   777,    -1,   325,   151,   730,    -1,   164,   151,    -1,
     111,    -1,   307,    -1,    -1,   372,   730,    -1,    -1,   121,
     777,    -1,   133,   478,   775,   479,   474,   475,   480,   431,
     476,    -1,   351,    -1,   188,    -1,   794,    -1,   337,    -1,
     338,    -1,   476,   477,    -1,    -1,   104,    -1,   269,    -1,
     157,   643,   794,    -1,   262,   643,   794,    -1,   138,    -1,
     294,   643,   789,    -1,   170,   643,   789,    -1,   184,   294,
     497,    -1,   184,   257,   262,   497,    -1,   104,    -1,    -1,
     383,   269,    -1,    -1,   481,   158,   794,    -1,    -1,   372,
      -1,    -1,   134,   483,   343,   775,   415,   484,   416,   504,
     505,   506,   507,    -1,   134,   483,   343,   775,   266,   775,
     415,   484,   416,   505,   506,   507,    -1,   347,    -1,   345,
      -1,   237,   347,    -1,   237,   345,    -1,   192,   347,    -1,
     192,   345,    -1,    -1,   485,    -1,    -1,   486,    -1,   485,
     421,   486,    -1,   487,    -1,   492,    -1,   494,    -1,   909,
     705,   488,    -1,   488,   489,    -1,    -1,   129,   777,   490,
      -1,   490,    -1,   491,    -1,   257,   262,    -1,   262,    -1,
     365,   508,    -1,   289,   225,   508,    -1,   118,   415,   730,
     416,    -1,   151,   731,    -1,   298,   775,   496,   499,   500,
      -1,   153,    -1,   257,   153,    -1,   208,   154,    -1,   208,
     200,    -1,   233,   775,   493,    -1,   204,   152,    -1,   173,
     152,    -1,    -1,   129,   777,   495,    -1,   495,    -1,   118,
     415,   730,   416,    -1,   365,   415,   497,   416,   508,    -1,
     289,   225,   415,   497,   416,   508,    -1,   185,   225,   415,
     497,   416,   298,   775,   496,   499,   500,   539,    -1,   415,
     497,   416,    -1,    -1,   497,   421,   498,    -1,   498,    -1,
     909,    -1,   240,   189,    -1,   240,   282,    -1,    -1,   501,
      -1,   502,    -1,   501,   502,    -1,   502,   501,    -1,    -1,
     271,   156,   503,    -1,   271,   369,   503,    -1,   253,    81,
      -1,   307,    -1,   111,    -1,   325,   151,    -1,   325,   262,
      -1,   207,   415,   774,   416,    -1,    -1,   383,   269,    -1,
     384,   269,    -1,    -1,   271,   127,   164,    -1,   271,   127,
     156,   313,    -1,   271,   127,   287,   313,    -1,    -1,   344,
     777,    -1,    -1,   372,   206,   344,   777,    -1,    -1,    -1,
     134,   483,   343,   775,   512,   511,   510,   669,    -1,   383,
     269,    93,    -1,   384,   269,    93,    -1,    93,    -1,   415,
     513,   416,    -1,    -1,   513,   421,   514,    -1,   514,    -1,
     909,    -1,   134,   483,   321,   775,   517,    -1,    87,   321,
     775,   517,    -1,   517,   518,    -1,    -1,   109,   796,    -1,
     144,    -1,   253,   144,    -1,   205,   519,   796,    -1,   241,
     796,    -1,   243,   796,    -1,   253,   241,    -1,   253,   243,
      -1,   334,   431,   796,    -1,   306,   431,   796,    -1,   108,
      -1,    -1,   134,   521,   525,   227,   457,   195,   522,   523,
      -1,   360,    -1,    -1,   777,    -1,   777,   561,    -1,   226,
     794,    -1,    -1,   164,   525,   227,   794,   470,    -1,   292,
      -1,    -1,   134,   344,   777,   527,   238,   789,    -1,   281,
     777,    -1,    -1,   164,   344,   777,    -1,   134,   356,   777,
     530,   531,   271,   775,   533,   174,   293,   777,   415,   536,
     416,    -1,   134,   129,   356,   777,    83,   531,   271,   775,
     538,   539,   183,   165,   312,   174,   293,   783,   415,   536,
     416,    -1,   100,    -1,    83,    -1,   532,    -1,   532,   275,
     532,    -1,   532,   275,   532,   275,   532,    -1,   213,    -1,
     156,    -1,   369,    -1,   183,   534,   535,    -1,    -1,   165,
      -1,    -1,   312,    -1,   335,    -1,   537,    -1,   536,   421,
     537,    -1,    -1,   798,    -1,   909,    -1,    -1,   188,   775,
      -1,   540,    -1,   540,   541,    -1,   541,    -1,   541,   540,
      -1,    -1,   257,   153,    -1,   153,    -1,   208,   200,    -1,
     208,   154,    -1,   164,   356,   777,   271,   775,   470,    -1,
     134,    95,   777,   118,   415,   730,   416,   539,    -1,   164,
      95,   777,    -1,   134,    84,   783,   547,    -1,   134,   273,
     736,   547,    -1,   134,   361,   560,   547,    -1,   134,   361,
     560,    93,   546,    -1,   415,   703,   416,    -1,   415,   548,
     416,    -1,   549,    -1,   548,   421,   549,    -1,   912,   402,
     550,    -1,   912,    -1,   596,    -1,   739,    -1,   797,    -1,
     134,   273,   120,   560,   554,   183,   361,   705,   372,   779,
      93,   552,    -1,   553,    -1,   552,   421,   553,    -1,   273,
     790,   606,   555,    -1,   273,   790,   606,   415,   605,   416,
     555,    -1,   190,   790,   783,   590,    -1,   339,   705,    -1,
     151,    -1,    -1,   297,    -1,    -1,   164,   273,   120,   560,
     372,   779,   470,    -1,   164,   558,   559,   470,    -1,   343,
      -1,   321,    -1,   379,    -1,   206,    -1,   361,    -1,   162,
      -1,   131,    -1,   316,    -1,   560,    -1,   559,   421,   560,
      -1,   909,    -1,   909,   561,    -1,   417,   780,    -1,   561,
     417,   780,    -1,   359,   676,   775,    -1,   180,   564,   566,
     777,   872,    -1,   180,   564,   777,   872,    -1,   180,   566,
     777,   872,    -1,   180,   777,   872,    -1,   180,   564,   566,
     777,    -1,   180,   564,   777,    -1,   180,   566,   777,    -1,
     180,   777,    -1,   246,   564,   566,   777,    -1,   246,   777,
      -1,   252,    -1,   290,    -1,   181,    -1,   229,    -1,    79,
     565,    -1,   300,   565,    -1,   565,    -1,    85,    -1,   186,
      -1,   186,   565,    -1,   186,    85,    -1,    99,    -1,    99,
     565,    -1,    99,    85,    -1,   791,    -1,   203,    -1,   188,
      -1,   126,   271,   568,   777,   221,   569,    -1,   126,   271,
      84,   783,   415,   603,   416,   221,   569,    -1,   126,   271,
     190,   783,   590,   221,   569,    -1,   126,   271,   273,   736,
     415,   605,   416,   221,   569,    -1,   126,   271,   356,   777,
     271,   560,   221,   569,    -1,   126,   271,   314,   777,   271,
     560,   221,   569,    -1,   126,   271,   314,   777,   221,   569,
      -1,   126,   271,   273,   120,   560,   372,   779,   221,   569,
      -1,   126,   271,   228,   265,   796,   221,   569,    -1,   126,
     271,   113,   415,   705,    93,   705,   416,   221,   569,    -1,
     126,   271,   525,   227,   560,   221,   569,    -1,   125,    -1,
     145,    -1,   316,    -1,   206,    -1,   321,    -1,   343,    -1,
     162,    -1,   361,    -1,   379,    -1,   131,    -1,   794,    -1,
     262,    -1,   193,   572,   271,   575,   351,   576,   578,    -1,
     309,   579,   572,   271,   575,   188,   576,   470,    -1,    85,
     291,    -1,    85,    -1,   573,    -1,   574,    -1,   573,   421,
     574,    -1,   320,    -1,   213,    -1,   369,    -1,   156,    -1,
     314,    -1,   298,    -1,   356,    -1,   174,    -1,   370,    -1,
     134,    -1,   347,    -1,   345,    -1,   774,    -1,   343,   774,
      -1,   190,   580,    -1,   145,   776,    -1,   227,   776,    -1,
     316,   776,    -1,   344,   776,    -1,   577,    -1,   576,   421,
     577,    -1,   909,    -1,   194,   909,    -1,   383,   193,   274,
      -1,    -1,   193,   274,   183,    -1,    -1,   581,    -1,   580,
     421,   581,    -1,   783,   590,    -1,   134,   583,   206,   781,
     271,   775,   584,   415,   585,   416,   507,   702,    -1,   365,
      -1,    -1,   372,   779,    -1,    -1,   586,    -1,   585,   421,
     586,    -1,   909,   587,    -1,   733,   587,    -1,   415,   730,
     416,   587,    -1,   560,    -1,   372,   560,    -1,    -1,   134,
     589,   190,   783,   590,   308,   596,   598,   600,    -1,   275,
     304,    -1,    -1,   415,   591,   416,    -1,   415,   416,    -1,
     592,    -1,   591,   421,   592,    -1,   593,   595,   597,    -1,
     593,   597,    -1,   203,    -1,   277,    -1,   210,    -1,    -1,
     794,    -1,   794,   421,   794,    -1,   911,    -1,   597,    -1,
     705,    -1,   910,   561,   410,   361,    -1,   599,    -1,   598,
     599,    -1,    93,   594,    -1,   227,   457,    -1,   201,    -1,
     333,    -1,   380,    -1,   110,   271,   262,   211,    -1,   308,
     262,   271,   262,   211,    -1,   340,    -1,   177,   319,   155,
      -1,   177,   319,   220,    -1,   319,   155,    -1,   319,   220,
      -1,   383,   547,    -1,    -1,   164,   190,   783,   590,   470,
      -1,   164,    84,   783,   415,   603,   416,   470,    -1,   705,
      -1,   408,    -1,   164,   273,   736,   415,   605,   416,   470,
      -1,   705,    -1,   705,   421,   705,    -1,   256,   421,   705,
      -1,   705,   421,   256,    -1,   736,    -1,   909,   417,   606,
      -1,   134,   113,   415,   705,    93,   705,   416,   383,   190,
     581,   608,    -1,   134,   113,   415,   705,    93,   705,   416,
     384,   190,   608,    -1,    93,    96,    -1,    -1,   164,   113,
     415,   705,    93,   705,   416,   470,    -1,   299,   611,   775,
     612,    -1,   299,   145,   777,   612,    -1,   206,    -1,   343,
      -1,   184,    -1,    -1,    87,    84,   783,   415,   603,   416,
     302,   351,   777,    -1,    87,   131,   560,   302,   351,   777,
      -1,    87,   145,   778,   302,   351,   778,    -1,    87,   190,
     783,   590,   302,   351,   777,    -1,    87,   194,   799,   302,
     351,   799,    -1,    87,   227,   777,   302,   351,   777,    -1,
      87,   273,   120,   560,   372,   779,   302,   351,   777,    -1,
      87,   316,   777,   302,   351,   777,    -1,    87,   343,   700,
     302,   351,   777,    -1,    87,   206,   700,   302,   351,   777,
      -1,    87,   343,   700,   302,   614,   777,   351,   777,    -1,
      87,   356,   777,   271,   700,   302,   351,   777,    -1,    87,
     371,   799,   302,   351,   799,    -1,    87,   344,   777,   302,
     351,   777,    -1,   125,    -1,    -1,    87,    84,   783,   415,
     603,   416,   281,   351,   799,    -1,    87,   131,   560,   281,
     351,   799,    -1,    87,   145,   778,   281,   351,   799,    -1,
      87,   162,   778,   281,   351,   799,    -1,    87,   190,   783,
     590,   281,   351,   799,    -1,    87,   273,   606,   415,   605,
     416,   281,   351,   799,    -1,    87,   273,   120,   560,   372,
     779,   281,   351,   799,    -1,    87,   316,   777,   281,   351,
     799,    -1,    87,   361,   560,   281,   351,   799,    -1,    87,
     344,   777,   281,   351,   799,    -1,    -1,   134,   589,   314,
     777,    93,   617,   271,   622,   351,   775,   702,   161,   623,
     618,    -1,   258,    -1,   620,    -1,   415,   619,   416,    -1,
     619,   418,   621,    -1,   621,    -1,   669,    -1,   656,    -1,
     665,    -1,   660,    -1,   625,    -1,   620,    -1,    -1,   320,
      -1,   369,    -1,   156,    -1,   213,    -1,   214,    -1,    86,
      -1,    -1,   164,   314,   777,   271,   775,   470,    -1,   259,
     775,    -1,   235,   775,    -1,   367,   775,    -1,   367,   408,
      -1,    78,   629,    -1,   101,   629,   632,    -1,   334,   354,
     632,    -1,   127,   629,    -1,   169,   629,    -1,   311,   629,
      -1,   315,   909,    -1,   301,   315,   909,    -1,   301,   909,
      -1,   311,   629,   351,   315,   909,    -1,   311,   629,   351,
     909,    -1,   385,    -1,   354,    -1,    -1,   223,   232,   452,
      -1,   295,   272,    -1,   295,   386,    -1,   630,    -1,   631,
     421,   630,    -1,   631,   630,    -1,   631,    -1,    -1,   134,
     589,   379,   775,   496,    93,   669,    -1,   236,   782,    -1,
     134,   145,   778,   383,   636,    -1,   134,   145,   778,    -1,
     637,    -1,   636,   637,    -1,   344,   638,   777,    -1,   344,
     638,   151,    -1,   238,   638,   794,    -1,   238,   638,   151,
      -1,   346,   638,   777,    -1,   346,   638,   151,    -1,   167,
     638,   795,    -1,   167,   638,   151,    -1,   281,   638,   777,
      -1,   281,   638,   151,    -1,   402,    -1,    -1,    87,   145,
     778,   325,   448,    -1,    87,   145,   778,   459,    -1,   164,
     145,   778,    -1,   134,   162,   560,   643,   705,   488,    -1,
      87,   162,   560,   469,    -1,    87,   162,   560,   164,   257,
     262,    -1,    87,   162,   560,   325,   257,   262,    -1,    87,
     162,   560,    82,   494,    -1,    87,   162,   560,   164,   129,
     777,   470,    -1,    93,    -1,    -1,   134,   554,   131,   560,
     183,   794,   351,   794,   188,   560,    -1,   122,   781,   271,
     775,    -1,   122,   775,    -1,   122,    -1,   373,   650,   651,
     649,    -1,   373,   650,   651,   649,   775,    -1,   373,   650,
     651,   649,   647,    -1,   648,   649,    -1,   648,   649,   775,
     652,    -1,    89,    -1,    88,    -1,   378,    -1,    -1,   189,
      -1,    -1,   187,    -1,    -1,   415,   776,   416,    -1,    -1,
     176,   655,   649,   654,    -1,   669,    -1,   656,    -1,   665,
      -1,   660,    -1,   666,    -1,   648,    -1,    -1,   213,   219,
     775,   657,    -1,   375,   415,   771,   416,    -1,   151,   375,
      -1,   669,    -1,   415,   658,   416,   375,   415,   771,   416,
      -1,   415,   658,   416,   669,    -1,   658,   421,   659,    -1,
     659,    -1,   909,   763,    -1,   156,   188,   700,   702,    -1,
     239,   676,   774,   662,   664,    -1,   203,   663,   244,    -1,
      -1,    80,   327,    -1,   312,   327,    -1,   312,   172,    -1,
     327,   369,   172,    -1,   327,    -1,   327,   312,   172,    -1,
     172,    -1,    80,   172,    -1,   261,    -1,    -1,   369,   700,
     325,   767,   692,   702,    -1,   150,   777,   667,   143,   668,
     183,   669,    -1,    -1,   667,   104,    -1,   667,   212,    -1,
     667,   317,    -1,   667,   253,   317,    -1,    -1,   383,   197,
      -1,   384,   197,    -1,   671,    -1,   670,    -1,   415,   671,
     416,    -1,   415,   670,   416,    -1,   673,    -1,   672,   680,
      -1,   672,   679,   689,   684,    -1,   672,   679,   683,   690,
      -1,   673,    -1,   670,    -1,   320,   678,   765,   674,   692,
     702,   687,   688,    -1,   672,   364,   677,   672,    -1,   672,
     217,   677,   672,    -1,   672,   171,   677,   672,    -1,   219,
     675,    -1,   872,    -1,    -1,   347,   676,   775,    -1,   345,
     676,   775,    -1,   237,   347,   676,   775,    -1,   237,   345,
     676,   775,    -1,   192,   347,   676,   775,    -1,   192,   345,
     676,   775,    -1,   343,   775,    -1,   775,    -1,   343,    -1,
      -1,    85,    -1,    -1,   160,    -1,   160,   271,   415,   741,
     416,    -1,    85,    -1,    -1,   680,    -1,    -1,   276,   108,
     681,    -1,   682,    -1,   681,   421,   682,    -1,   730,   372,
     739,    -1,   730,    94,    -1,   730,   159,    -1,   730,    -1,
     234,   685,   268,   686,    -1,   268,   686,   234,   685,    -1,
     234,   685,    -1,   268,   686,    -1,   234,   685,   421,   686,
      -1,   683,    -1,    -1,   730,    -1,    85,    -1,   730,    -1,
     194,   108,   741,    -1,    -1,   196,   730,    -1,    -1,   183,
     369,   691,    -1,   183,   295,   272,    -1,   689,    -1,    -1,
     266,   776,    -1,    -1,   188,   693,    -1,    -1,   693,   421,
     694,    -1,   694,    -1,   700,    -1,   700,   696,    -1,   701,
      -1,   701,   696,    -1,   701,    93,   415,   703,   416,    -1,
     701,    93,   909,   415,   703,   416,    -1,   701,   909,   415,
     703,   416,    -1,   670,    -1,   670,   696,    -1,   695,    -1,
     415,   695,   416,   696,    -1,   415,   695,   416,    -1,   694,
     137,   224,   694,    -1,   694,   389,   694,    -1,   694,   697,
     224,   694,   699,    -1,   694,   224,   694,   699,    -1,   694,
     249,   697,   224,   694,    -1,   694,   249,   224,   694,    -1,
      93,   909,   415,   776,   416,    -1,    93,   909,    -1,   909,
     415,   776,   416,    -1,   909,    -1,   189,   698,    -1,   231,
     698,    -1,   310,   698,    -1,   209,    -1,   278,    -1,    -1,
     372,   415,   776,   416,    -1,   271,   730,    -1,   775,    -1,
     775,   408,    -1,   272,   775,    -1,   272,   415,   775,   416,
      -1,   733,    -1,   382,   730,    -1,    -1,   704,    -1,   703,
     421,   704,    -1,   909,   705,    -1,   708,   706,    -1,   326,
     708,   706,    -1,   708,    92,   413,   790,   414,    -1,   326,
     708,    92,   413,   790,   414,    -1,   413,   414,   706,    -1,
     413,   707,   414,   706,    -1,    -1,   790,    -1,   415,   707,
     416,    -1,   707,   406,   707,    -1,   707,   407,   707,    -1,
     707,   408,   707,    -1,   707,   409,   707,    -1,   707,   410,
     707,    -1,   789,    -1,   909,    -1,   710,    -1,   726,    -1,
     711,    -1,   715,    -1,   719,    -1,   727,   729,    -1,   727,
     415,   790,   416,   729,    -1,   910,   561,    -1,   710,    -1,
     726,    -1,   711,    -1,   716,    -1,   720,    -1,   910,    -1,
     215,    -1,   216,    -1,   331,    -1,   103,    -1,   296,    -1,
     182,   712,    -1,   163,   286,    -1,   149,   714,    -1,   148,
     714,    -1,   264,   713,    -1,   106,    -1,   415,   790,   416,
      -1,    -1,   415,   790,   421,   790,   416,    -1,   415,   790,
     416,    -1,    -1,   415,   790,   421,   790,   416,    -1,   415,
     790,   416,    -1,    -1,   717,    -1,   718,    -1,   717,    -1,
     718,    -1,   105,   724,   415,   790,   416,    -1,   105,   724,
      -1,   721,    -1,   722,    -1,   721,    -1,   722,    -1,   723,
     415,   790,   416,   725,    -1,   723,   725,    -1,   116,   724,
      -1,   115,   724,    -1,   376,    -1,   248,   116,   724,    -1,
     248,   115,   724,    -1,   250,   724,    -1,   377,    -1,    -1,
     116,   325,   909,    -1,    -1,   350,   415,   790,   416,   728,
      -1,   350,   728,    -1,   349,   415,   790,   416,   728,    -1,
     349,   728,    -1,   218,    -1,   383,   349,   388,    -1,   384,
     349,   388,    -1,    -1,   387,    -1,   245,    -1,   146,    -1,
     198,    -1,   242,    -1,   318,    -1,   387,   351,   245,    -1,
     146,   351,   198,    -1,   146,   351,   242,    -1,   146,   351,
     318,    -1,   198,   351,   242,    -1,   242,   351,   318,    -1,
     198,   351,   318,    -1,    -1,   732,    -1,   730,    77,   705,
      -1,   730,    97,   349,   388,   732,    -1,   406,   730,    -1,
     407,   730,    -1,   410,   730,    -1,   411,   730,    -1,   730,
     410,    -1,   730,   411,    -1,   730,   406,   730,    -1,   730,
     407,   730,    -1,   730,   408,   730,    -1,   730,   409,   730,
      -1,   730,   410,   730,    -1,   730,   411,   730,    -1,   730,
     403,   730,    -1,   730,   404,   730,    -1,   730,   402,   730,
      -1,   730,   738,   730,    -1,   738,   730,    -1,   730,   738,
      -1,   730,    90,   730,    -1,   730,   275,   730,    -1,   257,
     730,    -1,   730,   233,   730,    -1,   730,   233,   730,   170,
     730,    -1,   730,   257,   233,   730,    -1,   730,   257,   233,
     730,   170,   730,    -1,   730,   199,   730,    -1,   730,   199,
     730,   170,   730,    -1,   730,   257,   199,   730,    -1,   730,
     257,   199,   730,   170,   730,    -1,   730,   329,   351,   730,
      -1,   730,   329,   351,   730,   170,   730,    -1,   730,   257,
     329,   351,   730,    -1,   730,   257,   329,   351,   730,   170,
     730,    -1,   730,   222,    -1,   730,   221,   262,    -1,   730,
     260,    -1,   730,   221,   257,   262,    -1,   730,   221,   358,
      -1,   730,   221,   257,   358,    -1,   730,   221,   179,    -1,
     730,   221,   257,   179,    -1,   730,   221,   366,    -1,   730,
     221,   257,   366,    -1,   730,   221,   160,   188,   730,    -1,
     730,   221,   266,   415,   743,   416,    -1,   730,   221,   257,
     266,   415,   743,   416,    -1,   730,   102,   731,    90,   731,
      -1,   730,   257,   102,   731,    90,   731,    -1,   730,   203,
     754,    -1,   730,   257,   203,   754,    -1,   730,   740,   735,
     670,    -1,   730,   740,   735,   415,   730,   416,    -1,   365,
     670,    -1,   732,    -1,   731,    77,   705,    -1,   407,   731,
      -1,   410,   731,    -1,   411,   731,    -1,   731,   410,    -1,
     731,   411,    -1,   731,   406,   731,    -1,   731,   407,   731,
      -1,   731,   408,   731,    -1,   731,   409,   731,    -1,   731,
     410,   731,    -1,   731,   411,   731,    -1,   731,   403,   731,
      -1,   731,   404,   731,    -1,   731,   402,   731,    -1,   731,
     392,   731,    -1,   738,   731,    -1,   731,   738,    -1,   731,
     221,   160,   188,   731,    -1,   731,   221,   266,   415,   731,
     416,    -1,   731,   221,   257,   266,   415,   731,   416,    -1,
     760,    -1,   784,    -1,   400,   763,    -1,   415,   730,   416,
     763,    -1,   755,    -1,   733,    -1,   670,    -1,   175,   670,
      -1,    92,   670,    -1,    92,   745,    -1,   734,    -1,   783,
     415,   416,    -1,   783,   415,   741,   416,    -1,   783,   415,
      85,   741,   416,    -1,   783,   415,   160,   741,   416,    -1,
     783,   415,   408,   416,    -1,   139,    -1,   140,   764,    -1,
     140,   415,   790,   416,    -1,   141,   764,    -1,   141,   415,
     790,   416,    -1,   142,   764,    -1,   324,   764,    -1,   371,
     764,    -1,   113,   415,   730,    93,   705,   416,    -1,   178,
     415,   742,   416,    -1,   280,   415,   747,   416,    -1,   285,
     415,   749,   416,    -1,   341,   415,   750,   416,    -1,   355,
     415,   730,    93,   705,   416,    -1,   357,   415,   107,   753,
     416,    -1,   357,   415,   230,   753,   416,    -1,   357,   415,
     353,   753,   416,    -1,   357,   415,   753,   416,    -1,   132,
     415,   730,   372,   560,   416,    -1,   132,   415,   741,   416,
      -1,   263,   415,   730,   421,   730,   416,    -1,   123,   415,
     741,   416,    -1,   312,   415,   741,   416,    -1,   312,   415,
     416,    -1,   415,   741,   421,   730,   416,    -1,    91,    -1,
     332,    -1,    85,    -1,   392,    -1,   737,    -1,   406,    -1,
     407,    -1,   408,    -1,   410,    -1,   411,    -1,   409,    -1,
     403,    -1,   404,    -1,   402,    -1,   392,    -1,   273,   415,
     606,   416,    -1,   736,    -1,   273,   415,   606,   416,    -1,
     736,    -1,   273,   415,   606,   416,    -1,   233,    -1,   257,
     233,    -1,   199,    -1,   257,   199,    -1,   730,    -1,   741,
     421,   730,    -1,   746,   188,   730,    -1,    -1,   743,   421,
     705,    -1,   705,    -1,   745,    -1,   744,   421,   745,    -1,
     413,   741,   414,    -1,   413,   744,   414,    -1,   930,    -1,
     387,    -1,   245,    -1,   146,    -1,   198,    -1,   242,    -1,
     318,    -1,   794,    -1,   730,   748,   751,   752,    -1,   730,
     748,   751,    -1,   284,   730,    -1,   731,   203,   731,    -1,
      -1,   730,   751,   752,    -1,   730,   752,   751,    -1,   730,
     751,    -1,   730,   752,    -1,   741,    -1,    -1,   188,   730,
      -1,   183,   730,    -1,   730,   188,   741,    -1,   188,   741,
      -1,   741,    -1,   670,    -1,   415,   741,   416,    -1,   112,
     759,   756,   758,   169,    -1,   756,   757,    -1,   757,    -1,
     381,   730,   348,   730,    -1,   166,   730,    -1,    -1,   730,
      -1,    -1,   773,    -1,   773,   762,    -1,   417,   780,    -1,
     417,   408,    -1,   413,   730,   414,    -1,   413,   730,   423,
     730,   414,    -1,   761,    -1,   762,   761,    -1,    -1,   763,
     761,    -1,   415,   416,    -1,    -1,   765,   421,   766,    -1,
     766,    -1,   730,    93,   912,    -1,   730,    -1,   408,    -1,
     767,   421,   770,    -1,   415,   768,   416,   402,   415,   769,
     416,    -1,   770,    -1,   909,   763,    -1,   909,   763,   421,
     768,    -1,   730,    -1,   730,   421,   769,    -1,   909,   763,
     402,   730,    -1,   909,   763,   402,   151,    -1,   771,   421,
     772,    -1,   772,    -1,   730,    -1,   151,    -1,   800,    -1,
     909,    -1,   775,    -1,   774,   421,   775,    -1,   773,    -1,
     773,   762,    -1,   777,    -1,   776,   421,   777,    -1,   909,
      -1,   909,    -1,   909,    -1,   912,    -1,   909,    -1,   794,
      -1,   911,    -1,   773,   762,    -1,   798,    -1,   709,   794,
      -1,   727,   794,   729,    -1,   727,   415,   790,   416,   794,
     729,    -1,   358,    -1,   179,    -1,   262,    -1,   926,    -1,
     399,    -1,   401,    -1,   397,    -1,   398,    -1,   391,    -1,
     785,    -1,   927,    -1,   790,    -1,   407,   790,    -1,   785,
      -1,   929,    -1,   786,    -1,   792,    -1,   407,   786,    -1,
     407,   785,    -1,   789,    -1,   789,    -1,   927,    -1,   785,
      -1,   789,    -1,   927,    -1,   786,    -1,   785,    -1,   407,
     786,    -1,   407,   785,    -1,   927,    -1,   789,    -1,   796,
      -1,   789,    -1,   786,    -1,   785,    -1,   787,    -1,   788,
      -1,   927,    -1,   909,    -1,   270,    -1,   251,    -1,     9,
     351,   802,   808,   809,    -1,     9,   351,   151,    -1,     9,
     810,    -1,   145,   802,    -1,   778,   805,   807,    -1,   803,
     423,   804,   807,   409,   778,   813,    -1,   812,    -1,   930,
     929,    -1,   392,   806,    -1,   804,    -1,    -1,   909,    -1,
     909,   417,   806,    -1,   396,    -1,   423,   790,    -1,    -1,
      93,   802,    -1,    -1,   371,   810,    -1,    -1,   811,    -1,
     811,   409,   811,    -1,   811,    25,   108,   811,    -1,   811,
     372,   811,    -1,   799,    -1,   794,    -1,   929,    -1,   392,
     909,    -1,    -1,   150,   777,   667,   143,   668,   183,   864,
      -1,   147,   288,   864,    -1,   147,   864,    -1,   817,    -1,
     831,    -1,   818,    -1,    -1,   836,   839,   819,   852,   418,
      -1,    -1,   839,   820,   852,   418,    -1,   842,   418,    -1,
     796,    -1,   421,   796,    -1,    -1,   729,    -1,   387,   351,
     242,    -1,   387,   351,   318,    -1,   146,   351,   146,    -1,
     245,   351,   245,    -1,    -1,   826,   825,   828,   827,    -1,
     923,   101,   150,    39,   418,    -1,   923,   169,   150,    39,
     418,    -1,    -1,   829,    -1,   833,    -1,   831,    -1,   829,
     833,    -1,   829,   831,    -1,   833,    -1,   830,   833,    -1,
      -1,    76,   832,   839,   855,   913,   706,   418,    -1,    -1,
     836,   839,   834,   852,   418,    -1,    -1,   839,   835,   852,
     418,    -1,   842,   418,    -1,   837,   838,    -1,   837,    -1,
     838,    -1,    62,    -1,    73,    -1,    71,    -1,    56,    -1,
      57,    -1,    75,    -1,   848,    -1,   844,    -1,   840,    -1,
     913,   415,   821,   822,   416,    -1,   913,   823,    -1,   846,
      -1,    20,   908,   841,    -1,    20,   841,    -1,    20,   908,
      -1,   419,   934,   420,    -1,    -1,   846,   843,   419,   830,
     420,    -1,   842,    -1,    -1,   847,   845,   419,   830,   420,
      -1,    48,   908,    -1,   364,   908,    -1,    48,    -1,   364,
      -1,   849,    -1,   851,   850,    -1,    49,    40,    -1,    49,
      40,   215,    -1,    49,    -1,    49,   215,    -1,    49,    29,
      -1,    49,    29,   215,    -1,    49,    29,    29,    -1,    49,
      29,    29,   215,    -1,    49,   115,    -1,    40,    -1,    40,
     215,    -1,   215,    -1,    29,    -1,    29,   215,    -1,    29,
      29,    -1,    29,    29,   215,    -1,     5,    -1,   115,    -1,
     163,    -1,    41,    -1,    -1,   853,    -1,   852,   421,   853,
      -1,   855,   914,   706,   854,    -1,    -1,   402,   935,    -1,
      -1,   408,    -1,   408,   408,    -1,   150,   335,   930,    -1,
      19,   858,    -1,   859,    -1,    13,    -1,    85,    -1,    -1,
     802,    -1,   151,    -1,   174,   200,   863,    -1,    -1,   174,
     864,   861,   862,    -1,   868,   872,    -1,   872,   868,    -1,
     868,    -1,   872,    -1,    -1,   812,    -1,   393,    -1,   777,
      -1,   812,    -1,    22,   777,    -1,    33,   777,   867,    -1,
      -1,   868,    -1,   372,   873,    -1,   869,    -1,   372,   871,
      18,   931,    -1,   219,   871,    18,   931,    -1,    -1,    42,
      -1,   219,   922,    -1,   870,    -1,   874,    -1,   874,   421,
     873,    -1,   797,    -1,   926,    -1,   288,   864,   188,   863,
      -1,    17,   211,   777,   869,    -1,    17,   877,   777,   869,
      -1,    17,   877,   777,   870,    -1,    34,    -1,    -1,     3,
      18,   931,    -1,   147,    18,   931,    -1,   191,    18,   931,
     881,    -1,   882,    -1,   881,   421,   882,    -1,   929,   402,
     886,    -1,   325,    18,   931,   884,    -1,   885,    -1,   884,
     421,   885,    -1,   886,   402,   792,    -1,    12,    -1,   191,
      18,   931,    50,   792,   888,    -1,   889,    -1,   888,   421,
     889,    -1,   929,   402,   893,    -1,   325,    18,   931,    50,
     792,   891,    -1,   892,    -1,   891,   421,   892,    -1,   893,
     402,   793,    -1,     8,    -1,    14,    -1,    15,    -1,    16,
      -1,    26,    -1,    27,    -1,    28,    -1,    30,    -1,    31,
      -1,    32,    -1,   286,    -1,    36,    -1,    37,    -1,    38,
      -1,   361,    -1,   325,     4,   402,   895,    -1,   325,     4,
     351,   895,    -1,   271,    -1,   267,    -1,   325,    10,   351,
     859,    -1,   325,    10,   402,   859,    -1,   325,    10,   859,
      -1,    -1,   361,   898,   913,   221,   839,   706,   899,    -1,
      35,    -1,    -1,    -1,    51,   901,   912,   221,   839,   706,
     899,    -1,    52,    43,   903,    -1,    52,   257,    21,   903,
      -1,    52,    45,   903,    -1,    11,    -1,    44,    -1,    47,
      -1,    24,   777,    -1,    23,   351,   777,    -1,   161,   777,
     415,   924,   416,    -1,   161,     6,    -1,     7,   777,   415,
     924,   416,    -1,     7,   777,    -1,   905,    -1,   906,    -1,
       6,    -1,     7,    -1,     8,    -1,    11,    -1,    12,    -1,
      14,    -1,    15,    -1,    16,    -1,    21,    -1,    23,    -1,
      24,    -1,    25,    -1,    26,    -1,    27,    -1,    28,    -1,
      30,    -1,    31,    -1,    32,    -1,    36,    -1,    37,    -1,
      38,    -1,    39,    -1,    43,    -1,    44,    -1,    45,    -1,
      47,    -1,    50,    -1,     9,    -1,    17,    -1,    19,    -1,
      33,    -1,    51,    -1,    52,    -1,     5,    -1,    29,    -1,
      34,    -1,    40,    -1,    48,    -1,    41,    -1,    49,    -1,
     912,    -1,   930,    -1,   916,    -1,   919,    -1,   904,    -1,
     915,    -1,   115,    -1,   930,    -1,   916,    -1,   904,    -1,
     907,    -1,   915,    -1,   930,    -1,   916,    -1,   920,    -1,
     904,    -1,   915,    -1,   914,    -1,   907,    -1,   115,    -1,
     211,    -1,   215,    -1,   364,    -1,   351,    -1,   915,    -1,
     917,    -1,   930,    -1,   919,    -1,   920,    -1,   905,    -1,
     913,    -1,   921,    -1,   918,    -1,   906,    -1,    56,    -1,
      57,    -1,    62,    -1,    71,    -1,    73,    -1,    76,    -1,
      75,    -1,   917,    -1,   918,    -1,   146,    -1,   198,    -1,
     242,    -1,   245,    -1,   318,    -1,   387,    -1,    78,    -1,
      79,    -1,    80,    -1,    81,    -1,    82,    -1,    83,    -1,
      84,    -1,    86,    -1,    87,    -1,    95,    -1,    96,    -1,
      97,    -1,    99,    -1,   100,    -1,   101,    -1,   108,    -1,
     109,    -1,   111,    -1,   114,    -1,   117,    -1,   119,    -1,
     120,    -1,   121,    -1,   122,    -1,   126,    -1,   127,    -1,
     128,    -1,   130,    -1,   131,    -1,   133,    -1,   135,    -1,
     136,    -1,   138,    -1,   143,    -1,   144,    -1,   145,    -1,
     147,    -1,   150,    -1,   152,    -1,   154,    -1,   156,    -1,
     157,    -1,   158,    -1,   162,    -1,   163,    -1,   164,    -1,
     165,    -1,   167,    -1,   168,    -1,   170,    -1,   173,    -1,
     172,    -1,   174,    -1,   176,    -1,   180,    -1,   181,    -1,
     184,    -1,   186,    -1,   190,    -1,   192,    -1,   195,    -1,
     197,    -1,   200,    -1,   201,    -1,   202,    -1,   204,    -1,
     205,    -1,   206,    -1,   207,    -1,   212,    -1,   213,    -1,
     214,    -1,   223,    -1,   225,    -1,   226,    -1,   227,    -1,
     228,    -1,   229,    -1,   232,    -1,   235,    -1,   236,    -1,
     237,    -1,   238,    -1,   239,    -1,   240,    -1,   241,    -1,
     243,    -1,   244,    -1,   246,    -1,   247,    -1,   252,    -1,
     253,    -1,   254,    -1,   255,    -1,   258,    -1,   259,    -1,
     261,    -1,   265,    -1,   266,    -1,   269,    -1,   273,    -1,
     274,    -1,   281,    -1,   282,    -1,   283,    -1,   288,    -1,
     287,    -1,   290,    -1,   291,    -1,   292,    -1,   293,    -1,
     294,    -1,   295,    -1,   297,    -1,   299,    -1,   300,    -1,
     301,    -1,   302,    -1,   303,    -1,   304,    -1,   305,    -1,
     306,    -1,   307,    -1,   308,    -1,   309,    -1,   311,    -1,
     313,    -1,   314,    -1,   315,    -1,   316,    -1,   317,    -1,
     321,    -1,   322,    -1,   323,    -1,   325,    -1,   327,    -1,
     328,    -1,   330,    -1,   333,    -1,   334,    -1,   335,    -1,
     336,    -1,   337,    -1,   338,    -1,   339,    -1,   340,    -1,
     342,    -1,   344,    -1,   345,    -1,   346,    -1,   347,    -1,
     352,    -1,   354,    -1,   356,    -1,   359,    -1,   360,    -1,
     361,    -1,   362,    -1,   363,    -1,   366,    -1,   367,    -1,
     368,    -1,   369,    -1,   370,    -1,   373,    -1,   374,    -1,
     375,    -1,   377,    -1,   379,    -1,   383,    -1,   384,    -1,
     385,    -1,   386,    -1,   388,    -1,   103,    -1,   105,    -1,
     116,    -1,   123,    -1,   132,    -1,   148,    -1,   149,    -1,
     175,    -1,   178,    -1,   182,    -1,   210,    -1,   216,    -1,
     218,    -1,   248,    -1,   250,    -1,   256,    -1,   263,    -1,
     264,    -1,   277,    -1,   280,    -1,   285,    -1,   286,    -1,
     296,    -1,   312,    -1,   326,    -1,   331,    -1,   341,    -1,
     349,    -1,   350,    -1,   355,    -1,   357,    -1,   376,    -1,
      98,    -1,   102,    -1,   104,    -1,   137,    -1,   187,    -1,
     189,    -1,   199,    -1,   209,    -1,   221,    -1,   222,    -1,
     224,    -1,   231,    -1,   233,    -1,   249,    -1,   260,    -1,
     278,    -1,   279,    -1,   310,    -1,   329,    -1,   378,    -1,
      85,    -1,    88,    -1,    89,    -1,    90,    -1,    91,    -1,
      92,    -1,    93,    -1,    94,    -1,   107,    -1,   112,    -1,
     113,    -1,   118,    -1,   124,    -1,   125,    -1,   129,    -1,
     134,    -1,   139,    -1,   140,    -1,   141,    -1,   142,    -1,
     151,    -1,   153,    -1,   159,    -1,   160,    -1,   161,    -1,
     166,    -1,   169,    -1,   171,    -1,   179,    -1,   183,    -1,
     185,    -1,   188,    -1,   193,    -1,   194,    -1,   196,    -1,
     203,    -1,   208,    -1,   217,    -1,   219,    -1,   230,    -1,
     234,    -1,   251,    -1,   257,    -1,   262,    -1,   267,    -1,
     268,    -1,   270,    -1,   271,    -1,   272,    -1,   275,    -1,
     276,    -1,   289,    -1,   298,    -1,   320,    -1,   324,    -1,
     332,    -1,   343,    -1,   348,    -1,   353,    -1,   358,    -1,
     365,    -1,   371,    -1,   372,    -1,   381,    -1,   382,    -1,
     925,    -1,   922,   421,   925,    -1,    46,    -1,    -1,   934,
      -1,   929,   928,    -1,   929,    -1,   929,   928,    -1,   929,
      -1,   929,    -1,    26,   929,    -1,    26,   777,    -1,   394,
      -1,   390,    -1,   393,    -1,   777,    -1,   812,    -1,   937,
      -1,   415,   416,    -1,   415,   933,   416,    -1,   932,    -1,
     933,   932,    -1,   935,    -1,   934,   421,   935,    -1,   933,
      -1,   419,   934,   420,    -1,   937,    -1,   415,    -1,   416,
      -1,   421,    -1,   418,    -1,   390,    -1,   393,    -1,   785,
      -1,   786,    -1,   789,    -1,   408,    -1,   406,    -1,   407,
      -1,   409,    -1,   410,    -1,   262,    -1,    53,    -1,    54,
      -1,    55,    -1,    56,    -1,    57,    -1,    58,    -1,    59,
      -1,    60,    -1,    61,    -1,    62,    -1,    63,    -1,    64,
      -1,    66,    -1,    65,    -1,    67,    -1,    68,    -1,    69,
      -1,    70,    -1,    71,    -1,    72,    -1,    73,    -1,    74,
      -1,    76,    -1,    75,    -1,     5,    -1,    20,    -1,   198,
      -1,   215,    -1,    29,    -1,   242,    -1,   245,    -1,   318,
      -1,    40,    -1,    41,    -1,    48,    -1,    49,    -1,   387,
      -1,   115,    -1,   182,    -1,   351,    -1,   364,    -1,   376,
      -1,   413,    -1,   414,    -1,   402,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   588,   588,   590,   591,   594,   595,   596,   602,   603,
     604,   605,   606,   609,   621,   622,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   653,   654,   655,   656,   657,
     658,   659,   660,   661,   662,   663,   664,   665,   666,   667,
     668,   669,   670,   671,   672,   674,   675,   676,   677,   678,
     679,   680,   681,   682,   683,   684,   685,   686,   687,   688,
     690,   691,   692,   693,   694,   695,   696,   697,   699,   700,
     701,   702,   703,   704,   705,   706,   707,   713,   714,   715,
     716,   717,   718,   719,   720,   721,   727,   737,   741,   749,
     757,   761,   772,   782,   786,   793,   800,   806,   816,   826,
     832,   841,   848,   854,   863,   870,   891,   895,   896,   907,
     909,   913,   915,   925,   932,   933,   936,   938,   940,   942,
     944,   946,   948,   950,   954,   956,   966,   968,   975,   976,
     979,   981,   992,   994,  1004,  1015,  1017,  1021,  1022,  1025,
    1026,  1033,  1034,  1035,  1036,  1037,  1038,  1051,  1053,  1055,
    1059,  1061,  1063,  1065,  1067,  1069,  1071,  1073,  1077,  1078,
    1082,  1084,  1088,  1090,  1094,  1095,  1096,  1097,  1100,  1101,
    1102,  1105,  1106,  1107,  1108,  1118,  1119,  1120,  1122,  1124,
    1126,  1130,  1131,  1132,  1135,  1136,  1139,  1141,  1143,  1145,
    1147,  1151,  1153,  1155,  1157,  1159,  1163,  1167,  1169,  1173,
    1174,  1180,  1191,  1193,  1199,  1200,  1204,  1208,  1211,  1214,
    1217,  1220,  1223,  1226,  1229,  1232,  1235,  1238,  1241,  1244,
    1248,  1249,  1255,  1258,  1263,  1264,  1267,  1268,  1269,  1272,
    1273,  1283,  1297,  1302,  1303,  1311,  1312,  1313,  1316,  1317,
    1320,  1321,  1322,  1324,  1326,  1327,  1329,  1331,  1333,  1338,
    1339,  1342,  1343,  1350,  1353,  1356,  1357,  1367,  1370,  1380,
    1381,  1382,  1383,  1384,  1385,  1386,  1390,  1393,  1395,  1397,
    1401,  1402,  1403,  1406,  1412,  1413,  1416,  1418,  1419,  1433,
    1435,  1437,  1439,  1441,  1443,  1445,  1460,  1461,  1462,  1463,
    1466,  1473,  1474,  1475,  1482,  1484,  1488,  1490,  1492,  1494,
    1499,  1500,  1503,  1505,  1509,  1512,  1514,  1520,  1523,  1524,
    1525,  1526,  1527,  1530,  1534,  1538,  1539,  1540,  1541,  1542,
    1545,  1548,  1551,  1552,  1553,  1556,  1557,  1558,  1559,  1562,
    1563,  1566,  1567,  1576,  1575,  1593,  1594,  1595,  1599,  1602,
    1605,  1607,  1611,  1622,  1626,  1630,  1631,  1634,  1636,  1638,
    1640,  1642,  1644,  1646,  1648,  1650,  1652,  1656,  1657,  1668,
    1673,  1674,  1681,  1682,  1685,  1688,  1691,  1695,  1696,  1706,
    1710,  1711,  1725,  1736,  1741,  1749,  1750,  1753,  1755,  1757,
    1761,  1762,  1763,  1766,  1769,  1772,  1773,  1776,  1777,  1780,
    1782,  1785,  1788,  1789,  1792,  1793,  1796,  1797,  1804,  1805,
    1813,  1818,  1820,  1824,  1826,  1830,  1841,  1849,  1864,  1866,
    1868,  1870,  1874,  1878,  1882,  1883,  1886,  1887,  1891,  1892,
    1893,  1896,  1903,  1904,  1907,  1909,  1911,  1913,  1917,  1918,
    1921,  1922,  1925,  1937,  1941,  1942,  1943,  1944,  1945,  1946,
    1947,  1948,  1951,  1953,  1957,  1958,  1961,  1962,  1971,  1986,
    1991,  1996,  2001,  2006,  2011,  2016,  2021,  2026,  2028,  2032,
    2033,  2034,  2035,  2036,  2037,  2038,  2039,  2040,  2041,  2042,
    2043,  2044,  2045,  2048,  2051,  2052,  2055,  2057,  2059,  2061,
    2063,  2065,  2067,  2069,  2071,  2073,  2075,  2079,  2080,  2081,
    2082,  2083,  2084,  2085,  2086,  2087,  2088,  2091,  2092,  2102,
    2106,  2113,  2114,  2115,  2118,  2120,  2124,  2125,  2126,  2127,
    2128,  2129,  2130,  2131,  2132,  2133,  2134,  2135,  2138,  2140,
    2142,  2144,  2146,  2148,  2150,  2154,  2156,  2160,  2161,  2164,
    2169,  2172,  2177,  2180,  2182,  2186,  2197,  2202,  2203,  2206,
    2209,  2212,  2213,  2216,  2218,  2220,  2224,  2225,  2226,  2229,
    2234,  2235,  2238,  2240,  2244,  2246,  2250,  2251,  2254,  2255,
    2261,  2268,  2271,  2273,  2277,  2279,  2289,  2291,  2296,  2298,
    2302,  2304,  2306,  2308,  2310,  2312,  2314,  2316,  2318,  2320,
    2322,  2324,  2328,  2329,  2342,  2346,  2350,  2351,  2355,  2359,
    2361,  2363,  2365,  2370,  2372,  2376,  2379,  2384,  2385,  2389,
    2400,  2402,  2406,  2407,  2410,  2411,  2422,  2424,  2426,  2428,
    2430,  2432,  2434,  2436,  2438,  2440,  2442,  2444,  2446,  2448,
    2452,  2453,  2462,  2464,  2466,  2468,  2470,  2472,  2474,  2476,
    2478,  2480,  2492,  2491,  2501,  2502,  2503,  2507,  2509,  2513,
    2514,  2515,  2516,  2517,  2520,  2521,  2525,  2526,  2527,  2528,
    2531,  2532,  2533,  2536,  2548,  2552,  2556,  2558,  2571,  2572,
    2573,  2574,  2575,  2576,  2577,  2578,  2579,  2580,  2581,  2585,
    2586,  2587,  2591,  2593,  2594,  2598,  2599,  2600,  2604,  2605,
    2615,  2627,  2639,  2641,  2645,  2647,  2651,  2653,  2655,  2657,
    2659,  2661,  2663,  2665,  2667,  2669,  2673,  2674,  2685,  2687,
    2698,  2709,  2716,  2718,  2720,  2722,  2724,  2728,  2729,  2733,
    2747,  2749,  2751,  2764,  2766,  2768,  2772,  2774,  2778,  2779,
    2782,  2783,  2786,  2787,  2790,  2791,  2794,  2797,  2808,  2813,
    2814,  2815,  2816,  2817,  2821,  2822,  2871,  2875,  2877,  2879,
    2881,  2883,  2887,  2889,  2893,  2905,  2909,  2913,  2916,  2919,
    2920,  2921,  2922,  2923,  2924,  2925,  2926,  2929,  2930,  2940,
    2954,  2985,  2986,  2987,  2988,  2989,  2992,  2996,  2997,  3007,
    3009,  3013,  3015,  3019,  3021,  3023,  3025,  3029,  3030,  3033,
    3037,  3039,  3041,  3045,  3050,  3051,  3061,  3063,  3065,  3067,
    3069,  3071,  3073,  3075,  3079,  3080,  3083,  3084,  3087,  3089,
    3091,  3094,  3097,  3098,  3101,  3105,  3106,  3109,  3111,  3113,
    3115,  3119,  3121,  3123,  3125,  3127,  3131,  3132,  3135,  3136,
    3139,  3149,  3152,  3155,  3158,  3161,  3163,  3167,  3168,  3171,
    3172,  3183,  3184,  3187,  3188,  3198,  3200,  3202,  3204,  3206,
    3208,  3210,  3212,  3214,  3216,  3218,  3239,  3241,  3243,  3245,
    3247,  3249,  3251,  3255,  3257,  3259,  3261,  3265,  3266,  3267,
    3268,  3272,  3273,  3283,  3285,  3289,  3291,  3293,  3295,  3299,
    3302,  3303,  3306,  3308,  3312,  3325,  3327,  3329,  3331,  3336,
    3342,  3349,  3356,  3357,  3358,  3359,  3360,  3361,  3362,  3363,
    3364,  3367,  3368,  3369,  3370,  3371,  3372,  3374,  3376,  3380,
    3381,  3382,  3383,  3384,  3387,  3395,  3397,  3399,  3401,  3403,
    3405,  3407,  3409,  3411,  3413,  3415,  3419,  3422,  3425,  3427,
    3430,  3433,  3435,  3438,  3446,  3447,  3450,  3451,  3454,  3458,
    3467,  3468,  3471,  3472,  3475,  3479,  3483,  3485,  3487,  3489,
    3491,  3493,  3497,  3500,  3503,  3506,  3509,  3511,  3513,  3515,
    3519,  3523,  3525,  3528,  3531,  3532,  3533,  3534,  3535,  3536,
    3537,  3538,  3539,  3540,  3541,  3542,  3543,  3544,  3570,  3572,
    3574,  3585,  3587,  3589,  3591,  3593,  3595,  3597,  3599,  3601,
    3603,  3605,  3607,  3609,  3611,  3613,  3615,  3617,  3619,  3621,
    3623,  3625,  3627,  3629,  3631,  3633,  3635,  3637,  3639,  3641,
    3643,  3645,  3647,  3649,  3651,  3653,  3655,  3657,  3668,  3670,
    3672,  3674,  3676,  3678,  3680,  3682,  3684,  3686,  3688,  3690,
    3692,  3694,  3696,  3698,  3710,  3712,  3714,  3716,  3718,  3720,
    3722,  3724,  3726,  3728,  3730,  3732,  3734,  3736,  3738,  3740,
    3742,  3744,  3746,  3748,  3750,  3752,  3764,  3766,  3768,  3770,
    3772,  3774,  3776,  3778,  3780,  3782,  3784,  3796,  3798,  3800,
    3802,  3804,  3806,  3808,  3810,  3812,  3814,  3816,  3818,  3820,
    3822,  3824,  3826,  3828,  3830,  3832,  3835,  3837,  3839,  3841,
    3843,  3845,  3847,  3849,  3854,  3856,  3858,  3862,  3863,  3864,
    3867,  3868,  3871,  3872,  3873,  3874,  3875,  3876,  3877,  3878,
    3879,  3882,  3883,  3886,  3887,  3890,  3891,  3892,  3893,  3894,
    3895,  3898,  3900,  3904,  3907,  3910,  3912,  3916,  3917,  3921,
    3922,  3928,  3929,  3930,  3931,  3932,  3933,  3934,  3935,  3939,
    3941,  3946,  3950,  3953,  3956,  3958,  3960,  3962,  3964,  3967,
    3970,  3974,  3978,  3980,  3982,  3986,  3988,  3995,  3999,  4001,
    4005,  4009,  4012,  4015,  4016,  4019,  4020,  4024,  4025,  4026,
    4027,  4030,  4031,  4035,  4036,  4039,  4040,  4050,  4052,  4057,
    4059,  4061,  4066,  4068,  4092,  4096,  4105,  4116,  4124,  4134,
    4136,  4140,  4142,  4146,  4147,  4157,  4158,  4161,  4163,  4167,
    4169,  4173,  4175,  4180,  4181,  4182,  4183,  4184,  4186,  4188,
    4190,  4198,  4200,  4202,  4204,  4206,  4208,  4210,  4212,  4216,
    4217,  4218,  4219,  4220,  4231,  4232,  4235,  4236,  4239,  4247,
    4250,  4258,  4259,  4268,  4277,  4289,  4290,  4293,  4294,  4295,
    4298,  4299,  4300,  4301,  4302,  4305,  4306,  4309,  4310,  4311,
    4312,  4313,  4314,  4317,  4319,  4326,  4342,  4344,  4347,  4349,
    4353,  4365,  4381,  4387,  4399,  4408,  4409,  4412,  4413,  4414,
    4417,  4418,  4421,  4422,  4425,  4426,  4429,  4431,  4433,  4435,
    4439,  4446,  4469,  4501,  4511,  4518,  4558,  4560,  4567,  4569,
    4570,  4575,  4573,  4588,  4587,  4600,  4606,  4608,  4609,  4612,
    4613,  4614,  4615,  4616,  4623,  4622,  4632,  4634,  4636,  4637,
    4640,  4641,  4642,  4643,  4646,  4647,  4651,  4650,  4711,  4709,
    4724,  4723,  4736,  4742,  4746,  4750,  4756,  4757,  4758,  4759,
    4762,  4763,  4766,  4774,  4791,  4799,  4822,  4916,  4950,  4952,
    4954,  4958,  4962,  4961,  5012,  5014,  5013,  5028,  5034,  5041,
    5046,  5049,  5050,  5053,  5054,  5055,  5056,  5057,  5058,  5059,
    5067,  5075,  5078,  5079,  5080,  5081,  5082,  5083,  5091,  5099,
    5100,  5101,  5104,  5105,  5108,  5110,  5114,  5185,  5186,  5193,
    5194,  5195,  5201,  5210,  5213,  5214,  5215,  5216,  5219,  5220,
    5226,  5240,  5239,  5257,  5258,  5259,  5260,  5261,  5264,  5266,
    5270,  5271,  5278,  5283,  5285,  5286,  5289,  5290,  5293,  5300,
    5307,  5307,  5309,  5310,  5313,  5313,  5315,  5325,  5334,  5340,
    5346,  5352,  5360,  5361,  5373,  5383,  5394,  5398,  5399,  5402,
    5407,  5411,  5412,  5415,  5422,  5429,  5433,  5434,  5437,  5440,
    5444,  5445,  5448,  5455,  5456,  5457,  5458,  5459,  5460,  5461,
    5462,  5463,  5464,  5465,  5466,  5467,  5468,  5469,  5499,  5500,
    5503,  5504,  5511,  5512,  5513,  5520,  5519,  5578,  5579,  5586,
    5585,  5654,  5660,  5666,  5674,  5680,  5686,  5692,  5698,  5704,
    5710,  5716,  5722,  5733,  5734,  5737,  5738,  5739,  5740,  5741,
    5742,  5743,  5744,  5745,  5746,  5747,  5748,  5749,  5750,  5751,
    5752,  5753,  5754,  5755,  5756,  5757,  5758,  5759,  5760,  5761,
    5762,  5763,  5766,  5767,  5768,  5769,  5770,  5771,  5775,  5776,
    5777,  5778,  5779,  5780,  5781,  5784,  5800,  5801,  5802,  5803,
    5804,  5805,  5810,  5811,  5812,  5813,  5814,  5819,  5820,  5821,
    5822,  5823,  5829,  5830,  5831,  5832,  5833,  5834,  5835,  5836,
    5837,  5840,  5841,  5842,  5843,  5846,  5847,  5848,  5849,  5852,
    5853,  5854,  5855,  5856,  5857,  5858,  5876,  5876,  5878,  5879,
    5880,  5881,  5882,  5883,  5886,  5887,  5888,  5889,  5890,  5891,
    5892,  5893,  5894,  5895,  5896,  5897,  5898,  5899,  5900,  5901,
    5902,  5903,  5904,  5905,  5906,  5907,  5908,  5909,  5910,  5911,
    5912,  5913,  5914,  5915,  5916,  5917,  5918,  5919,  5920,  5921,
    5923,  5924,  5925,  5926,  5927,  5928,  5929,  5930,  5931,  5932,
    5933,  5934,  5935,  5936,  5937,  5938,  5939,  5940,  5941,  5942,
    5943,  5944,  5945,  5946,  5947,  5948,  5950,  5951,  5952,  5953,
    5954,  5955,  5956,  5957,  5958,  5959,  5960,  5961,  5962,  5963,
    5964,  5965,  5966,  5967,  5968,  5969,  5970,  5971,  5972,  5973,
    5975,  5976,  5978,  5979,  5980,  5981,  5982,  5983,  5984,  5985,
    5986,  5987,  5988,  5989,  5990,  5991,  5992,  5993,  5994,  5995,
    5996,  5997,  5998,  5999,  6000,  6001,  6002,  6003,  6004,  6005,
    6006,  6007,  6008,  6009,  6010,  6011,  6012,  6013,  6014,  6015,
    6016,  6017,  6018,  6019,  6020,  6022,  6023,  6024,  6025,  6026,
    6027,  6028,  6029,  6030,  6031,  6032,  6033,  6034,  6035,  6036,
    6037,  6038,  6039,  6040,  6041,  6042,  6043,  6044,  6045,  6046,
    6047,  6048,  6049,  6050,  6051,  6052,  6053,  6054,  6055,  6056,
    6057,  6058,  6059,  6060,  6061,  6062,  6063,  6065,  6079,  6080,
    6084,  6085,  6086,  6087,  6088,  6089,  6090,  6091,  6092,  6096,
    6097,  6098,  6099,  6100,  6101,  6102,  6103,  6104,  6105,  6106,
    6107,  6108,  6109,  6110,  6111,  6112,  6113,  6114,  6115,  6116,
    6130,  6131,  6132,  6133,  6134,  6135,  6136,  6137,  6138,  6139,
    6140,  6141,  6142,  6143,  6144,  6145,  6146,  6147,  6148,  6149,
    6159,  6160,  6161,  6162,  6163,  6164,  6165,  6166,  6167,  6168,
    6169,  6170,  6171,  6172,  6173,  6174,  6175,  6176,  6177,  6178,
    6179,  6180,  6181,  6182,  6183,  6184,  6185,  6186,  6187,  6188,
    6189,  6190,  6191,  6192,  6193,  6194,  6195,  6196,  6197,  6198,
    6199,  6200,  6201,  6202,  6203,  6204,  6205,  6206,  6207,  6208,
    6209,  6210,  6211,  6212,  6213,  6214,  6215,  6216,  6220,  6221,
    6225,  6226,  6227,  6228,  6229,  6233,  6233,  6236,  6239,  6240,
    6243,  6245,  6250,  6260,  6267,  6268,  6269,  6272,  6301,  6302,
    6305,  6307,  6315,  6316,  6317,  6321,  6322,  6326,  6327,  6330,
    6331,  6334,  6335,  6336,  6337,  6338,  6341,  6342,  6343,  6344,
    6345,  6346,  6347,  6348,  6349,  6350,  6351,  6352,  6353,  6354,
    6355,  6356,  6357,  6358,  6359,  6360,  6361,  6362,  6363,  6364,
    6365,  6366,  6367,  6368,  6369,  6370,  6371,  6372,  6373,  6374,
    6375,  6376,  6377,  6378,  6379,  6380,  6381,  6382,  6383,  6384,
    6385,  6386,  6387,  6388,  6389,  6390,  6391,  6392,  6393,  6394,
    6395,  6396
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_CONNECTION", "SQL_CONTINUE", "SQL_COUNT", "SQL_CURRENT", 
  "SQL_DATA", "SQL_DATETIME_INTERVAL_CODE", 
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR", 
  "SQL_DISCONNECT", "SQL_ENUM", "SQL_FOUND", "SQL_FREE", "SQL_GO", 
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER", 
  "SQL_LENGTH", "SQL_LONG", "SQL_NAME", "SQL_NULLABLE", 
  "SQL_OCTET_LENGTH", "SQL_OPEN", "SQL_OUTPUT", "SQL_REFERENCE", 
  "SQL_RETURNED_LENGTH", "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", 
  "SQL_SECTION", "SQL_SHORT", "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", 
  "SQL_SQLPRINT", "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", 
  "SQL_UNSIGNED", "SQL_VALUE", "SQL_VAR", "SQL_WHENEVER", "S_ADD", 
  "S_AND", "S_ANYTHING", "S_AUTO", "S_CONST", "S_DEC", "S_DIV", 
  "S_DOTPOINT", "S_EQUAL", "S_EXTERN", "S_INC", "S_LSHIFT", "S_MEMPOINT", 
  "S_MEMBER", "S_MOD", "S_MUL", "S_NEQUAL", "S_OR", "S_REGISTER", 
  "S_RSHIFT", "S_STATIC", "S_SUB", "S_VOLATILE", "S_TYPEDEF", "TYPECAST", 
  "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION", "ADD", "AFTER", 
  "AGGREGATE", "ALL", "ALSO", "ALTER", "ANALYSE", "ANALYZE", "AND", "ANY", 
  "ARRAY", "AS", "ASC", "ASSERTION", "ASSIGNMENT", "AT", "AUTHORIZATION", 
  "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", "BINARY", "BIT", 
  "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", "CASCADE", "CASE", "CAST", 
  "CHAIN", "CHAR_P", "CHARACTER", "CHARACTERISTICS", "CHECK", 
  "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER", "COALESCE", "COLLATE", 
  "COLUMN", "COMMENT", "COMMIT", "COMMITTED", "CONSTRAINT", "CONSTRAINTS", 
  "CONVERSION_P", "CONVERT", "COPY", "CREATE", "CREATEDB", "CREATEUSER", 
  "CROSS", "CSV", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", 
  "CURRENT_USER", "CURSOR", "CYCLE", "DATABASE", "DAY_P", "DEALLOCATE", 
  "DEC", "DECIMAL_P", "DECLARE", "DEFAULT", "DEFAULTS", "DEFERRABLE", 
  "DEFERRED", "DEFINER", "DELETE_P", "DELIMITER", "DELIMITERS", "DESC", 
  "DISTINCT", "DO", "DOMAIN_P", "DOUBLE_P", "DROP", "EACH", "ELSE", 
  "ENCODING", "ENCRYPTED", "END_P", "ESCAPE", "EXCEPT", "EXCLUSIVE", 
  "EXCLUDING", "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", "EXTRACT", 
  "FALSE_P", "FETCH", "FIRST_P", "FLOAT_P", "FOR", "FORCE", "FOREIGN", 
  "FORWARD", "FREEZE", "FROM", "FULL", "FUNCTION", "GET", "GLOBAL", 
  "GRANT", "GROUP_P", "HANDLER", "HAVING", "HOLD", "HOUR_P", "ILIKE", 
  "IMMEDIATE", "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", 
  "INCREMENT", "INDEX", "INHERITS", "INITIALLY", "INNER_P", "INOUT", 
  "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", "INT_P", "INTEGER", 
  "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", "ISNULL", "ISOLATION", 
  "JOIN", "KEY", "LANCOMPILER", "LANGUAGE", "LARGE_P", "LAST_P", 
  "LEADING", "LEFT", "LEVEL", "LIKE", "LIMIT", "LISTEN", "LOAD", "LOCAL", 
  "LOCATION", "LOCK_P", "MATCH", "MAXVALUE", "MINUTE_P", "MINVALUE", 
  "MODE", "MONTH_P", "MOVE", "NAMES", "NATIONAL", "NATURAL", "NCHAR", 
  "NEW", "NEXT", "NO", "NOCREATEDB", "NOCREATEUSER", "NONE", "NOT", 
  "NOTHING", "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P", "NULLIF", "NUMERIC", 
  "OBJECT_P", "OF", "OFF", "OFFSET", "OIDS", "OLD", "ON", "ONLY", 
  "OPERATOR", "OPTION", "OR", "ORDER", "OUT_P", "OUTER_P", "OVERLAPS", 
  "OVERLAY", "OWNER", "PARTIAL", "PASSWORD", "PLACING", "POSITION", 
  "PRECISION", "PRESERVE", "PREPARE", "PRIMARY", "PRIOR", "PRIVILEGES", 
  "PROCEDURAL", "PROCEDURE", "QUOTE", "READ", "REAL", "RECHECK", 
  "REFERENCES", "REINDEX", "RELATIVE_P", "RELEASE", "RENAME", 
  "REPEATABLE", "REPLACE", "RESET", "RESTART", "RESTRICT", "RETURNS", 
  "REVOKE", "RIGHT", "ROLLBACK", "ROW", "ROWS", "RULE", "SAVEPOINT", 
  "SCHEMA", "SCROLL", "SECOND_P", "SECURITY", "SELECT", "SEQUENCE", 
  "SERIALIZABLE", "SESSION", "SESSION_USER", "SET", "SETOF", "SHARE", 
  "SHOW", "SIMILAR", "SIMPLE", "SMALLINT", "SOME", "STABLE", "START", 
  "STATEMENT", "STATISTICS", "STDIN", "STDOUT", "STORAGE", "STRICT_P", 
  "SUBSTRING", "SYSID", "TABLE", "TABLESPACE", "TEMP", "TEMPLATE", 
  "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TO", "TOAST", "TRAILING", 
  "TRANSACTION", "TREAT", "TRIGGER", "TRIM", "TRUE_P", "TRUNCATE", 
  "TRUSTED", "TYPE_P", "UNCOMMITTED", "UNENCRYPTED", "UNION", "UNIQUE", 
  "UNKNOWN", "UNLISTEN", "UNTIL", "UPDATE", "USAGE", "USER", "USING", 
  "VACUUM", "VALID", "VALUES", "VARCHAR", "VARYING", "VERBOSE", "VIEW", 
  "VOLATILE", "WHEN", "WHERE", "WITH", "WITHOUT", "WORK", "WRITE", 
  "YEAR_P", "ZONE", "UNIONJOIN", "IDENT", "SCONST", "Op", "CSTRING", 
  "CVARIABLE", "CPP_LINE", "IP", "BCONST", "XCONST", "ICONST", "PARAM", 
  "FCONST", "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", "'*'", "'/'", 
  "'%'", "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", "';'", "'{'", 
  "'}'", "','", "\"=\"", "':'", "$accept", "prog", "statements", 
  "statement", "opt_at", "stmt", "CreateUserStmt", "opt_with", 
  "AlterUserStmt", "AlterUserSetStmt", "DropUserStmt", "OptUserList", 
  "OptUserElem", "user_list", "CreateGroupStmt", "OptGroupList", 
  "OptGroupElem", "AlterGroupStmt", "DropGroupStmt", "CreateSchemaStmt", 
  "OptSchemaName", "OptSchemaEltList", "schema_stmt", "VariableSetStmt", 
  "set_rest", "var_name", "var_list_or_default", "var_list", "iso_level", 
  "var_value", "opt_boolean", "zone_value", "opt_encoding", 
  "ColId_or_Sconst", "VariableShowStmt", "VariableResetStmt", 
  "ConstraintsSetStmt", "constraints_set_list", "constraints_set_mode", 
  "CheckPointStmt", "AlterTableStmt", "alter_table_cmds", 
  "alter_table_cmd", "alter_rel_cmds", "alter_rel_cmd", 
  "alter_column_default", "opt_drop_behavior", "alter_using", 
  "ClosePortalStmt", "CopyStmt", "copy_from", "copy_file_name", 
  "copy_opt_list", "copy_opt_item", "opt_binary", "opt_oids", 
  "copy_delimiter", "opt_using", "CreateStmt", "OptTemp", 
  "OptTableElementList", "TableElementList", "TableElement", "columnDef", 
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr", 
  "TableLikeClause", "like_including_defaults", "TableConstraint", 
  "ConstraintElem", "opt_column_list", "columnList", "columnElem", 
  "key_match", "key_actions", "key_delete", "key_update", "key_action", 
  "OptInherit", "OptWithOids", "OnCommitOption", "OptTableSpace", 
  "OptConsTableSpace", "CreateAsStmt", "@1", "WithOidsAs", "OptCreateAs", 
  "CreateAsList", "CreateAsElement", "CreateSeqStmt", "AlterSeqStmt", 
  "OptSeqList", "OptSeqElem", "opt_by", "CreatePLangStmt", "opt_Trusted", 
  "handler_name", "opt_lancompiler", "DropPLangStmt", "opt_procedural", 
  "CreateTableSpaceStmt", "OptTableSpaceOwner", "DropTableSpaceStmt", 
  "CreateTrigStmt", "TriggerActionTime", "TriggerEvents", 
  "TriggerOneEvent", "TriggerForSpec", "TriggerForOpt", "TriggerForType", 
  "TriggerFuncArgs", "TriggerFuncArg", "OptConstrFromTable", 
  "ConstraintAttributeSpec", "ConstraintDeferrabilitySpec", 
  "ConstraintTimeSpec", "DropTrigStmt", "CreateAssertStmt", 
  "DropAssertStmt", "DefineStmt", "rowdefinition", "definition", 
  "def_list", "def_elem", "def_arg", "CreateOpClassStmt", 
  "opclass_item_list", "opclass_item", "opt_default", "opt_recheck", 
  "DropOpClassStmt", "DropStmt", "drop_type", "any_name_list", "any_name", 
  "attrs", "TruncateStmt", "FetchStmt", "fetch_direction", "fetch_count", 
  "from_in", "CommentStmt", "comment_type", "comment_text", "GrantStmt", 
  "RevokeStmt", "privileges", "privilege_list", "privilege", 
  "privilege_target", "grantee_list", "grantee", "opt_grant_grant_option", 
  "opt_revoke_grant_option", "function_with_argtypes_list", 
  "function_with_argtypes", "IndexStmt", "index_opt_unique", 
  "access_method_clause", "index_params", "index_elem", "opt_class", 
  "CreateFunctionStmt", "opt_or_replace", "func_args", "func_args_list", 
  "func_arg", "arg_class", "func_as", "param_name", "func_return", 
  "func_type", "createfunc_opt_list", "createfunc_opt_item", 
  "opt_definition", "RemoveFuncStmt", "RemoveAggrStmt", "aggr_argtype", 
  "RemoveOperStmt", "oper_argtypes", "any_operator", "CreateCastStmt", 
  "cast_context", "DropCastStmt", "ReindexStmt", "reindex_type", 
  "opt_force", "RenameStmt", "opt_column", "AlterOwnerStmt", "RuleStmt", 
  "@2", "RuleActionList", "RuleActionMulti", "RuleActionStmt", 
  "RuleActionStmtOrEmpty", "event", "opt_instead", "DropRuleStmt", 
  "NotifyStmt", "ListenStmt", "UnlistenStmt", "TransactionStmt", 
  "opt_transaction", "transaction_mode_item", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "ViewStmt", "LoadStmt", 
  "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", "opt_equal", 
  "AlterDatabaseSetStmt", "DropdbStmt", "CreateDomainStmt", 
  "AlterDomainStmt", "opt_as", "CreateConversionStmt", "ClusterStmt", 
  "VacuumStmt", "AnalyzeStmt", "analyze_keyword", "opt_verbose", 
  "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt", 
  "ExplainableStmt", "opt_analyze", "InsertStmt", "insert_rest", 
  "insert_column_list", "insert_column_item", "DeleteStmt", "LockStmt", 
  "opt_lock", "lock_type", "opt_nowait", "UpdateStmt", 
  "DeclareCursorStmt", "cursor_options", "opt_hold", "SelectStmt", 
  "select_with_parens", "select_no_parens", "select_clause", 
  "simple_select", "into_clause", "OptTempTableName", "opt_table", 
  "opt_all", "opt_distinct", "opt_sort_clause", "sort_clause", 
  "sortby_list", "sortby", "select_limit", "opt_select_limit", 
  "select_limit_value", "select_offset_value", "group_clause", 
  "having_clause", "for_update_clause", "opt_for_update_clause", 
  "update_list", "from_clause", "from_list", "table_ref", "joined_table", 
  "alias_clause", "join_type", "join_outer", "join_qual", "relation_expr", 
  "func_table", "where_clause", "TableFuncElementList", 
  "TableFuncElement", "Typename", "opt_array_bounds", "Iresult", 
  "SimpleTypename", "ConstTypename", "GenericType", "Numeric", 
  "opt_float", "opt_numeric", "opt_decimal", "Bit", "ConstBit", 
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter", 
  "CharacterWithLength", "CharacterWithoutLength", "character", 
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval", 
  "opt_timezone", "opt_interval", "a_expr", "b_expr", "c_expr", 
  "func_expr", "row", "sub_type", "all_Op", "MathOp", "qual_Op", 
  "qual_all_Op", "subquery_Op", "expr_list", "extract_list", "type_list", 
  "array_expr_list", "array_expr", "extract_arg", "overlay_list", 
  "overlay_placing", "position_list", "substr_list", "substr_from", 
  "substr_for", "trim_list", "in_expr", "case_expr", "when_clause_list", 
  "when_clause", "case_default", "case_arg", "columnref", 
  "indirection_el", "indirection", "opt_indirection", 
  "opt_empty_parentheses", "target_list", "target_el", 
  "update_target_list", "inf_col_list", "inf_val_list", 
  "update_target_el", "insert_target_list", "insert_target_el", 
  "relation_name", "qualified_name_list", "qualified_name", "name_list", 
  "name", "database_name", "access_method", "attr_name", "index_name", 
  "file_name", "func_name", "AexprConst", "Iconst", "Fconst", "Bconst", 
  "Xconst", "Sconst", "PosIntConst", "IntConst", "IntConstVar", 
  "AllConstVar", "StringConst", "PosIntStringConst", "NumConst", 
  "AllConst", "PosAllConst", "UserId", "SpecialRuleRelation", 
  "ECPGConnect", "connection_target", "db_prefix", "server", "opt_server", 
  "server_name", "opt_port", "opt_connection_name", "opt_user", 
  "ora_user", "user_name", "char_variable", "opt_options", 
  "ECPGCursorStmt", "ECPGDeallocate", "ECPGVarDeclaration", 
  "single_vt_declaration", "single_var_declaration", "@3", "@4", 
  "precision", "opt_scale", "ecpg_interval", "ECPGDeclaration", "@5", 
  "sql_startdeclare", "sql_enddeclare", "var_type_declarations", 
  "vt_declarations", "variable_declarations", "type_declaration", "@6", 
  "var_declaration", "@7", "@8", "storage_declaration", "storage_clause", 
  "storage_modifier", "var_type", "enum_type", "enum_definition", 
  "struct_union_type_with_symbol", "@9", "struct_union_type", "@10", 
  "s_struct_union_symbol", "s_struct_union", "simple_type", 
  "unsigned_type", "signed_type", "opt_signed", "variable_list", 
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare", 
  "ECPGDisconnect", "dis_name", "connection_object", "ECPGExecute", "@11", 
  "execute_rest", "execstring", "prepared_name", "ECPGFree", "ECPGOpen", 
  "opt_ecpg_using", "ecpg_using", "using_descriptor", "into_descriptor", 
  "opt_sql", "ecpg_into", "using_list", "UsingConst", "ECPGPrepare", 
  "ECPGDescribe", "opt_output", "ECPGAllocateDescr", 
  "ECPGDeallocateDescr", "ECPGGetDescriptorHeader", 
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem", 
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems", 
  "ECPGSetDescHeaderItem", "desc_header_item", "ECPGGetDescriptor", 
  "ECPGGetDescItems", "ECPGGetDescItem", "ECPGSetDescriptor", 
  "ECPGSetDescItems", "ECPGSetDescItem", "descriptor_item", 
  "ECPGSetAutocommit", "on_off", "ECPGSetConnection", "ECPGTypedef", 
  "@12", "opt_reference", "ECPGVar", "@13", "ECPGWhenever", "action", 
  "ECPGKeywords", "ECPGKeywords_vanames", "ECPGKeywords_rest", 
  "ECPGTypeName", "symbol", "ColId", "type_name", "function_name", 
  "ColLabel", "ECPGColLabelCommon", "ECPGColLabel", "ECPGCKeywords", 
  "unreserved_keyword", "ECPGunreserved_interval", "ECPGunreserved", 
  "col_name_keyword", "func_name_keyword", "reserved_keyword", 
  "into_list", "ecpgstart", "c_args", "coutputvariable", "civarind", 
  "civar", "indicator", "cvariable", "ident", "quoted_ident_stringvar", 
  "c_stuff_item", "c_stuff", "c_list", "c_term", "c_thing", "c_anything", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,    61,    60,    62,   657,    43,    45,    42,    47,
      37,    94,   658,    91,    93,    40,    41,    46,    59,   123,
     125,    44,   659,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   424,   425,   426,   426,   427,   427,   427,   427,   427,
     427,   427,   427,   428,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   429,   429,   429,   429,
     429,   429,   429,   429,   429,   429,   430,   431,   431,   432,
     432,   433,   433,   434,   435,   435,   436,   436,   436,   436,
     436,   436,   436,   436,   437,   437,   438,   438,   439,   439,
     440,   440,   441,   441,   442,   443,   443,   444,   444,   445,
     445,   446,   446,   446,   446,   446,   446,   447,   447,   447,
     448,   448,   448,   448,   448,   448,   448,   448,   449,   449,
     450,   450,   451,   451,   452,   452,   452,   452,   453,   453,
     453,   454,   454,   454,   454,   455,   455,   455,   455,   455,
     455,   456,   456,   456,   457,   457,   458,   458,   458,   458,
     458,   459,   459,   459,   459,   459,   460,   461,   461,   462,
     462,   463,   464,   464,   465,   465,   466,   466,   466,   466,
     466,   466,   466,   466,   466,   466,   466,   466,   466,   466,
     467,   467,   468,   468,   469,   469,   470,   470,   470,   471,
     471,   472,   473,   474,   474,   475,   475,   475,   476,   476,
     477,   477,   477,   477,   477,   477,   477,   477,   477,   478,
     478,   479,   479,   480,   480,   481,   481,   482,   482,   483,
     483,   483,   483,   483,   483,   483,   484,   484,   485,   485,
     486,   486,   486,   487,   488,   488,   489,   489,   489,   490,
     490,   490,   490,   490,   490,   490,   491,   491,   491,   491,
     492,   493,   493,   493,   494,   494,   495,   495,   495,   495,
     496,   496,   497,   497,   498,   499,   499,   499,   500,   500,
     500,   500,   500,   501,   502,   503,   503,   503,   503,   503,
     504,   504,   505,   505,   505,   506,   506,   506,   506,   507,
     507,   508,   508,   510,   509,   511,   511,   511,   512,   512,
     513,   513,   514,   515,   516,   517,   517,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   519,   519,   520,
     521,   521,   522,   522,   523,   523,   524,   525,   525,   526,
     527,   527,   528,   529,   529,   530,   530,   531,   531,   531,
     532,   532,   532,   533,   533,   534,   534,   535,   535,   536,
     536,   536,   537,   537,   538,   538,   539,   539,   539,   539,
     539,   540,   540,   541,   541,   542,   543,   544,   545,   545,
     545,   545,   546,   547,   548,   548,   549,   549,   550,   550,
     550,   551,   552,   552,   553,   553,   553,   553,   554,   554,
     555,   555,   556,   557,   558,   558,   558,   558,   558,   558,
     558,   558,   559,   559,   560,   560,   561,   561,   562,   563,
     563,   563,   563,   563,   563,   563,   563,   563,   563,   564,
     564,   564,   564,   564,   564,   564,   564,   564,   564,   564,
     564,   564,   564,   565,   566,   566,   567,   567,   567,   567,
     567,   567,   567,   567,   567,   567,   567,   568,   568,   568,
     568,   568,   568,   568,   568,   568,   568,   569,   569,   570,
     571,   572,   572,   572,   573,   573,   574,   574,   574,   574,
     574,   574,   574,   574,   574,   574,   574,   574,   575,   575,
     575,   575,   575,   575,   575,   576,   576,   577,   577,   578,
     578,   579,   579,   580,   580,   581,   582,   583,   583,   584,
     584,   585,   585,   586,   586,   586,   587,   587,   587,   588,
     589,   589,   590,   590,   591,   591,   592,   592,   593,   593,
     593,   593,   594,   594,   595,   596,   597,   597,   598,   598,
     599,   599,   599,   599,   599,   599,   599,   599,   599,   599,
     599,   599,   600,   600,   601,   602,   603,   603,   604,   605,
     605,   605,   605,   606,   606,   607,   607,   608,   608,   609,
     610,   610,   611,   611,   612,   612,   613,   613,   613,   613,
     613,   613,   613,   613,   613,   613,   613,   613,   613,   613,
     614,   614,   615,   615,   615,   615,   615,   615,   615,   615,
     615,   615,   617,   616,   618,   618,   618,   619,   619,   620,
     620,   620,   620,   620,   621,   621,   622,   622,   622,   622,
     623,   623,   623,   624,   625,   626,   627,   627,   628,   628,
     628,   628,   628,   628,   628,   628,   628,   628,   628,   629,
     629,   629,   630,   630,   630,   631,   631,   631,   632,   632,
     633,   634,   635,   635,   636,   636,   637,   637,   637,   637,
     637,   637,   637,   637,   637,   637,   638,   638,   639,   639,
     640,   641,   642,   642,   642,   642,   642,   643,   643,   644,
     645,   645,   645,   646,   646,   646,   647,   647,   648,   648,
     649,   649,   650,   650,   651,   651,   652,   652,   653,   654,
     654,   654,   654,   654,   655,   655,   656,   657,   657,   657,
     657,   657,   658,   658,   659,   660,   661,   662,   662,   663,
     663,   663,   663,   663,   663,   663,   663,   664,   664,   665,
     666,   667,   667,   667,   667,   667,   668,   668,   668,   669,
     669,   670,   670,   671,   671,   671,   671,   672,   672,   673,
     673,   673,   673,   674,   674,   674,   675,   675,   675,   675,
     675,   675,   675,   675,   676,   676,   677,   677,   678,   678,
     678,   678,   679,   679,   680,   681,   681,   682,   682,   682,
     682,   683,   683,   683,   683,   683,   684,   684,   685,   685,
     686,   687,   687,   688,   688,   689,   689,   690,   690,   691,
     691,   692,   692,   693,   693,   694,   694,   694,   694,   694,
     694,   694,   694,   694,   694,   694,   695,   695,   695,   695,
     695,   695,   695,   696,   696,   696,   696,   697,   697,   697,
     697,   698,   698,   699,   699,   700,   700,   700,   700,   701,
     702,   702,   703,   703,   704,   705,   705,   705,   705,   706,
     706,   706,   707,   707,   707,   707,   707,   707,   707,   707,
     707,   708,   708,   708,   708,   708,   708,   708,   708,   709,
     709,   709,   709,   709,   710,   711,   711,   711,   711,   711,
     711,   711,   711,   711,   711,   711,   712,   712,   713,   713,
     713,   714,   714,   714,   715,   715,   716,   716,   717,   718,
     719,   719,   720,   720,   721,   722,   723,   723,   723,   723,
     723,   723,   724,   724,   725,   725,   726,   726,   726,   726,
     727,   728,   728,   728,   729,   729,   729,   729,   729,   729,
     729,   729,   729,   729,   729,   729,   729,   729,   730,   730,
     730,   730,   730,   730,   730,   730,   730,   730,   730,   730,
     730,   730,   730,   730,   730,   730,   730,   730,   730,   730,
     730,   730,   730,   730,   730,   730,   730,   730,   730,   730,
     730,   730,   730,   730,   730,   730,   730,   730,   730,   730,
     730,   730,   730,   730,   730,   730,   730,   730,   730,   730,
     730,   730,   730,   730,   731,   731,   731,   731,   731,   731,
     731,   731,   731,   731,   731,   731,   731,   731,   731,   731,
     731,   731,   731,   731,   731,   731,   732,   732,   732,   732,
     732,   732,   732,   732,   732,   732,   732,   733,   733,   733,
     733,   733,   733,   733,   733,   733,   733,   733,   733,   733,
     733,   733,   733,   733,   733,   733,   733,   733,   733,   733,
     733,   733,   733,   733,   734,   734,   734,   735,   735,   735,
     736,   736,   737,   737,   737,   737,   737,   737,   737,   737,
     737,   738,   738,   739,   739,   740,   740,   740,   740,   740,
     740,   741,   741,   742,   742,   743,   743,   744,   744,   745,
     745,   746,   746,   746,   746,   746,   746,   746,   746,   747,
     747,   748,   749,   749,   750,   750,   750,   750,   750,   750,
     751,   752,   753,   753,   753,   754,   754,   755,   756,   756,
     757,   758,   758,   759,   759,   760,   760,   761,   761,   761,
     761,   762,   762,   763,   763,   764,   764,   765,   765,   766,
     766,   766,   767,   767,   767,   768,   768,   769,   769,   770,
     770,   771,   771,   772,   772,   773,   773,   774,   774,   775,
     775,   776,   776,   777,   778,   779,   780,   781,   782,   783,
     783,   784,   784,   784,   784,   784,   784,   784,   784,   785,
     786,   787,   788,   789,   790,   790,   791,   791,   792,   792,
     793,   793,   793,   793,   793,   794,   794,   795,   795,   795,
     796,   796,   796,   796,   796,   797,   797,   798,   798,   798,
     798,   798,   798,   799,   800,   800,   801,   801,   801,   801,
     802,   802,   802,   803,   804,   805,   805,   806,   806,   806,
     807,   807,   808,   808,   809,   809,   810,   810,   810,   810,
     811,   811,   812,   813,   813,   814,   815,   815,   816,   817,
     817,   819,   818,   820,   818,   818,   821,   822,   822,   823,
     823,   823,   823,   823,   825,   824,   826,   827,   828,   828,
     829,   829,   829,   829,   830,   830,   832,   831,   834,   833,
     835,   833,   833,   836,   836,   836,   837,   837,   837,   837,
     838,   838,   839,   839,   839,   839,   839,   839,   840,   840,
     840,   841,   843,   842,   844,   845,   844,   846,   846,   847,
     847,   848,   848,   849,   849,   849,   849,   849,   849,   849,
     849,   849,   850,   850,   850,   850,   850,   850,   850,   850,
     850,   850,   851,   851,   852,   852,   853,   854,   854,   855,
     855,   855,   856,   857,   858,   858,   858,   858,   859,   859,
     860,   861,   860,   862,   862,   862,   862,   862,   863,   863,
     864,   864,   865,   866,   867,   867,   868,   868,   869,   870,
     871,   871,   872,   872,   873,   873,   874,   874,   875,   876,
     876,   876,   877,   877,   878,   879,   880,   881,   881,   882,
     883,   884,   884,   885,   886,   887,   888,   888,   889,   890,
     891,   891,   892,   893,   893,   893,   893,   893,   893,   893,
     893,   893,   893,   893,   893,   893,   893,   893,   894,   894,
     895,   895,   896,   896,   896,   898,   897,   899,   899,   901,
     900,   902,   902,   902,   903,   903,   903,   903,   903,   903,
     903,   903,   903,   904,   904,   905,   905,   905,   905,   905,
     905,   905,   905,   905,   905,   905,   905,   905,   905,   905,
     905,   905,   905,   905,   905,   905,   905,   905,   905,   905,
     905,   905,   906,   906,   906,   906,   906,   906,   907,   907,
     907,   907,   907,   907,   907,   908,   909,   909,   909,   909,
     909,   909,   910,   910,   910,   910,   910,   911,   911,   911,
     911,   911,   912,   912,   912,   912,   912,   912,   912,   912,
     912,   913,   913,   913,   913,   914,   914,   914,   914,   915,
     915,   915,   915,   915,   915,   915,   916,   916,   917,   917,
     917,   917,   917,   917,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   919,   919,
     919,   919,   919,   919,   919,   919,   919,   919,   919,   919,
     919,   919,   919,   919,   919,   919,   919,   919,   919,   919,
     919,   919,   919,   919,   919,   919,   919,   919,   919,   919,
     920,   920,   920,   920,   920,   920,   920,   920,   920,   920,
     920,   920,   920,   920,   920,   920,   920,   920,   920,   920,
     921,   921,   921,   921,   921,   921,   921,   921,   921,   921,
     921,   921,   921,   921,   921,   921,   921,   921,   921,   921,
     921,   921,   921,   921,   921,   921,   921,   921,   921,   921,
     921,   921,   921,   921,   921,   921,   921,   921,   921,   921,
     921,   921,   921,   921,   921,   921,   921,   921,   921,   921,
     921,   921,   921,   921,   921,   921,   921,   921,   921,   921,
     921,   921,   921,   921,   921,   922,   922,   923,   924,   924,
     925,   925,   926,   927,   928,   928,   928,   929,   930,   930,
     931,   931,   932,   932,   932,   933,   933,   934,   934,   935,
     935,   936,   936,   936,   936,   936,   937,   937,   937,   937,
     937,   937,   937,   937,   937,   937,   937,   937,   937,   937,
     937,   937,   937,   937,   937,   937,   937,   937,   937,   937,
     937,   937,   937,   937,   937,   937,   937,   937,   937,   937,
     937,   937,   937,   937,   937,   937,   937,   937,   937,   937,
     937,   937,   937,   937,   937,   937,   937,   937,   937,   937,
     937,   937
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     0,     2,     4,     3,     2,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     5,     1,     0,     4,
       5,     5,     4,     3,     2,     0,     2,     2,     1,     1,
       1,     1,     3,     3,     3,     1,     4,     5,     2,     0,
       2,     2,     6,     6,     3,     6,     4,     1,     0,     2,
       0,     1,     1,     1,     1,     1,     1,     2,     3,     3,
       3,     3,     3,     2,     5,     2,     3,     3,     1,     3,
       1,     1,     1,     3,     2,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     6,     1,
       1,     1,     1,     0,     1,     1,     2,     3,     4,     3,
       2,     2,     3,     4,     3,     2,     4,     1,     1,     1,
       1,     1,     4,     4,     1,     3,     3,     4,     6,     6,
       6,     6,     4,     6,     2,     4,     3,     3,     3,     3,
       1,     3,     3,     3,     3,     2,     1,     1,     0,     2,
       0,     2,     9,     1,     1,     1,     1,     1,     2,     0,
       1,     1,     3,     3,     1,     3,     3,     3,     4,     1,
       0,     2,     0,     3,     0,     1,     0,    11,    12,     1,
       1,     2,     2,     2,     2,     0,     1,     0,     1,     3,
       1,     1,     1,     3,     2,     0,     3,     1,     1,     2,
       1,     2,     3,     4,     2,     5,     1,     2,     2,     2,
       3,     2,     2,     0,     3,     1,     4,     5,     6,    11,
       3,     0,     3,     1,     1,     2,     2,     0,     1,     1,
       2,     2,     0,     3,     3,     2,     1,     1,     2,     2,
       4,     0,     2,     2,     0,     3,     4,     4,     0,     2,
       0,     4,     0,     0,     8,     3,     3,     1,     3,     0,
       3,     1,     1,     5,     4,     2,     0,     2,     1,     2,
       3,     2,     2,     2,     2,     3,     3,     1,     0,     8,
       1,     0,     1,     2,     2,     0,     5,     1,     0,     6,
       2,     0,     3,    14,    19,     1,     1,     1,     3,     5,
       1,     1,     1,     3,     0,     1,     0,     1,     1,     1,
       3,     0,     1,     1,     0,     2,     1,     2,     1,     2,
       0,     2,     1,     2,     2,     6,     8,     3,     4,     4,
       4,     5,     3,     3,     1,     3,     3,     1,     1,     1,
       1,    12,     1,     3,     4,     7,     4,     2,     1,     0,
       1,     0,     7,     4,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     1,     2,     2,     3,     3,     5,
       4,     4,     3,     4,     3,     3,     2,     4,     2,     1,
       1,     1,     1,     2,     2,     1,     1,     1,     2,     2,
       1,     2,     2,     1,     1,     1,     6,     9,     7,     9,
       8,     8,     6,     9,     7,    10,     7,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     7,
       8,     2,     1,     1,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     2,     2,     2,     2,     1,     3,     1,     2,     3,
       0,     3,     0,     1,     3,     2,    12,     1,     0,     2,
       0,     1,     3,     2,     2,     4,     1,     2,     0,     9,
       2,     0,     3,     2,     1,     3,     3,     2,     1,     1,
       1,     0,     1,     3,     1,     1,     1,     4,     1,     2,
       2,     2,     1,     1,     1,     4,     5,     1,     3,     3,
       2,     2,     2,     0,     5,     7,     1,     1,     7,     1,
       3,     3,     3,     1,     3,    11,    10,     2,     0,     8,
       4,     4,     1,     1,     1,     0,     9,     6,     6,     7,
       6,     6,     9,     6,     6,     6,     8,     8,     6,     6,
       1,     0,     9,     6,     6,     6,     7,     9,     9,     6,
       6,     6,     0,    14,     1,     1,     3,     3,     1,     1,
       1,     1,     1,     1,     1,     0,     1,     1,     1,     1,
       1,     1,     0,     6,     2,     2,     2,     2,     2,     3,
       3,     2,     2,     2,     2,     3,     2,     5,     4,     1,
       1,     0,     3,     2,     2,     1,     3,     2,     1,     0,
       7,     2,     5,     3,     1,     2,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     1,     0,     5,     4,
       3,     6,     4,     6,     6,     5,     7,     1,     0,    10,
       4,     2,     1,     4,     5,     5,     2,     4,     1,     1,
       1,     0,     1,     0,     1,     0,     3,     0,     4,     1,
       1,     1,     1,     1,     1,     0,     4,     4,     2,     1,
       7,     4,     3,     1,     2,     4,     5,     3,     0,     2,
       2,     2,     3,     1,     3,     1,     2,     1,     0,     6,
       7,     0,     2,     2,     2,     3,     0,     2,     2,     1,
       1,     3,     3,     1,     2,     4,     4,     1,     1,     8,
       4,     4,     4,     2,     1,     0,     3,     3,     4,     4,
       4,     4,     2,     1,     1,     0,     1,     0,     1,     5,
       1,     0,     1,     0,     3,     1,     3,     3,     2,     2,
       1,     4,     4,     2,     2,     4,     1,     0,     1,     1,
       1,     3,     0,     2,     0,     3,     3,     1,     0,     2,
       0,     2,     0,     3,     1,     1,     2,     1,     2,     5,
       6,     5,     1,     2,     1,     4,     3,     4,     3,     5,
       4,     5,     4,     5,     2,     4,     1,     2,     2,     2,
       1,     1,     0,     4,     2,     1,     2,     2,     4,     1,
       2,     0,     1,     3,     2,     2,     3,     5,     6,     3,
       4,     0,     1,     3,     3,     3,     3,     3,     3,     1,
       1,     1,     1,     1,     1,     1,     2,     5,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     2,     2,     2,     2,     1,     3,     0,     5,     3,
       0,     5,     3,     0,     1,     1,     1,     1,     5,     2,
       1,     1,     1,     1,     5,     2,     2,     2,     1,     3,
       3,     2,     1,     0,     3,     0,     5,     2,     5,     2,
       1,     3,     3,     0,     1,     1,     1,     1,     1,     1,
       3,     3,     3,     3,     3,     3,     3,     0,     1,     3,
       5,     2,     2,     2,     2,     2,     2,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     2,     2,     3,
       3,     2,     3,     5,     4,     6,     3,     5,     4,     6,
       4,     6,     5,     7,     2,     3,     2,     4,     3,     4,
       3,     4,     3,     4,     5,     6,     7,     5,     6,     3,
       4,     4,     6,     2,     1,     3,     2,     2,     2,     2,
       2,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     2,     2,     5,     6,     7,     1,     1,     2,     4,
       1,     1,     1,     2,     2,     2,     1,     3,     4,     5,
       5,     4,     1,     2,     4,     2,     4,     2,     2,     2,
       6,     4,     4,     4,     4,     6,     5,     5,     5,     4,
       6,     4,     6,     4,     4,     3,     5,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     4,     1,     4,     1,     4,     1,     2,     1,
       2,     1,     3,     3,     0,     3,     1,     1,     3,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     4,
       3,     2,     3,     0,     3,     3,     2,     2,     1,     0,
       2,     2,     3,     2,     1,     1,     3,     5,     2,     1,
       4,     2,     0,     1,     0,     1,     2,     2,     2,     3,
       5,     1,     2,     0,     2,     2,     0,     3,     1,     3,
       1,     1,     3,     7,     1,     2,     4,     1,     3,     4,
       4,     3,     1,     1,     1,     1,     1,     1,     3,     1,
       2,     1,     3,     1,     1,     1,     1,     1,     1,     1,
       2,     1,     2,     3,     6,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     1,     1,
       1,     1,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     5,     3,     2,     2,
       3,     7,     1,     2,     2,     1,     0,     1,     3,     1,
       2,     0,     2,     0,     2,     0,     1,     3,     4,     3,
       1,     1,     1,     2,     0,     7,     3,     2,     1,     1,
       1,     0,     5,     0,     4,     2,     1,     2,     0,     1,
       3,     3,     3,     3,     0,     4,     5,     5,     0,     1,
       1,     1,     2,     2,     1,     2,     0,     7,     0,     5,
       0,     4,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     5,     2,     1,     3,     2,
       2,     3,     0,     5,     1,     0,     5,     2,     2,     1,
       1,     1,     2,     2,     3,     1,     2,     2,     3,     3,
       4,     2,     1,     2,     1,     1,     2,     2,     3,     1,
       1,     1,     1,     0,     1,     3,     4,     0,     2,     0,
       1,     2,     3,     2,     1,     1,     1,     0,     1,     1,
       3,     0,     4,     2,     2,     1,     1,     0,     1,     1,
       1,     1,     2,     3,     0,     1,     2,     1,     4,     4,
       0,     1,     2,     1,     1,     3,     1,     1,     4,     4,
       4,     4,     1,     0,     3,     3,     4,     1,     3,     3,
       4,     1,     3,     3,     1,     6,     1,     3,     3,     6,
       1,     3,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     4,     4,
       1,     1,     4,     4,     3,     0,     7,     1,     0,     0,
       7,     3,     4,     3,     1,     1,     1,     2,     3,     5,
       2,     5,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     3,     1,     0,     1,
       2,     1,     2,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     2,     3,     1,     2,     1,     3,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
       3,     0,     2,     1,  1921,  1922,  1925,  1929,  1930,  1857,
    1931,  1932,  1897,  1898,  1899,  1900,  1901,  1902,  1903,  1904,
    1905,  1906,  1907,  1908,  1910,  1909,  1911,  1912,  1913,  1914,
    1915,  1916,  1917,  1918,  1920,  1919,  1934,  1935,  1923,  1924,
    1926,  1927,  1896,  1928,  1936,  1937,  1938,  1933,  1886,  1213,
    1887,    10,  1209,  1210,  1941,  1892,  1893,  1891,  1894,  1895,
    1939,  1940,  1882,  1883,  1885,    11,    12,  1884,     4,  1888,
    1889,  1890,     8,  1294,  1363,     9,  1881,  1363,     0,  1475,
    1476,  1477,     0,  1478,  1479,  1480,  1481,  1482,  1413,  1377,
       0,  1483,     0,  1484,  1485,  1486,  1487,  1488,  1489,  1490,
    1491,  1492,     0,  1493,  1494,  1495,  1496,  1362,  1497,  1498,
    1499,  1500,  1339,  1345,  1501,  1459,     0,  1319,  1320,  1316,
    1318,  1317,  1321,  1306,   671,     0,   719,   718,     0,  1770,
     671,  1771,  1738,  1772,  1739,  1740,   201,     0,   712,  1741,
       0,   671,  1742,   250,   551,  1773,     0,     0,  1743,  1744,
       0,     0,   368,   671,     0,  1745,   735,  1746,     0,  1747,
    1774,  1775,     0,     0,  1776,  1777,  1748,     0,  1749,  1750,
    1778,  1779,  1780,  1781,  1782,     0,     0,   795,     0,  1751,
    1783,  1752,  1753,     0,  1784,  1754,  1755,  1756,  1785,  1786,
    1757,  1758,  1759,     0,  1760,     0,     0,     0,   532,  1787,
     671,  1761,     0,   801,     0,  1762,     0,  1788,  1763,     0,
    1764,  1765,  1766,  1767,  1768,   795,  1455,  1340,     0,     0,
     723,  1769,  1789,  1868,  1869,     0,     0,     0,    43,    21,
      20,    57,    35,    16,    50,    38,    81,    82,    83,    27,
      23,    19,    24,    28,    40,    29,    39,    18,    36,    52,
      42,    55,    41,    56,    30,    48,    46,    37,    51,    54,
      77,    60,    26,    61,    73,    62,    34,    71,    69,    70,
      31,    49,    68,    72,    17,    74,    53,    67,    64,    78,
      76,    84,    65,    44,    14,    58,    33,    15,    32,    25,
      80,    22,   721,    59,    63,    47,    66,    79,    45,    75,
     778,   769,   803,   777,    86,    87,    88,     7,  1278,  1280,
    1279,  1363,  1314,  1315,  1283,  1324,  1334,  1323,  1327,  1335,
    1322,  1341,     0,    90,    92,    93,    94,    97,    98,    91,
      85,    89,    96,   102,    95,   101,    99,   100,   103,   104,
     105,  1544,   967,  1542,  1543,  1541,     0,  1363,  1301,  1300,
    1363,  1310,  1334,     0,  1502,  1503,  1504,  1505,  1506,  1507,
    1549,  1550,  1551,  1552,  1553,  1555,  1554,  1564,  1565,  1566,
    1567,  1568,  1569,  1570,  1571,  1572,  1573,  1574,  1575,  1576,
    1577,  1578,  1579,  1580,  1581,  1582,  1521,  1583,  1584,  1585,
    1586,  1587,  1588,  1589,  1590,  1591,  1592,  1593,  1594,  1595,
    1596,  1597,  1598,  1599,  1558,  1600,  1601,  1602,  1603,  1604,
    1605,  1606,  1607,  1608,  1609,  1610,  1611,  1612,  1613,  1615,
    1614,  1616,  1617,  1618,  1619,  1620,  1621,  1622,  1623,  1624,
    1625,  1559,  1626,  1627,  1628,  1629,  1630,  1631,  1632,  1633,
    1634,  1635,  1636,  1637,  1638,  1639,  1640,  1641,  1642,  1643,
    1644,  1645,  1646,  1647,  1648,  1649,  1560,  1650,  1651,  1561,
    1652,  1653,  1654,  1655,  1656,  1657,  1658,  1659,  1660,  1661,
    1662,  1663,  1664,  1665,  1666,  1667,  1668,  1670,  1669,  1671,
    1672,  1673,  1674,  1675,  1676,  1677,  1678,  1679,  1680,  1681,
    1682,  1683,  1684,  1685,  1686,  1687,  1688,  1689,  1690,  1691,
    1692,  1693,  1694,  1562,  1695,  1696,  1697,  1698,  1699,  1700,
    1701,  1702,  1703,  1704,  1705,  1706,  1707,  1708,  1709,  1710,
    1711,  1712,  1713,  1714,     0,  1715,  1716,  1717,  1718,  1719,
    1720,  1721,  1722,  1723,  1724,  1725,  1726,  1727,  1728,  1729,
    1730,  1731,  1732,  1733,  1734,  1735,  1736,  1563,  1737,  1867,
    1225,  1271,  1270,  1248,  1266,  1519,  1473,  1474,  1243,  1520,
    1517,  1556,  1557,  1518,  1226,  1863,  1516,  1412,     0,     0,
    1375,  1376,  1379,  1256,  1378,     0,  1252,  1373,  1374,  1194,
    1272,  1516,  1508,  1509,  1510,  1511,  1513,  1512,  1514,  1790,
    1791,  1792,  1793,  1794,  1795,  1796,  1797,  1798,  1799,  1800,
    1534,  1801,  1802,  1803,  1804,  1805,  1806,  1807,  1808,  1809,
    1810,  1811,  1812,  1813,  1814,  1815,  1816,  1817,  1818,  1819,
    1820,  1821,  1822,  1823,  1824,  1825,  1826,  1535,  1536,  1827,
    1828,  1829,  1830,  1831,  1832,  1833,  1834,  1835,  1836,  1837,
    1838,  1839,  1840,  1841,  1842,  1843,  1844,  1845,  1846,  1847,
    1538,  1848,  1849,  1537,  1850,  1851,  1852,  1853,  1854,     0,
    1329,  1548,  1533,  1330,  1515,  1545,  1532,  1539,  1540,  1547,
    1546,  1392,  1193,  1394,  1337,  1347,  1343,  1351,  1346,     0,
       0,     0,     0,  1363,   670,   669,   658,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    13,     0,   679,   231,  1245,  1244,  1189,
     711,     0,  1185,  1186,   368,   661,   249,     0,     0,     0,
       0,     0,     0,   428,     0,     0,     0,     0,     0,     0,
     138,     0,   260,   259,     0,   360,     0,   537,     0,     0,
     368,     0,     0,     0,  1249,     0,  1669,  1390,  1391,  1277,
    1704,   761,     0,     0,     0,     0,   440,     0,   439,     0,
       0,   437,     0,   367,     0,   441,   435,   434,     0,     0,
     438,     0,   436,     0,     0,   662,  1626,  1381,   734,   721,
    1565,   466,   470,   461,   467,   475,   474,   462,   459,   460,
    1679,     0,     0,   465,     0,   456,  1214,  1216,   473,  1215,
       0,   502,   515,   509,   513,   507,   511,   510,   506,   517,
     516,   512,   508,   514,     0,   503,   504,     0,   655,  1186,
     681,  1198,   794,     0,     0,   458,   654,     0,     0,   602,
     603,     0,  1692,   666,   195,  1697,  1765,  1716,   191,     0,
       0,   663,   664,   800,   798,     0,     0,     0,     0,  1591,
    1645,  1653,  1697,  1765,  1716,   147,     0,   158,   190,  1697,
    1765,  1716,   186,   679,     0,     0,  1338,   657,   656,     0,
       0,   865,   722,   725,   778,     0,   671,     0,     6,   720,
     716,   797,   797,     0,   797,     0,   774,  1281,  1334,  1313,
    1369,  1285,     0,     0,  1359,  1355,  1352,  1360,  1361,  1354,
    1342,   956,   957,   958,   955,   959,   954,     0,  1289,  1326,
    1295,     0,  1303,  1302,  1308,  1369,  1312,  1870,  1871,  1414,
    1247,  1263,     0,     0,     0,     0,     0,     0,  1255,  1261,
       0,  1253,     0,     0,  1875,  1879,     0,  1877,  1872,  1328,
    1400,  1393,  1395,  1397,  1349,  1348,  1344,     0,     0,  1464,
       0,     0,  1465,  1466,     0,  1461,  1463,     0,  1369,     0,
       0,  1519,  1199,  1520,  1517,  1529,  1516,     0,   444,     0,
       0,     0,   444,     0,     0,     0,     0,  1585,  1090,  1100,
    1098,  1099,  1092,  1093,  1094,  1097,  1095,  1096,     0,   593,
    1091,     0,     0,   346,     0,     0,     0,     0,   115,     0,
       0,     0,   675,   678,   659,     0,     0,  1161,  1190,     0,
       0,     0,   487,   496,   488,   493,     0,   490,     0,     0,
       0,   489,   491,   492,     0,   494,   495,     0,     0,   252,
       0,     0,     0,     0,   683,   708,   264,   263,   129,   262,
     261,     0,     0,   550,     0,   140,   371,     0,     0,   108,
       0,     0,     0,     0,     0,     0,     0,     0,  1415,  1276,
    1372,     0,   871,     0,   407,     0,   700,     0,   134,     0,
       0,     0,   372,     0,   113,   125,     0,   228,   442,  1389,
    1388,  1380,  1387,     0,   463,   472,   471,   469,   468,   464,
    1217,     0,   454,   455,  1400,  1403,   452,     0,   501,     0,
       0,     0,   748,  1187,     0,     0,   605,   605,   665,   194,
     192,     0,     0,     0,     0,     0,     0,  1738,  1739,   915,
    1154,     0,  1521,  1740,  1741,  1742,  1062,  1166,  1166,  1166,
    1743,  1744,  1608,  1745,  1746,  1206,  1747,   905,  1749,  1750,
    1751,  1752,     0,  1207,  1754,  1755,  1664,  1757,  1758,  1760,
    1761,  1166,  1763,  1764,  1765,  1766,  1767,  1768,  1205,     0,
    1166,  1769,  1101,  1211,  1212,  1163,     0,     0,  1171,     0,
       0,     0,  1052,     0,   899,   901,   902,   926,   927,   903,
     932,   933,   945,   900,     0,  1170,   968,  1051,  1056,     0,
    1050,  1046,   785,  1168,  1155,     0,  1047,  1239,  1238,  1240,
    1241,  1237,  1201,  1519,  1525,   904,  1520,  1517,  1208,  1242,
    1863,  1516,     0,     0,     0,     0,  1454,     0,   197,     0,
     198,  1191,  1697,   148,   182,   155,   181,     0,  1583,   149,
       0,   153,     0,     0,     0,   189,   187,     0,   660,   448,
       0,     0,   867,     0,   866,   724,   721,   772,   771,     5,
     727,   796,     0,     0,     0,     0,     0,     0,     0,   828,
     817,  1369,  1370,     0,  1364,     0,  1363,  1363,  1357,  1356,
    1353,     0,     0,     0,     0,     0,     0,  1231,  1230,  1286,
    1288,  1234,     0,  1369,     0,     0,  1265,     0,  1269,  1267,
    1400,  1409,  1400,  1410,  1411,  1259,  1254,  1257,     0,  1250,
    1261,  1873,     0,     0,  1876,  1331,     0,  1401,  1235,  1236,
    1406,     0,  1396,  1404,  1407,  1350,  1363,  1472,     0,  1467,
    1470,     0,  1462,     0,  1200,     0,     0,     0,     0,   445,
       0,     0,     0,   699,     0,     0,     0,   702,     0,   561,
       0,     0,     0,     0,     0,     0,     0,   203,   220,     0,
       0,     0,     0,     0,     0,   344,   621,   621,     0,     0,
     621,   621,     0,   202,   204,     0,     0,     0,     0,     0,
       0,   115,   109,   112,  1296,     0,   673,   674,     0,   677,
       0,  1158,  1157,  1196,  1162,   710,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   408,
       0,   908,   943,   943,   943,   923,   923,   917,   906,   950,
       0,   943,   920,   909,     0,   907,   953,   953,   938,     0,
     881,   891,   893,   894,   924,   925,   895,   930,   931,   892,
     967,  1524,   904,  1526,  1523,  1522,     0,     0,   707,     0,
     129,   126,   429,   409,     0,   136,     0,     0,   376,   375,
       0,     0,   410,   107,   115,   346,   339,     0,     0,     0,
    1197,     0,     0,   301,   762,   766,   763,     0,   764,     0,
     745,     0,     0,   228,     0,     0,     0,     0,     0,   228,
     226,   227,     0,   433,  1382,  1385,  1386,     0,   728,   730,
     732,   731,   733,   729,   453,   450,   451,     0,  1402,  1855,
    1861,     0,  1416,  1417,     0,  1599,  1622,  1639,  1693,     0,
    1711,     0,   518,   505,     0,     0,     0,   736,   739,     0,
       0,   758,   457,  1408,   604,   601,   600,   193,   531,     0,
    1692,   668,     0,     0,  1054,  1055,   942,   929,  1153,     0,
       0,   937,   936,     0,     0,     0,  1063,     0,  1065,     0,
    1067,     0,   913,   912,   911,  1053,  1114,     0,   910,   943,
     943,   941,   991,     0,     0,   914,     0,     0,  1133,     0,
    1068,  1139,     0,     0,     0,   949,     0,   947,     0,     0,
    1023,  1069,  1048,   971,   972,   973,   974,  1052,  1111,     0,
    1202,     0,     0,   935,     0,   967,     0,     0,     0,     0,
       0,  1109,     0,     0,  1004,  1107,     0,  1006,     0,     0,
       0,  1101,  1100,  1098,  1099,  1092,  1093,  1094,  1097,   975,
     976,  1105,   988,     0,   987,  1400,     0,   832,   784,  1156,
       0,     0,  1862,  1864,  1451,  1450,  1449,  1448,  1452,  1453,
    1424,     0,  1420,  1421,     0,   199,   200,   196,     0,     0,
     157,   156,   185,   184,     0,   179,   180,   152,     0,   175,
     176,   161,   172,   174,   173,   171,   150,   160,   162,   168,
     169,   170,   159,   151,   188,  1363,     0,     0,   832,  1174,
    1163,   713,     0,   717,   778,   782,   777,   781,   804,   805,
     810,   780,     0,   830,   819,   813,   818,   814,   820,   827,
     776,   816,   775,     0,  1371,  1284,  1369,   881,  1363,  1304,
    1363,  1358,  1292,   961,   962,   963,   964,   966,   965,  1293,
    1290,   960,  1291,  1233,  1232,     0,     0,     0,     0,  1311,
    1262,     0,  1246,  1268,     0,  1260,     0,  1874,  1880,  1878,
       0,     0,   881,  1858,  1468,  1858,   881,   587,     0,   586,
       0,     0,   446,     0,     0,     0,   698,     0,     0,     0,
       0,     0,   705,   295,     0,   225,     0,     0,     0,     0,
     558,   560,   559,   553,     0,   554,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     589,   594,     0,     0,     0,   348,   358,     0,     0,     0,
     108,   108,   345,   620,   214,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     111,   110,   118,   120,     0,   119,   121,     0,     0,     0,
     114,     0,     0,   167,   672,   676,  1159,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   251,
     234,   233,     0,     0,   414,   417,     0,   881,     0,     0,
       0,   875,   956,   955,   954,     0,   896,   898,     0,   697,
     697,   697,   697,   697,   682,   684,   275,   127,     0,     0,
     128,     0,   140,   265,   139,   141,   143,   144,   145,   142,
     146,   370,     0,   381,   380,   382,     0,   377,     0,   411,
     106,   343,     0,   267,     0,     0,     0,     0,     0,   632,
       0,     0,     0,     0,     0,   765,   870,     0,     0,   584,
       0,     0,   228,   228,   124,   366,   443,  1383,  1384,   761,
     449,     0,     0,  1860,  1218,     0,  1219,     0,     0,   521,
     520,   533,     0,   522,   523,   519,   524,     0,   738,     0,
       0,   743,  1163,     0,   755,     0,   753,     0,  1188,   757,
     746,     0,   667,  1111,     0,     0,     0,  1117,     0,     0,
    1152,  1149,     0,     0,  1111,     0,  1165,     0,     0,     0,
    1124,  1125,  1126,  1123,  1127,  1122,     0,     0,  1128,  1121,
       0,   940,   939,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1024,     0,     0,  1085,     0,  1111,  1138,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1111,
    1144,     0,  1164,  1163,     0,     0,     0,     0,  1203,   969,
     989,  1169,     0,     0,   996,     0,  1145,  1019,     0,  1010,
       0,  1005,     0,  1008,  1012,   992,     0,  1110,     0,  1108,
       0,     0,   990,     0,   985,   983,   984,   977,   978,   979,
     980,   981,   982,   986,  1089,  1087,  1088,     0,  1623,  1645,
       0,   795,   795,   783,   793,  1167,     0,   871,     0,     0,
       0,  1057,     0,  1866,  1865,     0,     0,     0,  1192,     0,
       0,   967,     0,   881,   868,     0,  1163,     0,   871,     0,
     715,   714,     0,     0,   808,   809,     0,   826,     0,   825,
       0,     0,     0,  1282,  1365,  1367,  1333,  1305,  1336,  1287,
    1325,     0,  1309,  1264,  1258,     0,  1398,  1405,  1458,     0,
    1859,     0,     0,     0,   623,   607,   447,   624,   608,     0,
       0,     0,     0,     0,   228,   703,   224,   704,   625,   552,
     561,     0,   557,   566,  1530,   904,   564,  1531,  1528,  1527,
       0,     0,   132,   133,   610,   222,   615,   223,   221,   611,
       0,  1195,     0,     0,     0,   629,   613,   347,   357,     0,
     351,   352,   349,   353,   354,     0,     0,   206,     0,     0,
     218,   217,   228,   228,   614,     0,   219,   216,   205,   631,
     619,     0,   630,   618,     0,   116,   117,     0,   165,   164,
     166,     0,     0,     0,     0,     0,     0,     0,   498,   482,
     497,     0,     0,     0,   476,   236,   237,   254,   235,   413,
       0,     0,     0,     0,   876,     0,     0,   881,     0,     0,
     889,   882,   890,     0,     0,     0,     0,   696,     0,     0,
       0,     0,     0,   685,   701,   131,   130,     0,   135,     0,
       0,   369,     0,     0,     0,   872,     0,     0,     0,     0,
     266,   268,   270,   271,   272,     0,   341,   342,   337,     0,
       0,   333,     0,     0,   540,     0,     0,     0,   303,   304,
       0,   767,   768,     0,   228,     0,   228,   228,   653,   405,
       0,  1399,  1856,  1425,  1426,     0,  1418,  1419,     0,   535,
       0,   530,   525,   527,  1184,  1183,     0,  1182,     0,     0,
     744,   756,   749,   751,   750,     0,     0,   747,     0,   799,
       0,  1119,  1120,     0,     0,     0,     0,  1148,     0,     0,
    1083,     0,  1081,  1064,  1066,   922,     0,  1071,     0,   916,
       0,   919,     0,  1102,     0,     0,  1072,  1026,  1027,  1028,
       0,     0,     0,     0,  1101,     0,     0,     0,     0,     0,
       0,     0,  1029,  1030,  1042,  1041,  1073,  1084,     0,     0,
    1136,  1137,  1074,   951,   952,   953,   953,     0,     0,  1143,
       0,     0,     0,  1079,  1049,  1112,   944,   945,     0,     0,
       0,     0,     0,     0,  1011,  1007,     0,  1009,  1013,     0,
       0,     0,   998,  1020,   994,     0,     0,  1000,     0,  1021,
     795,   795,   795,   795,   792,     0,     0,     0,   842,   831,
     834,   844,   835,   837,   869,  1189,   822,     0,     0,  1061,
    1058,  1433,  1434,  1435,  1436,  1437,  1438,  1439,  1440,  1441,
    1442,  1444,  1445,  1446,  1443,  1447,  1429,  1430,     0,  1422,
    1423,   154,     0,   177,   163,  1458,     0,  1175,  1172,   759,
       0,   726,   806,     0,  1103,   807,   829,   811,   815,   812,
       0,  1366,  1297,  1274,  1457,  1460,  1471,  1469,  1307,     0,
       0,     0,   294,     0,     0,     0,   706,   555,   556,   898,
     626,   609,     0,     0,   591,     0,   592,   590,   350,   356,
     355,   275,     0,     0,     0,   207,   215,   212,     0,     0,
     122,   123,  1160,     0,     0,   478,   484,     0,     0,     0,
       0,   486,   255,   108,     0,   415,  1664,  1093,   416,   418,
     565,   419,   420,   400,     0,     0,     0,   879,     0,     0,
       0,     0,     0,     0,   881,   967,     0,   693,  1227,  1228,
     692,  1229,   689,   688,   695,   694,   687,   686,   691,   690,
       0,     0,     0,   286,     0,     0,   280,     0,     0,   332,
     274,   277,   278,     0,     0,   384,   378,   412,     0,   874,
     267,   293,   321,     0,   338,     0,     0,     0,     0,   365,
     362,     0,     0,     0,     0,     0,   300,     0,   680,   760,
    1275,   585,   228,   432,   588,   766,     0,     0,   534,   528,
       0,     0,   499,   737,     0,     0,   741,   742,   754,   752,
     228,  1112,  1118,   928,     0,  1151,  1147,     0,     0,     0,
    1113,     0,     0,  1131,  1130,  1025,  1132,     0,     0,     0,
    1040,  1039,  1037,  1038,  1031,  1032,  1033,  1034,  1035,  1036,
    1141,  1140,  1134,  1135,   948,   946,     0,  1076,  1077,  1078,
    1142,  1086,   934,   967,   970,  1017,   997,  1146,  1014,     0,
    1116,     0,   993,     0,     0,     0,  1002,  1102,     0,     0,
       0,     0,     0,     0,   787,   786,   842,     0,   844,     0,
     843,   856,     0,     0,   862,   860,     0,   862,     0,   862,
       0,     0,   836,     0,   838,   856,  1190,     0,   824,  1059,
    1060,     0,     0,     0,  1456,     0,     0,  1180,  1179,     0,
    1368,     0,  1251,     0,     0,   296,     0,     0,   332,     0,
       0,     0,     0,   273,     0,     0,     0,     0,   230,   616,
     617,     0,     0,     0,     0,   481,   480,   239,     0,   402,
       0,     0,   406,   396,   398,     0,     0,     0,   877,   883,
     884,   885,   886,   887,   888,   880,   897,   394,     0,     0,
     284,   288,   289,   287,   279,   332,   301,     0,   281,     0,
       0,   386,     0,     0,   873,     0,     0,     0,   290,     0,
     324,   269,   340,   342,   335,   336,   334,     0,   359,   363,
       0,   539,     0,     0,     0,     0,   572,     0,     0,     0,
     573,   577,   574,   583,   568,   648,   649,   646,   647,     0,
     302,   599,     0,  1427,  1428,     0,   526,  1181,     0,   500,
    1150,  1070,  1080,   921,  1082,   918,  1129,     0,     0,     0,
    1075,  1204,     0,  1015,     0,  1018,   999,   995,     0,  1001,
    1022,   791,   790,   789,   788,   846,   854,     0,   833,     0,
     861,   857,     0,   858,     0,     0,   859,   848,     0,     0,
     854,     0,     0,     0,   779,  1431,     0,  1220,  1224,  1221,
    1432,   967,     0,  1176,     0,  1273,   622,   606,     0,   332,
     297,   567,   628,   612,   627,   208,   209,   210,   211,     0,
     213,   477,     0,   483,   479,   232,   253,   404,   403,   401,
     397,   399,   878,     0,   598,     0,   400,     0,     0,   276,
     282,   307,     0,     0,   267,   385,     0,     0,   379,   324,
     292,   291,     0,     0,     0,   328,   364,     0,     0,     0,
     541,   548,   548,   570,   562,     0,     0,   571,     0,   580,
     581,     0,   569,   549,     0,     0,   529,     0,  1043,     0,
       0,  1016,  1115,  1003,   845,     0,     0,   847,     0,     0,
     850,   852,     0,     0,     0,     0,     0,  1193,   821,   823,
    1223,  1222,   178,  1177,     0,  1104,     0,   298,   229,   485,
     240,   244,   708,   708,     0,   708,   241,   708,   238,   598,
       0,   596,   395,     0,   283,     0,   312,     0,     0,   387,
     388,   383,     0,   328,     0,   322,   323,     0,   330,   709,
       0,   330,     0,     0,   546,   544,   543,     0,     0,   578,
     579,     0,   582,   871,   740,     0,  1044,     0,   855,   864,
       0,   851,   849,   839,     0,   841,     0,  1173,   301,     0,
       0,     0,     0,     0,     0,   595,   597,     0,   305,   306,
       0,   285,   308,   309,   331,     0,     0,   330,   320,     0,
       0,   257,   548,   871,   542,   547,   563,   575,     0,     0,
    1045,   853,     0,   840,  1178,   307,   242,   246,     0,   247,
     243,   245,     0,     0,     0,     0,   310,     0,   311,     0,
       0,     0,   421,   422,   391,   258,     0,   325,     0,   329,
     545,   536,   576,   652,   863,   312,   248,     0,   317,     0,
     316,     0,   313,   314,     0,     0,   427,     0,     0,   389,
     392,   393,   326,   327,   651,   650,     0,   400,     0,   315,
     318,   319,     0,   431,   423,   373,     0,   634,   645,   633,
     635,   643,   640,   642,   641,   639,   299,     0,   426,   430,
       0,   424,   390,     0,   644,   638,   778,   769,     0,     0,
     636,   645,   391,   431,   637,     0,   425,   374
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,     2,    68,   226,   227,   228,  1454,   229,   230,
     231,  1372,  1830,  1074,   232,  1441,  1880,   233,   234,   235,
    1044,  1445,  1884,   236,   855,   856,  1666,  1667,  1834,  1668,
    1669,  1657,  1225,  1651,   237,   238,   239,  1219,  1647,   240,
     241,  1363,  1364,  1347,  1348,  1337,  1483,  2910,   242,   243,
    1852,  2227,  2915,  3008,   717,  1397,  2533,  2534,   244,   739,
    2269,  2270,  2271,  2272,  2254,  2580,  2581,  2582,  2273,  2798,
    2274,  1763,  1911,  2287,  2288,  3016,  3071,  3072,  3073,  3132,
    2800,  2945,  3028,  3081,  2788,   245,  2598,  2281,  1904,  2275,
    2276,   246,   247,  1355,  1802,  2179,   248,   740,  2599,  2808,
     249,   773,   250,  1447,   251,   252,  1450,  1896,  1897,  2792,
    2936,  3021,  3138,  3139,  2926,  2762,  2763,  2764,   253,   254,
     255,   256,  1899,  1399,  1853,  1854,  2538,   257,  3112,  3113,
     741,  3171,   258,   259,   774,  1077,  3034,  1329,   260,   261,
     792,   793,   794,   262,  1028,  2219,   263,   264,   814,   815,
     816,  1511,  2311,  2312,  2622,   840,  1940,  1941,   265,   742,
    2603,  2949,  2950,  3035,   266,   743,  1340,  1774,  1775,  1776,
    2953,  2151,  2539,  2540,  2823,  2824,  2963,   267,   268,  1748,
     269,  1789,   988,   270,  3011,   271,   272,   831,  1525,   273,
    1805,   274,   275,  2286,  3159,  3173,  3174,  3175,  2829,  3146,
     276,  3161,   278,   279,   280,   705,  1002,  1003,  1004,   281,
     282,   283,  1874,  1875,  2248,   284,   285,   286,   287,  1439,
     288,   289,   290,   291,   292,   880,   873,  1246,  1683,   293,
    1488,   779,  3162,  1517,  1950,  1951,  3163,   296,  1521,  1957,
    1960,  3164,   298,  1061,  1914,  3165,  1172,   301,   302,   303,
    1627,  2073,   823,  1252,   845,   885,   886,  1688,  1689,  1259,
    1702,  1695,  1697,  2718,  2884,  1260,  1700,  2109,  2077,  2429,
    2430,  2431,  2700,  2711,  2871,  2980,  2432,  2433,  1470,  2264,
    2265,  1790,  1861,  2239,  1420,  1173,  1174,  1175,  1558,  1565,
    1552,  1423,  1176,  1177,  1178,  1426,  1179,  1180,  1181,  1182,
    1537,  1593,  1183,  1184,  1575,   908,  1963,  2001,  1186,  1187,
    1188,  2067,  1621,   990,  1189,  2475,  1623,  2020,  1986,  2681,
    1966,  1535,  1987,  1997,  2355,  2004,  2009,  2380,  2381,  2021,
    2037,  1190,  1970,  1971,  2338,  1539,  1191,  2022,  1008,  1582,
    1546,  1192,  1193,  1678,  2095,  2994,  1679,  2316,  2317,  1194,
    1512,   871,  2976,  1221,   573,  2170,  1382,   711,   820,  1195,
    1196,  1197,  1198,  1199,  1200,  1201,  2241,   798,  1935,  2890,
    2220,  2560,  1309,  1670,  1202,   552,   712,   304,   574,   575,
     928,   929,  1296,  1299,  1286,  1732,   553,   554,   576,  2732,
     305,   306,   307,   308,   309,  1261,   890,  1280,  1726,   909,
      72,    77,    73,   910,   346,   347,  1708,   310,   683,  1709,
    1283,   915,   350,   312,   313,   351,   315,   660,   352,   892,
     317,   893,   318,   319,   320,   321,   900,   322,  1263,  1264,
    2481,  1265,   323,   324,   577,   578,   325,  1082,  1484,  1081,
     749,   326,   327,   941,   942,   943,  1095,  1497,  1096,  1312,
    1313,   328,   329,   569,   330,   331,   332,  1502,  1503,   333,
    1642,  1643,  1644,   334,  2303,  2304,   335,  2456,  2457,  2458,
     336,  1636,   337,   338,   865,  2485,   339,   679,   340,   955,
     555,   556,   557,  1204,   663,   819,  1205,   962,   664,   342,
     666,   559,   560,   561,   562,   563,   965,   670,  1498,    74,
    2129,  1499,  1208,  1209,  1632,  1210,   566,   919,   934,   935,
    2130,   937,    75,   938
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -2873
static const int yypact[] =
{
   -2873,   256, 12168, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, 13945, -2873, -2873, 49138,   492, -2873,
   -2873, -2873, 34770, -2873, -2873, -2873, -2873, -2873,   145, 34381,
   12795, -2873, 46810, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, 46810, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, 33215,   612, -2873, -2873,   167, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873,   -94,  1984, -2873, -2873, 37104, -2873,
      -3, -2873, -2873, -2873, -2873, -2873, -2873, 46810, 41766, -2873,
     252,   -94, -2873,   535,  5108, -2873, 37104, 35548, -2873, -2873,
   47198,   545,  2813,   -94, 37493, -2873,  1223, -2873, 30872, -2873,
   -2873, -2873,   662,  1752, -2873, -2873, -2873,   584, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, 41766,   761,   467, 31261, -2873,
   -2873, -2873, -2873, 41766, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, 37104, -2873,   391, 47586, 42542,   669, -2873,
     -94, -2873, 46810,   156, 32826, -2873, 42930, -2873, -2873,   525,
   -2873, -2873, -2873, -2873, -2873,   467, -2873, 33215, 29690, 40990,
     720, -2873, -2873, -2873, -2873,   -87,  5704,   453, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873,   589, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
      18, -2873,   540,    95, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, 50278,  1009, -2873, -2873, -2873,   558, -2873,   534, -2873,
   -2873, -2873,  1241, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873,   577, -2873, -2873, -2873,   944, 49518, -2873, -2873,
   50278, -2873,   611, 37104, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, 35937, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873,    86, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, 46810, 46810,
   -2873, -2873, -2873,   643, -2873,   659, -2873, -2873, -2873, -2873,
   -2873,   733, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, 12250,
   -2873, -2873, -2873,   766, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873,   846, -2873,   153,  1014, -2873, -2873, 33215,
    1190,  1190,  1218, 50278, -2873, -2873, -2873, 39826, 46810, 46810,
   46810, 39826, 46810, 40990, 46810, 28099, 46810, 41766, 40990, 46810,
   46810, 46810, 46810, -2873,  1222,   397, -2873, -2873, -2873,   624,
   -2873,   976, -2873,  1016,  2306, -2873, -2873, 41766, 39826, 46810,
     861,   937, 46810, -2873, 46810,   954, 46810,  1021,   767,  1034,
   46810, 46810, -2873, -2873, 46810, -2873, 46810, -2873, 46810,   605,
    1080,  1213,  1194,   349, -2873, 37104, 37104, -2873, -2873, -2873,
    1142, -2873, 40990, 39826, 46810,   994, -2873, 46810, -2873, 39826,
   46810, -2873,  1413, -2873, 46810, -2873, -2873, -2873, 46810, 46810,
   -2873, 46810, -2873,  1191, 46810, -2873,  1045, -2873, -2873,   589,
    1084, -2873,   177,   -52,   186, -2873, -2873,   -19,    66,    98,
    1084,   868, 42154, -2873, 46810,  1232, -2873, -2873, -2873, -2873,
   37104,  1167, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873,  1225,  1091, -2873, 41766, -2873, -2873,
   -2873, -2873, -2873, 41766,   880, -2873, -2873,  1318, 46810, -2873,
   -2873, 41766, 46810, -2873, -2873,  1470,  1153,  1396, -2873,  1321,
    1752,  1295, -2873, -2873,  1394, 16423,   -93, 31650, 37104, 43318,
   47974,    56, 43706,  1294,   397, -2873,   359, -2873, -2873,  1602,
    1345,  1481, -2873,   397, 41766, 50651, -2873, -2873, -2873, 25728,
    1429,  1368, -2873,  1596,  1378,  1388,   -94,  1370, -2873, -2873,
   41766,  1721,  1721,  1705,  1721,   617,   718, -2873, -2873, -2873,
    1423, -2873,  1436,  1451, -2873,   158,  1633, -2873, -2873, -2873,
   -2873,  1522,  1523,  1524,  1526, -2873,  1528,  1022, -2873, -2873,
   -2873,  1711, -2873, -2873, -2873,  1423, -2873, -2873, -2873, -2873,
   -2873,  1790,  1776, 36326, 36326,  1515,   -22, 32435, -2873,  1465,
     643, -2873, 15523, 12250, -2873, 23334,  1052, -2873, -2873, -2873,
      79, -2873, -2873, -2873,  1674, -2873, -2873,  1680, 46810, -2873,
    1552, 46810, -2873, -2873, 48362, -2873, -2873,  1190,  1423,   624,
    1490,  1492, -2873,  1494,  1496, -2873,  1497,   847,  1487,   797,
     169,  1632,   -47,  1499,   262,   708,  1617, 46810, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,  1512, -2873,
   -2873,  1516,   848, -2873,   900,   854,  1658,  1650,   980,  1517,
    1702,   -67, -2873,   283, -2873, 19300, 28912, -2873,   624, 41766,
   39826,  1521, -2873, -2873, -2873, -2873, 39826, -2873,  1673,  1443,
   46810, -2873, -2873, -2873, 46810, -2873, -2873,  1712, 46810,  1558,
    1533,  1825, 38661, 46810,  1566,  1858, -2873, -2873,  1569, -2873,
   -2873, 46810,  1533, -2873,  1855,  1856,  1675,   218,    38,  1572,
   41766, 41766,  1730, 46810, 46810, 39826, 46810, 41766, -2873, -2873,
   -2873,   506,  1576,  1544, -2873, 38661, -2873,  1499, -2873, 46810,
    1545,  1690, -2873,  1691,  1546, -2873,   761,    25, -2873, -2873,
   -2873, -2873,    63,    15, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, 46810,  1232,  1232,    82, -2873, -2873,    78, -2873, 41378,
    2296,    47,    -8, -2873, 46810,  1045,  1784,  1784, -2873, -2873,
   -2873,  1737,  1787,  1700, 48750,  1557,   679,   987,   875, -2873,
   19300,  1561,    37,    37,  1563,  1564, -2873,  1565,  1568,  1570,
     801,   801,  1687,  1571,  1574, -2873,   865, -2873,  1193,   945,
    1366,    37, 19300, -2873,  1578,   968,  1584,  1587,  1588,  1208,
    1589,  1570,  1272,  1592,  1031,  1059,  1595,  1597, -2873,  1571,
    1570,    29, -2873, -2873, -2873, -2873, 19300, 19300, -2873, 19300,
   19300, 16834, -2873,   761, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873,    24, -2873,   986,  6814, -2873, -2873, -2873, 19300,
   -2873, -2873,   -56, -2873,   624,  1598, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873,   988, -2873, -2873,  1046,  1085, -2873, -2873,
      97,  1086,  1117,  1117, 36715, 36715, -2873,   237, -2873,   436,
    1560, -2873,  1023, -2873, -2873, -2873, -2873, 35159,  1891, -2873,
    1607,   283, 30078, 46810, 30078, -2873, -2873,  1759, -2873, -2873,
    1794, 41766, -2873, 26907, -2873, -2873,   589, -2873, -2873, -2873,
    1601, -2873,   -87,   -87, 19300,   -87,   314, 17245, 19300,  1828,
     648,  1423,  1609,  1313, -2873, 39438, 49898, 49898,  1803, -2873,
   -2873,   656,   -18,  1707,  1778,   550,  1048, -2873, -2873, -2873,
    1605, -2873,  1879,  1423,  1342, 37104,  1659, 36326, -2873, -2873,
    1989, -2873,  1989, -2873, -2873, -2873, -2873,  1616,   868, -2873,
    1465, -2873, 15600,  1139, -2873, -2873, 12250, -2873, -2873, -2873,
   -2873,  2021, -2873,  1619, -2873, -2873, 50278,  1626, 46810, -2873,
    1627,  1628, -2873, 50651,   624, 29302,  1693,  1695, 33215,  1631,
    1701,  1703, 47974, -2873,   564,    96,    81, -2873,  1706,    92,
     864,  1685,  1689,  1713,  1714,  1719,  1727,  1630, -2873,  1723,
    1704, 37883, 28505,  1724,  1726,  1252,   578,  1938,  1808,  1728,
    1135,    52,  1697,  1661, -2873,  1732,  1735, 40990,  1738,  1741,
   47974, -2873,   820, -2873, -2873,   782, -2873, -2873,   397, -2873,
    1514, -2873, -2873, -2873, -2873, -2873,  1679, 38661,  1499,  1022,
   46810,  1683,   575,  1824, 46810,  1880,  1831,   -20, 33215, -2873,
    1688, -2873,  1725,  1725,  1725,  1696,  1696,  1698, -2873, -2873,
    1366,  1725,  1699, -2873, 39050, -2873,   642,   807, -2873,  2011,
      42, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
     680, -2873,  1487, -2873, -2873, -2873,  2022,   747, -2873, 38661,
   -2873,   488,  1955, -2873, 46810,   526, 46810,  1872, -2873, -2873,
     151,  1710, -2873, -2873, -2873, -2873,   279, 36326,  1929,  1845,
   -2873,  1499,  2033,  1715, -2873,  1292, -2873,  1810, -2873, 19300,
   -2873, 29302,  2038,    55,  1760, 37883, 41766, 41766, 46810,    55,
   -2873, -2873, 46810, -2873, -2873,  1232,   846, 46810, -2873, -2873,
   -2873, -2873, -2873, -2873,  1232, -2873, -2873,  2115,  1716, -2873,
      97,   868,  1718, -2873,  1733, 46810, 39826, 46810, 46810, 41766,
   46810,  1783,  1722, -2873,  1769,  1736, 26514, -2873, -2873,    71,
   41766,  1886, -2873, -2873, -2873, -2873, -2873, -2873, -2873, 41378,
   46810, -2873, 19300, 17656, -2873, -2873, -2873,  1740,  8961,  1775,
   19300, -2873, -2873, 19300, 19300,   585, -2873,   585, -2873,  1742,
   -2873,   868, -2873, -2873, -2873, -2873,  1978,   868, -2873,  1725,
    1725, -2873,  7796, 19300,   868, -2873, 28505, 19300, 19711, 14737,
   -2873, 19300,  1812,  1813,   868, -2873,   868, -2873, 19300, 16012,
   -2873, -2873,   624,  2080,  2080,    60,  1066,   723,  2286,  1745,
   -2873,  1834,   868, -2873,   868,   881, 38661, 19300, 33215,  1826,
   19711, 19300,  1758,  1502, -2873, 19300,   630, -2873,  1764, 19300,
    1829,    84, 19300, 19300, 19300, 19300, 19300, 19300, 19300, 21341,
   21752, -2873, 20122,    89,   278, 33992, 16423,  1993, -2873,   993,
   14325, 37104, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873,   868,  1766, -2873,  1780, -2873, -2873, -2873, 46810,  1891,
   -2873, -2873, -2873, -2873,  1837, -2873, -2873, -2873,  1096, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873,  1767, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, 50278,  1779, 46810,   -27, -2873,
   -2873, 40602, 46810, -2873, -2873,  1979, -2873, -2873,  1777, -2873,
    5937,  1979,  1928,  1935, -2873,   -80,  8961,  1968,  8961, -2873,
   -2873, -2873, -2873,  1348, -2873, -2873,  1423,  1791, 13185, -2873,
   13565, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873,  1022,  1792,  2168,  1372, -2873,
   -2873, 36326, -2873, -2873, 32435, -2873,  1800, -2873, -2873, -2873,
   37104,  1145,  1791, 12250, -2873, 12250,  1791, -2873,  1802, -2873,
   46810, 46810, -2873, 33215, 46810, 46810, -2873,  1806, 46810,  1999,
    2000,  1811, -2873, -2873, 46810, -2873,  1970, 19300,  1973, 46810,
   -2873, -2873, -2873, -2873,   337, -2873, 33604,  1889,  1901, 46810,
   46810, 46810, 46810, 46810, 46810,   517, 46810, 46810,  1809,  1842,
    1821, -2873, 46810, 46810,  1022, -2873,  2145,  1022,  1022,   604,
    1572,  1572, -2873, -2873, -2873, 46810, 46810, 46810,  1911, 46810,
   46810, 46810, 46810,   342,  1101, 46810, 46810,  1957, 46810, 46810,
   -2873,   820, -2873, -2873,  2066, -2873, -2873,  1870,   868,  1894,
   -2873,    31,  1969, -2873, -2873, -2873, -2873, 19300, 29302,  2170,
    2044,  2046,  1897, 37883,   400, 46810, 46810,  2053,   400, -2873,
   -2873, -2873,   682,   832, -2873,  1875, 19300,    50, 38661,  1865,
   24923, -2873,  1930, -2873,  1931,   868, -2873,  1631,   151,  1882,
    1882,  1882,  1882,  1882,   747, -2873, -2873,   488,   868, 46810,
   -2873,  2103, -2873,   961, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873,  1870, -2873, -2873, -2873,  2017,  2014, 46810, -2873,
     820,  1252, 41766, 40214,    57,  2095,   761, 41766,  1983, -2873,
   46810,  2199,  2100,  2101,  2116, -2873,  8961,  1885, 38661, -2873,
   46810,  1888,    55,    55, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, 37104,   733, -2873, -2873,   733, -2873,   733,  2290,  1560,
    1887, -2873,  1499,  1560,  1560,  1722,  1560, 44094, -2873, 18067,
     873, -2873, -2873,    30, -2873,    36,   -64,  2063, -2873, -2873,
   -2873,  2122, -2873,  8961,   902,   805,   824, -2873,   868, 19300,
      23, -2873,  6976,   936,  7416,  1088, -2873,  1895,  1896,  1094,
   -2873, -2873, -2873, -2873, -2873, -2873,  1898,  2127, -2873, -2873,
    1903, -2873, -2873,  2688,  1100,  1905,  7886,  1906, 19711, 19711,
   19711,   939, -2873, 19711,  1909, -2873,  1113,  6441,  1910,  1914,
    1944,  1945,  1919,  1920,  8379, 18478, 19300, 18478, 18478,  8637,
    1910,  1921, -2873, -2873, 19300, 46810,  1922,  1923, -2873, -2873,
    7796, -2873,  1958,  1489,  3519, 16834, -2873, -2873,  2138, -2873,
     490, -2873,  1936, -2873, -2873,  5847, 19711, 19300,  1758, 19300,
    2002, 28505,  4967, 19300,  7130,  3064,  3064,    93,    93,    60,
      60,    60,  1066,   278, -2873, -2873, -2873,  1939,  1147,  1268,
   41766,  2795,  3350, -2873, -2873, -2873, 24137,  1576, 19300, 19300,
    1941, -2873,  1126, -2873, -2873,   238,  2290,   868, -2873,   397,
     868,   881, 30475,  1791, -2873,  1942, -2873, 46810,  1576,   912,
   -2873, -2873,  1154, 19300, -2873, -2873,  1761, -2873, 46810, -2873,
   19300, 19300, 17245, -2873, -2873,  1959, -2873, -2873, -2873, -2873,
   -2873,  1946, -2873, -2873, -2873, 46810, -2873, -2873,  2324,  1950,
    1949,  1951,  1960,   870, -2873, -2873, -2873, -2873, -2873, 19300,
     389,  1964,  1965, 46810,    55, -2873,  8961, -2873, -2873, -2873,
     633, 38661, -2873, -2873,   139,  1487, -2873,   175,   185,   216,
   46810, 46810,  1546,  1546, -2873, -2873, -2873, -2873, -2873, -2873,
     905, -2873, 38661,  2092, 38272, -2873, -2873, -2873, -2873,  1022,
   -2873, -2873, -2873, -2873, -2873,  1022,  1022, -2873, 38661,   341,
   -2873, -2873,    55,    55, -2873,  2009, -2873, -2873, -2873, -2873,
   -2873,  2024, -2873, -2873, 46810, -2873, -2873,  1870, -2873, -2873,
   -2873,  5407,  1971, 38661,   400,   400, 46810,  1976, -2873, -2873,
   -2873,  2163,  2165,   400, -2873, -2873, -2873,     4, -2873, -2873,
   33215, 27693,  3410,  1980, -2873,  1986,   868,  1791, 25333,  1284,
   -2873, -2873, -2873,   532,  2144,  1987,  2123, -2873,   188,   155,
   44482, 44870, 45258, -2873,  2256, -2873,  1546,  2034,   526,   637,
    2026, -2873, 41766,   151,  1160, -2873, 38661,  1991, 41766,  1994,
    1992, -2873, -2873, -2873, -2873,  1182, -2873, 38661, -2873,  2143,
    2148, -2873, 46810,  2067,  2042, 38661,  2149,  1196, -2873, -2873,
     -87, -2873, -2873, 26121,    55,  2005,    55,    55, -2873, -2873,
    1005, -2873, -2873,  2001, -2873,  2023, -2873, -2873, 39826, -2873,
   46810,  -110, -2873, -2873, -2873,  8961,  1216, -2873,   409, 46810,
     624, -2873, -2873, -2873, -2873,  2251,  2254, -2873, 44094, -2873,
   19300, -2873, -2873,  2015,  2013,  8799, 19300, -2873,  2258, 38661,
   -2873, 46810, -2873, -2873, -2873, -2873,   868, -2873, 19300, -2873,
   19300, -2873,   868, -2873, 19300,  2248, -2873,  2361,    49,  2361,
   38661, 19711,   571,  1584, 20930, 19711, 19711, 19711, 19711, 19711,
   19711, 19711, 22149, 22560, -2873,   333, -2873, -2873, 19300, 19300,
    2257,  2248, -2873, -2873, -2873,  1426,  1426, 38661,  2025,  1910,
    2029,  2030, 19300, -2873,   624,  3681, -2873,  2331,   761, 20533,
   19711, 19300,  1227, 19300, -2873, -2873,  2041, -2873, -2873, 38661,
   19300,  2051,  8344, -2873,  9055, 19300,  2032,  9102, 16834, -2873,
     467,   467,   467,   467, -2873, 41766, 41766, 23744, 45646,  2048,
      48, -2873, 45646, 46034, -2873,   624,  2269,  1228,  1236, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873,  2054, -2873,  2065, -2873,
   -2873,   283,  2049, -2873, -2873,  2324,  2072,  1180, -2873, -2873,
   18889, -2873, -2873,  2062, -2873, -2873,  1560, -2873, -2873, -2873,
   12250, -2873, -2873,  2087, -2873, -2873, -2873, -2873, -2873,  2129,
    2130,  4436, -2873, 46810, 46810,  1238, -2873, -2873, -2873,   221,
   -2873, -2873,  2131,  2132, -2873,  2133, -2873, -2873, -2873, -2873,
   -2873, -2873,   407,   505, 38661, -2873, -2873, -2873, 46810, 46810,
    1546, -2873, -2873,  2265,  2074, -2873, -2873,  2267,  2270,   400,
     400, -2873, -2873,  1572,  2334, -2873,  2062,  1048, -2873, -2873,
   -2873, -2873, -2873,   512,   868,  1446,  2081, -2873,  1214, 25333,
   25333, 25333, 25333, 25333,  1791,   881, 41766, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
    2078, 46810, 19711, -2873,   712,    68, -2873,  2273, 41766,  2139,
   -2873, -2873, -2873, 38661, 41766,  2311,  2226, -2873, 46810, -2873,
   40214,   750,  2295, 40214, -2873, 46810,  2411,  2417,   -87,  2288,
    1487,   761, 46810,  2102,   675,   566, -2873, 46810, -2873, -2873,
   -2873, -2873,    55, -2873, -2873,  1292,   733,   238, -2873, -2873,
    2322, 44094, -2873, -2873, 18067,  2105, -2873, -2873, -2873, -2873,
      27,  8961, -2873, -2873, 19300,  8961, -2873,  2106,  2107,  2108,
    8961,  4714,  2109,  8961,  2257, -2873,  1116,  2328,  2255,  2113,
     333,  1116,   122,   122,    58,    58,    49,    49,    49,  2361,
    8961,  8961, -2873, -2873, -2873, -2873,  2114, -2873, -2873, -2873,
    1910, -2873, -2873,   881, -2873,   398,   984, -2873,   217, 38661,
   -2873,  1240,   984, 19711, 19300, 19300,  9419,   208, 19300,  4803,
   41766, 41766, 41766, 41766, -2873, -2873, 22957,    48,  2117, 46810,
   -2873,  2124, 24137,  2305,  2253, -2873, 24137,  2253,  1000,  2253,
   24137,  2308, -2873, 27300, -2873,  2125,   993,  2429,  2342, -2873,
   -2873,   238,  1170,   761, -2873,  2126, 46810, -2873,  8961, 28505,
   -2873, 46810, -2873, 46810, 46810, -2873,  1248,  1251,  2139,  2183,
   46810, 46810, 46810,  2256,  2291,  2293,   868, 46810,  2180, -2873,
   -2873,   400,  2335,   400,   400, -2873, -2873, -2873,   761, -2873,
     746,  2404, -2873,  2350,   343,  2146,  2372,  2373, -2873, -2873,
    1226,  1226, -2873, -2873, -2873, -2873, -2873,  2377, 19300,  1529,
    1116, -2873, -2873, -2873, -2873,  2139,  1715,  2360, -2873,  2195,
     320,  2403,  2396,   151, -2873,  2155,  2420,  2423, -2873,  2161,
    1450, -2873, -2873, -2873, -2873, -2873, -2873,   761, -2873,  1631,
    2390, -2873, 24530,   761,  2312,  2268, -2873, 36326,  2326,   644,
   -2873, -2873, -2873,  1655, -2873, -2873, -2873, -2873, -2873,  2233,
   -2873, -2873,  2406, -2873, -2873,  2317, -2873, -2873, 18067, -2873,
    8961, -2873, -2873, -2873, -2873, -2873, -2873, 19711,  2178, 19711,
   -2873, -2873,  1257, -2873, 38661,   398,   984,   984, 19300,   984,
   -2873, -2873, -2873, -2873, -2873, 45646,  2181, 46810,    48, 24137,
   -2873, -2873,  1838, -2873, 24137,  2371, -2873, -2873, 24137, 46810,
    2182, 46810, 19300, 19300, -2873, -2873,  1048, -2873, -2873, -2873,
   -2873,   881, 19300, -2873,  2184, -2873, -2873, -2873,  2303,  2139,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, 19300,
   -2873, -2873,   400, -2873, -2873,  1150, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, 39826,  2511, 41766,   512,  5185,  2345, -2873,
   -2873,  2368,  2275, 46810, 40214, -2873,     1,  2316, -2873,  1450,
   -2873, -2873, 41766,  2343,  2344,  2340, -2873, 46810, 19300,  1258,
   -2873, 46422, 15148, -2873,  2193,  2355,   714, -2873,  2352, -2873,
   -2873,  1533, -2873, -2873, 41766,   -87, -2873,  1290,   596, 19711,
     159, -2873, -2873,   984, -2873, 46810,  1305, -2873, 19300,  2209,
   -2873, -2873, 24137,  1838,  1308, 46810,  1316, 38661,  1910,  8961,
   -2873, -2873, -2873,  3295,  2212, -2873, 41766, -2873,  8961, -2873,
   -2873, -2873,  1858,  1858,   479,  1858, -2873,  1858, -2873,  2511,
    2529, -2873, -2873,  2446, -2873,   388,  2359, 46810,  2539, -2873,
   -2873, -2873, 46810,  2340,  1328, -2873, -2873,  2506,  2294, -2873,
    6410,  2294, 24530, 46810, -2873, -2873, -2873,   761,  2426, -2873,
   -2873,  2380, -2873,  1576, -2873,   640, -2873,  1351, -2873,  8961,
   46810, -2873, -2873, -2873,  1354, -2873, 19300, -2873,  1715,   761,
    1870,  2382, 46810,   761,  1870, -2873, -2873,  2469, -2873, -2873,
       2, -2873,  2374,  2375, -2873,   382,  2232,  2294, -2873,    74,
   46810, -2873, 46422,  1576, -2873, -2873, -2873, -2873,  2437,  2489,
   -2873, -2873,  1357, -2873, -2873,  2368, -2873, -2873, 46810,  2230,
   -2873, -2873,  2347,   234,   234,  2285, -2873,  2499, -2873,   868,
     868, 38661,  2235, -2873, 32039, -2873,  2348, -2873,  2356, -2873,
   -2873, -2873, -2873,   110, -2873,  2359,  2230,  2483, -2873,  2579,
   -2873,   438, -2873, -2873, 39826, 28505, -2873,   382,  1361, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873,   599,   512,  2378, -2873,
   -2873, -2873,  1499,   253, -2873, -2873, 32039, -2873,   417, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, 39826, -2873, -2873,
   37883, -2873, -2873,  1210, -2873, -2873,  1296,  1388,  2259,  2252,
   -2873,   417, 32039,  2376, -2873,  1364, -2873, -2873
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -2873, -2873, -2873, -2873, -2873,  2444, -2873, -1712, -2873, -2873,
   -2873,  -763, -2873, -1662, -2873,  1235, -2873, -2873, -2873, -2873,
   -2873,   790, -2873, -2873,  -749, -2873,  1442, -2873, -2873,   587,
   -2873, -2873, -2873, -1431, -2873,   -28, -2873, -2873, -2873, -2873,
   -2873, -2873,   863, -2873,   895,   493, -1379, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -1375,   800,
      94, -2873,   112,   882,   180, -2873,   -76, -2873, -2873, -2873,
    -303,   546, -2647, -2085,    99,  -387,  -416,  -362,  -360,  -391,
   -2873,  -223,  -308, -2068, -2545, -2873, -2873, -2873, -2873, -2873,
     124, -1369, -2873,  1262, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873,   225, -2873, -2873, -2873, -1368, -2873,   853, -2188, -2873,
   -2873, -2873,  -460,  -433, -2873, -2722,   -40,   -37, -2873, -2873,
   -2873, -2873, -2873, -1031, -2873,   498, -2873, -2873, -2873,  -408,
    1291,  -451, -2873, -2873, -2873, -2873,  -681, -1385, -2873, -2873,
    2556,   798,  -145, -2873, -2873, -1758, -1367, -2873,  1899, -2873,
    1635,  1207,   410,   116, -2873, -2873, -2873, -2209, -1362, -2873,
   -2873, -2873,  -292, -2640, -2873,   860, -1061, -2873,   595, -2873,
   -2873, -2873,   461, -1666, -2873,   -74, -2873, -2873, -2873, -1357,
   -2873, -1451, -1327, -2873,  -262, -2873, -2873, -2873,  1641, -2873,
    -157, -2873, -2873, -2873, -2873, -2873,  -390,  -426, -2873, -2873,
   -2873,   272, -2873, -2873, -2873,   137,  -972,  -826,  1904, -1359,
   -2873, -2873, -2873,   883,   -70, -2873, -2873, -2873, -2873, -1397,
   -2873, -2873, -2873,  1077,  2603,  -699, -2873, -2873, -2873, -2873,
   -2873, -2873,   -13, -2873, -2873,   441,   -12, -2873, -2873, -2873,
   -2873,   -11,  1678,   833,   154,   -62,   -71,  -224,   586,   614,
   -2873, -2873,  -207,   915, -2873, -2873, -2873, -2873,   665,  1519,
   -2873,   663,  -249, -2873, -2873,  1518, -2873, -2873,  1102, -2873,
   -2321,   347, -2328,    85,  -957,  -197,  -171, -2873, -2003, -2115,
     199,   553, -1634, -1935,  1374, -2873,  2158,  2188, -2873, -2873,
    -988, -2873, -2873,  2274,  2884, -2873, -2873,  4185,  5357, -2873,
   -1025,   392,  6417,  2079, -1113, -1394,  9039,  -902, -1253, -1994,
   -2873, -2873,  -693, -2873,  9768,   563, -2873, -1142, -2873,   117,
   -2873, -1441, -2873, -2873, -2873, -2873, -2873, -1410, -2232,  -467,
     751, -2873, -2873,   825, -2873, -2873, -2873,  -679,  -949, -1578,
     204, -2873,  1174, -2873,    83,  -252,   709,   -26,   181,     8,
    -819,    80,  -833,  7326,  -650, -1864, -1244,  1754, -2873,  -668,
   -2873,    -2,   395, -2873, -2873,   201,  -140, -2873, -1590, -2873,
     -16, -2873,  -870,  -907, -2872,   240, -2873, -2873,   -75, -2873,
    1881, -2873,  1076,  1513, -2873, -2873,  1083,  -794,  -133, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873,  1548,    72, -2873,   -55,
   -2873, -2873,  2742, -2873,  2505,   -61, -2873,  2159,   -30, -2873,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,  -800,  1112,
   -2873,  1863, -2873, -2873, -2873,  -725, -2873, -2873, -2873,  1720,
    -139, -2873, -2873, -2873,  -969,   946,  1900,  -813,  -973,  1082,
   -2873, -2873, -2873, -2873, -2873, -2873, -2873, -2873,   887, -2873,
   -2873,   741,   890, -2873, -2873,   213, -2873, -2873,   111,   214,
   -2873,  1620, -2873, -2873, -2873,   370, -2873, -2873, -2873,  -540,
    7392,   -25,   -85,   -33,   123,  1549,  7379,  1061,  -647,   -45,
    1575,  5551,  8867,   -31,   -44,   104,   132, -2873, -2873,  2493,
    1097,   909,  -876,  6137,  1343,  3223,  4076,  -704,  -810,  1912,
    -526, -1272, -2873,  2843
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1715
static const short yytable[] =
{
      69,   875,   989,   300,  1102,   661,  1473,   967,   864,   970,
    1324,  1443,   299,   314,   748,   777,  1220,  1452,   797,   960,
     997,   748,   349,   973,  1921,  1791,  1905,   661,  1231,  1589,
    1007,  1379,   947,  1310,  1739,  1042,  1866,  1279,   797,   969,
     971,  1058,  1577,  1035,   316,   665,   669,  1867,   870,   341,
    1030,  2085,   341,   703,   827,  1048,  2296,   662,  2495,   668,
     748,   294,   295,   297,  1314,   341,   551,   665,   669,  1070,
    1885,   744,  1034,  2115,  2436,  2586,  1886,  1887,  1888,   662,
    1083,   668,  2434,  1889,  1752,  1063,  1890,   341,  2185,  2186,
    2224,  1067,  1967,  1078,  1919,  2469,  1097,  1541,  1542,  2618,
    1925,  1223,  2099,  1229,  2712,  2714,  2697,  1066,  2128,  1486,
    2152,   922,  2132,  1485,  1917,  1284,  1561,  2162,  2163,  1495,
    1496,  1307,  1216,  1631,  1307,  1304,  2360,  1311,  1501,  1288,
    1289,  1451,   661,   936,  1859,  2360,  1480,  1596,  1480,  2931,
    1591,   956,  2233,  1553,  1217,  -938,   709,   704,  2662,   348,
    2278,  1953,  -770,  -943,   874,   300,   796,  1599,  3103,  2208,
     821,  2076,  -256,  1625,   299,  1487,  1480, -1619,  1850, -1090,
    1596,   151,   665,   669,  2064, -1090,   796,  1803,   343,   567,
    2065,   343,   944,   709,   662,  2703,   668,  1268,  2110,  2336,
    1599,   709,   341,  2900,   343,  1519,  3144,  1292,  1514,  2360,
   -1641,  2028,  2321,    71,  3013,  1376,   344,  1224,  2323,   344,
     680,  -770,   681,   294,   295,   297,   343,  2256,   710,  1628,
     918,  2783,   344,  2234,  1716,  1764,   709,   709,   167,  -773,
    3116, -1524,  1767,   203, -1194,   674,  2360,  2704,  3117,  1995,
    2930,   843,  3140,  1954,   344,  1629,  2441,  1765,  2325,  1640,
     887,  1334,  2442,  2443,  2444,   818,     3,  2705,  1212,  1379,
     684,   686,  1085,   826,  2445,  2446,  2447, -1526,  2448,  2449,
    2450,  1087,  2706,  2620,  2451,  2452,  2453, -1523,   715,  2707,
    1007,   888,  1094,   550,  3140, -1654,   341,  1641,  -773,   914,
     775,   685,   913, -1106,  1596,  1770,  1350,  2708,   868, -1106,
    1717,  1448,  1771,  2548,  1577,  2326,  2562,  1893, -1522,  1213,
    3140,  2621,  3036,  3019,  1599,  2002,   844, -1671,  1449,  1377,
     888,   343,   341,  1659,  3145,   341,  1391,  1840,   225,  1384,
    2784,  1851,  1481,  1335,  1481,   203,  3020,   841,  1768,  2557,
     866,  2111,  1386,  2362,  1341,  3128,   277,  2002,  1388,   344,
    1290,   684,  2527,  1766,  2997,  1596,   568,  2322,  2709,  1383,
    1442,  3118,  1481,  2324,  1894,  1626, -1619,   203,   945,  1772,
    1328,  3104,  1458,  1269,  2320,  1599,  2532,   550,  1541,  1542,
    2362,  2868,   685,  1955,   219,  2872,  1561,  1461,  1474,  2877,
    1964,  1965,  2217,  2209,  2097,  2363, -1576,    70,  1956, -1641,
    1908,  1973,  1975,  1811,  1969, -1621,  1835,  1303,  2736,  2737,
    2360,  3095,  2846,  1520,  1536,   343, -1090,  1322,  1553,   912,
    -938,  2066,  1515,  -938,   682,  3166,  1342,  2006,  -943,  2008,
     225,  -943,  2363,  2434,  -770,   940,  -770,  2710, -1715,  1592,
    2279,  2280,  3120,   344,  -938,  2394,  1482,    49,  2621,   921,
     549,   343,  -943,  1398,   343,  1860,  2525,  2526,   923,  2465,
    2373,  1703,  1516,  1860,  2196,  2531,  2370,  2371,  2372,  2373,
      49,  1620,   549,   549,  -183,  2360,   549,  1311,    52,   344,
      53,  2212,   344,  1728, -1654,  2498,  1276,  3129,  2082,  1638,
    1639,   549,  1304,  1733,  1336,   924,  2759,  2460,   277,  1603,
    1604,  1617,  1618,  1619,  1620,  2512,  1000,  1757,  1773,  2136,
     353,  -773,  1927,  -773,  2364,  1007, -1671,  1928,  2467,  1841,
    1895,  1930,   975,   714,  2454, -1715, -1715,   994,  2368,  2369,
    2370,  2371,  2372,  2373,  1991,  1992,   828,  2974,  1607,  1055,
   -1106,  3130,  2520,  2298,  2299,  1902,    49,  1681,  2977,   549,
    3169,  2364, -1524,  2981,  2362, -1524, -1524,  2983,  1765,  3131,
   -1524,  2365,  2366,  2367,  1343,  2368,  2369,  2370,  2371,  2372,
    2373,   549,  3109,   151,  1759,  3046,    52,  3068,  1001,    49,
     549,  1062,   549,  1756,   791,    52,  1902,    52, -1526,  3150,
    1645, -1526, -1526,   791,   661, -1576, -1526,   829, -1523,  2455,
    2761, -1523, -1523,  2547, -1621,  2938, -1523,  1059,  1821,  1692,
    1464,  2197,   918,   748,  2770,  2771,  2772,  2773,  2774,  2362,
    1000,  1820,   958,  1615,  1616,  1617,  1618,  1619,  1620, -1522,
     167,  2739, -1522, -1522,   665,   669,  1646, -1522,  1753,   716,
     797,   675,   797,  1080,   797,  1384,   662,  1091,   668,  1465,
     797,  1090,   676,   888,   341,  3110,  1767,    69,   341,   989,
    1883,  3051,  2218,  1056,  2744,  2759,  2513,   918,  3170,  2404,
    3069,  2363,  1939,  2360,  1943,  1944,   183,  1946,  1760,  1104,
     800,  1383,  1757,  1693,  1615,  1616,  1617,  1618,  1619,  1620,
    1945,  1900,  1001,  1758,  1903,   959,  1757,  2463,  2033,   959,
    3151,   709,  2514,  1803,  1378,   709,   709,  1758,  2434,  1842,
    1232,   881,  2434,  1847,  3009,   918,  2434,  2360,  1466,   163,
    2760,  3111,  2825,   901,  2416,   709,   959,   677,  1057,   203,
    1713,  2647,  2046,   752,   830,  2934,  3061,   203,  2811,  2368,
    2369,  2370,  2371,  2372,  2373,  2002,  2002,  2002,  2182,  1759,
    2002,  1855,  2405,  2149,  1761,   151,  2406,   882,  2150,  1467,
     709,   959,  2745,  1759,  2984,  2496,  2986,   959,  2813,  2761,
    2499,  2755,  2756,  3062,  1714,   902,  1233,   993,   796,  2826,
     796,  1234,   796,   343,  2625,  2814,   219,   343,   796,   796,
    2364,    49,  1720,  2002,   549,  1721,  1844,  1029,  1344,  2959,
    1256,  1926,  1712,   817,  2368,  2369,  2370,  2371,  2372,  2373,
     822,   344,   167,  2516,  2517,   344,   883, -1715,  2951,   903,
    1240,  2757,   904,  1468,   225,   709,  1862,   678,  2648,  2047,
    1878,   709,   225,  2048,  1310,  1226,  1770,  2649,  1942,   709,
     341,  2746,  1346,  1771,  2747,  2183,  1845,  2184,  2407,  2102,
    1715,  1257,  2815,  1760,  1713,  2119,  2408,  3157,   183,  1879,
      71,  2362,   839,  2049,  2960,  1314,  2781,  1760,  1722,  3039,
    3054,   878,   709,   989,  2389,  2434,  2816,   709,   902,   863,
    2434,  2309,  1257,  1885,  2434,  1258,  2827,  1041,   709,  1886,
    1887,  1888,  2632,  2402,  -778,   905,  1889,  1101,  1714,  1890,
    2917,  -802,  2817,  1103,   884,  1277,  -778,   551,   551,   872,
    1772,  1107,  2782,  2363,  1869,  2611,  1258,  2613,  2614,   203,
    2775,   661,   903,  2796,  2177,  1863,  1050,  2180,  2181,  1761,
      69,    69,   974,    69,  3040,  2828,  2437,  2438,  1277,  1027,
    -778,  1333,   998,  1761,  1239,  2644,  2918,   875,  1051,  1242,
    1384,  2031,  -802, -1332,  2797,  1822,  1823,  -778,  1050,  2050,
    1250,   665,   669,  3083,   906,  1052,  1038,   879,   219,   343,
    1373,  2663,  1080,   662,  1715,   668,   891,  3099,  1049,   549,
    2584,   341,  1356,  2818,    52,  1870,  -802,  1357,  2434,  1344,
       9,  -778,   907,  2911,  2819,  2913,  2914,   344,   905,  -778,
    1068,  1976,  2368,  2369,  2370,  2371,  2372,  2373,  2820,  3115,
    1345,  1075,   300,  3126,  3158,  2821,  2360,   709,   959,  2225,
    2226,  1493,  1358,  1824,   959,  1572,  1573,  1862,  1871,   916,
     300,  1762,  2364,  1346,  1359,   927,  2126,  1005,  2951,  1518,
    3089,  1006,  2365,  2366,  2367,  1534,  2368,  2369,  2370,  2371,
    2372,  2373,   550,  1804,    70,  2822,  3090,  1574,   709,   709,
    1479,  1596,  1555,   959,  1360,   709,   118,  1864,   785,  3018,
    1489,  1490,  1491,    49,  1825,  1826,   549,  1831,  1330,   902,
    3121,  1599,   930,   786,   122,  1832,  1600,  -778,  1580,  1385,
     721,  1872,  1533,  1873,   225,  1865,  2357,  2358,  2359,  1331,
    1587,  2375,   197,  1827,  1833,  2138,  1383,   709,  2002,  1464,
     343,  2002,  2002,  2002,  2002,  2002,  2002,  2002,  2002,  2002,
    2002,  1227,  1332,   903,   550,   550,  1863,   549,  1326,  1353,
    1455,  1456,  2889,    71,    71,  1365,    71,  1463,   344,  1247,
    1649,  1308,  2361,  1596,  2411,  1777,  2674,  2002,  2615,  1327,
    1354,  2489,    49,   725,  2999,   549,  1366,  1590,  1735,   978,
    2362,  2776,  1828,  1599,  2221,  2222,  1778,  -538,  1595,   979,
     980,   981,  2490,   982,   983,   984,   985,   986,   987,  1103,
     661,  1684,  1684,  1356,  1684,   659,  2502,  1602,  1357,  2704,
    1572,  1573,  -923,  2360,  1829,  -923,  1817,   948,   727,   905,
    1806,   949,  1361,  1810,  1812,  1603,  1604,  2503,  2730,  2705,
    1730,  1652,  2363,   950,   951,  2809,  1551,  1466,   940,  2331,
     665,   669,  1576,  1358,  2874,  1362,  2330,  2301,  1277,   946,
    1277,  2707,  1277,  2831,   952,  1359,   729,   953,  2332,   957,
     341,   341,   341,   661,  1607,  2333,   894,  1009,  2229,   709,
    2670,  2839,  1536,  2230,  3000,  1742,  -917,  1608,  1467,  -917,
    1803,   999,   549,  2461,  1809,  1360,  -943,    52,  1864,  -943,
     895,   551,  2664,  2665,  1723,  2476,  1032,   550,  1746,  2851,
    1557,   896,  1369,   665,   669,   197,   888, -1197,  3001,  2318,
    -943,   341,   875,  1033,  2319,   662,   796,   668,   341,  1036,
      69,  1037,  1278,   341,    69,  1370,   732,  3002,   733,  2508,
    2709,   126,   127,   661,  2470,  2509,  2510,   734,  2329,  2002,
    3003,  1676,  1468,  2330,  2542,  1005,   737,    70,    70,  1006,
      70,  2364,  1548,  1550,  3004,  1278,  -950,  2362,  1043,  -950,
    -551,  2365,  2366,  2367,  1053,  2368,  2369,  2370,  2371,  2372,
    2373,   954,  2340,   665,   669,  1570,   897,  2330,   989,  -920,
    -950,  1794,  -920,  1371,  1581,   662,  1039,   668,  1040,   343,
     343,   343,   763,   341,   550,   709,  1611,    49,  -908, -1524,
     549,  -908, -1524,  1564,  1634,   550,  2957,  1277,  1635,  2363,
    1615,  1616,  1617,  1618,  1619,  1620,  1795,   344,   344,   344,
    1054,  1594,  2894, -1530,   898,  1977,  1005,  1978, -1200,  1065,
    1006,  1979,  3005,  2474,  1572,  1573,   549,  1990,  1076,  3006,
     343,    52,  -953,    53,  1994,  -953,  1362,   343,   550,  1276,
    2002,  1308,   343,  1308,  2012,  1308,  2013, -1526,  1079,   549,
   -1526,  1652,  1572,  1573,  3007,   874,  1574,    52,   344,    53,
    -953,  1094,  2026,  -953,  2027,   344,   899,  1796,  1098,  2646,
     344, -1531,  2650,  2651,  2652,  2653,  2654,  2655,  2656,  2657,
    2658,  2659,  1305,  1306,  1576,  2483, -1523, -1522,   549, -1523,
   -1522,  1559,  1560,    52,   709,   709,  2716,    49,   550,  1379,
     549,   791,  2420,  1797,  2421,  1798,  1099,  2992,  2675,  1934,
   -1528, -1527,   343,    71,  2342,  1799,  1105,    71,  2364,  2330,
    2345,  2090,  1100,   661,   959,  2346,  2351,   709,  2365,  2366,
    2367,  2352,  2368,  2369,  2370,  2371,  2372,  2373,   709,  2377,
     344,  2036,   223,  1069,  2330,   224,    49,   709,  2474,   549,
    1988,  1110,  2440,   796,    52,   796,    53,  2330,  2388,   796,
    2390,  2391,  1276,   665,   669,   796,  1922,  1923,  1800,  1738,
    1306,    49,   796,  1390,   549,   662,  2360,   668,  1109,    52,
    2471,    53,   796,   341,   796,  1648,  2587,  2886,  1084,  2400,
    1086,  2588,  1088,  1855,  -906,  1419,  1801,  -906,  1089,  1103,
     796,  1596,   796,  1005,  2002,  1112,  2002,  1006,  2594,  -909,
    1958,  2726,  -909,  2595,  1597,  3059,  3060,   918,  3063,  1103,
    3064,  1599,  2606,  2422,  2093,  2423,  1600,  2607,  1472,  1111,
    2549,  2550,  2551,  2552,  2553,  1278,  3180,  1278,  3181,  1278,
    2769,   558,  2623,   709,  2551,  2552,  2553,  2624,   579,  1934,
    1942,   672,  2091,  2677,  2719,   888,  1114,  2570,  2330,  2330,
     341,   672,  2720,  2117,  2738,  2117,  2853,  2330,   550,  2607,
    2638,  2854,  2038,  -907,  2898,  1115,  -907,  2899,   661,  2607,
    2780,  1724,  2607,  2971,  3031,  1912,  1913,   579,  2854,  3032,
    2572,  2039,  1230,   341,  1882,   341,   672,   713,  2206,   709,
    2549,  2550,  2551,  2552,  2553,   579,   672,    70,  2554,   672,
    1235,    70,   343,   672,  1237,  2074,  3044,   672,   665,   669,
    2362,  2624,  1247,  1601,  -770,   551,  2002,  1602,  1924,  3179,
     662,  3048,   668,  1277,  3053,  2245,  1648,   672,   341,  2588,
     344,  1705,  3055,  1236,  1706,  1603,  1604,  2588,  2255,  1277,
    2988,    69,   672,    69,  3078,   833,   838,  1605,  2813,  1520,
    2873,   842,  2876,   857,  1243,   862,  1007,   550,  1655,  2040,
    1729,  2101,  2363,  1706,  2041,  2814,  2113,  3091,  2042,  1706,
    3093,  1606,  1648,  3124,  1607,  2588,  1244,  3155,  1648,   343,
    3187,  2855,  3156,  1245,  1278,  3156,  2928,  1608,  1249,  1609,
    2122,  2576,  1277,  1706,  1247,  1277,  1277,  1253,   918,  1255,
    2249,  2250,  2251,  2252,  1248,   978,  1251,   344,  3153,  1572,
    1573,   875,   343,  1254,   343,   979,   980,   981,  2577,   982,
     983,   984,   985,   986,   987,  1409,   796,  2578,  2334,  2766,
    2767,  1262,  2815,  2943,  2944,   978,  2228,   801,  1685,  1687,
     344,  1691,   344,  1610,  1656,   979,   980,   981,  1270,   982,
     983,   984,   985,   986,   987,  1266,  2816,   343,   796,   550,
    2043,  2477,  2478,   796,  2425,  2426,  1686,  1686,  2044,  1686,
    1267,  1291,  1293,  1271,  1272,  1273,   796,  1274,  1749,  1275,
    1282,  2364,  2817,  1285,  1287,   344,   802,  1290,  1298,  1315,
    2283,  2365,  2366,  2367,  2579,  2368,  2369,  2370,  2371,  2372,
    2373,  1316,   672,  1318,  1328,  1325,  1611, -1530,   803, -1531,
     709, -1528, -1527,  1338,  1339,   709,  1612,  1613,  1614,  1349,
    1615,  1616,  1617,  1618,  1619,  1620,   804,  1351,  1836,  1367,
    3042,  1368,   550,  1352,  1375,  1374,  1387,  1837,  1389,  1394,
    1839,  1396,  1308,  1400,    71,  2968,    71,  2970,  1398,  1437,
    2462,  1438,  1440,  1444,  -137,  1453,  1446,  1457,  1469,  1471,
    1475,  1476,  1477,  2818,  1587,   805,   796,  1478,  1524,  1527,
    1528,  1529,  1532,  1554,  2819,  2703,  1540,  2036,  1543,  1544,
    1545,  1648,  2267,  1547,  1654,  1549,   225,  2284,  2820,  1556,
    2134,  1674,  1876,  1563,  2137,  2821,  2419,   223,    49,  1566,
     224,   549,  1567,  1568,  1569,  2428,    52,  1571,    53,  2148,
    1578,  1256,  1579,  1630,  1276,  1675,  1682,  1704,  1711,  1075,
    1075,  2164,  2165,  1719,  1749,  1718,  1725,  2704,  2205,  1727,
    1731,  1307,  2175,  1734,  2473,  2822,   989,  1384,  2961,  1740,
    1741,  1743, -1475,  1745,  1750,   550,  1751,  2705,  1753,   550,
     806,  1785,  1754,   550,  1755,  2199,  1779,  1769,  2202,  2203,
    1780,  2240,  2706,  1803,  1781,  1782,   807,  3045,   687,  2707,
    1783,  1784,   808,   579,  1786,  1792,  1787,  1793,   709,  1807,
    1808,  1813,  1814,  1815,  2435,  1934,  1816,  2708,   796,  1818,
    1277,  3168,  1819,  2261,  1838,  1846,  2546,   809,  1843,   810,
    1849,  1848,  1536,  1856,  1858,  1868,   723,   550,   811,  2978,
    1892,  1551,  1906,  1557,  1564,   688,  1907,   672,   672,  1075,
    1278,   812,   813,  3024,  1980,  1898,  1909,  1915,  2360,   689,
    1910,  1918,  1920,  1931,  1947,  1938,  1278,  1932,    70,  1937,
      70,  2683,  3047,  1520,  1948,   661,   690,  1959,  2709,  2029,
    2424,  1949,  3047,   978,  2610,  1968,  1969,  1596,  1976,  2025,
     748,  2010,  2011,   979,   980,   981,  2024,   982,   983,   984,
     985,   986,   987,  2035,   691,  2032,  1981,  1277,   692,  2051,
    2053,  2076,  2087,  1277,  1277,   665,   669,  2086,  2092,  1278,
     693,  2089,  1278,  1278,   875,  2094,   882,   662,  2103,   668,
    2107,  2108,  2112,   875,  1860,   341,  2639,  2121,  2120,  2125,
    2979,   694,  2642,  2690,  2691,  2692,  2693,  3092,  2133,   300,
    1982,  2139,   300,  1983,  2141,  2142,  2143,  2710,  2608,  1277,
    2172,  2609,  2145,  2563,   796,  2147,   796,   968,   579,   972,
    2160,   558,  2174,   672,   991,   672,  2558,   300,   672,   672,
     968,   558,  2161,  2178,  2191,  1942,  2626,   695,  2173,  2201,
    2204,    49,  2207,  2213,  2210,  2214,  3029,  2215,   672,  2216,
     709,   579,  2362,   968,  2223,   558,   709,  2231,  2236,  1045,
     672,  2243,  2244,   672,  2247,   968,  2257,   558,  2262,  2263,
    2282,  2285,  2290,  1308,   672,   672,  1984,  2291,  2292,  2293,
     696,  2294,  1640,   672,  2297,   697,   579,  2327,  2308,   558,
    2328,  2343,  2344,   672,  2347,  2348,   959,   672,   672,  2349,
     558,  2353,  2356,   968,  2363,  2376,  2403,   698,   699,  2153,
    2382,  2330,  2383,  2384,   343,  2385,  2386,  2393,  2397,  2398,
     700,   672,  2585,   672,   796,   701,  2399,  1587,  2591,   672,
     796,  2409,  3085,  2415,  2418,   702,  2696,  2439,  2466,  2484,
    2518,  2480,   344,  1596,  2482,  1985,  2486,  2487,   223,    49,
    1306,   224,   549,  2505,  2570,  2519,  1597,   672,  2488,  2493,
    2494,  1108,  2673,  1599,  2529,  2571,  2530,  2523,  1600,  1721,
    1010,  1749,  2528,  2544,  2556,  2583,   579,   672,   672,   857,
    2500,   857,  2545,  2555,  2765,  1057,  2590,  2572,  2521,  2573,
    2592,  2235,  2596,  2593,  2602,   550,   550,  2597,  2601,  1011,
    2605,  2612,  2616,  2628,   550,  2617,  2629,  2636,  1533,  2633,
     802,  1012,  1308,   709,   709,  2435,  2379,  1013,  2360,  2240,
    2378,  2667,   989,  2364,  1075,  2668,  2669,  1591,  2687,  2559,
     550,  1014,   803,  2365,  2366,  2367,  2679,  2368,  2369,  2370,
    2371,  2372,  2373,  2717,  2574,  2723,  3152,  2722,  1015,  2702,
     804,  2295,   558,   558,  2725,  2721,  1297,  2729,    69,  2731,
    2733,  2734,  2740,  2741,  2742,  1601,  2751,  1278,  2753,  1602,
    2752,  2754,  2758,  2778,  2791,  2768,  1016,   672,  2785,  3178,
     672,  2793,  2799,   672,  2804,  2694,  2695,  1603,  1604,   805,
    2805,  2787,  1017,  2575,  2807,  2835,  2847,  2812,  2576,  1605,
    2838,  2848,  2841,  2842,  2843,  2845,   968,   300,  2849,  2869,
    2850,  2870,  2878,  2865,  1018,  1723,  2806,  2882,  2883,  2867,
    2881,  2892,   796,  1606,  2901,  2577,  1607,   796,   796,   796,
     796,   796,  2909,  2905,  2578,  2906,  2912,  2919,  2760,  1608,
    2922,  1609,  2923,  2924,   709,  2925,  2932,  2933,  2935,   672,
    2937,  2939,  2940,   672,  1278,  2941,  2942,   672,  2947,  1019,
    1278,  1278,   672,  2955,  2964,  2810,   709,  2956,  2958,  2965,
     968,  2966,   709,  2969,   806,  2982,  2975,  2985,   763,   550,
    2995,  2996,   968,  1460,  3010,   672,  2907,  2784,  3015,  3022,
     807,  3027,  3025,  3026,  3037,  1610,   808,  3038,   968,  3017,
    1020,  2579,  1021,  3041,  3050,  3066,  1278,  1022,  3057,  3067,
    3070,  2428,  3075,  3079,  3102,  2428,  2777,  3087,  3080,  2428,
     672,   809,  3088,   810,  3098,  3105,  3107,  3114,  3122,  1023,
    3123,  2607,   811,   672,  3104,  3103,  3137,  3148,  2786,  3127,
    3149,  3142,  1024,  1531,  2790,   812,   813,  1025,  3183,  3143,
     877,  3167,  2258,  3169,  3182,  1877,  1673,  2198,  1611,  2464,
    2168,    71,  2515,  2259,  2795,  1026,  2492,  2187,  1612,  1613,
    1614,  2743,  1615,  1616,  1617,  1618,  1619,  1620,   709,   709,
     709,   709,  2023,  2929,  2153,  2801,  2830,  2891,  3125,  3147,
    2435,  3108,  3106,  3133,  2435,  3077,  3023,  1901,  2435,  2802,
    1934,  2246,  3185,  3172,  2921,  2504,  2920,  2507,  2535,  3154,
     550,   550,  3186,  1881,   824,  1513,  1961,  2836,  2630,  1113,
    3084,  2511,  2916,  2260,   796,  2497,  2604,  3065,  1526,  2962,
    2240,  2240,  2240,  2240,  2240,  3184,  3160,  2253,  2100,   778,
    2627,  1492,  2300,   579,   579,  1596,  2524,  1238,  2472,  2832,
    2861,  2862,  2863,  2864,  2698,  2479,  1653,  1699,  1597,  1701,
    2098,  1671,  1672,  1671,  2153,  1599,  3052,  2794,  1857,  2672,
    1600,  2946,  1680,  2875,  2541,  2337,  2852,  2954,  2428,  2413,
    2075,  1652,   550,  2428,  3094,  2837,  2468,  2428,  1459,  2893,
    2124,  1300,  2967,  1736,  2123,  1710,   311,   889,  2114,  2589,
     959,  1323,   939,  2127,  2306,  1523,  1294,  2459,  2307,  2833,
    2511,  2834,  2885,  1637,   579,  2724,   558,  2156,  2153,   911,
    1707,  2302,  2131,  1933,  1302,    76,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   672,     0,     0,
       0,     0,     0,     0,     0,    70,     0,  2435,     0,     0,
       0,   857,  2435,     0,  2990,     0,  2435,  1601,     0,     0,
       0,  1602,  2637,     0,   300,     0,     0,   753,     0,     0,
       0,   991,     0,  2609,     0,     0,     0,     0,   754,  1603,
    1604,  2428,     0,  2645,     0,     0,     0,     0,     0,   857,
       0,  1605,     0,  2888,   550,     0,   755,     0,     0, -1712,
       0,   959,  1724,   709,  3177,     0,     0,     0,     0,   968,
    2666,     0,     0,   968,   756,  1606,     0,     0,  1607,     0,
     709,     0,   550,     0,   550,   550,     0,     0,   757,   550,
       0,  1608,  2680,  1609,     0,     0, -1712,     0,     0,  3134,
    3135,     0,   709,  2896,     0,   758,     0,     0, -1712,     0,
    2902,     0,  2904, -1712,     0,     0,     0,     0, -1712, -1712,
    2435, -1712,     0,   558,     0,   672,     0,     0,     0,     0,
       0,     0,     0,   759,   709,  3012,  1653,   760,   550,     0,
       0,     0, -1712,     0,   550,     0,     0,  1610,   550,   761,
       0,  3086,  1103,     0,     0,     0,     0,   558,     0, -1712,
       0,   968,     0,     0,     0,     0,   672,     0,     0,     0,
     959,     0,     0,  3096,  3043,     0,     0,  3100,     0,     0,
       0,     0,     0,     0,   672,     0,   672,   672,     0,   672,
       0,     0,     0, -1712,     0,  1952,     0,  2748,     0,     0,
       0, -1712,     0,     0,     0,   300,  3058,     0,     0,  1962,
    1611,     0,     0,     0,     0,     0,   762,  3176,     0,     0,
    1612,  1613,  1614,     0,  1615,  1616,  1617,  1618,  1619,  1620,
       0,     0,     0,     0,     0,   763,     0,   796,   796,  2350,
     300,  1430,     0,   550,     0,   991,     0,  2887,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   764,     0,   765,
       0,     0,     0,     0,   766,     0,  2789,     0,   822,     0,
       0,  1596,   959,     0,  1430,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   767,   768,     0, -1712,
       0,  1599,     0,     0,     0,     0,  1600,     0,     0,   769,
       0,     0,     0,     0,   770,   959,     0, -1712,     0,     0,
     672,     0,     0,     0,   771,     0,     0,     0,     0,     0,
    1421,     0,   772,     0,     0,     0,     0,   672,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -1712,     0,
       0, -1712, -1712, -1712,     0,     0,     0,     0,     0,     0,
    1422,     0,     0,  1421,     0,     0,  2096,     0,     0,     0,
       0,   672,  2680,     0,     0,     0,     0,     0,   550,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1422,     0,     0,     0,     0,     0,     0,
     550,  3097,     0,  1601,   550,  3101,     0,  1602,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     558,  2991,     0,  1297,     0,  1603,  1604,     0,     0,   672,
       0,     0,     0,     0,     0,     0,     0,  1605,     0,   558,
     672,     0,     0,   558,   579,   565,  1424,   672,     0,  1658,
       0,     0,   580,   672,     0,     0,     0,     0,   558,     0,
       0,     0,     0,     0,  1607,     0,     0,     0,   558,   558,
     558,   558,   672,   672,     0,   672,  2171,  1608,     0,  1424,
       0,   558,   672,     0,     0,     0,     0,     0,     0,     0,
       0,   580,     0,     0,  2188,  2189,   672,     0,   672,  2193,
     672,   672,     0,     0,   558,   672,     0,   558,   558,   580,
     580,     0,  1596,     0,     0,     0,     0,   580,     0,     0,
       0,   565,     0,     0,     0,  1597,     0,     0,     0,     0,
       0,     0,  1599,  1610,   968,   968,     0,  1600,     0,   565,
       0,   565,     0,     0,  1430,     0,     0,  2972,     0,  2242,
       0,     0,     0,     0,     0,     0,   580,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   558,     0,
    1430,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2266,     0,     0,
       0,     0,  2277,     0,     0,     0,  1611,     0,     0,  2289,
       0,     0,     0,     0,     0,     0,  1430, -1715, -1715,  2171,
    1615,  1616,  1617,  1618,  1619,  1620,     0,     0,     0,     0,
     672,     0,     0,  1421, -1714,     0,     0,  1596,     0,     0,
       0,     0,     0,  1430,  1601,     0,  2313,     0,  1602,     0,
    1597,     0,     0,     0,     0,     0,     0,  1599,     0,  1421,
       0,     0,  1600,  1422,     0,     0,  1603,  1604,  1430,     0,
       0, -1714,     0,     0,     0,     0,     0,     0,  1605,     0,
       0,     0,     0, -1714,     0,     0,     0,     0, -1714,  1422,
    2589,     0,     0, -1714, -1714,  1421, -1714,     0,     0,     0,
    1430,     0,  1606,     0,  1430,  1607,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -1714,  1608,     0,
    1609,     0,  1421,     0,  2396,  1422,   580,     0,     0,     0,
       0,     0,     0,     0, -1714,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1596,  1421,     0,  1424,
     991,     0,  1422,     0,     0,     0,     0,     0,     0,  1601,
       0,     0,     0,  1602,     0,     0,  1599,     0, -1714,     0,
       0,  1600,     0,     0,  1610,  1424, -1714,  1422,     0,  1421,
       0,  1603,  1604,  1421,     0,     0,     0,     0,     0,     0,
       0,  1671,     0,  1605,     0,     0,  1680,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   672,     0,  1422,
       0,  1424,     0,  1422,  3136,     0,     0,  1606,     0,     0,
    1607,     0,     0,     0,   579,  1430,     0,     0,     0,     0,
       0,     0,     0,  1608,     0,  1609,     0,  1611,  1424,  2401,
       0,     0,  2289,   822,     0,     0,     0,  1612,  1613,  1614,
       0,  1615,  1616,  1617,  1618,  1619,  1620,     0,     0,   558,
     672,     0,     0,  1424, -1714,     0,  3056,     0, -1715,     0,
       0,     0,  1602,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -1714,     0,     0,     0,     0,     0,     0,  1610,
    1603,  1604,     0,     0,     0,  1424,     0,   580,     0,  1424,
       0,     0, -1715,   558,  1421,     0,     0,     0,  1596,     0,
       0,     0,     0, -1714,     0,  2171, -1714, -1714, -1714,     0,
       0,  1597,     0,     0,     0,     0,     0,     0,  1599,  1607,
       0,     0,     0,  1600,  1422,     0,     0,  2242,     0,     0,
       0,     0,  1608,     0,     0,     0,     0,     0,     0,   672,
     672,   672,  1611,     0,   931,     0,     0,     0,     0,     0,
       0,     0,  1612,  1613,  1614,     0,  1615,  1616,  1617,  1618,
    1619,  1620,     0,     0,     0,     0,  2543,     0,     0,     0,
       0,   672,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   672,     0,     0,     0,     0,     0, -1715,     0,
       0,     0,     0,     0,     0,  1430,     0,     0,     0,  2619,
       0,     0,     0,     0,     0,     0,     0,     0,  1952,     0,
    1424,     0,     0,     0,     0,     0,     0,  2313,     0,     0,
    1601,     0,     0,     0,  1602,     0,     0,     0,     0,     0,
     968,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1603,  1604,     0,     0,     0,     0,     0,     0,
       0,  1611,     0,     0,  1605,     0,  1425,  1430,     0,     0,
       0,     0,  1430,     0,     0,  1615,  1616,  1617,  1618,  1619,
    1620,     0,     0,     0,  1421,     0,     0,  1430,  1606,     0,
       0,  1607,     0,     0,     0,     0,     0,     0,     0,  1425,
       0,     0,     0,     0,  1608,     0,  1609,     0,     0,     0,
       0,     0,     0,     0,  1422,     0,     0,     0,   580,   580,
       0,     0,     0,     0,     0,     0,     0,  2701,     0,     0,
       0,  2701,  2715,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1421,  1430,     0,   580,
       0,  1421,     0,   565,     0,   565,     0,   565,     0,     0,
    1610,     0,     0,   565,   565,     0,  1421,     0,     0,     0,
       0,     0,     0,   580,     0,     0,  1422,     0,     0,     0,
       0,  1422,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2289,  2289,     0,     0,  1422,     0,     0,     0,
    1424,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   672,   672,     0,
     580,   580,     0,  1611,   565,     0,  1421,     0,     0,     0,
       0,     0,     0,  1612,  1613,  1614,     0,  1615,  1616,  1617,
    1618,  1619,  1620,     0,     0,     0,     0,  2671,  2242,  2242,
    2242,  2242,  2242,     0,     0,     0,  1422,     0,     0,     0,
       0,     0,  1424,     0,     0,     0,     0,  1424,     0,     0,
     672,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     565,     0,  1424,     0,     0,     0,     0,  2266,     0,  2188,
       0,     0,  2188,     0,  2803,     0,   565,   565,     0,     0,
     345,  2171,     0,   345,     0,     0,  2289,     0,     0,     0,
       0,     0,     0,     0,     0,   581,   345,     0,     0,     0,
    2313,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   345,     0,
       0,     0,  1424,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   581,     0,     0,     0,     0,  1425,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   581,     0,     0,     0,     0,     0,     0,     0,
    1430,     0,     0,     0,     0,  1425,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2701,     0,     0,  2866,     0,
       0,  1430,     0,  1430,     0,     0,     0,     0,     0,     0,
       0,     0,  2880,     0,     0,     0,     0,  1430,     0,     0,
       0,  1425,     0,     0,     0,  2096,     0,     0,   991,     0,
    2895,     0,   558,   672,     0,     0,     0,     0,     0,   558,
     672,   558,  1430,   345,     0,     0,  2908,     0,  1425,   565,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1421,
    1430,     0,     0,     0,     0,     0,     0,  1500,     0,     0,
    1504,     0,     0,  1425,     0,     0,     0,     0,   580,     0,
    1421,     0,  1421,     0,     0,     0,     0,     0,     0,  1422,
       0,     0,     0,     0,     0,  1430,  1421,     0,     0,     0,
       0,     0,     0,     0,     0,  1425,  1430,     0,     0,  1425,
    1422,  2952,  1422,     0,  1430,     0,  1653,     0,     0,     0,
       0,  1421,     0,     0,     0,     0,  1422,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   345,     0,  1421,
       0,     0,     0,     0,     0,     0,   565,     0,     0,     0,
       0,  1422,     0,     0,     0,     0,     0,   565,     0,     0,
       0,     0,     0,     0,  2701,     0,   672,     0,  1430,  1422,
       0,     0,     0,   345,  1421,  1424,   345,     0,  2266,     0,
    2987,     0,     0,  1633,     0,  1421,     0,   580,   580,  1430,
       0,     0,     0,  1421,     0,     0,  1424,     0,  1424,     0,
     565,     0,     0,   565,  1422,   565,     0,   565,     0,     0,
       0,     0,  1424,     0,     0,  1422,  1430,     0,     0,     0,
       0,     0,     0,  1422,     0,     0,     0,     0,     0,     0,
    1425,     0,  2171,  2188,     0,     0,     0,  1424,  1430,     0,
       0,     0,     0,     0,     0,     0,   968,  1421,     0,     0,
     968,   968,     0,     0,     0,  1424,     0,     0,   580,     0,
     565,     0,     0,  1596,     0,     0,     0,     0,  1421,     0,
       0,   565,     0,     0,   672,     0,  1597,  1422,     0,     0,
       0,     0,     0,  1599,  2987,     0,     0,     0,  1600,     0,
    1424,     0,     0,     0,     0,  1421,     0,     0,  1422,     0,
       0,  1424,     0,     0,     0,     0,     0,     0,     0,  1424,
       0,     0,     0,     0,     0,     0,   672,  1421,     0,     0,
       0,   672,     0,     0,     0,  1422,     0,     0,     0,     0,
       0,  2952,   968,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1430,     0,     0,     0,  1422,     0,   672,
     581,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2289,   565,  1424,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   672,
       0,   968,     0,     0,  1424,  1601,     0,     0,     0,  1602,
       0,     0,     0,     0,     0,     0,     0,  2289,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1603,  1604,     0,
    1425,  1424,  1430,  3141,     0,     0,     0,     0,     0,  1605,
       0,     0,  1421,     0,     0,     0,     0,     0,     0,     0,
     565,     0,     0,  1424,   991,     0,     0,     0,     0,     0,
       0,     0,     0,  1606,     0,     0,  1607,     0,     0,     0,
       0,     0,  1422,     0,     0,  3141,     0,     0,     0,  1608,
       0,  1609,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1425,  1633,  1936,     0,     0,  1425,     0,     0,
       0,  3141,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1421,  1425,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   345,     0,     0,  1430,   345,
       0,     0,     0,   966,     0,  1610,     0,   966,   565,     0,
     565,  1422,     0,     0,   565,     0,     0,     0,     0,   565,
     565,     0,     0,     0,     0,     0,     0,   565,  1424,     0,
       0,  1596,     0,     0,   966,     0,     0,   565,     0,   565,
       0,     0,  1425,     0,  1597,     0,     0,     0,     0,     0,
       0,  1599,     0,     0,     0,   565,  1600,   565,     0,     0,
       0,     0,     0,     0,     0,     0,  1060,     0,  1611,   966,
       0,     0,     0,     0,     0,   966,     0,  1421,  1612,  1613,
    1614,     0,  1615,  1616,  1617,  1618,  1619,  1620,  1500,     0,
       0,     0,  2735,     0,  2084,     0,     0,  1424,     0,     0,
       0,     0,     0,     0,  1936,     0,     0,  1422,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1596,   565,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1597,     0,     0,     0,     0,     0,     0,
    1599,     0,     0,     0,     0,  1600,     0,     0,     0,     0,
       0,     0,     0,  1601,     0,     0,     0,  1602,     0,     0,
       0,  1211,     0,   581,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1430,     0,  1603,  1604,     0,     0,     0,
       0,   345,     0,     0,     0,     0,     0,  1605,   565,     0,
       0,     0,     0,  1424,   565,     0,     0,     0,     0,     0,
       0,     0,     0,   580,     0,     0,     0,     0,     0,     0,
       0,  1606,     0,     0,  1607,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1608,     0,  1609,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1601,     0,     0,     0,  1602,     0,     0,     0,
       0,     0,  1421,     0,     0,     0,     0,   565,     0,     0,
     565,   565,     0,     0,  1603,  1604,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1425,  1605,     0,     0,     0,
       0,     0,  1422,  1610,  1596,     0,     0,     0,     0,     0,
       0,   565,     0,     0,     0,     0,  1425,  1597,  1425,     0,
    1606,     0,     0,  1607,  1599,     0,  1430,   565,     0,  1600,
       0,   565,  1425,     0,     0,   565,  1608,     0,  1609,     0,
       0,  1211,   345,   565,     0,     0,   966,     0,   565,     0,
       0,     0,   966,     0,     0,     0,     0,  1425,     0,     0,
       0,   565,     0,     0,     0,     0,  1611,     0,  1435,     0,
       0,     0,     0,     0,     0,  1425,  1612,  1613,  1614,     0,
    1615,  1616,  1617,  1618,  1619,  1620,     0,     0,  1424,   565,
    2844,   966,  1610,     0,     0,     0,     0,     0,     0,     0,
       0,  1435,     0,     0,     0,  1421,     0,     0,     0,     0,
    1425,     0,     0,     0,   580,  1500,     0,     0,  2305,     0,
    1504,  1425,     0,     0,     0,     0,  1601,     0,     0,  1425,
    1602,     0,     0,     0,     0,  1422,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1603,  1604,
    1430,   565,   718,     0,     0,  1611,  1211,     0,     0,     0,
    1605,     0,     0,   719,     0,  1612,  1613,  1614,     0,  1615,
    1616,  1617,  1618,  1619,  1620,     0,     0,  1427,  1211,  2860,
       0,   720,     0,  1425,  1606,     0,     0,  1607,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   721,     0,  -429,
    1608,     0,  1211,  1211,  1425,  1211,  1211,  1211,     0,  1430,
    1427,     0,     0,   722,     0,     0,     0,     0,     0,   723,
       0,  1424,  1596,     0,     0,  1211,     0,     0,     0,  1421,
     724,  1425,     0,     0,     0,  1597,     0,     0,     0,     0,
       0,     0,  1599,     0,     0,     0,     0,  1600,     0,     0,
     581,   581,     0,  1425,     0,     0,  1610,     0,     0,  1422,
     725,     0,   726,     0,     0,     0,  1660,     0,     0,     0,
    1936,     0,     0,   565,  -538,   565,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1421,     0,
    1211,     0,     0,  1211,  1211,  -361,     0,     0,     0,     0,
       0,   345,   345,   345,     0,   727,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1422,  1611,
       0,   581,     0,     0,     0,     0,     0,     0,     0,  1612,
    1613,  1614,     0,  1615,  1616,  1617,  1618,  1619,  1620,     0,
       0,   728,     0,   729,  1601,  1424,     0,     0,  1602,     0,
       0,     0,   345,     0,     0,     0,     0,     0,  1425,   345,
    -361,  1435,   565,     0,   345,     0,  1603,  1604,   565,   565,
       0,     0,     0,     0,     0,     0,     0,     0,  1605,     0,
       0,     0,     0,     0,   730,     0,     0,  1435,     0,  -265,
       0,     0,     0,     0,     0,     0,     0,   565,   565,     0,
       0,     0,  1606,     0,  1424,  1607,   565,     0,     0,     0,
       0,  -265,   731,   732,   565,   733,     0,     0,  1608,   565,
    1609,   565,     0,  1435,   734,     0,     0,  1425,   735,   736,
       0,   565,   565,   737,   345,     0,     0,     0,     0,   738,
       0,     0,     0,     0,  1596,     0,     0,     0,     0,     0,
    1435,     0,     0,     0,     0,     0,     0,  1597,     0,     0,
       0,     0,     0,     0,  1599,     0,     0,     0,     0,  1600,
    1427,     0,     0,     0,  1610,  1435,   580,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1427,     0,     0,     0,
       0,     0,     0,     0,     0,  1211,     0,  1435,     0,     0,
       0,  1435,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1425,     0,     0,     0,     0,     0,   565,
       0,     0,  1427,     0,     0,   565,     0,  1611,     0,     0,
       0,     0,   966,     0,     0,     0,     0,  1612,  1613,  1614,
       0,  1615,  1616,  1617,  1618,  1619,  1620,     0,     0,  1427,
       0,  3014,     0,     0,     0,     0,  1601,     0,  1211,  1211,
    1602,     0,     0,     0,     0,     0,  1211,     0,     0,  1211,
    1211,   565,     0,     0,  1427,     0,     0,     0,  1603,  1604,
       0,     0,  1989,     0,     0,     0,     0,     0,     0,  1211,
    1605,   667,     0,  1211,  1211,  1211,     0,  1211,     0,     0,
       0,     0,     0,     0,  1211,  1211,  1427,     0,     0,     0,
    1427,     0,     0,   667,  1606,     0,     0,  1607,     0,     0,
       0,     0,  1435,  1211,   345,     0,  1211,  1211,     0,     0,
    1608,  1211,  1609,     0,     0,  1211,     0,     0,  1211,  1211,
    1211,  1211,  1211,  1211,  1211,  1211,  1211,     0,  1211,     0,
       0,     0,  1211,     0,     0,     0,  1211,    78,     0,     0,
       0,     0,     0,    82,     0,     0,     0,     0,     0,     0,
       0,    88,     0,    89,     0,     0,    92,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1610,   102,  1425,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   345,   565,   565,     0,   115,   116,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   565,   667,     0,
       0,     0,   565,   565,   565,   565,   565,     0,     0,     0,
       0,  1427,   124,     0,   345,     0,   345,     0,     0,     0,
       0,   125,   126,   127,     0,     0,     0,     0,     0,  1611,
       0,     0,     0,     0,     0,   876,     0,     0,     0,  1612,
    1613,  1614,     0,  1615,  1616,  1617,  1618,  1619,  1620,     0,
       0,  2522,     0,   136,   565,   137,   138,     0,     0,   345,
     140,   141,     0,     0,     0,     0,     0,   143,   144,  2305,
       0,     0,     0,  1211,     0,     0,     0,     0,     0,   146,
       0,   147,  2159,     0,   150,     0,     0,     0,     0,     0,
     151,     0,     0,     0,     0,     0,     0,     0,   152,     0,
       0,  1425,     0,   153,     0,     0,     0,     0,   154,     0,
     156,     0,     0,     0,   158,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   162,     0,   163,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1211,  1435,     0,     0,   167,     0,  1435,
       0,     0,     0,     0,  1596,     0,     0,     0,     0,     0,
       0,     0,  1211,     0,  1435,     0,     0,     0,     0,   175,
     176,     0,     0,   177,  1599,  1936,   565,     0,     0,  1600,
     178,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1427,     0,   183,     0,     0,     0,     0,     0,   565,
       0,     0,     0,     0,   565,     0,   565,   565,     0,     0,
       0,   565,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   193,     0,  1435,  1425,     0,     0,     0,     0,
       0,     0,     0,   195,     0,   196,     0,     0,     0,   197,
       0,     0,     0,   198,  1596,   200,     0,  2410,     0,   202,
       0,     0,     0,  1427,   203,  1211,     0,  1597,  1427,   204,
     565,  2104,   206,     0,  1599,     0,   565,     0,   209,  1600,
     565,     0,     0,  1427,     0,  1211, -1715,     0,     0,     0,
    1602,     0,     0,     0,  1425,     0,     0,     0,     0,     0,
       0,     0,     0,   215,     0,   216,     0,     0,  1603,  1604,
       0,   218,     0,   219,  1211,  1211,  1211,   220,     0,  1211,
   -1715,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1211,  1211,  1211,  1211,     0,  2105,     0,     0,     0,
    1211,     0,     0,  1427,     0,     0,     0,  1607,     0,     0,
       0,  1211,     0,     0,     0,     0,     0,     0,     0,   225,
    1608,     0,  1211,  1211,     0,  1211,     0,     0,     0,  1211,
       0,     0,     0,     0,     0,   565,  1601,     0,     0,     0,
    1602,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   966,     0,  1211,  1211,     0,     0,  1603,  1604,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1605,     0,     0,     0,     0,     0, -1715,     0,     0,  1211,
       0,     0,     0,     0,     0,     0,  1211,  1211,  1211,     0,
       0,     0,     0,     0,  1606,     0,     0,  1607,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1608,     0,  1609,     0,     0,  1211,     0,     0,     0,   564,
       0,     0,     0,     0,     0,     0,     0,  1435,     0,     0,
     667,     0,     0,     0,     0,     0,     0,     0,   963,  1611,
       0,     0,   963,     0,     0,     0,     0,     0,  1435,     0,
    1435,     0,     0,  1615,  1616,  1617,  1618,  1619,  1620,     0,
     565,     0,     0,     0,  1435,     0,  1610,     0,     0,   963,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   565,     0,     0,     0,   565,     0,     0,  1435,
       0,     0,     0,     0,     0,   799,     0,     0,     0,     0,
       0,     0,     0,     0,   963,     0,   345,  1435,     0,  2106,
     963,     0,     0,   564,     0,   799,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1611,
       0,     0,   565,   565,     0,     0,  1427,   565,     0,  1612,
    1613,  1614,  1435,  1615,  1616,  1617,  1618,  1619,  1620,     0,
       0,     0,     0,  1435,     0,     0,     0,  1427,     0,  1427,
       0,  1435,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1427,     0,     0,     0,     0,     0,   565,
       0,     0,     0,     0,   966,     0,     0,     0,     0,  1428,
       0,     0,     0,     0,     0,     0,  1206,     0,  1427,     0,
       0,     0,     0,     0,     0,   565,  1211,     0,     0,     0,
       0,     0,  1211,     0,     0,  1435,  1427,     0,     0,     0,
       0,     0,  1428,     0,  1211,     0,  1211,     0,     0,     0,
    1211,     0,     0,     0,     0,     0,  1435,  1211,     0,     0,
    1211,  1211,  1211,  1211,  1211,  1211,  1211,  1211,  1211,  1211,
       0,  1427,     0,     0,  1211,  1211,     0,     0,     0,     0,
       0,     0,  1427,  1435,     0,     0,     0,     0,  1211,     0,
    1427,     0,     0,     0,     0,  1211,  1211,  1211,     0,  1211,
       0,     0,     0,     0,     0,  1435,  1211,  1596,     0,     0,
       0,  1211,     0,     0,  1211,     0,     0,     0,     0,     0,
    1597,     0,     0,   966,     0,     0,     0,  1599,     0,     0,
       0,     0,  1600,     0,     0,     0,     0,     0,  1596,     0,
       0,     0,     0,     0,  1427,     0,     0,     0,     0,     0,
       0,  1597,     0,     0,     0,     0,     0,     0,  1599,     0,
       0,     0,     0,  1600,     0,  1427,  1211,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1206,   667,     0,     0,
       0,   963,     0,     0,     0,     0,     0,   963,     0,     0,
       0,     0,  1427,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1433,     0,     0,     0,     0,     0,     0,
    1435,     0,     0,     0,  1427,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   963,     0,     0,  1601,
       0,     0,     0,  1602,     0,     0,  1433,     0,     0,     0,
       0,     0,     0,     0,  2378,     0,     0,     0,     0,  2379,
       0,  1603,  1604,     0,     0,     0,     0,     0,     0,     0,
    1601,     0,     0,  1605,  1602,     0,     0,     0,  1211,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1435,
       0,     0,  1603,  1604,     0,     0,     0,  1606,     0,     0,
    1607,  1206,     0,     0,  1605,     0,     0,     0,     0,     0,
       0,     0,  1428,  1608,     0,  1609,     0,     0,     0,     0,
       0,     0,     0,  1206,     0,     0,     0,     0,  1606,  1427,
    1211,  1607,     0,     0,     0,     0,     0,     0,  1428,     0,
    1211,     0,     0,     0,  1608,     0,  1609,  1206,  1206,     0,
    1206,  1206,  1206,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1610,
    1206,     0,     0,     0,  1428,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1435,     0,     0,     0,  1211,
    1211,  1211,     0,     0,  1211,     0,     0,     0,  1427,     0,
    1610,  1428,     0,     0,     0,     0,     0,     0,   966,     0,
       0,     0,   966,     0,     0,     0,   966,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1428,     0,     0,     0,
       0,     0,  1611,     0,     0,  1206,     0,     0,  1206,  1206,
       0,     0,  1612,  1613,  1614,     0,  1615,  1616,  1617,  1618,
    1619,  1620,     0,     0,     0,     0,  3082,     0,  1428,     0,
       0,     0,  1428,  1611,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1612,  1613,  1614,     0,  1615,  1616,  1617,
    1618,  1619,  1620,     0,  1211,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1427,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1433,     0,     0,   667,
       0,     0,     0,     0,     0,     0,     0,     0,   966,     0,
       0,  1596,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1433,     0,  1597,     0,     0,  1598,     0,     0,
       0,  1599,     0,     0,  1211,     0,  1600,   799,     0,   799,
       0,   799,     0,  1211,     0,  1211,     0,   799,   799,     0,
    1435,     0,     0,     0,  1211,     0,     0,     0,  1433,     0,
       0,     0,     0,     0,     0,   966,     0,     0,     0,   667,
     966,     0,     0,  1428,   966,     0,     0,     0,  1211,  1211,
       0,     0,     0,     0,     0,  1433,     0,     0,  1211,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1211,     0,     0,   564,     0,
    1433,     0,     0,     0,     0,     0,     0,     0,     0,   966,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1601,     0,     0,     0,  1602,     0,     0,
    1206,     0,  1433,     0,  1211,     0,  1433,     0,     0,     0,
       0,     0,     0,     0,     0,  1603,  1604,     0,     0,  1427,
       0,     0,     0,     0,  1281,  1211,     0,  1605,     0,     0,
       0,     0,     0,  1596,  1211,     0,     0,   963,   966,     0,
     564,   564,     0,  1435,     0,     0,  1597,     0,     0,  2339,
       0,  1606,     0,  1599,  1607,     0,     0,  1281,  1600,     0,
       0,     0,     0,  1206,  1206,     0,     0,  1608,     0,  1609,
       0,  1206,     0,     0,  1206,  1206,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   966,     0,
       0,     0,     0,     0,  1206,     0,     0,     0,  1206,  1206,
    1206,     0,  1206,     0,     0,     0,     0,     0,     0,  1206,
    1206,     0,  1211,  1428,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1610,     0,     0,     0,  1433,  1206,   667,
       0,  1206,  1206,     0,     0,     0,  1206,     0,     0,     0,
    1206,     0,     0,  1206,  1206,  1206,  1206,  1206,  1206,  1206,
    1206,  1206,  1427,  1206,     0,  1601,     0,  1206,     0,  1602,
       0,  1206,     0,     0,     0,     0,     0,  1435,     0,     0,
       0,     0,     0,     0,     0,  1428,     0,  1603,  1604,     0,
    1428,     0,     0,     0,     0,     0,  1611,  1596,     0,  1605,
     966,     0,     0,   564,     0,  1428,  1612,  1613,  1614,     0,
    1615,  1616,  1617,  1618,  1619,  1620,     0,  1599,     0,     0,
       0,     0,  1600,  1606,     0,     0,  1607,     0,     0,     0,
       0,     0,     0,   966,     0,     0,  1435,     0,     0,  1608,
       0,  1609,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1428,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1427,     0,     0,     0,
       0,     0,     0,     0,   667,  1610,     0,     0,     0,     0,
     564,     0,     0,     0,     0,     0,     0,     0,  1206,     0,
       0,   564,     0,     0,     0,     0,     0,  2157,     0,  1601,
       0,     0,     0,  1602,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1603,  1604,     0,     0,  1427,     0,     0,     0,     0,
       0,     0,     0,  1605,   564,     0,     0,  1281,  1611,  1281,
       0,  1281,     0,     0,     0,     0,     0,     0,  1612,  1613,
    1614,     0,  1615,  1616,  1617,  1618,  1619,  1620,  1206,  1433,
    1607,     0,     0,     0,  1433,     0,     0,     0,     0,     0,
       0,     0,     0,  1608,     0,     0,     0,  1206,     0,  1433,
       0,     0,     0,     0,     0,     0,     0,     0,   671,     0,
       0,     0,     0,     0,   564,     0,     0,     0,   673,     0,
       0,     0,     0,     0,     0,   799,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1429,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1610,
       0,     0,     0,   706,     0,     0,     0,     0,     0,  1433,
       0,     0,     0,   747,     0,     0,   751,     0,     0,     0,
     747,     0,  1429,     0,   795,     0,     0,     0,     0,     0,
       0,     0,     0,  1596,     0,     0,     0,     0,     0,     0,
    1206,     0,     0,     0,   825,     0,  1597,     0,  1428,     0,
       0,     0,     0,  1599,     0,     0,     0,     0,  1600,   747,
    1206,     0,  1611,     0,     0,     0,  1281,     0,     0,  1428,
       0,  1428,  1612,  1613,  1614,     0,  1615,  1616,  1617,  1618,
    1619,  1620,     0,     0,     0,  1428,     0,     0,     0,  1206,
    1206,  1206,     0,     0,  1206,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1206,  1206,  1206,  1206,
    1428,     0,     0,     0,     0,  1206,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1206,     0,  1428,     0,
       0,     0,     0,     0,   564,     0,     0,  1206,  1206,     0,
    1206,     0,     0,     0,  1206,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1601,     0,     0,     0,  1602,
       0,     0,     0,  1428,     0,     0,     0,   963,     0,  1206,
    1206,     0,     0,     0,  1428,     0,     0,  1603,  1604,     0,
       0,     0,  1428,     0,     0,     0,     0,     0,     0,  1605,
       0,     0,     0,     0,  1206,     0,     0,     0,     0,     0,
       0,  1206,  1206,  1206,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1606,     0,     0,  1607,     0,     0,   917,
       0,     0,   799,     0,   799,     0,     0,     0,   799,  1608,
    1206,  1609,     0,   564,   799,     0,  1428,     0,     0,     0,
       0,   799,  1433,     0,     0,     0,     0,     0,     0,     0,
       0,   799,     0,   799,     0,     0,     0,  1428,     0,     0,
       0,     0,     0,  1433,     0,  1433,     0,     0,     0,   799,
       0,   799,     0,     0,     0,     0,     0,     0,     0,  1433,
       0,     0,  1429,     0,  1428,  1610,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1433,     0,  1428,     0,  1429,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   667,  1433,     0,     0,     0,     0,     0,  2341,     0,
       0,     0,     0,     0,     0,   564,     0,     0,     0,     0,
       0,     0,     0,     0,  1429,     0,     0,     0,  1611,     0,
       0,     0,     0,     0,     0,     0,     0,  1433,  1612,  1613,
    1614,     0,  1615,  1616,  1617,  1618,  1619,  1620,  1433,     0,
       0,  1429,     0,     0,     0,     0,  1433,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1429,     0,     0,   963,
       0,     0,  1281,     0,     0,     0,     0,     0,   564,     0,
       0,  1428,     0,  1596,     0,     0,     0,     0,  1281,     0,
       0,  1206,     0,     0,     0,     0,     0,  1206,  1429,     0,
    1433,     0,  1429,  1599,   925,   926,     0,     0,  1600,  1206,
       0,  1206,     0,     0,     0,  1206,     0,     0,     0,     0,
       0,  1433,  1206,     0,     0,  1206,  1206,  1206,  1206,  1206,
    1206,  1206,  1206,  1206,  1206,     0,     0,     0,     0,  1206,
    1206,  1281,     0,     0,  1281,  1281,     0,     0,  1433,     0,
    1428,     0,     0,  1206,     0,     0,     0,     0,     0,     0,
    1206,  1206,  1206,     0,  1206,     0,     0,     0,     0,     0,
    1433,  1206,     0,  1596,     0,   799,  1206,     0,     0,  1206,
       0,     0,     0,     0,     0,     0,  1597,     0,   963,     0,
       0,   564,     0,  1599,     0,   564,     0,     0,  1600,   564,
       0,     0,     0,     0,     0,  1601,     0,   799,     0,  1602,
       0,     0,   799,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1429,     0,   799,     0,  1603,  1604,     0,
     976,  1206,   992,     0,     0,   995,   996,     0,     0,  1605,
       0,     0,     0,     0,     0,     0,  1428,     0,     0,     0,
       0,     0,     0,   564,     0,  1031,     0,     0,     0,     0,
       0,     0,     0,  1606,     0,     0,  1607,  1046,     0,     0,
    1047,     0,     0,     0,     0,  1433,     0,     0,     0,  1608,
       0,   917,   747,     0,     0,     0,     0,     0,     0,   961,
    1064,     0,     0,   961,     0,  1601,     0,     0,     0,  1602,
    1071,     0,     0,     0,  1072,  1073,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   799,     0,  1603,  1604,     0,
     961,     0,     0,     0,     0,     0,     0,     0,  1092,  1605,
    1093,     0,     0,  1206,     0,  1610,   917,     0,     0,     0,
       0,     0,     0,     0,  1433,     0,     0,     0,     0,     0,
       0,     0,     0,  1606,     0,   961,  1607,     0,     0,     0,
       0,   961,     0,     0,  1106,     0,     0,     0,     0,  1608,
       0,  1609,     0,     0,     0,     0,     0,     0,     0,     0,
    2354,     0,     0,     0,   917,  1206,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1206,     0,     0,  1611,     0,
       0,     0,     0,  1429,     0,     0,     0,     0,  1612,  1613,
    1614,     0,  1615,  1616,  1617,  1618,  1619,  1620,     0,     0,
       0,  1428,     0,     0,     0,  1610,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   799,     0,  1281,
    1433,     0,     0,     0,  1206,  1206,  1206,  1203,     0,  1206,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   963,     0,  1429,     0,   963,     0,     0,
    1429,   963,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1317,  1429,     0,  1319,  1611,     0,
    1321,     0,     0,     0,     0,     0,     0,     0,  1612,  1613,
    1614,     0,  1615,  1616,  1617,  1618,  1619,  1620,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1281,     0,     0,     0,
       0,     0,  1281,  1281,     0,     0,     0,     0,     0,  1206,
       0,     0,     0,     0,     0,  1429,     0,     0,     0,     0,
       0,     0,     0,     0,  1428,     0,  1392,     0,     0,     0,
    1393,   564,   564,     0,  1395,     0,     0,     0,     0,  1436,
     564,     0,     0,   963,     0,     0,     0,     0,  1281,     0,
       0,     0,     0,   799,     0,   799,     0,     0,     0,     0,
       0,     0,  1462,     0,     0,  2561,   564,     0,     0,  1206,
       0,     0,     0,     0,     0,     0,     0,  1203,  1206,     0,
    1206,     0,   961,     0,     0,  1433,     0,     0,   961,  1206,
       0,  1432,     0,     0,     0,     0,     0,  1494,     0,     0,
     963,  1596,     0,     0,  1431,   963,     0,     0,     0,   963,
    1522,     0,     0,  1206,  1206,     0,     0,     0,     0,     0,
       0,  1599,     0,  1206,  1432,     0,  1600,   961,     0,     0,
       0,     0,     0,     0,     0,     0,  1596,  1431,     0,     0,
    1206,     0,     0,     0,     0,     0,     0,     0,  1428,  1597,
       0,     0,  2387,     0,   963,     0,  1599,     0,     0,     0,
       0,  1600,     0,   799,     0,     0,     0,     0,     0,   799,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1206,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1203,     0,  2684,     0,     0,     0,     0,     0,
    1206,     0,     0,     0,     0,     0,     0,  1428,     0,  1206,
       0,     0,     0,   963,  1203,   564,     0,     0,  1433,     0,
       0,     0,     0, -1715,     0,     0,     0,  1602,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1203,  1203,
       0,  1203,  1203,  1203,     0,  1603,  1604,     0,  1429,     0,
       0,     0,     0,     0,     0,     0,     0, -1715,  1601,     0,
       0,  1203,  1602,   963,     0,     0,     0,     0,     0,  1429,
       0,  1429,     0,     0,     0,     0,     0,     0,     0,     0,
    1603,  1604,     0,     0,  1607,  1429,     0,  1206,     0,     0,
       0,     0,  1605,     0,     0,     0,     0,  1608,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1429,     0,     0,     0,     0,     0,  1606,     0,     0,  1607,
       0,     0,     0,     0,  1744,     0,  1203,     0,  1429,  1203,
    1203,     0,  1608,     0,  1609,     0,     0,     0,     0,     0,
       0,     0,  1433,     0,     0,     0,   564,   564,     0,     0,
       0,     0,     0, -1715,     0,     0,     0,     0,     0,     0,
       0,   799,     0,  1429,     0,   963,   799,   799,   799,   799,
     799,     0,     0,     0,  1429,     0,     0,     0,     0,     0,
       0,     0,  1429,     0,  1432,     0,     0,     0,  1610,     0,
       0,     0,     0,     0,  1596,     0,     0,  1431,   963,     0,
       0,  1433,     0,     0,     0,     0,     0,  1597,     0,     0,
    1432,     0,     0,     0,  1599,     0,  1611,     0,   564,  1600,
       0,     0,     0,  1431,     0,     0,     0,     0,     0,     0,
    1615,  1616,  1617,  1618,  1619,  1620,  1429,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1432,     0,     0,     0,
       0,  1611,  1891,     0,     0,     0,     0,  1429,     0,  1431,
       0,  1612,  1613,  1614,     0,  1615,  1616,  1617,  1618,  1619,
    1620,     0,     0,  1432,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1429,     0,  1431,     0,     0,     0,
       0,     0,     0,  1929,     0,     0,     0,     0,  1432,     0,
       0,     0,     0,     0,     0,  2392,  1429,     0,     0,     0,
       0,  1431,     0,     0,     0,     0,  1601,     0,     0,     0,
    1602,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1432,     0,     0,     0,  1432,     0,     0,     0,  1603,  1604,
     564,  1203,     0,  1431,     0,     0,     0,  1431,     0,     0,
    1605,     0,     0,     0,     0,     0,  1596,     0,     0,     0,
       0,     0,     0,   799,     0,     0,     0,     0,   564,  1597,
     564,   564,     0,     0,  1606,   564,  1599,  1607,   961,     0,
       0,  1600,     0,     0,     0,     0,     0,     0,     0,     0,
    1608,     0,  1609,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1203,  1203,     0,     0,     0,     0,
       0,  1429,  1203,     0,     0,  1203,  1203,     0,     0,     0,
       0,     0,     0,     0,   564,     0,     0,     0,     0,     0,
     564,     0,     0,     0,   564,  1203,     0,  2083,     0,  1203,
    1203,  1203,     0,  1203,     0,     0,  1610,     0,     0,     0,
    1203,  1203,     0,     0,  2088,  1432,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1431,  1203,
       0,     0,  1203,  1203,     0,     0,     0,  1203,  1601,     0,
    1429,  1203,  1602,     0,  1203,  1203,  1203,  1203,  1203,  1203,
    1203,  1203,  1203,     0,  1203,     0,     0,     0,  1203,     0,
    1603,  1604,  1203,     0,     0,     0,     0,     0,     0,  1611,
       0,     0,  1605,     0,     0,     0,     0,     0,  1596,  1612,
    1613,  1614,     0,  1615,  1616,  1617,  1618,  1619,  1620,   564,
       0,  1597,     0,     0,     0,     0,  1606,     0,  1599,  1607,
       0,     0,     0,  1600,     0,     0,   917,     0,     0,     0,
       0,     0,  1608,     0,  1609,     0,     0,  2135,     0,     0,
       0,     0,     0,     0,  2140,     0,     0,     0,     0,     0,
    2144,     0,     0,     0,     0,     0,  1429,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2166,
    2167,     0,  2169,     0,     0,     0,     0,     0,     0,  2176,
       0,     0,     0,     0,     0,     0,     0,     0,  1610,     0,
       0,     0,  1596,  2190,     0,  2192,     0,  2194,  2195,     0,
       0,     0,  2200,     0,     0,     0,     0,  2634,     0,     0,
       0,     0,  1599,     0,     0,  2155,     0,  1600,     0,  1203,
    1601,     0,     0,     0,  1602,     0,     0,     0,  2154,     0,
       0,     0,     0,     0,   564,     0,     0,     0,     0,  1596,
       0,     0,  1603,  1604,     0,     0,     0,     0,     0,     0,
       0,  1611,     0,     0,  1605,     0,   564,     0,     0,  1599,
     564,  1612,  1613,  1614,  1600,  1615,  1616,  1617,  1618,  1619,
    1620,     0,     0,     0,     0,     0,     0,  1432,  1606,     0,
       0,  1607,  1432,     0,     0,  2685,     0,     0,     0,  1203,
    1431,     0,     0,     0,  1608,  1431,  1609,  1432,     0,     0,
       0,     0,     0,     0,     0,     0,   799,   799,  1203,     0,
    1431,     0,     0,     0, -1715,     0,     0,   917,  1602,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1429,  2688,     0,     0,     0,  1603,  1604,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -1715,     0,
    1610,     0,     0,     0,     0,     0,     0,  1432,     0,     0,
       0, -1715,     0,     0,     0,  1602,     0,     0,     0,     0,
    1431,     0,     0,     0,     0,  1607,     0,     0,     0,     0,
       0,     0,     0,  1603,  1604,     0,     0,     0,  1608,     0,
       0,     0,     0,     0,     0, -1715,     0,     0,     0,     0,
       0,  1203,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1611,     0,     0,     0,     0,     0,     0,
       0,  1203,  1607,  1612,  1613,  1614,     0,  1615,  1616,  1617,
    1618,  1619,  1620,     0,     0,  1608,     0,     0,     0,     0,
       0,     0,     0,     0, -1715,     0,     0,     0,     0,     0,
    1203,  1203,  1203,     0,     0,  1203,     0,     0,     0,     0,
       0,     0,     0,     0,  1429,     0,     0,  1203,  1203,  1203,
    1203,     0,     0,     0,     0,     0,  1203,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1203,     0,     0,
       0, -1715,     0,     0,     0,     0,     0,     0,  1203,  1203,
       0,  1203,     0,     0,     0,  1203,     0,  1611,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1615,  1616,  1617,  1618,  1619,  1620,     0,   961,     0,
    1203,  1203,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2501,     0,     0,
       0,     0,     0,     0,  1611,  1203,  1596,     0,     0,     0,
       0,     0,  1203,  1203,  1203,     0,     0,     0,  1615,  1616,
    1617,  1618,  1619,  1620,     0,     0,  1599,     0,     0,     0,
       0,  1600,     0,     0,     0,     0,     0,     0,  1429,     0,
    2155,  1203,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1431,     0,     0,     0,     0,     0,     0,
       0,  1432,     0,  1432,   964,     0,     0,     0,   964,     0,
       0,     0,     0,     0,  1431,     0,  1431,  1432,     0,     0,
       0,     0,     0,     0,     0,     0,  2565,  2567,  2569,     0,
    1431,     0,     0,     0,     0,   964,     0,  1429,     0,  2858,
       0,     0,  1432,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1431,     0,     0,  2600,     0,
    2155,     0,     0,     0,     0,     0,     0,     0, -1715,   747,
     964,     0,  1602,  1431,     0,     0,   964,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1603,  1604,     0,     0,     0,  1432,     0,     0,     0,     0,
       0,     0, -1715,     0,     0,     0,  1432,     0,  1431,     0,
       0,     0,     0,     0,  2155,     0,     0,     0,     0,  1431,
       0,     0,     0,     0,     0,     0,     0,  1431,     0,  1607,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1608,     0,     0,     0,     0,     0,     0,     0,
     961,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1207,     0,     0,     0,     0,     0,  1432,     0,
       0,     0,  1203,     0,     0,     0,     0,     0,  1203,     0,
       0,  1431,     0,     0,     0,     0,     0,     0,     0,  1432,
    1203,     0,  1203,     0,     0,     0,  1203,     0, -1715,     0,
       0,     0,  1431,  1203,     0,     0,  1203,  1203,  1203,  1203,
    1203,  1203,  1203,  1203,  1203,  1203,  1432,     0,     0,     0,
    1203,  1203,     0,     0,     0,     0,     0,     0,     0,  1431,
       0,     0,     0,     0,  1203,     0,     0,     0,  1432,     0,
       0,  1203,  1203,  1203,     0,  1203,     0,     0,     0,     0,
       0,  1431,  1203,     0,     0,     0,     0,  1203,     0,     0,
    1203,  1611,     0,     0,     0,     0,     0,     0,     0,   961,
       0,     0,     0,     0,     0,  1615,  1616,  1617,  1618,  1619,
    1620,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2749,  2750,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1203,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1207,     0,     0,     0,     0,   964,     0,     0,
       0,     0,     0,   964,  1185,     0,     0,     0,     0,     0,
       0,     0,     0,  1432,     0,     0,     0,  2779,     0,  1434,
       0,     0,     0,     0,     0,     0,  1431,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   964,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1434,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1432,     0,  1203,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1431,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1207,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1207,
       0,     0,     0,     0,     0,     0,  1203,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1203,     0,     0,     0,
       0,     0,     0,  1207,  1207,     0,  1207,  1207,  1207,     0,
       0,     0,     0,     0,  1380,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1207,     0,  1432,     0,
    2897,     0,     0,     0,     0,     0,     0,  2903,     0,     0,
       0,  1431,     0,     0,     0,  1203,  1203,  1203,     0,     0,
    1203,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   961,     0,     0,     0,   961,     0,
       0,     0,   961,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1207,     0,     0,  1207,  1207,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1538,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1203,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1562,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1434,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   961,  1583,  1584,     0,  1585,  1586,
    1588,     0,     0,     0,     0,     0,     0,     0,  1434,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1624,     0,
    1203,     0,     0,  1432,     0,     0,     0,     0,     0,  1203,
       0,  1203,     0,     0,     0,     0,  1431,     0,     0,     0,
    1203,     0,     0,     0,  1434,     0,     0,     0,     0,     0,
       0,   961,     0,     0,     0,     0,   961,     0,     0,     0,
     961,     0,     0,     0,  1203,  1203,     0,     0,     0,     0,
       0,  1434,     0,     0,  1203,     0,     0,     0,     0,     0,
       0,     0,     0,  1690,     0,     0,  1696,  1698,     0,     0,
       0,  1203,     0,     0,     0,     0,  1434,     0,     0,     0,
       0,     0,     0,     0,     0,   961,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1207,     0,  1434,     0,
    1203,     0,  1434,  3074,     0,     0,     0,     0,  3076,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1203,     0,     0,     0,     0,  1432,     0,     0,     0,
    1203,     0,     0,   964,   961,     0,     0,     0,     0,  1431,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1207,
    1207,     0,     0,     0,     0,     0,  3119,  1207,     0,     0,
    1207,  1207,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   961,     0,     0,     0,     0,     0,
    1207,     0,     0,     0,  1207,  1207,  1207,     0,  1207,     0,
       0,     0,     0,     0,     0,  1207,  1207,     0,  1203,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1434,  1207,     0,     0,  1207,  1207,     0,
       0,     0,  1207,     0,     0,     0,  1207,     0,     0,  1207,
    1207,  1207,  1207,  1207,  1207,  1207,  1207,  1207,     0,  1207,
    1432,     0,     0,  1207,     0,     0,     0,  1207,     0,     0,
       0,     0,     0,  1431,     0,     0,     0,     0,  1916,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   961,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1432,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   961,
       0,     0,  1431,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1972,
       0,     0,     0,  1974,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1993,     0,     0,     0,  1996,     0,     0,     0,
    2007,     0,     0,     0,     0,     0,     0,  2014,  2019,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1207,     0,  2030,     0,     0,     0,
    2034,     0,     0,  2158,  2045,     0,     0,     0,  2052,     0,
       0,  2054,  2055,  2056,  2057,  2058,  2059,  2060,  2061,  2062,
       0,  2063,     0,     0,     0,  1185,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1207,  1434,     0,     0,     0,     0,
    1434,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1207,     0,  1434,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1434,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2146,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1207,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1207,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1207,  1207,  1207,     0,     0,
    1207,     0,     0,     0,     0,     0,  2211,     0,     0,     0,
       0,     0,  1207,  1207,  1207,  1207,     0,     0,     0,     0,
       0,  1207,     0,     0,     0,  2232,     0,     0,     0,     0,
       0,     0,  1207,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1207,  1207,     0,  1207,     0,     0,     0,
    1207,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   964,     0,  1207,  1207,     0,     0,     0,
       0,     0,     0,  1622,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1207,     0,     0,     0,     0,     0,     0,  1207,  1207,  1207,
       0,     0,     0,     0,     0,     0,     0,     0,  2315,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1207,     0,  2335,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1434,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1434,
       0,  1434,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2019,  1434,  2019,  2019,     0,     0,
       0,     0,     0,  2395,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1434,     0,     0,     0,     0,     0,  2412,     0,  2414,     0,
       0,     0,  2417,     0,     0,     0,     0,     0,  1434,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1434,     0,     0,     0,     0,     0,     0,
       0,     0,  1690,     0,  1434,     0,     0,     0,  1622,  1698,
    1698,  1696,  1434,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   964,     0,     0,  2491,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1207,     0,     0,
       0,     0,     0,  1207,     0,     0,  1434,     0,     0,     0,
       0,     0,     0,     0,     0,  1207,     0,  1207,     0,     0,
       0,  1207,     0,     0,     0,     0,     0,  1434,  1207,     0,
       0,  1207,  1207,  1207,  1207,  1207,  1207,  1207,  1207,  1207,
    1207,     0,     0,     0,     0,  1207,  1207,     0,     0,     0,
       0,     0,     0,     0,  1434,     0,     0,     0,     0,  1207,
       0,     0,     0,     0,     0,     0,  1207,  1207,  1207,     0,
    1207,     0,     0,     0,     0,     0,  1434,  1207,     0,     0,
       0,     0,  1207,     0,     0,  1207,     0,     0,     0,     0,
       0,     0,     0,     0,   964,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1622,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1622,     0,     0,     0,     0,     0,  2003,  1207,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1622,  1622,  1622,  1622,     0,  1622,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2003,  2631,
       0,     0,     0,     0,     0,  2635,     0,     0,     0,     0,
       0,  1434,     0,     0,     0,     0,     0,  2640,     0,  2641,
       0,     0,  1622,  2643,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2660,  2661,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1207,
    2676,     0,  2678,     0,     0,     0,     0,     0,     0,  2682,
    1434,     0,     0,     0,  2686,     0,     0,  2689,  1622,     0,
       0,     0,     0,     0,  1622,     0,  1622,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1207,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1207,     0,     0,     0,     0,     0,     0,     0,  2728,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1434,     0,     0,     0,
    1207,  1207,  1207,     0,     0,  1207,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   964,
       0,     0,     0,   964,     0,     0,     0,   964,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1207,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2315,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2840,     0,     0,     0,     0,     0,   964,
       0,     0,     0,     0,  1622,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1207,     0,     0,     0,     0,
       0,     0,     0,     0,  1207,     0,  1207,     0,     0,     0,
       0,  1434,     0,  2856,  2857,  1207,     0,  2859,     0,     0,
       0,  1622,     0,     0,     0,     0,   964,     0,     0,     0,
    1622,   964,  1622,     0,     0,   964,     0,     0,     0,  1207,
    1207,     0,     0,     0,     0,     0,     0,     0,     0,  1207,
       0,  1622,     0,     0,  1622,     0,  2003,  2003,  2003,  2374,
       0,  2003,     0,     0,     0,  1622,  1207,     0,     0,     0,
       0,     0,  1622,     0,     0,     0,     0,  1622,     0,     0,
     964,     0,     0,     0,     0,     0,     0,     0,  1622,     0,
       0,  2374,  1622,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1622,  2003,  1207,     0,  2927,     0,     0,
    1622,     0,  1622,  1622,  1622,  1622,  1622,  1622,  1622,  1622,
    1622,  1622,     0,     0,     0,     0,  1207,     0,     0,     0,
       0,     0,     0,     0,     0,  1207,     0,     0,     0,   964,
       0,     0,     0,     0,  1434,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2315,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2973,     0,   964,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1622,     0,     0,     0,     0,     0,
       0,     0,  2989,  1207,     0,     0,     0,     0,     0,     0,
       0,  2993,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2998,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1434,  1622,
       0,     0,     0,     0,     0,     0,     0,  3030,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1622,   964,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3049,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   964,     0,     0,  1434,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1622,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2993,     0,     0,     0,     0,
       0,     0,     0,  1622,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2374,  2374,  2374,     0,  2003,
       0,     0,  2003,  2003,  2003,  2003,  2003,  2003,  2003,  2003,
    2003,  2003,     0,  2374,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1622,     0,     0,     0,     0,  2003,     0,
       0,     0,     0,     4,     0,     0,     0,     0,     0,  2374,
    1622,     0,  1622,     0,     0,  1622,     0,     0,     5,     0,
       0,     0,     0,     0,     0,     0,     0,     6,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     7,     8,
       0,     0,     0,     0,     9,     0,    10,    11,     0,     0,
       0,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     4,     0,     0,     0,  1622,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     6,
       0,     0,     0,    36,     0,     0,     0,     0,     0,     0,
       7,     8,     0,     0,     0,     0,     0,     0,    10,    11,
       0,     0,     0,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2003,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      37,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    36,    38,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    39,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1622,
       0,     0,     0,  1622,     0,     0,     0,     0,  1622,  1622,
      40,  1622,     0,    41,  2374,     0,     0,     0,  2374,  2374,
    2374,  2374,  2374,  2374,  2374,  2374,  2374,  2374,  1622,  1622,
      42,     0,    37,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2374,  1622,     0,  1622,     0,    38,     0,
    1622,  2003,     0,     0,  1622,     0,     0,  1622,     0,     0,
       0,     0,     0,     0,     0,    39,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    43,     0,     0,     0,
       0,     0,    40,     0,     0,    41,  1622,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    42,     0,     0,     0,     0,     0,     0,    44,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    45,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    46,     0,     0,     0,  2374,     0,
       0,     0,     0,     0,     0,    47,     0,     0,    48,    49,
       0,    50,     0,    51,     0,     0,     0,    52,    43,    53,
      54,     0,     0,     0,    55,    56,    57,    58,    59,     0,
       0,    60,    61,    62,    63,     0,    64,    65,    66,    67,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    44,     0,     0,     0,     0,     0,     0,  1622,     0,
       0,     0,     0,     0,    45,  2003,     0,  2003,     0,     0,
       0,     0,     0,  2374,  1622,  1622,    46,  1622,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,     0,     0,
      48,    49,     0,    50,     0,     0,     0,     0,     0,    52,
       0,    53,    54,     0,     0,     0,    55,    56,    57,    58,
      59,     0,     0,    60,    61,   932,     0,     0,     0,   933,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1622,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2374,  2003,  2374,     0,
       0,  1622,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1622,     0,     0,
       0,  1622,     0,     0,     0,     0,  1622,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1622,     0,
     582,    79,    80,    81,   354,     0,    83,    84,     0,    85,
      86,    87,   355,  2374,   356,     0,    91,  1622,    93,    94,
      95,    96,    97,    98,   583,    99,   100,   101,   357,   584,
       0,   103,   104,   105,   106,   585,   586,     0,   108,   109,
     110,     0,   111,   587,   588,   114,   358,   359,     0,     0,
       0,   360,   361,     0,     0,     0,     0,   362,     0,     0,
       0,     0,     0,     0,     0,     0,   363,     0,   364,     0,
     365,   366,     0,   367,   368,   369,   370,   371,   372,   373,
     589,   374,   375,   590,   591,   592,   593,   594,   595,   596,
     376,   377,   378,   129,   379,   380,   381,   131,   132,   133,
     134,     0,   597,   382,   383,     0,   384,   598,   599,   385,
     600,   135,   387,   601,   388,   389,   390,   391,   139,   602,
     603,   392,   393,   394,   604,   395,   396,   142,   397,   605,
     398,   399,   145,   400,   606,   607,   608,   609,   401,   402,
     403,   404,   405,   148,   149,   406,   610,   407,   611,   408,
       0,   409,   410,   411,   612,   613,   614,   412,   413,   414,
     415,   615,   416,   417,   616,   418,   617,   419,   420,   421,
     155,   422,     0,   157,   618,   423,   424,   159,   619,   425,
     620,   426,   160,   621,   161,   427,     0,   428,   622,   623,
     429,   624,   430,   431,   164,   432,   433,   434,   625,   435,
     436,   437,   438,   626,   165,   166,   627,   439,   440,   441,
     628,   168,   629,   169,   630,     0,   170,   171,   442,   172,
     443,   444,   445,   446,   447,   631,   173,   448,   174,   632,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   179,   180,   181,   633,   462,   463,   464,
     465,   182,   634,   466,   467,   184,   468,   635,   185,   186,
     469,   470,   636,   637,   471,   638,   639,   640,   472,   473,
     641,   642,   187,   188,   189,   190,   474,   475,   476,     0,
     191,   192,   477,   478,   643,   479,   480,   481,   482,   483,
     484,   194,   485,   644,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   496,   199,   497,   201,   498,   499,
     500,   501,   502,   503,     0,   645,   504,   505,   506,   646,
     507,   205,   508,   509,   207,   510,   208,   647,   511,   512,
     513,   514,   515,   516,   517,   518,   210,   519,   648,   520,
     521,   522,   523,   649,   211,   212,   650,   525,   651,   526,
     213,   527,   214,   652,   528,   529,   530,   531,   532,   653,
     654,   533,   534,   535,   536,   537,   655,   656,   538,   539,
     540,   221,   541,   222,   542,     0,   657,   658,   543,   544,
     545,   546,   547,   548,     0,   223,     0,     0,   224,     0,
       0,    79,    80,    81,     0,     0,    83,    84,     0,    85,
      86,    87,     0,     0,     0,    90,    91,     0,    93,    94,
      95,    96,    97,    98,   659,    99,   100,   101,     0,     0,
       0,   103,   104,   105,   106,     0,   107,     0,   108,   109,
     110,     0,   111,   112,   113,   114,     0,     0,     0,     0,
       0,   117,   118,     0,     0,     0,     0,   119,     0,     0,
       0,     0,     0,     0,     0,     0,   120,     0,   121,     0,
     122,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   129,     0,     0,     0,   131,   132,   133,
     134,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   135,     0,     0,     0,     0,     0,     0,   139,     0,
       0,     0,     0,     0,     0,     0,     0,   142,     0,     0,
       0,     0,   145,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   148,   149,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     155,     0,     0,   157,     0,     0,     0,   159,     0,     0,
       0,     0,   160,     0,   161,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   164,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   165,   166,     0,     0,     0,     0,
       0,   168,     0,   169,     0,     0,   170,   171,     0,   172,
       0,     0,     0,     0,     0,     0,   173,     0,   174,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   179,   180,   181,     0,     0,     0,     0,
       0,   182,     0,     0,     0,   184,     0,     0,   185,   186,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   187,   188,   189,   190,     0,     0,     0,     0,
     191,   192,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   194,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   199,     0,   201,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   205,     0,     0,   207,     0,   208,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   210,     0,     0,     0,
       0,     0,     0,     0,   211,   212,     0,     0,     0,     0,
     213,     0,   214,     0,     0,     0,     0,     0,     0,   217,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   221,     0,   222,     0,     0,     0,     0,     0,     0,
       0,    79,    80,    81,     0,   223,    83,    84,   224,    85,
      86,    87,     0,     0,     0,    90,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,     0,     0,
       0,   103,   104,   105,   106,  2116,   107,     0,   108,   109,
     110,     0,   111,   112,   113,   114,     0,     0,     0,     0,
       0,   117,   118,     0,     0,     0,     0,   119,     0,     0,
       0,     0,     0,     0,     0,     0,   120,     0,   121,     0,
     122,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   129,     0,     0,     0,   131,   132,   133,
     134,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   135,     0,     0,     0,     0,     0,     0,   139,     0,
       0,     0,     0,     0,     0,     0,     0,   142,     0,     0,
       0,     0,   145,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   148,   149,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     155,     0,     0,   157,     0,     0,     0,   159,     0,     0,
       0,     0,   160,     0,   161,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   164,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   165,   166,     0,     0,     0,     0,
       0,   168,     0,   169,     0,     0,   170,   171,     0,   172,
       0,     0,     0,     0,     0,     0,   173,     0,   174,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   179,   180,   181,     0,     0,     0,     0,
       0,   182,     0,     0,     0,   184,     0,     0,   185,   186,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   187,   188,   189,   190,     0,     0,     0,     0,
     191,   192,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   194,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   199,     0,   201,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   205,     0,     0,   207,     0,   208,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   210,     0,     0,     0,
       0,     0,     0,     0,   211,   212,     0,     0,     0,     0,
     213,     0,   214,     0,     0,     0,     0,     0,     0,   217,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   221,     0,   222,     0,     0,     0,     0,    78,     0,
       0,    79,    80,    81,    82,   223,    83,    84,   224,    85,
      86,    87,    88,     0,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   102,     0,
       0,   103,   104,   105,   106,  2118,   107,     0,   108,   109,
     110,     0,   111,   112,   113,   114,   115,   116,     0,     0,
       0,   117,   118,     0,     0,     0,     0,   119,     0,     0,
       0,     0,     0,     0,     0,     0,   120,     0,   121,     0,
     122,   123,     0,   124,     0,     0,     0,     0,     0,     0,
       0,     0,   125,   126,   127,     0,     0,     0,     0,     0,
       0,     0,   128,   129,     0,     0,   130,   131,   132,   133,
     134,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   135,     0,     0,   136,     0,   137,   138,   139,     0,
       0,   140,   141,     0,     0,     0,     0,   142,   143,   144,
       0,     0,   145,     0,     0,     0,     0,     0,     0,     0,
     146,     0,   147,   148,   149,   150,     0,     0,     0,     0,
       0,   151,     0,     0,     0,     0,     0,     0,     0,   152,
       0,     0,     0,     0,   153,     0,     0,     0,     0,   154,
     155,   156,     0,   157,     0,   158,     0,   159,     0,     0,
       0,     0,   160,     0,   161,     0,   162,     0,   163,     0,
       0,     0,     0,     0,   164,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   165,   166,     0,     0,   167,     0,
       0,   168,     0,   169,     0,     0,   170,   171,     0,   172,
       0,     0,     0,     0,     0,     0,   173,     0,   174,     0,
     175,   176,     0,     0,   177,     0,     0,     0,     0,     0,
       0,   178,     0,   179,   180,   181,     0,     0,     0,     0,
       0,   182,     0,     0,   183,   184,     0,     0,   185,   186,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   187,   188,   189,   190,     0,     0,     0,     0,
     191,   192,     0,   193,     0,     0,     0,     0,     0,     0,
       0,   194,     0,     0,   195,     0,   196,     0,     0,     0,
     197,     0,     0,     0,   198,   199,   200,   201,     0,     0,
     202,     0,     0,     0,     0,   203,     0,     0,     0,     0,
     204,   205,     0,   206,   207,     0,   208,     0,     0,   209,
       0,     0,     0,     0,     0,     0,   210,     0,     0,     0,
       0,     0,     0,     0,   211,   212,     0,     0,     0,     0,
     213,     0,   214,     0,   215,     0,   216,     0,     0,   217,
       0,     0,   218,     0,   219,     0,     0,     0,   220,     0,
       0,   221,     0,   222,     0,     0,     0,     0,     0,     0,
     582,    79,    80,    81,   354,   223,    83,    84,   224,    85,
      86,    87,   355,     0,   356,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   583,    99,   100,   101,   357,   584,
     225,   103,   104,   105,   106,   585,   586,     0,   108,   109,
     110,     0,   111,   587,   588,   114,   358,   359,     0,     0,
       0,   360,   361,     0,     0,     0,     0,   362,     0,     0,
       0,     0,     0,     0,     0,     0,   363,     0,   364,     0,
     365,   366,     0,   367,   368,   369,   370,   371,   372,   373,
    2078,   374,   375,     0,     0,     0,     0,  1116,     0,     0,
     376,   377,   378,   129,   379,   380,   381,   131,  1117,   133,
    1118,  1119,     0,   382,   383,     0,   384,  1120,  1121,   385,
    1122,  1123,   387,     0,   388,   389,   390,   391,  1124,     0,
       0,   392,   393,   394,     0,   395,   396,  1125,   397,     0,
     398,   399,   145,   400,  1126,  1127,  1128,  1129,   401,   402,
     403,   404,   405,  1130,  1131,   406,     0,   407,     0,   408,
       0,   409,   410,   411,     0,  2079,     0,   412,  1132,   414,
     415,     0,   416,   417,     0,   418,     0,   419,   420,   421,
    1133,   422,     0,  1134,  1135,   423,   424,  1136,     0,   425,
       0,   426,   160,     0,   161,   427,     0,   428,     0,     0,
     429,     0,   430,   431,   164,   432,   433,   434,     0,   435,
     436,   437,   438,     0,   165,   166,     0,   439,   440,   441,
    1137,  1138,     0,  1139,     0,     0,   170,   171,   442,   172,
     443,   444,   445,   446,   447,     0,   173,   448,   174,     0,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,  1140,   180,  1141,   707,   462,   463,   464,
     465,   182,  1142,   466,   467,   184,   468,  1143,  1144,  1145,
     469,   470,     0,     0,   471,   708,     0,     0,  1146,   473,
       0,     0,   187,   188,   189,  1147,   474,   475,   476,     0,
    1148,   192,   477,   478,     0,   479,   480,   481,   482,   483,
     484,  1149,   485,     0,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   496,   199,   497,  1150,   498,   499,
     500,   501,   502,   503,     0,     0,   504,   505,   506,  1151,
     507,   205,   508,   509,   207,   510,  1152,     0,   511,   512,
     513,   514,   515,   516,   517,   518,  1153,   519,     0,   520,
     521,   522,   523,     0,  1154,  1155,     0,   525,     0,   526,
    1156,   527,  1157,  1158,   528,   529,   530,   531,   532,     0,
    1159,   533,   534,   535,   536,   537,  1160,     0,   538,   539,
     540,  1161,   541,   222,   542,     0,     0,     0,   543,   544,
     545,   546,   547,   548,     0,   223,    49,  1162,   224,   549,
       0,     0,  1163,  1164,    52,  1165,    53,     0,     0,     0,
       0,  1166,  1167,  2080,     0,  1169,  1170,     0,     0,     0,
    1171,  2081,   582,    79,    80,    81,   354,     0,    83,    84,
       0,    85,    86,    87,   355,     0,   356,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   583,    99,   100,   101,
     357,   584,     0,   103,   104,   105,   106,   585,   586,     0,
     108,   109,   110,     0,   111,   587,   588,   114,   358,   359,
       0,     0,     0,   360,   361,     0,     0,     0,     0,   362,
       0,     0,     0,     0,     0,     0,     0,     0,   363,     0,
     364,     0,   365,   366,     0,   367,   368,   369,   370,   371,
     372,   373,     0,   374,   375,     0,     0,     0,     0,  1116,
       0,     0,   376,   377,   378,   129,   379,   380,   381,   131,
    1117,   133,  1118,  1119,     0,   382,   383,     0,   384,  1120,
    1121,   385,  1122,  1123,   387,     0,   388,   389,   390,   391,
    1124,     0,     0,   392,   393,   394,     0,   395,   396,  1125,
     397,     0,   398,   399,   145,   400,  1126,  1127,  1128,  1129,
     401,   402,   403,   404,   405,  1130,  1131,   406,     0,   407,
       0,   408,     0,   409,   410,   411,     0,     0,     0,   412,
    1132,   414,   415,     0,   416,   417,     0,   418,     0,   419,
     420,   421,  1133,   422,     0,  1134,  1135,   423,   424,  1136,
       0,   425,     0,   426,   160,     0,   161,   427,     0,   428,
       0,     0,   429,     0,   430,   431,   164,   432,   433,   434,
       0,   435,   436,   437,   438,     0,   165,   166,     0,   439,
     440,   441,  1137,  1138,     0,  1139,     0,     0,   170,   171,
     442,   172,   443,   444,   445,   446,   447,     0,   173,   448,
     174,     0,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,  1140,   180,  1141,   707,   462,
     463,   464,   465,   182,  1142,   466,   467,   184,   468,  1143,
    1144,  1145,   469,   470,     0,     0,   471,   708,     0,     0,
    1146,   473,     0,     0,   187,   188,   189,  1147,   474,   475,
     476,     0,  1148,   192,   477,   478,     0,   479,   480,   481,
     482,   483,   484,  1149,   485,     0,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,   496,   199,   497,  1150,
     498,   499,   500,   501,   502,   503,     0,     0,   504,   505,
     506,  1151,   507,   205,   508,   509,   207,   510,  1152,     0,
     511,   512,   513,   514,   515,   516,   517,   518,  1153,   519,
       0,   520,   521,   522,   523,     0,  1154,  1155,     0,   525,
       0,   526,  1156,   527,  1157,  1158,   528,   529,   530,   531,
     532,     0,  1159,   533,   534,   535,   536,   537,  1160,     0,
     538,   539,   540,  1161,   541,   222,   542,     0,     0,     0,
     543,   544,   545,   546,   547,   548,     0,   223,    49,  1162,
     224,   549,     0,     0,  1163,  1164,    52,  1165,    53,     0,
       0,     0,     0,  1166,  1167,     0,     0,  1169,  1170,     0,
       0,     0,  1171,  2005,    79,    80,    81,   354,     0,    83,
      84,     0,    85,    86,    87,   355,     0,   356,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   357,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   358,
     359,     0,     0,     0,   360,   361,     0,     0,     0,     0,
     362,     0,     0,     0,     0,     0,     0,     0,     0,   363,
       0,   364,     0,   365,   366,     0,   367,   368,   369,   370,
     371,   372,   373,     0,   374,   375,     0,     0,     0,     0,
       0,     0,     0,   376,   377,   378,     0,   379,   380,   381,
       0,   132,     0,   134,     0,     0,   382,   383,     0,   384,
       0,     0,   385,   386,   135,   387,     0,   388,   389,   390,
     391,   139,     0,     0,   392,   393,   394,     0,   395,   396,
     142,   397,     0,   398,   399,     0,   400,     0,     0,     0,
       0,   401,   402,   403,   404,   405,   148,   149,   406,     0,
     407,     0,   408,     0,   409,   410,   411,     0,     0,     0,
     412,   413,   414,   415,     0,   416,   417,     0,   418,     0,
     419,   420,   421,   155,   422,     0,   157,     0,   423,   424,
     159,     0,   425,     0,   426,     0,     0,     0,   427,     0,
     428,     0,     0,   429,     0,   430,   431,     0,   432,   433,
     434,     0,   435,   436,   437,   438,     0,     0,   166,     0,
     439,   440,   441,     0,   168,     0,   169,     0,     0,     0,
       0,   442,     0,   443,   444,   445,   446,   447,     0,     0,
     448,     0,     0,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   179,     0,   181,     0,
     462,   463,   464,   465,   182,     0,   466,   467,     0,   468,
       0,   185,   186,   469,   470,     0,     0,   471,     0,     0,
       0,   472,   473,     0,     0,   187,     0,     0,   190,   474,
     475,   476,     0,   191,   192,   477,   478,     0,   479,   480,
     481,   482,   483,   484,   194,   485,     0,   486,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,     0,   497,
     201,   498,   499,   500,   501,   502,   503,     0,     0,   504,
     505,   506,     0,   507,   205,   508,   509,     0,   510,   208,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   210,
     519,     0,   520,   521,   522,   523,     0,   211,   212,     0,
     525,     0,   526,   213,   527,   214,     0,   528,   529,   530,
     531,   532,     0,     0,   533,   534,   535,   536,   537,     0,
    3033,   538,   539,   540,   221,   541,     0,   542,     4,     0,
       0,   543,   544,   545,   546,   547,   548,     0,   223,     0,
       0,   224,     0,     5,     0,     0,     0,     0,     0,     0,
       0,     0,     6,     0,     0,     0,     0,     0,     0,     0,
       0, -1186,     0,     7,     8, -1186,     0,     0,     0,     0,
       0,    10,    11,     0,     0,     0,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
       0,     0,     0,     0,     0,     4,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     6,
       0,     0,     0,     0,     0,     0,     0,     0,    36,     0,
       7,     8,     0,     0,     0,     0,     0,     0,    10,    11,
       0,     0,     0,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    37,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    36,     0,     0,     0,     0,
       0,    38,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    39,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    40,     0,     0,    41,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    37,     0,     0,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    38,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    39,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    43,    40,     0,     0,    41,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    45,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,    48,    49,     0,    50,     0,    43,     0,
       0,     0,    52,     0,    53,    54,     0,     0,     0,    55,
      56,    57,    58,    59,     0,     0,    60,    61,   932,  1301,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    44,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    45,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,     0,     0,
      48,    49,     0,    50,     0,     0,     0,     0,     0,    52,
       0,    53,    54,     0,     0,     0,    55,    56,    57,    58,
      59,     0,     0,    60,    61,   932,  1737,   582,    79,    80,
      81,   354,     0,    83,    84,     0,    85,    86,    87,   355,
       0,   356,     0,    91,     0,    93,    94,    95,    96,    97,
      98,   583,    99,   100,   101,   357,   584,     0,   103,   104,
     105,   106,   585,   586,     0,   108,   109,   110,     0,   111,
     587,   588,   114,   358,   359,     0,     0,     0,   360,   361,
       0,     0,     0,     0,   362,     0,     0,     0,     0,     0,
       0,     0,     0,   363,     0,   364,     0,   365,   366,     0,
     367,   368,   369,   370,   371,   372,   373,     0,   374,   375,
       0,     0,     0,     0,  1116,     0,     0,   376,   377,   378,
     129,   379,   380,   381,   131,  1117,   133,  1118,  1119,  2015,
     382,   383,     0,   384,  1120,  1121,   385,  1122,  1123,   387,
       0,   388,   389,   390,   391,  1124,     0,     0,   392,   393,
     394,     0,   395,   396,  1125,   397,     0,   398,   399,   145,
     400,  1126,  1127,  1128,  1129,   401,   402,   403,   404,   405,
    1130,  1131,   406,     0,   407,     0,   408,     0,   409,   410,
     411,     0,     0,     0,   412,  1132,   414,   415,     0,   416,
     417,     0,   418,     0,   419,   420,   421,  1133,   422,     0,
    1134,  1135,   423,   424,  1136,     0,   425,     0,   426,   160,
    2016,   161,   427,     0,   428,     0,     0,   429,     0,   430,
     431,   164,   432,   433,   434,     0,   435,   436,   437,   438,
       0,   165,   166,     0,   439,   440,   441,  1137,  1138,     0,
    1139,     0,     0,   170,   171,   442,   172,   443,   444,   445,
     446,   447,  2017,   173,   448,   174,     0,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
    1140,   180,  1141,   707,   462,   463,   464,   465,   182,  1142,
     466,   467,   184,   468,  1143,  1144,  1145,   469,   470,     0,
       0,   471,   708,     0,     0,  1146,   473,     0,     0,   187,
     188,   189,  1147,   474,   475,   476,     0,  1148,   192,   477,
     478,     0,   479,   480,   481,   482,   483,   484,  1149,   485,
       0,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   199,   497,  1150,   498,   499,   500,   501,   502,
     503,     0,     0,   504,   505,   506,  1151,   507,   205,   508,
     509,   207,   510,  1152,     0,   511,   512,   513,   514,   515,
     516,   517,   518,  1153,   519,     0,   520,   521,   522,   523,
       0,  1154,  1155,     0,   525,  2018,   526,  1156,   527,  1157,
    1158,   528,   529,   530,   531,   532,     0,  1159,   533,   534,
     535,   536,   537,  1160,     0,   538,   539,   540,  1161,   541,
     222,   542,     0,     0,     0,   543,   544,   545,   546,   547,
     548,     0,   223,    49,  1162,   224,   549,     0,     0,  1163,
    1164,    52,  1165,    53,     0,     0,     0,     0,  1166,  1167,
       0,     0,  1169,  1170,     0,     0,     0,  1171,   582,    79,
      80,    81,   354,     0,    83,    84,     0,    85,    86,    87,
     355,     0,   356,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   583,    99,   100,   101,   357,   584,     0,   103,
     104,   105,   106,   585,   586,     0,   108,   109,   110,     0,
     111,   587,   588,   114,   358,   359,     0,     0,     0,   360,
     361,     0,     0,     0,     0,   362,     0,     0,     0,     0,
       0,     0,     0,     0,   363,     0,   364,     0,   365,   366,
       0,   367,   368,   369,   370,   371,   372,   373,     0,   374,
     375,     0,     0,     0,     0,  1116,     0,     0,   376,   377,
     378,   129,   379,   380,   381,   131,  1117,   133,  1118,  1119,
       0,   382,   383,     0,   384,  1120,  1121,   385,  1122,  1123,
     387,     0,   388,   389,   390,   391,  1124,     0,     0,   392,
     393,   394,     0,   395,   396,  1125,   397,     0,   398,   399,
     145,   400,  1126,  1127,  1128,  1129,   401,   402,   403,   404,
     405,  1130,  1131,   406,     0,   407,     0,   408,     0,   409,
     410,   411,     0,     0,     0,   412,  1132,   414,   415,     0,
     416,   417,     0,   418,     0,   419,   420,   421,  1133,   422,
       0,  1134,  1135,   423,   424,  1136,     0,   425,     0,   426,
     160,     0,   161,   427,     0,   428,     0,     0,   429,     0,
     430,   431,   164,   432,   433,   434,     0,   435,   436,   437,
     438,     0,   165,   166,     0,   439,   440,   441,  1137,  1138,
       0,  1139,     0,     0,   170,   171,   442,   172,   443,   444,
     445,   446,   447,     0,   173,   448,   174,     0,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,  1140,   180,  1141,   707,   462,   463,   464,   465,   182,
    1142,   466,   467,   184,   468,  1143,  1144,  1145,   469,   470,
       0,     0,   471,   708,     0,     0,  1146,   473,     0,     0,
     187,   188,   189,  1147,   474,   475,   476,     0,  1148,   192,
     477,   478,     0,   479,   480,   481,   482,   483,   484,  1149,
     485,     0,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,   199,   497,  1150,   498,   499,   500,   501,
     502,   503,     0,     0,   504,   505,   506,  1151,   507,   205,
     508,   509,   207,   510,  1152,     0,   511,   512,   513,   514,
     515,   516,   517,   518,  1153,   519,     0,   520,   521,   522,
     523,     0,  1154,  1155,     0,   525,     0,   526,  1156,   527,
    1157,  1158,   528,   529,   530,   531,   532,     0,  1159,   533,
     534,   535,   536,   537,  1160,     0,   538,   539,   540,  1161,
     541,   222,   542,     0,     0,     0,   543,   544,   545,   546,
     547,   548,     0,   223,    49,  1162,   224,   549,     0,     0,
    1163,  1164,    52,  1165,    53,     0,     0,     0,     0,  1166,
    1167,  1168,     0,  1169,  1170,     0,     0,     0,  1171,   582,
      79,    80,    81,   354,     0,    83,    84,     0,    85,    86,
      87,   355,     0,   356,     0,    91,     0,    93,    94,    95,
      96,    97,    98,   583,    99,   100,   101,   357,   584,     0,
     103,   104,   105,   106,   585,   586,     0,   108,   109,   110,
       0,   111,   587,   588,   114,   358,   359,     0,     0,     0,
     360,   361,     0,     0,     0,     0,   362,     0,     0,     0,
       0,     0,     0,     0,     0,   363,     0,   364,     0,   365,
     366,     0,   367,   368,   369,   370,   371,   372,   373,     0,
     374,   375,     0,     0,     0,     0,  1116,     0,     0,   376,
     377,   378,   129,   379,   380,   381,   131,  1117,   133,  1118,
    1119,     0,   382,   383,     0,   384,  1120,  1121,   385,  1122,
    1123,   387,     0,   388,   389,   390,   391,  1124,     0,     0,
     392,   393,   394,     0,   395,   396,  1125,   397,     0,   398,
     399,   145,   400,  1126,  1127,  1128,  1129,   401,   402,   403,
     404,   405,  1130,  1131,   406,     0,   407,     0,   408,     0,
     409,   410,   411,     0,     0,     0,   412,  1132,   414,   415,
       0,   416,   417,     0,   418,     0,   419,   420,   421,  1133,
     422,     0,  1134,  1135,   423,   424,  1136,     0,   425,     0,
     426,   160,     0,   161,   427,     0,   428,     0,     0,   429,
       0,   430,   431,   164,   432,   433,   434,     0,   435,   436,
     437,   438,     0,   165,   166,     0,   439,   440,   441,  1137,
    1138,     0,  1139,     0,     0,   170,   171,   442,   172,   443,
     444,   445,   446,   447,     0,   173,   448,   174,     0,   449,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   461,  1140,   180,  1141,   707,   462,   463,   464,   465,
     182,  1142,   466,   467,   184,   468,  1143,  1144,  1145,   469,
     470,     0,     0,   471,   708,     0,     0,  1146,   473,     0,
       0,   187,   188,   189,  1147,   474,   475,   476,     0,  1148,
     192,   477,   478,     0,   479,   480,   481,   482,   483,   484,
    1149,   485,     0,   486,   487,   488,   489,   490,   491,   492,
     493,   494,   495,   496,   199,   497,  1150,   498,   499,   500,
     501,   502,   503,     0,   203,   504,   505,   506,  1151,   507,
     205,   508,   509,   207,   510,  1152,     0,   511,   512,   513,
     514,   515,   516,   517,   518,  1153,   519,     0,   520,   521,
     522,   523,     0,  1154,  1155,     0,   525,     0,   526,  1156,
     527,  1157,  1158,   528,   529,   530,   531,   532,     0,  1159,
     533,   534,   535,   536,   537,  1160,     0,   538,   539,   540,
    1161,   541,   222,   542,     0,     0,     0,   543,   544,   545,
     546,   547,   548,     0,   223,    49,  1162,   224,   549,     0,
       0,  1163,  1164,    52,  1165,    53,     0,     0,     0,     0,
    1166,  1167,     0,     0,  1169,  1170,     0,     0,     0,  1171,
     582,    79,    80,    81,   354,     0,    83,    84,     0,    85,
      86,    87,   355,     0,   356,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   583,    99,   100,   101,   357,   584,
       0,   103,   104,   105,   106,   585,   586,     0,   108,   109,
     110,     0,   111,   587,   588,   114,   358,   359,     0,     0,
       0,   360,   361,     0,     0,     0,     0,   362,     0,     0,
       0,     0,     0,     0,     0,     0,   363,     0,   364,     0,
     365,   366,     0,   367,   368,   369,   370,   371,   372,   373,
    1694,   374,   375,     0,     0,     0,     0,  1116,     0,     0,
     376,   377,   378,   129,   379,   380,   381,   131,  1117,   133,
    1118,  1119,     0,   382,   383,     0,   384,  1120,  1121,   385,
    1122,  1123,   387,     0,   388,   389,   390,   391,  1124,     0,
       0,   392,   393,   394,     0,   395,   396,  1125,   397,     0,
     398,   399,   145,   400,  1126,  1127,  1128,  1129,   401,   402,
     403,   404,   405,  1130,  1131,   406,     0,   407,     0,   408,
       0,   409,   410,   411,     0,     0,     0,   412,  1132,   414,
     415,     0,   416,   417,     0,   418,     0,   419,   420,   421,
    1133,   422,     0,  1134,  1135,   423,   424,  1136,     0,   425,
       0,   426,   160,     0,   161,   427,     0,   428,     0,     0,
     429,     0,   430,   431,   164,   432,   433,   434,     0,   435,
     436,   437,   438,     0,   165,   166,     0,   439,   440,   441,
    1137,  1138,     0,  1139,     0,     0,   170,   171,   442,   172,
     443,   444,   445,   446,   447,     0,   173,   448,   174,     0,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,  1140,   180,  1141,   707,   462,   463,   464,
     465,   182,  1142,   466,   467,   184,   468,  1143,  1144,  1145,
     469,   470,     0,     0,   471,   708,     0,     0,  1146,   473,
       0,     0,   187,   188,   189,  1147,   474,   475,   476,     0,
    1148,   192,   477,   478,     0,   479,   480,   481,   482,   483,
     484,  1149,   485,     0,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   496,   199,   497,  1150,   498,   499,
     500,   501,   502,   503,     0,     0,   504,   505,   506,  1151,
     507,   205,   508,   509,   207,   510,  1152,     0,   511,   512,
     513,   514,   515,   516,   517,   518,  1153,   519,     0,   520,
     521,   522,   523,     0,  1154,  1155,     0,   525,     0,   526,
    1156,   527,  1157,  1158,   528,   529,   530,   531,   532,     0,
    1159,   533,   534,   535,   536,   537,  1160,     0,   538,   539,
     540,  1161,   541,   222,   542,     0,     0,     0,   543,   544,
     545,   546,   547,   548,     0,   223,    49,  1162,   224,   549,
       0,     0,  1163,  1164,    52,  1165,    53,     0,     0,     0,
       0,  1166,  1167,     0,     0,  1169,  1170,     0,     0,     0,
    1171,   582,    79,    80,    81,   354,     0,    83,    84,     0,
      85,    86,    87,   355,     0,   356,     0,    91,     0,    93,
      94,    95,    96,    97,    98,   583,    99,   100,   101,   357,
     584,     0,   103,   104,   105,   106,   585,   586,     0,   108,
     109,   110,     0,   111,   587,   588,   114,   358,   359,     0,
       0,     0,   360,   361,     0,     0,     0,     0,   362,     0,
       0,     0,     0,     0,     0,     0,     0,   363,     0,   364,
       0,   365,   366,     0,   367,   368,   369,   370,   371,   372,
     373,     0,   374,   375,     0,     0,     0,     0,  1116,     0,
       0,   376,   377,   378,   129,   379,   380,   381,   131,  1117,
     133,  1118,  1119,     0,   382,   383,     0,   384,  1120,  1121,
     385,  1122,  1123,   387,     0,   388,   389,   390,   391,  1124,
       0,     0,   392,   393,   394,     0,   395,   396,  1125,   397,
       0,   398,   399,   145,   400,  1126,  1127,  1128,  1129,   401,
     402,   403,   404,   405,  1130,  1131,   406,     0,   407,     0,
     408,     0,   409,   410,   411,     0,     0,     0,   412,  1132,
     414,   415,     0,   416,   417,     0,   418,     0,   419,   420,
     421,  1133,   422,     0,  1134,  1135,   423,   424,  1136,     0,
     425,     0,   426,   160,     0,   161,   427,     0,   428,     0,
       0,   429,     0,   430,   431,   164,   432,   433,   434,     0,
     435,   436,   437,   438,     0,   165,   166,     0,   439,   440,
     441,  1137,  1138,     0,  1139,     0,     0,   170,   171,   442,
     172,   443,   444,   445,   446,   447,     0,   173,   448,   174,
       0,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   461,  1140,   180,  1141,   707,   462,   463,
     464,   465,   182,  1142,   466,   467,   184,   468,  1143,  1144,
    1145,   469,   470,     0,     0,   471,   708,     0,     0,  1146,
     473,     0,     0,   187,   188,   189,  1147,   474,   475,   476,
       0,  1148,   192,   477,   478,     0,   479,   480,   481,   482,
     483,   484,  1149,   485,     0,   486,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,   199,   497,  1150,   498,
     499,   500,   501,   502,   503,     0,     0,   504,   505,   506,
    1151,   507,   205,   508,   509,   207,   510,  1152,     0,   511,
     512,   513,   514,   515,   516,   517,   518,  1153,   519,     0,
     520,   521,   522,   523,     0,  1154,  1155,     0,   525,     0,
     526,  1156,   527,  1157,  1158,   528,   529,   530,   531,   532,
       0,  1159,   533,   534,   535,   536,   537,  1160,     0,   538,
     539,   540,  1161,   541,   222,   542,     0,     0,     0,   543,
     544,   545,   546,   547,   548,     0,   223,    49,  1162,   224,
     549,     0,     0,  1163,  1164,    52,  1165,    53,     0,     0,
       0,     0,  1166,  1167,     0,     0,  1169,  1170,     0,  1533,
       0,  1171,   582,    79,    80,    81,   354,     0,    83,    84,
       0,    85,    86,    87,   355,     0,   356,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   583,    99,   100,   101,
     357,   584,     0,   103,   104,   105,   106,   585,   586,     0,
     108,   109,   110,     0,   111,   587,   588,   114,   358,   359,
       0,     0,     0,   360,   361,     0,     0,     0,     0,   362,
       0,     0,     0,     0,     0,     0,     0,     0,   363,     0,
     364,     0,   365,   366,     0,   367,   368,   369,   370,   371,
     372,   373,     0,   374,   375,     0,     0,     0,     0,  1116,
       0,     0,   376,   377,   378,   129,   379,   380,   381,   131,
    1117,   133,  1118,  1119,     0,   382,   383,     0,   384,  1120,
    1121,   385,  1122,  1123,   387,     0,   388,   389,   390,   391,
    1124,     0,     0,   392,   393,   394,     0,   395,   396,  1125,
     397,     0,   398,   399,   145,   400,  1126,  1127,  1128,  1129,
     401,   402,   403,   404,   405,  1130,  1131,   406,  2314,   407,
       0,   408,     0,   409,   410,   411,     0,     0,     0,   412,
    1132,   414,   415,     0,   416,   417,     0,   418,     0,   419,
     420,   421,  1133,   422,     0,  1134,  1135,   423,   424,  1136,
       0,   425,     0,   426,   160,     0,   161,   427,     0,   428,
       0,     0,   429,     0,   430,   431,   164,   432,   433,   434,
       0,   435,   436,   437,   438,     0,   165,   166,     0,   439,
     440,   441,  1137,  1138,     0,  1139,     0,     0,   170,   171,
     442,   172,   443,   444,   445,   446,   447,     0,   173,   448,
     174,     0,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,  1140,   180,  1141,   707,   462,
     463,   464,   465,   182,  1142,   466,   467,   184,   468,  1143,
    1144,  1145,   469,   470,     0,     0,   471,   708,     0,     0,
    1146,   473,     0,     0,   187,   188,   189,  1147,   474,   475,
     476,     0,  1148,   192,   477,   478,     0,   479,   480,   481,
     482,   483,   484,  1149,   485,     0,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,   496,   199,   497,  1150,
     498,   499,   500,   501,   502,   503,     0,     0,   504,   505,
     506,  1151,   507,   205,   508,   509,   207,   510,  1152,     0,
     511,   512,   513,   514,   515,   516,   517,   518,  1153,   519,
       0,   520,   521,   522,   523,     0,  1154,  1155,     0,   525,
       0,   526,  1156,   527,  1157,  1158,   528,   529,   530,   531,
     532,     0,  1159,   533,   534,   535,   536,   537,  1160,     0,
     538,   539,   540,  1161,   541,   222,   542,     0,     0,     0,
     543,   544,   545,   546,   547,   548,     0,   223,    49,  1162,
     224,   549,     0,     0,  1163,  1164,    52,  1165,    53,     0,
       0,     0,     0,  1166,  1167,     0,     0,  1169,  1170,     0,
       0,     0,  1171,   582,    79,    80,    81,   354,     0,    83,
      84,     0,    85,    86,    87,   355,     0,   356,     0,    91,
       0,    93,    94,    95,    96,    97,    98,   583,    99,   100,
     101,   357,   584,     0,   103,   104,   105,   106,   585,   586,
       0,   108,   109,   110,     0,   111,   587,   588,   114,   358,
     359,     0,     0,     0,   360,   361,     0,     0,     0,     0,
     362,     0,     0,     0,     0,     0,     0,     0,     0,   363,
       0,   364,     0,   365,   366,     0,   367,   368,   369,   370,
     371,   372,   373,     0,   374,   375,     0,     0,     0,     0,
    1116,     0,     0,   376,   377,   378,   129,   379,   380,   381,
     131,  1117,   133,  1118,  1119,     0,   382,   383,     0,   384,
    1120,  1121,   385,  1122,  1123,   387,     0,   388,   389,   390,
     391,  1124,     0,     0,   392,   393,   394,     0,   395,   396,
    1125,   397,     0,   398,   399,   145,   400,  1126,  1127,  1128,
    1129,   401,   402,   403,   404,   405,  1130,  1131,   406,     0,
     407,     0,   408,     0,   409,   410,   411,     0,     0,     0,
     412,  1132,   414,   415,     0,   416,   417,     0,   418,     0,
     419,   420,   421,  1133,   422,     0,  1134,  1135,   423,   424,
    1136,     0,   425,     0,   426,   160,  2016,   161,   427,     0,
     428,     0,     0,   429,     0,   430,   431,   164,   432,   433,
     434,     0,   435,   436,   437,   438,     0,   165,   166,     0,
     439,   440,   441,  1137,  1138,     0,  1139,     0,     0,   170,
     171,   442,   172,   443,   444,   445,   446,   447,     0,   173,
     448,   174,     0,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,  1140,   180,  1141,   707,
     462,   463,   464,   465,   182,  1142,   466,   467,   184,   468,
    1143,  1144,  1145,   469,   470,     0,     0,   471,   708,     0,
       0,  1146,   473,     0,     0,   187,   188,   189,  1147,   474,
     475,   476,     0,  1148,   192,   477,   478,     0,   479,   480,
     481,   482,   483,   484,  1149,   485,     0,   486,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,   199,   497,
    1150,   498,   499,   500,   501,   502,   503,     0,     0,   504,
     505,   506,  1151,   507,   205,   508,   509,   207,   510,  1152,
       0,   511,   512,   513,   514,   515,   516,   517,   518,  1153,
     519,     0,   520,   521,   522,   523,     0,  1154,  1155,     0,
     525,     0,   526,  1156,   527,  1157,  1158,   528,   529,   530,
     531,   532,     0,  1159,   533,   534,   535,   536,   537,  1160,
       0,   538,   539,   540,  1161,   541,   222,   542,     0,     0,
       0,   543,   544,   545,   546,   547,   548,     0,   223,    49,
    1162,   224,   549,     0,     0,  1163,  1164,    52,  1165,    53,
       0,     0,     0,     0,  1166,  1167,     0,     0,  1169,  1170,
       0,     0,     0,  1171,   582,    79,    80,    81,   354,     0,
      83,    84,     0,    85,    86,    87,   355,     0,   356,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   583,    99,
     100,   101,   357,   584,     0,   103,   104,   105,   106,   585,
     586,     0,   108,   109,   110,     0,   111,   587,   588,   114,
     358,   359,     0,     0,     0,   360,   361,     0,     0,     0,
       0,   362,     0,     0,     0,     0,     0,     0,     0,     0,
     363,     0,   364,     0,   365,   366,     0,   367,   368,   369,
     370,   371,   372,   373,     0,   374,   375,     0,     0,     0,
       0,  1116,     0,     0,   376,   377,   378,   129,   379,   380,
     381,   131,  1117,   133,  1118,  1119,     0,   382,   383,     0,
     384,  1120,  1121,   385,  1122,  1123,   387,     0,   388,   389,
     390,   391,  1124,     0,     0,   392,   393,   394,     0,   395,
     396,  1125,   397,     0,   398,   399,   145,   400,  1126,  1127,
    1128,  1129,   401,   402,   403,   404,   405,  1130,  1131,   406,
    2727,   407,     0,   408,     0,   409,   410,   411,     0,     0,
       0,   412,  1132,   414,   415,     0,   416,   417,     0,   418,
       0,   419,   420,   421,  1133,   422,     0,  1134,  1135,   423,
     424,  1136,     0,   425,     0,   426,   160,     0,   161,   427,
       0,   428,     0,     0,   429,     0,   430,   431,   164,   432,
     433,   434,     0,   435,   436,   437,   438,     0,   165,   166,
       0,   439,   440,   441,  1137,  1138,     0,  1139,     0,     0,
     170,   171,   442,   172,   443,   444,   445,   446,   447,     0,
     173,   448,   174,     0,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,  1140,   180,  1141,
     707,   462,   463,   464,   465,   182,  1142,   466,   467,   184,
     468,  1143,  1144,  1145,   469,   470,     0,     0,   471,   708,
       0,     0,  1146,   473,     0,     0,   187,   188,   189,  1147,
     474,   475,   476,     0,  1148,   192,   477,   478,     0,   479,
     480,   481,   482,   483,   484,  1149,   485,     0,   486,   487,
     488,   489,   490,   491,   492,   493,   494,   495,   496,   199,
     497,  1150,   498,   499,   500,   501,   502,   503,     0,     0,
     504,   505,   506,  1151,   507,   205,   508,   509,   207,   510,
    1152,     0,   511,   512,   513,   514,   515,   516,   517,   518,
    1153,   519,     0,   520,   521,   522,   523,     0,  1154,  1155,
       0,   525,     0,   526,  1156,   527,  1157,  1158,   528,   529,
     530,   531,   532,     0,  1159,   533,   534,   535,   536,   537,
    1160,     0,   538,   539,   540,  1161,   541,   222,   542,     0,
       0,     0,   543,   544,   545,   546,   547,   548,     0,   223,
      49,  1162,   224,   549,     0,     0,  1163,  1164,    52,  1165,
      53,     0,     0,     0,     0,  1166,  1167,     0,     0,  1169,
    1170,     0,     0,     0,  1171,   582,    79,    80,    81,   354,
       0,    83,    84,     0,    85,    86,    87,   355,     0,   356,
       0,    91,     0,    93,    94,    95,    96,    97,    98,   583,
      99,   100,   101,   357,   584,     0,   103,   104,   105,   106,
     585,   586,     0,   108,   109,   110,     0,   111,   587,   588,
     114,   358,   359,     0,     0,     0,   360,   361,     0,     0,
       0,     0,   362,     0,     0,     0,     0,     0,     0,     0,
       0,   363,     0,   364,     0,   365,   366,     0,   367,   368,
     369,   370,   371,   372,   373,     0,   374,   375,     0,     0,
       0,     0,  1116,     0,     0,   376,   377,   378,   129,   379,
     380,   381,   131,  1117,   133,  1118,  1119,     0,   382,   383,
       0,   384,  1120,  1121,   385,  1122,  1123,   387,     0,   388,
     389,   390,   391,  1124,     0,     0,   392,   393,   394,     0,
     395,   396,  1125,   397,     0,   398,   399,   145,   400,  1126,
    1127,  1128,  1129,   401,   402,   403,   404,   405,  1130,  1131,
     406,     0,   407,     0,   408,     0,   409,   410,   411,     0,
       0,     0,   412,  1132,   414,   415,     0,   416,   417,     0,
     418,     0,   419,   420,   421,  1133,   422,     0,  1134,  1135,
     423,   424,  1136,     0,   425,     0,   426,   160,     0,   161,
     427,     0,   428,     0,     0,   429,     0,   430,   431,   164,
     432,   433,   434,     0,   435,   436,   437,   438,     0,   165,
     166,     0,   439,   440,   441,  1137,  1138,     0,  1139,     0,
       0,   170,   171,   442,   172,   443,   444,   445,   446,   447,
       0,   173,   448,   174,     0,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,  1140,   180,
    1141,   707,   462,   463,   464,   465,   182,  1142,   466,   467,
     184,   468,  1143,  1144,  1145,   469,   470,     0,     0,   471,
     708,     0,     0,  1146,   473,     0,     0,   187,   188,   189,
    1147,   474,   475,   476,     0,  1148,   192,   477,   478,     0,
     479,   480,   481,   482,   483,   484,  1149,   485,     0,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
     199,   497,  1150,   498,   499,   500,   501,   502,   503,     0,
       0,   504,   505,   506,  1151,   507,   205,   508,   509,   207,
     510,  1152,     0,   511,   512,   513,   514,   515,   516,   517,
     518,  1153,   519,     0,   520,   521,   522,   523,     0,  1154,
    1155,     0,   525,     0,   526,  1156,   527,  1157,  1158,   528,
     529,   530,   531,   532,     0,  1159,   533,   534,   535,   536,
     537,  1160,     0,   538,   539,   540,  1161,   541,   222,   542,
       0,     0,     0,   543,   544,   545,   546,   547,   548,     0,
     223,    49,  1162,   224,   549,     0,     0,  1163,  1164,    52,
    1165,    53,     0,     0,     0,     0,  1166,  1167,     0,     0,
    1169,  1170,     0,     0,     0,  1171,   582,    79,    80,    81,
     354,     0,    83,    84,     0,    85,    86,    87,   355,     0,
     356,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     583,    99,   100,   101,   357,   584,     0,   103,   104,   105,
     106,   585,   586,     0,   108,   109,   110,     0,   111,   587,
     588,   114,   358,   359,     0,     0,     0,   360,   361,     0,
       0,     0,     0,   362,     0,     0,     0,     0,     0,     0,
       0,     0,   363,     0,   364,     0,   365,   366,     0,   367,
     368,   369,   370,   371,   372,   373,     0,   374,   375,     0,
       0,     0,     0,  1116,     0,     0,   376,   377,   378,   129,
     379,   380,   381,   131,  1117,   133,  1118,  1119,     0,   382,
     383,     0,   384,  1120,  1121,   385,  1122,  1123,   387,     0,
     388,   389,   390,   391,  1124,     0,     0,   392,   393,   394,
       0,   395,   396,  1125,   397,     0,   398,   399,   145,   400,
    1126,  1127,  1128,  1129,   401,   402,   403,   404,   405,  1130,
    1131,   406,     0,   407,     0,   408,     0,   409,   410,   411,
       0,     0,     0,   412,  1132,   414,   415,     0,   416,   417,
       0,   418,     0,   419,   420,   421,  1133,   422,     0,  1134,
    1135,   423,   424,  1136,     0,   425,     0,   426,   160,     0,
     161,   427,     0,   428,     0,     0,   429,     0,   430,   431,
     164,   432,   433,   434,     0,   435,   436,   437,   438,     0,
     165,   166,     0,   439,   440,   441,  1137,  1138,     0,  1139,
       0,     0,   170,   171,   442,   172,   443,   444,   445,   446,
     447,     0,   173,   448,   174,     0,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   461,  1140,
     180,  1141,   707,   462,   463,   464,   465,   182,     0,   466,
     467,   184,   468,  1143,  1144,  1145,   469,   470,     0,     0,
     471,   708,     0,     0,  1146,   473,     0,     0,   187,   188,
     189,  1147,   474,   475,   476,     0,  1148,   192,   477,   478,
       0,   479,   480,   481,   482,   483,   484,  1149,   485,     0,
     486,   487,   488,   489,   490,   491,   492,   493,   494,   495,
     496,   199,   497,  1150,   498,   499,   500,   501,   502,   503,
       0,     0,   504,   505,   506,  1151,   507,   205,   508,   509,
     207,   510,  1152,     0,   511,   512,   513,   514,   515,   516,
     517,   518,  1153,   519,     0,   520,   521,   522,   523,     0,
    1154,  1155,     0,   525,     0,   526,  1156,   527,  1157,  1158,
     528,   529,   530,   531,   532,     0,     0,   533,   534,   535,
     536,   537,  1160,     0,   538,   539,   540,  1161,   541,   222,
     542,     0,     0,     0,   543,   544,   545,   546,   547,   548,
       0,   223,    49,  1162,   224,   549,     0,     0,  1163,  1164,
      52,  1165,    53,     0,     0,     0,     0,     0,  1998,     0,
       0,  1999,  2000,     0,     0,     0,  1171,   582,    79,    80,
      81,   354,     0,    83,    84,     0,    85,    86,    87,   355,
       0,   356,     0,    91,     0,    93,    94,    95,    96,    97,
      98,   583,    99,   100,   101,   357,   584,     0,   103,   104,
     105,   106,   585,   586,     0,   108,   109,   110,     0,   111,
     587,   588,   114,   358,   359,     0,     0,     0,   360,   361,
       0,     0,     0,     0,   362,     0,     0,     0,     0,     0,
       0,     0,     0,   363,     0,   364,     0,   365,   366,     0,
     367,   368,   369,   370,   371,   372,   373,     0,   374,   375,
       0,     0,     0,     0,  1116,     0,     0,   376,   377,   378,
     129,   379,   380,   381,     0,  1117,   133,  1118,  1119,     0,
     382,   383,     0,   384,  1120,  1121,   385,  1122,  1123,   387,
       0,   388,   389,   390,   391,  1124,     0,     0,   392,   393,
     394,     0,   395,   396,  1125,   397,     0,   398,   399,   145,
     400,  1126,  1127,  1128,  1129,   401,   402,   403,   404,   405,
    1130,  1131,   406,     0,   407,     0,   408,     0,   409,   410,
     411,     0,     0,     0,   412,  1132,   414,   415,     0,   416,
     417,     0,     0,     0,   419,   420,   421,  1133,   422,     0,
    1134,  1135,   423,   424,  1136,     0,   425,     0,   426,   160,
       0,   161,   427,     0,   428,     0,     0,   429,     0,   430,
     431,     0,   432,   433,   434,     0,   435,   436,   437,   438,
       0,   165,   166,     0,   439,   440,   441,  1137,  1138,     0,
    1139,     0,     0,   170,   171,   442,   172,   443,   444,   445,
     446,   447,     0,   173,   448,     0,     0,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
    1140,   180,  1141,   707,   462,   463,   464,   465,   182,     0,
     466,   467,   184,   468,  1143,  1144,  1145,   469,   470,     0,
       0,   471,   708,     0,     0,  1146,   473,     0,     0,   187,
     188,   189,  1147,   474,   475,   476,     0,  1148,   192,   477,
     478,     0,   479,   480,   481,   482,   483,   484,  1149,   485,
       0,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   199,   497,  1150,   498,   499,   500,   501,   502,
     503,     0,     0,   504,   505,   506,  1151,   507,   205,   508,
     509,     0,   510,  1152,     0,   511,   512,   513,   514,   515,
     516,   517,   518,  1153,   519,     0,   520,   521,   522,   523,
       0,  1154,  1155,     0,   525,     0,   526,  1156,   527,  1157,
    1158,   528,   529,   530,   531,   532,     0,  1159,   533,   534,
     535,   536,   537,  1160,     0,   538,   539,   540,  1161,   541,
     222,   542,     0,     0,     0,   543,   544,   545,   546,   547,
     548,     0,   223,    49,  1162,   224,   549,     0,     0,  1163,
    1164,    52,  1165,    53,     0,     0,     0,     0,  1166,  1167,
       0,     0,  1169,  1170,     0,     0,     0,  1171,   582,    79,
      80,    81,   354,     0,    83,    84,     0,    85,    86,    87,
     355,     0,   356,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   583,    99,   100,   101,   357,   584,     0,   103,
     104,   105,   106,   585,   586,     0,   108,   109,   110,     0,
     111,   587,   588,   114,   358,   359,     0,     0,     0,   360,
     361,     0,     0,     0,     0,   362,     0,     0,     0,     0,
       0,     0,     0,     0,   363,     0,   364,     0,   365,   366,
       0,   367,   368,   369,   370,   371,   372,   373,     0,   374,
     375,     0,     0,     0,     0,  1116,     0,     0,   376,   377,
     378,   129,   379,   380,   381,   131,  1117,   133,  1118,  1119,
       0,   382,   383,     0,   384,  1120,  1121,   385,  1122,  1123,
     387,     0,   388,   389,   390,   391,  1124,     0,     0,   392,
     393,   394,     0,   395,   396,  1125,   397,     0,   398,   399,
     145,   400,  1126,  1127,  1128,  1129,   401,   402,   403,   404,
     405,  1130,  1131,   406,     0,   407,     0,   408,     0,   409,
     410,   411,     0,     0,     0,   412,  1132,   414,   415,     0,
     416,   417,     0,   418,     0,   419,   420,   421,  1133,   422,
       0,  1134,  1135,   423,   424,  1136,     0,   425,     0,   426,
     160,     0,   161,   427,     0,   428,     0,     0,   429,     0,
     430,   431,   164,   432,   433,   434,     0,   435,   436,   437,
     438,     0,   165,   166,     0,   439,   440,   441,  1137,  1138,
       0,  1139,     0,     0,   170,   171,   442,   172,   443,   444,
     445,   446,   447,     0,   173,   448,   174,     0,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,  1140,   180,  1141,   707,   462,   463,   464,   465,   182,
       0,   466,   467,   184,   468,  1143,  1144,  1145,   469,   470,
       0,     0,   471,   708,     0,     0,   472,   473,     0,     0,
     187,   188,   189,  1147,   474,   475,   476,     0,  1148,   192,
     477,   478,     0,   479,   480,   481,   482,   483,   484,  1149,
     485,     0,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,   199,   497,  1150,   498,   499,   500,   501,
     502,   503,     0,     0,   504,   505,   506,  1151,   507,   205,
     508,   509,   207,   510,  1152,     0,   511,   512,   513,   514,
     515,   516,   517,   518,  1153,   519,     0,   520,   521,   522,
     523,     0,  1154,  1155,     0,   525,     0,   526,  1156,   527,
    1157,  1158,   528,   529,   530,   531,   532,     0,     0,   533,
     534,   535,   536,   537,  1160,     0,   538,   539,   540,  1161,
     541,   222,   542,     0,     0,     0,   543,   544,   545,   546,
     547,   548,     0,   223,    49,     0,   224,   549,     0,     0,
    1163,  1164,    52,  1165,    53,   582,    79,    80,    81,   354,
       0,    83,    84,     0,    85,    86,    87,   355,  1171,   356,
       0,    91,     0,    93,    94,    95,    96,    97,    98,   583,
      99,   100,   101,   357,   584,     0,   103,   104,   105,   106,
     585,   586,     0,   108,   109,   110,     0,   111,   587,   588,
     114,   358,   359,     0,     0,     0,   360,   361,     0,     0,
       0,     0,   362,     0,     0,     0,     0,     0,     0,     0,
       0,   363,     0,   364,     0,   365,   366,     0,   367,   368,
     369,   370,   371,   372,   373,     0,   374,   375,     0,     0,
       0,     0,  1116,     0,     0,   376,   377,   378,   129,   379,
     380,   381,     0,  1117,   133,  1118,  1119,     0,   382,   383,
       0,   384,  1120,  1121,   385,  1122,  1123,   387,     0,   388,
     389,   390,   391,  1124,     0,     0,   392,   393,   394,     0,
     395,   396,  1125,   397,     0,   398,   399,   145,   400,  1126,
    1127,  1128,  1129,   401,   402,   403,   404,   405,  1130,  1131,
     406,     0,   407,     0,   408,     0,   409,   410,   411,     0,
       0,     0,   412,  1132,   414,   415,     0,   416,   417,     0,
       0,     0,   419,   420,   421,  1133,   422,     0,  1134,  1135,
     423,   424,  1136,     0,   425,     0,   426,   160,     0,   161,
     427,     0,   428,     0,     0,   429,     0,   430,   431,     0,
     432,   433,   434,     0,   435,   436,   437,   438,     0,   165,
     166,     0,   439,   440,   441,  1137,  1138,     0,  1139,     0,
       0,   170,   171,   442,   172,   443,   444,   445,   446,   447,
       0,   173,   448,     0,     0,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,  1140,   180,
    1141,   707,   462,   463,   464,   465,   182,     0,   466,   467,
     184,   468,  1143,  1144,  1145,   469,   470,     0,     0,   471,
     708,     0,     0,     0,   473,     0,     0,   187,   188,   189,
    1147,   474,   475,   476,     0,  1148,   192,   477,   478,     0,
     479,   480,   481,   482,   483,   484,  1149,   485,     0,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
     199,   497,  1150,   498,   499,   500,   501,   502,   503,     0,
       0,   504,   505,   506,  1151,   507,   205,   508,   509,     0,
     510,  1152,     0,   511,   512,   513,   514,   515,   516,   517,
     518,  1153,   519,     0,   520,   521,   522,   523,     0,  1154,
    1155,     0,   525,     0,   526,  1156,   527,  1157,  1158,   528,
     529,   530,   531,   532,     0,     0,   533,   534,   535,   536,
     537,  1160,     0,   538,   539,   540,  1161,   541,   222,   542,
       0,     0,     0,   543,   544,   545,   546,   547,   548,     0,
     223,    49,     0,   224,   549,     0,     0,  1163,  1164,    52,
    1165,    53,     0,     0,     0,     0,     0,  1998,     0,     0,
    1999,  2000,     0,     0,     0,  1171,   582,    79,    80,    81,
     354,     0,    83,    84,     0,    85,    86,    87,   355,     0,
     356,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     583,    99,   100,   101,   357,   584,     0,   103,   104,   105,
     106,   585,   586,     0,   108,   109,   110,     0,   111,   587,
     588,   114,   358,   359,     0,     0,     0,   360,   361,     0,
       0,     0,     0,   362,     0,     0,     0,     0,     0,     0,
       0,     0,   363,     0,   364,     0,   365,   366,     0,   367,
     368,   369,   370,   371,   372,   373, -1095,   374,   375,     0,
       0,     0, -1095,  1116,     0,     0,   376,   377,   378,   129,
     379,   380,   381,     0,  1117,   133,  1118,  1119,     0,   382,
     383,     0,   384,  1120,  1121,   385,  1122,  1123,   387,     0,
     388,   389,   390,   391,  1124,     0,     0,   392,   393,   394,
       0,   395,   396,  1125,   397,     0,   398,   399,   145,   400,
    1126,  1127,  1128,  1129,   401,   402,   403,   404,   405,  1130,
    1131,   406,     0,   407,     0,   408,     0,   409,   410,   411,
       0,     0,     0,   412,  1132,   414,   415,     0,   416,   417,
       0,     0,     0,   419,   420,   421,  1133,   422,     0,  1134,
    1135,   423,   424,  1136,     0,   425,     0,   426,   160,     0,
     161,   427,     0,   428,     0,     0,   429,     0,   430,   431,
       0,   432,   433,   434,     0,   435,   436,   437,   438,     0,
     165,   166,     0,   439,   440,   441,  1137,  1138,     0,  1139,
       0,     0,     0,     0,   442,   172,   443,   444,   445,   446,
     447,     0,   173,   448,     0,     0,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   461,  1140,
     180,  1141,   707,   462,   463,   464,   465,   182,     0,   466,
     467,     0,   468,  1143,  1144,  1145,   469,   470,     0,     0,
     471,   708,     0,     0,     0,   473,     0,     0,   187,   188,
     189,  1147,   474,   475,   476,     0,  1148,   192,   477,   478,
       0,   479,   480,   481,   482,   483,   484,  1149,   485,     0,
     486,   487,   488,   489,   490,   491,   492,   493,   494,   495,
     496,   199,   497,  1150,   498,   499,   500,   501,   502,   503,
       0,     0,   504,   505,   506,  1151,   507,   205,   508,   509,
       0,   510,  1152, -1095,   511,   512,   513,   514,   515,   516,
     517,   518,  1153,   519,     0,   520,   521,   522,   523,     0,
    1154,  1155,     0,   525,     0,   526,  1156,   527,  1157,  1158,
     528,   529,   530,   531,   532,     0,  1159,   533,   534,   535,
     536,   537,  1160,     0,   538,   539,   540,  1161,   541,   222,
     542,     0,     0,     0,   543,   544,   545,   546,   547,   548,
       0,   223,    49,     0,   224,   549,     0,     0,  1163,  1164,
      52,  1165,    53,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1170,     0,     0,     0,  1171,   582,    79,    80,
      81,   354,     0,    83,    84,     0,    85,    86,    87,   355,
       0,   356,     0,    91,     0,    93,    94,    95,    96,    97,
      98,   583,    99,   100,   101,   357,   584,     0,   103,   104,
     105,   106,   585,   586,     0,   108,   109,   110,     0,   111,
     587,   588,   114,   358,   359,     0,     0,     0,   360,   361,
       0,     0,     0,     0,   362,     0,     0,     0,     0,     0,
       0,     0,     0,   363,     0,   364,     0,   365,   366,     0,
     367,   368,   369,   370,   371,   372,   373, -1096,   374,   375,
       0,     0,     0, -1096,  1116,     0,     0,   376,   377,   378,
     129,   379,   380,   381,     0,  1117,   133,  1118,  1119,     0,
     382,   383,     0,   384,  1120,  1121,   385,  1122,  1123,   387,
       0,   388,   389,   390,   391,  1124,     0,     0,   392,   393,
     394,     0,   395,   396,  1125,   397,     0,   398,   399,   145,
     400,  1126,  1127,  1128,  1129,   401,   402,   403,   404,   405,
    1130,  1131,   406,     0,   407,     0,   408,     0,   409,   410,
     411,     0,     0,     0,   412,  1132,   414,   415,     0,   416,
     417,     0,     0,     0,   419,   420,   421,  1133,   422,     0,
    1134,  1135,   423,   424,  1136,     0,   425,     0,   426,   160,
       0,   161,   427,     0,   428,     0,     0,   429,     0,   430,
     431,     0,   432,   433,   434,     0,   435,   436,   437,   438,
       0,   165,   166,     0,   439,   440,   441,  1137,  1138,     0,
    1139,     0,     0,     0,     0,   442,   172,   443,   444,   445,
     446,   447,     0,   173,   448,     0,     0,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
    1140,   180,  1141,   707,   462,   463,   464,   465,   182,     0,
     466,   467,     0,   468,  1143,  1144,  1145,   469,   470,     0,
       0,   471,   708,     0,     0,     0,   473,     0,     0,   187,
     188,   189,  1147,   474,   475,   476,     0,  1148,   192,   477,
     478,     0,   479,   480,   481,   482,   483,   484,  1149,   485,
       0,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   199,   497,  1150,   498,   499,   500,   501,   502,
     503,     0,     0,   504,   505,   506,  1151,   507,   205,   508,
     509,     0,   510,  1152, -1096,   511,   512,   513,   514,   515,
     516,   517,   518,  1153,   519,     0,   520,   521,   522,   523,
       0,  1154,  1155,     0,   525,     0,   526,  1156,   527,  1157,
    1158,   528,   529,   530,   531,   532,     0,  1159,   533,   534,
     535,   536,   537,  1160,     0,   538,   539,   540,  1161,   541,
     222,   542,     0,     0,     0,   543,   544,   545,   546,   547,
     548,     0,   223,    49,     0,   224,   549,     0,     0,  1163,
    1164,    52,  1165,    53,   582,    79,    80,    81,   354,     0,
      83,    84,     0,    85,    86,    87,   355,  1171,   356,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   583,    99,
     100,   101,   357,   584,     0,   103,   104,   105,   106,   585,
     586,     0,   108,   109,   110,     0,   111,   587,   588,   114,
     358,   359,     0,     0,     0,   360,   361,     0,     0,     0,
       0,   362,     0,     0,     0,     0,     0,     0,     0,     0,
     363,     0,   364,     0,   365,   366,     0,   367,   368,   369,
     370,   371,   372,   373,     0,   374,   375,     0,     0,     0,
       0,  1116,     0,     0,   376,   377,   378,   129,   379,   380,
     381,     0,  1117,   133,  1118,  1119,     0,   382,   383,     0,
     384,  1120,  1121,   385,  1122,  1123,   387,     0,   388,   389,
     390,   391,  1124,     0,     0,   392,   393,   394,     0,   395,
     396,  1125,   397,     0,   398,   399,   145,   400,  1126,  1127,
    1128,  1129,   401,   402,   403,   404,   405,  1130,  1131,   406,
       0,   407,     0,   408,     0,   409,   410,   411,     0,     0,
       0,   412,  1132,   414,   415,     0,   416,   417,     0,     0,
       0,   419,   420,   421,  1133,   422,     0,  1134,  1135,   423,
     424,  1136,     0,   425,     0,   426,   160,     0,   161,   427,
       0,   428,     0,     0,   429,     0,   430,   431,     0,   432,
     433,   434,     0,   435,   436,   437,   438,     0,   165,   166,
       0,   439,   440,   441,  1137,  1138,     0,  1139,     0,     0,
       0,     0,   442,   172,   443,   444,   445,   446,   447,     0,
     173,   448,     0,     0,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,  1140,   180,  1141,
     707,   462,   463,   464,   465,   182,     0,   466,   467,     0,
     468,     0,  1144,  1145,   469,   470,     0,     0,   471,   708,
       0,     0,     0,   473,     0,     0,   187,   188,   189,  1147,
     474,   475,   476,     0,  1148,   192,   477,   478,     0,   479,
     480,   481,   482,   483,   484,  1149,   485,     0,   486,   487,
     488,   489,   490,   491,   492,   493,   494,   495,   496,   199,
     497,  1150,   498,   499,   500,   501,   502,   503,     0,     0,
     504,   505,   506,  1151,   507,   205,   508,   509,     0,   510,
    1152,     0,   511,   512,   513,   514,   515,   516,   517,   518,
    1153,   519,     0,   520,   521,   522,   523,     0,  1154,  1155,
       0,   525,     0,   526,  1156,   527,  1157,  1158,   528,   529,
     530,   531,   532,     0,     0,   533,   534,   535,   536,   537,
    1160,     0,   538,   539,   540,  1161,   541,   222,   542,     0,
       0,     0,   543,   544,   545,   546,   547,   548,     0,   223,
      49,     0,   224,   549,     0,     0,  1163,  1164,    52,  1165,
      53,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2000,     0,     0,     0,  1171,   582,    79,    80,    81,   354,
       0,    83,    84,     0,    85,    86,    87,   355,     0,   356,
       0,    91,     0,    93,    94,    95,    96,    97,    98,   583,
      99,   100,   101,   357,   584,     0,   103,   104,   105,   106,
     585,   586,     0,   108,   109,   110,     0,   111,   587,   588,
     114,   358,   359,     0,     0,     0,   360,   361,     0,     0,
       0,     0,   362,     0,     0,     0,     0,     0,     0,     0,
       0,   363,     0,   364,     0,   365,   366,     0,   367,   368,
     369,   370,   371,   372,   373,     0,   374,   375,     0,     0,
       0,     0,  1116,     0,     0,   376,   377,   378,   129,   379,
     380,   381,     0,  1117,   133,  1118,  1119,     0,   382,   383,
       0,   384,  1120,  1121,   385,  1122,  1123,   387,     0,   388,
     389,   390,   391,  1124,     0,     0,   392,   393,   394,     0,
     395,   396,  1125,   397,     0,   398,   399,   145,   400,  1126,
    1127,  1128,  1129,   401,   402,   403,   404,   405,  1130,  1131,
     406,     0,   407,     0,   408,     0,   409,   410,   411,     0,
       0,     0,   412,  1132,   414,   415,     0,   416,   417,     0,
       0,     0,   419,   420,   421,  1133,   422,     0,  1134,  1135,
     423,   424,  1136,     0,   425,     0,   426,   160,     0,   161,
     427,     0,   428,     0,     0,   429,     0,   430,   431,     0,
     432,   433,   434,     0,   435,   436,   437,   438,     0,   165,
     166,     0,   439,   440,   441,  1137,  1138,     0,  1139,     0,
       0,     0,     0,   442,   172,   443,   444,   445,   446,   447,
       0,   173,   448,     0,     0,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,  1140,   180,
    1141,   707,   462,   463,   464,   465,   182,     0,   466,   467,
       0,   468,     0,  1144,  1145,   469,   470,     0,     0,   471,
     708,     0,     0,     0,   473,     0,     0,   187,   188,   189,
    1147,   474,   475,   476,     0,  1148,   192,   477,   478,     0,
     479,   480,   481,   482,   483,   484,  1149,   485,     0,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
     199,   497,  1150,   498,   499,   500,   501,   502,   503,     0,
       0,   504,   505,   506,  1151,   507,   205,   508,   509,     0,
     510,  1152,     0,   511,   512,   513,   514,   515,   516,   517,
     518,  1153,   519,     0,   520,   521,   522,   523,     0,  1154,
    1155,     0,   525,     0,   526,  1156,   527,  1157,  1158,   528,
     529,   530,   531,   532,     0,     0,   533,   534,   535,   536,
     537,  1160,     0,   538,   539,   540,  1161,   541,   222,   542,
       0,     0,     0,   543,   544,   545,   546,   547,   548,     0,
     223,    49,     0,   224,   549,     0,     0,  1163,  1164,    52,
    1165,    53,     0,    79,    80,    81,   354,     0,    83,    84,
       0,    85,    86,    87,   355,  1171,   356,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     357,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   358,   359,
       0,     0,     0,   360,   361,     0,     0,     0,     0,   362,
       0,     0,     0,     0,     0,     0,     0,     0,   363,     0,
     364,     0,   365,   366,     0,   367,   368,   369,   370,   371,
     372,   373,     0,   374,   375,     0,     0,     0,     0,     0,
    2699,     0,   376,   377,   378,     0,   379,   380,   381,     0,
     132,     0,   134,     0,     0,   382,   383,     0,   384,     0,
       0,   385,   386,   135,   387,     0,   388,   389,   390,   391,
     139,     0,     0,   392,   393,   394,     0,   395,   396,   142,
     397,     0,   398,   399,     0,   400,     0,     0,     0,     0,
     401,   402,   403,   404,   405,   148,   149,   406,     0,   407,
       0,   408,     0,   409,   410,   411,     0,     0,     0,   412,
     413,   414,   415,     0,   416,   417,     0,   418,  -778,   419,
     420,   421,   155,   422,     0,   157,     0,   423,   424,   159,
    -778,   425,     0,   426,     0,     0,     0,   427,     0,   428,
       0,     0,   429,     0,   430,   431,     0,   432,   433,   434,
       0,   435,   436,   437,   438,     0,     0,   166,     0,   439,
     440,   441,     0,   168,  -778,   169,     0,     0,     0,     0,
     442,     0,   443,   444,   445,   446,   447,     0,     0,   448,
       0,  -778,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   179,     0,   181,     0,   462,
     463,   464,   465,   182,     0,   466,   467,     0,   468,     0,
     185,   186,   469,   470,     0,  -778,   471,     0,     0,     0,
     472,   473,     0,  -778,   187,     0,     0,   190,   474,   475,
     476,     0,   191,   192,   477,   478,     0,   479,   480,   481,
     482,   483,   484,   194,   485,     0,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,   496,     0,   497,   201,
     498,   499,   500,   501,   502,   503,     0,     0,   504,   505,
     506,     0,   507,   205,   508,   509,     0,   510,   208,     0,
     511,   512,   513,   514,   515,   516,   517,   518,   210,   519,
       0,   520,   521,   522,   523,     0,   211,   212,     0,   525,
       0,   526,   213,   527,   214,     0,   528,   529,   530,   531,
     532,  -778,     0,   533,   534,   535,   536,   537,     0,     0,
     538,   539,   540,   221,   541,     0,   542,     0,     0,     4,
     543,   544,   545,   546,   547,   548,     0,   223,     0,     0,
     224,     0,     0,     0,     5,     0,     0,     0,     0,     0,
       0,     0,     0,     6,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1247,     7,     8,     0,     0,     0,     0,
       0,     0,    10,    11,     0,     0,     0,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    36,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    37,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    38,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    39,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    40,     0,     0,    41,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    43,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    44,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    45,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      46,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,    48,    49,     0,    50,     0,     0,
       0,     0,     0,    52,     0,    53,    54,     0,     0,     0,
      55,    56,    57,    58,    59,     0,     0,    60,    61,   932,
      79,    80,    81,   354,     0,    83,    84,     0,    85,    86,
      87,   355,     0,   356,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   357,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   358,   359,     0,     0,     0,
     360,   361,     0,     0,     0,     0,   362,     0,     0,     0,
       0,     0,     0,     0,     0,   363,     0,   364,     0,   365,
     366,     0,   367,   368,   369,   370,   371,   372,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
     377,   378,   129,   379,   380,   381,   131,   132,   133,   134,
       0,     0,   382,   383,     0,   384,     0,  1121,   385,   386,
     135,   387,     0,   388,   389,   390,   391,  1124,     0,     0,
     392,   393,   394,     0,   395,   396,  1125,   397,     0,   398,
     399,   145,   400,  1126,  1127,  1128,  1129,   401,   402,   403,
     404,   405,   148,   149,   406,     0,   407,     0,   408,     0,
     409,   410,   411,     0,     0,     0,   412,   413,   414,   415,
       0,   416,   417,     0,   418,     0,   419,   420,   421,   155,
     422,     0,  1134,     0,   423,   424,   159,     0,   425,     0,
     426,   160,     0,   161,   427,     0,   428,     0,     0,   429,
       0,   430,   431,   164,   432,   433,   434,     0,   435,   436,
     437,   438,     0,   165,   166,     0,   439,   440,   441,     0,
     168,     0,   169,     0,     0,   170,   171,   442,   172,   443,
     444,   445,   446,   447,     0,   173,   448,   174,     0,   449,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   461,   179,   180,   181,   707,   462,   463,   464,   465,
     182,     0,   466,   467,   184,   468,     0,  1144,   186,   469,
     470,     0,     0,   471,   708,     0,   869,   472,   473,     0,
       0,   187,   188,   189,  1147,   474,   475,   476,     0,  1148,
     192,   477,   478,     0,   479,   480,   481,   482,   483,   484,
     194,   485,     0,   486,   487,   488,   489,   490,   491,   492,
     493,   494,   495,   496,   199,   497,   201,   498,   499,   500,
     501,   502,   503,     0,   203,   504,   505,   506,  1151,   507,
     205,   508,   509,   207,   510,   208,     0,   511,   512,   513,
     514,   515,   516,   517,   518,  1153,   519,     0,   520,   521,
     522,   523,     0,   211,   212,     0,   525,     0,   526,  1156,
     527,  1157,     0,   528,   529,   530,   531,   532,     0,     0,
     533,   534,   535,   536,   537,  1160,     0,   538,   539,   540,
     221,   541,   222,   542,     0,     0,     0,   543,   544,   545,
     546,   547,   548,     0,   223,     0,     0,   224,     0,     0,
       0,     0,     0,    79,    80,    81,   354,     0,    83,    84,
       0,    85,    86,    87,   355,     0,   356,     0,    91,  2427,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     357,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   358,   359,
       0,     0,     0,   360,   361,     0,     0,     0,     0,   362,
       0,     0,     0,     0,     0,     0,     0,     0,   363,     0,
     364,     0,   365,   366,     0,   367,   368,   369,   370,   371,
     372,   373,     0,   374,   375,     0,     0,     0,     0,     0,
       0,     0,   376,   377,   378,   129,   379,   380,   381,   131,
     132,   133,   134,     0,     0,   382,   383,     0,   384,     0,
    1121,   385,   386,   135,   387,     0,   388,   389,   390,   391,
    1124,     0,     0,   392,   393,   394,     0,   395,   396,  1125,
     397,     0,   398,   399,   145,   400,  1126,  1127,  1128,  1129,
     401,   402,   403,   404,   405,   148,   149,   406,     0,   407,
       0,   408,     0,   409,   410,   411,     0,     0,     0,   412,
     413,   414,   415,     0,   416,   417,     0,   418,     0,   419,
     420,   421,   155,   422,     0,  1134,     0,   423,   424,   159,
       0,   425,     0,   426,   160,     0,   161,   427,     0,   428,
       0,     0,   429,     0,   430,   431,   164,   432,   433,   434,
       0,   435,   436,   437,   438,     0,   165,   166,     0,   439,
     440,   441,     0,   168,     0,   169,     0,     0,   170,   171,
     442,   172,   443,   444,   445,   446,   447,     0,   173,   448,
     174,     0,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   179,   180,   181,   707,   462,
     463,   464,   465,   182,     0,   466,   467,   184,   468,     0,
    1144,   186,   469,   470,     0,     0,   471,   708,     0,   869,
     472,   473,     0,     0,   187,   188,   189,  1147,   474,   475,
     476,     0,  1148,   192,   477,   478,     0,   479,   480,   481,
     482,   483,   484,   194,   485,     0,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,   496,   199,   497,   201,
     498,   499,   500,   501,   502,   503,     0,     0,   504,   505,
     506,  1151,   507,   205,   508,   509,   207,   510,   208,     0,
     511,   512,   513,   514,   515,   516,   517,   518,  1153,   519,
       0,   520,   521,   522,   523,     0,   211,   212,     0,   525,
       0,   526,  1156,   527,  1157,     0,   528,   529,   530,   531,
     532,     0,     0,   533,   534,   535,   536,   537,  1160,     0,
     538,   539,   540,   221,   541,   222,   542,     0,     0,     0,
     543,   544,   545,   546,   547,   548,     0,   223,     0,     0,
     224,     0,     0,     0,     0,     0,    79,    80,    81,   354,
       0,    83,    84,     0,    85,    86,    87,   355,     0,   356,
       0,    91,  2427,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   357,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   358,   359,     0,     0,     0,   360,   361,     0,     0,
       0,     0,   362,     0,     0,     0,     0,     0,     0,     0,
       0,   363,     0,   364,     0,   365,   366,     0,   367,   368,
     369,   370,   371,   372,   373,     0,   374,   375,     0,     0,
       0,     0,     0,     0,     0,   376,   377,   378,   129,   379,
     380,   381,   131,   132,   133,   134,     0,     0,   382,   383,
       0,   384,     0,  1121,   385,   386,   135,   387,     0,   388,
     389,   390,   391,  1124,     0,     0,   392,   393,   394,     0,
     395,   396,  1125,   397,     0,   398,   399,   145,   400,  1126,
    1127,  1128,  1129,   401,   402,   403,   404,   405,   148,   149,
     406,     0,   407,     0,   408,     0,   409,   410,   411,     0,
       0,     0,   412,   413,   414,   415,     0,   416,   417,     0,
     418,     0,   419,   420,   421,   155,   422,     0,  1134,     0,
     423,   424,   159,     0,   425,     0,   426,   160,     0,   161,
     427,     0,   428,     0,     0,   429,     0,   430,   431,   164,
     432,   433,   434,     0,   435,   436,   437,   438,     0,   165,
     166,     0,   439,   440,   441,     0,   168,     0,   169,     0,
       0,   170,   171,   442,   172,   443,   444,   445,   446,   447,
       0,   173,   448,   174,     0,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   179,   180,
     181,   707,   462,   463,   464,   465,   182,     0,   466,   467,
     184,   468,     0,  1144,   186,   469,   470,     0,     0,   471,
     708,     0,     0,   472,   473,     0,     0,   187,   188,   189,
    1147,   474,   475,   476,     0,  1148,   192,   477,   478,     0,
     479,   480,   481,   482,   483,   484,   194,   485,     0,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
     199,   497,   201,   498,   499,   500,   501,   502,   503,     0,
       0,   504,   505,   506,  1151,   507,   205,   508,   509,   207,
     510,   208,     0,   511,   512,   513,   514,   515,   516,   517,
     518,  1153,   519,     0,   520,   521,   522,   523,     0,   211,
     212,     0,   525,     0,   526,  1156,   527,  1157,     0,   528,
     529,   530,   531,   532,     0,     0,   533,   534,   535,   536,
     537,  1160,     0,   538,   539,   540,   221,   541,   222,   542,
       0,     0,     0,   543,   544,   545,   546,   547,   548,     0,
     223,     0,     0,   224,     0,     0,     0,     0,     0,    79,
      80,    81,   354,     0,    83,    84,     0,    85,    86,    87,
     355,     0,   356,     0,    91,  2948,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   357,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   358,   359,     0,     0,     0,   360,
     361,     0,     0,     0,     0,   362,     0,     0,     0,     0,
       0,     0,     0,     0,   363,     0,   364,     0,   365,   366,
       0,   367,   368,   369,   370,   371,   372,   373,     0,   374,
     375,     0,     0,     0,     0,     0,     0,     0,   376,   377,
     378,     0,   379,   380,   381,     0,   132,     0,   134,     0,
       0,   382,   383,     0,   384,     0,     0,   385,   386,   135,
     387,     0,   388,   389,   390,   391,   139,     0,     0,   392,
     393,   394,     0,   395,   396,   142,   397,     0,   398,   399,
       0,   400,     0,     0,     0,     0,   401,   402,   403,   404,
     405,   148,   149,   406,     0,   407,     0,   408,     0,   409,
     410,   411,     0,     0,     0,   412,   413,   414,   415,     0,
     416,   417,     0,   418,     0,   419,   420,   421,   155,   422,
       0,   157,     0,   423,   424,   159,     0,   425,     0,   426,
       0,     0,     0,   427,     0,   428,     0,     0,   429,     0,
     430,   431,     0,   432,   433,   434,     0,   435,   436,   437,
     438,     0,     0,   166,     0,   439,   440,   441,     0,   168,
       0,   169,     0,     0,     0,     0,   442,     0,   443,   444,
     445,   446,   447,     0,     0,   448,     0,     0,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   179,     0,   181,     0,   462,   463,   464,   465,   182,
       0,   466,   467,     0,   468,     0,   185,   186,   469,   470,
       0,     0,   471,     0,     0,     0,   472,   473,     0,     0,
     187,     0,     0,   190,   474,   475,   476,     0,   191,   192,
     477,   478,     0,   479,   480,   481,   482,   483,   484,   194,
     485,     0,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,     0,   497,   201,   498,   499,   500,   501,
     502,   503,     0,     0,   504,   505,   506,     0,   507,   205,
     508,   509,     0,   510,   208,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   210,   519,     0,   520,   521,   522,
     523,     0,   211,   212,     0,   525,     0,   526,   213,   527,
     214,     0,   528,   529,   530,   531,   532,     0,     0,   533,
     534,   535,   536,   537,     0,     0,   538,   539,   540,   221,
     541,     0,   542,     0,     0,     0,   543,   544,   545,   546,
     547,   548,     0,   223,    49,     0,   224,   549,     0,     0,
       0,     0,    52,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2237,  2238,    79,
      80,    81,   354,     0,    83,    84,     0,    85,    86,    87,
     355,     0,   356,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   357,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   358,   359,     0,     0,     0,   360,
     361,     0,     0,     0,     0,   362,     0,     0,     0,     0,
       0,     0,     0,     0,   363,     0,   364,     0,   365,   366,
       0,   367,   368,   369,   370,   371,   372,   373,     0,   374,
     375,     0,     0,     0,     0,     0,     0,     0,   376,   377,
     378,     0,   379,   380,   381,     0,   132,     0,   134,     0,
       0,   382,   383,     0,   384,     0,     0,   385,   386,   135,
     387,     0,   388,   389,   390,   391,   139,     0,     0,   392,
     393,   394,     0,   395,   396,   142,   397,     0,   398,   399,
       0,   400,     0,     0,     0,     0,   401,   402,   403,   404,
     405,   148,   149,   406,     0,   407,     0,   408,     0,   409,
     410,   411,     0,     0,     0,   412,   413,   414,   415,     0,
     416,   417,     0,   418,     0,   419,   420,   421,   155,   422,
       0,   157,     0,   423,   424,   159,     0,   425,     0,   426,
       0,     0,     0,   427,     0,   428,     0,     0,   429,     0,
     430,   431,     0,   432,   433,   434,     0,   435,   436,   437,
     438,     0,     0,   166,     0,   439,   440,   441,     0,   168,
       0,   169,     0,     0,     0,     0,   442,     0,   443,   444,
     445,   446,   447,     0,     0,   448,     0,     0,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   179,     0,   181,     0,   462,   463,   464,   465,   182,
       0,   466,   467,     0,   468,     0,   185,   186,   469,   470,
       0,     0,   471,     0,     0,     0,   472,   473,     0,     0,
     187,     0,     0,   190,   474,   475,   476,     0,   191,   192,
     477,   478,     0,   479,   480,   481,   482,   483,   484,   194,
     485,     0,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,     0,   497,   201,   498,   499,   500,   501,
     502,   503,     0,     0,   504,   505,   506,     0,   507,   205,
     508,   509,     0,   510,   208,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   210,   519,     0,   520,   521,   522,
     523,     0,   211,   212,     0,   525,     0,   526,   213,   527,
     214,     0,   528,   529,   530,   531,   532,     0,     0,   533,
     534,   535,   536,   537,     0,     0,   538,   539,   540,   221,
     541,     0,   542,     0,     0,     0,   543,   544,   545,   546,
     547,   548,     0,   223,    49,     0,   224,   549,     0,     0,
       0,     0,    52,     0,    79,    80,    81,   354,     0,    83,
      84,     0,    85,    86,    87,   355,     0,   356,  2238,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   357,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   358,
     359,     0,     0,     0,   360,   361,     0,     0,     0,     0,
     362,     0,     0,     0,     0,     0,     0,     0,     0,   363,
       0,   364,     0,   365,   366,     0,   367,   368,   369,   370,
     371,   372,   373,     0,   374,   375,     0,     0,     0,     0,
       0,     0,     0,   376,   377,   378,     0,   379,   380,   381,
       0,   132,     0,   134,     0,     0,   382,   383,     0,   384,
       0,     0,   385,   386,   135,   387,     0,   388,   389,   390,
     391,   139,     0,     0,   392,   393,   394,     0,   395,   396,
     142,   397,     0,   398,   399,     0,   400,     0,     0,     0,
       0,   401,   402,   403,   404,   405,   148,   149,   406,     0,
     407,     0,   408,     0,   409,   410,   411,     0,     0,     0,
     412,   413,   414,   415,     0,   416,   417,     0,   418,     0,
     419,   420,   421,   155,   422,     0,   157,     0,   423,   424,
     159,     0,   425,     0,   426,     0,     0,     0,   427,     0,
     428,     0,     0,   429,     0,   430,   431,     0,   432,   433,
     434,     0,   435,   436,   437,   438,     0,     0,   166,     0,
     439,   440,   441,     0,   168,     0,   169,     0,     0,     0,
       0,   442,     0,   443,   444,   445,   446,   447,     0,     0,
     448,     0,     0,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   179,     0,   181,   707,
     462,   463,   464,   465,   182,     0,   466,   467,     0,   468,
       0,   185,   186,   469,   470,     0,     0,   471,   708,     0,
       0,   472,   473,     0,     0,   187,     0,     0,   190,   474,
     475,   476,     0,   191,   192,   477,   478,     0,   479,   480,
     481,   482,   483,   484,   194,   485,     0,   486,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,     0,   497,
     201,   498,   499,   500,   501,   502,   503,     0,     0,   504,
     505,   506,     0,   507,   205,   508,   509,     0,   510,   208,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   210,
     519,     0,   520,   521,   522,   523,     0,   211,   212,     0,
     525,     0,   526,   213,   527,   214,     0,   528,   529,   530,
     531,   532,     0,     0,   533,   534,   535,   536,   537,     0,
       0,   538,   539,   540,   221,   541,     0,   542,     0,     0,
       0,   543,   544,   545,   546,   547,   548,     0,   223,     0,
       0,   224,     0,     0,     0,     0,     0,    79,    80,    81,
     354,     0,    83,    84,     0,    85,    86,    87,   355,     0,
     356,     0,    91,  1241,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   357,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   358,   359,     0,     0,     0,   360,   361,     0,
       0,     0,     0,   362,     0,     0,     0,     0,     0,     0,
       0,     0,   363,     0,   364,     0,   365,   366,     0,   367,
     368,   369,   370,   371,   372,   373,     0,   374,   375,     0,
       0,     0,     0,     0,     0,     0,   376,   377,   378,     0,
     379,   380,   381,     0,   132,     0,   134,     0,     0,   382,
     383,     0,   384,     0,     0,   385,   386,   135,   387,     0,
     388,   389,   390,   391,   139,     0,     0,   392,   393,   394,
       0,   395,   396,   142,   397,     0,   398,   399,     0,   400,
       0,     0,     0,     0,   401,   402,   403,   404,   405,   148,
     149,   406,     0,   407,     0,   408,     0,   409,   410,   411,
       0,     0,     0,   412,   413,   414,   415,     0,   416,   417,
       0,   418,     0,   419,   420,   421,   155,   422,     0,   157,
       0,   423,   424,   159,     0,   425,     0,   426,     0,     0,
       0,   427,     0,   428,     0,     0,   429,     0,   430,   431,
       0,   432,   433,   434,     0,   435,   436,   437,   438,     0,
       0,   166,     0,   439,   440,   441,     0,   168,     0,   169,
       0,     0,     0,     0,   442,     0,   443,   444,   445,   446,
     447,     0,     0,   448,     0,     0,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   179,
       0,   181,     0,   462,   463,   464,   465,   182,     0,   466,
     467,     0,   468,     0,   185,   186,   469,   470,     0,     0,
     471,     0,     0,     0,   472,   473,     0,     0,   187,     0,
       0,   190,   474,   475,   476,     0,   191,   192,   477,   478,
       0,   479,   480,   481,   482,   483,   484,   194,   485,     0,
     486,   487,   488,   489,   490,   491,   492,   493,   494,   495,
     496,     0,   497,   201,   498,   499,   500,   501,   502,   503,
       0,   203,   504,   505,   506,     0,   507,   205,   508,   509,
       0,   510,   208,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   210,   519,     0,   520,   521,   522,   523,     0,
     211,   212,     0,   525,     0,   526,   213,   527,   214,     0,
     528,   529,   530,   531,   532,     0,     0,   533,   534,   535,
     536,   537,     0,     0,   538,   539,   540,   221,   541,     0,
     542,     0,     0,     0,   543,   544,   545,   546,   547,   548,
       0,   223,     0,     0,   224,   549,     0,     0,     0,     0,
      79,    80,    81,   354,     0,    83,    84,     0,    85,    86,
      87,   355,     0,   356,     0,    91,   225,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   357,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   358,   359,     0,     0,     0,
     360,   361,     0,     0,     0,     0,   362,     0,     0,     0,
       0,     0,     0,     0,     0,   363,     0,   364,     0,   365,
     366,     0,   367,   368,   369,   370,   371,   372,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
     377,   378,     0,   379,   380,   381,     0,   132,     0,   134,
       0,     0,   382,   383,     0,   384,     0,     0,   385,   386,
     135,   387,     0,   388,   389,   390,   391,   139,     0,     0,
     392,   393,   394,     0,   395,   396,   142,   397,     0,   398,
     399,     0,   400,     0,     0,     0,     0,   401,   402,   403,
     404,   405,   148,   149,   406,     0,   407,     0,   408,     0,
     409,   410,   411,     0,     0,     0,   412,   413,   414,   415,
       0,   416,   417,     0,   418,     0,   419,   420,   421,   155,
     422,     0,   157,     0,   423,   424,   159,     0,   425,     0,
     426,     0,     0,     0,   427,     0,   428,     0,     0,   429,
       0,   430,   431,     0,   432,   433,   434,     0,   435,   436,
     437,   438,     0,     0,   166,     0,   439,   440,   441,     0,
     168,     0,   169,     0,     0,     0,     0,   442,     0,   443,
     444,   445,   446,   447,     0,     0,   448,     0,     0,   449,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   461,   179,     0,   181,     0,   462,   463,   464,   465,
     182,     0,   466,   467,     0,   468,     0,   185,   186,   469,
     470,     0,     0,   471,     0,     0,     0,   472,   473,     0,
       0,   187,     0,     0,   190,   474,   475,   476,     0,   191,
     192,   477,   478,     0,   479,   480,   481,   482,   483,   484,
     194,   485,     0,   486,   487,   488,   489,   490,   491,   492,
     493,   494,   495,   496,     0,   497,   201,   498,   499,   500,
     501,   502,   503,     0,   203,   504,   505,   506,     0,   507,
     205,   508,   509,     0,   510,   208,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   210,   519,     0,   520,   521,
     522,   523,     0,   211,   212,     0,   525,     0,   526,   213,
     527,   214,     0,   528,   529,   530,   531,   532,     0,     0,
     533,   534,   535,   536,   537,     0,     0,   538,   539,   540,
     221,   541,     0,   542,     0,     0,     0,   543,   544,   545,
     546,   547,   548,     0,   223,     0,     0,   224,     0,     0,
       0,     0,     0,    79,    80,    81,   354,     0,    83,    84,
       0,    85,    86,    87,   355,     0,   356,     0,    91,   225,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     357,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   358,   359,
       0,     0,     0,   360,   361,     0,     0,     0,     0,   362,
       0,     0,     0,     0,     0,     0,     0,     0,   363,     0,
     364,     0,   365,   366,     0,   367,   368,   369,   370,   371,
     372,   373,     0,   374,   375,     0,     0,     0,     0,     0,
       0,     0,   376,   377,   378,     0,   379,   380,   381,     0,
     132,     0,   134,     0,     0,   382,   383,     0,   384,     0,
       0,   385,   386,   135,   387,     0,   388,   389,   390,   391,
     139,     0,     0,   392,   393,   394,     0,   395,   396,   142,
     397,     0,   398,   399,     0,   400,     0,     0,     0,     0,
     401,   402,   403,   404,   405,   148,   149,   406,     0,   407,
       0,   408,     0,   409,   410,   411,     0,     0,     0,   412,
     413,   414,   415,     0,   416,   417,     0,   418,     0,   419,
     420,   421,   155,   422,     0,   157,     0,   423,   424,   159,
       0,   425,     0,   426,     0,     0,     0,   427,     0,   428,
       0,     0,   429,     0,   430,   431,     0,   432,   433,   434,
       0,   435,   436,   437,   438,     0,     0,   166,     0,   439,
     440,   441,     0,   168,     0,   169,     0,     0,     0,     0,
     442,     0,   443,   444,   445,   446,   447,     0,     0,   448,
       0,     0,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   179,     0,   181,     0,   462,
     463,   464,   465,   182,     0,   466,   467,     0,   468,     0,
     185,   186,   469,   470,     0,     0,   471,     0,     0,     0,
     472,   473,     0,     0,   187,     0,     0,   190,   474,   475,
     476,     0,   191,   192,   477,   478,     0,   479,   480,   481,
     482,   483,   484,   194,   485,     0,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,   496,     0,   497,   201,
     498,   499,   500,   501,   502,   503,     0,     0,   504,   505,
     506,     0,   507,   205,   508,   509,     0,   510,   208,     0,
     511,   512,   513,   514,   515,   516,   517,   518,   210,   519,
       0,   520,   521,   522,   523,     0,   211,   212,     0,   525,
       0,   526,   213,   527,   214,     0,   528,   529,   530,   531,
     532,     0,     0,   533,   534,   535,   536,   537,     0,     0,
     538,   539,   540,   221,   541,     0,   542,     0,     0,     0,
     543,   544,   545,   546,   547,   548,     0,   223,     0,     0,
     224,     0,     0,     0,     0,     0,    79,    80,    81,   354,
       0,    83,    84,     0,    85,    86,    87,   355,     0,   356,
       0,    91,  1677,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   357,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   358,   359,     0,     0,     0,   360,   361,     0,     0,
       0,     0,   362,     0,     0,     0,     0,     0,     0,     0,
       0,   363,     0,   364,     0,   365,   366,     0,   367,   368,
     369,   370,   371,   372,   373,     0,   374,   375,     0,     0,
       0,     0,     0,     0,     0,   376,   377,   378,     0,   379,
     380,   381,     0,   132,     0,   134,     0,     0,   382,   383,
       0,   384,     0,     0,   385,   386,   135,   387,     0,   388,
     389,   390,   391,   139,     0,     0,   392,   393,   394,     0,
     395,   396,   142,   397,     0,   398,   399,     0,   400,     0,
       0,     0,     0,   401,   402,   403,   404,   405,   148,   149,
     406,     0,   407,     0,   408,     0,   409,   410,   411,     0,
       0,     0,   412,   413,   414,   415,     0,   416,   417,     0,
     418,     0,   419,   420,   421,   155,   422,     0,   157,     0,
     423,   424,   159,     0,   425,     0,   426,     0,     0,     0,
     427,     0,   428,     0,     0,   429,     0,   430,   431,     0,
     432,   433,   434,     0,   435,   436,   437,   438,     0,     0,
     166,     0,   439,   440,   441,     0,   168,     0,   169,     0,
       0,     0,     0,   442,     0,   443,   444,   445,   446,   447,
       0,     0,   448,     0,     0,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   179,     0,
     181,     0,   462,   463,   464,   465,   182,     0,   466,   467,
       0,   468,     0,   185,   186,   469,   470,     0,     0,   471,
       0,     0,     0,   472,   473,     0,     0,   187,     0,     0,
     190,   474,   475,   476,     0,   191,   192,   477,   478,     0,
     479,   480,   481,   482,   483,   484,   194,   485,     0,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
       0,   497,   201,   498,   499,   500,   501,   502,   503,     0,
       0,   504,   505,   506,     0,   507,   205,   508,   509,     0,
     510,   208,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   210,   519,     0,   520,   521,   522,   523,     0,   211,
     212,     0,   525,     0,   526,   213,   527,   214,     0,   528,
     529,   530,   531,   532,     0,     0,   533,   534,   535,   536,
     537,     0,     0,   538,   539,   540,   221,   541,     0,   542,
       0,     0,     0,   543,   544,   545,   546,   547,   548,     0,
     223,     0,     0,   224,     0,     0,     0,     0,   582,    79,
      80,    81,   354,     0,    83,    84,     0,    85,    86,    87,
     355,     0,   356,     0,    91,  2879,    93,    94,    95,    96,
      97,    98,   583,    99,   100,   101,   357,   584,     0,   103,
     104,   105,   106,   585,   586,     0,   108,   109,   110,     0,
     111,   587,   588,   114,   358,   359,     0,     0,     0,   360,
     361,     0,     0,     0,     0,   362,     0,     0,     0,     0,
       0,     0,     0,     0,   363,     0,   364,     0,   365,   366,
       0,   367,   368,   369,   370,   371,   372,   373,     0,   374,
     375,     0,     0,     0,     0,     0,     0,     0,   376,   377,
     378,     0,   379,   380,   381,     0,  1401,     0,  1402,  1119,
       0,   382,   383,     0,   384,     0,     0,   385,  1403,  1404,
     387,     0,   388,   389,   390,   391,     0,     0,     0,   392,
     393,   394,     0,   395,   396,     0,   397,     0,   398,   399,
       0,   400,     0,     0,     0,     0,   401,   402,   403,   404,
     405,  1405,  1406,   406,     0,   407,     0,   408,     0,   409,
     410,   411,     0,     0,     0,   412,  1132,   414,   415,     0,
     416,   417,     0,   418,     0,   419,   420,   421,     0,   422,
       0,     0,     0,   423,   424,  1407,     0,   425,     0,   426,
       0,     0,     0,   427,     0,   428,     0,     0,   429,     0,
     430,   431,     0,   432,   433,   434,     0,   435,   436,   437,
     438,     0,     0,     0,     0,   439,   440,   441,  1137,  1408,
       0,  1409,     0,     0,     0,     0,   442,     0,   443,   444,
     445,   446,   447,     0,     0,   448,     0,     0,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,  1410,     0,  1411,     0,   462,   463,   464,   465,     0,
       0,   466,   467,     0,   468,     0,     0,  1412,   469,   470,
       0,     0,   471,     0,     0,     0,  2536,   473,     0,     0,
       0,     0,     0,     0,   474,   475,   476,     0,     0,     0,
     477,   478,     0,   479,   480,   481,   482,   483,   484,  1413,
     485,     0,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,     0,   497,     0,   498,   499,   500,   501,
     502,   503,     0,     0,   504,   505,   506,     0,   507,  1414,
     508,   509,     0,   510,  1415,     0,   511,   512,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   520,   521,   522,
     523,     0,  1416,  1417,     0,   525,     0,   526,     0,   527,
       0,     0,   528,   529,   530,   531,   532,     0,     0,   533,
     534,   535,   536,   537,     0,     0,   538,   539,   540,  1418,
     541,     0,   542,     0,     0,     0,   543,   544,   545,   546,
     547,   548,     0,   223,    49,   978,   224,   549,     0,     0,
       0,     0,    52,     0,    53,   979,   980,   981,     0,   982,
    2537,   984,   985,   986,   987,    79,    80,    81,   354,     0,
      83,    84,     0,    85,    86,    87,   355,     0,   356,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   357,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     358,   359,     0,     0,     0,   360,   361,     0,     0,     0,
       0,   362,     0,     0,     0,     0,     0,     0,     0,     0,
     363,     0,   364,     0,   365,   366,     0,   367,   368,   369,
     370,   371,   372,   373,     0,   374,   375,     0,     0,     0,
       0,     0,     0,     0,   376,   377,   378,     0,   379,   380,
     381,     0,   132,     0,   134,     0,     0,   382,   383,     0,
     384,     0,     0,   385,   386,   135,   387,     0,   388,   977,
     390,   391,   139,     0,     0,   392,   393,   394,     0,   395,
     396,   142,   397,     0,   398,   399,     0,   400,     0,     0,
       0,     0,   401,   402,   403,   404,   405,   148,   149,   406,
       0,   407,     0,   408,     0,   409,   410,   411,     0,     0,
       0,   412,   413,   414,   415,     0,   416,   417,     0,   418,
       0,   419,   420,   421,   155,   422,     0,   157,     0,   423,
     424,   159,     0,   425,     0,   426,     0,     0,     0,   427,
       0,   428,     0,     0,   429,     0,   430,   431,     0,   432,
     433,   434,     0,   435,   436,   437,   438,     0,     0,   166,
       0,   439,   440,   441,     0,   168,     0,   169,     0,     0,
       0,     0,   442,     0,   443,   444,   445,   446,   447,     0,
       0,   448,     0,     0,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   179,     0,   181,
       0,   462,   463,   464,   465,   182,     0,   466,   467,     0,
     468,     0,   185,   186,   469,   470,     0,     0,   471,     0,
       0,     0,   472,   473,     0,     0,   187,     0,     0,   190,
     474,   475,   476,     0,   191,   192,   477,   478,     0,   479,
     480,   481,   482,   483,   484,   194,   485,     0,   486,   487,
     488,   489,   490,   491,   492,   493,   494,   495,   496,     0,
     497,   201,   498,   499,   500,   501,   502,   503,     0,     0,
     504,   505,   506,     0,   507,   205,   508,   509,     0,   510,
     208,     0,   511,   512,   513,   514,   515,   516,   517,   518,
     210,   519,     0,   520,   521,   522,   523,     0,   211,   212,
       0,   525,     0,   526,   213,   527,   214,     0,   528,   529,
     530,   531,   532,     0,     0,   533,   534,   535,   536,   537,
       0,     0,   538,   539,   540,   221,   541,     0,   542,     0,
       0,     0,   543,   544,   545,   546,   547,   548,     0,   223,
       0,   978,   224,     0,     0,     0,     0,     0,     0,     0,
       0,   979,   980,   981,     0,   982,   983,   984,   985,   986,
     987,    79,    80,    81,   354,     0,    83,    84,     0,    85,
      86,    87,   355,     0,   356,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   357,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   358,   359,     0,     0,
       0,   360,   361,     0,     0,     0,     0,   362,     0,     0,
       0,     0,     0,     0,     0,     0,   363,     0,   364,     0,
     365,   366,     0,   367,   368,   369,   370,   371,   372,   373,
       0,   374,   375,     0,     0,     0,     0,     0,     0,     0,
     376,   377,   378,     0,   379,   380,   381,     0,   132,     0,
     134,     0,     0,   382,   383,     0,   384,     0,     0,   385,
     386,   135,   387,     0,   388,   389,   390,   391,   139,     0,
       0,   392,   393,   394,     0,   395,   396,   142,   397,     0,
     398,   399,     0,   400,     0,     0,     0,     0,   401,   402,
     403,   404,   405,   148,   149,   406,     0,   407,     0,   408,
       0,   409,   410,   411,     0,     0,     0,   412,   413,   414,
     415,     0,   416,   417,     0,   418,     0,   419,   420,   421,
     155,   422,     0,   157,     0,   423,   424,   159,     0,   425,
       0,   426,     0,     0,     0,   427,     0,   428,     0,     0,
     429,     0,   430,   431,     0,   432,   433,   434,     0,   435,
     436,   437,   438,     0,     0,   166,     0,   439,   440,   441,
       0,   168,     0,   169,     0,     0,     0,     0,   442,     0,
     443,   444,   445,   446,   447,     0,     0,   448,     0,     0,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   179,     0,   181,     0,   462,   463,   464,
     465,   182,     0,   466,   467,     0,   468,     0,   185,   186,
     469,   470,     0,     0,   471,     0,     0,     0,   472,   473,
       0,     0,   187,     0,     0,   190,   474,   475,   476,     0,
     191,   192,   477,   478,     0,   479,   480,   481,   482,   483,
     484,   194,   485,     0,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   496,     0,   497,   201,   498,   499,
     500,   501,   502,   503,     0,     0,   504,   505,   506,     0,
     507,   205,   508,   509,     0,   510,   208,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   210,   519,     0,   520,
     521,   522,   523,     0,   211,   212,     0,   525,     0,   526,
     213,   527,   214,     0,   528,   529,   530,   531,   532,     0,
       0,   533,   534,   535,   536,   537,     0,     0,   538,   539,
     540,   221,   541,     0,   542,     0,     0,     0,   543,   544,
     545,   546,   547,   548,     0,   223,     0,   978,   224,     0,
       0,     0,     0,     0,     0,     0,     0,   979,   980,   981,
       0,   982,   983,   984,   985,   986,   987,   582,    79,    80,
      81,   354,     0,    83,    84,     0,    85,    86,    87,   355,
       0,   356,     0,    91,     0,    93,    94,    95,    96,    97,
      98,   583,    99,   100,   101,   357,   584,     0,   103,   104,
     105,   106,   585,   586,     0,   108,   109,   110,     0,   111,
     587,   588,   114,   358,   359,     0,     0,     0,   360,   361,
       0,     0,     0,     0,   362,     0,     0,     0,     0,     0,
       0,     0,     0,   363,     0,   364,     0,   365,   366,     0,
     367,   368,   369,   370,   371,   372,   373,   589,   374,   375,
     590,   591,   592,   593,   594,   595,   596,   376,   377,   378,
     129,   379,   380,   381,   131,   132,   133,   134,     0,   597,
     382,   383,     0,   384,   598,   599,   385,   600,   135,   387,
     601,   388,   389,   390,   391,   139,   602,   603,   392,   393,
     394,   604,   395,   396,   142,   397,   605,   398,   399,   145,
     400,   606,   607,   608,   609,   401,   402,   403,   404,   405,
     148,   149,   406,   610,   407,   611,   408,     0,   409,   410,
     411,   612,   613,   614,   412,   413,   414,   415,   615,   416,
     417,   616,   418,   617,   419,   420,   421,   155,   422,     0,
     157,   618,   423,   424,   159,   619,   425,   620,   426,   160,
     621,   161,   427,     0,   428,   622,   623,   429,   624,   430,
     431,   164,   432,   433,   434,   625,   435,   436,   437,   438,
     626,   165,   166,   627,   439,   440,   441,   628,   168,   629,
     169,   630,     0,   170,   171,   442,   172,   443,   444,   445,
     446,   447,   631,   173,   448,   174,   632,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     179,   180,   181,   633,   462,   463,   464,   465,   182,   634,
     466,   467,   184,   468,   635,   185,   186,   469,   470,   636,
     637,   471,   638,   639,   640,   472,   473,   641,   642,   187,
     188,   189,   190,   474,   475,   476,     0,   191,   192,   477,
     478,   643,   479,   480,   481,   482,   483,   484,   194,   485,
     644,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   199,   497,   201,   498,   499,   500,   501,   502,
     503,     0,   645,   504,   505,   506,   646,   507,   205,   508,
     509,   207,   510,   208,   647,   511,   512,   513,   514,   515,
     516,   517,   518,   210,   519,   648,   520,   521,   522,   523,
     649,   211,   212,   650,   525,   651,   526,   213,   527,   214,
     652,   528,   529,   530,   531,   532,   653,   654,   533,   534,
     535,   536,   537,   655,   656,   538,   539,   540,   221,   541,
     222,   542,     0,   657,   658,   543,   544,   545,   546,   547,
     548,     0,   223,     0,     0,   224,     0,   582,    79,    80,
      81,   354,     0,    83,    84,     0,    85,    86,    87,   355,
    1381,   356,     0,    91,     0,    93,    94,    95,    96,    97,
      98,   583,    99,   100,   101,   357,   584,     0,   103,   104,
     105,   106,   585,   586,     0,   108,   109,   110,     0,   111,
     587,   588,   114,   358,   359,     0,     0,     0,   360,   361,
       0,     0,     0,     0,   362,     0,     0,     0,     0,     0,
       0,     0,     0,   363,     0,   364,     0,   365,   366,     0,
     367,   368,   369,   370,   371,   372,   373,     0,   374,   375,
       0,     0,     0,     0,     0,     0,     0,   376,   377,   378,
       0,   379,   380,   381,     0,  1401,     0,  1402,  1119,     0,
     382,   383,     0,   384,     0,     0,   385,  1403,  1404,   387,
       0,   388,   389,   390,   391,     0,     0,     0,   392,   393,
     394,     0,   395,   396,     0,   397,     0,   398,   399,     0,
     400,     0,     0,     0,     0,   401,   402,   403,   404,   405,
    1405,  1406,   406,     0,   407,     0,   408,     0,   409,   410,
     411,     0,     0,     0,   412,  1132,   414,   415,     0,   416,
     417,     0,   418,     0,   419,   420,   421,     0,   422,     0,
       0,     0,   423,   424,  1407,     0,   425,     0,   426,     0,
       0,     0,   427,     0,   428,     0,     0,   429,     0,   430,
     431,     0,   432,   433,   434,     0,   435,   436,   437,   438,
       0,     0,     0,     0,   439,   440,   441,  1137,  1408,     0,
    1409,     0,     0,     0,     0,   442,     0,   443,   444,   445,
     446,   447,     0,     0,   448,     0,     0,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
    1410,     0,  1411,     0,   462,   463,   464,   465,     0,     0,
     466,   467,     0,   468,     0,     0,  1412,   469,   470,     0,
       0,   471,     0,     0,     0,   472,   473,     0,     0,     0,
       0,     0,     0,   474,   475,   476,     0,     0,     0,   477,
     478,     0,   479,   480,   481,   482,   483,   484,  1413,   485,
       0,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,     0,   497,     0,   498,   499,   500,   501,   502,
     503,     0,     0,   504,   505,   506,     0,   507,  1414,   508,
     509,     0,   510,  1415,     0,   511,   512,   513,   514,   515,
     516,   517,   518,     0,   519,     0,   520,   521,   522,   523,
       0,  1416,  1417,     0,   525,     0,   526,     0,   527,     0,
       0,   528,   529,   530,   531,   532,     0,     0,   533,   534,
     535,   536,   537,     0,     0,   538,   539,   540,  1418,   541,
       0,   542,     0,     0,     0,   543,   544,   545,   546,   547,
     548,     0,   223,     0,     0,   224,    79,    80,    81,   354,
       0,    83,    84,     0,    85,    86,    87,   355,     0,   356,
    1747,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   357,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   358,   359,     0,     0,     0,   360,   361,     0,     0,
       0,     0,   362,     0,     0,     0,     0,     0,     0,     0,
       0,   363,     0,   364,     0,   365,   366,     0,   367,   368,
     369,   370,   371,   372,   373,     0,   374,   375,     0,     0,
       0,     0,     0,     0,     0,   376,   377,   378,     0,   379,
     380,   381,     0,   132,     0,   134,     0,     0,   382,   383,
       0,   384,     0,     0,   385,   386,   135,   387,     0,   388,
     389,   390,   391,   139,     0,     0,   392,   393,   394,     0,
     395,   396,   142,   397,     0,   398,   399,     0,   400,     0,
       0,     0,     0,   401,   402,   403,   404,   405,   148,   149,
     406,     0,   407,     0,   408,     0,   409,   410,   411,     0,
       0,     0,   412,   413,   414,   415,     0,   416,   417,     0,
     418,     0,   419,   420,   421,   155,   422,     0,   157,     0,
     423,   424,   159,     0,   425,     0,   426,     0,     0,     0,
     427,     0,   428,     0,     0,   429,     0,   430,   431,     0,
     432,   433,   434,     0,   435,   436,   437,   438,     0,     0,
     166,     0,   439,   440,   441,     0,   168,     0,   169,     0,
       0,     0,     0,   442,     0,   443,   444,   445,   446,   447,
       0,     0,   448,     0,     0,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   179,     0,
     181,   707,   462,   463,   464,   465,   182,     0,   466,   467,
       0,   468,     0,   185,   186,   469,   470,     0,     0,   471,
     708,     0,     0,   472,   473,     0,     0,   187,     0,     0,
     190,   474,   475,   476,     0,   191,   192,   477,   478,     0,
     479,   480,   481,   482,   483,   484,   194,   485,     0,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
       0,   497,   201,   498,   499,   500,   501,   502,   503,     0,
       0,   504,   505,   506,     0,   507,   205,   508,   509,     0,
     510,   208,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   210,   519,     0,   520,   521,   522,   523,     0,   211,
     212,     0,   525,     0,   526,   213,   527,   214,     0,   528,
     529,   530,   531,   532,     0,     0,   533,   534,   535,   536,
     537,     0,     0,   538,   539,   540,   221,   541,     0,   542,
       0,     0,     0,   543,   544,   545,   546,   547,   548,     0,
     223,     0,     0,   224,    79,    80,    81,   354,     0,    83,
      84,     0,    85,    86,    87,   355,     0,   356,   867,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   357,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   358,
     359,     0,     0,     0,   360,   361,     0,     0,     0,     0,
     362,     0,     0,     0,     0,     0,     0,     0,     0,   363,
       0,   364,     0,   365,   366,     0,   367,   368,   369,   370,
     371,   372,   373,     0,   374,   375,     0,     0,     0,     0,
       0,     0,     0,   376,   377,   378,     0,   379,   380,   381,
       0,   132,     0,   134,     0,     0,   382,   383,     0,   384,
       0,     0,   385,   386,   135,   387,     0,   388,   389,   390,
     391,   139,     0,     0,   392,   393,   394,     0,   395,   396,
     142,   397,     0,   398,   399,     0,   400,     0,     0,     0,
       0,   401,   402,   403,   404,   405,   148,   149,   406,  1661,
     407,     0,   408,     0,   409,   410,   411,     0,     0,     0,
     412,   413,   414,   415,     0,   416,   417,     0,   418,     0,
     419,   420,   421,   155,   422,     0,   157,  1662,   423,   424,
     159,     0,   425,     0,   426,     0,     0,     0,   427,     0,
     428,     0,     0,   429,     0,   430,   431,     0,   432,   433,
     434,     0,   435,   436,   437,   438,     0,     0,   166,     0,
     439,   440,   441,     0,   168,     0,   169,     0,     0,     0,
       0,   442,     0,   443,   444,   445,   446,   447,     0,     0,
     448,     0,     0,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   179,     0,   181,     0,
     462,   463,   464,   465,   182,     0,   466,   467,     0,   468,
       0,   185,   186,   469,   470,  1663,     0,   471,     0,  1664,
       0,   472,   473,     0,     0,   187,     0,     0,   190,   474,
     475,   476,     0,   191,   192,   477,   478,     0,   479,   480,
     481,   482,   483,   484,   194,   485,     0,   486,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,     0,   497,
     201,   498,   499,   500,   501,   502,   503,     0,     0,   504,
     505,   506,     0,   507,   205,   508,   509,     0,   510,   208,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   210,
     519,     0,   520,   521,   522,   523,     0,   211,   212,     0,
     525,     0,   526,   213,   527,   214,  1665,   528,   529,   530,
     531,   532,     0,     0,   533,   534,   535,   536,   537,     0,
       0,   538,   539,   540,   221,   541,     0,   542,     0,     0,
       0,   543,   544,   545,   546,   547,   548,     0,   223,    49,
       0,   224,   549,     0,     0,     0,     0,    52,     0,    53,
       0,    79,    80,    81,   354,  1276,    83,    84,     0,    85,
      86,    87,   355,     0,   356,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   357,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   358,   359,     0,     0,
       0,   360,   361,     0,     0,     0,     0,   362,     0,     0,
       0,     0,     0,     0,     0,     0,   363,     0,   364,     0,
     365,   366,     0,   367,   368,   369,   370,   371,   372,   373,
       0,   374,   375,     0,     0,     0,     0,     0,     0,     0,
     376,   377,   378,     0,   379,   380,   381,     0,   132,     0,
     134,     0,     0,   382,   383,     0,   384,     0,     0,   385,
     386,   135,   387,     0,   388,   389,   390,   391,   139,     0,
       0,   392,   393,   394,     0,   395,   396,   142,   397,     0,
     398,   399,     0,   400,     0,     0,     0,     0,   401,   402,
     403,   404,   405,   148,   149,   406,     0,   407,     0,   408,
       0,   409,   410,   411,     0,     0,     0,   412,   413,   414,
     415,     0,   416,   417,     0,   418,     0,   419,   420,   421,
     155,   422,     0,   157,  1662,   423,   424,   159,     0,   425,
       0,   426,     0,     0,     0,   427,     0,   428,     0,     0,
     429,     0,   430,   431,     0,   432,   433,   434,     0,   435,
     436,   437,   438,     0,     0,   166,     0,   439,   440,   441,
       0,   168,     0,   169,     0,     0,     0,     0,   442,     0,
     443,   444,   445,   446,   447,     0,     0,   448,     0,     0,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   179,     0,   181,     0,   462,   463,   464,
     465,   182,     0,   466,   467,     0,   468,     0,   185,   186,
     469,   470,  1663,     0,   471,     0,  1664,     0,   472,   473,
       0,     0,   187,     0,     0,   190,   474,   475,   476,     0,
     191,   192,   477,   478,     0,   479,   480,   481,   482,   483,
     484,   194,   485,     0,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   496,     0,   497,   201,   498,   499,
     500,   501,   502,   503,     0,     0,   504,   505,   506,     0,
     507,   205,   508,   509,     0,   510,   208,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   210,   519,     0,   520,
     521,   522,   523,     0,   211,   212,     0,   525,     0,   526,
     213,   527,   214,  1665,   528,   529,   530,   531,   532,     0,
       0,   533,   534,   535,   536,   537,     0,     0,   538,   539,
     540,   221,   541,     0,   542,     0,     0,     0,   543,   544,
     545,   546,   547,   548,     0,   223,    49,     0,   224,   549,
       0,     0,     0,     0,    52,     0,    53,     0,    79,    80,
      81,   354,  1276,    83,    84,     0,    85,    86,    87,   355,
       0,   356,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   357,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   358,   359,     0,     0,     0,   360,   361,
       0,     0,     0,     0,   362,     0,     0,     0,     0,     0,
       0,     0,     0,   363,     0,   364,     0,   365,   366,     0,
     367,   780,   369,   370,   371,   372,   373,   781,   374,   375,
       0,     0,     0,     0,     0,     0,     0,   376,   377,   378,
       0,   782,   380,   381,     0,   132,     0,   134,     0,     0,
     382,   383,     0,   384,     0,     0,   385,   386,   135,   387,
       0,   388,   389,   390,   391,   139,     0,     0,   392,   393,
     394,     0,   395,   396,   142,   397,     0,   398,   399,     0,
     400,     0,     0,     0,     0,   401,   402,   403,   404,   405,
     148,   149,   406,     0,   407,     0,   408,     0,   409,   410,
     411,     0,     0,     0,   412,   413,   414,   415,     0,   416,
     417,     0,   418,     0,   419,   420,   421,   155,   422,     0,
     157,     0,   423,   783,   159,     0,   425,     0,   784,     0,
     785,     0,   427,     0,   428,     0,     0,   429,     0,   430,
     431,     0,   432,   433,   434,   786,   435,   436,   437,   438,
       0,     0,   166,     0,   439,   440,   441,     0,   168,     0,
     169,     0,     0,     0,     0,   442,     0,   443,   444,   445,
     446,   787,     0,     0,   448,     0,     0,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     179,     0,   181,     0,   788,   463,   464,   465,   182,     0,
     466,   467,     0,   468,     0,   185,   186,   469,   470,     0,
       0,   471,     0,     0,     0,   472,   473,     0,     0,   187,
       0,     0,   190,   474,   475,   476,     0,   191,   192,   477,
     478,     0,   789,   480,   481,   482,   483,   484,   194,   485,
       0,   486,   790,   488,   489,   490,   491,   492,   493,   494,
     495,   496,     0,   497,   201,   498,   499,   500,   501,   502,
     503,     0,     0,   504,   505,   506,     0,   507,   205,   508,
     509,     0,   510,   208,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   210,   519,     0,   520,   521,   522,   523,
       0,   211,   212,     0,   525,     0,   526,   213,   527,   214,
       0,   528,   529,   530,   531,   532,     0,     0,   533,   534,
     535,   536,   537,     0,     0,   538,   539,   540,   221,   541,
       0,   542,     0,     0,     0,   543,   544,   545,   546,   547,
     548,     0,   223,     0,     0,   224,   549,    79,    80,    81,
     354,    52,    83,    84,     0,    85,    86,    87,   355,   791,
     356,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   357,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   358,   359,     0,     0,     0,   360,   361,     0,
       0,     0,     0,   362,     0,     0,     0,     0,     0,     0,
       0,     0,   363,     0,   364,     0,   365,   366,     0,   367,
     780,   369,   370,   371,   372,   373,   781,   374,   375,     0,
       0,     0,     0,     0,     0,     0,   376,   377,   378,     0,
     782,   380,   381,     0,   132,     0,   134,     0,     0,   382,
     383,     0,   384,     0,     0,   385,   386,   135,   387,     0,
     388,   389,   390,   391,   139,     0,     0,   392,   393,   394,
       0,   395,   396,   142,   397,     0,   398,   399,     0,   400,
       0,     0,     0,     0,   401,   402,   403,   404,   405,   148,
     149,   406,     0,   407,     0,   408,     0,   409,   410,   411,
       0,     0,     0,   412,   413,   414,   415,     0,   416,   417,
       0,   418,     0,   419,   420,   421,   155,   422,     0,   157,
       0,   423,   783,   159,     0,   425,     0,   784,     0,     0,
       0,   427,     0,   428,     0,     0,   429,     0,   430,   431,
       0,   432,   433,   434,     0,   435,   436,   437,   438,     0,
       0,   166,     0,   439,   440,   441,     0,   168,     0,   169,
       0,     0,     0,     0,   442,     0,   443,   444,   445,   446,
     787,     0,     0,   448,     0,     0,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   179,
       0,   181,     0,   788,   463,   464,   465,   182,     0,   466,
     467,     0,   468,     0,   185,   186,   469,   470,     0,     0,
     471,     0,     0,     0,   472,   473,     0,     0,   187,     0,
       0,   190,   474,   475,   476,     0,   191,   192,   477,   478,
       0,   789,   480,   481,   482,   483,   484,   194,   485,     0,
     486,   790,   488,   489,   490,   491,   492,   493,   494,   495,
     496,     0,   497,   201,   498,   499,   500,   501,   502,   503,
       0,     0,   504,   505,   506,     0,   507,   205,   508,   509,
       0,   510,   208,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   210,   519,     0,   520,   521,   522,   523,     0,
     211,   212,     0,   525,     0,   526,   213,   527,   214,     0,
     528,   529,   530,   531,   532,     0,     0,   533,   534,   535,
     536,   537,     0,     0,   538,   539,   540,   221,   541,     0,
     542,     0,     0,     0,   543,   544,   545,   546,   547,   548,
       0,   223,     0,     0,   224,   549,    79,    80,    81,   354,
      52,    83,    84,     0,    85,    86,    87,   355,   791,   356,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   357,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   358,   359,     0,     0,     0,   360,   361,     0,     0,
       0,     0,   362,     0,     0,     0,     0,     0,     0,     0,
       0,   363,     0,   364,     0,   365,   366,     0,   367,   368,
     369,   370,   371,   372,   373,     0,   374,   375,     0,     0,
       0,     0,     0,     0,     0,   376,   377,   378,     0,   379,
     380,   381,     0,   132,     0,   134,     0,     0,   382,   383,
       0,   384,     0,     0,   385,   386,   135,   387,     0,   388,
     389,   390,   391,   139,     0,     0,   392,   393,   394,     0,
     395,   396,   142,   397,     0,   398,   399,     0,   400,     0,
       0,     0,     0,   401,   402,   403,   404,   405,   148,   149,
     406,   572,   407,     0,   408,     0,   409,   410,   411,     0,
       0,     0,   412,   413,   414,   415,     0,   416,   417,     0,
     418,     0,   419,   420,   421,   155,   422,     0,   157,     0,
     423,   424,   159,     0,   425,     0,   426,     0,     0,     0,
     427,     0,   428,     0,     0,   429,     0,   430,   431,     0,
     432,   433,   434,     0,   435,   436,   437,   438,     0,     0,
     166,     0,   439,   440,   441,     0,   168,     0,   169,     0,
       0,     0,     0,   442,     0,   443,   444,   445,   446,   447,
       0,     0,   448,     0,     0,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   179,     0,
     181,     0,   462,   463,   464,   465,   182,     0,   466,   467,
       0,   468,     0,   185,   186,   469,   470,     0,     0,   471,
       0,     0,     0,   472,   473,     0,     0,   187,     0,     0,
     190,   474,   475,   476,     0,   191,   192,   477,   478,     0,
     479,   480,   481,   482,   483,   484,   194,   485,     0,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
       0,   497,   201,   498,   499,   500,   501,   502,   503,     0,
       0,   504,   505,   506,     0,   507,   205,   508,   509,     0,
     510,   208,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   210,   519,     0,   520,   521,   522,   523,     0,   211,
     212,  1214,   525,     0,   526,   213,   527,   214,     0,   528,
     529,   530,   531,   532,     0,     0,   533,   534,   535,   536,
     537,     0,     0,   538,   539,   540,   221,   541,     0,   542,
       0,     0,     0,   543,   544,   545,   546,   547,   548,     0,
     223,     0,     0,   224,   549,    79,    80,    81,   354,     0,
      83,    84,  1215,    85,    86,    87,   355,     0,   356,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   357,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     358,   359,     0,     0,     0,   360,   361,     0,     0,     0,
       0,   362,     0,     0,     0,     0,     0,     0,     0,     0,
     363,     0,   364,     0,   365,   366,     0,   367,   368,   369,
     370,   371,   372,   373,     0,   374,   375,     0,     0,     0,
       0,     0,     0,     0,   376,   377,   378,     0,   379,   380,
     381,     0,   132,     0,   134,     0,     0,   382,   383,     0,
     384,     0,     0,   385,   386,   135,   387,     0,   388,   389,
     390,   391,   139,     0,     0,   392,   393,   394,     0,   395,
     396,   142,   397,     0,   398,   399,     0,   400,     0,     0,
       0,     0,   401,   402,   403,   404,   405,   148,   149,   406,
       0,   407,     0,   408,     0,   409,   410,   411,     0,     0,
       0,   412,   413,   414,   415,     0,   416,   417,     0,   418,
       0,   419,   420,   421,   155,   422,     0,   157,     0,   423,
     424,   159,     0,   425,     0,   426,     0,     0,     0,   427,
       0,   428,     0,     0,   429,     0,   430,   431,     0,   432,
     433,   434,     0,   435,   436,   437,   438,     0,     0,   166,
       0,   439,   440,   441,     0,   168,     0,   169,     0,     0,
       0,     0,   442,     0,   443,   444,   445,   446,   447,     0,
       0,   448,     0,     0,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   179,     0,   181,
       0,   462,   463,   464,   465,   182,     0,   466,   467,     0,
     468,     0,   185,   186,   469,   470,     0,     0,   471,     0,
       0,     0,   472,   473,     0,     0,   187,     0,     0,   190,
     474,   475,   476,     0,   191,   192,   477,   478,     0,   479,
     480,   481,   482,   483,   484,   194,   485,     0,   486,   487,
     488,   489,   490,   491,   492,   493,   494,   495,   496,     0,
     497,   201,   498,   499,   500,   501,   502,   503,     0,     0,
     504,   505,   506,     0,   507,   205,   508,   509,     0,   510,
     208,     0,   511,   512,   513,   514,   515,   516,   517,   518,
     210,   519,     0,   520,   521,   522,   523,     0,   211,   212,
       0,   525,     0,   526,   213,   527,   214,     0,   528,   529,
     530,   531,   532,     0,     0,   533,   534,   535,   536,   537,
       0,     0,   538,   539,   540,   221,   541,     0,   542,     0,
       0,     0,   543,   544,   545,   546,   547,   548,     0,   223,
      49,     0,   224,   549,     0,     0,  1163,  1164,    52,     0,
      53,    79,    80,    81,   354,     0,    83,    84,     0,    85,
      86,    87,   355,     0,   356,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   357,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   358,   359,     0,     0,
       0,   360,   361,     0,     0,     0,     0,   362,     0,     0,
       0,     0,     0,     0,     0,     0,   363,     0,   364,     0,
     365,   366,     0,   367,   368,   369,   370,   371,   372,   373,
       0,   374,   375,     0,     0,     0,     0,     0,     0,     0,
     376,   377,   378,     0,   379,   380,   381,     0,   132,     0,
     134,     0,     0,   382,   383,     0,   384,     0,     0,   385,
     386,   135,   387,     0,   388,   389,   390,   391,   139,     0,
       0,   392,   393,   394,     0,   395,   396,   142,   397,     0,
     398,   399,     0,   400,     0,     0,     0,     0,   401,   402,
     403,   404,   405,   148,   149,   406,     0,   407,     0,   408,
       0,   409,   410,   411,     0,     0,     0,   412,   413,   414,
     415,     0,   416,   417,     0,   418,     0,   419,   420,   421,
     155,   422,     0,   157,     0,   423,   424,   159,     0,   425,
       0,   426,     0,     0,     0,   427,     0,   428,     0,     0,
     429,     0,   430,   431,     0,   432,   433,   434,     0,   435,
     436,   437,   438,     0,     0,   166,     0,   439,   440,   441,
       0,   168,     0,   169,     0,     0,     0,     0,   442,     0,
     443,   444,   445,   446,   447,     0,     0,   448,     0,     0,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   179,     0,   181,     0,   462,   463,   464,
     465,   182,     0,   466,   467,     0,   468,     0,   185,   186,
     469,   470,     0,     0,   471,     0,     0,     0,   472,   473,
       0,     0,   187,     0,     0,   190,   474,   475,   476,     0,
     191,   192,   477,   478,     0,   479,   480,   481,   482,   483,
     484,   194,   485,     0,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   496,     0,   497,   201,   498,   499,
     500,   501,   502,   503,     0,     0,   504,   505,   506,     0,
     507,   205,   508,   509,     0,   510,   208,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   210,   519,     0,   520,
     521,   522,   523,     0,   211,   212,     0,   525,     0,   526,
     213,   527,   214,     0,   528,   529,   530,   531,   532,     0,
       0,   533,   534,   535,   536,   537,     0,     0,   538,   539,
     540,   221,   541,     0,   542,     0,     0,     0,   543,   544,
     545,   546,   547,   548,     0,   223,     0,     0,   224,     0,
     846,  1295,    79,    80,    81,   354,   847,    83,    84,     0,
      85,    86,    87,   355,   848,   356,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   357,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   358,   359,     0,
       0,     0,   360,   361,     0,     0,     0,     0,   362,     0,
       0,     0,     0,     0,     0,     0,     0,   363,     0,   364,
       0,   365,   366,     0,   367,   368,   369,   370,   371,   372,
     373,     0,   374,   375,     0,     0,     0,     0,     0,     0,
       0,   376,   377,   378,     0,   379,   380,   381,     0,   132,
       0,   134,     0,     0,   382,   383,     0,   384,     0,     0,
     385,   386,   135,   387,     0,   388,   389,   390,   391,   139,
       0,     0,   392,   393,   394,     0,   849,   396,   142,   397,
       0,   398,   399,     0,   400,     0,     0,     0,     0,   401,
     402,   403,   404,   405,   148,   149,   406,     0,   407,     0,
     408,     0,   409,   410,   411,     0,     0,     0,   412,   413,
     414,   415,     0,   416,   417,     0,   418,     0,   419,   420,
     421,   155,   422,     0,   157,     0,   423,   424,   159,     0,
     425,     0,   426,     0,     0,     0,   427,     0,   428,     0,
       0,   429,     0,   430,   431,     0,   432,   433,   434,     0,
     435,   436,   437,   438,     0,     0,   166,     0,   439,   440,
     441,     0,   168,     0,   169,     0,     0,     0,     0,   442,
       0,   443,   444,   445,   446,   447,     0,     0,   448,     0,
       0,   449,   450,   850,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   851,   179,     0,   181,     0,   462,   463,
     464,   465,   182,     0,   466,   467,     0,   468,     0,   185,
     186,   469,   470,     0,     0,   471,     0,     0,     0,   472,
     473,     0,     0,   187,     0,     0,   190,   474,   475,   476,
       0,   191,   192,   477,   478,     0,   479,   480,   481,   482,
     483,   484,   194,   485,     0,   486,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,     0,   497,   201,   498,
     499,   500,   501,   502,   503,     0,     0,   504,   505,   852,
       0,   507,   205,   508,   509,     0,   510,   208,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   210,   519,     0,
     520,   521,   522,   523,     0,   853,   212,     0,   525,     0,
     854,   213,   527,   214,     0,   528,   529,   530,   531,   532,
       0,     0,   533,   534,   535,   536,   537,     0,     0,   538,
     539,   540,   221,   541,     0,   542,     0,     0,     0,   543,
     544,   545,   546,   547,   548,     0,   223,     0,     0,   224,
     582,    79,    80,    81,   354,     0,    83,    84,     0,    85,
      86,    87,   355,     0,   356,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   583,    99,   100,   101,   357,   584,
       0,   103,   104,   105,   106,   585,   586,     0,   108,   109,
     110,     0,   111,   587,   588,   114,   358,   359,     0,     0,
       0,   360,   361,     0,     0,     0,     0,   362,     0,     0,
       0,     0,     0,     0,     0,     0,   363,     0,   364,     0,
     365,   366,     0,   367,   368,   369,   370,   371,   372,   373,
     589,   374,   375,   590,   591,   592,   593,   594,   595,   596,
     376,   377,   378,   129,   379,   380,   381,   131,   132,   133,
     134,     0,   597,   382,   383,     0,   384,   598,   599,   385,
     600,   135,   387,   601,   388,   389,   390,   391,   139,   602,
     603,   392,   393,   394,   604,   395,   396,   142,   397,   605,
     398,   399,   145,   400,   606,   607,   608,   609,   401,   402,
     403,   404,   405,   148,   149,   406,   610,   407,   611,   408,
       0,   409,   410,   411,   612,   613,   614,   412,   413,   414,
     415,   615,   416,   417,   616,   418,   617,   419,   420,   421,
     155,   422,     0,   157,   618,   423,   424,   159,   619,   425,
     620,   426,   160,   621,   161,   427,     0,   428,   622,   623,
     429,   624,   430,   431,   164,   432,   433,   434,   625,   435,
     436,   437,   438,   626,   165,   166,   627,   439,   440,   441,
     628,   168,   629,   169,   630,     0,   170,   171,   442,   172,
     443,   444,   445,   446,   447,   631,   173,   448,   174,   632,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   179,   180,   181,   633,   462,   463,   464,
     465,   182,   634,   466,   467,   184,   468,   635,   185,   186,
     469,   470,   636,   637,   471,   638,   639,   640,   472,   473,
     641,   642,   187,   188,   189,   190,   474,   475,   476,     0,
     191,   192,   477,   478,   643,   479,   480,   481,   482,   483,
     484,   194,   485,   644,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   496,   199,   497,   201,   498,   499,
     500,   501,   502,   503,     0,   645,   504,   505,   506,   646,
     507,   205,   508,   509,   207,   510,   208,   647,   511,   512,
     513,   514,   515,   516,   517,   518,   210,   519,   648,   520,
     521,   522,   523,   649,   211,   212,   650,   525,   651,   526,
     213,   527,   214,   652,   528,   529,   530,   531,   532,   653,
     654,   533,   534,   535,   536,   537,   655,   656,   538,   539,
     540,   221,   541,   222,   542,     0,   657,   658,   543,   544,
     545,   546,   547,   548,     0,   223,     0,     0,   224,   582,
      79,    80,    81,   354,     0,    83,    84,     0,    85,    86,
      87,   355,     0,   356,     0,    91,     0,    93,    94,    95,
      96,    97,    98,   583,    99,   100,   101,   357,   584,     0,
     103,   104,   105,   106,   585,   586,     0,   108,   109,   110,
       0,   111,   587,   588,   114,   358,   359,     0,     0,     0,
     360,   361,     0,     0,     0,     0,   362,     0,     0,     0,
       0,     0,     0,     0,     0,   363,     0,   364,     0,   365,
     366,     0,   367,   368,   369,   370,   371,   372,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
     377,   378,   129,   379,   380,   381,   131,  1401,   133,  1402,
    1119,     0,   382,   383,     0,   384,     0,     0,   385,  1403,
    1404,   387,     0,   388,   389,   390,   391,     0,     0,     0,
     392,   393,   394,     0,   395,   396,     0,   397,     0,   398,
     399,   145,   400,     0,     0,     0,     0,   401,   402,   403,
     404,   405,  1405,  1406,   406,     0,   407,     0,   408,     0,
     409,   410,   411,     0,     0,     0,   412,  1132,   414,   415,
       0,   416,   417,     0,   418,     0,   419,   420,   421,     0,
     422,     0,     0,     0,   423,   424,  1407,     0,   425,     0,
     426,   160,     0,   161,   427,     0,   428,     0,     0,   429,
       0,   430,   431,   164,   432,   433,   434,     0,   435,   436,
     437,   438,     0,   165,     0,     0,   439,   440,   441,  1137,
    1408,     0,  1409,     0,     0,   170,   171,   442,   172,   443,
     444,   445,   446,   447,     0,   173,   448,   174,     0,   449,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   461,  1410,   180,  1411,     0,   462,   463,   464,   465,
       0,     0,   466,   467,   184,   468,     0,     0,  1412,   469,
     470,     0,     0,   471,     0,     0,     0,   472,   473,     0,
       0,     0,   188,   189,     0,   474,   475,   476,     0,     0,
       0,   477,   478,     0,   479,   480,   481,   482,   483,   484,
    1413,   485,     0,   486,   487,   488,   489,   490,   491,   492,
     493,   494,   495,   496,   199,   497,     0,   498,   499,   500,
     501,   502,   503,     0,     0,   504,   505,   506,     0,   507,
    1414,   508,   509,   207,   510,  1415,     0,   511,   512,   513,
     514,   515,   516,   517,   518,     0,   519,     0,   520,   521,
     522,   523,     0,  1416,  1417,     0,   525,     0,   526,     0,
     527,     0,     0,   528,   529,   530,   531,   532,     0,     0,
     533,   534,   535,   536,   537,     0,     0,   538,   539,   540,
    1418,   541,   222,   542,     0,     0,     0,   543,   544,   545,
     546,   547,   548,     0,   223,     0,     0,   224,    79,    80,
      81,   354,     0,    83,    84,     0,    85,    86,    87,   355,
       0,   356,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   357,     0,     0,   103,   104,
     105,   106,     0,     0,  1307,   108,   109,   110,     0,   111,
       0,     0,   114,   358,   359,     0,     0,     0,   360,   361,
       0,     0,     0,     0,   362,     0,     0,     0,     0,     0,
       0,     0,     0,   363,     0,   364,     0,   365,   366,     0,
     367,   368,   369,   370,   371,   372,   373,     0,   374,   375,
       0,     0,     0,     0,     0,     0,     0,   376,   377,   378,
       0,   379,   380,   381,     0,   132,     0,   134,     0,     0,
     382,   383,     0,   384,     0,     0,   385,   386,   135,   387,
       0,   388,   389,   390,   391,   139,     0,     0,   392,   393,
     394,     0,   395,   396,   142,   397,     0,   398,   399,     0,
     400,     0,     0,     0,     0,   401,   402,   403,   404,   405,
     148,   149,   406,     0,   407,     0,   408,     0,   409,   410,
     411,     0,     0,     0,   412,   413,   414,   415,     0,   416,
     417,     0,   418,     0,   419,   420,   421,   155,   422,     0,
     157,     0,   423,   424,   159,     0,   425,     0,   426,     0,
       0,     0,   427,     0,  2068,     0,     0,   429,     0,   430,
     431,     0,   432,   433,   434,     0,   435,   436,   437,   438,
       0,     0,   166,     0,   439,   440,   441,     0,   168,     0,
     169,     0,     0,     0,     0,   442,     0,   443,   444,   445,
     446,   447,     0,     0,   448,     0,     0,   449,   450,  2069,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     179,     0,   181,   707,   462,   463,   464,   465,   182,     0,
     466,   467,     0,   468,     0,   185,   186,   469,   470,     0,
       0,   471,   708,     0,     0,   472,   473,     0,     0,   187,
       0,     0,   190,   474,   475,   476,     0,   191,   192,   477,
     478,     0,   479,   480,   481,   482,   483,   484,   194,   485,
       0,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,     0,   497,   201,   498,   499,   500,   501,   502,
     503,     0,     0,   504,   505,   506,     0,   507,   205,   508,
     509,     0,   510,   208,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   210,   519,  2070,   520,  2071,   522,  2072,
       0,   211,   212,     0,   525,     0,   526,   213,   527,   214,
       0,   528,   529,   530,   531,   532,     0,     0,   533,   534,
     535,   536,   537,     0,     0,   538,   539,   540,   221,   541,
       0,   542,     0,     0,     0,   543,   544,   545,   546,   547,
     548,     0,   223,     0,     0,   224,   549,    79,    80,    81,
     354,     0,    83,    84,   570,    85,    86,    87,   355,     0,
     356,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   357,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   358,   359,     0,     0,     0,   360,   361,     0,
       0,     0,     0,   362,     0,     0,     0,     0,     0,     0,
       0,     0,   363,     0,   364,     0,   365,   366,     0,   367,
     368,   369,   370,   371,   372,   373,   571,   374,   375,     0,
       0,     0,     0,     0,     0,     0,   376,   377,   378,     0,
     379,   380,   381,     0,   132,     0,   134,     0,     0,   382,
     383,     0,   384,     0,     0,   385,   386,   135,   387,     0,
     388,   389,   390,   391,   139,     0,     0,   392,   393,   394,
       0,   395,   396,   142,   397,     0,   398,   399,     0,   400,
       0,     0,     0,     0,   401,   402,   403,   404,   405,   148,
     149,   406,   572,   407,     0,   408,     0,   409,   410,   411,
       0,     0,     0,   412,   413,   414,   415,     0,   416,   417,
       0,   418,     0,   419,   420,   421,   155,   422,     0,   157,
       0,   423,   424,   159,     0,   425,     0,   426,     0,     0,
       0,   427,     0,   428,     0,     0,   429,     0,   430,   431,
       0,   432,   433,   434,     0,   435,   436,   437,   438,     0,
       0,   166,     0,   439,   440,   441,     0,   168,     0,   169,
       0,     0,     0,     0,   442,     0,   443,   444,   445,   446,
     447,     0,     0,   448,     0,     0,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   179,
       0,   181,     0,   462,   463,   464,   465,   182,     0,   466,
     467,     0,   468,     0,   185,   186,   469,   470,     0,     0,
     471,     0,     0,     0,   472,   473,     0,     0,   187,     0,
       0,   190,   474,   475,   476,     0,   191,   192,   477,   478,
       0,   479,   480,   481,   482,   483,   484,   194,   485,     0,
     486,   487,   488,   489,   490,   491,   492,   493,   494,   495,
     496,     0,   497,   201,   498,   499,   500,   501,   502,   503,
       0,     0,   504,   505,   506,     0,   507,   205,   508,   509,
       0,   510,   208,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   210,   519,     0,   520,   521,   522,   523,     0,
     211,   212,     0,   525,     0,   526,   213,   527,   214,     0,
     528,   529,   530,   531,   532,     0,     0,   533,   534,   535,
     536,   537,     0,     0,   538,   539,   540,   221,   541,     0,
     542,     0,     0,     0,   543,   544,   545,   546,   547,   548,
       0,   223,     0,     0,   224,   549,    79,    80,    81,   354,
       0,    83,    84,     0,    85,    86,    87,   355,     0,   356,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   357,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   358,   359,     0,     0,     0,   360,   361,     0,     0,
       0,     0,   362,     0,     0,     0,     0,     0,     0,     0,
       0,   363,     0,   364,     0,   365,   366,     0,   367,   368,
     369,   370,   371,   372,   373,     0,   374,   375,     0,     0,
       0,     0,     0,     0,     0,   376,   377,   378,     0,   379,
     380,   381,     0,   132,     0,   134,     0,     0,   382,   383,
       0,   384,     0,     0,   385,   386,   135,   387,     0,   388,
     389,   390,   391,   139,     0,     0,   392,   393,   394,     0,
     395,   396,   142,   397,     0,   398,   399,     0,   400,     0,
       0,     0,     0,   401,   402,   403,   404,   405,   148,   149,
     406,     0,   407,     0,   408,     0,   409,   410,   411,     0,
       0,     0,   412,   413,   414,   415,     0,   416,   417,     0,
     418,     0,   419,   420,   421,   155,   422,     0,   157,     0,
     423,   424,   159,     0,   425,     0,   426,     0,     0,     0,
     427,     0,   428,     0,     0,   429,     0,   430,   431,     0,
     432,   433,   434,     0,   435,   436,   437,   438,     0,     0,
     166,     0,   439,   440,   441,     0,   168,     0,   169,     0,
       0,     0,     0,   442,     0,   443,   444,   445,   446,   447,
       0,     0,   448,     0,     0,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   179,     0,
     181,     0,   462,   463,   464,   465,   182,     0,   466,   467,
       0,   468,     0,   185,   186,   469,   470,     0,     0,   471,
       0,     0,     0,   472,   473,     0,     0,   187,     0,     0,
     190,   474,   475,   476,     0,   191,   192,   477,   478,     0,
     479,   480,   481,   482,   483,   484,   194,   485,     0,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
       0,   497,   201,   498,   499,   500,   501,   502,   503,     0,
       0,   504,   505,   506,     0,   507,   205,   508,   509,     0,
     510,   208,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   210,   519,     0,   520,   521,   522,   523,     0,   211,
     212,   524,   525,     0,   526,   213,   527,   214,     0,   528,
     529,   530,   531,   532,     0,     0,   533,   534,   535,   536,
     537,     0,     0,   538,   539,   540,   221,   541,     0,   542,
       0,     0,     0,   543,   544,   545,   546,   547,   548,     0,
     223,    49,     0,   224,   549,    79,    80,    81,   354,     0,
      83,    84,     0,    85,    86,    87,   355,     0,   356,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   357,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     358,   359,     0,     0,     0,   360,   361,     0,     0,     0,
       0,   362,     0,     0,     0,     0,     0,     0,     0,     0,
     363,     0,   364,     0,   365,   366,     0,   367,   368,   369,
     370,   371,   372,   373,     0,   374,   375,     0,     0,     0,
       0,     0,     0,     0,   376,   377,   378,     0,   379,   380,
     381,     0,   132,     0,   134,     0,     0,   382,   383,     0,
     384,     0,     0,   385,   386,   135,   387,     0,   388,   389,
     390,   391,   139,     0,     0,   392,   393,   394,     0,   395,
     396,   142,   397,     0,   398,   399,     0,   400,     0,     0,
       0,     0,   401,   402,   403,   404,   405,   148,   149,   406,
    1650,   407,     0,   408,     0,   409,   410,   411,     0,     0,
       0,   412,   413,   414,   415,     0,   416,   417,     0,   418,
       0,   419,   420,   421,   155,   422,     0,   157,     0,   423,
     424,   159,     0,   425,     0,   426,     0,     0,     0,   427,
       0,   428,     0,     0,   429,     0,   430,   431,     0,   432,
     433,   434,     0,   435,   436,   437,   438,     0,     0,   166,
       0,   439,   440,   441,     0,   168,     0,   169,     0,     0,
       0,     0,   442,     0,   443,   444,   445,   446,   447,     0,
       0,   448,     0,     0,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   179,     0,   181,
       0,   462,   463,   464,   465,   182,     0,   466,   467,     0,
     468,     0,   185,   186,   469,   470,     0,     0,   471,     0,
       0,     0,   472,   473,     0,     0,   187,     0,     0,   190,
     474,   475,   476,     0,   191,   192,   477,   478,     0,   479,
     480,   481,   482,   483,   484,   194,   485,     0,   486,   487,
     488,   489,   490,   491,   492,   493,   494,   495,   496,     0,
     497,   201,   498,   499,   500,   501,   502,   503,     0,     0,
     504,   505,   506,     0,   507,   205,   508,   509,     0,   510,
     208,     0,   511,   512,   513,   514,   515,   516,   517,   518,
     210,   519,     0,   520,   521,   522,   523,     0,   211,   212,
       0,   525,     0,   526,   213,   527,   214,     0,   528,   529,
     530,   531,   532,     0,     0,   533,   534,   535,   536,   537,
       0,     0,   538,   539,   540,   221,   541,     0,   542,     0,
       0,     0,   543,   544,   545,   546,   547,   548,     0,   223,
      49,     0,   224,   549,    79,    80,    81,   354,     0,    83,
      84,     0,    85,    86,    87,   355,   745,   356,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   357,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   358,
     359,     0,     0,     0,   360,   361,     0,     0,     0,     0,
     362,     0,     0,     0,     0,     0,     0,     0,     0,   363,
       0,   364,     0,   365,   366,     0,   367,   368,   369,   370,
     371,   372,   373,     0,   374,   375,     0,     0,     0,     0,
       0,     0,     0,   376,   377,   378,     0,   379,   380,   381,
       0,   132,     0,   134,     0,     0,   382,   383,     0,   384,
       0,     0,   385,   386,   135,   387,     0,   388,   389,   390,
     391,   139,     0,     0,   392,   393,   394,     0,   395,   396,
     142,   397,     0,   398,   399,     0,   400,     0,     0,     0,
       0,   401,   402,   403,   404,   405,   148,   149,   406,     0,
     407,     0,   408,     0,   409,   410,   411,     0,     0,     0,
     412,   413,   414,   415,     0,   416,   417,     0,   418,     0,
     419,   420,   421,   155,   422,     0,   157,     0,   423,   424,
     159,     0,   425,     0,   426,     0,     0,     0,   427,     0,
     428,     0,     0,   429,     0,   430,   431,     0,   432,   433,
     434,     0,   435,   436,   437,   438,     0,     0,   166,     0,
     439,   440,   441,     0,   168,     0,   169,     0,     0,     0,
       0,   442,     0,   443,   444,   445,   446,   447,     0,     0,
     448,     0,     0,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   179,     0,   181,     0,
     462,   463,   464,   465,   182,     0,   466,   467,     0,   468,
       0,   185,   186,   469,   470,     0,     0,   471,     0,     0,
       0,   472,   473,     0,     0,   187,     0,     0,   190,   474,
     475,   476,     0,   191,   192,   477,   746,     0,   479,   480,
     481,   482,   483,   484,   194,   485,     0,   486,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,     0,   497,
     201,   498,   499,   500,   501,   502,   503,     0,     0,   504,
     505,   506,     0,   507,   205,   508,   509,     0,   510,   208,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   210,
     519,     0,   520,   521,   522,   523,     0,   211,   212,     0,
     525,     0,   526,   213,   527,   214,     0,   528,   529,   530,
     531,   532,     0,     0,   533,   534,   535,   536,   537,     0,
       0,   538,   539,   540,   221,   541,     0,   542,     0,     0,
       0,   543,   544,   545,   546,   547,   548,     0,   223,     0,
       0,   224,   549,    79,    80,    81,   354,     0,    83,    84,
       0,    85,    86,    87,   355,     0,   356,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     357,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   358,   359,
       0,     0,     0,   360,   361,     0,     0,     0,     0,   362,
       0,     0,     0,     0,     0,     0,     0,     0,   363,     0,
     364,     0,   365,   366,     0,   367,   368,   369,   370,   371,
     372,   373,     0,   374,   375,     0,     0,     0,     0,     0,
       0,     0,   376,   377,   378,     0,   379,   380,   381,     0,
     132,     0,   134,     0,     0,   382,   383,     0,   384,     0,
       0,   385,   386,   135,   387,     0,   388,   389,   390,   391,
     139,     0,     0,   392,   393,   394,     0,   395,   396,   142,
     397,     0,   398,   399,     0,   400,     0,     0,     0,     0,
     401,   402,   403,   404,   405,   148,   149,   406,   920,   407,
       0,   408,     0,   409,   410,   411,     0,     0,     0,   412,
     413,   414,   415,     0,   416,   417,     0,   418,     0,   419,
     420,   421,   155,   422,     0,   157,     0,   423,   424,   159,
       0,   425,     0,   426,     0,     0,     0,   427,     0,   428,
       0,     0,   429,     0,   430,   431,     0,   432,   433,   434,
       0,   435,   436,   437,   438,     0,     0,   166,     0,   439,
     440,   441,     0,   168,     0,   169,     0,     0,     0,     0,
     442,     0,   443,   444,   445,   446,   447,     0,     0,   448,
       0,     0,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   179,     0,   181,     0,   462,
     463,   464,   465,   182,     0,   466,   467,     0,   468,     0,
     185,   186,   469,   470,     0,     0,   471,     0,     0,     0,
     472,   473,     0,     0,   187,     0,     0,   190,   474,   475,
     476,     0,   191,   192,   477,   478,     0,   479,   480,   481,
     482,   483,   484,   194,   485,     0,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,   496,     0,   497,   201,
     498,   499,   500,   501,   502,   503,     0,     0,   504,   505,
     506,     0,   507,   205,   508,   509,     0,   510,   208,     0,
     511,   512,   513,   514,   515,   516,   517,   518,   210,   519,
       0,   520,   521,   522,   523,     0,   211,   212,     0,   525,
       0,   526,   213,   527,   214,     0,   528,   529,   530,   531,
     532,     0,     0,   533,   534,   535,   536,   537,     0,     0,
     538,   539,   540,   221,   541,     0,   542,     0,     0,     0,
     543,   544,   545,   546,   547,   548,     0,   223,     0,     0,
     224,   549,    79,    80,    81,   354,     0,    83,    84,     0,
      85,    86,    87,   355,     0,   356,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   357,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   358,   359,     0,
       0,     0,   360,   361,     0,     0,     0,     0,   362,     0,
       0,     0,     0,     0,     0,     0,     0,   363,     0,   364,
       0,   365,   366,     0,   367,   368,   369,   370,   371,   372,
     373,     0,   374,   375,     0,     0,     0,     0,     0,     0,
       0,   376,   377,   378,     0,   379,   380,   381,     0,   132,
       0,   134,     0,     0,   382,   383,     0,   384,     0,     0,
     385,   386,   135,   387,     0,   388,   389,   390,   391,   139,
       0,     0,   392,   393,   394,     0,   395,   396,   142,   397,
       0,   398,   399,     0,   400,     0,     0,     0,     0,   401,
     402,   403,   404,   405,   148,   149,   406,     0,   407,     0,
     408,     0,   409,   410,   411,     0,     0,     0,   412,   413,
     414,   415,     0,   416,   417,     0,   418,     0,   419,   420,
     421,   155,   422,     0,   157,     0,   423,   424,   159,     0,
     425,     0,   426,     0,     0,     0,   427,     0,   428,     0,
       0,   429,     0,   430,   431,     0,   432,   433,   434,     0,
     435,   436,   437,   438,     0,     0,   166,     0,   439,   440,
     441,     0,   168,     0,   169,     0,     0,     0,     0,   442,
       0,   443,   444,   445,   446,   447,     0,     0,   448,     0,
       0,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   461,   179,     0,   181,     0,   462,   463,
     464,   465,   182,     0,   466,   467,     0,   468,     0,   185,
     186,   469,   470,     0,     0,   471,     0,     0,     0,   472,
     473,     0,     0,   187,     0,     0,   190,   474,   475,   476,
       0,   191,   192,   477,   478,     0,   479,   480,   481,   482,
     483,   484,   194,   485,     0,   486,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,     0,   497,   201,   498,
     499,   500,   501,   502,   503,     0,     0,   504,   505,   506,
       0,   507,   205,   508,   509,     0,   510,   208,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   210,   519,     0,
     520,   521,   522,   523,     0,   211,   212,     0,   525,     0,
     526,   213,   527,   214,     0,   528,   529,   530,   531,   532,
       0,     0,   533,   534,   535,   536,   537,     0,     0,   538,
     539,   540,   221,   541,     0,   542,     0,     0,     0,   543,
     544,   545,   546,   547,   548,     0,   223,    49,     0,   224,
     549,    79,    80,    81,   354,     0,    83,    84,     0,    85,
      86,    87,   355,     0,   356,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   357,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   358,   359,     0,     0,
       0,   360,   361,     0,     0,     0,     0,   362,     0,     0,
       0,     0,     0,     0,     0,     0,   363,     0,   364,     0,
     365,   366,     0,   367,   368,   369,   370,   371,   372,   373,
       0,   374,   375,     0,     0,     0,     0,     0,     0,     0,
     376,   377,   378,     0,   379,   380,   381,     0,   132,     0,
     134,     0,     0,   382,   383,     0,   384,     0,     0,   385,
     386,   135,   387,     0,   388,   389,   390,   391,   139,     0,
       0,   392,   393,   394,     0,   395,   396,   142,   397,     0,
     398,   399,     0,   400,     0,     0,     0,     0,   401,   402,
     403,   404,   405,   148,   149,   406,   572,   407,     0,   408,
       0,   409,   410,   411,     0,     0,     0,   412,   413,   414,
     415,     0,   416,   417,     0,   418,     0,   419,   420,   421,
     155,   422,     0,   157,     0,   423,   424,   159,     0,   425,
       0,   426,     0,     0,     0,   427,     0,   428,     0,     0,
     429,     0,   430,   431,     0,   432,   433,   434,     0,   435,
     436,   437,   438,     0,     0,   166,     0,   439,   440,   441,
       0,   168,     0,   169,     0,     0,     0,     0,   442,     0,
     443,   444,   445,   446,   447,     0,     0,   448,     0,     0,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   179,     0,   181,     0,   462,   463,   464,
     465,   182,     0,   466,   467,     0,   468,     0,   185,   186,
     469,   470,     0,     0,   471,     0,     0,     0,   472,   473,
       0,     0,   187,     0,     0,   190,   474,   475,   476,     0,
     191,   192,   477,   478,     0,   479,   480,   481,   482,   483,
     484,   194,   485,     0,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   496,     0,   497,   201,   498,   499,
     500,   501,   502,   503,     0,     0,   504,   505,   506,     0,
     507,   205,   508,   509,     0,   510,   208,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   210,   519,     0,   520,
     521,   522,   523,     0,   211,   212,     0,   525,     0,   526,
     213,   527,   214,     0,   528,   529,   530,   531,   532,     0,
       0,   533,   534,   535,   536,   537,     0,     0,   538,   539,
     540,   221,   541,     0,   542,     0,     0,     0,   543,   544,
     545,   546,   547,   548,     0,   223,     0,     0,   224,   549,
      79,    80,    81,   354,     0,    83,    84,     0,    85,    86,
      87,   355,     0,   356,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   357,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   358,   359,     0,     0,     0,
     360,   361,     0,     0,     0,     0,   362,     0,     0,     0,
       0,     0,     0,     0,     0,   363,     0,   364,     0,   365,
     366,     0,   367,   368,   369,   370,   371,   372,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
     377,   378,     0,   379,   380,   381,     0,   132,     0,   134,
       0,     0,   382,   383,     0,   384,     0,     0,   385,   386,
     135,   387,     0,   388,   389,   390,   391,   139,     0,     0,
     392,   393,   394,     0,   395,   396,   142,   397,     0,   398,
     399,     0,   400,     0,     0,     0,     0,   401,   402,   403,
     404,   405,   148,   149,   406,     0,   407,     0,   408,     0,
     409,   410,   411,     0,     0,     0,   412,   413,   414,   415,
       0,   416,   417,     0,   418,     0,   419,   420,   421,   155,
     422,     0,   157,     0,   423,   424,   159,     0,   425,     0,
     426,     0,     0,     0,   427,     0,   428,     0,     0,   429,
       0,   430,   431,     0,   432,   433,   434,     0,   435,   436,
     437,   438,     0,     0,   166,     0,   439,   440,   441,     0,
     168,     0,   169,     0,     0,     0,     0,   442,     0,   443,
     444,   445,   446,   447,     0,     0,   448,     0,     0,   449,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   461,   179,     0,   181,     0,   462,   463,   464,   465,
     182,     0,   466,   467,     0,   468,     0,   185,   186,   469,
     470,     0,     0,   471,     0,     0,     0,   472,   473,     0,
       0,   187,     0,     0,   190,   474,   475,   476,     0,   191,
     192,   477,   478,     0,   479,   480,   481,   482,   483,   484,
     194,   485,     0,   486,   487,   488,   489,   490,   491,   492,
     493,   494,   495,   496,     0,   497,   201,   498,   499,   500,
     501,   502,   503,     0,     0,   504,   505,   506,     0,   507,
     205,   508,   509,     0,   510,   208,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   210,   519,     0,   520,   521,
     522,   523,     0,   211,   212,     0,   525,     0,   526,   213,
     527,   214,     0,   528,   529,   530,   531,   532,     0,     0,
     533,   534,   535,   536,   537,     0,     0,   538,   539,   540,
     221,   541,     0,   542,     0,     0,     0,   543,   544,   545,
     546,   547,   548,     0,   223,     0,     0,   224,   549,    79,
      80,    81,   354,     0,    83,    84,     0,    85,    86,    87,
     355,     0,   356,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   357,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   358,   359,     0,     0,     0,   360,
     361,     0,     0,     0,     0,   362,     0,     0,     0,     0,
       0,     0,     0,     0,   363,     0,   364,     0,   365,   366,
       0,   367,   368,   369,   370,   371,   372,   373,     0,   374,
     375,     0,     0,     0,     0,     0,     0,     0,   376,   377,
     378,     0,   379,   380,   381,     0,   132,     0,   134,     0,
       0,   382,   383,     0,   384,     0,     0,   385,   386,   135,
     387,     0,   388,   389,   390,   391,   139,     0,     0,   392,
     393,   394,     0,   395,   396,   142,   397,     0,   398,   399,
       0,   400,     0,     0,     0,     0,   401,   402,   403,   404,
     405,   148,   149,   406,     0,   407,     0,   408,     0,   409,
     410,   411,     0,     0,     0,   412,   413,   414,   415,     0,
     416,   417,     0,   418,     0,   419,   420,   421,   155,   422,
       0,   157,     0,   423,   424,   159,     0,   425,     0,   426,
       0,     0,     0,   427,     0,   428,     0,     0,   429,     0,
     430,   431,     0,   776,   433,   434,     0,   435,   436,   437,
     438,     0,     0,   166,     0,   439,   440,   441,     0,   168,
       0,   169,     0,     0,     0,     0,   442,     0,   443,   444,
     445,   446,   447,     0,     0,   448,     0,     0,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   179,     0,   181,     0,   462,   463,   464,   465,   182,
       0,   466,   467,     0,   468,     0,   185,   186,   469,   470,
       0,     0,   471,     0,     0,     0,   472,   473,     0,     0,
     187,     0,     0,   190,   474,   475,   476,     0,   191,   192,
     477,   478,     0,   479,   480,   481,   482,   483,   484,   194,
     485,     0,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,     0,   497,   201,   498,   499,   500,   501,
     502,   503,     0,     0,   504,   505,   506,     0,   507,   205,
     508,   509,     0,   510,   208,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   210,   519,     0,   520,   521,   522,
     523,     0,   211,   212,     0,   525,     0,   526,   213,   527,
     214,     0,   528,   529,   530,   531,   532,     0,     0,   533,
     534,   535,   536,   537,     0,     0,   538,   539,   540,   221,
     541,     0,   542,     0,     0,     0,   543,   544,   545,   546,
     547,   548,     0,   223,     0,     0,   224,   549,   582,    79,
      80,    81,   354,     0,    83,    84,     0,    85,    86,    87,
     355,     0,   356,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   583,    99,   100,   101,   357,   584,     0,   103,
     104,   105,   106,   585,   586,     0,   108,   109,   110,     0,
     111,   587,   588,   114,   358,   359,     0,     0,     0,   360,
     361,     0,     0,     0,     0,   362,     0,     0,     0,     0,
       0,     0,     0,     0,   363,     0,   364,     0,   365,   366,
       0,   367,   368,   369,   370,   371,   372,   373,     0,   374,
     375,     0,     0,     0,     0,     0,     0,     0,   376,   377,
     378,     0,   379,   380,   381,     0,  1401,     0,  1402,  1119,
       0,   382,   383,     0,   384,     0,     0,   385,  1403,  1404,
     387,     0,   388,   389,   390,   391,     0,     0,     0,   392,
     393,   394,     0,   395,   396,     0,   397,     0,   398,   399,
       0,   400,     0,     0,     0,     0,   401,   402,   403,   404,
     405,  1405,  1406,   406,     0,   407,     0,   408,     0,   409,
     410,   411,     0,     0,     0,   412,  1132,   414,   415,     0,
     416,   417,     0,   418,     0,   419,   420,   421,     0,   422,
       0,     0,     0,   423,   424,  1407,     0,   425,     0,   426,
       0,     0,     0,   427,     0,   428,     0,     0,   429,     0,
     430,   431,     0,   432,   433,   434,     0,   435,   436,   437,
     438,     0,     0,     0,     0,   439,   440,   441,  1137,  1408,
       0,  1409,     0,     0,     0,     0,   442,     0,   443,   444,
     445,   446,   447,     0,     0,   448,     0,     0,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,  1410,     0,  1411,     0,   462,   463,   464,   465,  1788,
       0,   466,   467,     0,   468,     0,     0,  1412,   469,   470,
       0,     0,   471,     0,     0,     0,   472,   473,     0,     0,
       0,     0,     0,     0,   474,   475,   476,     0,     0,     0,
     477,   478,     0,   479,   480,   481,   482,   483,   484,  1413,
     485,     0,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,     0,   497,     0,   498,   499,   500,   501,
     502,   503,     0,     0,   504,   505,   506,     0,   507,  1414,
     508,   509,     0,   510,  1415,     0,   511,   512,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   520,   521,   522,
     523,     0,  1416,  1417,     0,   525,     0,   526,     0,   527,
       0,     0,   528,   529,   530,   531,   532,     0,     0,   533,
     534,   535,   536,   537,     0,     0,   538,   539,   540,  1418,
     541,     0,   542,     0,     0,     0,   543,   544,   545,   546,
     547,   548,     0,   223,     0,     0,   224,   582,    79,    80,
      81,   354,     0,    83,    84,     0,    85,    86,    87,   355,
       0,   356,     0,    91,     0,    93,    94,    95,    96,    97,
      98,   583,    99,   100,   101,   357,   584,     0,   103,   104,
     105,   106,   585,   586,     0,   108,   109,   110,     0,   111,
     587,   588,   114,   358,   359,     0,     0,     0,   360,   361,
       0,     0,     0,     0,   362,     0,     0,     0,     0,     0,
       0,     0,     0,   363,     0,   364,     0,   365,   366,     0,
     367,   368,   369,   370,   371,   372,   373,     0,   374,   375,
       0,     0,     0,     0,     0,     0,     0,   376,   377,   378,
       0,   379,   380,   381,     0,  1401,     0,  1402,  1119,     0,
     382,   383,     0,   384,     0,     0,   385,  1403,  1404,   387,
       0,   388,   389,   390,   391,     0,     0,     0,   392,   393,
     394,     0,   395,   396,     0,   397,     0,   398,   399,     0,
     400,     0,     0,     0,     0,   401,   402,   403,   404,   405,
    1405,  1406,   406,     0,   407,     0,   408,     0,   409,   410,
     411,     0,     0,     0,   412,  1132,   414,   415,     0,   416,
     417,     0,   418,     0,   419,   420,   421,     0,   422,     0,
       0,     0,   423,   424,  1407,     0,   425,     0,   426,     0,
       0,     0,   427,     0,   428,     0,     0,   429,     0,   430,
     431,     0,   432,   433,   434,     0,   435,   436,   437,   438,
       0,     0,     0,     0,   439,   440,   441,  1137,  1408,     0,
    1409,     0,     0,     0,     0,   442,     0,   443,   444,   445,
     446,   447,     0,     0,   448,     0,     0,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
    1410,     0,  1411,     0,   462,   463,   464,   465,  2506,     0,
     466,   467,     0,   468,     0,     0,  1412,   469,   470,     0,
       0,   471,     0,     0,     0,   472,   473,     0,     0,     0,
       0,     0,     0,   474,   475,   476,     0,     0,     0,   477,
     478,     0,   479,   480,   481,   482,   483,   484,  1413,   485,
       0,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,     0,   497,     0,   498,   499,   500,   501,   502,
     503,     0,     0,   504,   505,   506,     0,   507,  1414,   508,
     509,     0,   510,  1415,     0,   511,   512,   513,   514,   515,
     516,   517,   518,     0,   519,     0,   520,   521,   522,   523,
       0,  1416,  1417,     0,   525,     0,   526,     0,   527,     0,
       0,   528,   529,   530,   531,   532,     0,     0,   533,   534,
     535,   536,   537,     0,     0,   538,   539,   540,  1418,   541,
       0,   542,     0,     0,     0,   543,   544,   545,   546,   547,
     548,     0,   223,     0,     0,   224,   582,    79,    80,    81,
     354,     0,    83,    84,     0,    85,    86,    87,   355,     0,
     356,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     583,    99,   100,   101,   357,   584,     0,   103,   104,   105,
     106,   585,   586,     0,   108,   109,   110,     0,   111,   587,
     588,   114,   358,   359,     0,     0,     0,   360,   361,     0,
       0,     0,     0,   362,     0,     0,     0,     0,     0,     0,
       0,     0,   363,     0,   364,     0,   365,   366,     0,   367,
     368,   369,   370,   371,   372,   373,     0,   374,   375,     0,
       0,     0,     0,     0,     0,     0,   376,   377,   378,     0,
     379,   380,   381,     0,  1401,     0,  1402,  1119,     0,   382,
     383,     0,   384,     0,     0,   385,  1403,  1404,   387,     0,
     388,   389,   390,   391,     0,     0,     0,   392,   393,   394,
       0,   395,   396,     0,   397,     0,   398,   399,     0,   400,
       0,     0,     0,     0,   401,   402,   403,   404,   405,  1405,
    1406,   406,     0,   407,     0,   408,     0,   409,   410,   411,
       0,     0,     0,   412,  1132,   414,   415,     0,   416,   417,
       0,   418,     0,   419,   420,   421,     0,   422,     0,     0,
       0,   423,   424,  1407,     0,   425,     0,   426,     0,     0,
       0,   427,     0,   428,     0,     0,   429,     0,   430,   431,
       0,   432,   433,   434,     0,   435,   436,   437,   438,     0,
       0,     0,     0,   439,   440,   441,  1137,  1408,     0,  1409,
       0,     0,     0,     0,   442,     0,   443,   444,   445,   446,
     447,     0,     0,   448,     0,     0,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   458,   459,   460,   461,  1410,
       0,  1411,     0,   462,   463,   464,   465,     0,     0,   466,
     467,     0,   468,     0,     0,  1412,   469,   470,     0,     0,
     471,     0,     0,     0,   472,   473,     0,     0,     0,     0,
       0,     0,   474,   475,   476,     0,     0,     0,   477,   478,
       0,   479,   480,   481,   482,   483,   484,  1413,   485,     0,
     486,   487,   488,   489,   490,   491,   492,   493,   494,   495,
     496,     0,   497,     0,   498,   499,   500,   501,   502,   503,
       0,     0,   504,   505,   506,     0,   507,  1414,   508,   509,
       0,   510,  1415,     0,   511,   512,   513,   514,   515,   516,
     517,   518,     0,   519,     0,   520,   521,   522,   523,     0,
    1416,  1417,     0,   525,     0,   526,     0,   527,     0,     0,
     528,   529,   530,   531,   532,     0,     0,   533,   534,   535,
     536,   537,     0,     0,   538,   539,   540,  1418,   541,     0,
     542,     0,     0,     0,   543,   544,   545,   546,   547,   548,
       0,   223,     0,     0,   224,   582,    79,    80,    81,   354,
       0,    83,    84,     0,    85,    86,    87,   355,     0,   356,
       0,    91,     0,    93,    94,    95,    96,    97,    98,   583,
      99,   100,   101,   357,   584,     0,   103,   104,   105,   106,
     585,   586,     0,   108,   109,   110,     0,   111,   587,   588,
     114,   358,   359,     0,     0,     0,   360,   361,     0,     0,
       0,     0,   362,     0,     0,     0,     0,     0,     0,     0,
       0,   363,     0,   364,     0,   365,   366,     0,   367,   368,
     369,   370,   371,   372,   373,     0,   374,   375,     0,     0,
       0,     0,     0,     0,     0,   376,   377,   378,     0,   379,
     380,   381,     0,  1401,     0,  1402,  1119,     0,   382,   383,
       0,   384,     0,     0,   385,  1403,  1404,   387,     0,   388,
     389,   390,   391,     0,     0,     0,   392,   393,   394,     0,
     395,   396,     0,   397,     0,   398,   399,     0,   400,     0,
       0,     0,     0,   401,   402,   403,   404,   405,  1405,  1406,
     406,     0,   407,     0,   408,     0,   409,   410,   411,     0,
       0,     0,   412,  1132,   414,   415,     0,   416,   417,     0,
     418,     0,   419,   420,   421,     0,   422,     0,     0,     0,
     423,   424,  1407,     0,   425,     0,   426,     0,     0,     0,
     427,     0,   428,     0,     0,   429,     0,   430,   431,     0,
     432,   433,   434,     0,   435,   436,   437,   438,     0,     0,
       0,     0,   439,   440,   441,  1137,  1408,     0,  1409,     0,
       0,     0,     0,   442,     0,   443,   444,   445,   446,   447,
       0,     0,   448,     0,     0,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,  1410,     0,
    1411,     0,   462,   463,   464,   465,     0,     0,   466,   467,
       0,   468,     0,     0,  1412,   469,   470,     0,     0,   471,
       0,     0,     0,   472,   473,     0,     0,     0,     0,     0,
       0,   474,   475,   476,     0,     0,     0,   477,   478,     0,
     479,   480,   481,   482,   483,   484,  1413,   485,     0,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
       0,   497,     0,   498,   499,   500,   501,   502,   503,     0,
       0,   504,   505,   506,     0,   507,     0,   508,   509,     0,
     510,  1415,     0,   511,   512,   513,   514,   515,   516,   517,
     518,     0,   519,     0,   520,   521,   522,   523,     0,  1416,
    1417,     0,   525,     0,   526,     0,   527,     0,     0,   528,
     529,   530,   531,   532,     0,     0,   533,   534,   535,   536,
     537,     0,     0,   538,   539,   540,  1418,   541,     0,   542,
       0,     0,     0,   543,   544,   545,   546,   547,   548,     0,
     223,     0,     0,   224,    79,    80,    81,   354,     0,    83,
      84,     0,    85,    86,    87,   355,     0,   356,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   357,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   358,
     359,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   367,   368,   369,   370,
     371,   372,   373,   589,   374,   375,   590,   591,   592,   593,
     594,   595,   596,   376,   377,   378,   129,   379,   380,   381,
     131,   132,   133,   134,     0,   597,   382,   383,     0,   384,
     598,   599,   385,     0,   135,   387,   601,   388,   389,   390,
     391,   139,   602,   603,   392,   393,   394,   604,   395,   396,
     142,   397,   605,   398,   399,   145,   400,   606,   607,   608,
     609,   401,   402,   403,     0,   405,   148,   149,   406,   610,
     407,   611,   408,     0,   409,   410,   411,   612,   613,   614,
     412,   413,   414,   415,   615,   416,   417,   616,   418,   617,
     419,   420,   421,   155,   422,     0,   157,   618,   423,   424,
     159,   619,   425,   620,   426,   160,   621,   161,   427,     0,
     428,   622,   623,   429,   624,   430,     0,   164,   432,   433,
     434,   625,   435,   436,   437,   438,   626,   165,   166,     0,
     439,   440,   441,     0,   168,   629,   169,   630,     0,   170,
     171,   442,   172,   443,   444,   445,   446,   447,   631,   173,
     448,   174,   632,   449,   450,   451,   452,   453,   454,   455,
       0,   457,   458,     0,   460,   461,   179,   180,   181,   633,
     462,   463,   464,   465,   182,   634,   466,   467,   184,   468,
     635,   185,   186,   469,   470,   636,   637,   471,   638,   639,
     640,   472,   473,   641,   642,   187,   188,   189,   190,   474,
     475,   476,     0,   191,   192,   477,   478,   643,   479,   480,
     481,   482,   483,   484,   194,   485,   644,   486,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,   199,   497,
     201,   498,   499,   500,   501,   502,     0,     0,   645,   504,
     505,   506,   646,   507,   205,   508,   509,   207,   510,   208,
     647,   511,   512,   513,   514,   515,   516,   517,   518,   210,
     519,   648,   520,   521,   522,   523,   649,   211,   212,     0,
     525,   651,   526,   213,   527,   214,   652,   528,   529,   530,
     531,   532,     0,   654,   533,   534,   535,   536,   537,   655,
     656,   538,   539,   540,   221,   541,   222,   542,     0,   657,
     658,   543,   544,   545,   546,     0,   548,     0,   223,     0,
       0,   224,    79,    80,    81,   354,     0,    83,    84,     0,
      85,    86,    87,   355,     0,   356,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   357,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   358,   359,     0,
       0,     0,   360,   361,     0,     0,     0,     0,   362,     0,
       0,     0,     0,     0,     0,     0,     0,   363,     0,   364,
       0,   365,   366,     0,   367,   368,   369,   370,   371,   372,
     373,     0,   374,   375,     0,     0,     0,     0,     0,     0,
       0,   376,   377,   378,   129,   379,   380,   381,   131,   132,
     133,   134,     0,     0,   382,   383,     0,   384,     0,     0,
     385,   386,   135,   387,     0,   388,   389,   390,   391,   139,
       0,     0,   392,   393,   394,     0,   395,   396,   142,   397,
       0,   398,   399,   145,   400,     0,     0,     0,     0,   401,
     402,   403,   404,   405,   148,   149,   406,     0,   407,     0,
     408,     0,   409,   410,   411,     0,     0,     0,   412,   413,
     414,   415,     0,   416,   417,     0,   418,     0,   419,   420,
     421,   155,   422,     0,   157,     0,   423,   424,   159,     0,
     425,     0,   426,   160,     0,   161,   427,     0,   428,     0,
       0,   429,     0,   430,   431,   164,   432,   433,   434,     0,
     435,   436,   437,   438,     0,   165,   166,     0,   439,   440,
     441,     0,   168,     0,   169,     0,     0,   170,   171,   442,
     172,   443,   444,   445,   446,   447,     0,   173,   448,   174,
       0,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   461,   179,   180,   181,   707,   462,   463,
     464,   465,   182,     0,   466,   467,   184,   468,     0,   185,
     186,   469,   470,     0,     0,   471,   708,     0,     0,   472,
     473,     0,     0,   187,   188,   189,   190,   474,   475,   476,
       0,   191,   192,   477,   478,     0,   479,   480,   481,   482,
     483,   484,   194,   485,     0,   486,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,   199,   497,   201,   498,
     499,   500,   501,   502,   503,     0,     0,   504,   505,   506,
       0,   507,   205,   508,   509,   207,   510,   208,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   210,   519,     0,
     520,   521,   522,   523,     0,   211,   212,     0,   525,     0,
     526,   213,   527,   214,     0,   528,   529,   530,   531,   532,
       0,     0,   533,   534,   535,   536,   537,     0,     0,   538,
     539,   540,   221,   541,   222,   542,     0,     0,     0,   543,
     544,   545,   546,   547,   548,     0,   223,     0,     0,   224,
      79,    80,    81,   354,     0,    83,    84,     0,    85,    86,
      87,   355,     0,   356,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   357,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   358,   359,     0,     0,     0,
     360,   361,     0,     0,     0,     0,   362,     0,     0,     0,
       0,     0,     0,     0,     0,   363,     0,   364,     0,   365,
     366,     0,   367,   368,   369,   370,   371,   372,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
     377,   378,     0,   379,   380,   381,     0,   132,     0,   134,
       0,     0,   382,   383,     0,   384,     0,     0,   385,   386,
     135,   387,  1757,   388,   389,   390,   391,   139,     0,     0,
     392,   393,   394,  1758,   395,   396,   142,   397,     0,   398,
     399,     0,   400,     0,     0,     0,     0,   401,   402,   403,
     404,   405,   148,   149,   406,     0,   407,     0,   408,     0,
     409,   410,   411,     0,     0,     0,   412,   413,   414,   415,
       0,   416,   417,     0,   418,     0,   419,   420,   421,   155,
     422,     0,   157,     0,   423,   424,   159,     0,   425,  1759,
     426,     0,     0,     0,   427,     0,   428,     0,     0,   429,
       0,   430,   431,     0,   432,   433,   434,     0,   435,   436,
     437,   438,     0,     0,   166,     0,   439,   440,   441,     0,
     168,     0,   169,     0,     0,     0,     0,   442,     0,   443,
     444,   445,   446,   447,     0,     0,   448,  2268,     0,   449,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   461,   179,     0,   181,     0,   462,   463,   464,   465,
     182,     0,   466,   467,     0,   468,     0,   185,   186,   469,
     470,     0,     0,   471,     0,     0,     0,   472,   473,     0,
       0,   187,     0,     0,   190,   474,   475,   476,     0,   191,
     192,   477,   478,  1760,   479,   480,   481,   482,   483,   484,
     194,   485,     0,   486,   487,   488,   489,   490,   491,   492,
     493,   494,   495,   496,     0,   497,   201,   498,   499,   500,
     501,   502,   503,     0,     0,   504,   505,   506,     0,   507,
     205,   508,   509,     0,   510,   208,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   210,   519,     0,   520,   521,
     522,   523,     0,   211,   212,     0,   525,     0,   526,   213,
     527,   214,     0,   528,   529,   530,   531,   532,     0,  1761,
     533,   534,   535,   536,   537,     0,     0,   538,   539,   540,
     221,   541,     0,   542,     0,     0,     0,   543,   544,   545,
     546,   547,   548,     0,   223,     0,     0,   224,    79,    80,
      81,   354,     0,    83,    84,     0,    85,    86,    87,   355,
       0,   356,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   357,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   358,   359,     0,     0,     0,   360,   361,
       0,     0,     0,     0,   362,     0,     0,     0,     0,     0,
       0,     0,     0,   363,     0,   364,     0,   365,   366,     0,
     367,   368,   369,   370,   371,   372,   373,     0,   374,   375,
     126,   127,     0,     0,     0,     0,     0,   376,   377,   378,
       0,   379,   380,   381,     0,   132,     0,   134,     0,     0,
     382,   383,     0,   384,     0,     0,   385,   386,   135,   387,
       0,   388,   389,   390,   391,   139,     0,     0,   392,   393,
     394,     0,   395,   396,   142,   397,     0,   398,   399,     0,
     400,     0,     0,     0,     0,   401,   402,   403,   404,   405,
     148,   149,   406,     0,   407,     0,   408,     0,   409,   410,
     411,     0,     0,     0,   412,   413,   414,   415,     0,   416,
     417,     0,   418,     0,   419,   420,   421,   155,   422,     0,
     157,     0,   423,   424,   159,     0,   425,     0,   426,     0,
       0,     0,   427,     0,   428,     0,     0,   429,     0,   430,
     431,     0,   432,   433,   434,     0,   435,   436,   437,   438,
       0,     0,   166,     0,   439,   440,   441,     0,   168,     0,
     169,     0,     0,     0,     0,   442,     0,   443,   444,   445,
     446,   447,     0,     0,   448,     0,     0,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     179,     0,   181,   707,   462,   463,   464,   465,   182,     0,
     466,   467,     0,   468,     0,   185,   186,   469,   470,     0,
       0,   471,   708,     0,     0,   472,   473,     0,     0,   187,
       0,     0,   190,   474,   475,   476,     0,   191,   192,   477,
     478,     0,   479,   480,   481,   482,   483,   484,   194,   485,
       0,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,     0,   497,   201,   498,   499,   500,   501,   502,
     503,     0,     0,   504,   505,   506,     0,   507,   205,   508,
     509,     0,   510,   208,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   210,   519,     0,   520,   521,   522,   523,
       0,   211,   212,     0,   525,     0,   526,   213,   527,   214,
       0,   528,   529,   530,   531,   532,     0,     0,   533,   534,
     535,   536,   537,     0,     0,   538,   539,   540,   221,   541,
       0,   542,     0,     0,     0,   543,   544,   545,   546,   547,
     548,     0,   223,     0,     0,   224,    79,    80,    81,   354,
       0,    83,    84,     0,    85,    86,    87,   355,     0,   356,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   357,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   358,   359,     0,     0,     0,   360,   361,     0,     0,
       0,     0,   362,     0,     0,     0,     0,     0,     0,     0,
       0,   363,     0,   364,     0,   365,   366,     0,   367,   368,
     369,   370,   371,   372,   373,     0,   374,   375,     0,     0,
       0,     0,     0,     0,     0,   376,   377,   378,     0,   379,
     380,   381,     0,   132,     0,   134,     0,     0,   382,   383,
       0,   384,     0,     0,   385,   386,   135,   387,     0,   388,
     389,   390,   391,   139,     0,     0,   392,   393,   394,     0,
     395,   396,   142,   397,     0,   398,   399,     0,   400,     0,
       0,     0,     0,   401,   402,   403,   404,   405,   148,   149,
     406,     0,   407,     0,   408,     0,   409,   410,   411,     0,
       0,     0,   412,   413,   414,   415,     0,   416,   417,     0,
     418,     0,   419,   420,   421,   155,   422,     0,   157,     0,
     423,   424,   159,     0,   425,     0,   426,     0,     0,     0,
     427,     0,   428,     0,     0,   429,     0,   430,   431,     0,
     432,   433,   434,     0,   435,   436,   437,   438,     0,     0,
     166,     0,   439,   440,   441,     0,   168,     0,   169,     0,
       0,     0,     0,   442,     0,   443,   444,   445,   446,   447,
       0,     0,   448,     0,     0,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   179,     0,
     181,   707,   462,   463,   464,   465,   182,     0,   466,   467,
       0,   468,     0,   185,   186,   469,   470,     0,     0,   471,
     708,     0,   869,   472,   473,     0,     0,   187,     0,     0,
     190,   474,   475,   476,     0,   191,   192,   477,   478,     0,
     479,   480,   481,   482,   483,   484,   194,   485,     0,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
       0,   497,   201,   498,   499,   500,   501,   502,   503,     0,
       0,   504,   505,   506,     0,   507,   205,   508,   509,     0,
     510,   208,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   210,   519,     0,   520,   521,   522,   523,     0,   211,
     212,     0,   525,     0,   526,   213,   527,   214,     0,   528,
     529,   530,   531,   532,     0,     0,   533,   534,   535,   536,
     537,     0,     0,   538,   539,   540,   221,   541,     0,   542,
       0,     0,     0,   543,   544,   545,   546,   547,   548,     0,
     223,     0,     0,   224,    79,    80,    81,   354,     0,    83,
      84,     0,    85,    86,    87,   355,     0,   356,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   357,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   358,
     359,     0,     0,     0,   360,   361,     0,     0,     0,     0,
     362,     0,     0,     0,     0,     0,     0,     0,     0,   363,
       0,   364,     0,   365,   366,     0,   367,   368,   369,   370,
     371,   372,   373,     0,   374,   375,     0,     0,     0,     0,
       0,     0,     0,   376,   377,   378,     0,   379,   380,   381,
       0,   132,     0,   134,     0,     0,   382,   383,     0,   384,
       0,     0,   385,   386,   135,   387,     0,   388,   389,   390,
     391,   139,     0,     0,   392,   393,   394,     0,   395,   396,
     142,   397,     0,   398,   399,     0,   400,     0,     0,     0,
       0,   401,   402,  1505,   404,   405,   148,   149,   406,     0,
     407,     0,   408,     0,   409,   410,   411,     0,     0,     0,
     412,   413,   414,   415,     0,   416,   417,     0,   418,     0,
     419,   420,   421,   155,   422,     0,   157,     0,   423,   424,
     159,     0,   425,     0,   426,     0,     0,     0,  1506,     0,
     428,     0,     0,   429,     0,   430,   431,     0,   432,   433,
     434,     0,   435,   436,   437,   438,     0,     0,   166,     0,
     439,   440,   441,     0,   168,     0,   169,     0,     0,     0,
       0,   442,     0,   443,   444,  1507,   446,   447,     0,     0,
     448,     0,     0,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   179,     0,   181,   707,
     462,   463,   464,   465,   182,     0,   466,   467,     0,   468,
       0,   185,   186,   469,   470,     0,     0,   471,   708,     0,
       0,   472,   473,     0,     0,   187,     0,     0,   190,   474,
     475,   476,     0,   191,   192,   477,   478,     0,   479,   480,
     481,   482,   483,   484,   194,   485,     0,   486,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,     0,   497,
     201,   498,   499,   500,  1508,   502,   503,     0,     0,   504,
     505,   506,     0,   507,   205,   508,   509,     0,   510,   208,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   210,
     519,  1509,  1510,   521,   522,   523,     0,   211,   212,     0,
     525,     0,   526,   213,   527,   214,     0,   528,   529,   530,
     531,   532,     0,     0,   533,   534,   535,   536,   537,     0,
       0,   538,   539,   540,   221,   541,     0,   542,     0,     0,
       0,   543,   544,   545,   546,   547,   548,     0,   223,     0,
       0,   224,    79,    80,    81,   354,     0,    83,    84,     0,
      85,    86,    87,   355,     0,   356,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   357,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   358,   359,     0,
       0,     0,   360,   361,     0,     0,     0,     0,   362,     0,
       0,     0,     0,     0,     0,     0,     0,   363,     0,   364,
       0,   365,   366,     0,   367,   368,   369,   370,   371,   372,
     373,     0,   374,   375,     0,     0,     0,     0,     0,     0,
       0,   376,   377,   378,     0,   379,   380,   381,     0,   132,
       0,   134,     0,     0,   382,   383,     0,   384,     0,     0,
     385,   386,   135,   387,     0,   388,   389,   390,   391,   139,
       0,     0,   392,   393,   394,     0,   395,   396,   142,   397,
       0,   398,   399,     0,   400,     0,     0,     0,     0,   401,
     402,   403,   404,   405,   148,   149,   406,     0,   407,     0,
     408,     0,   409,   410,   411,     0,     0,     0,   412,   413,
     414,   415,     0,   416,   417,     0,   418,     0,   419,   420,
     421,   155,   422,     0,   157,     0,   423,   424,   159,     0,
     425,     0,   426,     0,     0,     0,   427,     0,   428,     0,
       0,   429,     0,   430,   431,     0,   432,   433,   434,     0,
     435,   436,   437,   438,     0,     0,   166,     0,   439,   440,
     441,     0,   168,     0,   169,     0,     0,     0,     0,   442,
       0,   443,   444,   445,   446,   447,     0,     0,   448,     0,
       0,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   461,   179,     0,   181,   707,   462,   463,
     464,   465,   182,     0,   466,   467,     0,   468,     0,   185,
     186,   469,   470,     0,     0,   471,   708,     0,     0,   472,
     473,     0,     0,   187,     0,     0,   190,   474,   475,   476,
       0,   191,   192,   477,   478,     0,   479,   480,   481,   482,
     483,   484,   194,   485,     0,   486,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,     0,   497,   201,   498,
     499,   500,   501,   502,   503,     0,     0,   504,   505,   506,
       0,   507,   205,   508,   509,     0,   510,   208,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   210,   519,     0,
     520,   521,   522,   523,     0,   211,   212,     0,   525,     0,
     526,   213,   527,   214,     0,   528,   529,   530,   531,   532,
       0,     0,   533,   534,   535,   536,   537,     0,     0,   538,
     539,   540,   221,   541,     0,   542,     0,     0,     0,   543,
     544,   545,   546,   547,   548,     0,   223,     0,     0,   224,
      79,    80,    81,   354,     0,    83,    84,     0,    85,    86,
      87,   355,     0,   356,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   357,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   358,   359,     0,     0,     0,
     360,   361,     0,     0,     0,     0,   362,     0,     0,     0,
       0,     0,     0,     0,     0,   363,     0,   364,     0,   365,
     366,     0,   367,   368,   369,   370,   371,   372,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
     377,   378,     0,   379,   380,   381,     0,   132,     0,   134,
       0,     0,   382,   383,     0,   384,     0,     0,   385,   386,
     135,   387,     0,   388,   389,   390,   391,   139,     0,     0,
     392,   393,   394,     0,   395,   396,   142,   397,     0,   398,
     399,     0,   400,     0,     0,     0,     0,   401,   402,   403,
     404,   405,   148,   149,   406,     0,   407,     0,   408,     0,
     409,   410,   411,     0,     0,     0,   412,   413,   414,   415,
       0,   416,   417,     0,   418,     0,   419,   420,   421,   155,
     422,     0,   157,     0,   423,   424,   159,     0,   425,     0,
     426,     0,   785,     0,   427,     0,   428,     0,     0,   429,
       0,   430,   431,     0,   432,   433,   434,   786,   435,   436,
     437,   438,     0,     0,   166,     0,   439,   440,   441,     0,
     168,     0,   169,     0,     0,     0,     0,   442,     0,   443,
     444,   445,   446,   447,     0,     0,   448,     0,     0,   449,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   461,   179,     0,   181,     0,   462,   463,   464,   465,
     182,     0,   466,   467,     0,   468,     0,   185,   186,   469,
     470,     0,     0,   471,     0,     0,     0,   472,   473,     0,
       0,   187,     0,     0,   190,   474,   475,   476,     0,   191,
     192,   477,   478,     0,   479,   480,   481,   482,   483,   484,
     194,   485,     0,   486,   487,   488,   489,   490,   491,   492,
     493,   494,   495,   496,     0,   497,   201,   498,   499,   500,
     501,   502,   503,     0,     0,   504,   505,   506,     0,   507,
     205,   508,   509,     0,   510,   208,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   210,   519,     0,   520,   521,
     522,   523,     0,   211,   212,     0,   525,     0,   526,   213,
     527,   214,     0,   528,   529,   530,   531,   532,     0,     0,
     533,   534,   535,   536,   537,     0,     0,   538,   539,   540,
     221,   541,     0,   542,     0,     0,     0,   543,   544,   545,
     546,   547,   548,     0,   223,     0,     0,   224,    79,    80,
      81,   354,     0,    83,    84,     0,    85,    86,    87,   355,
       0,   356,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   357,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   358,   359,     0,     0,     0,   360,   361,
       0,     0,     0,     0,   362,     0,     0,     0,     0,     0,
       0,     0,     0,   363,     0,   364,     0,   365,   366,     0,
     367,   368,   369,   370,   371,   372,   373,   834,   374,   375,
       0,     0,     0,     0,     0,     0,     0,   376,   377,   378,
       0,   379,   380,   381,     0,   132,     0,   134,     0,     0,
     382,   383,     0,   384,     0,     0,   385,   386,   135,   387,
       0,   388,   389,   390,   391,   139,     0,     0,   392,   393,
     394,     0,   395,   396,   142,   397,     0,   398,   399,     0,
     400,     0,     0,     0,     0,   401,   402,   403,   404,   405,
     148,   149,   406,     0,   407,     0,   408,     0,   409,   410,
     411,     0,     0,     0,   412,   413,   414,   415,     0,   416,
     417,     0,   418,     0,   419,   420,   421,   155,   422,     0,
     157,     0,   423,   424,   159,     0,   425,     0,   426,     0,
       0,     0,   427,     0,   428,     0,     0,   429,     0,   430,
     431,     0,   432,   433,   434,     0,   435,   436,   437,   438,
       0,     0,   166,     0,   439,   440,   441,     0,   168,     0,
     169,     0,     0,     0,     0,   442,     0,   443,   444,   445,
     446,   447,     0,     0,   448,     0,     0,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     179,     0,   181,     0,   462,   463,   464,   465,   182,     0,
     466,   467,     0,   468,     0,   185,   186,   469,   470,     0,
       0,   471,     0,     0,     0,   472,   473,     0,     0,   187,
       0,     0,   190,   474,   475,   476,     0,   191,   192,   477,
     478,     0,   479,   480,   481,   482,   483,   484,   194,   485,
       0,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,     0,   497,   201,   498,   499,   500,   501,   502,
     503,     0,     0,   504,   505,   835,     0,   507,   205,   508,
     509,     0,   510,   208,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   210,   519,     0,   520,   521,   522,   523,
       0,   836,   212,     0,   525,     0,   837,   213,   527,   214,
       0,   528,   529,   530,   531,   532,     0,     0,   533,   534,
     535,   536,   537,     0,     0,   538,   539,   540,   221,   541,
       0,   542,     0,     0,     0,   543,   544,   545,   546,   547,
     548,     0,   223,     0,     0,   224,    79,    80,    81,   354,
       0,    83,    84,     0,    85,    86,    87,   355,     0,   356,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   357,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   358,   359,     0,     0,     0,   360,   361,     0,     0,
       0,     0,   362,     0,     0,     0,     0,     0,     0,     0,
       0,   363,     0,   364,     0,   365,   366,     0,   367,   368,
     369,   370,   371,   372,   373,   858,   374,   375,     0,     0,
       0,     0,     0,     0,     0,   376,   377,   378,     0,   379,
     380,   381,     0,   132,     0,   134,     0,     0,   382,   383,
       0,   384,     0,     0,   385,   386,   135,   387,     0,   388,
     389,   390,   391,   139,     0,     0,   392,   393,   394,     0,
     395,   396,   142,   397,     0,   398,   399,     0,   400,     0,
       0,     0,     0,   401,   402,   403,   404,   405,   148,   149,
     406,     0,   407,     0,   408,     0,   409,   410,   411,     0,
       0,     0,   412,   413,   414,   415,     0,   416,   417,     0,
     418,     0,   419,   420,   421,   155,   422,     0,   157,     0,
     423,   424,   159,     0,   425,     0,   426,     0,     0,     0,
     427,     0,   428,     0,     0,   429,     0,   430,   431,     0,
     432,   433,   434,     0,   435,   436,   437,   438,     0,     0,
     166,     0,   439,   440,   441,     0,   168,     0,   169,     0,
       0,     0,     0,   442,     0,   443,   444,   445,   446,   447,
       0,     0,   448,     0,     0,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   179,     0,
     181,     0,   462,   463,   464,   465,   182,     0,   466,   467,
       0,   468,     0,   185,   186,   469,   470,     0,     0,   471,
       0,     0,     0,   472,   473,     0,     0,   187,     0,     0,
     190,   474,   475,   476,     0,   191,   192,   477,   478,     0,
     479,   480,   481,   482,   483,   484,   194,   485,     0,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
       0,   497,   201,   498,   499,   500,   501,   502,   503,     0,
       0,   504,   505,   859,     0,   507,   205,   508,   509,     0,
     510,   208,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   210,   519,     0,   520,   521,   522,   523,     0,   860,
     212,     0,   525,     0,   861,   213,   527,   214,     0,   528,
     529,   530,   531,   532,     0,     0,   533,   534,   535,   536,
     537,     0,     0,   538,   539,   540,   221,   541,     0,   542,
       0,     0,     0,   543,   544,   545,   546,   547,   548,     0,
     223,     0,     0,   224,    79,    80,    81,   354,     0,    83,
      84,     0,    85,    86,    87,   355,     0,   356,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   357,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   358,
     359,     0,     0,     0,   360,   361,     0,     0,     0,     0,
     362,     0,     0,     0,     0,     0,     0,     0,     0,   363,
       0,   364,     0,   365,   366,     0,   367,   368,   369,   370,
     371,   372,   373,  1218,   374,   375,     0,     0,     0,     0,
       0,     0,     0,   376,   377,   378,     0,   379,   380,   381,
       0,   132,     0,   134,     0,     0,   382,   383,     0,   384,
       0,     0,   385,   386,   135,   387,     0,   388,   389,   390,
     391,   139,     0,     0,   392,   393,   394,     0,   395,   396,
     142,   397,     0,   398,   399,     0,   400,     0,     0,     0,
       0,   401,   402,   403,   404,   405,   148,   149,   406,     0,
     407,     0,   408,     0,   409,   410,   411,     0,     0,     0,
     412,   413,   414,   415,     0,   416,   417,     0,   418,     0,
     419,   420,   421,   155,   422,     0,   157,     0,   423,   424,
     159,     0,   425,     0,   426,     0,     0,     0,   427,     0,
     428,     0,     0,   429,     0,   430,   431,     0,   432,   433,
     434,     0,   435,   436,   437,   438,     0,     0,   166,     0,
     439,   440,   441,     0,   168,     0,   169,     0,     0,     0,
       0,   442,     0,   443,   444,   445,   446,   447,     0,     0,
     448,     0,     0,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   179,     0,   181,     0,
     462,   463,   464,   465,   182,     0,   466,   467,     0,   468,
       0,   185,   186,   469,   470,     0,     0,   471,     0,     0,
       0,   472,   473,     0,     0,   187,     0,     0,   190,   474,
     475,   476,     0,   191,   192,   477,   478,     0,   479,   480,
     481,   482,   483,   484,   194,   485,     0,   486,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,     0,   497,
     201,   498,   499,   500,   501,   502,   503,     0,     0,   504,
     505,   506,     0,   507,   205,   508,   509,     0,   510,   208,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   210,
     519,     0,   520,   521,   522,   523,     0,   211,   212,     0,
     525,     0,   526,   213,   527,   214,     0,   528,   529,   530,
     531,   532,     0,     0,   533,   534,   535,   536,   537,     0,
       0,   538,   539,   540,   221,   541,     0,   542,     0,     0,
       0,   543,   544,   545,   546,   547,   548,     0,   223,     0,
       0,   224,    79,    80,    81,   354,     0,    83,    84,     0,
      85,    86,    87,   355,     0,   356,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   357,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   358,   359,     0,
       0,     0,   360,   361,     0,     0,     0,     0,   362,     0,
       0,     0,     0,     0,     0,     0,     0,   363,     0,   364,
       0,   365,   366,     0,   367,   368,   369,   370,   371,   372,
     373,     0,   374,   375,     0,     0,     0,     0,     0,     0,
       0,   376,   377,   378,  1227,   379,   380,   381,     0,   132,
       0,   134,     0,     0,   382,   383,     0,   384,     0,     0,
     385,   386,   135,  1228,     0,   388,   389,   390,   391,   139,
       0,     0,   392,   393,   394,     0,   395,   396,   142,   397,
       0,   398,   399,     0,   400,     0,     0,     0,     0,   401,
     402,   403,   404,   405,   148,   149,   406,     0,   407,     0,
     408,     0,   409,   410,   411,     0,     0,     0,   412,   413,
     414,   415,     0,   416,   417,     0,   418,     0,   419,   420,
     421,   155,   422,     0,   157,     0,   423,   424,   159,     0,
     425,     0,   426,     0,     0,     0,   427,     0,   428,     0,
       0,   429,     0,   430,   431,     0,   432,   433,   434,     0,
     435,   436,   437,   438,     0,     0,   166,     0,   439,   440,
     441,     0,   168,     0,   169,     0,     0,     0,     0,   442,
       0,   443,   444,   445,   446,   447,     0,     0,   448,     0,
       0,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   851,   179,     0,   181,     0,   462,   463,
     464,   465,   182,     0,   466,   467,     0,   468,     0,   185,
     186,   469,   470,     0,     0,   471,     0,     0,     0,   472,
     473,     0,     0,   187,     0,     0,   190,   474,   475,   476,
       0,   191,   192,   477,   478,     0,   479,   480,   481,   482,
     483,   484,   194,   485,     0,   486,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,     0,   497,   201,   498,
     499,   500,   501,   502,   503,     0,     0,   504,   505,  1222,
       0,   507,   205,   508,   509,     0,   510,   208,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   210,   519,     0,
     520,   521,   522,   523,     0,   853,   212,     0,   525,     0,
     854,   213,   527,   214,     0,   528,   529,   530,   531,   532,
       0,     0,   533,   534,   535,   536,   537,     0,     0,   538,
     539,   540,   221,   541,     0,   542,     0,     0,     0,   543,
     544,   545,   546,   547,   548,     0,   223,     0,     0,   224,
      79,    80,    81,   354,     0,    83,    84,     0,    85,    86,
      87,   355,     0,   356,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   357,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   358,   359,     0,     0,     0,
     360,   361,     0,     0,     0,     0,   362,     0,     0,     0,
       0,     0,     0,     0,     0,   363,     0,   364,     0,   365,
     366,     0,   367,   368,   369,   370,   371,   372,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
     377,   378,     0,   379,   380,   381,     0,   132,     0,   134,
       0,     0,   382,   383,     0,   384,     0,     0,   385,   386,
     135,   387,     0,   388,   389,   390,   391,   139,     0,     0,
     392,   393,   394,     0,   395,   396,   142,   397,     0,   398,
     399,     0,   400,     0,     0,     0,     0,   401,   402,   403,
     404,   405,   148,   149,   406,     0,   407,     0,   408,     0,
     409,   410,   411,     0,     0,     0,   412,   413,   414,   415,
       0,   416,   417,     0,   418,     0,   419,   420,   421,   155,
     422,     0,   157,     0,   423,   424,   159,     0,   425,     0,
     426,     0,     0,     0,   427,     0,   428,     0,  2310,   429,
       0,   430,   431,     0,   432,   433,   434,     0,   435,   436,
     437,   438,     0,     0,   166,     0,   439,   440,   441,     0,
     168,     0,   169,     0,     0,     0,     0,   442,     0,   443,
     444,   445,   446,   447,     0,     0,   448,     0,     0,   449,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   461,   179,     0,   181,     0,   462,   463,   464,   465,
     182,     0,   466,   467,     0,   468,     0,   185,   186,   469,
     470,     0,     0,   471,     0,     0,     0,   472,   473,     0,
       0,   187,     0,     0,   190,   474,   475,   476,     0,   191,
     192,   477,   478,     0,   479,   480,   481,   482,   483,   484,
     194,   485,     0,   486,   487,   488,   489,   490,   491,   492,
     493,   494,   495,   496,     0,   497,   201,   498,   499,   500,
     501,   502,   503,     0,     0,   504,   505,   506,     0,   507,
     205,   508,   509,     0,   510,   208,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   210,   519,     0,   520,   521,
     522,   523,     0,   211,   212,     0,   525,     0,   526,   213,
     527,   214,     0,   528,   529,   530,   531,   532,     0,     0,
     533,   534,   535,   536,   537,     0,     0,   538,   539,   540,
     221,   541,     0,   542,     0,     0,     0,   543,   544,   545,
     546,   547,   548,     0,   223,     0,     0,   224,    79,    80,
      81,   354,     0,    83,    84,     0,    85,    86,    87,   355,
       0,   356,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   357,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   358,   359,     0,     0,     0,   360,   361,
       0,     0,     0,     0,   362,     0,     0,     0,     0,     0,
       0,     0,     0,   363,     0,   364,     0,   365,   366,     0,
     367,   368,   369,   370,   371,   372,   373,     0,   374,   375,
       0,     0,     0,     0,     0,     0,     0,   376,   377,   378,
       0,   379,   380,   381,     0,   132,     0,   134,     0,     0,
     382,   383,     0,   384,     0,     0,   385,   386,   135,   387,
       0,   388,   389,   390,   391,   139,     0,     0,   392,   393,
     394,     0,   395,   396,   142,   397,     0,   398,   399,     0,
     400,     0,     0,     0,     0,   401,   402,   403,   404,   405,
     148,   149,   406,  2564,   407,     0,   408,     0,   409,   410,
     411,     0,     0,     0,   412,   413,   414,   415,     0,   416,
     417,     0,   418,     0,   419,   420,   421,   155,   422,     0,
     157,     0,   423,   424,   159,     0,   425,     0,   426,     0,
       0,     0,   427,     0,   428,     0,     0,   429,     0,   430,
     431,     0,   432,   433,   434,     0,   435,   436,   437,   438,
       0,     0,   166,     0,   439,   440,   441,     0,   168,     0,
     169,     0,     0,     0,     0,   442,     0,   443,   444,   445,
     446,   447,     0,     0,   448,     0,     0,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     179,     0,   181,     0,   462,   463,   464,   465,   182,     0,
     466,   467,     0,   468,     0,   185,   186,   469,   470,     0,
       0,   471,     0,     0,     0,   472,   473,     0,     0,   187,
       0,     0,   190,   474,   475,   476,     0,   191,   192,   477,
     478,     0,   479,   480,   481,   482,   483,   484,   194,   485,
       0,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,     0,   497,   201,   498,   499,   500,   501,   502,
     503,     0,     0,   504,   505,   506,     0,   507,   205,   508,
     509,     0,   510,   208,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   210,   519,     0,   520,   521,   522,   523,
       0,   211,   212,     0,   525,     0,   526,   213,   527,   214,
       0,   528,   529,   530,   531,   532,     0,     0,   533,   534,
     535,   536,   537,     0,     0,   538,   539,   540,   221,   541,
       0,   542,     0,     0,     0,   543,   544,   545,   546,   547,
     548,     0,   223,     0,     0,   224,    79,    80,    81,   354,
       0,    83,    84,     0,    85,    86,    87,   355,     0,   356,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   357,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   358,   359,     0,     0,     0,   360,   361,     0,     0,
       0,     0,   362,     0,     0,     0,     0,     0,     0,     0,
       0,   363,     0,   364,     0,   365,   366,     0,   367,   368,
     369,   370,   371,   372,   373,     0,   374,   375,     0,     0,
       0,     0,     0,     0,     0,   376,   377,   378,     0,   379,
     380,   381,     0,   132,     0,   134,     0,     0,   382,   383,
       0,   384,     0,     0,   385,   386,   135,   387,     0,   388,
     389,   390,   391,   139,     0,     0,   392,   393,   394,     0,
     395,   396,   142,   397,     0,   398,   399,     0,   400,     0,
       0,     0,     0,   401,   402,   403,   404,   405,   148,   149,
     406,  2566,   407,     0,   408,     0,   409,   410,   411,     0,
       0,     0,   412,   413,   414,   415,     0,   416,   417,     0,
     418,     0,   419,   420,   421,   155,   422,     0,   157,     0,
     423,   424,   159,     0,   425,     0,   426,     0,     0,     0,
     427,     0,   428,     0,     0,   429,     0,   430,   431,     0,
     432,   433,   434,     0,   435,   436,   437,   438,     0,     0,
     166,     0,   439,   440,   441,     0,   168,     0,   169,     0,
       0,     0,     0,   442,     0,   443,   444,   445,   446,   447,
       0,     0,   448,     0,     0,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   179,     0,
     181,     0,   462,   463,   464,   465,   182,     0,   466,   467,
       0,   468,     0,   185,   186,   469,   470,     0,     0,   471,
       0,     0,     0,   472,   473,     0,     0,   187,     0,     0,
     190,   474,   475,   476,     0,   191,   192,   477,   478,     0,
     479,   480,   481,   482,   483,   484,   194,   485,     0,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
       0,   497,   201,   498,   499,   500,   501,   502,   503,     0,
       0,   504,   505,   506,     0,   507,   205,   508,   509,     0,
     510,   208,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   210,   519,     0,   520,   521,   522,   523,     0,   211,
     212,     0,   525,     0,   526,   213,   527,   214,     0,   528,
     529,   530,   531,   532,     0,     0,   533,   534,   535,   536,
     537,     0,     0,   538,   539,   540,   221,   541,     0,   542,
       0,     0,     0,   543,   544,   545,   546,   547,   548,     0,
     223,     0,     0,   224,    79,    80,    81,   354,     0,    83,
      84,     0,    85,    86,    87,   355,     0,   356,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   357,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   358,
     359,     0,     0,     0,   360,   361,     0,     0,     0,     0,
     362,     0,     0,     0,     0,     0,     0,     0,     0,   363,
       0,   364,     0,   365,   366,     0,   367,   368,   369,   370,
     371,   372,   373,     0,   374,   375,     0,     0,     0,     0,
       0,     0,     0,   376,   377,   378,     0,   379,   380,   381,
       0,   132,     0,   134,     0,     0,   382,   383,     0,   384,
       0,     0,   385,   386,   135,   387,     0,   388,   389,   390,
     391,   139,     0,     0,   392,   393,   394,     0,   395,   396,
     142,   397,     0,   398,   399,     0,   400,     0,     0,     0,
       0,   401,   402,   403,   404,   405,   148,   149,   406,  2568,
     407,     0,   408,     0,   409,   410,   411,     0,     0,     0,
     412,   413,   414,   415,     0,   416,   417,     0,   418,     0,
     419,   420,   421,   155,   422,     0,   157,     0,   423,   424,
     159,     0,   425,     0,   426,     0,     0,     0,   427,     0,
     428,     0,     0,   429,     0,   430,   431,     0,   432,   433,
     434,     0,   435,   436,   437,   438,     0,     0,   166,     0,
     439,   440,   441,     0,   168,     0,   169,     0,     0,     0,
       0,   442,     0,   443,   444,   445,   446,   447,     0,     0,
     448,     0,     0,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   179,     0,   181,     0,
     462,   463,   464,   465,   182,     0,   466,   467,     0,   468,
       0,   185,   186,   469,   470,     0,     0,   471,     0,     0,
       0,   472,   473,     0,     0,   187,     0,     0,   190,   474,
     475,   476,     0,   191,   192,   477,   478,     0,   479,   480,
     481,   482,   483,   484,   194,   485,     0,   486,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,     0,   497,
     201,   498,   499,   500,   501,   502,   503,     0,     0,   504,
     505,   506,     0,   507,   205,   508,   509,     0,   510,   208,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   210,
     519,     0,   520,   521,   522,   523,     0,   211,   212,     0,
     525,     0,   526,   213,   527,   214,     0,   528,   529,   530,
     531,   532,     0,     0,   533,   534,   535,   536,   537,     0,
       0,   538,   539,   540,   221,   541,     0,   542,     0,     0,
       0,   543,   544,   545,   546,   547,   548,     0,   223,     0,
       0,   224,    79,    80,    81,   354,     0,    83,    84,     0,
      85,    86,    87,   355,     0,   356,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   357,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   358,   359,     0,
       0,     0,   360,   361,     0,     0,     0,     0,   362,     0,
       0,     0,     0,     0,     0,     0,     0,   363,     0,   364,
       0,   365,   366,     0,   367,   368,   369,   370,   371,   372,
     373,     0,   374,   375,     0,     0,     0,     0,     0,  2699,
       0,   376,   377,   378,     0,   379,   380,   381,     0,   132,
       0,   134,     0,     0,   382,   383,     0,   384,     0,     0,
     385,   386,   135,   387,     0,   388,   389,   390,   391,   139,
       0,     0,   392,   393,   394,     0,   395,   396,   142,   397,
       0,   398,   399,     0,   400,     0,     0,     0,     0,   401,
     402,   403,   404,   405,   148,   149,   406,     0,   407,     0,
     408,     0,   409,   410,   411,     0,     0,     0,   412,   413,
     414,   415,     0,   416,   417,     0,   418,     0,   419,   420,
     421,   155,   422,     0,   157,     0,   423,   424,   159,     0,
     425,     0,   426,     0,     0,     0,   427,     0,   428,     0,
       0,   429,     0,   430,   431,     0,   432,   433,   434,     0,
     435,   436,   437,   438,     0,     0,   166,     0,   439,   440,
     441,     0,   168,     0,   169,     0,     0,     0,     0,   442,
       0,   443,   444,   445,   446,   447,     0,     0,   448,     0,
       0,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   461,   179,     0,   181,     0,   462,   463,
     464,   465,   182,     0,   466,   467,     0,   468,     0,   185,
     186,   469,   470,     0,     0,   471,     0,     0,     0,   472,
     473,     0,     0,   187,     0,     0,   190,   474,   475,   476,
       0,   191,   192,   477,   478,     0,   479,   480,   481,   482,
     483,   484,   194,   485,     0,   486,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,     0,   497,   201,   498,
     499,   500,   501,   502,   503,     0,     0,   504,   505,   506,
       0,   507,   205,   508,   509,     0,   510,   208,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   210,   519,     0,
     520,   521,   522,   523,     0,   211,   212,     0,   525,     0,
     526,   213,   527,   214,     0,   528,   529,   530,   531,   532,
       0,     0,   533,   534,   535,   536,   537,     0,     0,   538,
     539,   540,   221,   541,     0,   542,     0,     0,     0,   543,
     544,   545,   546,   547,   548,     0,   223,     0,     0,   224,
      79,    80,    81,   354,     0,    83,    84,     0,    85,    86,
      87,   355,     0,   356,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   357,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   358,   359,     0,     0,     0,
     360,   361,     0,     0,     0,     0,   362,     0,     0,     0,
       0,     0,     0,     0,     0,   363,     0,   364,     0,   365,
     366,     0,   367,   368,   369,   370,   371,   372,   373,     0,
     374,   375,     0,     0,     0,     0,     0,  2713,     0,   376,
     377,   378,     0,   379,   380,   381,     0,   132,     0,   134,
       0,     0,   382,   383,     0,   384,     0,     0,   385,   386,
     135,   387,     0,   388,   389,   390,   391,   139,     0,     0,
     392,   393,   394,     0,   395,   396,   142,   397,     0,   398,
     399,     0,   400,     0,     0,     0,     0,   401,   402,   403,
     404,   405,   148,   149,   406,     0,   407,     0,   408,     0,
     409,   410,   411,     0,     0,     0,   412,   413,   414,   415,
       0,   416,   417,     0,   418,     0,   419,   420,   421,   155,
     422,     0,   157,     0,   423,   424,   159,     0,   425,     0,
     426,     0,     0,     0,   427,     0,   428,     0,     0,   429,
       0,   430,   431,     0,   432,   433,   434,     0,   435,   436,
     437,   438,     0,     0,   166,     0,   439,   440,   441,     0,
     168,     0,   169,     0,     0,     0,     0,   442,     0,   443,
     444,   445,   446,   447,     0,     0,   448,     0,     0,   449,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   461,   179,     0,   181,     0,   462,   463,   464,   465,
     182,     0,   466,   467,     0,   468,     0,   185,   186,   469,
     470,     0,     0,   471,     0,     0,     0,   472,   473,     0,
       0,   187,     0,     0,   190,   474,   475,   476,     0,   191,
     192,   477,   478,     0,   479,   480,   481,   482,   483,   484,
     194,   485,     0,   486,   487,   488,   489,   490,   491,   492,
     493,   494,   495,   496,     0,   497,   201,   498,   499,   500,
     501,   502,   503,     0,     0,   504,   505,   506,     0,   507,
     205,   508,   509,     0,   510,   208,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   210,   519,     0,   520,   521,
     522,   523,     0,   211,   212,     0,   525,     0,   526,   213,
     527,   214,     0,   528,   529,   530,   531,   532,     0,     0,
     533,   534,   535,   536,   537,     0,     0,   538,   539,   540,
     221,   541,     0,   542,     0,     0,     0,   543,   544,   545,
     546,   547,   548,     0,   223,     0,     0,   224,    79,    80,
      81,   354,     0,    83,    84,     0,    85,    86,    87,   355,
       0,   356,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   357,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   358,   359,     0,     0,     0,   360,   361,
       0,     0,     0,     0,   362,     0,     0,     0,     0,     0,
       0,     0,     0,   363,     0,   364,     0,   365,   366,     0,
     367,   368,   369,   370,   371,   372,   373,     0,   374,   375,
       0,     0,     0,     0,     0,     0,     0,   376,   377,   378,
       0,   379,   380,   381,     0,   132,     0,   134,     0,     0,
     382,   383,     0,   384,     0,     0,   385,   386,   135,   387,
       0,   388,   389,   390,   391,   139,     0,     0,   392,   393,
     394,     0,   395,   396,   142,   397,     0,   398,   399,     0,
     400,     0,     0,     0,     0,   401,   402,   403,   404,   405,
     148,   149,   406,     0,   407,     0,   408,     0,   409,   410,
     411,     0,     0,     0,   412,   413,   414,   415,     0,   416,
     417,     0,   418,     0,   419,   420,   421,   155,   422,     0,
     157,     0,   423,   424,   159,     0,   425,     0,   426,     0,
       0,     0,   427,     0,   428,     0,     0,   429,     0,   430,
     431,     0,   432,   433,   434,     0,   435,   436,   437,   438,
       0,     0,   166,     0,   439,   440,   441,     0,   168,     0,
     169,     0,     0,     0,     0,   442,     0,   443,   444,   445,
     446,   447,     0,     0,   448,     0,     0,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     179,     0,   181,     0,   462,   463,   464,   465,   182,     0,
     466,   467,     0,   468,     0,   185,   186,   469,   470,     0,
       0,   471,     0,     0,     0,   472,   473,     0,     0,   187,
       0,     0,   190,   474,   475,   476,     0,   191,   192,   477,
     478,     0,   479,   480,   481,   482,   483,   484,   194,   485,
       0,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,     0,   497,   201,   498,   499,   500,   501,   502,
     503,     0,     0,   504,   505,   506,     0,   507,   205,   508,
     509,     0,   510,   208,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   210,   519,     0,   520,   521,   522,   523,
       0,   211,   212,     0,   525,     0,   526,   213,   527,   214,
       0,   528,   529,   530,   531,   532,     0,     0,   533,   534,
     535,   536,   537,     0,  3033,   538,   539,   540,   221,   541,
       0,   542,     0,     0,     0,   543,   544,   545,   546,   547,
     548,     0,   223,     0,     0,   224,    79,    80,    81,   354,
       0,    83,    84,     0,    85,    86,    87,   355,     0,   356,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   357,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   358,   359,     0,     0,     0,   360,   361,     0,     0,
       0,     0,   362,     0,     0,     0,     0,     0,     0,     0,
       0,   363,     0,   364,     0,   365,   366,     0,   367,   368,
     369,   370,   371,   372,   373,     0,   374,   375,     0,     0,
       0,     0,     0,     0,     0,   376,   377,   378,     0,   379,
     380,   381,     0,   132,     0,   134,     0,     0,   382,   383,
       0,   384,     0,     0,   385,   386,   135,   387,     0,   388,
     389,   390,   391,   139,     0,     0,   392,   393,   394,     0,
     395,   396,   142,   397,     0,   398,   399,     0,   400,     0,
       0,     0,     0,   401,   402,   403,   404,   405,   148,   149,
     406,     0,   407,     0,   408,     0,   409,   410,   411,     0,
       0,     0,   412,   413,   414,   415,     0,   416,   417,     0,
     418,     0,   419,   420,   421,   155,   422,     0,   157,     0,
     423,   424,   159,     0,   425,     0,   426,     0,     0,     0,
     427,     0,   428,     0,     0,   429,     0,   430,   431,     0,
     432,   433,   434,     0,   435,   436,   437,   438,     0,     0,
     166,     0,   439,   440,   441,     0,   168,     0,   169,     0,
       0,     0,     0,   442,     0,   443,   444,   445,   446,   447,
       0,     0,   448,     0,     0,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   179,     0,
     181,     0,   462,   463,   464,   465,   182,     0,   466,   467,
       0,   468,     0,   185,   186,   469,   470,     0,     0,   471,
       0,     0,     0,   472,   473,     0,     0,   187,     0,     0,
     190,   474,   475,   476,     0,   191,   192,   477,   478,     0,
     479,   480,   481,   482,   483,   484,   194,   485,     0,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
       0,   497,   201,   498,   499,   500,   501,   502,   503,     0,
       0,   504,   505,   506,     0,   507,   205,   508,   509,     0,
     510,   208,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   210,   519,     0,   520,   521,   522,   523,     0,   211,
     212,     0,   525,     0,   526,   213,   527,   214,     0,   528,
     529,   530,   531,   532,     0,     0,   533,   534,   535,   536,
     537,     0,     0,   538,   539,   540,   221,   541,     0,   542,
       0,     0,     0,   543,   544,   545,   546,   547,   548,     0,
     223,     0,     0,   224,    79,    80,    81,   354,     0,    83,
      84,     0,    85,    86,    87,   355,     0,   356,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   357,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   358,
     359,     0,     0,     0,   360,   361,     0,     0,     0,     0,
     362,     0,     0,     0,     0,     0,     0,     0,     0,   363,
       0,   364,     0,   365,   366,     0,   367,   368,   369,   370,
     371,   372,   373,     0,   374,   375,     0,     0,     0,     0,
       0,     0,     0,   376,   377,   378,     0,   379,   380,   381,
       0,   132,     0,   134,     0,     0,   382,   383,     0,   384,
       0,     0,   385,   386,   135,   387,     0,   388,   389,   390,
     391,   139,     0,     0,   392,   393,   394,     0,   395,   396,
     142,   397,     0,   398,   399,     0,   400,     0,     0,     0,
       0,   401,   402,   403,   404,   405,   148,   149,   406,     0,
     407,     0,   408,     0,   409,   410,   411,     0,     0,     0,
     412,   413,   414,   415,     0,   416,   417,     0,   418,     0,
     419,   420,   421,   155,   422,     0,   157,     0,   423,   424,
     159,     0,   425,     0,   426,     0,     0,     0,   427,     0,
     428,     0,     0,   429,     0,   430,   431,     0,   432,   433,
     434,     0,   435,   436,   437,   438,     0,     0,   166,     0,
     439,   440,   441,     0,   168,     0,   169,     0,     0,     0,
       0,   442,     0,   443,   444,   445,   446,   447,     0,     0,
     448,     0,     0,   449,   450,   451,   452,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   179,     0,   181,     0,
     462,   463,   464,   465,   182,     0,   466,   467,     0,   468,
       0,   185,   186,   469,   470,     0,     0,   471,     0,     0,
       0,   472,   473,     0,     0,   187,     0,     0,   190,   474,
     475,   476,     0,   191,   192,   477,   478,     0,   479,   480,
     481,   482,   483,   484,   194,   485,     0,   486,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,     0,   497,
     201,   498,   499,   500,   501,   502,   503,     0,     0,   504,
     505,   506,     0,   507,   205,   508,   509,     0,   510,   208,
       0,   511,   512,   750,   514,   515,   516,   517,   518,   210,
     519,     0,   520,   521,   522,   523,     0,   211,   212,     0,
     525,     0,   526,   213,   527,   214,     0,   528,   529,   530,
     531,   532,     0,     0,   533,   534,   535,   536,   537,     0,
       0,   538,   539,   540,   221,   541,     0,   542,     0,     0,
       0,   543,   544,   545,   546,   547,   548,     0,   223,     0,
       0,   224,    79,    80,    81,   354,     0,    83,    84,     0,
      85,    86,    87,   355,     0,   356,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   357,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   358,   359,     0,
       0,     0,   360,   361,     0,     0,     0,     0,   362,     0,
       0,     0,     0,     0,     0,     0,     0,   363,     0,   364,
       0,   365,   366,     0,   367,   368,   369,   370,   371,   372,
     373,     0,   374,   375,     0,     0,     0,     0,     0,     0,
       0,   376,   377,   378,     0,   379,   380,   381,     0,   132,
       0,   134,     0,     0,   382,   383,     0,   384,     0,     0,
     385,   386,   135,   387,     0,   388,   389,   390,   391,   139,
       0,     0,   392,   393,   394,     0,   395,   396,   142,   397,
       0,   398,   399,     0,   400,     0,     0,     0,     0,   401,
     402,   403,   404,   405,   148,   149,   406,     0,   407,     0,
     408,     0,   409,   410,   411,     0,     0,     0,   412,   413,
     414,   415,     0,   416,   417,     0,   418,     0,   419,   420,
     421,   155,   422,     0,   157,     0,   423,   424,   159,     0,
     425,     0,   426,     0,     0,     0,   427,     0,   428,     0,
       0,   429,     0,   430,   431,     0,   432,   433,   434,     0,
     435,   436,   437,   438,     0,     0,   166,     0,   439,   440,
     441,     0,   168,     0,   169,     0,     0,     0,     0,   442,
       0,   443,   444,   445,   446,   447,     0,     0,   448,     0,
       0,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   461,   179,     0,   181,     0,   462,   463,
     464,   465,   182,     0,   466,   467,     0,   468,     0,   185,
     186,   469,   470,     0,     0,   471,     0,     0,     0,   472,
     473,     0,     0,   187,     0,     0,   190,   474,   475,   476,
       0,   191,   192,   477,   478,     0,   479,   480,   481,   482,
     483,   484,   194,   485,     0,   486,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,     0,   497,   201,   498,
     499,   832,   501,   502,   503,     0,     0,   504,   505,   506,
       0,   507,   205,   508,   509,     0,   510,   208,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   210,   519,     0,
     520,   521,   522,   523,     0,   211,   212,     0,   525,     0,
     526,   213,   527,   214,     0,   528,   529,   530,   531,   532,
       0,     0,   533,   534,   535,   536,   537,     0,     0,   538,
     539,   540,   221,   541,     0,   542,     0,     0,     0,   543,
     544,   545,   546,   547,   548,     0,   223,     0,     0,   224,
      79,    80,    81,   354,     0,    83,    84,     0,    85,    86,
      87,   355,     0,   356,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   357,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   358,   359,     0,     0,     0,
     360,   361,     0,     0,     0,     0,   362,     0,     0,     0,
       0,     0,     0,     0,     0,   363,     0,   364,     0,   365,
     366,     0,   367,   368,   369,   370,   371,   372,   373,     0,
     374,   375,     0,     0,     0,     0,     0,     0,     0,   376,
     377,   378,     0,   379,   380,   381,     0,   132,     0,   134,
       0,     0,   382,   383,     0,   384,     0,     0,   385,   386,
     135,   387,     0,   388,   389,   390,   391,   139,     0,     0,
     392,   393,   394,     0,   395,   396,   142,   397,     0,   398,
     399,     0,   400,     0,     0,     0,     0,   401,   402,   403,
     404,   405,   148,   149,   406,     0,   407,     0,   408,     0,
     409,   410,   411,     0,     0,     0,   412,   413,   414,   415,
       0,   416,   417,     0,   418,     0,   419,   420,   421,   155,
     422,     0,   157,     0,   423,   424,   159,     0,   425,     0,
     426,     0,     0,     0,   427,     0,   428,     0,     0,   429,
       0,   430,   431,     0,   432,   433,   434,     0,   435,   436,
     437,   438,     0,     0,   166,     0,   439,   440,   441,     0,
     168,     0,   169,     0,     0,     0,     0,   442,     0,   443,
     444,   445,   446,   447,     0,     0,   448,     0,     0,   449,
     450,   451,   452,   453,   454,   455,   456,   457,   458,   459,
     460,   851,   179,     0,   181,     0,   462,   463,   464,   465,
     182,     0,   466,   467,     0,   468,     0,   185,   186,   469,
     470,     0,     0,   471,     0,     0,     0,   472,   473,     0,
       0,   187,     0,     0,   190,   474,   475,   476,     0,   191,
     192,   477,   478,     0,   479,   480,   481,   482,   483,   484,
     194,   485,     0,   486,   487,   488,   489,   490,   491,   492,
     493,   494,   495,   496,     0,   497,   201,   498,   499,   500,
     501,   502,   503,     0,     0,   504,   505,  1222,     0,   507,
     205,   508,   509,     0,   510,   208,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   210,   519,     0,   520,   521,
     522,   523,     0,   853,   212,     0,   525,     0,   854,   213,
     527,   214,     0,   528,   529,   530,   531,   532,     0,     0,
     533,   534,   535,   536,   537,     0,     0,   538,   539,   540,
     221,   541,     0,   542,     0,     0,     0,   543,   544,   545,
     546,   547,   548,     0,   223,     0,     0,   224,  1320,    80,
      81,   354,     0,    83,    84,     0,    85,    86,    87,   355,
       0,   356,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   357,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   358,   359,     0,     0,     0,   360,   361,
       0,     0,     0,     0,   362,     0,     0,     0,     0,     0,
       0,     0,     0,   363,     0,   364,     0,   365,   366,     0,
     367,   368,   369,   370,   371,   372,   373,     0,   374,   375,
       0,     0,     0,     0,     0,     0,     0,   376,   377,   378,
       0,   379,   380,   381,     0,   132,     0,   134,     0,     0,
     382,   383,     0,   384,     0,     0,   385,   386,   135,   387,
       0,   388,   389,   390,   391,   139,     0,     0,   392,   393,
     394,     0,   395,   396,   142,   397,     0,   398,   399,     0,
     400,     0,     0,     0,     0,   401,   402,   403,   404,   405,
     148,   149,   406,     0,   407,     0,   408,     0,   409,   410,
     411,     0,     0,     0,   412,   413,   414,   415,     0,   416,
     417,     0,   418,     0,   419,   420,   421,   155,   422,     0,
     157,     0,   423,   424,   159,     0,   425,     0,   426,     0,
       0,     0,   427,     0,   428,     0,     0,   429,     0,   430,
     431,     0,   432,   433,   434,     0,   435,   436,   437,   438,
       0,     0,   166,     0,   439,   440,   441,     0,   168,     0,
     169,     0,     0,     0,     0,   442,     0,   443,   444,   445,
     446,   447,     0,     0,   448,     0,     0,   449,   450,   451,
     452,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     179,     0,   181,     0,   462,   463,   464,   465,   182,     0,
     466,   467,     0,   468,     0,   185,   186,   469,   470,     0,
       0,   471,     0,     0,     0,   472,   473,     0,     0,   187,
       0,     0,   190,   474,   475,   476,     0,   191,   192,   477,
     478,     0,   479,   480,   481,   482,   483,   484,   194,   485,
       0,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,     0,   497,   201,   498,   499,   500,   501,   502,
     503,     0,     0,   504,   505,   506,     0,   507,   205,   508,
     509,     0,   510,   208,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   210,   519,     0,   520,   521,   522,   523,
       0,   211,   212,     0,   525,     0,   526,   213,   527,   214,
       0,   528,   529,   530,   531,   532,     0,     0,   533,   534,
     535,   536,   537,     0,     0,   538,   539,   540,   221,   541,
       0,   542,     0,     0,     0,   543,   544,   545,   546,   547,
     548,     0,   223,     0,     0,   224,    79,    80,    81,   354,
       0,    83,    84,     0,    85,    86,    87,   355,     0,   356,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   357,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   358,   359,     0,     0,     0,   360,   361,     0,     0,
       0,     0,   362,     0,     0,     0,     0,     0,     0,     0,
       0,   363,     0,   364,     0,   365,   366,     0,   367,   368,
     369,   370,   371,   372,   373,     0,   374,   375,     0,     0,
       0,     0,     0,     0,     0,   376,   377,   378,     0,   379,
     380,   381,     0,   132,     0,   134,     0,     0,   382,   383,
       0,   384,     0,     0,   385,   386,   135,   387,     0,   388,
     389,   390,   391,   139,     0,     0,   392,   393,   394,     0,
     395,   396,   142,   397,     0,   398,   399,     0,   400,     0,
       0,     0,     0,   401,   402,   403,   404,   405,   148,   149,
     406,     0,   407,     0,   408,     0,   409,   410,   411,     0,
       0,     0,   412,   413,   414,   415,     0,   416,   417,     0,
     418,     0,   419,   420,   421,   155,   422,     0,   157,     0,
     423,   424,   159,     0,   425,     0,   426,     0,     0,     0,
     427,     0,   428,     0,     0,   429,     0,   430,   431,     0,
     432,   433,   434,     0,   435,   436,   437,   438,     0,     0,
     166,     0,   439,   440,   441,     0,   168,     0,   169,     0,
       0,     0,     0,   442,     0,   443,   444,   445,   446,   447,
       0,     0,   448,     0,     0,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   179,     0,
     181,     0,   462,   463,   464,   465,   182,     0,   466,   467,
       0,   468,     0,   185,   186,   469,   470,     0,     0,   471,
       0,     0,     0,   472,   473,     0,     0,   187,     0,     0,
     190,   474,   475,   476,     0,   191,   192,   477,   478,     0,
     479,   480,   481,   482,   483,   484,   194,   485,     0,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
       0,   497,   201,   498,   499,  1530,   501,   502,   503,     0,
       0,   504,   505,   506,     0,   507,   205,   508,   509,     0,
     510,   208,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   210,   519,     0,   520,   521,   522,   523,     0,   211,
     212,     0,   525,     0,   526,   213,   527,   214,     0,   528,
     529,   530,   531,   532,     0,     0,   533,   534,   535,   536,
     537,     0,     0,   538,   539,   540,   221,   541,     0,   542,
       0,     0,     0,   543,   544,   545,   546,   547,   548,     0,
     223,     0,     0,   224,    79,    80,    81,     0,     0,    83,
      84,     0,    85,    86,    87,     0,     0,     0,    90,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,     0,     0,     0,   103,   104,   105,   106,     0,   107,
       0,   108,   109,   110, -1298,   111,   112,   113,   114,     0,
       0,     0,     0,     0,   117,   118,     0,     0,     0,     0,
     119,     0,     0,     0,     0,     0,     0,     0,     0,   120,
       0,   121,     0,   122,   123,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   129,     0,     0,     0,
     131,   132,   133,   134,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   135,     0,     0,     0,     0,     0,
       0,   139,     0,     0,     0,     0,     0,     0,     0,     0,
     142,     0,     0,     0,     0,   145,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   148,   149,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   155,     0,     0,   157,     0,     0,     0,
     159,     0,     0,     0,     0,   160,     0,   161,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   164,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   165,   166,     0,
       0,     0,     0,     0,   168,     0,   169,     0,     0,   170,
     171,     0,   172,     0,     0,     0,     0,     0,     0,   173,
       0,   174,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   179,   180,   181,     0,
       0,     0,     0,     0,   182,     0,     0,     0,   184,     0,
       0,   185,   186,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   187,   188,   189,   190,     0,
       0,     0,     0,   191,   192,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   194,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   199,     0,
     201,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   205,     0,     0,   207,     0,   208,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   210,
       0,     0,     0,     0,     0,     0,     0,   211,   212,     0,
       0,     0,     0,   213,     0,   214,     0,     0,     0,     0,
       0,     0,   217,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   221,     0,   222,     0,     0,     0,
       0,     0,     0,     0,    79,    80,    81,     0,   223,    83,
      84,   224,    85,    86,    87,     0,     0,     0,    90,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,     0,     0,     0,   103,   104,   105,   106,     0,   107,
       0,   108,   109,   110, -1299,   111,   112,   113,   114,     0,
       0,     0,     0,     0,   117,   118,     0,     0,     0,     0,
     119,     0,     0,     0,     0,     0,     0,     0,     0,   120,
       0,   121,     0,   122,   123,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   129,     0,     0,     0,
     131,   132,   133,   134,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   135,     0,     0,     0,     0,     0,
       0,   139,     0,     0,     0,     0,     0,     0,     0,     0,
     142,     0,     0,     0,     0,   145,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   148,   149,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   155,     0,     0,   157,     0,     0,     0,
     159,     0,     0,     0,     0,   160,     0,   161,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   164,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   165,   166,     0,
       0,     0,     0,     0,   168,     0,   169,     0,     0,   170,
     171,     0,   172,     0,     0,     0,     0,     0,     0,   173,
       0,   174,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   179,   180,   181,     0,
       0,     0,     0,     0,   182,     0,     0,     0,   184,     0,
       0,   185,   186,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   187,   188,   189,   190,     0,
       0,     0,     0,   191,   192,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   194,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   199,     0,
     201,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   205,     0,     0,   207,     0,   208,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   210,
       0,     0,     0,     0,     0,     0,     0,   211,   212,     0,
       0,     0,     0,   213,     0,   214,     0,     0,     0,     0,
       0,     0,   217,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   221,     0,   222,     0,     0,     0,
       0,     0,     0,     0,    79,    80,    81,     0,   223,    83,
      84,   224,    85,    86,    87,     0,     0,     0,    90,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,     0,     0,     0,   103,   104,   105,   106,     0,   107,
       0,   108,   109,   110,     0,   111,   112,   113,   114,     0,
       0,     0,     0,     0,   117,   118,     0,     0,     0,     0,
     119,     0,     0,     0,     0,     0,     0,     0,     0,   120,
       0,   121,     0,   122,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   129,     0,     0,     0,
     131,   132,   133,   134,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   135,     0,     0,     0,     0,     0,
       0,   139,     0,     0,     0,     0,     0,     0,     0,     0,
     142,     0,     0,     0,     0,   145,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   148,   149,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   155,     0,     0,   157,     0,     0,     0,
     159,     0,     0,     0,     0,   160,     0,   161,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   164,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   165,   166,     0,
       0,     0,     0,     0,   168,     0,   169,     0,     0,   170,
     171,     0,   172,     0,     0,     0,     0,     0,     0,   173,
       0,   174,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   179,   180,   181,     0,
       0,     0,     0,     0,   182,     0,     0,     0,   184,     0,
       0,   185,   186,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   187,   188,   189,   190,     0,
       0,     0,     0,   191,   192,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   194,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   199,     0,
     201,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   205,     0,     0,   207,     0,   208,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   210,
       0,     0,     0,     0,     0,     0,     0,   211,   212,     0,
       0,     0,     0,   213,     0,   214,     0,     0,     0,     0,
       0,     0,   217,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   221,     0,   222,     0,     0,     0,
       0,     0,     0,     0,    79,    80,    81,     0,   223,    83,
      84,   224,    85,    86,    87,     0,     0,     0,    90,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,     0,     0,     0,   103,   104,   105,   106,     0,   107,
       0,   108,   109,   110,     0,   111,   112,   113,   114,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   129,     0,     0,     0,
     131,   132,   133,   134,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   135,     0,     0,     0,     0,     0,
       0,   139,     0,     0,     0,     0,     0,     0,     0,     0,
     142,     0,     0,     0,     0,   145,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   148,   149,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   155,     0,     0,   157,     0,     0,     0,
     159,     0,     0,     0,     0,   160,     0,   161,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   164,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   165,   166,     0,
       0,     0,     0,     0,   168,     0,   169,     0,     0,   170,
     171,     0,   172,     0,     0,     0,     0,     0,     0,   173,
       0,   174,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   179,   180,   181,     0,
       0,     0,     0,     0,   182,     0,     0,     0,   184,     0,
       0,   185,   186,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   187,   188,   189,   190,     0,
       0,     0,     0,   191,   192,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   194,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   199,     0,
     201,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   205,     0,     0,   207,     0,   208,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   210,
       0,     0,     0,     0,     0,     0,     0,   211,   212,     0,
       0,     0,     0,   213,     0,   214,     0,     0,     0,     0,
       0,     0,   217,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   221,     0,   222,    79,    80,    81,
       0,     0,    83,    84,     0,    85,    86,    87,   223,     0,
       0,   224,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,     0,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   129,
       0,     0,     0,   131,   132,   133,   134,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   135,     0,     0,
       0,     0,     0,     0,   139,     0,     0,     0,     0,     0,
       0,     0,     0,   142,     0,     0,     0,     0,   145,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   148,
     149,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   155,     0,     0,   157,
       0,     0,     0,   159,     0,     0,     0,     0,   160,     0,
     161,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     164,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     165,   166,     0,     0,     0,     0,     0,   168,     0,   169,
       0,     0,   170,   171,     0,   172,     0,     0,     0,     0,
       0,     0,   173,     0,   174,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   179,
     180,   181,     0,     0,     0,     0,     0,   182,     0,     0,
       0,   184,     0,     0,   185,   186,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   187,   188,
     189,   190,     0,     0,     0,     0,   191,   192,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   194,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   199,     0,   201,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   205,     0,     0,
     207,     0,   208,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   210,     0,     0,     0,     0,     0,     0,     0,
     211,   212,     0,     0,     0,     0,   213,     0,   214,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   221,     0,   222,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   223,     0,     0,   224
};

static const short yycheck[] =
{
       2,   225,   695,    74,   823,    90,  1067,   688,   215,   690,
     959,  1042,    74,    74,   147,   154,   849,  1048,   158,   687,
     701,   154,    77,   691,  1475,  1352,  1457,   112,   854,  1171,
     709,  1003,   679,   940,  1306,   728,  1430,   907,   178,   689,
     690,   745,  1155,   724,    74,    90,    90,  1432,   219,    74,
     718,  1641,    77,   128,   193,   736,  1920,    90,  2143,    90,
     193,    74,    74,    74,   940,    90,    82,   112,   112,   762,
    1445,   146,   722,  1707,  2077,  2263,  1445,  1445,  1445,   112,
     779,   112,  2076,  1445,  1328,   753,  1445,   112,  1800,  1801,
    1848,   759,  1533,   774,  1473,  2098,   800,  1122,  1123,  2308,
    1479,   850,  1680,   852,  2432,  2433,  2427,   757,  1742,  1082,
    1776,    25,  1746,  1082,  1471,   915,  1141,  1779,  1780,  1092,
    1093,    42,   847,    26,    42,   935,    77,   940,    50,   923,
     924,    93,   217,   659,    92,    77,   111,    77,   111,  2786,
     116,   681,    92,  1131,   848,   116,   138,   150,  2380,    77,
      93,    80,   134,   116,   225,   226,   158,    97,   156,   128,
     176,   188,   158,   219,   226,   150,   111,   219,   188,    85,
      77,   156,   217,   217,    85,    91,   178,   125,    74,    34,
      91,    77,    29,   175,   217,   137,   217,    29,   268,   166,
      97,   183,   217,  2738,    90,   203,    86,   219,   151,    77,
     219,  1595,   172,     2,  2926,   272,    74,   151,   172,    77,
      43,   193,    45,   226,   226,   226,   112,  1879,   138,  1192,
     353,   153,    90,  1857,   242,   129,   218,   219,   213,   134,
     156,    92,   151,   320,   281,   112,    77,   189,   164,  1566,
    2785,    85,  3114,   172,   112,  1194,     8,   151,   312,    12,
     311,    82,    14,    15,    16,   175,     0,   209,   351,  1231,
     354,   124,    85,   183,    26,    27,    28,    92,    30,    31,
      32,    85,   224,   383,    36,    37,    38,    92,   141,   231,
     959,   311,   219,    82,  3156,   219,   311,    50,   193,   350,
     153,   385,   347,    85,    77,   203,   977,   249,   218,    91,
     318,    83,   210,  2238,  1417,   369,   151,   156,    92,   402,
    3182,   421,  2952,   312,    97,  1568,   160,   219,   100,   386,
     350,   217,   347,  1230,   214,   350,  1019,  1388,   415,  1008,
     262,   351,   307,   164,   307,   320,   335,   200,   257,   151,
     217,   421,  1010,   221,    82,   111,    74,  1600,  1016,   217,
     372,   354,  2216,   257,  2899,    77,   211,   327,   310,  1006,
    1041,   287,   307,   327,   213,   421,   418,   320,   215,   277,
     417,   369,  1053,   215,  1952,    97,   372,   176,  1403,  1404,
     221,  2702,   385,   312,   369,  2706,  1411,  1055,  1069,  2710,
    1532,  1533,  1843,   362,   421,   273,   219,     2,   327,   418,
    1461,  1543,  1544,   351,   381,   219,  1378,   933,  2493,  2494,
      77,  3058,  2644,   421,   377,   311,   332,   957,  1406,   347,
     391,   332,   375,   394,   257,  3147,   164,  1569,   391,  1571,
     415,   394,   273,  2427,   416,   372,   418,   389,   221,   415,
     383,   384,  3082,   311,   415,  2023,   421,   391,   421,   524,
     394,   347,   415,   415,   350,   413,  2214,  2215,   372,  2093,
     411,  1261,   415,   413,   122,  2223,   408,   409,   410,   411,
     391,   411,   394,   394,   418,    77,   394,  1290,   399,   347,
     401,  1838,   350,  1283,   418,  2151,   407,   253,  1630,  1214,
    1215,   394,  1302,  1287,   325,   409,   153,  2087,   226,   221,
     222,   408,   409,   410,   411,   164,   223,   118,   416,  1753,
      18,   416,  1485,   418,   392,  1194,   418,  1486,  2096,  1389,
     369,  1494,   693,   271,   286,   403,   404,   698,   406,   407,
     408,   409,   410,   411,  1559,  1560,   145,  2865,   260,   190,
     332,   307,  2204,  1922,  1923,   266,   391,  1246,  2869,   394,
     297,   392,   413,  2874,   221,   416,   417,  2878,   151,   325,
     421,   402,   403,   404,   302,   406,   407,   408,   409,   410,
     411,   394,   190,   156,   185,   416,   399,   189,   295,   391,
     394,   752,   394,  1332,   407,   399,   266,   399,   413,   151,
     154,   416,   417,   407,   679,   418,   421,   206,   413,   361,
     257,   416,   417,  2237,   418,  2793,   421,   746,  1371,   295,
     104,   269,   745,   746,  2549,  2550,  2551,  2552,  2553,   221,
     223,  1370,   683,   406,   407,   408,   409,   410,   411,   413,
     213,   410,   416,   417,   679,   679,   200,   421,   417,   104,
     780,    29,   782,   776,   784,  1324,   679,   792,   679,   143,
     790,   791,    40,   683,   679,   273,   151,   659,   683,  1352,
     134,  2982,   262,   314,   257,   153,   325,   800,   415,   179,
     282,   273,  1505,    77,  1507,  1508,   259,  1510,   289,   824,
      18,  1328,   118,   369,   406,   407,   408,   409,   410,   411,
    1509,  1454,   295,   129,   415,   687,   118,  2091,  1600,   691,
     262,   693,   361,   125,   421,   697,   698,   129,  2702,  1390,
     351,   171,  2706,  1394,  2923,   848,  2710,    77,   212,   193,
     208,   339,   156,   146,  2051,   717,   718,   115,   379,   320,
     198,   160,   102,   188,   343,   415,   257,   320,  2602,   406,
     407,   408,   409,   410,   411,  1998,  1999,  2000,   144,   185,
    2003,  1398,   262,   416,   365,   156,   266,   217,   421,   253,
     752,   753,   257,   185,  2879,  2144,  2881,   759,    93,   257,
    2155,  2529,  2530,   294,   242,   198,   417,   697,   780,   213,
     782,   422,   784,   679,   375,   110,   369,   683,   790,   791,
     392,   391,   242,  2046,   394,   245,   221,   717,   281,   155,
     183,  1482,   146,   219,   406,   407,   408,   409,   410,   411,
     343,   679,   213,  2192,  2193,   683,   276,   221,  2812,   242,
     865,  2533,   245,   317,   415,   817,   146,   215,   257,   199,
     342,   823,   415,   203,  1741,   851,   203,   266,  1506,   831,
     865,   336,   325,   210,   339,   241,   271,   243,   358,  1682,
     318,   234,   177,   289,   198,  1725,   366,   258,   259,   371,
     659,   221,   193,   233,   220,  1741,   154,   289,   318,   155,
    2985,   418,   864,  1566,  2016,  2869,   201,   869,   198,   354,
    2874,  1942,   234,  2258,  2878,   268,   320,   120,   880,  2258,
    2258,  2258,  2333,  2035,   171,   318,  2258,   817,   242,  2258,
     154,   183,   227,   823,   364,   907,   183,   923,   924,   189,
     277,   831,   200,   273,   167,  2294,   268,  2296,  2297,   320,
    2554,  1006,   242,   173,  1794,   245,   321,  1797,  1798,   365,
     932,   933,   692,   935,   220,   369,  2078,  2079,   940,   714,
     217,   969,   702,   365,   864,  2355,   200,  1171,   343,   869,
    1629,  1598,   234,   419,   204,   135,   136,   234,   321,   329,
     880,  1006,  1006,  3031,   387,   740,   726,   378,   369,   865,
     998,  2381,  1105,  1006,   318,  1006,   418,  3062,   738,   394,
     343,  1006,    82,   308,   399,   238,   268,    87,  2982,   281,
      46,   268,   415,  2751,   319,  2753,  2754,   865,   318,   276,
     760,   416,   406,   407,   408,   409,   410,   411,   333,  3077,
     302,   771,  1083,  3098,   415,   340,    77,  1009,  1010,   337,
     338,  1083,   122,   203,  1016,   383,   384,   146,   281,   418,
    1101,  1334,   392,   325,   134,   392,  1740,   413,  3032,  1101,
    3043,   417,   402,   403,   404,  1116,   406,   407,   408,   409,
     410,   411,   851,  1356,   659,   380,   416,   415,  1050,  1051,
    1076,    77,  1133,  1055,   164,  1057,    57,   387,   188,  2933,
    1083,  1083,  1083,   391,   254,   255,   394,   295,   281,   198,
    3083,    97,   423,   203,    75,   303,   102,   364,  1159,  1009,
     129,   344,   413,   346,   415,   415,  1998,  1999,  2000,   302,
    1171,  2003,   305,   283,   322,  1755,  1753,  1099,  2361,   104,
    1006,  2364,  2365,  2366,  2367,  2368,  2369,  2370,  2371,  2372,
    2373,    98,   325,   242,   923,   924,   245,   394,   281,   281,
    1050,  1051,  2722,   932,   933,   281,   935,  1057,  1006,   416,
     117,   940,   203,    77,  2046,   281,  2399,  2400,   143,   302,
     302,   281,   391,   192,  2912,   394,   302,  1173,  1298,   392,
     221,  2555,   342,    97,  1845,  1846,   302,   206,  1184,   402,
     403,   404,   302,   406,   407,   408,   409,   410,   411,  1099,
    1265,  1252,  1253,    82,  1255,   419,   281,   203,    87,   189,
     383,   384,   391,    77,   374,   394,  1367,     7,   237,   318,
    1357,    11,   302,  1360,  1361,   221,   222,   302,  2480,   209,
    1285,  1227,   273,    23,    24,  2600,   415,   212,   372,   414,
    1265,  1265,   415,   122,   224,   325,   421,  1931,  1230,   215,
    1232,   231,  1234,  2612,    44,   134,   275,    47,   414,    21,
    1265,  1266,  1267,  1328,   260,   421,     5,   271,   416,  1241,
    2392,  2630,   377,   421,   104,  1316,   391,   273,   253,   394,
     125,    39,   394,  2089,   129,   164,   391,   399,   387,   394,
      29,  1287,  2385,  2386,  1276,  2108,   415,  1076,  1323,  2673,
     415,    40,   302,  1328,  1328,   305,  1316,   271,   138,   416,
     415,  1316,  1516,   356,   421,  1328,  1298,  1328,  1323,   345,
    1302,   347,   907,  1328,  1306,   325,   345,   157,   347,  2179,
     310,    88,    89,  1398,   402,  2185,  2186,   356,   416,  2572,
     170,  1241,   317,   421,  2231,   413,   365,   932,   933,   417,
     935,   392,  1128,  1129,   184,   940,   391,   221,   304,   394,
     379,   402,   403,   404,   131,   406,   407,   408,   409,   410,
     411,   161,   416,  1398,  1398,  1151,   115,   421,  2051,   391,
     415,   109,   394,   383,  1160,  1398,   345,  1398,   347,  1265,
    1266,  1267,   292,  1398,  1173,  1367,   392,   391,   391,   391,
     394,   394,   394,   415,   267,  1184,  2817,  1389,   271,   273,
     406,   407,   408,   409,   410,   411,   144,  1265,  1266,  1267,
     206,   415,  2729,   415,   163,  1545,   413,  1547,   415,   415,
     417,  1551,   262,  2106,   383,   384,   394,  1557,   227,   269,
    1316,   399,   391,   401,  1564,   394,   325,  1323,  1227,   407,
    2683,  1230,  1328,  1232,  1574,  1234,  1576,   391,   393,   394,
     394,  1457,   383,   384,   294,  1516,   415,   399,  1316,   401,
     391,   219,  1592,   394,  1594,  1323,   215,   205,   291,  2361,
    1328,   415,  2364,  2365,  2366,  2367,  2368,  2369,  2370,  2371,
    2372,  2373,   420,   421,   415,  2125,   391,   391,   394,   394,
     394,   115,   116,   399,  1476,  1477,  2435,   391,  1287,  2461,
     394,   407,   345,   241,   347,   243,   271,  2891,  2400,  1501,
     415,   415,  1398,  1302,   416,   253,   188,  1306,   392,   421,
     416,   415,   421,  1598,  1506,   421,   416,  1509,   402,   403,
     404,   421,   406,   407,   408,   409,   410,   411,  1520,   416,
    1398,  1602,   390,   120,   421,   393,   391,  1529,  2231,   394,
    1556,   388,   416,  1545,   399,  1547,   401,   421,  2015,  1551,
    2017,  2018,   407,  1598,  1598,  1557,  1476,  1477,   306,   420,
     421,   391,  1564,   120,   394,  1598,    77,  1598,    98,   399,
     416,   401,  1574,  1598,  1576,   421,   416,   407,   780,    90,
     782,   421,   784,  2230,   391,  1032,   334,   394,   790,  1509,
    1592,    77,  1594,   413,  2847,   274,  2849,   417,   416,   391,
    1520,   421,   394,   421,    90,  3002,  3003,  1740,  3005,  1529,
    3007,    97,   416,   345,  1675,   347,   102,   421,  1065,   223,
     406,   407,   408,   409,   410,  1230,   416,  1232,   418,  1234,
     416,    82,   416,  1625,   408,   409,   410,   421,    89,  1641,
    2308,    92,  1658,   416,   416,  1675,   351,   118,   421,   421,
    1675,   102,   416,  1708,   416,  1710,   416,   421,  1457,   421,
    2341,   421,   160,   391,   416,   271,   394,   416,  1753,   421,
    2572,  1276,   421,   416,   416,   383,   384,   128,   421,   421,
     151,   179,   388,  1708,  1444,  1710,   137,   138,  1828,  1681,
     406,   407,   408,   409,   410,   146,   147,  1302,   414,   150,
      98,  1306,  1598,   154,   223,  1625,   416,   158,  1753,  1753,
     221,   421,   416,   199,   418,  1731,  2969,   203,  1478,  3170,
    1753,   416,  1753,  1725,   416,  1865,   421,   178,  1753,   421,
    1598,   418,   416,   388,   421,   221,   222,   421,  1878,  1741,
    2882,  1743,   193,  1745,   416,   196,   197,   233,    93,   421,
    2707,   202,  2709,   204,   325,   206,  2435,  1556,   151,   257,
     418,  1681,   273,   421,   262,   110,   418,   416,   266,   421,
     416,   257,   421,   416,   260,   421,   408,   416,   421,  1675,
     416,  2683,   421,   187,  1389,   421,   257,   273,   418,   275,
     418,   262,  1794,   421,   416,  1797,  1798,   882,  1931,   884,
    1870,  1871,  1872,  1873,   416,   392,    85,  1675,  3135,   383,
     384,  2035,  1708,   108,  1710,   402,   403,   404,   289,   406,
     407,   408,   409,   410,   411,   218,  1828,   298,  1968,   383,
     384,   408,   177,   383,   384,   392,  1852,    85,  1252,  1253,
    1708,  1255,  1710,   329,   237,   402,   403,   404,   215,   406,
     407,   408,   409,   410,   411,   419,   201,  1753,  1860,  1658,
     358,  2110,  2111,  1865,  2071,  2072,  1252,  1253,   366,  1255,
     419,   925,   926,   351,   351,   351,  1878,   351,  1325,   351,
     169,   392,   227,    93,   108,  1753,   134,   372,   423,   215,
    1906,   402,   403,   404,   365,   406,   407,   408,   409,   410,
     411,   221,   353,   351,   417,   415,   392,   415,   156,   415,
    1902,   415,   415,   281,   415,  1907,   402,   403,   404,   302,
     406,   407,   408,   409,   410,   411,   174,   415,   414,   271,
    2961,   281,  1731,   417,   232,   418,   415,   423,   265,   227,
    1387,   383,  1741,   118,  1743,  2847,  1745,  2849,   415,   383,
    2090,    93,   383,    98,    98,   383,   281,   227,   382,   415,
     415,   271,   271,   308,  2035,   213,  1968,   421,   184,   232,
     183,   271,   415,   286,   319,   137,   415,  2048,   415,   415,
     415,   421,  1902,   415,    93,   415,   415,  1907,   333,   415,
    1750,   232,  1439,   415,  1754,   340,  2067,   390,   391,   415,
     393,   394,   415,   415,   415,  2076,   399,   415,   401,  1769,
     415,   183,   415,   415,   407,   221,   415,   408,   215,  1779,
    1780,  1781,  1782,   245,  1471,   318,   421,   189,  1827,   150,
     371,    42,  1792,   417,   273,   380,  2729,  2716,   383,    18,
     421,   415,   415,   415,   351,  1844,   351,   209,   417,  1848,
     298,   421,   351,  1852,   351,  1815,   371,   351,  1818,  1819,
     371,  1860,   224,   125,   351,   351,   314,  2969,    84,   231,
     351,   344,   320,   524,   351,   351,   372,   351,  2070,   271,
     352,   384,   421,   351,  2076,  2087,   351,   249,  2090,   351,
    2092,  3152,   351,  1892,   415,   271,  2236,   345,   415,   347,
     269,   221,   377,   415,    93,    83,   151,  1906,   356,   271,
     238,   415,   183,   415,   415,   131,   271,   568,   569,  1879,
    1725,   369,   370,  2942,   146,   415,    93,   317,    77,   145,
     415,    93,   372,    18,   351,   402,  1741,   421,  1743,   421,
    1745,    90,  2975,   421,   375,  2230,   162,   261,   310,  1596,
    2070,   415,  2985,   392,  2293,   415,   381,    77,   416,   325,
    2293,   349,   349,   402,   403,   404,   421,   406,   407,   408,
     409,   410,   411,   415,   190,   349,   198,  2179,   194,   415,
     351,   188,   402,  2185,  2186,  2230,  2230,   421,   421,  1794,
     206,   354,  1797,  1798,  2418,   416,   217,  2230,   421,  2230,
     272,   266,   234,  2427,   413,  2230,  2346,    39,   416,   409,
     372,   227,  2352,  2420,  2421,  2422,  2423,  3050,   416,  2290,
     242,   415,  2293,   245,   225,   225,   415,   389,  2290,  2231,
     421,  2293,   262,  2249,  2236,   262,  2238,   688,   689,   690,
     351,   692,   421,   694,   695,   696,  2248,  2318,   699,   700,
     701,   702,   351,   108,   343,  2923,  2318,   273,   416,   302,
     194,   391,   368,    93,   295,   221,  2947,   221,   719,   372,
    2262,   722,   221,   724,   221,   726,  2268,   402,   413,   730,
     731,   351,   351,   734,   402,   736,   183,   738,   271,   275,
     195,   308,    93,  2092,   745,   746,   318,   197,   197,   183,
     316,   416,    12,   754,   416,   321,   757,   244,   421,   760,
     188,   416,   416,   764,   416,   188,  2308,   768,   769,   416,
     771,   416,   416,   774,   273,   416,   188,   343,   344,  1776,
     416,   421,   388,   388,  2230,   416,   416,   416,   416,   416,
     356,   792,  2262,   794,  2346,   361,   388,  2418,  2268,   800,
    2352,   415,  3033,   351,   415,   371,  2427,   416,   416,    35,
     351,   402,  2230,    77,   418,   387,   416,   416,   390,   391,
     421,   393,   394,   281,   118,   351,    90,   828,   418,   415,
     415,   832,  2398,    97,   221,   129,   221,   416,   102,   245,
      84,  1838,   416,   413,   271,   361,   847,   848,   849,   850,
    2160,   852,   416,   416,  2544,   379,   415,   151,  2207,   153,
     416,  1858,   269,   421,   372,  2214,  2215,   269,   351,   113,
     271,   416,   421,   172,  2223,   402,   172,   169,   413,   416,
     134,   125,  2231,  2425,  2426,  2427,   188,   131,    77,  2238,
     183,   416,  3135,   392,  2204,   416,   416,   116,   416,  2248,
    2249,   145,   156,   402,   403,   404,   415,   406,   407,   408,
     409,   410,   411,   194,   208,   416,  3134,   402,   162,   421,
     174,  1918,   923,   924,   402,   421,   927,   415,  2480,   392,
     351,   351,   351,   351,   351,   199,   221,  2092,   221,   203,
     416,   221,   158,   415,   183,   414,   190,   948,   225,  3167,
     951,   275,   207,   954,    93,  2425,  2426,   221,   222,   213,
      93,   372,   206,   257,   226,   193,   188,   415,   262,   233,
     415,   266,   416,   416,   416,   416,   977,  2598,   415,   224,
     416,   278,   224,   416,   228,  2537,  2598,   108,   196,   415,
     415,   415,  2544,   257,   361,   289,   260,  2549,  2550,  2551,
    2552,  2553,   372,   262,   298,   262,   221,   153,   208,   273,
     414,   275,   190,   190,  2556,   188,   206,   372,   165,  1020,
     174,   416,   152,  1024,  2179,   152,   415,  1028,   188,   273,
    2185,  2186,  1033,   271,   351,  2601,  2578,   319,   262,   183,
    1041,   274,  2584,   415,   298,   224,   415,   415,   292,  2398,
     416,   298,  1053,  1054,    93,  1056,  2746,   262,   240,   293,
     314,   271,   269,   269,   421,   329,   320,   262,  1069,   344,
     314,   365,   316,   271,   415,    96,  2231,   321,   416,   183,
     271,  2702,    93,   127,   165,  2706,  2556,   211,   344,  2710,
    1091,   345,   262,   347,   262,   271,   271,   415,   211,   343,
     161,   421,   356,  1104,   369,   156,   421,   174,  2578,   312,
      81,   313,   356,  1114,  2584,   369,   370,   361,   416,   313,
     226,   293,  1882,   297,   415,  1440,  1234,  1814,   392,  2092,
    1785,  2480,  2189,  1883,  2590,   379,  2140,  1805,   402,   403,
     404,  2511,   406,   407,   408,   409,   410,   411,  2690,  2691,
    2692,  2693,   416,  2779,  2151,  2593,  2607,  2723,  3095,  3125,
    2702,  3073,  3072,  3104,  2706,  3023,  2939,  1455,  2710,  2595,
    2722,  1868,  3182,  3156,  2764,  2172,  2763,  2174,  2230,  3137,
    2529,  2530,  3183,  1442,   178,  1100,  1529,  2621,  2328,   840,
    3032,  2188,  2758,  1883,  2746,  2150,  2285,  3009,  1107,  2823,
    2549,  2550,  2551,  2552,  2553,  3181,  3146,  1874,  1681,   156,
    2319,  1083,  1929,  1214,  1215,    77,  2213,   863,  2103,  2615,
    2690,  2691,  2692,  2693,  2427,  2112,  1227,  1259,    90,  1260,
    1678,  1232,  1233,  1234,  2231,    97,  2983,  2588,  1414,  2397,
     102,  2807,  1243,  2708,  2231,  1970,  2679,  2813,  2869,  2048,
    1626,  2817,  2601,  2874,  3056,  2624,  2097,  2878,  1054,  2726,
    1734,   930,  2838,  1300,  1731,  1267,    74,   312,  1706,  2266,
    2812,   958,   663,  1741,  1937,  1105,   926,  2086,  1938,  2616,
    2277,  2617,  2721,  1213,  1285,  2465,  1287,  1776,  2285,   346,
    1265,  1932,  1745,  1500,   932,     2,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1318,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2480,    -1,  2869,    -1,    -1,
      -1,  1332,  2874,    -1,  2886,    -1,  2878,   199,    -1,    -1,
      -1,   203,  2339,    -1,  2965,    -1,    -1,    84,    -1,    -1,
      -1,  1352,    -1,  2965,    -1,    -1,    -1,    -1,    95,   221,
     222,  2982,    -1,  2360,    -1,    -1,    -1,    -1,    -1,  1370,
      -1,   233,    -1,  2722,  2723,    -1,   113,    -1,    -1,   134,
      -1,  2923,  2537,  2925,  3158,    -1,    -1,    -1,    -1,  1390,
    2387,    -1,    -1,  1394,   131,   257,    -1,    -1,   260,    -1,
    2942,    -1,  2751,    -1,  2753,  2754,    -1,    -1,   145,  2758,
      -1,   273,  2409,   275,    -1,    -1,   171,    -1,    -1,  3109,
    3110,    -1,  2964,  2733,    -1,   162,    -1,    -1,   183,    -1,
    2740,    -1,  2742,   188,    -1,    -1,    -1,    -1,   193,   194,
    2982,   196,    -1,  1444,    -1,  1446,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   190,  2996,  2925,  1457,   194,  2807,    -1,
      -1,    -1,   217,    -1,  2813,    -1,    -1,   329,  2817,   206,
      -1,  3037,  2942,    -1,    -1,    -1,    -1,  1478,    -1,   234,
      -1,  1482,    -1,    -1,    -1,    -1,  1487,    -1,    -1,    -1,
    3032,    -1,    -1,  3059,  2964,    -1,    -1,  3063,    -1,    -1,
      -1,    -1,    -1,    -1,  1505,    -1,  1507,  1508,    -1,  1510,
      -1,    -1,    -1,   268,    -1,  1516,    -1,  2514,    -1,    -1,
      -1,   276,    -1,    -1,    -1,  3146,  2996,    -1,    -1,  1530,
     392,    -1,    -1,    -1,    -1,    -1,   273,  3158,    -1,    -1,
     402,   403,   404,    -1,   406,   407,   408,   409,   410,   411,
      -1,    -1,    -1,    -1,    -1,   292,    -1,  3109,  3110,   421,
    3181,  1032,    -1,  2912,    -1,  1566,    -1,  2722,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   314,    -1,   316,
      -1,    -1,    -1,    -1,   321,    -1,  2583,    -1,   343,    -1,
      -1,    77,  3134,    -1,  1065,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   343,   344,    -1,   364,
      -1,    97,    -1,    -1,    -1,    -1,   102,    -1,    -1,   356,
      -1,    -1,    -1,    -1,   361,  3167,    -1,   382,    -1,    -1,
    1631,    -1,    -1,    -1,   371,    -1,    -1,    -1,    -1,    -1,
    1032,    -1,   379,    -1,    -1,    -1,    -1,  1648,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   413,    -1,
      -1,   416,   417,   418,    -1,    -1,    -1,    -1,    -1,    -1,
    1032,    -1,    -1,  1065,    -1,    -1,  1677,    -1,    -1,    -1,
      -1,  1682,  2679,    -1,    -1,    -1,    -1,    -1,  3037,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1065,    -1,    -1,    -1,    -1,    -1,    -1,
    3059,  3060,    -1,   199,  3063,  3064,    -1,   203,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1731,  2886,    -1,  1734,    -1,   221,   222,    -1,    -1,  1740,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   233,    -1,  1750,
    1751,    -1,    -1,  1754,  1755,    82,  1032,  1758,    -1,  1230,
      -1,    -1,    89,  1764,    -1,    -1,    -1,    -1,  1769,    -1,
      -1,    -1,    -1,    -1,   260,    -1,    -1,    -1,  1779,  1780,
    1781,  1782,  1783,  1784,    -1,  1786,  1787,   273,    -1,  1065,
      -1,  1792,  1793,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   128,    -1,    -1,  1805,  1806,  1807,    -1,  1809,  1810,
    1811,  1812,    -1,    -1,  1815,  1816,    -1,  1818,  1819,   146,
     147,    -1,    77,    -1,    -1,    -1,    -1,   154,    -1,    -1,
      -1,   158,    -1,    -1,    -1,    90,    -1,    -1,    -1,    -1,
      -1,    -1,    97,   329,  1845,  1846,    -1,   102,    -1,   176,
      -1,   178,    -1,    -1,  1325,    -1,    -1,  2854,    -1,  1860,
      -1,    -1,    -1,    -1,    -1,    -1,   193,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1879,    -1,
    1351,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1898,    -1,    -1,
      -1,    -1,  1903,    -1,    -1,    -1,   392,    -1,    -1,  1910,
      -1,    -1,    -1,    -1,    -1,    -1,  1387,   403,   404,  1920,
     406,   407,   408,   409,   410,   411,    -1,    -1,    -1,    -1,
    1931,    -1,    -1,  1325,   134,    -1,    -1,    77,    -1,    -1,
      -1,    -1,    -1,  1414,   199,    -1,  1947,    -1,   203,    -1,
      90,    -1,    -1,    -1,    -1,    -1,    -1,    97,    -1,  1351,
      -1,    -1,   102,  1325,    -1,    -1,   221,   222,  1439,    -1,
      -1,   171,    -1,    -1,    -1,    -1,    -1,    -1,   233,    -1,
      -1,    -1,    -1,   183,    -1,    -1,    -1,    -1,   188,  1351,
    2987,    -1,    -1,   193,   194,  1387,   196,    -1,    -1,    -1,
    1471,    -1,   257,    -1,  1475,   260,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   217,   273,    -1,
     275,    -1,  1414,    -1,  2025,  1387,   353,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   234,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    77,  1439,    -1,  1325,
    2051,    -1,  1414,    -1,    -1,    -1,    -1,    -1,    -1,   199,
      -1,    -1,    -1,   203,    -1,    -1,    97,    -1,   268,    -1,
      -1,   102,    -1,    -1,   329,  1351,   276,  1439,    -1,  1471,
      -1,   221,   222,  1475,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2092,    -1,   233,    -1,    -1,  2097,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2108,    -1,  1471,
      -1,  1387,    -1,  1475,  3111,    -1,    -1,   257,    -1,    -1,
     260,    -1,    -1,    -1,  2125,  1596,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,    -1,   275,    -1,   392,  1414,   170,
      -1,    -1,  2143,   343,    -1,    -1,    -1,   402,   403,   404,
      -1,   406,   407,   408,   409,   410,   411,    -1,    -1,  2160,
    2161,    -1,    -1,  1439,   364,    -1,   421,    -1,   199,    -1,
      -1,    -1,   203,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   382,    -1,    -1,    -1,    -1,    -1,    -1,   329,
     221,   222,    -1,    -1,    -1,  1471,    -1,   524,    -1,  1475,
      -1,    -1,   233,  2204,  1596,    -1,    -1,    -1,    77,    -1,
      -1,    -1,    -1,   413,    -1,  2216,   416,   417,   418,    -1,
      -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,    97,   260,
      -1,    -1,    -1,   102,  1596,    -1,    -1,  2238,    -1,    -1,
      -1,    -1,   273,    -1,    -1,    -1,    -1,    -1,    -1,  2250,
    2251,  2252,   392,    -1,   581,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   402,   403,   404,    -1,   406,   407,   408,   409,
     410,   411,    -1,    -1,    -1,    -1,   416,    -1,    -1,    -1,
      -1,  2282,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2293,    -1,    -1,    -1,    -1,    -1,   329,    -1,
      -1,    -1,    -1,    -1,    -1,  1776,    -1,    -1,    -1,  2310,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2319,    -1,
    1596,    -1,    -1,    -1,    -1,    -1,    -1,  2328,    -1,    -1,
     199,    -1,    -1,    -1,   203,    -1,    -1,    -1,    -1,    -1,
    2341,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   221,   222,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   392,    -1,    -1,   233,    -1,  1032,  1838,    -1,    -1,
      -1,    -1,  1843,    -1,    -1,   406,   407,   408,   409,   410,
     411,    -1,    -1,    -1,  1776,    -1,    -1,  1858,   257,    -1,
      -1,   260,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1065,
      -1,    -1,    -1,    -1,   273,    -1,   275,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1776,    -1,    -1,    -1,   745,   746,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2428,    -1,    -1,
      -1,  2432,  2433,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1838,  1918,    -1,   776,
      -1,  1843,    -1,   780,    -1,   782,    -1,   784,    -1,    -1,
     329,    -1,    -1,   790,   791,    -1,  1858,    -1,    -1,    -1,
      -1,    -1,    -1,   800,    -1,    -1,  1838,    -1,    -1,    -1,
      -1,  1843,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2493,  2494,    -1,    -1,  1858,    -1,    -1,    -1,
    1776,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2518,  2519,    -1,
     847,   848,    -1,   392,   851,    -1,  1918,    -1,    -1,    -1,
      -1,    -1,    -1,   402,   403,   404,    -1,   406,   407,   408,
     409,   410,   411,    -1,    -1,    -1,    -1,   416,  2549,  2550,
    2551,  2552,  2553,    -1,    -1,    -1,  1918,    -1,    -1,    -1,
      -1,    -1,  1838,    -1,    -1,    -1,    -1,  1843,    -1,    -1,
    2571,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     907,    -1,  1858,    -1,    -1,    -1,    -1,  2588,    -1,  2590,
      -1,    -1,  2593,    -1,  2595,    -1,   923,   924,    -1,    -1,
      74,  2602,    -1,    77,    -1,    -1,  2607,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    89,    90,    -1,    -1,    -1,
    2621,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,
      -1,    -1,  1918,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   128,    -1,    -1,    -1,    -1,  1325,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   146,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2151,    -1,    -1,    -1,    -1,  1351,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2696,    -1,    -1,  2699,    -1,
      -1,  2172,    -1,  2174,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2713,    -1,    -1,    -1,    -1,  2188,    -1,    -1,
      -1,  1387,    -1,    -1,    -1,  2726,    -1,    -1,  2729,    -1,
    2731,    -1,  2733,  2734,    -1,    -1,    -1,    -1,    -1,  2740,
    2741,  2742,  2213,   217,    -1,    -1,  2747,    -1,  1414,  1076,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2151,
    2231,    -1,    -1,    -1,    -1,    -1,    -1,  1094,    -1,    -1,
    1097,    -1,    -1,  1439,    -1,    -1,    -1,    -1,  1105,    -1,
    2172,    -1,  2174,    -1,    -1,    -1,    -1,    -1,    -1,  2151,
      -1,    -1,    -1,    -1,    -1,  2266,  2188,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1471,  2277,    -1,    -1,  1475,
    2172,  2812,  2174,    -1,  2285,    -1,  2817,    -1,    -1,    -1,
      -1,  2213,    -1,    -1,    -1,    -1,  2188,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   311,    -1,  2231,
      -1,    -1,    -1,    -1,    -1,    -1,  1173,    -1,    -1,    -1,
      -1,  2213,    -1,    -1,    -1,    -1,    -1,  1184,    -1,    -1,
      -1,    -1,    -1,    -1,  2865,    -1,  2867,    -1,  2339,  2231,
      -1,    -1,    -1,   347,  2266,  2151,   350,    -1,  2879,    -1,
    2881,    -1,    -1,  1210,    -1,  2277,    -1,  1214,  1215,  2360,
      -1,    -1,    -1,  2285,    -1,    -1,  2172,    -1,  2174,    -1,
    1227,    -1,    -1,  1230,  2266,  1232,    -1,  1234,    -1,    -1,
      -1,    -1,  2188,    -1,    -1,  2277,  2387,    -1,    -1,    -1,
      -1,    -1,    -1,  2285,    -1,    -1,    -1,    -1,    -1,    -1,
    1596,    -1,  2933,  2934,    -1,    -1,    -1,  2213,  2409,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2947,  2339,    -1,    -1,
    2951,  2952,    -1,    -1,    -1,  2231,    -1,    -1,  1285,    -1,
    1287,    -1,    -1,    77,    -1,    -1,    -1,    -1,  2360,    -1,
      -1,  1298,    -1,    -1,  2975,    -1,    90,  2339,    -1,    -1,
      -1,    -1,    -1,    97,  2985,    -1,    -1,    -1,   102,    -1,
    2266,    -1,    -1,    -1,    -1,  2387,    -1,    -1,  2360,    -1,
      -1,  2277,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2285,
      -1,    -1,    -1,    -1,    -1,    -1,  3017,  2409,    -1,    -1,
      -1,  3022,    -1,    -1,    -1,  2387,    -1,    -1,    -1,    -1,
      -1,  3032,  3033,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2514,    -1,    -1,    -1,  2409,    -1,  3050,
     524,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3062,  1389,  2339,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3080,
      -1,  3082,    -1,    -1,  2360,   199,    -1,    -1,    -1,   203,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3098,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   221,   222,    -1,
    1776,  2387,  2583,  3114,    -1,    -1,    -1,    -1,    -1,   233,
      -1,    -1,  2514,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1457,    -1,    -1,  2409,  3135,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   257,    -1,    -1,   260,    -1,    -1,    -1,
      -1,    -1,  2514,    -1,    -1,  3156,    -1,    -1,    -1,   273,
      -1,   275,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1838,  1500,  1501,    -1,    -1,  1843,    -1,    -1,
      -1,  3182,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2583,  1858,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   679,    -1,    -1,  2679,   683,
      -1,    -1,    -1,   687,    -1,   329,    -1,   691,  1545,    -1,
    1547,  2583,    -1,    -1,  1551,    -1,    -1,    -1,    -1,  1556,
    1557,    -1,    -1,    -1,    -1,    -1,    -1,  1564,  2514,    -1,
      -1,    77,    -1,    -1,   718,    -1,    -1,  1574,    -1,  1576,
      -1,    -1,  1918,    -1,    90,    -1,    -1,    -1,    -1,    -1,
      -1,    97,    -1,    -1,    -1,  1592,   102,  1594,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   750,    -1,   392,   753,
      -1,    -1,    -1,    -1,    -1,   759,    -1,  2679,   402,   403,
     404,    -1,   406,   407,   408,   409,   410,   411,  1625,    -1,
      -1,    -1,   416,    -1,  1631,    -1,    -1,  2583,    -1,    -1,
      -1,    -1,    -1,    -1,  1641,    -1,    -1,  2679,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      77,  1658,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   199,    -1,    -1,    -1,   203,    -1,    -1,
      -1,   845,    -1,   847,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2854,    -1,   221,   222,    -1,    -1,    -1,
      -1,   865,    -1,    -1,    -1,    -1,    -1,   233,  1725,    -1,
      -1,    -1,    -1,  2679,  1731,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1740,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   257,    -1,    -1,   260,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,    -1,   275,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   199,    -1,    -1,    -1,   203,    -1,    -1,    -1,
      -1,    -1,  2854,    -1,    -1,    -1,    -1,  1794,    -1,    -1,
    1797,  1798,    -1,    -1,   221,   222,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2151,   233,    -1,    -1,    -1,
      -1,    -1,  2854,   329,    77,    -1,    -1,    -1,    -1,    -1,
      -1,  1828,    -1,    -1,    -1,    -1,  2172,    90,  2174,    -1,
     257,    -1,    -1,   260,    97,    -1,  2987,  1844,    -1,   102,
      -1,  1848,  2188,    -1,    -1,  1852,   273,    -1,   275,    -1,
      -1,  1005,  1006,  1860,    -1,    -1,  1010,    -1,  1865,    -1,
      -1,    -1,  1016,    -1,    -1,    -1,    -1,  2213,    -1,    -1,
      -1,  1878,    -1,    -1,    -1,    -1,   392,    -1,  1032,    -1,
      -1,    -1,    -1,    -1,    -1,  2231,   402,   403,   404,    -1,
     406,   407,   408,   409,   410,   411,    -1,    -1,  2854,  1906,
     416,  1055,   329,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1065,    -1,    -1,    -1,  2987,    -1,    -1,    -1,    -1,
    2266,    -1,    -1,    -1,  1931,  1932,    -1,    -1,  1935,    -1,
    1937,  2277,    -1,    -1,    -1,    -1,   199,    -1,    -1,  2285,
     203,    -1,    -1,    -1,    -1,  2987,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   221,   222,
    3111,  1968,    84,    -1,    -1,   392,  1120,    -1,    -1,    -1,
     233,    -1,    -1,    95,    -1,   402,   403,   404,    -1,   406,
     407,   408,   409,   410,   411,    -1,    -1,  1032,  1142,   416,
      -1,   113,    -1,  2339,   257,    -1,    -1,   260,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   129,    -1,   131,
     273,    -1,  1166,  1167,  2360,  1169,  1170,  1171,    -1,  3170,
    1065,    -1,    -1,   145,    -1,    -1,    -1,    -1,    -1,   151,
      -1,  2987,    77,    -1,    -1,  1189,    -1,    -1,    -1,  3111,
     162,  2387,    -1,    -1,    -1,    90,    -1,    -1,    -1,    -1,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,    -1,    -1,
    1214,  1215,    -1,  2409,    -1,    -1,   329,    -1,    -1,  3111,
     192,    -1,   194,    -1,    -1,    -1,  1230,    -1,    -1,    -1,
    2087,    -1,    -1,  2090,   206,  2092,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3170,    -1,
    1254,    -1,    -1,  1257,  1258,   227,    -1,    -1,    -1,    -1,
      -1,  1265,  1266,  1267,    -1,   237,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3170,   392,
      -1,  1285,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   402,
     403,   404,    -1,   406,   407,   408,   409,   410,   411,    -1,
      -1,   273,    -1,   275,   199,  3111,    -1,    -1,   203,    -1,
      -1,    -1,  1316,    -1,    -1,    -1,    -1,    -1,  2514,  1323,
     292,  1325,  2179,    -1,  1328,    -1,   221,   222,  2185,  2186,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   233,    -1,
      -1,    -1,    -1,    -1,   316,    -1,    -1,  1351,    -1,   321,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2214,  2215,    -1,
      -1,    -1,   257,    -1,  3170,   260,  2223,    -1,    -1,    -1,
      -1,   343,   344,   345,  2231,   347,    -1,    -1,   273,  2236,
     275,  2238,    -1,  1387,   356,    -1,    -1,  2583,   360,   361,
      -1,  2248,  2249,   365,  1398,    -1,    -1,    -1,    -1,   371,
      -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,    -1,    -1,
    1414,    -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,
      -1,    -1,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
    1325,    -1,    -1,    -1,   329,  1439,  2293,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1351,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1469,    -1,  1471,    -1,    -1,
      -1,  1475,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2679,    -1,    -1,    -1,    -1,    -1,  2346,
      -1,    -1,  1387,    -1,    -1,  2352,    -1,   392,    -1,    -1,
      -1,    -1,  1506,    -1,    -1,    -1,    -1,   402,   403,   404,
      -1,   406,   407,   408,   409,   410,   411,    -1,    -1,  1414,
      -1,   416,    -1,    -1,    -1,    -1,   199,    -1,  1532,  1533,
     203,    -1,    -1,    -1,    -1,    -1,  1540,    -1,    -1,  1543,
    1544,  2398,    -1,    -1,  1439,    -1,    -1,    -1,   221,   222,
      -1,    -1,  1556,    -1,    -1,    -1,    -1,    -1,    -1,  1563,
     233,    90,    -1,  1567,  1568,  1569,    -1,  1571,    -1,    -1,
      -1,    -1,    -1,    -1,  1578,  1579,  1471,    -1,    -1,    -1,
    1475,    -1,    -1,   112,   257,    -1,    -1,   260,    -1,    -1,
      -1,    -1,  1596,  1597,  1598,    -1,  1600,  1601,    -1,    -1,
     273,  1605,   275,    -1,    -1,  1609,    -1,    -1,  1612,  1613,
    1614,  1615,  1616,  1617,  1618,  1619,  1620,    -1,  1622,    -1,
      -1,    -1,  1626,    -1,    -1,    -1,  1630,     3,    -1,    -1,
      -1,    -1,    -1,     9,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    19,    -1,    -1,    22,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   329,    33,  2854,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1675,  2529,  2530,    -1,    51,    52,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2544,   217,    -1,
      -1,    -1,  2549,  2550,  2551,  2552,  2553,    -1,    -1,    -1,
      -1,  1596,    78,    -1,  1708,    -1,  1710,    -1,    -1,    -1,
      -1,    87,    88,    89,    -1,    -1,    -1,    -1,    -1,   392,
      -1,    -1,    -1,    -1,    -1,   101,    -1,    -1,    -1,   402,
     403,   404,    -1,   406,   407,   408,   409,   410,   411,    -1,
      -1,   414,    -1,   119,  2601,   121,   122,    -1,    -1,  1753,
     126,   127,    -1,    -1,    -1,    -1,    -1,   133,   134,  2616,
      -1,    -1,    -1,  1767,    -1,    -1,    -1,    -1,    -1,   145,
      -1,   147,  1776,    -1,   150,    -1,    -1,    -1,    -1,    -1,
     156,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   164,    -1,
      -1,  2987,    -1,   169,    -1,    -1,    -1,    -1,   174,    -1,
     176,    -1,    -1,    -1,   180,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1837,  1838,    -1,    -1,   213,    -1,  1843,
      -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1856,    -1,  1858,    -1,    -1,    -1,    -1,   235,
     236,    -1,    -1,   239,    97,  2722,  2723,    -1,    -1,   102,
     246,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1776,    -1,   259,    -1,    -1,    -1,    -1,    -1,  2746,
      -1,    -1,    -1,    -1,  2751,    -1,  2753,  2754,    -1,    -1,
      -1,  2758,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   288,    -1,  1918,  3111,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   299,    -1,   301,    -1,    -1,    -1,   305,
      -1,    -1,    -1,   309,    77,   311,    -1,   170,    -1,   315,
      -1,    -1,    -1,  1838,   320,  1949,    -1,    90,  1843,   325,
    2807,    94,   328,    -1,    97,    -1,  2813,    -1,   334,   102,
    2817,    -1,    -1,  1858,    -1,  1969,   199,    -1,    -1,    -1,
     203,    -1,    -1,    -1,  3170,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   359,    -1,   361,    -1,    -1,   221,   222,
      -1,   367,    -1,   369,  1998,  1999,  2000,   373,    -1,  2003,
     233,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2015,  2016,  2017,  2018,    -1,   159,    -1,    -1,    -1,
    2024,    -1,    -1,  1918,    -1,    -1,    -1,   260,    -1,    -1,
      -1,  2035,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   415,
     273,    -1,  2046,  2047,    -1,  2049,    -1,    -1,    -1,  2053,
      -1,    -1,    -1,    -1,    -1,  2912,   199,    -1,    -1,    -1,
     203,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2076,    -1,  2078,  2079,    -1,    -1,   221,   222,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     233,    -1,    -1,    -1,    -1,    -1,   329,    -1,    -1,  2103,
      -1,    -1,    -1,    -1,    -1,    -1,  2110,  2111,  2112,    -1,
      -1,    -1,    -1,    -1,   257,    -1,    -1,   260,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     273,    -1,   275,    -1,    -1,  2139,    -1,    -1,    -1,    82,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2151,    -1,    -1,
     679,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   687,   392,
      -1,    -1,   691,    -1,    -1,    -1,    -1,    -1,  2172,    -1,
    2174,    -1,    -1,   406,   407,   408,   409,   410,   411,    -1,
    3037,    -1,    -1,    -1,  2188,    -1,   329,    -1,    -1,   718,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3059,    -1,    -1,    -1,  3063,    -1,    -1,  2213,
      -1,    -1,    -1,    -1,    -1,   158,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   753,    -1,  2230,  2231,    -1,   372,
     759,    -1,    -1,   176,    -1,   178,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,
      -1,    -1,  3109,  3110,    -1,    -1,  2151,  3114,    -1,   402,
     403,   404,  2266,   406,   407,   408,   409,   410,   411,    -1,
      -1,    -1,    -1,  2277,    -1,    -1,    -1,  2172,    -1,  2174,
      -1,  2285,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2188,    -1,    -1,    -1,    -1,    -1,  3156,
      -1,    -1,    -1,    -1,  2308,    -1,    -1,    -1,    -1,  1032,
      -1,    -1,    -1,    -1,    -1,    -1,   845,    -1,  2213,    -1,
      -1,    -1,    -1,    -1,    -1,  3182,  2330,    -1,    -1,    -1,
      -1,    -1,  2336,    -1,    -1,  2339,  2231,    -1,    -1,    -1,
      -1,    -1,  1065,    -1,  2348,    -1,  2350,    -1,    -1,    -1,
    2354,    -1,    -1,    -1,    -1,    -1,  2360,  2361,    -1,    -1,
    2364,  2365,  2366,  2367,  2368,  2369,  2370,  2371,  2372,  2373,
      -1,  2266,    -1,    -1,  2378,  2379,    -1,    -1,    -1,    -1,
      -1,    -1,  2277,  2387,    -1,    -1,    -1,    -1,  2392,    -1,
    2285,    -1,    -1,    -1,    -1,  2399,  2400,  2401,    -1,  2403,
      -1,    -1,    -1,    -1,    -1,  2409,  2410,    77,    -1,    -1,
      -1,  2415,    -1,    -1,  2418,    -1,    -1,    -1,    -1,    -1,
      90,    -1,    -1,  2427,    -1,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,    77,    -1,
      -1,    -1,    -1,    -1,  2339,    -1,    -1,    -1,    -1,    -1,
      -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,    -1,  2360,  2470,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1005,  1006,    -1,    -1,
      -1,  1010,    -1,    -1,    -1,    -1,    -1,  1016,    -1,    -1,
      -1,    -1,  2387,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1032,    -1,    -1,    -1,    -1,    -1,    -1,
    2514,    -1,    -1,    -1,  2409,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1055,    -1,    -1,   199,
      -1,    -1,    -1,   203,    -1,    -1,  1065,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   183,    -1,    -1,    -1,    -1,   188,
      -1,   221,   222,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     199,    -1,    -1,   233,   203,    -1,    -1,    -1,  2572,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2583,
      -1,    -1,   221,   222,    -1,    -1,    -1,   257,    -1,    -1,
     260,  1120,    -1,    -1,   233,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1325,   273,    -1,   275,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1142,    -1,    -1,    -1,    -1,   257,  2514,
    2624,   260,    -1,    -1,    -1,    -1,    -1,    -1,  1351,    -1,
    2634,    -1,    -1,    -1,   273,    -1,   275,  1166,  1167,    -1,
    1169,  1170,  1171,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   329,
    1189,    -1,    -1,    -1,  1387,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2679,    -1,    -1,    -1,  2683,
    2684,  2685,    -1,    -1,  2688,    -1,    -1,    -1,  2583,    -1,
     329,  1414,    -1,    -1,    -1,    -1,    -1,    -1,  2702,    -1,
      -1,    -1,  2706,    -1,    -1,    -1,  2710,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1439,    -1,    -1,    -1,
      -1,    -1,   392,    -1,    -1,  1254,    -1,    -1,  1257,  1258,
      -1,    -1,   402,   403,   404,    -1,   406,   407,   408,   409,
     410,   411,    -1,    -1,    -1,    -1,   416,    -1,  1471,    -1,
      -1,    -1,  1475,   392,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   402,   403,   404,    -1,   406,   407,   408,
     409,   410,   411,    -1,  2778,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2679,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1325,    -1,    -1,  1328,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2812,    -1,
      -1,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1351,    -1,    90,    -1,    -1,    93,    -1,    -1,
      -1,    97,    -1,    -1,  2838,    -1,   102,   780,    -1,   782,
      -1,   784,    -1,  2847,    -1,  2849,    -1,   790,   791,    -1,
    2854,    -1,    -1,    -1,  2858,    -1,    -1,    -1,  1387,    -1,
      -1,    -1,    -1,    -1,    -1,  2869,    -1,    -1,    -1,  1398,
    2874,    -1,    -1,  1596,  2878,    -1,    -1,    -1,  2882,  2883,
      -1,    -1,    -1,    -1,    -1,  1414,    -1,    -1,  2892,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2909,    -1,    -1,   851,    -1,
    1439,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2923,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   199,    -1,    -1,    -1,   203,    -1,    -1,
    1469,    -1,  1471,    -1,  2948,    -1,  1475,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   221,   222,    -1,    -1,  2854,
      -1,    -1,    -1,    -1,   907,  2969,    -1,   233,    -1,    -1,
      -1,    -1,    -1,    77,  2978,    -1,    -1,  1506,  2982,    -1,
     923,   924,    -1,  2987,    -1,    -1,    90,    -1,    -1,    93,
      -1,   257,    -1,    97,   260,    -1,    -1,   940,   102,    -1,
      -1,    -1,    -1,  1532,  1533,    -1,    -1,   273,    -1,   275,
      -1,  1540,    -1,    -1,  1543,  1544,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3032,    -1,
      -1,    -1,    -1,    -1,  1563,    -1,    -1,    -1,  1567,  1568,
    1569,    -1,  1571,    -1,    -1,    -1,    -1,    -1,    -1,  1578,
    1579,    -1,  3056,  1776,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   329,    -1,    -1,    -1,  1596,  1597,  1598,
      -1,  1600,  1601,    -1,    -1,    -1,  1605,    -1,    -1,    -1,
    1609,    -1,    -1,  1612,  1613,  1614,  1615,  1616,  1617,  1618,
    1619,  1620,  2987,  1622,    -1,   199,    -1,  1626,    -1,   203,
      -1,  1630,    -1,    -1,    -1,    -1,    -1,  3111,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1838,    -1,   221,   222,    -1,
    1843,    -1,    -1,    -1,    -1,    -1,   392,    77,    -1,   233,
    3134,    -1,    -1,  1076,    -1,  1858,   402,   403,   404,    -1,
     406,   407,   408,   409,   410,   411,    -1,    97,    -1,    -1,
      -1,    -1,   102,   257,    -1,    -1,   260,    -1,    -1,    -1,
      -1,    -1,    -1,  3167,    -1,    -1,  3170,    -1,    -1,   273,
      -1,   275,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1918,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3111,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1753,   329,    -1,    -1,    -1,    -1,
    1173,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1767,    -1,
      -1,  1184,    -1,    -1,    -1,    -1,    -1,  1776,    -1,   199,
      -1,    -1,    -1,   203,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   221,   222,    -1,    -1,  3170,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   233,  1227,    -1,    -1,  1230,   392,  1232,
      -1,  1234,    -1,    -1,    -1,    -1,    -1,    -1,   402,   403,
     404,    -1,   406,   407,   408,   409,   410,   411,  1837,  1838,
     260,    -1,    -1,    -1,  1843,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,    -1,    -1,    -1,  1856,    -1,  1858,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    92,    -1,
      -1,    -1,    -1,    -1,  1287,    -1,    -1,    -1,   102,    -1,
      -1,    -1,    -1,    -1,    -1,  1298,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1032,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   329,
      -1,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,  1918,
      -1,    -1,    -1,   147,    -1,    -1,   150,    -1,    -1,    -1,
     154,    -1,  1065,    -1,   158,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    77,    -1,    -1,    -1,    -1,    -1,    -1,
    1949,    -1,    -1,    -1,   178,    -1,    90,    -1,  2151,    -1,
      -1,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   193,
    1969,    -1,   392,    -1,    -1,    -1,  1389,    -1,    -1,  2172,
      -1,  2174,   402,   403,   404,    -1,   406,   407,   408,   409,
     410,   411,    -1,    -1,    -1,  2188,    -1,    -1,    -1,  1998,
    1999,  2000,    -1,    -1,  2003,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2015,  2016,  2017,  2018,
    2213,    -1,    -1,    -1,    -1,  2024,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2035,    -1,  2231,    -1,
      -1,    -1,    -1,    -1,  1457,    -1,    -1,  2046,  2047,    -1,
    2049,    -1,    -1,    -1,  2053,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   199,    -1,    -1,    -1,   203,
      -1,    -1,    -1,  2266,    -1,    -1,    -1,  2076,    -1,  2078,
    2079,    -1,    -1,    -1,  2277,    -1,    -1,   221,   222,    -1,
      -1,    -1,  2285,    -1,    -1,    -1,    -1,    -1,    -1,   233,
      -1,    -1,    -1,    -1,  2103,    -1,    -1,    -1,    -1,    -1,
      -1,  2110,  2111,  2112,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   257,    -1,    -1,   260,    -1,    -1,   353,
      -1,    -1,  1545,    -1,  1547,    -1,    -1,    -1,  1551,   273,
    2139,   275,    -1,  1556,  1557,    -1,  2339,    -1,    -1,    -1,
      -1,  1564,  2151,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1574,    -1,  1576,    -1,    -1,    -1,  2360,    -1,    -1,
      -1,    -1,    -1,  2172,    -1,  2174,    -1,    -1,    -1,  1592,
      -1,  1594,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2188,
      -1,    -1,  1325,    -1,  2387,   329,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2213,    -1,  2409,    -1,  1351,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2230,  2231,    -1,    -1,    -1,    -1,    -1,   372,    -1,
      -1,    -1,    -1,    -1,    -1,  1658,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1387,    -1,    -1,    -1,   392,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2266,   402,   403,
     404,    -1,   406,   407,   408,   409,   410,   411,  2277,    -1,
      -1,  1414,    -1,    -1,    -1,    -1,  2285,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1439,    -1,    -1,  2308,
      -1,    -1,  1725,    -1,    -1,    -1,    -1,    -1,  1731,    -1,
      -1,  2514,    -1,    77,    -1,    -1,    -1,    -1,  1741,    -1,
      -1,  2330,    -1,    -1,    -1,    -1,    -1,  2336,  1471,    -1,
    2339,    -1,  1475,    97,   568,   569,    -1,    -1,   102,  2348,
      -1,  2350,    -1,    -1,    -1,  2354,    -1,    -1,    -1,    -1,
      -1,  2360,  2361,    -1,    -1,  2364,  2365,  2366,  2367,  2368,
    2369,  2370,  2371,  2372,  2373,    -1,    -1,    -1,    -1,  2378,
    2379,  1794,    -1,    -1,  1797,  1798,    -1,    -1,  2387,    -1,
    2583,    -1,    -1,  2392,    -1,    -1,    -1,    -1,    -1,    -1,
    2399,  2400,  2401,    -1,  2403,    -1,    -1,    -1,    -1,    -1,
    2409,  2410,    -1,    77,    -1,  1828,  2415,    -1,    -1,  2418,
      -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,  2427,    -1,
      -1,  1844,    -1,    97,    -1,  1848,    -1,    -1,   102,  1852,
      -1,    -1,    -1,    -1,    -1,   199,    -1,  1860,    -1,   203,
      -1,    -1,  1865,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1596,    -1,  1878,    -1,   221,   222,    -1,
     694,  2470,   696,    -1,    -1,   699,   700,    -1,    -1,   233,
      -1,    -1,    -1,    -1,    -1,    -1,  2679,    -1,    -1,    -1,
      -1,    -1,    -1,  1906,    -1,   719,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   257,    -1,    -1,   260,   731,    -1,    -1,
     734,    -1,    -1,    -1,    -1,  2514,    -1,    -1,    -1,   273,
      -1,   745,   746,    -1,    -1,    -1,    -1,    -1,    -1,   687,
     754,    -1,    -1,   691,    -1,   199,    -1,    -1,    -1,   203,
     764,    -1,    -1,    -1,   768,   769,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1968,    -1,   221,   222,    -1,
     718,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   792,   233,
     794,    -1,    -1,  2572,    -1,   329,   800,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2583,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   257,    -1,   753,   260,    -1,    -1,    -1,
      -1,   759,    -1,    -1,   828,    -1,    -1,    -1,    -1,   273,
      -1,   275,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     284,    -1,    -1,    -1,   848,  2624,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2634,    -1,    -1,   392,    -1,
      -1,    -1,    -1,  1776,    -1,    -1,    -1,    -1,   402,   403,
     404,    -1,   406,   407,   408,   409,   410,   411,    -1,    -1,
      -1,  2854,    -1,    -1,    -1,   329,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2090,    -1,  2092,
    2679,    -1,    -1,    -1,  2683,  2684,  2685,   845,    -1,  2688,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2702,    -1,  1838,    -1,  2706,    -1,    -1,
    1843,  2710,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   948,  1858,    -1,   951,   392,    -1,
     954,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   402,   403,
     404,    -1,   406,   407,   408,   409,   410,   411,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2179,    -1,    -1,    -1,
      -1,    -1,  2185,  2186,    -1,    -1,    -1,    -1,    -1,  2778,
      -1,    -1,    -1,    -1,    -1,  1918,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2987,    -1,  1020,    -1,    -1,    -1,
    1024,  2214,  2215,    -1,  1028,    -1,    -1,    -1,    -1,  1033,
    2223,    -1,    -1,  2812,    -1,    -1,    -1,    -1,  2231,    -1,
      -1,    -1,    -1,  2236,    -1,  2238,    -1,    -1,    -1,    -1,
      -1,    -1,  1056,    -1,    -1,  2248,  2249,    -1,    -1,  2838,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1005,  2847,    -1,
    2849,    -1,  1010,    -1,    -1,  2854,    -1,    -1,  1016,  2858,
      -1,  1032,    -1,    -1,    -1,    -1,    -1,  1091,    -1,    -1,
    2869,    77,    -1,    -1,  1032,  2874,    -1,    -1,    -1,  2878,
    1104,    -1,    -1,  2882,  2883,    -1,    -1,    -1,    -1,    -1,
      -1,    97,    -1,  2892,  1065,    -1,   102,  1055,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    77,  1065,    -1,    -1,
    2909,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3111,    90,
      -1,    -1,    93,    -1,  2923,    -1,    97,    -1,    -1,    -1,
      -1,   102,    -1,  2346,    -1,    -1,    -1,    -1,    -1,  2352,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2948,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1120,    -1,   170,    -1,    -1,    -1,    -1,    -1,
    2969,    -1,    -1,    -1,    -1,    -1,    -1,  3170,    -1,  2978,
      -1,    -1,    -1,  2982,  1142,  2398,    -1,    -1,  2987,    -1,
      -1,    -1,    -1,   199,    -1,    -1,    -1,   203,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1166,  1167,
      -1,  1169,  1170,  1171,    -1,   221,   222,    -1,  2151,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   233,   199,    -1,
      -1,  1189,   203,  3032,    -1,    -1,    -1,    -1,    -1,  2172,
      -1,  2174,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     221,   222,    -1,    -1,   260,  2188,    -1,  3056,    -1,    -1,
      -1,    -1,   233,    -1,    -1,    -1,    -1,   273,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2213,    -1,    -1,    -1,    -1,    -1,   257,    -1,    -1,   260,
      -1,    -1,    -1,    -1,  1318,    -1,  1254,    -1,  2231,  1257,
    1258,    -1,   273,    -1,   275,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3111,    -1,    -1,    -1,  2529,  2530,    -1,    -1,
      -1,    -1,    -1,   329,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2544,    -1,  2266,    -1,  3134,  2549,  2550,  2551,  2552,
    2553,    -1,    -1,    -1,  2277,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2285,    -1,  1325,    -1,    -1,    -1,   329,    -1,
      -1,    -1,    -1,    -1,    77,    -1,    -1,  1325,  3167,    -1,
      -1,  3170,    -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,
    1351,    -1,    -1,    -1,    97,    -1,   392,    -1,  2601,   102,
      -1,    -1,    -1,  1351,    -1,    -1,    -1,    -1,    -1,    -1,
     406,   407,   408,   409,   410,   411,  2339,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1387,    -1,    -1,    -1,
      -1,   392,  1446,    -1,    -1,    -1,    -1,  2360,    -1,  1387,
      -1,   402,   403,   404,    -1,   406,   407,   408,   409,   410,
     411,    -1,    -1,  1414,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2387,    -1,  1414,    -1,    -1,    -1,
      -1,    -1,    -1,  1487,    -1,    -1,    -1,    -1,  1439,    -1,
      -1,    -1,    -1,    -1,    -1,   188,  2409,    -1,    -1,    -1,
      -1,  1439,    -1,    -1,    -1,    -1,   199,    -1,    -1,    -1,
     203,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1471,    -1,    -1,    -1,  1475,    -1,    -1,    -1,   221,   222,
    2723,  1469,    -1,  1471,    -1,    -1,    -1,  1475,    -1,    -1,
     233,    -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,
      -1,    -1,    -1,  2746,    -1,    -1,    -1,    -1,  2751,    90,
    2753,  2754,    -1,    -1,   257,  2758,    97,   260,  1506,    -1,
      -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     273,    -1,   275,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1532,  1533,    -1,    -1,    -1,    -1,
      -1,  2514,  1540,    -1,    -1,  1543,  1544,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2807,    -1,    -1,    -1,    -1,    -1,
    2813,    -1,    -1,    -1,  2817,  1563,    -1,  1631,    -1,  1567,
    1568,  1569,    -1,  1571,    -1,    -1,   329,    -1,    -1,    -1,
    1578,  1579,    -1,    -1,  1648,  1596,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1596,  1597,
      -1,    -1,  1600,  1601,    -1,    -1,    -1,  1605,   199,    -1,
    2583,  1609,   203,    -1,  1612,  1613,  1614,  1615,  1616,  1617,
    1618,  1619,  1620,    -1,  1622,    -1,    -1,    -1,  1626,    -1,
     221,   222,  1630,    -1,    -1,    -1,    -1,    -1,    -1,   392,
      -1,    -1,   233,    -1,    -1,    -1,    -1,    -1,    77,   402,
     403,   404,    -1,   406,   407,   408,   409,   410,   411,  2912,
      -1,    90,    -1,    -1,    -1,    -1,   257,    -1,    97,   260,
      -1,    -1,    -1,   102,    -1,    -1,  1740,    -1,    -1,    -1,
      -1,    -1,   273,    -1,   275,    -1,    -1,  1751,    -1,    -1,
      -1,    -1,    -1,    -1,  1758,    -1,    -1,    -1,    -1,    -1,
    1764,    -1,    -1,    -1,    -1,    -1,  2679,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1783,
    1784,    -1,  1786,    -1,    -1,    -1,    -1,    -1,    -1,  1793,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   329,    -1,
      -1,    -1,    77,  1807,    -1,  1809,    -1,  1811,  1812,    -1,
      -1,    -1,  1816,    -1,    -1,    -1,    -1,   348,    -1,    -1,
      -1,    -1,    97,    -1,    -1,  1776,    -1,   102,    -1,  1767,
     199,    -1,    -1,    -1,   203,    -1,    -1,    -1,  1776,    -1,
      -1,    -1,    -1,    -1,  3037,    -1,    -1,    -1,    -1,    77,
      -1,    -1,   221,   222,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   392,    -1,    -1,   233,    -1,  3059,    -1,    -1,    97,
    3063,   402,   403,   404,   102,   406,   407,   408,   409,   410,
     411,    -1,    -1,    -1,    -1,    -1,    -1,  1838,   257,    -1,
      -1,   260,  1843,    -1,    -1,   170,    -1,    -1,    -1,  1837,
    1838,    -1,    -1,    -1,   273,  1843,   275,  1858,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3109,  3110,  1856,    -1,
    1858,    -1,    -1,    -1,   199,    -1,    -1,  1931,   203,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2854,   170,    -1,    -1,    -1,   221,   222,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   233,    -1,
     329,    -1,    -1,    -1,    -1,    -1,    -1,  1918,    -1,    -1,
      -1,   199,    -1,    -1,    -1,   203,    -1,    -1,    -1,    -1,
    1918,    -1,    -1,    -1,    -1,   260,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   221,   222,    -1,    -1,    -1,   273,    -1,
      -1,    -1,    -1,    -1,    -1,   233,    -1,    -1,    -1,    -1,
      -1,  1949,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   392,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1969,   260,   402,   403,   404,    -1,   406,   407,   408,
     409,   410,   411,    -1,    -1,   273,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   329,    -1,    -1,    -1,    -1,    -1,
    1998,  1999,  2000,    -1,    -1,  2003,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2987,    -1,    -1,  2015,  2016,  2017,
    2018,    -1,    -1,    -1,    -1,    -1,  2024,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2035,    -1,    -1,
      -1,   329,    -1,    -1,    -1,    -1,    -1,    -1,  2046,  2047,
      -1,  2049,    -1,    -1,    -1,  2053,    -1,   392,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   406,   407,   408,   409,   410,   411,    -1,  2076,    -1,
    2078,  2079,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2161,    -1,    -1,
      -1,    -1,    -1,    -1,   392,  2103,    77,    -1,    -1,    -1,
      -1,    -1,  2110,  2111,  2112,    -1,    -1,    -1,   406,   407,
     408,   409,   410,   411,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,  3111,    -1,
    2151,  2139,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2151,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2172,    -1,  2174,   687,    -1,    -1,    -1,   691,    -1,
      -1,    -1,    -1,    -1,  2172,    -1,  2174,  2188,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2250,  2251,  2252,    -1,
    2188,    -1,    -1,    -1,    -1,   718,    -1,  3170,    -1,   170,
      -1,    -1,  2213,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2213,    -1,    -1,  2282,    -1,
    2231,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   199,  2293,
     753,    -1,   203,  2231,    -1,    -1,   759,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     221,   222,    -1,    -1,    -1,  2266,    -1,    -1,    -1,    -1,
      -1,    -1,   233,    -1,    -1,    -1,  2277,    -1,  2266,    -1,
      -1,    -1,    -1,    -1,  2285,    -1,    -1,    -1,    -1,  2277,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2285,    -1,   260,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2308,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   845,    -1,    -1,    -1,    -1,    -1,  2339,    -1,
      -1,    -1,  2330,    -1,    -1,    -1,    -1,    -1,  2336,    -1,
      -1,  2339,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2360,
    2348,    -1,  2350,    -1,    -1,    -1,  2354,    -1,   329,    -1,
      -1,    -1,  2360,  2361,    -1,    -1,  2364,  2365,  2366,  2367,
    2368,  2369,  2370,  2371,  2372,  2373,  2387,    -1,    -1,    -1,
    2378,  2379,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2387,
      -1,    -1,    -1,    -1,  2392,    -1,    -1,    -1,  2409,    -1,
      -1,  2399,  2400,  2401,    -1,  2403,    -1,    -1,    -1,    -1,
      -1,  2409,  2410,    -1,    -1,    -1,    -1,  2415,    -1,    -1,
    2418,   392,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2427,
      -1,    -1,    -1,    -1,    -1,   406,   407,   408,   409,   410,
     411,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2518,  2519,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2470,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1005,    -1,    -1,    -1,    -1,  1010,    -1,    -1,
      -1,    -1,    -1,  1016,   845,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2514,    -1,    -1,    -1,  2571,    -1,  1032,
      -1,    -1,    -1,    -1,    -1,    -1,  2514,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1055,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1065,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2583,    -1,  2572,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2583,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1120,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1142,
      -1,    -1,    -1,    -1,    -1,    -1,  2624,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2634,    -1,    -1,    -1,
      -1,    -1,    -1,  1166,  1167,    -1,  1169,  1170,  1171,    -1,
      -1,    -1,    -1,    -1,  1005,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1189,    -1,  2679,    -1,
    2734,    -1,    -1,    -1,    -1,    -1,    -1,  2741,    -1,    -1,
      -1,  2679,    -1,    -1,    -1,  2683,  2684,  2685,    -1,    -1,
    2688,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2702,    -1,    -1,    -1,  2706,    -1,
      -1,    -1,  2710,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1254,    -1,    -1,  1257,  1258,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1120,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2778,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1142,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1325,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2812,  1166,  1167,    -1,  1169,  1170,
    1171,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1351,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1189,    -1,
    2838,    -1,    -1,  2854,    -1,    -1,    -1,    -1,    -1,  2847,
      -1,  2849,    -1,    -1,    -1,    -1,  2854,    -1,    -1,    -1,
    2858,    -1,    -1,    -1,  1387,    -1,    -1,    -1,    -1,    -1,
      -1,  2869,    -1,    -1,    -1,    -1,  2874,    -1,    -1,    -1,
    2878,    -1,    -1,    -1,  2882,  2883,    -1,    -1,    -1,    -1,
      -1,  1414,    -1,    -1,  2892,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1254,    -1,    -1,  1257,  1258,    -1,    -1,
      -1,  2909,    -1,    -1,    -1,    -1,  1439,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2923,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1469,    -1,  1471,    -1,
    2948,    -1,  1475,  3017,    -1,    -1,    -1,    -1,  3022,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2969,    -1,    -1,    -1,    -1,  2987,    -1,    -1,    -1,
    2978,    -1,    -1,  1506,  2982,    -1,    -1,    -1,    -1,  2987,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1532,
    1533,    -1,    -1,    -1,    -1,    -1,  3080,  1540,    -1,    -1,
    1543,  1544,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3032,    -1,    -1,    -1,    -1,    -1,
    1563,    -1,    -1,    -1,  1567,  1568,  1569,    -1,  1571,    -1,
      -1,    -1,    -1,    -1,    -1,  1578,  1579,    -1,  3056,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1596,  1597,    -1,    -1,  1600,  1601,    -1,
      -1,    -1,  1605,    -1,    -1,    -1,  1609,    -1,    -1,  1612,
    1613,  1614,  1615,  1616,  1617,  1618,  1619,  1620,    -1,  1622,
    3111,    -1,    -1,  1626,    -1,    -1,    -1,  1630,    -1,    -1,
      -1,    -1,    -1,  3111,    -1,    -1,    -1,    -1,  1469,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3134,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3170,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3167,
      -1,    -1,  3170,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1540,
      -1,    -1,    -1,  1544,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1563,    -1,    -1,    -1,  1567,    -1,    -1,    -1,
    1571,    -1,    -1,    -1,    -1,    -1,    -1,  1578,  1579,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1767,    -1,  1597,    -1,    -1,    -1,
    1601,    -1,    -1,  1776,  1605,    -1,    -1,    -1,  1609,    -1,
      -1,  1612,  1613,  1614,  1615,  1616,  1617,  1618,  1619,  1620,
      -1,  1622,    -1,    -1,    -1,  1626,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1837,  1838,    -1,    -1,    -1,    -1,
    1843,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1856,    -1,  1858,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1918,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1767,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1949,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1969,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1998,  1999,  2000,    -1,    -1,
    2003,    -1,    -1,    -1,    -1,    -1,  1837,    -1,    -1,    -1,
      -1,    -1,  2015,  2016,  2017,  2018,    -1,    -1,    -1,    -1,
      -1,  2024,    -1,    -1,    -1,  1856,    -1,    -1,    -1,    -1,
      -1,    -1,  2035,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2046,  2047,    -1,  2049,    -1,    -1,    -1,
    2053,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2076,    -1,  2078,  2079,    -1,    -1,    -1,
      -1,    -1,    -1,  1185,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2103,    -1,    -1,    -1,    -1,    -1,    -1,  2110,  2111,  2112,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1949,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2139,    -1,  1969,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2151,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2172,
      -1,  2174,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2015,  2188,  2017,  2018,    -1,    -1,
      -1,    -1,    -1,  2024,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2213,    -1,    -1,    -1,    -1,    -1,  2047,    -1,  2049,    -1,
      -1,    -1,  2053,    -1,    -1,    -1,    -1,    -1,  2231,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2266,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2103,    -1,  2277,    -1,    -1,    -1,  1380,  2110,
    2111,  2112,  2285,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2308,    -1,    -1,  2139,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2330,    -1,    -1,
      -1,    -1,    -1,  2336,    -1,    -1,  2339,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2348,    -1,  2350,    -1,    -1,
      -1,  2354,    -1,    -1,    -1,    -1,    -1,  2360,  2361,    -1,
      -1,  2364,  2365,  2366,  2367,  2368,  2369,  2370,  2371,  2372,
    2373,    -1,    -1,    -1,    -1,  2378,  2379,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2387,    -1,    -1,    -1,    -1,  2392,
      -1,    -1,    -1,    -1,    -1,    -1,  2399,  2400,  2401,    -1,
    2403,    -1,    -1,    -1,    -1,    -1,  2409,  2410,    -1,    -1,
      -1,    -1,  2415,    -1,    -1,  2418,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2427,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1538,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1562,    -1,    -1,    -1,    -1,    -1,  1568,  2470,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1583,  1584,  1585,  1586,    -1,  1588,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1600,  2330,
      -1,    -1,    -1,    -1,    -1,  2336,    -1,    -1,    -1,    -1,
      -1,  2514,    -1,    -1,    -1,    -1,    -1,  2348,    -1,  2350,
      -1,    -1,  1624,  2354,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2378,  2379,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2572,
    2401,    -1,  2403,    -1,    -1,    -1,    -1,    -1,    -1,  2410,
    2583,    -1,    -1,    -1,  2415,    -1,    -1,  2418,  1690,    -1,
      -1,    -1,    -1,    -1,  1696,    -1,  1698,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2624,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2634,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2470,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2679,    -1,    -1,    -1,
    2683,  2684,  2685,    -1,    -1,  2688,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2702,
      -1,    -1,    -1,  2706,    -1,    -1,    -1,  2710,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2778,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2624,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2634,    -1,    -1,    -1,    -1,    -1,  2812,
      -1,    -1,    -1,    -1,  1916,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2838,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2847,    -1,  2849,    -1,    -1,    -1,
      -1,  2854,    -1,  2684,  2685,  2858,    -1,  2688,    -1,    -1,
      -1,  1963,    -1,    -1,    -1,    -1,  2869,    -1,    -1,    -1,
    1972,  2874,  1974,    -1,    -1,  2878,    -1,    -1,    -1,  2882,
    2883,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2892,
      -1,  1993,    -1,    -1,  1996,    -1,  1998,  1999,  2000,  2001,
      -1,  2003,    -1,    -1,    -1,  2007,  2909,    -1,    -1,    -1,
      -1,    -1,  2014,    -1,    -1,    -1,    -1,  2019,    -1,    -1,
    2923,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2030,    -1,
      -1,  2033,  2034,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2045,  2046,  2948,    -1,  2778,    -1,    -1,
    2052,    -1,  2054,  2055,  2056,  2057,  2058,  2059,  2060,  2061,
    2062,  2063,    -1,    -1,    -1,    -1,  2969,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2978,    -1,    -1,    -1,  2982,
      -1,    -1,    -1,    -1,  2987,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2838,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2858,    -1,  3032,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2146,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2883,  3056,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2892,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2909,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3111,  2211,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2948,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2232,  3134,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2978,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3167,    -1,    -1,  3170,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2315,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3056,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2335,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2357,  2358,  2359,    -1,  2361,
      -1,    -1,  2364,  2365,  2366,  2367,  2368,  2369,  2370,  2371,
    2372,  2373,    -1,  2375,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2395,    -1,    -1,    -1,    -1,  2400,    -1,
      -1,    -1,    -1,     5,    -1,    -1,    -1,    -1,    -1,  2411,
    2412,    -1,  2414,    -1,    -1,  2417,    -1,    -1,    20,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    29,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    40,    41,
      -1,    -1,    -1,    -1,    46,    -1,    48,    49,    -1,    -1,
      -1,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     5,    -1,    -1,    -1,  2491,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      20,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    29,
      -1,    -1,    -1,   115,    -1,    -1,    -1,    -1,    -1,    -1,
      40,    41,    -1,    -1,    -1,    -1,    -1,    -1,    48,    49,
      -1,    -1,    -1,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2572,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     182,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   115,   198,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   215,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2631,
      -1,    -1,    -1,  2635,    -1,    -1,    -1,    -1,  2640,  2641,
     242,  2643,    -1,   245,  2646,    -1,    -1,    -1,  2650,  2651,
    2652,  2653,  2654,  2655,  2656,  2657,  2658,  2659,  2660,  2661,
     262,    -1,   182,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2675,  2676,    -1,  2678,    -1,   198,    -1,
    2682,  2683,    -1,    -1,  2686,    -1,    -1,  2689,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   215,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   318,    -1,    -1,    -1,
      -1,    -1,   242,    -1,    -1,   245,  2728,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   262,    -1,    -1,    -1,    -1,    -1,    -1,   351,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   364,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   376,    -1,    -1,    -1,  2780,    -1,
      -1,    -1,    -1,    -1,    -1,   387,    -1,    -1,   390,   391,
      -1,   393,    -1,   395,    -1,    -1,    -1,   399,   318,   401,
     402,    -1,    -1,    -1,   406,   407,   408,   409,   410,    -1,
      -1,   413,   414,   415,   416,    -1,   418,   419,   420,   421,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,    -1,    -1,    -1,    -1,    -1,    -1,  2840,    -1,
      -1,    -1,    -1,    -1,   364,  2847,    -1,  2849,    -1,    -1,
      -1,    -1,    -1,  2855,  2856,  2857,   376,  2859,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   387,    -1,    -1,
     390,   391,    -1,   393,    -1,    -1,    -1,    -1,    -1,   399,
      -1,   401,   402,    -1,    -1,    -1,   406,   407,   408,   409,
     410,    -1,    -1,   413,   414,   415,    -1,    -1,    -1,   419,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2927,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2968,  2969,  2970,    -1,
      -1,  2973,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2989,    -1,    -1,
      -1,  2993,    -1,    -1,    -1,    -1,  2998,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3030,    -1,
       5,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,  3045,    19,    -1,    21,  3049,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      -1,    36,    37,    38,    39,    40,    41,    -1,    43,    44,
      45,    -1,    47,    48,    49,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,    -1,   107,   108,   109,    -1,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,    -1,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,    -1,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,    -1,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,    -1,   381,   382,   383,   384,
     385,   386,   387,   388,    -1,   390,    -1,    -1,   393,    -1,
      -1,     6,     7,     8,    -1,    -1,    11,    12,    -1,    14,
      15,    16,    -1,    -1,    -1,    20,    21,    -1,    23,    24,
      25,    26,    27,    28,   419,    30,    31,    32,    -1,    -1,
      -1,    36,    37,    38,    39,    -1,    41,    -1,    43,    44,
      45,    -1,    47,    48,    49,    50,    -1,    -1,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    98,    -1,    -1,    -1,   102,   103,   104,
     105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   116,    -1,    -1,    -1,    -1,    -1,    -1,   123,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,
      -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   148,   149,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     175,    -1,    -1,   178,    -1,    -1,    -1,   182,    -1,    -1,
      -1,    -1,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   199,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   209,   210,    -1,    -1,    -1,    -1,
      -1,   216,    -1,   218,    -1,    -1,   221,   222,    -1,   224,
      -1,    -1,    -1,    -1,    -1,    -1,   231,    -1,   233,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   248,   249,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,    -1,    -1,   260,    -1,    -1,   263,   264,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   277,   278,   279,   280,    -1,    -1,    -1,    -1,
     285,   286,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   296,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   310,    -1,   312,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   326,    -1,    -1,   329,    -1,   331,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   341,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   349,   350,    -1,    -1,    -1,    -1,
     355,    -1,   357,    -1,    -1,    -1,    -1,    -1,    -1,   364,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   376,    -1,   378,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     6,     7,     8,    -1,   390,    11,    12,   393,    14,
      15,    16,    -1,    -1,    -1,    20,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    -1,    -1,
      -1,    36,    37,    38,    39,   420,    41,    -1,    43,    44,
      45,    -1,    47,    48,    49,    50,    -1,    -1,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    98,    -1,    -1,    -1,   102,   103,   104,
     105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   116,    -1,    -1,    -1,    -1,    -1,    -1,   123,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,
      -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   148,   149,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     175,    -1,    -1,   178,    -1,    -1,    -1,   182,    -1,    -1,
      -1,    -1,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   199,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   209,   210,    -1,    -1,    -1,    -1,
      -1,   216,    -1,   218,    -1,    -1,   221,   222,    -1,   224,
      -1,    -1,    -1,    -1,    -1,    -1,   231,    -1,   233,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   248,   249,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,    -1,    -1,   260,    -1,    -1,   263,   264,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   277,   278,   279,   280,    -1,    -1,    -1,    -1,
     285,   286,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   296,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   310,    -1,   312,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   326,    -1,    -1,   329,    -1,   331,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   341,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   349,   350,    -1,    -1,    -1,    -1,
     355,    -1,   357,    -1,    -1,    -1,    -1,    -1,    -1,   364,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   376,    -1,   378,    -1,    -1,    -1,    -1,     3,    -1,
      -1,     6,     7,     8,     9,   390,    11,    12,   393,    14,
      15,    16,    17,    -1,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      -1,    36,    37,    38,    39,   420,    41,    -1,    43,    44,
      45,    -1,    47,    48,    49,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    87,    88,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    97,    98,    -1,    -1,   101,   102,   103,   104,
     105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   116,    -1,    -1,   119,    -1,   121,   122,   123,    -1,
      -1,   126,   127,    -1,    -1,    -1,    -1,   132,   133,   134,
      -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     145,    -1,   147,   148,   149,   150,    -1,    -1,    -1,    -1,
      -1,   156,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   164,
      -1,    -1,    -1,    -1,   169,    -1,    -1,    -1,    -1,   174,
     175,   176,    -1,   178,    -1,   180,    -1,   182,    -1,    -1,
      -1,    -1,   187,    -1,   189,    -1,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,   199,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   209,   210,    -1,    -1,   213,    -1,
      -1,   216,    -1,   218,    -1,    -1,   221,   222,    -1,   224,
      -1,    -1,    -1,    -1,    -1,    -1,   231,    -1,   233,    -1,
     235,   236,    -1,    -1,   239,    -1,    -1,    -1,    -1,    -1,
      -1,   246,    -1,   248,   249,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,    -1,   259,   260,    -1,    -1,   263,   264,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   277,   278,   279,   280,    -1,    -1,    -1,    -1,
     285,   286,    -1,   288,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   296,    -1,    -1,   299,    -1,   301,    -1,    -1,    -1,
     305,    -1,    -1,    -1,   309,   310,   311,   312,    -1,    -1,
     315,    -1,    -1,    -1,    -1,   320,    -1,    -1,    -1,    -1,
     325,   326,    -1,   328,   329,    -1,   331,    -1,    -1,   334,
      -1,    -1,    -1,    -1,    -1,    -1,   341,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   349,   350,    -1,    -1,    -1,    -1,
     355,    -1,   357,    -1,   359,    -1,   361,    -1,    -1,   364,
      -1,    -1,   367,    -1,   369,    -1,    -1,    -1,   373,    -1,
      -1,   376,    -1,   378,    -1,    -1,    -1,    -1,    -1,    -1,
       5,     6,     7,     8,     9,   390,    11,    12,   393,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
     415,    36,    37,    38,    39,    40,    41,    -1,    43,    44,
      45,    -1,    47,    48,    49,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,   108,   109,    -1,   111,   112,   113,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,   152,    -1,   154,
      -1,   156,   157,   158,    -1,   160,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,   170,    -1,   172,   173,   174,
     175,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
      -1,   186,   187,    -1,   189,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,   199,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,   209,   210,    -1,   212,   213,   214,
     215,   216,    -1,   218,    -1,    -1,   221,   222,   223,   224,
     225,   226,   227,   228,   229,    -1,   231,   232,   233,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,   274,
      -1,    -1,   277,   278,   279,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,    -1,
     365,   366,   367,   368,   369,   370,   371,    -1,   373,   374,
     375,   376,   377,   378,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,   391,   392,   393,   394,
      -1,    -1,   397,   398,   399,   400,   401,    -1,    -1,    -1,
      -1,   406,   407,   408,    -1,   410,   411,    -1,    -1,    -1,
     415,   416,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    -1,    36,    37,    38,    39,    40,    41,    -1,
      43,    44,    45,    -1,    47,    48,    49,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,
      -1,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,   108,   109,    -1,   111,   112,
     113,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,   175,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,    -1,   186,   187,    -1,   189,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,   209,   210,    -1,   212,
     213,   214,   215,   216,    -1,   218,    -1,    -1,   221,   222,
     223,   224,   225,   226,   227,   228,   229,    -1,   231,   232,
     233,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,    -1,    -1,   269,   270,    -1,    -1,
     273,   274,    -1,    -1,   277,   278,   279,   280,   281,   282,
     283,    -1,   285,   286,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,    -1,    -1,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,    -1,   365,   366,   367,   368,   369,   370,   371,    -1,
     373,   374,   375,   376,   377,   378,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,   391,   392,
     393,   394,    -1,    -1,   397,   398,   399,   400,   401,    -1,
      -1,    -1,    -1,   406,   407,    -1,    -1,   410,   411,    -1,
      -1,    -1,   415,   416,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,
      -1,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,
     212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,
      -1,   223,    -1,   225,   226,   227,   228,   229,    -1,    -1,
     232,    -1,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,    -1,   250,    -1,
     252,   253,   254,   255,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,    -1,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,    -1,   321,
     322,   323,    -1,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,    -1,   359,   360,   361,
     362,   363,    -1,    -1,   366,   367,   368,   369,   370,    -1,
     372,   373,   374,   375,   376,   377,    -1,   379,     5,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,    -1,
      -1,   393,    -1,    20,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   413,    -1,    40,    41,   417,    -1,    -1,    -1,    -1,
      -1,    48,    49,    -1,    -1,    -1,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      -1,    -1,    -1,    -1,    -1,     5,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      20,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    29,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   115,    -1,
      40,    41,    -1,    -1,    -1,    -1,    -1,    -1,    48,    49,
      -1,    -1,    -1,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   182,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   115,    -1,    -1,    -1,    -1,
      -1,   198,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   215,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   242,    -1,    -1,   245,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   182,    -1,    -1,   262,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   198,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   215,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   318,   242,    -1,    -1,   245,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   262,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   364,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   376,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     387,    -1,    -1,   390,   391,    -1,   393,    -1,   318,    -1,
      -1,    -1,   399,    -1,   401,   402,    -1,    -1,    -1,   406,
     407,   408,   409,   410,    -1,    -1,   413,   414,   415,   416,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   364,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   376,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   387,    -1,    -1,
     390,   391,    -1,   393,    -1,    -1,    -1,    -1,    -1,   399,
      -1,   401,   402,    -1,    -1,    -1,   406,   407,   408,   409,
     410,    -1,    -1,   413,   414,   415,   416,     5,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    -1,    36,    37,
      38,    39,    40,    41,    -1,    43,    44,    45,    -1,    47,
      48,    49,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,    -1,   111,   112,   113,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,   170,    -1,   172,   173,   174,   175,   176,    -1,
     178,   179,   180,   181,   182,    -1,   184,    -1,   186,   187,
     188,   189,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,   199,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,   209,   210,    -1,   212,   213,   214,   215,   216,    -1,
     218,    -1,    -1,   221,   222,   223,   224,   225,   226,   227,
     228,   229,   230,   231,   232,   233,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,    -1,
      -1,   269,   270,    -1,    -1,   273,   274,    -1,    -1,   277,
     278,   279,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,    -1,   365,   366,   367,
     368,   369,   370,   371,    -1,   373,   374,   375,   376,   377,
     378,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,   391,   392,   393,   394,    -1,    -1,   397,
     398,   399,   400,   401,    -1,    -1,    -1,    -1,   406,   407,
      -1,    -1,   410,   411,    -1,    -1,    -1,   415,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    -1,    36,
      37,    38,    39,    40,    41,    -1,    43,    44,    45,    -1,
      47,    48,    49,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
      -1,   108,   109,    -1,   111,   112,   113,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,   179,   180,   181,   182,    -1,   184,    -1,   186,
     187,    -1,   189,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,   199,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,   209,   210,    -1,   212,   213,   214,   215,   216,
      -1,   218,    -1,    -1,   221,   222,   223,   224,   225,   226,
     227,   228,   229,    -1,   231,   232,   233,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
      -1,    -1,   269,   270,    -1,    -1,   273,   274,    -1,    -1,
     277,   278,   279,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,   358,   359,   360,   361,   362,   363,    -1,   365,   366,
     367,   368,   369,   370,   371,    -1,   373,   374,   375,   376,
     377,   378,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,   391,   392,   393,   394,    -1,    -1,
     397,   398,   399,   400,   401,    -1,    -1,    -1,    -1,   406,
     407,   408,    -1,   410,   411,    -1,    -1,    -1,   415,     5,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    -1,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      -1,    47,    48,    49,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,    -1,   108,   109,    -1,   111,   112,   113,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,   179,   180,   181,   182,    -1,   184,    -1,
     186,   187,    -1,   189,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,   199,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,   209,   210,    -1,   212,   213,   214,   215,
     216,    -1,   218,    -1,    -1,   221,   222,   223,   224,   225,
     226,   227,   228,   229,    -1,   231,   232,   233,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,    -1,    -1,   269,   270,    -1,    -1,   273,   274,    -1,
      -1,   277,   278,   279,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,   320,   321,   322,   323,   324,   325,
     326,   327,   328,   329,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,    -1,   365,
     366,   367,   368,   369,   370,   371,    -1,   373,   374,   375,
     376,   377,   378,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,   391,   392,   393,   394,    -1,
      -1,   397,   398,   399,   400,   401,    -1,    -1,    -1,    -1,
     406,   407,    -1,    -1,   410,   411,    -1,    -1,    -1,   415,
       5,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      -1,    36,    37,    38,    39,    40,    41,    -1,    43,    44,
      45,    -1,    47,    48,    49,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,   108,   109,    -1,   111,   112,   113,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,   170,    -1,   172,   173,   174,
     175,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
      -1,   186,   187,    -1,   189,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,   199,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,   209,   210,    -1,   212,   213,   214,
     215,   216,    -1,   218,    -1,    -1,   221,   222,   223,   224,
     225,   226,   227,   228,   229,    -1,   231,   232,   233,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,   274,
      -1,    -1,   277,   278,   279,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,    -1,
     365,   366,   367,   368,   369,   370,   371,    -1,   373,   374,
     375,   376,   377,   378,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,   391,   392,   393,   394,
      -1,    -1,   397,   398,   399,   400,   401,    -1,    -1,    -1,
      -1,   406,   407,    -1,    -1,   410,   411,    -1,    -1,    -1,
     415,     5,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    -1,    36,    37,    38,    39,    40,    41,    -1,    43,
      44,    45,    -1,    47,    48,    49,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,
      -1,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,    -1,   108,   109,    -1,   111,   112,   113,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,   175,   176,    -1,   178,   179,   180,   181,   182,    -1,
     184,    -1,   186,   187,    -1,   189,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,   199,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,   209,   210,    -1,   212,   213,
     214,   215,   216,    -1,   218,    -1,    -1,   221,   222,   223,
     224,   225,   226,   227,   228,   229,    -1,   231,   232,   233,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,
     274,    -1,    -1,   277,   278,   279,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
      -1,   365,   366,   367,   368,   369,   370,   371,    -1,   373,
     374,   375,   376,   377,   378,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,   391,   392,   393,
     394,    -1,    -1,   397,   398,   399,   400,   401,    -1,    -1,
      -1,    -1,   406,   407,    -1,    -1,   410,   411,    -1,   413,
      -1,   415,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    -1,    36,    37,    38,    39,    40,    41,    -1,
      43,    44,    45,    -1,    47,    48,    49,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,
      -1,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,   108,   109,    -1,   111,   112,
     113,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,   175,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,    -1,   186,   187,    -1,   189,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,   209,   210,    -1,   212,
     213,   214,   215,   216,    -1,   218,    -1,    -1,   221,   222,
     223,   224,   225,   226,   227,   228,   229,    -1,   231,   232,
     233,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,    -1,    -1,   269,   270,    -1,    -1,
     273,   274,    -1,    -1,   277,   278,   279,   280,   281,   282,
     283,    -1,   285,   286,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,    -1,    -1,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,    -1,   365,   366,   367,   368,   369,   370,   371,    -1,
     373,   374,   375,   376,   377,   378,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,   391,   392,
     393,   394,    -1,    -1,   397,   398,   399,   400,   401,    -1,
      -1,    -1,    -1,   406,   407,    -1,    -1,   410,   411,    -1,
      -1,    -1,   415,     5,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    -1,    36,    37,    38,    39,    40,    41,
      -1,    43,    44,    45,    -1,    47,    48,    49,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      92,    -1,    -1,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,    -1,   108,   109,    -1,   111,
     112,   113,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,   175,   176,    -1,   178,   179,   180,   181,
     182,    -1,   184,    -1,   186,   187,   188,   189,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,   199,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,   209,   210,    -1,
     212,   213,   214,   215,   216,    -1,   218,    -1,    -1,   221,
     222,   223,   224,   225,   226,   227,   228,   229,    -1,   231,
     232,   233,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,    -1,    -1,   269,   270,    -1,
      -1,   273,   274,    -1,    -1,   277,   278,   279,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,    -1,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,    -1,   365,   366,   367,   368,   369,   370,   371,
      -1,   373,   374,   375,   376,   377,   378,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,   391,
     392,   393,   394,    -1,    -1,   397,   398,   399,   400,   401,
      -1,    -1,    -1,    -1,   406,   407,    -1,    -1,   410,   411,
      -1,    -1,    -1,   415,     5,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    -1,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    -1,    47,    48,    49,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    92,    -1,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,    -1,   108,   109,    -1,
     111,   112,   113,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,   175,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,    -1,   186,   187,    -1,   189,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,   199,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,   209,   210,
      -1,   212,   213,   214,   215,   216,    -1,   218,    -1,    -1,
     221,   222,   223,   224,   225,   226,   227,   228,   229,    -1,
     231,   232,   233,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,    -1,    -1,   269,   270,
      -1,    -1,   273,   274,    -1,    -1,   277,   278,   279,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,   358,   359,   360,
     361,   362,   363,    -1,   365,   366,   367,   368,   369,   370,
     371,    -1,   373,   374,   375,   376,   377,   378,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
     391,   392,   393,   394,    -1,    -1,   397,   398,   399,   400,
     401,    -1,    -1,    -1,    -1,   406,   407,    -1,    -1,   410,
     411,    -1,    -1,    -1,   415,     5,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    -1,    36,    37,    38,    39,
      40,    41,    -1,    43,    44,    45,    -1,    47,    48,    49,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    92,    -1,    -1,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,   108,   109,
      -1,   111,   112,   113,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,   175,   176,    -1,   178,   179,
     180,   181,   182,    -1,   184,    -1,   186,   187,    -1,   189,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,   199,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,   209,
     210,    -1,   212,   213,   214,   215,   216,    -1,   218,    -1,
      -1,   221,   222,   223,   224,   225,   226,   227,   228,   229,
      -1,   231,   232,   233,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,    -1,    -1,   269,
     270,    -1,    -1,   273,   274,    -1,    -1,   277,   278,   279,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,    -1,   365,   366,   367,   368,   369,
     370,   371,    -1,   373,   374,   375,   376,   377,   378,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,   391,   392,   393,   394,    -1,    -1,   397,   398,   399,
     400,   401,    -1,    -1,    -1,    -1,   406,   407,    -1,    -1,
     410,   411,    -1,    -1,    -1,   415,     5,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    -1,    36,    37,    38,
      39,    40,    41,    -1,    43,    44,    45,    -1,    47,    48,
      49,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    92,    -1,    -1,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,    -1,   108,
     109,    -1,   111,   112,   113,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,    -1,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,    -1,   172,   173,   174,   175,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,    -1,   186,   187,    -1,
     189,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
     199,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
     209,   210,    -1,   212,   213,   214,   215,   216,    -1,   218,
      -1,    -1,   221,   222,   223,   224,   225,   226,   227,   228,
     229,    -1,   231,   232,   233,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,    -1,   258,
     259,   260,   261,   262,   263,   264,   265,   266,    -1,    -1,
     269,   270,    -1,    -1,   273,   274,    -1,    -1,   277,   278,
     279,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,    -1,    -1,   366,   367,   368,
     369,   370,   371,    -1,   373,   374,   375,   376,   377,   378,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,   391,   392,   393,   394,    -1,    -1,   397,   398,
     399,   400,   401,    -1,    -1,    -1,    -1,    -1,   407,    -1,
      -1,   410,   411,    -1,    -1,    -1,   415,     5,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    -1,    36,    37,
      38,    39,    40,    41,    -1,    43,    44,    45,    -1,    47,
      48,    49,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,    97,
      98,    99,   100,   101,    -1,   103,   104,   105,   106,    -1,
     108,   109,    -1,   111,   112,   113,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,    -1,    -1,   172,   173,   174,   175,   176,    -1,
     178,   179,   180,   181,   182,    -1,   184,    -1,   186,   187,
      -1,   189,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,    -1,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,   209,   210,    -1,   212,   213,   214,   215,   216,    -1,
     218,    -1,    -1,   221,   222,   223,   224,   225,   226,   227,
     228,   229,    -1,   231,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,    -1,
     258,   259,   260,   261,   262,   263,   264,   265,   266,    -1,
      -1,   269,   270,    -1,    -1,   273,   274,    -1,    -1,   277,
     278,   279,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,    -1,   365,   366,   367,
     368,   369,   370,   371,    -1,   373,   374,   375,   376,   377,
     378,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,   391,   392,   393,   394,    -1,    -1,   397,
     398,   399,   400,   401,    -1,    -1,    -1,    -1,   406,   407,
      -1,    -1,   410,   411,    -1,    -1,    -1,   415,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    -1,    36,
      37,    38,    39,    40,    41,    -1,    43,    44,    45,    -1,
      47,    48,    49,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
      -1,   108,   109,    -1,   111,   112,   113,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,   179,   180,   181,   182,    -1,   184,    -1,   186,
     187,    -1,   189,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,   199,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,   209,   210,    -1,   212,   213,   214,   215,   216,
      -1,   218,    -1,    -1,   221,   222,   223,   224,   225,   226,
     227,   228,   229,    -1,   231,   232,   233,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
      -1,   258,   259,   260,   261,   262,   263,   264,   265,   266,
      -1,    -1,   269,   270,    -1,    -1,   273,   274,    -1,    -1,
     277,   278,   279,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,   358,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,   371,    -1,   373,   374,   375,   376,
     377,   378,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,   391,    -1,   393,   394,    -1,    -1,
     397,   398,   399,   400,   401,     5,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,   415,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    -1,    36,    37,    38,    39,
      40,    41,    -1,    43,    44,    45,    -1,    47,    48,    49,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    92,    -1,    -1,    95,    96,    97,    98,    99,
     100,   101,    -1,   103,   104,   105,   106,    -1,   108,   109,
      -1,   111,   112,   113,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
      -1,    -1,   172,   173,   174,   175,   176,    -1,   178,   179,
     180,   181,   182,    -1,   184,    -1,   186,   187,    -1,   189,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,   209,
     210,    -1,   212,   213,   214,   215,   216,    -1,   218,    -1,
      -1,   221,   222,   223,   224,   225,   226,   227,   228,   229,
      -1,   231,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,    -1,   258,   259,
     260,   261,   262,   263,   264,   265,   266,    -1,    -1,   269,
     270,    -1,    -1,    -1,   274,    -1,    -1,   277,   278,   279,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,    -1,    -1,   366,   367,   368,   369,
     370,   371,    -1,   373,   374,   375,   376,   377,   378,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,   391,    -1,   393,   394,    -1,    -1,   397,   398,   399,
     400,   401,    -1,    -1,    -1,    -1,    -1,   407,    -1,    -1,
     410,   411,    -1,    -1,    -1,   415,     5,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    -1,    36,    37,    38,
      39,    40,    41,    -1,    43,    44,    45,    -1,    47,    48,
      49,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    -1,
      -1,    -1,    91,    92,    -1,    -1,    95,    96,    97,    98,
      99,   100,   101,    -1,   103,   104,   105,   106,    -1,   108,
     109,    -1,   111,   112,   113,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,    -1,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,    -1,    -1,   172,   173,   174,   175,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,    -1,   186,   187,    -1,
     189,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
      -1,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
     209,   210,    -1,   212,   213,   214,   215,   216,    -1,   218,
      -1,    -1,    -1,    -1,   223,   224,   225,   226,   227,   228,
     229,    -1,   231,   232,    -1,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,    -1,   258,
     259,    -1,   261,   262,   263,   264,   265,   266,    -1,    -1,
     269,   270,    -1,    -1,    -1,   274,    -1,    -1,   277,   278,
     279,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,    -1,   365,   366,   367,   368,
     369,   370,   371,    -1,   373,   374,   375,   376,   377,   378,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,   391,    -1,   393,   394,    -1,    -1,   397,   398,
     399,   400,   401,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   411,    -1,    -1,    -1,   415,     5,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    -1,    36,    37,
      38,    39,    40,    41,    -1,    43,    44,    45,    -1,    47,
      48,    49,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      -1,    -1,    -1,    91,    92,    -1,    -1,    95,    96,    97,
      98,    99,   100,   101,    -1,   103,   104,   105,   106,    -1,
     108,   109,    -1,   111,   112,   113,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,    -1,    -1,   172,   173,   174,   175,   176,    -1,
     178,   179,   180,   181,   182,    -1,   184,    -1,   186,   187,
      -1,   189,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,    -1,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,   209,   210,    -1,   212,   213,   214,   215,   216,    -1,
     218,    -1,    -1,    -1,    -1,   223,   224,   225,   226,   227,
     228,   229,    -1,   231,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,    -1,
     258,   259,    -1,   261,   262,   263,   264,   265,   266,    -1,
      -1,   269,   270,    -1,    -1,    -1,   274,    -1,    -1,   277,
     278,   279,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,    -1,   365,   366,   367,
     368,   369,   370,   371,    -1,   373,   374,   375,   376,   377,
     378,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,   391,    -1,   393,   394,    -1,    -1,   397,
     398,   399,   400,   401,     5,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,   415,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    -1,    36,    37,    38,    39,    40,
      41,    -1,    43,    44,    45,    -1,    47,    48,    49,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    92,    -1,    -1,    95,    96,    97,    98,    99,   100,
     101,    -1,   103,   104,   105,   106,    -1,   108,   109,    -1,
     111,   112,   113,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,    -1,
      -1,   172,   173,   174,   175,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,    -1,   186,   187,    -1,   189,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,   209,   210,
      -1,   212,   213,   214,   215,   216,    -1,   218,    -1,    -1,
      -1,    -1,   223,   224,   225,   226,   227,   228,   229,    -1,
     231,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,   265,   266,    -1,    -1,   269,   270,
      -1,    -1,    -1,   274,    -1,    -1,   277,   278,   279,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,   324,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,   358,   359,   360,
     361,   362,   363,    -1,    -1,   366,   367,   368,   369,   370,
     371,    -1,   373,   374,   375,   376,   377,   378,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
     391,    -1,   393,   394,    -1,    -1,   397,   398,   399,   400,
     401,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     411,    -1,    -1,    -1,   415,     5,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    -1,    36,    37,    38,    39,
      40,    41,    -1,    43,    44,    45,    -1,    47,    48,    49,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    92,    -1,    -1,    95,    96,    97,    98,    99,
     100,   101,    -1,   103,   104,   105,   106,    -1,   108,   109,
      -1,   111,   112,   113,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
      -1,    -1,   172,   173,   174,   175,   176,    -1,   178,   179,
     180,   181,   182,    -1,   184,    -1,   186,   187,    -1,   189,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,   209,
     210,    -1,   212,   213,   214,   215,   216,    -1,   218,    -1,
      -1,    -1,    -1,   223,   224,   225,   226,   227,   228,   229,
      -1,   231,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,   269,
     270,    -1,    -1,    -1,   274,    -1,    -1,   277,   278,   279,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,    -1,    -1,   366,   367,   368,   369,
     370,   371,    -1,   373,   374,   375,   376,   377,   378,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,   391,    -1,   393,   394,    -1,    -1,   397,   398,   399,
     400,   401,    -1,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,   415,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,
      43,    44,    45,    -1,    47,    -1,    -1,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      93,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,   171,   172,
     173,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
     183,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,   212,
     213,   214,    -1,   216,   217,   218,    -1,    -1,    -1,    -1,
     223,    -1,   225,   226,   227,   228,   229,    -1,    -1,   232,
      -1,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,    -1,   252,
     253,   254,   255,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,   265,   266,    -1,   268,   269,    -1,    -1,    -1,
     273,   274,    -1,   276,   277,    -1,    -1,   280,   281,   282,
     283,    -1,   285,   286,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,    -1,   311,   312,
     313,   314,   315,   316,   317,   318,    -1,    -1,   321,   322,
     323,    -1,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,   355,   356,   357,    -1,   359,   360,   361,   362,
     363,   364,    -1,   366,   367,   368,   369,   370,    -1,    -1,
     373,   374,   375,   376,   377,    -1,   379,    -1,    -1,     5,
     383,   384,   385,   386,   387,   388,    -1,   390,    -1,    -1,
     393,    -1,    -1,    -1,    20,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    29,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   416,    40,    41,    -1,    -1,    -1,    -1,
      -1,    -1,    48,    49,    -1,    -1,    -1,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   115,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   182,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   198,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   215,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   242,    -1,    -1,   245,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   262,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   318,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   364,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     376,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   387,    -1,    -1,   390,   391,    -1,   393,    -1,    -1,
      -1,    -1,    -1,   399,    -1,   401,   402,    -1,    -1,    -1,
     406,   407,   408,   409,   410,    -1,    -1,   413,   414,   415,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,   113,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,
     186,   187,    -1,   189,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,   199,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,   209,   210,    -1,   212,   213,   214,    -1,
     216,    -1,   218,    -1,    -1,   221,   222,   223,   224,   225,
     226,   227,   228,   229,    -1,   231,   232,   233,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,    -1,   258,   259,   260,   261,    -1,   263,   264,   265,
     266,    -1,    -1,   269,   270,    -1,   272,   273,   274,    -1,
      -1,   277,   278,   279,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,   320,   321,   322,   323,   324,   325,
     326,   327,   328,   329,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,    -1,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,   371,    -1,   373,   374,   375,
     376,   377,   378,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,    -1,    -1,   393,    -1,    -1,
      -1,    -1,    -1,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,   415,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,
      43,    44,    45,    -1,    47,    -1,    -1,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
     113,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
      -1,   184,    -1,   186,   187,    -1,   189,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,   209,   210,    -1,   212,
     213,   214,    -1,   216,    -1,   218,    -1,    -1,   221,   222,
     223,   224,   225,   226,   227,   228,   229,    -1,   231,   232,
     233,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,    -1,   258,   259,   260,   261,    -1,
     263,   264,   265,   266,    -1,    -1,   269,   270,    -1,   272,
     273,   274,    -1,    -1,   277,   278,   279,   280,   281,   282,
     283,    -1,   285,   286,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,    -1,    -1,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,   355,   356,   357,    -1,   359,   360,   361,   362,
     363,    -1,    -1,   366,   367,   368,   369,   370,   371,    -1,
     373,   374,   375,   376,   377,   378,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,    -1,    -1,
     393,    -1,    -1,    -1,    -1,    -1,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,   415,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,   113,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,   186,   187,    -1,   189,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,   199,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,   209,
     210,    -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,
      -1,   221,   222,   223,   224,   225,   226,   227,   228,   229,
      -1,   231,   232,   233,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,    -1,   258,   259,
     260,   261,    -1,   263,   264,   265,   266,    -1,    -1,   269,
     270,    -1,    -1,   273,   274,    -1,    -1,   277,   278,   279,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,    -1,   359,
     360,   361,   362,   363,    -1,    -1,   366,   367,   368,   369,
     370,   371,    -1,   373,   374,   375,   376,   377,   378,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,    -1,    -1,   393,    -1,    -1,    -1,    -1,    -1,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,   415,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    -1,    36,
      37,    38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,
      47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,   186,
      -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,    -1,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,
      -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,    -1,   250,    -1,   252,   253,   254,   255,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,   265,   266,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,
     277,    -1,    -1,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,    -1,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,    -1,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,    -1,    -1,   373,   374,   375,   376,
     377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,   391,    -1,   393,   394,    -1,    -1,
      -1,    -1,   399,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   414,   415,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    -1,    36,
      37,    38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,
      47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,   186,
      -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,    -1,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,
      -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,    -1,   250,    -1,   252,   253,   254,   255,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,   265,   266,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,
     277,    -1,    -1,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,    -1,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,    -1,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,    -1,    -1,   373,   374,   375,   376,
     377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,   391,    -1,   393,   394,    -1,    -1,
      -1,    -1,   399,    -1,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,   415,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,
      -1,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,
     212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,
      -1,   223,    -1,   225,   226,   227,   228,   229,    -1,    -1,
     232,    -1,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,    -1,   250,   251,
     252,   253,   254,   255,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,   265,   266,    -1,    -1,   269,   270,    -1,
      -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,    -1,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,    -1,   321,
     322,   323,    -1,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,    -1,   359,   360,   361,
     362,   363,    -1,    -1,   366,   367,   368,   369,   370,    -1,
      -1,   373,   374,   375,   376,   377,    -1,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,    -1,
      -1,   393,    -1,    -1,    -1,    -1,    -1,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,   415,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    -1,    36,    37,    38,
      39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,
      -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,   138,
      -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,   148,
     149,   150,    -1,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,    -1,   172,   173,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,
      -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
      -1,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
      -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,   218,
      -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,
     229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
      -1,   250,    -1,   252,   253,   254,   255,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,
     269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,
      -1,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,    -1,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,   320,   321,   322,   323,    -1,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,   355,   356,   357,    -1,
     359,   360,   361,   362,   363,    -1,    -1,   366,   367,   368,
     369,   370,    -1,    -1,   373,   374,   375,   376,   377,    -1,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,    -1,    -1,   393,   394,    -1,    -1,    -1,    -1,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,   415,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,
     186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,    -1,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,
     216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,
     226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,    -1,   252,   253,   254,   255,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,   265,
     266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,
      -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,   320,   321,   322,   323,    -1,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,    -1,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,    -1,    -1,   373,   374,   375,
     376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,    -1,    -1,   393,    -1,    -1,
      -1,    -1,    -1,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,   415,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,
      43,    44,    45,    -1,    47,    -1,    -1,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
      -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,   212,
     213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,
     223,    -1,   225,   226,   227,   228,   229,    -1,    -1,   232,
      -1,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,    -1,   252,
     253,   254,   255,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,
     273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,
     283,    -1,   285,   286,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,    -1,   311,   312,
     313,   314,   315,   316,   317,   318,    -1,    -1,   321,   322,
     323,    -1,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,   355,   356,   357,    -1,   359,   360,   361,   362,
     363,    -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,
     373,   374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,    -1,    -1,
     393,    -1,    -1,    -1,    -1,    -1,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,   415,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,   138,    -1,
      -1,    -1,    -1,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,    -1,
     210,    -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,
      -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,    -1,   252,   253,   254,   255,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,   269,
      -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,    -1,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,    -1,   359,
     360,   361,   362,   363,    -1,    -1,   366,   367,   368,   369,
     370,    -1,    -1,   373,   374,   375,   376,   377,    -1,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,    -1,    -1,   393,    -1,    -1,    -1,    -1,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,   415,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    -1,    36,
      37,    38,    39,    40,    41,    -1,    43,    44,    45,    -1,
      47,    48,    49,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,   106,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,    -1,    -1,    -1,   126,
     127,   128,    -1,   130,   131,    -1,   133,    -1,   135,   136,
      -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,    -1,   176,
      -1,    -1,    -1,   180,   181,   182,    -1,   184,    -1,   186,
      -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,    -1,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,    -1,    -1,    -1,   212,   213,   214,   215,   216,
      -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,    -1,   250,    -1,   252,   253,   254,   255,    -1,
      -1,   258,   259,    -1,   261,    -1,    -1,   264,   265,   266,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,
      -1,    -1,    -1,    -1,   281,   282,   283,    -1,    -1,    -1,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,    -1,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,    -1,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,    -1,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,    -1,   356,
      -1,    -1,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,    -1,    -1,   373,   374,   375,   376,
     377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,   391,   392,   393,   394,    -1,    -1,
      -1,    -1,   399,    -1,   401,   402,   403,   404,    -1,   406,
     407,   408,   409,   410,   411,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    -1,    36,    37,    38,    39,    -1,
      -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,
      -1,    -1,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,    -1,   210,
      -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,
      -1,    -1,   223,    -1,   225,   226,   227,   228,   229,    -1,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
      -1,   252,   253,   254,   255,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,    -1,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,    -1,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,    -1,   359,   360,
     361,   362,   363,    -1,    -1,   366,   367,   368,   369,   370,
      -1,    -1,   373,   374,   375,   376,   377,    -1,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
      -1,   392,   393,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   402,   403,   404,    -1,   406,   407,   408,   409,   410,
     411,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,    44,
      45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,   170,    -1,   172,   173,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,    -1,   184,
      -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,    -1,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,    -1,   210,    -1,   212,   213,   214,
      -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,
     225,   226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,    -1,   252,   253,   254,
     255,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
     265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
      -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,    -1,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
     355,   356,   357,    -1,   359,   360,   361,   362,   363,    -1,
      -1,   366,   367,   368,   369,   370,    -1,    -1,   373,   374,
     375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,    -1,   392,   393,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   402,   403,   404,
      -1,   406,   407,   408,   409,   410,   411,     5,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    -1,    36,    37,
      38,    39,    40,    41,    -1,    43,    44,    45,    -1,    47,
      48,    49,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,    -1,   107,
     108,   109,    -1,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,    -1,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   167,
     168,   169,   170,   171,   172,   173,   174,   175,   176,    -1,
     178,   179,   180,   181,   182,   183,   184,   185,   186,   187,
     188,   189,   190,    -1,   192,   193,   194,   195,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   219,    -1,   221,   222,   223,   224,   225,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,    -1,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,    -1,   381,   382,   383,   384,   385,   386,   387,
     388,    -1,   390,    -1,    -1,   393,    -1,     5,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
     408,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    -1,    36,    37,
      38,    39,    40,    41,    -1,    43,    44,    45,    -1,    47,
      48,    49,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,   106,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,    -1,    -1,    -1,   126,   127,
     128,    -1,   130,   131,    -1,   133,    -1,   135,   136,    -1,
     138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,   170,    -1,   172,   173,   174,    -1,   176,    -1,
      -1,    -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,
      -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,    -1,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,    -1,    -1,    -1,   212,   213,   214,   215,   216,    -1,
     218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,    -1,   252,   253,   254,   255,    -1,    -1,
     258,   259,    -1,   261,    -1,    -1,   264,   265,   266,    -1,
      -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,    -1,
      -1,    -1,    -1,   281,   282,   283,    -1,    -1,    -1,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,    -1,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,    -1,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,    -1,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,    -1,   356,    -1,
      -1,   359,   360,   361,   362,   363,    -1,    -1,   366,   367,
     368,   369,   370,    -1,    -1,   373,   374,   375,   376,   377,
      -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,    -1,    -1,   393,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
     408,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,   138,    -1,
      -1,    -1,    -1,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,    -1,
     210,    -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,
      -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,   251,   252,   253,   254,   255,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,   269,
     270,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,    -1,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,    -1,   359,
     360,   361,   362,   363,    -1,    -1,   366,   367,   368,   369,
     370,    -1,    -1,   373,   374,   375,   376,   377,    -1,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,    -1,    -1,   393,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,   408,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,
      -1,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,   175,   176,    -1,   178,   179,   180,   181,
     182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,
     212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,
      -1,   223,    -1,   225,   226,   227,   228,   229,    -1,    -1,
     232,    -1,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,    -1,   250,    -1,
     252,   253,   254,   255,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,   265,   266,   267,    -1,   269,    -1,   271,
      -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,    -1,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,    -1,   321,
     322,   323,    -1,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,    -1,    -1,   366,   367,   368,   369,   370,    -1,
      -1,   373,   374,   375,   376,   377,    -1,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,   391,
      -1,   393,   394,    -1,    -1,    -1,    -1,   399,    -1,   401,
      -1,     6,     7,     8,     9,   407,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,    44,
      45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,   170,    -1,   172,   173,   174,
     175,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
      -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,    -1,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,    -1,   210,    -1,   212,   213,   214,
      -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,
     225,   226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,    -1,   252,   253,   254,
     255,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
     265,   266,   267,    -1,   269,    -1,   271,    -1,   273,   274,
      -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,    -1,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,    -1,
      -1,   366,   367,   368,   369,   370,    -1,    -1,   373,   374,
     375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,   391,    -1,   393,   394,
      -1,    -1,    -1,    -1,   399,    -1,   401,    -1,     6,     7,
       8,     9,   407,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    -1,    36,    37,
      38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,
      -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
     138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,   170,    -1,   172,   173,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,
     188,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,    -1,   200,   201,   202,   203,   204,   205,   206,   207,
      -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,
     218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,    -1,   252,   253,   254,   255,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,   265,   266,    -1,
      -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,
      -1,    -1,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,   312,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,    -1,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,   355,   356,   357,
      -1,   359,   360,   361,   362,   363,    -1,    -1,   366,   367,
     368,   369,   370,    -1,    -1,   373,   374,   375,   376,   377,
      -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,    -1,    -1,   393,   394,     6,     7,     8,
       9,   399,    11,    12,    -1,    14,    15,    16,    17,   407,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    -1,    36,    37,    38,
      39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,
      -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,   138,
      -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,   148,
     149,   150,    -1,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,    -1,   172,   173,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,
      -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
      -1,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
      -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,   218,
      -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,
     229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
      -1,   250,    -1,   252,   253,   254,   255,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,
     269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,
      -1,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,    -1,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,    -1,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,   355,   356,   357,    -1,
     359,   360,   361,   362,   363,    -1,    -1,   366,   367,   368,
     369,   370,    -1,    -1,   373,   374,   375,   376,   377,    -1,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,    -1,    -1,   393,   394,     6,     7,     8,     9,
     399,    11,    12,    -1,    14,    15,    16,    17,   407,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,   138,    -1,
      -1,    -1,    -1,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,    -1,
     210,    -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,
      -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,    -1,   252,   253,   254,   255,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,   269,
      -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,    -1,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,   351,   352,    -1,   354,   355,   356,   357,    -1,   359,
     360,   361,   362,   363,    -1,    -1,   366,   367,   368,   369,
     370,    -1,    -1,   373,   374,   375,   376,   377,    -1,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,    -1,    -1,   393,   394,     6,     7,     8,     9,    -1,
      11,    12,   402,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    -1,    36,    37,    38,    39,    -1,
      -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,
      -1,    -1,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,    -1,   210,
      -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,
      -1,    -1,   223,    -1,   225,   226,   227,   228,   229,    -1,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
      -1,   252,   253,   254,   255,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,    -1,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,    -1,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,    -1,   359,   360,
     361,   362,   363,    -1,    -1,   366,   367,   368,   369,   370,
      -1,    -1,   373,   374,   375,   376,   377,    -1,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
     391,    -1,   393,   394,    -1,    -1,   397,   398,   399,    -1,
     401,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,    44,
      45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,   170,    -1,   172,   173,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,    -1,   184,
      -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,    -1,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,    -1,   210,    -1,   212,   213,   214,
      -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,
     225,   226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,    -1,   252,   253,   254,
     255,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
     265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
      -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,    -1,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
     355,   356,   357,    -1,   359,   360,   361,   362,   363,    -1,
      -1,   366,   367,   368,   369,   370,    -1,    -1,   373,   374,
     375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,    -1,    -1,   393,    -1,
       4,   396,     6,     7,     8,     9,    10,    11,    12,    -1,
      14,    15,    16,    17,    18,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,
      44,    45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,   175,   176,    -1,   178,    -1,   180,   181,   182,    -1,
     184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,    -1,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,    -1,   210,    -1,   212,   213,
     214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,
      -1,   225,   226,   227,   228,   229,    -1,    -1,   232,    -1,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,    -1,   250,    -1,   252,   253,
     254,   255,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,
     274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,    -1,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
      -1,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,   355,   356,   357,    -1,   359,   360,   361,   362,   363,
      -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,   373,
     374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,    -1,    -1,   393,
       5,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      -1,    36,    37,    38,    39,    40,    41,    -1,    43,    44,
      45,    -1,    47,    48,    49,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,    -1,   107,   108,   109,    -1,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,    -1,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,    -1,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,    -1,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,    -1,   381,   382,   383,   384,
     385,   386,   387,   388,    -1,   390,    -1,    -1,   393,     5,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    -1,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    45,
      -1,    47,    48,    49,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,    -1,    -1,    -1,
     126,   127,   128,    -1,   130,   131,    -1,   133,    -1,   135,
     136,   137,   138,    -1,    -1,    -1,    -1,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,    -1,
     176,    -1,    -1,    -1,   180,   181,   182,    -1,   184,    -1,
     186,   187,    -1,   189,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,   199,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,   209,    -1,    -1,   212,   213,   214,   215,
     216,    -1,   218,    -1,    -1,   221,   222,   223,   224,   225,
     226,   227,   228,   229,    -1,   231,   232,   233,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,    -1,   252,   253,   254,   255,
      -1,    -1,   258,   259,   260,   261,    -1,    -1,   264,   265,
     266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,
      -1,    -1,   278,   279,    -1,   281,   282,   283,    -1,    -1,
      -1,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,    -1,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,    -1,   325,
     326,   327,   328,   329,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,    -1,
     356,    -1,    -1,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,    -1,    -1,   373,   374,   375,
     376,   377,   378,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,    -1,    -1,   393,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    -1,    36,    37,
      38,    39,    -1,    -1,    42,    43,    44,    45,    -1,    47,
      -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
     138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,   170,    -1,   172,   173,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,
      -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,    -1,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,
     218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,   251,   252,   253,   254,   255,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,   265,   266,    -1,
      -1,   269,   270,    -1,    -1,   273,   274,    -1,    -1,   277,
      -1,    -1,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,   312,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,    -1,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,   355,   356,   357,
      -1,   359,   360,   361,   362,   363,    -1,    -1,   366,   367,
     368,   369,   370,    -1,    -1,   373,   374,   375,   376,   377,
      -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,    -1,    -1,   393,   394,     6,     7,     8,
       9,    -1,    11,    12,    13,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    -1,    36,    37,    38,
      39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,
      -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,   138,
      -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,    -1,   172,   173,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,
      -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
      -1,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
      -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,   218,
      -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,
     229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
      -1,   250,    -1,   252,   253,   254,   255,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,
     269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,
      -1,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,    -1,   311,   312,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,    -1,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,   355,   356,   357,    -1,
     359,   360,   361,   362,   363,    -1,    -1,   366,   367,   368,
     369,   370,    -1,    -1,   373,   374,   375,   376,   377,    -1,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,    -1,    -1,   393,   394,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,   138,    -1,
      -1,    -1,    -1,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,    -1,
     210,    -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,
      -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,    -1,   252,   253,   254,   255,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,   269,
      -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,    -1,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,   351,   352,    -1,   354,   355,   356,   357,    -1,   359,
     360,   361,   362,   363,    -1,    -1,   366,   367,   368,   369,
     370,    -1,    -1,   373,   374,   375,   376,   377,    -1,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,   391,    -1,   393,   394,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    -1,    36,    37,    38,    39,    -1,
      -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,
      51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    75,    76,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,
      -1,    -1,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,
      -1,   162,   163,   164,   165,    -1,   167,   168,    -1,   170,
      -1,   172,   173,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,
      -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,
     201,   202,    -1,   204,   205,   206,   207,    -1,    -1,   210,
      -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,
      -1,    -1,   223,    -1,   225,   226,   227,   228,   229,    -1,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
      -1,   252,   253,   254,   255,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,
     281,   282,   283,    -1,   285,   286,   287,   288,    -1,   290,
     291,   292,   293,   294,   295,   296,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,    -1,
     311,   312,   313,   314,   315,   316,   317,   318,    -1,    -1,
     321,   322,   323,    -1,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,    -1,   344,   345,   346,   347,    -1,   349,   350,
      -1,   352,    -1,   354,   355,   356,   357,    -1,   359,   360,
     361,   362,   363,    -1,    -1,   366,   367,   368,   369,   370,
      -1,    -1,   373,   374,   375,   376,   377,    -1,   379,    -1,
      -1,    -1,   383,   384,   385,   386,   387,   388,    -1,   390,
     391,    -1,   393,   394,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    18,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,
      -1,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,
     212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,
      -1,   223,    -1,   225,   226,   227,   228,   229,    -1,    -1,
     232,    -1,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,    -1,   250,    -1,
     252,   253,   254,   255,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,    -1,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,    -1,   321,
     322,   323,    -1,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,    -1,   359,   360,   361,
     362,   363,    -1,    -1,   366,   367,   368,   369,   370,    -1,
      -1,   373,   374,   375,   376,   377,    -1,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,    -1,
      -1,   393,   394,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,
      43,    44,    45,    -1,    47,    -1,    -1,    50,    51,    52,
      -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    75,    76,    -1,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
      -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,
     163,   164,   165,    -1,   167,   168,    -1,   170,    -1,   172,
     173,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
      -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,
      -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,   202,
      -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,   212,
     213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,
     223,    -1,   225,   226,   227,   228,   229,    -1,    -1,   232,
      -1,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,    -1,   250,    -1,   252,
     253,   254,   255,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,
     273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,
     283,    -1,   285,   286,   287,   288,    -1,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,    -1,   311,   312,
     313,   314,   315,   316,   317,   318,    -1,    -1,   321,   322,
     323,    -1,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
      -1,   344,   345,   346,   347,    -1,   349,   350,    -1,   352,
      -1,   354,   355,   356,   357,    -1,   359,   360,   361,   362,
     363,    -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,
     373,   374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,
     383,   384,   385,   386,   387,   388,    -1,   390,    -1,    -1,
     393,   394,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,
      44,    45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,   175,   176,    -1,   178,    -1,   180,   181,   182,    -1,
     184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,    -1,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,    -1,   210,    -1,   212,   213,
     214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,
      -1,   225,   226,   227,   228,   229,    -1,    -1,   232,    -1,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,    -1,   250,    -1,   252,   253,
     254,   255,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,
     274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,    -1,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
      -1,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,   355,   356,   357,    -1,   359,   360,   361,   362,   363,
      -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,   373,
     374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,   391,    -1,   393,
     394,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,    44,
      45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,
      -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      75,    76,    -1,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,    -1,   154,
      -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,   164,
     165,    -1,   167,   168,    -1,   170,    -1,   172,   173,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,    -1,   184,
      -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,
     195,    -1,   197,   198,    -1,   200,   201,   202,    -1,   204,
     205,   206,   207,    -1,    -1,   210,    -1,   212,   213,   214,
      -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,
     225,   226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,    -1,   252,   253,   254,
     255,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
     265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
      -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,   290,   291,   292,   293,   294,
     295,   296,   297,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,    -1,   311,   312,   313,   314,
     315,   316,   317,   318,    -1,    -1,   321,   322,   323,    -1,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,    -1,   344,
     345,   346,   347,    -1,   349,   350,    -1,   352,    -1,   354,
     355,   356,   357,    -1,   359,   360,   361,   362,   363,    -1,
      -1,   366,   367,   368,   369,   370,    -1,    -1,   373,   374,
     375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,
     385,   386,   387,   388,    -1,   390,    -1,    -1,   393,   394,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,
     186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,    -1,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,
     216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,
     226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,    -1,   252,   253,   254,   255,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,   265,
     266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,
      -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,    -1,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,    -1,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,    -1,    -1,   373,   374,   375,
     376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,    -1,    -1,   393,   394,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    -1,    36,
      37,    38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,
      47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,   186,
      -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,    -1,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,
      -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,    -1,   250,    -1,   252,   253,   254,   255,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,   265,   266,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,
     277,    -1,    -1,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,   312,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,    -1,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,   355,   356,
     357,    -1,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,    -1,    -1,   373,   374,   375,   376,
     377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,    -1,    -1,   393,   394,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    -1,    36,
      37,    38,    39,    40,    41,    -1,    43,    44,    45,    -1,
      47,    48,    49,    50,    51,    52,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,
      -1,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,   106,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,    -1,    -1,    -1,   126,
     127,   128,    -1,   130,   131,    -1,   133,    -1,   135,   136,
      -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,   152,    -1,   154,    -1,   156,
     157,   158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,
     167,   168,    -1,   170,    -1,   172,   173,   174,    -1,   176,
      -1,    -1,    -1,   180,   181,   182,    -1,   184,    -1,   186,
      -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,
     197,   198,    -1,   200,   201,   202,    -1,   204,   205,   206,
     207,    -1,    -1,    -1,    -1,   212,   213,   214,   215,   216,
      -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,    -1,   250,    -1,   252,   253,   254,   255,   256,
      -1,   258,   259,    -1,   261,    -1,    -1,   264,   265,   266,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,
      -1,    -1,    -1,    -1,   281,   282,   283,    -1,    -1,    -1,
     287,   288,    -1,   290,   291,   292,   293,   294,   295,   296,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,    -1,   311,    -1,   313,   314,   315,   316,
     317,   318,    -1,    -1,   321,   322,   323,    -1,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,   335,   336,
     337,   338,   339,   340,    -1,   342,    -1,   344,   345,   346,
     347,    -1,   349,   350,    -1,   352,    -1,   354,    -1,   356,
      -1,    -1,   359,   360,   361,   362,   363,    -1,    -1,   366,
     367,   368,   369,   370,    -1,    -1,   373,   374,   375,   376,
     377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,
     387,   388,    -1,   390,    -1,    -1,   393,     5,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    -1,    36,    37,
      38,    39,    40,    41,    -1,    43,    44,    45,    -1,    47,
      48,    49,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,   106,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,    -1,    -1,    -1,   126,   127,
     128,    -1,   130,   131,    -1,   133,    -1,   135,   136,    -1,
     138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,   170,    -1,   172,   173,   174,    -1,   176,    -1,
      -1,    -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,
      -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,    -1,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,    -1,    -1,    -1,   212,   213,   214,   215,   216,    -1,
     218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,    -1,   252,   253,   254,   255,   256,    -1,
     258,   259,    -1,   261,    -1,    -1,   264,   265,   266,    -1,
      -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,    -1,
      -1,    -1,    -1,   281,   282,   283,    -1,    -1,    -1,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,    -1,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,    -1,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,    -1,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,    -1,   356,    -1,
      -1,   359,   360,   361,   362,   363,    -1,    -1,   366,   367,
     368,   369,   370,    -1,    -1,   373,   374,   375,   376,   377,
      -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,    -1,    -1,   393,     5,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    -1,    36,    37,    38,
      39,    40,    41,    -1,    43,    44,    45,    -1,    47,    48,
      49,    50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,   106,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,    -1,    -1,    -1,   126,   127,   128,
      -1,   130,   131,    -1,   133,    -1,   135,   136,    -1,   138,
      -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,   148,
     149,   150,    -1,   152,    -1,   154,    -1,   156,   157,   158,
      -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,   168,
      -1,   170,    -1,   172,   173,   174,    -1,   176,    -1,    -1,
      -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,
      -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,
      -1,   200,   201,   202,    -1,   204,   205,   206,   207,    -1,
      -1,    -1,    -1,   212,   213,   214,   215,   216,    -1,   218,
      -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,
     229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
      -1,   250,    -1,   252,   253,   254,   255,    -1,    -1,   258,
     259,    -1,   261,    -1,    -1,   264,   265,   266,    -1,    -1,
     269,    -1,    -1,    -1,   273,   274,    -1,    -1,    -1,    -1,
      -1,    -1,   281,   282,   283,    -1,    -1,    -1,   287,   288,
      -1,   290,   291,   292,   293,   294,   295,   296,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,    -1,   311,    -1,   313,   314,   315,   316,   317,   318,
      -1,    -1,   321,   322,   323,    -1,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,   335,   336,   337,   338,
     339,   340,    -1,   342,    -1,   344,   345,   346,   347,    -1,
     349,   350,    -1,   352,    -1,   354,    -1,   356,    -1,    -1,
     359,   360,   361,   362,   363,    -1,    -1,   366,   367,   368,
     369,   370,    -1,    -1,   373,   374,   375,   376,   377,    -1,
     379,    -1,    -1,    -1,   383,   384,   385,   386,   387,   388,
      -1,   390,    -1,    -1,   393,     5,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    -1,    36,    37,    38,    39,
      40,    41,    -1,    43,    44,    45,    -1,    47,    48,    49,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,   106,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,    -1,    -1,    -1,   126,   127,   128,    -1,
     130,   131,    -1,   133,    -1,   135,   136,    -1,   138,    -1,
      -1,    -1,    -1,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,    -1,   176,    -1,    -1,    -1,
     180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,    -1,
      -1,    -1,   212,   213,   214,   215,   216,    -1,   218,    -1,
      -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,    -1,   252,   253,   254,   255,    -1,    -1,   258,   259,
      -1,   261,    -1,    -1,   264,   265,   266,    -1,    -1,   269,
      -1,    -1,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,
      -1,   281,   282,   283,    -1,    -1,    -1,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,    -1,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,    -1,   325,    -1,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,    -1,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,    -1,   356,    -1,    -1,   359,
     360,   361,   362,   363,    -1,    -1,   366,   367,   368,   369,
     370,    -1,    -1,   373,   374,   375,   376,   377,    -1,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,    -1,    -1,   393,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,    51,
      52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,    -1,   107,   108,   109,    -1,   111,
     112,   113,   114,    -1,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
     132,   133,   134,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,    -1,   147,   148,   149,   150,   151,
     152,   153,   154,    -1,   156,   157,   158,   159,   160,   161,
     162,   163,   164,   165,   166,   167,   168,   169,   170,   171,
     172,   173,   174,   175,   176,    -1,   178,   179,   180,   181,
     182,   183,   184,   185,   186,   187,   188,   189,   190,    -1,
     192,   193,   194,   195,   196,   197,    -1,   199,   200,   201,
     202,   203,   204,   205,   206,   207,   208,   209,   210,    -1,
     212,   213,   214,    -1,   216,   217,   218,   219,    -1,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
      -1,   243,   244,    -1,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,    -1,    -1,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,   347,   348,   349,   350,    -1,
     352,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,    -1,   365,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,    -1,   381,
     382,   383,   384,   385,   386,    -1,   388,    -1,   390,    -1,
      -1,   393,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,
      44,    45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,   137,   138,    -1,    -1,    -1,    -1,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,   175,   176,    -1,   178,    -1,   180,   181,   182,    -1,
     184,    -1,   186,   187,    -1,   189,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,   199,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,   209,   210,    -1,   212,   213,
     214,    -1,   216,    -1,   218,    -1,    -1,   221,   222,   223,
     224,   225,   226,   227,   228,   229,    -1,   231,   232,   233,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,    -1,   258,   259,   260,   261,    -1,   263,
     264,   265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,
     274,    -1,    -1,   277,   278,   279,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
      -1,   325,   326,   327,   328,   329,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,   355,   356,   357,    -1,   359,   360,   361,   362,   363,
      -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,   373,
     374,   375,   376,   377,   378,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,    -1,    -1,   393,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,   118,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,   129,   130,   131,   132,   133,    -1,   135,
     136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,    -1,   184,   185,
     186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,    -1,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,
     216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,
     226,   227,   228,   229,    -1,    -1,   232,   233,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,    -1,   252,   253,   254,   255,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,   265,
     266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,
      -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,    -1,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,    -1,   359,   360,   361,   362,   363,    -1,   365,
     366,   367,   368,   369,   370,    -1,    -1,   373,   374,   375,
     376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,    -1,    -1,   393,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    -1,    36,    37,
      38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,
      -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      88,    89,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
     138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,   170,    -1,   172,   173,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,
      -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,    -1,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,
     218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,   251,   252,   253,   254,   255,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,   265,   266,    -1,
      -1,   269,   270,    -1,    -1,   273,   274,    -1,    -1,   277,
      -1,    -1,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,   312,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,    -1,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,   355,   356,   357,
      -1,   359,   360,   361,   362,   363,    -1,    -1,   366,   367,
     368,   369,   370,    -1,    -1,   373,   374,   375,   376,   377,
      -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,    -1,    -1,   393,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,   138,    -1,
      -1,    -1,    -1,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,    -1,
     210,    -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,
      -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,   251,   252,   253,   254,   255,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,   269,
     270,    -1,   272,   273,   274,    -1,    -1,   277,    -1,    -1,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,    -1,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,    -1,   359,
     360,   361,   362,   363,    -1,    -1,   366,   367,   368,   369,
     370,    -1,    -1,   373,   374,   375,   376,   377,    -1,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,    -1,    -1,   393,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,
      -1,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,
     212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,
      -1,   223,    -1,   225,   226,   227,   228,   229,    -1,    -1,
     232,    -1,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,    -1,   250,   251,
     252,   253,   254,   255,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,   265,   266,    -1,    -1,   269,   270,    -1,
      -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,    -1,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,    -1,   321,
     322,   323,    -1,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,    -1,   359,   360,   361,
     362,   363,    -1,    -1,   366,   367,   368,   369,   370,    -1,
      -1,   373,   374,   375,   376,   377,    -1,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,    -1,
      -1,   393,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,
      44,    45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,   175,   176,    -1,   178,    -1,   180,   181,   182,    -1,
     184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,    -1,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,    -1,   210,    -1,   212,   213,
     214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,
      -1,   225,   226,   227,   228,   229,    -1,    -1,   232,    -1,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,    -1,   250,   251,   252,   253,
     254,   255,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,   265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,
     274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,    -1,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
      -1,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,   355,   356,   357,    -1,   359,   360,   361,   362,   363,
      -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,   373,
     374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,    -1,    -1,   393,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,
     186,    -1,   188,    -1,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,    -1,   200,   201,   202,   203,   204,   205,
     206,   207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,
     216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,
     226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,    -1,   252,   253,   254,   255,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,   265,
     266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,
      -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,    -1,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,    -1,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,    -1,    -1,   373,   374,   375,
     376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,    -1,    -1,   393,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    -1,    36,    37,
      38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,
      -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
     138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,   170,    -1,   172,   173,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,
      -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,    -1,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,
     218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,    -1,   252,   253,   254,   255,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,   265,   266,    -1,
      -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,
      -1,    -1,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,   312,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,    -1,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,   355,   356,   357,
      -1,   359,   360,   361,   362,   363,    -1,    -1,   366,   367,
     368,   369,   370,    -1,    -1,   373,   374,   375,   376,   377,
      -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,    -1,    -1,   393,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,   138,    -1,
      -1,    -1,    -1,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,    -1,
     210,    -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,
      -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,    -1,   252,   253,   254,   255,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,   269,
      -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,    -1,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,    -1,   359,
     360,   361,   362,   363,    -1,    -1,   366,   367,   368,   369,
     370,    -1,    -1,   373,   374,   375,   376,   377,    -1,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,    -1,    -1,   393,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,
      -1,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,
     212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,
      -1,   223,    -1,   225,   226,   227,   228,   229,    -1,    -1,
     232,    -1,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,    -1,   250,    -1,
     252,   253,   254,   255,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,    -1,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,    -1,   321,
     322,   323,    -1,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,    -1,   359,   360,   361,
     362,   363,    -1,    -1,   366,   367,   368,   369,   370,    -1,
      -1,   373,   374,   375,   376,   377,    -1,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,    -1,
      -1,   393,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,
      44,    45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    98,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,   175,   176,    -1,   178,    -1,   180,   181,   182,    -1,
     184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,    -1,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,    -1,   210,    -1,   212,   213,
     214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,
      -1,   225,   226,   227,   228,   229,    -1,    -1,   232,    -1,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,    -1,   250,    -1,   252,   253,
     254,   255,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,
     274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,    -1,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
      -1,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,   355,   356,   357,    -1,   359,   360,   361,   362,   363,
      -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,   373,
     374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,    -1,    -1,   393,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,
     186,    -1,    -1,    -1,   190,    -1,   192,    -1,   194,   195,
      -1,   197,   198,    -1,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,
     216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,
     226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,    -1,   252,   253,   254,   255,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,   265,
     266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,
      -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,    -1,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,    -1,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,    -1,    -1,   373,   374,   375,
     376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,    -1,    -1,   393,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    -1,    36,    37,
      38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,
      -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
     138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,   170,    -1,   172,   173,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,
      -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,    -1,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,
     218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,    -1,   252,   253,   254,   255,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,   265,   266,    -1,
      -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,
      -1,    -1,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,   312,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,    -1,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,   355,   356,   357,
      -1,   359,   360,   361,   362,   363,    -1,    -1,   366,   367,
     368,   369,   370,    -1,    -1,   373,   374,   375,   376,   377,
      -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,    -1,    -1,   393,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,   138,    -1,
      -1,    -1,    -1,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,    -1,
     210,    -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,
      -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,    -1,   252,   253,   254,   255,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,   269,
      -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,    -1,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,    -1,   359,
     360,   361,   362,   363,    -1,    -1,   366,   367,   368,   369,
     370,    -1,    -1,   373,   374,   375,   376,   377,    -1,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,    -1,    -1,   393,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,
      -1,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,
     212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,
      -1,   223,    -1,   225,   226,   227,   228,   229,    -1,    -1,
     232,    -1,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,    -1,   250,    -1,
     252,   253,   254,   255,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,    -1,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,    -1,   321,
     322,   323,    -1,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,    -1,   359,   360,   361,
     362,   363,    -1,    -1,   366,   367,   368,   369,   370,    -1,
      -1,   373,   374,   375,   376,   377,    -1,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,    -1,
      -1,   393,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,
      44,    45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    93,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,   175,   176,    -1,   178,    -1,   180,   181,   182,    -1,
     184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,    -1,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,    -1,   210,    -1,   212,   213,
     214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,
      -1,   225,   226,   227,   228,   229,    -1,    -1,   232,    -1,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,    -1,   250,    -1,   252,   253,
     254,   255,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,
     274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,    -1,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
      -1,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,   355,   356,   357,    -1,   359,   360,   361,   362,   363,
      -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,   373,
     374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,    -1,    -1,   393,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    93,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,
     186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,    -1,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,
     216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,
     226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,    -1,   252,   253,   254,   255,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,   265,
     266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,
      -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,    -1,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,    -1,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,    -1,    -1,   373,   374,   375,
     376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,    -1,    -1,   393,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    -1,    36,    37,
      38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,
      -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
     138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,   170,    -1,   172,   173,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,
      -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,    -1,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,
     218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,    -1,   252,   253,   254,   255,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,   265,   266,    -1,
      -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,
      -1,    -1,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,   312,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,    -1,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,   355,   356,   357,
      -1,   359,   360,   361,   362,   363,    -1,    -1,   366,   367,
     368,   369,   370,    -1,   372,   373,   374,   375,   376,   377,
      -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,    -1,    -1,   393,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,   138,    -1,
      -1,    -1,    -1,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,    -1,
     210,    -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,
      -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,    -1,   252,   253,   254,   255,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,   269,
      -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,    -1,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,    -1,   359,
     360,   361,   362,   363,    -1,    -1,   366,   367,   368,   369,
     370,    -1,    -1,   373,   374,   375,   376,   377,    -1,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,    -1,    -1,   393,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    -1,    36,    37,    38,    39,    -1,    -1,
      -1,    43,    44,    45,    -1,    47,    -1,    -1,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,   138,    -1,    -1,    -1,
      -1,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
     152,    -1,   154,    -1,   156,   157,   158,    -1,    -1,    -1,
     162,   163,   164,   165,    -1,   167,   168,    -1,   170,    -1,
     172,   173,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,    -1,   184,    -1,   186,    -1,    -1,    -1,   190,    -1,
     192,    -1,    -1,   195,    -1,   197,   198,    -1,   200,   201,
     202,    -1,   204,   205,   206,   207,    -1,    -1,   210,    -1,
     212,   213,   214,    -1,   216,    -1,   218,    -1,    -1,    -1,
      -1,   223,    -1,   225,   226,   227,   228,   229,    -1,    -1,
     232,    -1,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,    -1,   250,    -1,
     252,   253,   254,   255,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,   265,   266,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,    -1,    -1,   277,    -1,    -1,   280,   281,
     282,   283,    -1,   285,   286,   287,   288,    -1,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,    -1,   311,
     312,   313,   314,   315,   316,   317,   318,    -1,    -1,   321,
     322,   323,    -1,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,    -1,   344,   345,   346,   347,    -1,   349,   350,    -1,
     352,    -1,   354,   355,   356,   357,    -1,   359,   360,   361,
     362,   363,    -1,    -1,   366,   367,   368,   369,   370,    -1,
      -1,   373,   374,   375,   376,   377,    -1,   379,    -1,    -1,
      -1,   383,   384,   385,   386,   387,   388,    -1,   390,    -1,
      -1,   393,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    -1,    36,    37,    38,    39,    -1,    -1,    -1,    43,
      44,    45,    -1,    47,    -1,    -1,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    75,    76,    -1,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,   138,    -1,    -1,    -1,    -1,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,   152,    -1,
     154,    -1,   156,   157,   158,    -1,    -1,    -1,   162,   163,
     164,   165,    -1,   167,   168,    -1,   170,    -1,   172,   173,
     174,   175,   176,    -1,   178,    -1,   180,   181,   182,    -1,
     184,    -1,   186,    -1,    -1,    -1,   190,    -1,   192,    -1,
      -1,   195,    -1,   197,   198,    -1,   200,   201,   202,    -1,
     204,   205,   206,   207,    -1,    -1,   210,    -1,   212,   213,
     214,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   223,
      -1,   225,   226,   227,   228,   229,    -1,    -1,   232,    -1,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,    -1,   250,    -1,   252,   253,
     254,   255,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,   265,   266,    -1,    -1,   269,    -1,    -1,    -1,   273,
     274,    -1,    -1,   277,    -1,    -1,   280,   281,   282,   283,
      -1,   285,   286,   287,   288,    -1,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,    -1,   311,   312,   313,
     314,   315,   316,   317,   318,    -1,    -1,   321,   322,   323,
      -1,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,    -1,
     344,   345,   346,   347,    -1,   349,   350,    -1,   352,    -1,
     354,   355,   356,   357,    -1,   359,   360,   361,   362,   363,
      -1,    -1,   366,   367,   368,   369,   370,    -1,    -1,   373,
     374,   375,   376,   377,    -1,   379,    -1,    -1,    -1,   383,
     384,   385,   386,   387,   388,    -1,   390,    -1,    -1,   393,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    -1,
      36,    37,    38,    39,    -1,    -1,    -1,    43,    44,    45,
      -1,    47,    -1,    -1,    50,    51,    52,    -1,    -1,    -1,
      56,    57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    75,
      76,    -1,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,   138,    -1,    -1,    -1,    -1,   143,   144,   145,
     146,   147,   148,   149,   150,    -1,   152,    -1,   154,    -1,
     156,   157,   158,    -1,    -1,    -1,   162,   163,   164,   165,
      -1,   167,   168,    -1,   170,    -1,   172,   173,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,
     186,    -1,    -1,    -1,   190,    -1,   192,    -1,    -1,   195,
      -1,   197,   198,    -1,   200,   201,   202,    -1,   204,   205,
     206,   207,    -1,    -1,   210,    -1,   212,   213,   214,    -1,
     216,    -1,   218,    -1,    -1,    -1,    -1,   223,    -1,   225,
     226,   227,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,    -1,   252,   253,   254,   255,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,   265,
     266,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,    -1,
      -1,   277,    -1,    -1,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
     316,   317,   318,    -1,    -1,   321,   322,   323,    -1,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,    -1,   344,   345,
     346,   347,    -1,   349,   350,    -1,   352,    -1,   354,   355,
     356,   357,    -1,   359,   360,   361,   362,   363,    -1,    -1,
     366,   367,   368,   369,   370,    -1,    -1,   373,   374,   375,
     376,   377,    -1,   379,    -1,    -1,    -1,   383,   384,   385,
     386,   387,   388,    -1,   390,    -1,    -1,   393,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    -1,    36,    37,
      38,    39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,
      -1,    -1,    50,    51,    52,    -1,    -1,    -1,    56,    57,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    73,    -1,    75,    76,    -1,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
     138,    -1,    -1,    -1,    -1,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,   152,    -1,   154,    -1,   156,   157,
     158,    -1,    -1,    -1,   162,   163,   164,   165,    -1,   167,
     168,    -1,   170,    -1,   172,   173,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,
      -1,    -1,   190,    -1,   192,    -1,    -1,   195,    -1,   197,
     198,    -1,   200,   201,   202,    -1,   204,   205,   206,   207,
      -1,    -1,   210,    -1,   212,   213,   214,    -1,   216,    -1,
     218,    -1,    -1,    -1,    -1,   223,    -1,   225,   226,   227,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,    -1,   252,   253,   254,   255,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,   265,   266,    -1,
      -1,   269,    -1,    -1,    -1,   273,   274,    -1,    -1,   277,
      -1,    -1,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,    -1,   311,   312,   313,   314,   315,   316,   317,
     318,    -1,    -1,   321,   322,   323,    -1,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,    -1,   344,   345,   346,   347,
      -1,   349,   350,    -1,   352,    -1,   354,   355,   356,   357,
      -1,   359,   360,   361,   362,   363,    -1,    -1,   366,   367,
     368,   369,   370,    -1,    -1,   373,   374,   375,   376,   377,
      -1,   379,    -1,    -1,    -1,   383,   384,   385,   386,   387,
     388,    -1,   390,    -1,    -1,   393,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    -1,    36,    37,    38,    39,
      -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,    -1,
      50,    51,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    73,    -1,    75,    76,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,   138,    -1,
      -1,    -1,    -1,   143,   144,   145,   146,   147,   148,   149,
     150,    -1,   152,    -1,   154,    -1,   156,   157,   158,    -1,
      -1,    -1,   162,   163,   164,   165,    -1,   167,   168,    -1,
     170,    -1,   172,   173,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,   186,    -1,    -1,    -1,
     190,    -1,   192,    -1,    -1,   195,    -1,   197,   198,    -1,
     200,   201,   202,    -1,   204,   205,   206,   207,    -1,    -1,
     210,    -1,   212,   213,   214,    -1,   216,    -1,   218,    -1,
      -1,    -1,    -1,   223,    -1,   225,   226,   227,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,    -1,   252,   253,   254,   255,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,   265,   266,    -1,    -1,   269,
      -1,    -1,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,
     280,   281,   282,   283,    -1,   285,   286,   287,   288,    -1,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
      -1,   311,   312,   313,   314,   315,   316,   317,   318,    -1,
      -1,   321,   322,   323,    -1,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,    -1,   344,   345,   346,   347,    -1,   349,
     350,    -1,   352,    -1,   354,   355,   356,   357,    -1,   359,
     360,   361,   362,   363,    -1,    -1,   366,   367,   368,   369,
     370,    -1,    -1,   373,   374,   375,   376,   377,    -1,   379,
      -1,    -1,    -1,   383,   384,   385,   386,   387,   388,    -1,
     390,    -1,    -1,   393,     6,     7,     8,    -1,    -1,    11,
      12,    -1,    14,    15,    16,    -1,    -1,    -1,    20,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    -1,    -1,    -1,    36,    37,    38,    39,    -1,    41,
      -1,    43,    44,    45,    46,    47,    48,    49,    50,    -1,
      -1,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,
     102,   103,   104,   105,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   116,    -1,    -1,    -1,    -1,    -1,
      -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     132,    -1,    -1,    -1,    -1,   137,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   148,   149,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   175,    -1,    -1,   178,    -1,    -1,    -1,
     182,    -1,    -1,    -1,    -1,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   199,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   209,   210,    -1,
      -1,    -1,    -1,    -1,   216,    -1,   218,    -1,    -1,   221,
     222,    -1,   224,    -1,    -1,    -1,    -1,    -1,    -1,   231,
      -1,   233,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   248,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,    -1,    -1,   260,    -1,
      -1,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   277,   278,   279,   280,    -1,
      -1,    -1,    -1,   285,   286,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   296,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   310,    -1,
     312,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   326,    -1,    -1,   329,    -1,   331,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   341,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   349,   350,    -1,
      -1,    -1,    -1,   355,    -1,   357,    -1,    -1,    -1,    -1,
      -1,    -1,   364,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   376,    -1,   378,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     6,     7,     8,    -1,   390,    11,
      12,   393,    14,    15,    16,    -1,    -1,    -1,    20,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    -1,    -1,    -1,    36,    37,    38,    39,    -1,    41,
      -1,    43,    44,    45,    46,    47,    48,    49,    50,    -1,
      -1,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    76,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,
     102,   103,   104,   105,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   116,    -1,    -1,    -1,    -1,    -1,
      -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     132,    -1,    -1,    -1,    -1,   137,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   148,   149,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   175,    -1,    -1,   178,    -1,    -1,    -1,
     182,    -1,    -1,    -1,    -1,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   199,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   209,   210,    -1,
      -1,    -1,    -1,    -1,   216,    -1,   218,    -1,    -1,   221,
     222,    -1,   224,    -1,    -1,    -1,    -1,    -1,    -1,   231,
      -1,   233,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   248,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,    -1,    -1,   260,    -1,
      -1,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   277,   278,   279,   280,    -1,
      -1,    -1,    -1,   285,   286,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   296,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   310,    -1,
     312,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   326,    -1,    -1,   329,    -1,   331,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   341,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   349,   350,    -1,
      -1,    -1,    -1,   355,    -1,   357,    -1,    -1,    -1,    -1,
      -1,    -1,   364,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   376,    -1,   378,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     6,     7,     8,    -1,   390,    11,
      12,   393,    14,    15,    16,    -1,    -1,    -1,    20,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    -1,    -1,    -1,    36,    37,    38,    39,    -1,    41,
      -1,    43,    44,    45,    -1,    47,    48,    49,    50,    -1,
      -1,    -1,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    73,    -1,    75,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,
     102,   103,   104,   105,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   116,    -1,    -1,    -1,    -1,    -1,
      -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     132,    -1,    -1,    -1,    -1,   137,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   148,   149,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   175,    -1,    -1,   178,    -1,    -1,    -1,
     182,    -1,    -1,    -1,    -1,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   199,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   209,   210,    -1,
      -1,    -1,    -1,    -1,   216,    -1,   218,    -1,    -1,   221,
     222,    -1,   224,    -1,    -1,    -1,    -1,    -1,    -1,   231,
      -1,   233,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   248,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,    -1,    -1,   260,    -1,
      -1,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   277,   278,   279,   280,    -1,
      -1,    -1,    -1,   285,   286,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   296,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   310,    -1,
     312,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   326,    -1,    -1,   329,    -1,   331,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   341,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   349,   350,    -1,
      -1,    -1,    -1,   355,    -1,   357,    -1,    -1,    -1,    -1,
      -1,    -1,   364,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   376,    -1,   378,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     6,     7,     8,    -1,   390,    11,
      12,   393,    14,    15,    16,    -1,    -1,    -1,    20,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    -1,    -1,    -1,    36,    37,    38,    39,    -1,    41,
      -1,    43,    44,    45,    -1,    47,    48,    49,    50,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,
     102,   103,   104,   105,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   116,    -1,    -1,    -1,    -1,    -1,
      -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     132,    -1,    -1,    -1,    -1,   137,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   148,   149,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   175,    -1,    -1,   178,    -1,    -1,    -1,
     182,    -1,    -1,    -1,    -1,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   199,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   209,   210,    -1,
      -1,    -1,    -1,    -1,   216,    -1,   218,    -1,    -1,   221,
     222,    -1,   224,    -1,    -1,    -1,    -1,    -1,    -1,   231,
      -1,   233,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   248,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,    -1,    -1,   260,    -1,
      -1,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   277,   278,   279,   280,    -1,
      -1,    -1,    -1,   285,   286,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   296,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   310,    -1,
     312,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   326,    -1,    -1,   329,    -1,   331,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   341,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   349,   350,    -1,
      -1,    -1,    -1,   355,    -1,   357,    -1,    -1,    -1,    -1,
      -1,    -1,   364,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   376,    -1,   378,     6,     7,     8,
      -1,    -1,    11,    12,    -1,    14,    15,    16,   390,    -1,
      -1,   393,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    -1,    -1,    -1,    36,    37,    38,
      39,    -1,    -1,    -1,    43,    44,    45,    -1,    47,    -1,
      -1,    50,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,
      -1,    -1,    -1,   102,   103,   104,   105,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   116,    -1,    -1,
      -1,    -1,    -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,    -1,    -1,    -1,   137,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   148,
     149,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   175,    -1,    -1,   178,
      -1,    -1,    -1,   182,    -1,    -1,    -1,    -1,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     199,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     209,   210,    -1,    -1,    -1,    -1,    -1,   216,    -1,   218,
      -1,    -1,   221,   222,    -1,   224,    -1,    -1,    -1,    -1,
      -1,    -1,   231,    -1,   233,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   248,
     249,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,    -1,
      -1,   260,    -1,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   277,   278,
     279,   280,    -1,    -1,    -1,    -1,   285,   286,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   296,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   310,    -1,   312,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   326,    -1,    -1,
     329,    -1,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     349,   350,    -1,    -1,    -1,    -1,   355,    -1,   357,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   376,    -1,   378,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   390,    -1,    -1,   393
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short yystos[] =
{
       0,   425,   426,     0,     5,    20,    29,    40,    41,    46,
      48,    49,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,   115,   182,   198,   215,
     242,   245,   262,   318,   351,   364,   376,   387,   390,   391,
     393,   395,   399,   401,   402,   406,   407,   408,   409,   410,
     413,   414,   415,   416,   418,   419,   420,   421,   427,   785,
     786,   789,   824,   826,   923,   936,   937,   825,     3,     6,
       7,     8,     9,    11,    12,    14,    15,    16,    17,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    30,
      31,    32,    33,    36,    37,    38,    39,    41,    43,    44,
      45,    47,    48,    49,    50,    51,    52,    56,    57,    62,
      71,    73,    75,    76,    78,    87,    88,    89,    97,    98,
     101,   102,   103,   104,   105,   116,   119,   121,   122,   123,
     126,   127,   132,   133,   134,   137,   145,   147,   148,   149,
     150,   156,   164,   169,   174,   175,   176,   178,   180,   182,
     187,   189,   191,   193,   199,   209,   210,   213,   216,   218,
     221,   222,   224,   231,   233,   235,   236,   239,   246,   248,
     249,   250,   256,   259,   260,   263,   264,   277,   278,   279,
     280,   285,   286,   288,   296,   299,   301,   305,   309,   310,
     311,   312,   315,   320,   325,   326,   328,   329,   331,   334,
     341,   349,   350,   355,   357,   359,   361,   364,   367,   369,
     373,   376,   378,   390,   393,   415,   428,   429,   430,   432,
     433,   434,   438,   441,   442,   443,   447,   458,   459,   460,
     463,   464,   472,   473,   482,   509,   515,   516,   520,   524,
     526,   528,   529,   542,   543,   544,   545,   551,   556,   557,
     562,   563,   567,   570,   571,   582,   588,   601,   602,   604,
     607,   609,   610,   613,   615,   616,   624,   625,   626,   627,
     628,   633,   634,   635,   639,   640,   641,   642,   644,   645,
     646,   647,   648,   653,   656,   660,   661,   665,   666,   669,
     670,   671,   672,   673,   801,   814,   815,   816,   817,   818,
     831,   836,   837,   838,   839,   840,   842,   844,   846,   847,
     848,   849,   851,   856,   857,   860,   865,   866,   875,   876,
     878,   879,   880,   883,   887,   890,   894,   896,   897,   900,
     902,   905,   913,   919,   920,   930,   828,   829,   831,   833,
     836,   839,   842,    18,     9,    17,    19,    33,    51,    52,
      56,    57,    62,    71,    73,    75,    76,    78,    79,    80,
      81,    82,    83,    84,    86,    87,    95,    96,    97,    99,
     100,   101,   108,   109,   111,   114,   115,   117,   119,   120,
     121,   122,   126,   127,   128,   130,   131,   133,   135,   136,
     138,   143,   144,   145,   146,   147,   150,   152,   154,   156,
     157,   158,   162,   163,   164,   165,   167,   168,   170,   172,
     173,   174,   176,   180,   181,   184,   186,   190,   192,   195,
     197,   198,   200,   201,   202,   204,   205,   206,   207,   212,
     213,   214,   223,   225,   226,   227,   228,   229,   232,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   252,   253,   254,   255,   258,   259,   261,   265,
     266,   269,   273,   274,   281,   282,   283,   287,   288,   290,
     291,   292,   293,   294,   295,   297,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   311,   313,   314,
     315,   316,   317,   318,   321,   322,   323,   325,   327,   328,
     330,   333,   334,   335,   336,   337,   338,   339,   340,   342,
     344,   345,   346,   347,   351,   352,   354,   356,   359,   360,
     361,   362,   363,   366,   367,   368,   369,   370,   373,   374,
     375,   377,   379,   383,   384,   385,   386,   387,   388,   394,
     789,   794,   799,   810,   811,   904,   905,   906,   909,   915,
     916,   917,   918,   919,   927,   929,   930,    34,   211,   877,
      13,    85,   151,   778,   802,   803,   812,   858,   859,   909,
     929,   930,     5,    29,    34,    40,    41,    48,    49,    85,
      88,    89,    90,    91,    92,    93,    94,   107,   112,   113,
     115,   118,   124,   125,   129,   134,   139,   140,   141,   142,
     151,   153,   159,   160,   161,   166,   169,   171,   179,   183,
     185,   188,   193,   194,   196,   203,   208,   211,   215,   217,
     219,   230,   234,   251,   257,   262,   267,   268,   270,   271,
     272,   275,   276,   289,   298,   320,   324,   332,   343,   348,
     351,   353,   358,   364,   365,   371,   372,   381,   382,   419,
     841,   906,   907,   908,   912,   913,   914,   915,   917,   918,
     921,   777,   909,   777,   908,    29,    40,   115,   215,   901,
      43,    45,   257,   832,   354,   385,   629,    84,   131,   145,
     162,   190,   194,   206,   227,   273,   316,   321,   343,   344,
     356,   361,   371,   802,   150,   629,   777,   251,   270,   773,
     775,   781,   800,   909,   271,   629,   104,   478,    84,    95,
     113,   129,   145,   151,   162,   192,   194,   237,   273,   275,
     316,   344,   345,   347,   356,   360,   361,   365,   371,   483,
     521,   554,   583,   589,   802,    18,   288,   777,   812,   864,
     335,   777,   188,    84,    95,   113,   131,   145,   162,   190,
     194,   206,   273,   292,   314,   316,   321,   343,   344,   356,
     361,   371,   379,   525,   558,   629,   200,   864,   648,   655,
      79,    85,    99,   181,   186,   188,   203,   229,   252,   290,
     300,   407,   564,   565,   566,   777,   785,   790,   791,   927,
      18,    85,   134,   156,   174,   213,   298,   314,   320,   345,
     347,   356,   369,   370,   572,   573,   574,   219,   775,   909,
     782,   794,   343,   676,   564,   777,   775,   864,   145,   206,
     343,   611,   315,   909,    85,   323,   349,   354,   909,   193,
     579,   629,   909,    85,   160,   678,     4,    10,    18,   130,
     237,   247,   323,   349,   354,   448,   449,   909,    85,   323,
     349,   354,   909,   354,   676,   898,   908,   408,   775,   272,
     700,   775,   189,   650,   670,   671,   101,   429,   418,   378,
     649,   171,   217,   276,   364,   679,   680,   839,   842,   838,
     820,   418,   843,   845,     5,    29,    40,   115,   163,   215,
     850,   146,   198,   242,   245,   318,   387,   415,   729,   823,
     827,   923,   831,   833,   839,   835,   418,   777,   812,   931,
     151,   802,    25,   372,   409,   777,   777,   392,   804,   805,
     423,   929,   415,   419,   932,   933,   934,   935,   937,   841,
     372,   867,   868,   869,    29,   215,   215,   912,     7,    11,
      23,    24,    44,    47,   161,   903,   903,    21,   839,   773,
     783,   904,   911,   915,   916,   920,   930,   560,   909,   778,
     560,   778,   909,   783,   799,   700,   777,   120,   392,   402,
     403,   404,   406,   407,   408,   409,   410,   411,   606,   736,
     737,   909,   777,   775,   700,   777,   777,   560,   799,    39,
     223,   295,   630,   631,   632,   413,   417,   761,   762,   271,
      84,   113,   125,   131,   145,   162,   190,   206,   228,   273,
     314,   316,   321,   343,   356,   361,   379,   525,   568,   775,
     783,   777,   415,   356,   778,   560,   345,   347,   799,   345,
     347,   120,   736,   304,   444,   909,   777,   777,   560,   799,
     321,   343,   525,   131,   206,   190,   314,   379,   931,   864,
     930,   667,   700,   783,   777,   415,   778,   783,   799,   120,
     736,   777,   777,   777,   437,   799,   227,   559,   560,   393,
     812,   863,   861,   649,   565,    85,   565,    85,   565,   565,
     790,   566,   777,   777,   219,   870,   872,   931,   291,   271,
     421,   775,   774,   775,   566,   188,   777,   775,   909,    98,
     388,   223,   274,   572,   351,   271,    92,   103,   105,   106,
     112,   113,   115,   116,   123,   132,   139,   140,   141,   142,
     148,   149,   163,   175,   178,   179,   182,   215,   216,   218,
     248,   250,   257,   262,   263,   264,   273,   280,   285,   296,
     312,   324,   331,   341,   349,   350,   355,   357,   358,   365,
     371,   376,   392,   397,   398,   400,   406,   407,   408,   410,
     411,   415,   670,   709,   710,   711,   716,   717,   718,   720,
     721,   722,   723,   726,   727,   730,   732,   733,   734,   738,
     755,   760,   765,   766,   773,   783,   784,   785,   786,   787,
     788,   789,   798,   904,   907,   910,   915,   916,   926,   927,
     929,   930,   351,   402,   351,   402,   859,   931,    85,   461,
     776,   777,   323,   448,   151,   456,   794,    98,   117,   448,
     388,   631,   351,   417,   422,    98,   388,   223,   632,   775,
     913,   415,   775,   325,   408,   187,   651,   416,   416,   418,
     775,    85,   677,   677,   108,   677,   183,   234,   268,   683,
     689,   819,   408,   852,   853,   855,   419,   419,    29,   215,
     215,   351,   351,   351,   351,   351,   407,   785,   786,   796,
     821,   927,   169,   834,   852,    93,   808,   108,   811,   811,
     372,   869,   219,   869,   870,   396,   806,   909,   423,   807,
     804,   416,   933,   934,   932,   420,   421,    42,   789,   796,
     797,   871,   873,   874,   926,   215,   221,   777,   351,   777,
       6,   777,   903,   855,   762,   415,   281,   302,   417,   561,
     281,   302,   325,   459,    82,   164,   325,   469,   281,   415,
     590,    82,   164,   302,   281,   302,   325,   467,   468,   302,
     560,   415,   417,   281,   302,   517,    82,    87,   122,   134,
     164,   302,   325,   465,   466,   281,   302,   271,   281,   302,
     325,   383,   435,   459,   418,   232,   272,   386,   421,   630,
     730,   408,   780,   912,   761,   775,   783,   415,   783,   265,
     120,   736,   777,   777,   227,   777,   383,   479,   415,   547,
     118,   103,   105,   115,   116,   148,   149,   182,   216,   218,
     248,   250,   264,   296,   326,   331,   349,   350,   376,   705,
     708,   710,   711,   715,   717,   718,   719,   721,   722,   726,
     727,   904,   910,   915,   916,   930,   777,   383,    93,   643,
     383,   439,   560,   547,    98,   445,   281,   527,    83,   100,
     530,    93,   547,   383,   431,   775,   775,   227,   560,   781,
     909,   783,   777,   775,   104,   143,   212,   253,   317,   382,
     702,   415,   705,   590,   560,   415,   271,   271,   421,   794,
     111,   307,   421,   470,   862,   868,   872,   150,   654,   656,
     660,   665,   666,   669,   777,   872,   872,   871,   922,   925,
     929,    50,   881,   882,   929,   145,   190,   227,   316,   343,
     344,   575,   774,   574,   151,   375,   415,   657,   669,   203,
     421,   662,   777,   863,   184,   612,   612,   232,   183,   271,
     315,   909,   415,   413,   670,   745,   377,   724,   730,   759,
     415,   724,   724,   415,   415,   415,   764,   415,   764,   415,
     764,   415,   714,   714,   286,   670,   415,   415,   712,   115,
     116,   724,   730,   415,   415,   713,   415,   415,   415,   415,
     764,   415,   383,   384,   415,   728,   415,   728,   415,   415,
     670,   764,   763,   730,   730,   730,   730,   670,   730,   741,
     794,   116,   415,   725,   415,   794,    77,    90,    93,    97,
     102,   199,   203,   221,   222,   233,   257,   260,   273,   275,
     329,   392,   402,   403,   404,   406,   407,   408,   409,   410,
     411,   736,   738,   740,   730,   219,   421,   674,   872,   762,
     415,    26,   928,   929,   267,   271,   895,   895,   859,   859,
      12,    50,   884,   885,   886,   154,   200,   462,   421,   117,
     151,   457,   794,   909,    93,   151,   237,   455,   727,   797,
     930,   151,   179,   267,   271,   358,   450,   451,   453,   454,
     797,   909,   909,   450,   232,   221,   775,   415,   767,   770,
     909,   649,   415,   652,   670,   672,   673,   672,   681,   682,
     730,   672,   295,   369,    85,   685,   730,   686,   730,   689,
     690,   683,   684,   852,   408,   418,   421,   914,   830,   833,
     830,   215,   146,   198,   242,   318,   242,   318,   318,   245,
     242,   245,   318,   785,   786,   421,   822,   150,   852,   418,
     802,   371,   809,   811,   417,   790,   807,   416,   420,   935,
      18,   421,   839,   415,   777,   415,   913,   408,   603,   705,
     351,   351,   780,   417,   351,   351,   448,   118,   129,   185,
     289,   365,   494,   495,   129,   151,   257,   151,   257,   351,
     203,   210,   277,   416,   591,   592,   593,   281,   302,   371,
     371,   351,   351,   351,   344,   421,   351,   372,   256,   605,
     705,   606,   351,   351,   109,   144,   205,   241,   243,   253,
     306,   334,   518,   125,   494,   614,   614,   271,   352,   129,
     614,   351,   614,   384,   421,   351,   351,   700,   351,   351,
     448,   435,   135,   136,   203,   254,   255,   283,   342,   374,
     436,   295,   303,   322,   452,   630,   414,   423,   415,   705,
     590,   796,   560,   415,   221,   271,   271,   560,   221,   269,
     188,   351,   474,   548,   549,   912,   415,   708,    93,    92,
     413,   706,   146,   245,   387,   415,   729,   561,    83,   167,
     238,   281,   344,   346,   636,   637,   705,   439,   342,   371,
     440,   554,   799,   134,   446,   482,   515,   529,   570,   582,
     633,   777,   238,   156,   213,   369,   531,   532,   415,   546,
     435,   517,   266,   415,   512,   457,   183,   271,   590,    93,
     415,   496,   383,   384,   668,   317,   730,   603,    93,   470,
     372,   605,   775,   775,   799,   470,   560,   872,   868,   777,
     872,    18,   421,   928,   785,   792,   929,   421,   402,   776,
     580,   581,   783,   776,   776,   774,   776,   351,   375,   415,
     658,   659,   909,    80,   172,   312,   327,   663,   775,   261,
     664,   575,   909,   730,   741,   741,   744,   745,   415,   381,
     756,   757,   730,   741,   730,   741,   416,   790,   790,   790,
     146,   198,   242,   245,   318,   387,   742,   746,   794,   930,
     790,   724,   724,   730,   790,   606,   730,   747,   407,   410,
     411,   731,   732,   738,   749,   416,   741,   730,   741,   750,
     349,   349,   790,   790,   730,   107,   188,   230,   353,   730,
     741,   753,   761,   416,   421,   325,   790,   790,   729,   705,
     730,   912,   349,   731,   730,   415,   670,   754,   160,   179,
     257,   262,   266,   358,   366,   730,   102,   199,   203,   233,
     329,   415,   730,   351,   730,   730,   730,   730,   730,   730,
     730,   730,   730,   730,    85,    91,   332,   735,   192,   237,
     343,   345,   347,   675,   775,   766,   188,   692,    85,   160,
     408,   416,   741,   777,   929,   792,   421,   402,   777,   354,
     415,   794,   421,   839,   416,   768,   909,   421,   692,   763,
     647,   775,   776,   421,    94,   159,   372,   272,   266,   691,
     268,   421,   234,   418,   853,   706,   420,   833,   420,   796,
     416,    39,   418,   810,   806,   409,   931,   873,   706,   924,
     934,   924,   706,   416,   799,   777,   780,   799,   778,   415,
     777,   225,   225,   415,   777,   262,   730,   262,   799,   416,
     421,   595,   597,   705,   904,   910,   911,   915,   916,   930,
     351,   351,   437,   437,   799,   799,   777,   777,   468,   777,
     779,   909,   421,   416,   421,   799,   777,   796,   108,   519,
     796,   796,   144,   241,   243,   431,   431,   487,   909,   909,
     777,   343,   777,   909,   777,   777,   122,   269,   466,   799,
     777,   302,   799,   799,   194,   789,   790,   368,   128,   362,
     295,   730,   603,    93,   221,   221,   372,   605,   262,   569,
     794,   560,   560,   221,   569,   337,   338,   475,   794,   416,
     421,   402,   730,    92,   706,   705,   413,   414,   415,   707,
     789,   790,   909,   351,   351,   790,   531,   402,   638,   638,
     638,   638,   638,   637,   488,   790,   437,   183,   445,   483,
     589,   789,   271,   275,   703,   704,   909,   775,   233,   484,
     485,   486,   487,   492,   494,   513,   514,   909,    93,   383,
     384,   511,   195,   794,   775,   308,   617,   497,   498,   909,
      93,   197,   197,   183,   416,   705,   779,   416,   470,   470,
     667,   931,   925,   888,   889,   929,   882,   886,   421,   590,
     194,   576,   577,   909,   151,   730,   771,   772,   416,   421,
     763,   172,   327,   172,   327,   312,   369,   244,   188,   416,
     421,   414,   414,   421,   790,   730,   166,   757,   758,    93,
     416,   372,   416,   416,   416,   416,   421,   416,   188,   416,
     421,   416,   421,   416,   284,   748,   416,   731,   731,   731,
      77,   203,   221,   273,   392,   402,   403,   404,   406,   407,
     408,   409,   410,   411,   738,   731,   416,   416,   183,   188,
     751,   752,   416,   388,   388,   416,   416,    93,   753,   741,
     753,   753,   188,   416,   763,   730,   909,   416,   416,   388,
      90,   170,   741,   188,   179,   262,   266,   358,   366,   415,
     170,   731,   730,   754,   730,   351,   606,   730,   415,   670,
     345,   347,   345,   347,   775,   676,   676,   415,   670,   693,
     694,   695,   700,   701,   733,   773,   702,   741,   741,   416,
     416,     8,    14,    15,    16,    26,    27,    28,    30,    31,
      32,    36,    37,    38,   286,   361,   891,   892,   893,   885,
     792,   631,   790,   729,   453,   706,   416,   763,   770,   702,
     402,   416,   682,   273,   736,   739,   776,   686,   686,   685,
     402,   854,   418,   778,    35,   899,   416,   416,   418,   281,
     302,   730,   495,   415,   415,   497,   470,   592,   597,   561,
     799,   777,   281,   302,   705,   281,   256,   705,   796,   796,
     796,   705,   164,   325,   361,   469,   470,   470,   351,   351,
     437,   789,   414,   416,   705,   569,   569,   779,   416,   221,
     221,   569,   372,   480,   481,   549,   273,   407,   550,   596,
     597,   739,   797,   416,   413,   416,   790,   706,   707,   406,
     407,   408,   409,   410,   414,   416,   271,   151,   785,   789,
     795,   927,   151,   794,   151,   777,   151,   777,   151,   777,
     118,   129,   151,   153,   208,   257,   262,   289,   298,   365,
     489,   490,   491,   361,   343,   775,   532,   416,   421,   705,
     415,   775,   416,   421,   416,   421,   269,   269,   510,   522,
     777,   351,   372,   584,   596,   271,   416,   421,   669,   669,
     864,   470,   416,   470,   470,   143,   421,   402,   581,   909,
     383,   421,   578,   416,   421,   375,   669,   659,   172,   172,
     576,   730,   745,   416,   348,   730,   169,   705,   560,   790,
     730,   730,   790,   730,   751,   705,   731,   160,   257,   266,
     731,   731,   731,   731,   731,   731,   731,   731,   731,   731,
     730,   730,   752,   751,   728,   728,   705,   416,   416,   416,
     741,   416,   725,   794,   732,   731,   730,   416,   730,   415,
     705,   743,   730,    90,   170,   170,   730,   416,   170,   730,
     676,   676,   676,   676,   775,   775,   670,   694,   695,    93,
     696,   909,   421,   137,   189,   209,   224,   231,   249,   310,
     389,   697,   696,    93,   696,   909,   762,   194,   687,   416,
     416,   421,   402,   416,   899,   402,   421,   151,   730,   415,
     935,   392,   813,   351,   351,   416,   497,   497,   416,   410,
     351,   351,   351,   488,   257,   257,   336,   339,   705,   777,
     777,   221,   416,   221,   221,   569,   569,   431,   158,   153,
     208,   257,   539,   540,   541,   790,   383,   384,   414,   416,
     707,   707,   707,   707,   707,   706,   729,   775,   415,   777,
     731,   154,   200,   153,   262,   225,   775,   372,   508,   705,
     775,   183,   533,   275,   704,   484,   173,   204,   493,   207,
     504,   486,   514,   909,    93,    93,   669,   226,   523,   561,
     794,   779,   415,    93,   110,   177,   201,   227,   308,   319,
     333,   340,   380,   598,   599,   156,   213,   320,   369,   622,
     498,   470,   668,   889,   893,   193,   577,   772,   415,   470,
     730,   416,   416,   416,   416,   416,   752,   188,   266,   415,
     416,   729,   743,   416,   421,   731,   730,   730,   170,   730,
     416,   775,   775,   775,   775,   416,   909,   415,   694,   224,
     278,   698,   694,   698,   224,   697,   698,   694,   224,   415,
     909,   415,   108,   196,   688,   892,   407,   786,   789,   792,
     793,   794,   415,   768,   606,   909,   799,   777,   416,   416,
     508,   361,   799,   777,   799,   262,   262,   790,   909,   372,
     471,   569,   221,   569,   569,   476,   794,   154,   200,   153,
     541,   540,   414,   190,   190,   188,   538,   730,   257,   490,
     508,   496,   206,   372,   415,   165,   534,   174,   532,   416,
     152,   152,   415,   383,   384,   505,   794,   188,   415,   585,
     586,   733,   909,   594,   794,   271,   319,   457,   262,   155,
     220,   383,   599,   600,   351,   183,   274,   771,   731,   415,
     731,   416,   705,   730,   696,   415,   776,   694,   271,   372,
     699,   694,   224,   694,   703,   415,   703,   909,   741,   730,
     785,   786,   729,   730,   769,   416,   298,   508,   730,   569,
     104,   138,   157,   170,   184,   262,   269,   294,   477,   581,
      93,   608,   775,   539,   416,   240,   499,   344,   779,   312,
     335,   535,   293,   505,   774,   269,   269,   271,   506,   560,
     730,   416,   421,   372,   560,   587,   587,   421,   262,   155,
     220,   271,   547,   775,   416,   731,   416,   776,   416,   730,
     415,   694,   699,   416,   703,   416,   421,   416,   775,   643,
     643,   257,   294,   643,   643,   608,    96,   183,   189,   282,
     271,   500,   501,   502,   777,    93,   777,   506,   416,   127,
     344,   507,   416,   507,   586,   560,   794,   211,   262,   702,
     416,   416,   776,   416,   769,   496,   794,   789,   262,   497,
     794,   789,   165,   156,   369,   271,   502,   271,   501,   190,
     273,   339,   552,   553,   415,   507,   156,   164,   287,   777,
     587,   702,   211,   161,   416,   499,   497,   312,   111,   253,
     307,   325,   503,   503,   790,   790,   705,   421,   536,   537,
     798,   909,   313,   313,    86,   214,   623,   500,   174,    81,
     151,   262,   783,   606,   553,   416,   421,   258,   415,   618,
     620,   625,   656,   660,   665,   669,   539,   293,   590,   297,
     415,   555,   537,   619,   620,   621,   670,   671,   783,   605,
     416,   418,   415,   416,   621,   536,   555,   416
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1

/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 5:
#line 594 "preproc.y"
    { connection = NULL; }
    break;

  case 7:
#line 597 "preproc.y"
    {
			fprintf(yyout, "%s", yyvsp[0].str);
                        free(yyvsp[0].str);
			output_line_number();
		}
    break;

  case 9:
#line 603 "preproc.y"
    { fprintf(yyout, "%s", yyvsp[0].str); free(yyvsp[0].str); }
    break;

  case 10:
#line 604 "preproc.y"
    { fprintf(yyout, "%s", yyvsp[0].str); free(yyvsp[0].str); }
    break;

  case 11:
#line 605 "preproc.y"
    { braces_open++; fputs("{", yyout); }
    break;

  case 12:
#line 606 "preproc.y"
    { remove_typedefs(braces_open); remove_variables(braces_open--); fputs("}", yyout); }
    break;

  case 13:
#line 610 "preproc.y"
    {
			connection = yyvsp[0].str;
			/*
			 *	Do we have a variable as connection target?
			 *	Remove the variable from the variable
			 *	list or else it will be used twice
			 */
			if (argsinsert != NULL)
				argsinsert = NULL;
		}
    break;

  case 14:
#line 621 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 15:
#line 622 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 16:
#line 623 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 17:
#line 624 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 18:
#line 625 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 19:
#line 626 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 20:
#line 627 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 21:
#line 628 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 22:
#line 629 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 23:
#line 630 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 24:
#line 632 "preproc.y"
    {
			if (INFORMIX_MODE)
			{
				/* Informix also has a CLOSE DATABASE command that
				   essantially works like a DISCONNECT CURRENT 
				   as far as I know. */
				if (pg_strcasecmp(yyvsp[0].str+strlen("close "), "database") == 0)
				{
					if (connection)
		                                mmerror(PARSE_ERROR, ET_ERROR, "no at option for close database statement.\n");
								
					fprintf(yyout, "{ ECPGdisconnect(__LINE__, \"CURRENT\");");
		                        whenever_action(2);
		                        free(yyvsp[0].str);
				}
				else
					output_statement(yyvsp[0].str, 0, connection);
			}
			else
				output_statement(yyvsp[0].str, 0, connection);
		}
    break;

  case 25:
#line 653 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 26:
#line 654 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 27:
#line 655 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 28:
#line 656 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 29:
#line 657 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 30:
#line 658 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 31:
#line 659 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 32:
#line 660 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 33:
#line 661 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 34:
#line 662 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 35:
#line 663 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 36:
#line 664 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 37:
#line 665 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 38:
#line 666 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 39:
#line 667 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 40:
#line 668 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 41:
#line 669 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 42:
#line 670 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 43:
#line 671 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 44:
#line 672 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 45:
#line 674 "preproc.y"
    { output_simple_statement(yyvsp[0].str); }
    break;

  case 46:
#line 675 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 47:
#line 676 "preproc.y"
    { output_statement(yyvsp[0].str, 1, connection); }
    break;

  case 48:
#line 677 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 49:
#line 678 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 50:
#line 679 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 51:
#line 680 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 52:
#line 681 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 53:
#line 682 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 54:
#line 683 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 55:
#line 684 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 56:
#line 685 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 57:
#line 686 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 58:
#line 687 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 59:
#line 688 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 60:
#line 690 "preproc.y"
    { output_statement(yyvsp[0].str, 1, connection); }
    break;

  case 61:
#line 691 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 62:
#line 692 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 63:
#line 693 "preproc.y"
    { output_statement(yyvsp[0].str, 1, connection); }
    break;

  case 64:
#line 694 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 65:
#line 695 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 66:
#line 696 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 67:
#line 697 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 68:
#line 699 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 69:
#line 700 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 70:
#line 701 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 71:
#line 702 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 72:
#line 703 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 73:
#line 704 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 74:
#line 705 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 75:
#line 706 "preproc.y"
    { output_statement(yyvsp[0].str, 1, connection); }
    break;

  case 76:
#line 708 "preproc.y"
    {
			fprintf(yyout, "{ ECPGtrans(__LINE__, %s, \"%s\");", connection ? connection : "NULL", yyvsp[0].str);
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 77:
#line 713 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 78:
#line 714 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 79:
#line 715 "preproc.y"
    { output_statement(yyvsp[0].str, 1, connection); }
    break;

  case 80:
#line 716 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 81:
#line 717 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 82:
#line 718 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 83:
#line 719 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 84:
#line 720 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 85:
#line 722 "preproc.y"
    {
			fprintf(yyout,"ECPGallocate_desc(__LINE__, %s);",yyvsp[0].str);
			whenever_action(0);
			free(yyvsp[0].str);
		}
    break;

  case 86:
#line 728 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for connect statement.\n");

			fprintf(yyout, "{ ECPGconnect(__LINE__, %d, %s, %d); ", compat, yyvsp[0].str, autocommit);
			reset_variables();
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 87:
#line 738 "preproc.y"
    {
			output_simple_statement(yyvsp[0].str);
		}
    break;

  case 88:
#line 742 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for deallocate statement.\n");
			fprintf(yyout, "{ ECPGdeallocate(__LINE__, %d, %s);", compat, yyvsp[0].str);
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 89:
#line 750 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for deallocate statement.\n");
			fprintf(yyout,"ECPGdeallocate_desc(__LINE__, %s);",yyvsp[0].str);
			whenever_action(0);
			free(yyvsp[0].str);
		}
    break;

  case 90:
#line 758 "preproc.y"
    {
			output_simple_statement(yyvsp[0].str);
		}
    break;

  case 91:
#line 762 "preproc.y"
    {
			fprint