/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSEXTBlendMinMax.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

class JSEXTBlendMinMaxPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSEXTBlendMinMaxPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEXTBlendMinMaxPrototype* ptr = new (NotNull, JSC::allocateCell<JSEXTBlendMinMaxPrototype>(vm)) JSEXTBlendMinMaxPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTBlendMinMaxPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSEXTBlendMinMaxPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTBlendMinMaxPrototype, JSEXTBlendMinMaxPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSEXTBlendMinMaxPrototypeTableValues[] =
{
    { "MIN_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8007 } },
    { "MAX_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8008 } },
};

const ClassInfo JSEXTBlendMinMaxPrototype::s_info = { "EXTBlendMinMax"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTBlendMinMaxPrototype) };

void JSEXTBlendMinMaxPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSEXTBlendMinMax::info(), JSEXTBlendMinMaxPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSEXTBlendMinMax::s_info = { "EXTBlendMinMax"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTBlendMinMax) };

JSEXTBlendMinMax::JSEXTBlendMinMax(Structure* structure, JSDOMGlobalObject& globalObject, Ref<EXTBlendMinMax>&& impl)
    : JSDOMWrapper<EXTBlendMinMax>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, EXTBlendMinMax>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSEXTBlendMinMax::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSEXTBlendMinMaxPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSEXTBlendMinMaxPrototype::create(vm, &globalObject, structure);
}

JSObject* JSEXTBlendMinMax::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSEXTBlendMinMax>(vm, globalObject);
}

void JSEXTBlendMinMax::destroy(JSC::JSCell* cell)
{
    JSEXTBlendMinMax* thisObject = static_cast<JSEXTBlendMinMax*>(cell);
    thisObject->JSEXTBlendMinMax::~JSEXTBlendMinMax();
}

JSC::GCClient::IsoSubspace* JSEXTBlendMinMax::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSEXTBlendMinMax, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForEXTBlendMinMax.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForEXTBlendMinMax = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForEXTBlendMinMax.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForEXTBlendMinMax = std::forward<decltype(space)>(space); }
    );
}

void JSEXTBlendMinMax::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSEXTBlendMinMax*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSEXTBlendMinMaxOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsEXTBlendMinMax = jsCast<JSEXTBlendMinMax*>(handle.slot()->asCell());
    auto& owner = jsEXTBlendMinMax->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsEXTBlendMinMax"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSEXTBlendMinMaxOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsEXTBlendMinMax = static_cast<JSEXTBlendMinMax*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsEXTBlendMinMax->protectedWrapped().ptr(), jsEXTBlendMinMax);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7EXTBlendMinMax@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14EXTBlendMinMaxE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, EXTBlendMinMax>, void>> static inline void verifyVTable(EXTBlendMinMax* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7EXTBlendMinMax@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore14EXTBlendMinMaxE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // EXTBlendMinMax has subclasses. If EXTBlendMinMax has subclasses that get passed
        // to toJS() we currently require EXTBlendMinMax you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<EXTBlendMinMax>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<EXTBlendMinMax>(impl.ptr());
#endif
    return createWrapper<EXTBlendMinMax>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, EXTBlendMinMax& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

EXTBlendMinMax* JSEXTBlendMinMax::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSEXTBlendMinMax*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
