/*
 * THIS FILE WAS AUTOMATICALLY GENERATED, DO NOT EDIT.
 *
 * Copyright (C) 2024 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "SharedPreferencesForWebProcess.h"

#include "WebPreferencesKeys.h"
#include "WebPreferencesStore.h"

namespace WebKit {

SharedPreferencesForWebProcess sharedPreferencesForWebProcess(const WebPreferencesStore& preferencesStore)
{
    SharedPreferencesForWebProcess sharedPreferences;
        sharedPreferences.allowTestOnlyIPC = preferencesStore.getBoolValueForKey(WebPreferencesKey::allowTestOnlyIPCKey());
#if ENABLE(ENCRYPTED_MEDIA)
        sharedPreferences.encryptedMediaAPIEnabled = preferencesStore.getBoolValueForKey(WebPreferencesKey::encryptedMediaAPIEnabledKey());
#endif
        sharedPreferences.usesSingleWebProcess = preferencesStore.getBoolValueForKey(WebPreferencesKey::usesSingleWebProcessKey());
        sharedPreferences.appBadgeEnabled = preferencesStore.getBoolValueForKey(WebPreferencesKey::appBadgeEnabledKey());
#if ENABLE(ATTACHMENT_ELEMENT)
        sharedPreferences.attachmentElementEnabled = preferencesStore.getBoolValueForKey(WebPreferencesKey::attachmentElementEnabledKey());
#endif
#if ENABLE(INPUT_TYPE_COLOR)
        sharedPreferences.inputTypeColorEnabled = preferencesStore.getBoolValueForKey(WebPreferencesKey::inputTypeColorEnabledKey());
#endif
        sharedPreferences.contactPickerAPIEnabled = preferencesStore.getBoolValueForKey(WebPreferencesKey::contactPickerAPIEnabledKey());
#if ENABLE(DATALIST_ELEMENT)
        sharedPreferences.dataListElementEnabled = preferencesStore.getBoolValueForKey(WebPreferencesKey::dataListElementEnabledKey());
#endif
#if ENABLE(RE_DYNAMIC_CONTENT_SCALING)
        sharedPreferences.useCGDisplayListsForDOMRendering = preferencesStore.getBoolValueForKey(WebPreferencesKey::useCGDisplayListsForDOMRenderingKey());
#endif
        sharedPreferences.blobFileAccessEnforcementEnabled = preferencesStore.getBoolValueForKey(WebPreferencesKey::blobFileAccessEnforcementEnabledKey());
#if ENABLE(MEDIA_SESSION_COORDINATOR)
        sharedPreferences.mediaSessionCoordinatorEnabled = preferencesStore.getBoolValueForKey(WebPreferencesKey::mediaSessionCoordinatorEnabledKey());
#endif
#if ENABLE(FULLSCREEN_API)
        sharedPreferences.fullScreenEnabled = preferencesStore.getBoolValueForKey(WebPreferencesKey::fullScreenEnabledKey());
#endif
#if ENABLE(GPU_PROCESS)
        sharedPreferences.useGPUProcessForDOMRenderingEnabled = preferencesStore.getBoolValueForKey(WebPreferencesKey::useGPUProcessForDOMRenderingEnabledKey());
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
        sharedPreferences.useGPUProcessForWebGLEnabled = preferencesStore.getBoolValueForKey(WebPreferencesKey::useGPUProcessForWebGLEnabledKey());
#endif
#if ENABLE(GAMEPAD)
        sharedPreferences.gamepadsEnabled = preferencesStore.getBoolValueForKey(WebPreferencesKey::gamepadsEnabledKey());
#endif
#if ENABLE(MODEL_ELEMENT)
        sharedPreferences.modelElementEnabled = preferencesStore.getBoolValueForKey(WebPreferencesKey::modelElementEnabledKey());
#endif
        sharedPreferences.ignoreIframeEmbeddingProtectionsEnabled = preferencesStore.getBoolValueForKey(WebPreferencesKey::ignoreIframeEmbeddingProtectionsEnabledKey());
        sharedPreferences.lockdownFontParserEnabled = preferencesStore.getBoolValueForKey(WebPreferencesKey::lockdownFontParserEnabledKey());
        sharedPreferences.serviceWorkersEnabled = preferencesStore.getBoolValueForKey(WebPreferencesKey::serviceWorkersEnabledKey());
        sharedPreferences.shapeDetection = preferencesStore.getBoolValueForKey(WebPreferencesKey::shapeDetectionKey());
        sharedPreferences.siteIsolationEnabled = preferencesStore.getBoolValueForKey(WebPreferencesKey::siteIsolationEnabledKey());
        sharedPreferences.speechRecognitionEnabled = preferencesStore.getBoolValueForKey(WebPreferencesKey::speechRecognitionEnabledKey());
        sharedPreferences.speechSynthesisAPIEnabled = preferencesStore.getBoolValueForKey(WebPreferencesKey::speechSynthesisAPIEnabledKey());
#if ENABLE(IMAGE_ANALYSIS) && ENABLE(VIDEO)
        sharedPreferences.textRecognitionInVideosEnabled = preferencesStore.getBoolValueForKey(WebPreferencesKey::textRecognitionInVideosEnabledKey());
#endif
#if ENABLE(WEB_AUTHN)
        sharedPreferences.webAuthenticationEnabled = preferencesStore.getBoolValueForKey(WebPreferencesKey::webAuthenticationEnabledKey());
#endif
        sharedPreferences.webLocksAPIEnabled = preferencesStore.getBoolValueForKey(WebPreferencesKey::webLocksAPIEnabledKey());
        sharedPreferences.webGLEnabled = preferencesStore.getBoolValueForKey(WebPreferencesKey::webGLEnabledKey());
        sharedPreferences.webGPUEnabled = preferencesStore.getBoolValueForKey(WebPreferencesKey::webGPUEnabledKey());
        sharedPreferences.webTransportEnabled = preferencesStore.getBoolValueForKey(WebPreferencesKey::webTransportEnabledKey());
#if ENABLE(WEBXR)
        sharedPreferences.webXREnabled = preferencesStore.getBoolValueForKey(WebPreferencesKey::webXREnabledKey());
#endif
    return sharedPreferences;
}

bool updateSharedPreferencesForWebProcess(SharedPreferencesForWebProcess& sharedPreferences, const WebPreferencesStore& preferencesStore)
{
    bool didChange = false;
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::allowTestOnlyIPCKey()) && !sharedPreferences.allowTestOnlyIPC) {
        sharedPreferences.allowTestOnlyIPC = true;
        didChange = true;
    }
#if ENABLE(ENCRYPTED_MEDIA)
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::encryptedMediaAPIEnabledKey()) && !sharedPreferences.encryptedMediaAPIEnabled) {
        sharedPreferences.encryptedMediaAPIEnabled = true;
        didChange = true;
    }
#endif
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::usesSingleWebProcessKey()) && !sharedPreferences.usesSingleWebProcess) {
        sharedPreferences.usesSingleWebProcess = true;
        didChange = true;
    }
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::appBadgeEnabledKey()) && !sharedPreferences.appBadgeEnabled) {
        sharedPreferences.appBadgeEnabled = true;
        didChange = true;
    }
#if ENABLE(ATTACHMENT_ELEMENT)
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::attachmentElementEnabledKey()) && !sharedPreferences.attachmentElementEnabled) {
        sharedPreferences.attachmentElementEnabled = true;
        didChange = true;
    }
#endif
#if ENABLE(INPUT_TYPE_COLOR)
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::inputTypeColorEnabledKey()) && !sharedPreferences.inputTypeColorEnabled) {
        sharedPreferences.inputTypeColorEnabled = true;
        didChange = true;
    }
#endif
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::contactPickerAPIEnabledKey()) && !sharedPreferences.contactPickerAPIEnabled) {
        sharedPreferences.contactPickerAPIEnabled = true;
        didChange = true;
    }
#if ENABLE(DATALIST_ELEMENT)
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::dataListElementEnabledKey()) && !sharedPreferences.dataListElementEnabled) {
        sharedPreferences.dataListElementEnabled = true;
        didChange = true;
    }
#endif
#if ENABLE(RE_DYNAMIC_CONTENT_SCALING)
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::useCGDisplayListsForDOMRenderingKey()) && !sharedPreferences.useCGDisplayListsForDOMRendering) {
        sharedPreferences.useCGDisplayListsForDOMRendering = true;
        didChange = true;
    }
#endif
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::blobFileAccessEnforcementEnabledKey()) && !sharedPreferences.blobFileAccessEnforcementEnabled) {
        sharedPreferences.blobFileAccessEnforcementEnabled = true;
        didChange = true;
    }
#if ENABLE(MEDIA_SESSION_COORDINATOR)
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::mediaSessionCoordinatorEnabledKey()) && !sharedPreferences.mediaSessionCoordinatorEnabled) {
        sharedPreferences.mediaSessionCoordinatorEnabled = true;
        didChange = true;
    }
#endif
#if ENABLE(FULLSCREEN_API)
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::fullScreenEnabledKey()) && !sharedPreferences.fullScreenEnabled) {
        sharedPreferences.fullScreenEnabled = true;
        didChange = true;
    }
#endif
#if ENABLE(GPU_PROCESS)
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::useGPUProcessForDOMRenderingEnabledKey()) && !sharedPreferences.useGPUProcessForDOMRenderingEnabled) {
        sharedPreferences.useGPUProcessForDOMRenderingEnabled = true;
        didChange = true;
    }
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::useGPUProcessForWebGLEnabledKey()) && !sharedPreferences.useGPUProcessForWebGLEnabled) {
        sharedPreferences.useGPUProcessForWebGLEnabled = true;
        didChange = true;
    }
#endif
#if ENABLE(GAMEPAD)
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::gamepadsEnabledKey()) && !sharedPreferences.gamepadsEnabled) {
        sharedPreferences.gamepadsEnabled = true;
        didChange = true;
    }
#endif
#if ENABLE(MODEL_ELEMENT)
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::modelElementEnabledKey()) && !sharedPreferences.modelElementEnabled) {
        sharedPreferences.modelElementEnabled = true;
        didChange = true;
    }
#endif
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::ignoreIframeEmbeddingProtectionsEnabledKey()) && !sharedPreferences.ignoreIframeEmbeddingProtectionsEnabled) {
        sharedPreferences.ignoreIframeEmbeddingProtectionsEnabled = true;
        didChange = true;
    }
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::lockdownFontParserEnabledKey()) && !sharedPreferences.lockdownFontParserEnabled) {
        sharedPreferences.lockdownFontParserEnabled = true;
        didChange = true;
    }
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::serviceWorkersEnabledKey()) && !sharedPreferences.serviceWorkersEnabled) {
        sharedPreferences.serviceWorkersEnabled = true;
        didChange = true;
    }
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::shapeDetectionKey()) && !sharedPreferences.shapeDetection) {
        sharedPreferences.shapeDetection = true;
        didChange = true;
    }
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::siteIsolationEnabledKey()) && !sharedPreferences.siteIsolationEnabled) {
        sharedPreferences.siteIsolationEnabled = true;
        didChange = true;
    }
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::speechRecognitionEnabledKey()) && !sharedPreferences.speechRecognitionEnabled) {
        sharedPreferences.speechRecognitionEnabled = true;
        didChange = true;
    }
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::speechSynthesisAPIEnabledKey()) && !sharedPreferences.speechSynthesisAPIEnabled) {
        sharedPreferences.speechSynthesisAPIEnabled = true;
        didChange = true;
    }
#if ENABLE(IMAGE_ANALYSIS) && ENABLE(VIDEO)
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::textRecognitionInVideosEnabledKey()) && !sharedPreferences.textRecognitionInVideosEnabled) {
        sharedPreferences.textRecognitionInVideosEnabled = true;
        didChange = true;
    }
#endif
#if ENABLE(WEB_AUTHN)
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::webAuthenticationEnabledKey()) && !sharedPreferences.webAuthenticationEnabled) {
        sharedPreferences.webAuthenticationEnabled = true;
        didChange = true;
    }
#endif
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::webLocksAPIEnabledKey()) && !sharedPreferences.webLocksAPIEnabled) {
        sharedPreferences.webLocksAPIEnabled = true;
        didChange = true;
    }
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::webGLEnabledKey()) && !sharedPreferences.webGLEnabled) {
        sharedPreferences.webGLEnabled = true;
        didChange = true;
    }
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::webGPUEnabledKey()) && !sharedPreferences.webGPUEnabled) {
        sharedPreferences.webGPUEnabled = true;
        didChange = true;
    }
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::webTransportEnabledKey()) && !sharedPreferences.webTransportEnabled) {
        sharedPreferences.webTransportEnabled = true;
        didChange = true;
    }
#if ENABLE(WEBXR)
    if (preferencesStore.getBoolValueForKey(WebPreferencesKey::webXREnabledKey()) && !sharedPreferences.webXREnabled) {
        sharedPreferences.webXREnabled = true;
        didChange = true;
    }
#endif
    return didChange;
}

} // namespace WebKit
