/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Color;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.gdi.AbstractPen;

public class LogPen
extends AbstractPen {
    private int penStyle;
    private int width;
    private Color color;

    public LogPen(int penStyle, int width, Color color) {
        this.penStyle = penStyle;
        this.width = width;
        this.color = color;
    }

    public LogPen(EMFInputStream emf) throws IOException {
        this.penStyle = emf.readDWORD();
        this.width = emf.readDWORD();
        emf.readDWORD();
        this.color = emf.readCOLORREF();
    }

    public void write(EMFOutputStream emf) throws IOException {
        emf.writeDWORD(this.penStyle);
        emf.writeDWORD(this.width);
        emf.writeDWORD(0);
        emf.writeCOLORREF(this.color);
    }

    public String toString() {
        return "  LogPen\n    penstyle: " + this.penStyle + "\n    width: " + this.width + "\n    color: " + this.color;
    }

    @Override
    public void render(EMFRenderer renderer) {
        renderer.setUseCreatePen(true);
        renderer.setPenPaint(this.color);
        renderer.setPenStroke(this.createStroke(renderer, this.penStyle, null, this.width));
    }
}

