/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.interpreter;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.dataflow.DataFlowProblem;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.LabelInstr;
import org.jruby.ir.instructions.ReceiveSelfInstr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.Site;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.TemporaryBooleanVariable;
import org.jruby.ir.operands.TemporaryClosureVariable;
import org.jruby.ir.operands.TemporaryFixnumVariable;
import org.jruby.ir.operands.TemporaryFloatVariable;
import org.jruby.ir.operands.TemporaryLocalReplacementVariable;
import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.TemporaryVariableType;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.CFG;
import org.jruby.ir.representations.CFGLinearizer;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;

public class FullInterpreterContext
extends InterpreterContext {
    private final CFG cfg;
    private BasicBlock[] linearizedBBList = null;
    private Map<String, DataFlowProblem> dataFlowProblems;
    private final List<CompilerPass> executedPasses = new ArrayList<CompilerPass>();
    private Set<LocalVariable> definedLocalVars;
    private Set<LocalVariable> usedLocalVars;
    public int floatVariableIndex = -1;
    public int fixnumVariableIndex = -1;
    public int booleanVariableIndex = -1;

    public FullInterpreterContext(IRScope scope, CFG cfg, BasicBlock[] linearizedBBList, int temporaryVariableCount, EnumSet<IRFlags> flags2) {
        super(scope, (List<Instr>)null, temporaryVariableCount, flags2);
        this.cfg = cfg;
        this.linearizedBBList = linearizedBBList;
    }

    public FullInterpreterContext(IRScope scope, Instr[] instructions, int temporaryVariableCount, EnumSet<IRFlags> flags2) {
        super(scope, (List<Instr>)null, temporaryVariableCount, flags2);
        this.cfg = this.buildCFG(instructions);
    }

    public BasicBlock[] linearizeBasicBlocks() {
        this.linearizedBBList = CFGLinearizer.linearize(this.cfg);
        return this.linearizedBBList;
    }

    private CFG buildCFG(Instr[] instructions) {
        CFG newCFG = new CFG(this.getScope());
        newCFG.build(instructions);
        return newCFG;
    }

    @Override
    public boolean hasExplicitCallProtocol() {
        return this.hasExplicitCallProtocol;
    }

    public boolean needsBinding() {
        return this.reuseParentDynScope() || !this.isDynamicScopeEliminated();
    }

    public void generateInstructionsForInterpretation() {
        this.linearizeBasicBlocks();
        ArrayList<Instr> newInstrs = new ArrayList<Instr>();
        int ipc = 0;
        for (BasicBlock b2 : this.getLinearizedBBList()) {
            b2.getLabel().setTargetPC(ipc);
            List<Instr> bbInstrs = b2.getInstrs();
            int bbInstrsLength = bbInstrs.size();
            for (int i2 = 0; i2 < bbInstrsLength; ++i2) {
                Instr instr = bbInstrs.get(i2);
                if (instr instanceof ReceiveSelfInstr) continue;
                if (instr instanceof LabelInstr) {
                    ((LabelInstr)instr).getLabel().setTargetPC(ipc);
                }
                newInstrs.add(instr);
                ++ipc;
            }
        }
        this.cfg.getExitBB().getLabel().setTargetPC(ipc + 1);
        Instr[] linearizedInstrArray = newInstrs.toArray(new Instr[newInstrs.size()]);
        BasicBlock[] basicBlocks = this.getLinearizedBBList();
        this.rescueIPCs = new int[2 * basicBlocks.length];
        ipc = 0;
        for (int i3 = 0; i3 < basicBlocks.length; ++i3) {
            BasicBlock bb = basicBlocks[i3];
            BasicBlock rescuerBB = this.cfg.getRescuerBBFor(bb);
            int rescuerPC = rescuerBB == null ? -1 : rescuerBB.getLabel().getTargetPC();
            this.rescueIPCs[i3 * 2] = ipc + bb.getInstrs().size();
            this.rescueIPCs[i3 * 2 + 1] = rescuerPC;
            for (Instr instr : bb.getInstrs()) {
                if (!(instr instanceof ReceiveSelfInstr)) {
                    ++ipc;
                    continue;
                }
                int n = i3 * 2;
                this.rescueIPCs[n] = this.rescueIPCs[n] - 1;
            }
        }
        this.instructions = linearizedInstrArray;
    }

    @Override
    public CFG getCFG() {
        return this.cfg;
    }

    @Override
    public void computeScopeFlagsFromInstructions() {
        for (BasicBlock b2 : this.cfg.getBasicBlocks()) {
            for (Instr i2 : b2.getInstrs()) {
                i2.computeScopeFlags(this.getScope(), this.getFlags());
            }
        }
    }

    public Map<String, DataFlowProblem> getDataFlowProblems() {
        if (this.dataFlowProblems == null) {
            this.dataFlowProblems = new HashMap<String, DataFlowProblem>();
        }
        return this.dataFlowProblems;
    }

    public List<CompilerPass> getExecutedPasses() {
        return this.executedPasses;
    }

    public BasicBlock[] getLinearizedBBList() {
        return this.linearizedBBList;
    }

    @Override
    public String toStringInstrs() {
        return "\nCFG:\n" + this.cfg.toStringGraph() + "\nInstructions:\n" + this.cfg.toStringInstrs();
    }

    public String toStringLinearized() {
        StringBuilder buf = new StringBuilder();
        for (BasicBlock bb : this.getLinearizedBBList()) {
            buf.append(bb + bb.toStringInstrs());
        }
        return buf.toString();
    }

    public FullInterpreterContext duplicate() {
        try {
            CFG newCFG = this.cfg.clone(new SimpleCloneInfo(this.getScope(), false, true), this.getScope());
            BasicBlock[] newLinearizedBBList = new BasicBlock[this.linearizedBBList.length];
            for (int i2 = 0; i2 < this.linearizedBBList.length; ++i2) {
                newLinearizedBBList[i2] = newCFG.getBBForLabel(this.linearizedBBList[i2].getLabel());
            }
            return new FullInterpreterContext(this.getScope(), newCFG, newLinearizedBBList, this.temporaryVariableCount, this.getFlags());
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public int determineRPC(int ipc) {
        int length2 = this.rescueIPCs.length;
        int i2 = 0;
        while (i2 + 1 < length2) {
            if (ipc <= this.rescueIPCs[i2]) {
                return this.rescueIPCs[i2 + 1];
            }
            i2 += 2;
        }
        throw new RuntimeException("BUG: no RPC found for " + this.getFileName() + ":" + this.getName() + ":" + ipc);
    }

    public BasicBlock findBasicBlockOf(long callsiteId) {
        for (BasicBlock basicBlock : this.linearizeBasicBlocks()) {
            for (Instr instr : basicBlock.getInstrs()) {
                Site site;
                if (!(instr instanceof Site) || (site = (Site)((Object)instr)).getCallSiteId() != callsiteId) continue;
                return basicBlock;
            }
        }
        throw new RuntimeException("Bug: Looking for callsiteId: " + callsiteId + " in " + this);
    }

    public Set<LocalVariable> getUsedLocalVariables() {
        return this.usedLocalVars;
    }

    public void setUpUseDefLocalVarMaps() {
        this.definedLocalVars = new HashSet<LocalVariable>(1);
        this.usedLocalVars = new HashSet<LocalVariable>(1);
        for (BasicBlock bb : this.getCFG().getBasicBlocks()) {
            for (Instr i2 : bb.getInstrs()) {
                Variable v;
                for (Variable v2 : i2.getUsedVariables()) {
                    if (!(v2 instanceof LocalVariable)) continue;
                    this.usedLocalVars.add((LocalVariable)v2);
                }
                if (!(i2 instanceof ResultInstr) || !((v = ((ResultInstr)((Object)i2)).getResult()) instanceof LocalVariable) || ((LocalVariable)v).isOuterScopeVar()) continue;
                this.definedLocalVars.add((LocalVariable)v);
            }
        }
        for (IRClosure cl : this.getScope().getClosures()) {
            cl.getFullInterpreterContext().setUpUseDefLocalVarMaps();
        }
    }

    public boolean usesLocalVariable(Variable v) {
        if (this.usedLocalVars == null) {
            this.setUpUseDefLocalVarMaps();
        }
        if (this.usedLocalVars.contains(v)) {
            return true;
        }
        for (IRClosure cl : this.getScope().getClosures()) {
            if (!cl.getFullInterpreterContext().usesLocalVariable(v)) continue;
            return true;
        }
        return false;
    }

    public boolean definesLocalVariable(Variable v) {
        if (this.definedLocalVars == null) {
            this.setUpUseDefLocalVarMaps();
        }
        if (this.definedLocalVars.contains(v)) {
            return true;
        }
        for (IRClosure cl : this.getScope().getClosures()) {
            if (!cl.getFullInterpreterContext().definesLocalVariable(v)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void initialize() {
    }

    public TemporaryVariable createTemporaryVariable() {
        ++this.temporaryVariableCount;
        if (this.getScope().getScopeType() == IRScopeType.CLOSURE) {
            return new TemporaryClosureVariable(((IRClosure)this.getScope()).closureId, this.temporaryVariableCount - 1);
        }
        return this.getScope().getManager().newTemporaryLocalVariable(this.temporaryVariableCount - 1);
    }

    public TemporaryLocalVariable getNewTemporaryVariableFor(LocalVariable var) {
        ++this.temporaryVariableCount;
        return new TemporaryLocalReplacementVariable(var.getId(), this.temporaryVariableCount - 1);
    }

    public TemporaryLocalVariable getNewUnboxedVariable(Class type2) {
        TemporaryVariableType varType = type2 == Float.class ? TemporaryVariableType.FLOAT : (type2 == Fixnum.class ? TemporaryVariableType.FIXNUM : (type2 == Boolean.class ? TemporaryVariableType.BOOLEAN : (type2 == Integer.class ? TemporaryVariableType.INT : TemporaryVariableType.LOCAL)));
        return this.getNewTemporaryVariable(varType);
    }

    public TemporaryLocalVariable getNewTemporaryVariable(TemporaryVariableType type2) {
        switch (type2) {
            case FLOAT: {
                ++this.floatVariableIndex;
                return new TemporaryFloatVariable(this.floatVariableIndex);
            }
            case FIXNUM: {
                ++this.fixnumVariableIndex;
                return new TemporaryFixnumVariable(this.fixnumVariableIndex);
            }
            case BOOLEAN: {
                ++this.booleanVariableIndex;
                return new TemporaryBooleanVariable(this.booleanVariableIndex);
            }
            case LOCAL: {
                return this.getScope().getManager().newTemporaryLocalVariable(this.temporaryVariableCount - 1);
            }
            case INT: {
                return this.getScope().getManager().newTemporaryIntVariable(this.temporaryVariableCount - 1);
            }
        }
        throw new RuntimeException("Invalid temporary variable being alloced in this scope: " + (Object)((Object)type2));
    }

    public boolean needsFrame() {
        boolean bindingHasEscaped = this.bindingHasEscaped();
        boolean requireFrame = bindingHasEscaped || this.getScope().usesEval() || this.getScope().usesZSuper() || this.getScope().canCaptureCallersBinding();
        for (IRFlags flag : this.getFlags()) {
            switch (flag) {
                case BINDING_HAS_ESCAPED: 
                case REQUIRES_LASTLINE: 
                case REQUIRES_BACKREF: 
                case REQUIRES_VISIBILITY: 
                case REQUIRES_BLOCK: 
                case REQUIRES_SELF: 
                case REQUIRES_METHODNAME: 
                case REQUIRES_CLASS: {
                    requireFrame = true;
                }
            }
        }
        return requireFrame;
    }

    public boolean bindingHasEscaped() {
        return this.getFlags().contains((Object)IRFlags.BINDING_HAS_ESCAPED);
    }

    public boolean needsOnlyBackref() {
        if (this.getScope().usesEval() || this.getScope().usesZSuper() || this.getScope().canCaptureCallersBinding()) {
            return false;
        }
        boolean backrefSeen = false;
        for (IRFlags flag : this.getFlags()) {
            switch (flag) {
                case BINDING_HAS_ESCAPED: 
                case REQUIRES_LASTLINE: 
                case REQUIRES_VISIBILITY: 
                case REQUIRES_BLOCK: 
                case REQUIRES_SELF: 
                case REQUIRES_METHODNAME: 
                case REQUIRES_CLASS: {
                    return false;
                }
                case REQUIRES_BACKREF: {
                    backrefSeen = true;
                }
            }
        }
        return backrefSeen;
    }
}

