#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 postgresql-binary
version:              0.12.4
visibility:           public
id:                   postgresql-binary-0.12.4-GpOFt4xRW7920L7tTddwXO
key:                  postgresql-binary-0.12.4-GpOFt4xRW7920L7tTddwXO
license:              MIT
copyright:            (c) 2014, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/postgresql-binary 
synopsis:             Encoders and decoders for the PostgreSQL'\''s binary format
description:
    An API for dealing with PostgreSQL'\''s binary data format.

    It can be used to implement performant bindings to Postgres.
    E.g., <http://hackage.haskell.org/package/hasql "hasql">
    is based on this library.

    It supports all Postgres versions starting from 8.3
    and is tested against 8.3, 9.3 and 9.5
    with the @integer_datetimes@ setting off and on.

category:             PostgreSQL, Database, Codecs, Parsing
abi:                  b3ec768b1799500f4d79bc0fd5b07a6d
exposed:              True
exposed-modules:
    PostgreSQL.Binary.Data PostgreSQL.Binary.Decoding
    PostgreSQL.Binary.Encoding

hidden-modules:
    PostgreSQL.Binary.Encoding.Builders PostgreSQL.Binary.Prelude
    PostgreSQL.Binary.Integral PostgreSQL.Binary.Interval
    PostgreSQL.Binary.Numeric PostgreSQL.Binary.Time
    PostgreSQL.Binary.Inet PostgreSQL.Binary.BuilderPrim

import-dirs:          /usr/lib/ghc-8.10.5/site-local/postgresql-binary-0.12.4
library-dirs:         /usr/lib/ghc-8.10.5/site-local/postgresql-binary-0.12.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/postgresql-binary-0.12.4
hs-libraries:         HSpostgresql-binary-0.12.4-GpOFt4xRW7920L7tTddwXO
depends:
    aeson-1.5.6.0-IA546NaLWlLGqcowhw6tTs base-4.14.2.0
    binary-parser-0.5.7-L626XySs8IaIUdykTAGRv8 bytestring-0.10.12.0
    bytestring-strict-builder-0.4.5.4-EXyHRvCUxc0EosEM792RfA
    containers-0.6.4.1 network-ip-0.3.0.3-Lcni9tkgzTtBlo37y349LC
    scientific-0.3.7.0-Ea1GK6jx8XDEEsfAKxwFym text-1.2.4.1 time-1.9.3
    transformers-0.5.6.2
    unordered-containers-0.2.14.0-D9MLkVL2jXfKIhE8RrmI8O
    uuid-1.3.15-1ImEMMQejSB2yr2jhy0kUX
    vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp

haddock-interfaces:
    /usr/share/doc/haskell-postgresql-binary/html/postgresql-binary.haddock

haddock-html:         /usr/share/doc/haskell-postgresql-binary/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

