﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/swf/SWF_EXPORTS.h>
#include <aws/swf/SWFRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/swf/model/Decision.h>
#include <utility>

namespace Aws
{
namespace SWF
{
namespace Model
{

  /**
   * <p>Input data for a TaskCompleted response to a decision task.</p><p><h3>See
   * Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/swf-2012-01-25/RespondDecisionTaskCompletedInput">AWS
   * API Reference</a></p>
   */
  class RespondDecisionTaskCompletedRequest : public SWFRequest
  {
  public:
    AWS_SWF_API RespondDecisionTaskCompletedRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "RespondDecisionTaskCompleted"; }

    AWS_SWF_API Aws::String SerializePayload() const override;

    AWS_SWF_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;


    /**
     * <p>The <code>taskToken</code> from the <a>DecisionTask</a>.</p>  <p>
     * <code>taskToken</code> is generated by the service and should be treated as an
     * opaque value. If the task is passed to another process, its
     * <code>taskToken</code> must also be passed. This enables it to provide its
     * progress and respond with results.</p> 
     */
    inline const Aws::String& GetTaskToken() const{ return m_taskToken; }

    /**
     * <p>The <code>taskToken</code> from the <a>DecisionTask</a>.</p>  <p>
     * <code>taskToken</code> is generated by the service and should be treated as an
     * opaque value. If the task is passed to another process, its
     * <code>taskToken</code> must also be passed. This enables it to provide its
     * progress and respond with results.</p> 
     */
    inline bool TaskTokenHasBeenSet() const { return m_taskTokenHasBeenSet; }

    /**
     * <p>The <code>taskToken</code> from the <a>DecisionTask</a>.</p>  <p>
     * <code>taskToken</code> is generated by the service and should be treated as an
     * opaque value. If the task is passed to another process, its
     * <code>taskToken</code> must also be passed. This enables it to provide its
     * progress and respond with results.</p> 
     */
    inline void SetTaskToken(const Aws::String& value) { m_taskTokenHasBeenSet = true; m_taskToken = value; }

    /**
     * <p>The <code>taskToken</code> from the <a>DecisionTask</a>.</p>  <p>
     * <code>taskToken</code> is generated by the service and should be treated as an
     * opaque value. If the task is passed to another process, its
     * <code>taskToken</code> must also be passed. This enables it to provide its
     * progress and respond with results.</p> 
     */
    inline void SetTaskToken(Aws::String&& value) { m_taskTokenHasBeenSet = true; m_taskToken = std::move(value); }

    /**
     * <p>The <code>taskToken</code> from the <a>DecisionTask</a>.</p>  <p>
     * <code>taskToken</code> is generated by the service and should be treated as an
     * opaque value. If the task is passed to another process, its
     * <code>taskToken</code> must also be passed. This enables it to provide its
     * progress and respond with results.</p> 
     */
    inline void SetTaskToken(const char* value) { m_taskTokenHasBeenSet = true; m_taskToken.assign(value); }

    /**
     * <p>The <code>taskToken</code> from the <a>DecisionTask</a>.</p>  <p>
     * <code>taskToken</code> is generated by the service and should be treated as an
     * opaque value. If the task is passed to another process, its
     * <code>taskToken</code> must also be passed. This enables it to provide its
     * progress and respond with results.</p> 
     */
    inline RespondDecisionTaskCompletedRequest& WithTaskToken(const Aws::String& value) { SetTaskToken(value); return *this;}

    /**
     * <p>The <code>taskToken</code> from the <a>DecisionTask</a>.</p>  <p>
     * <code>taskToken</code> is generated by the service and should be treated as an
     * opaque value. If the task is passed to another process, its
     * <code>taskToken</code> must also be passed. This enables it to provide its
     * progress and respond with results.</p> 
     */
    inline RespondDecisionTaskCompletedRequest& WithTaskToken(Aws::String&& value) { SetTaskToken(std::move(value)); return *this;}

    /**
     * <p>The <code>taskToken</code> from the <a>DecisionTask</a>.</p>  <p>
     * <code>taskToken</code> is generated by the service and should be treated as an
     * opaque value. If the task is passed to another process, its
     * <code>taskToken</code> must also be passed. This enables it to provide its
     * progress and respond with results.</p> 
     */
    inline RespondDecisionTaskCompletedRequest& WithTaskToken(const char* value) { SetTaskToken(value); return *this;}


    /**
     * <p>The list of decisions (possibly empty) made by the decider while processing
     * this decision task. See the docs for the <a>Decision</a> structure for
     * details.</p>
     */
    inline const Aws::Vector<Decision>& GetDecisions() const{ return m_decisions; }

    /**
     * <p>The list of decisions (possibly empty) made by the decider while processing
     * this decision task. See the docs for the <a>Decision</a> structure for
     * details.</p>
     */
    inline bool DecisionsHasBeenSet() const { return m_decisionsHasBeenSet; }

    /**
     * <p>The list of decisions (possibly empty) made by the decider while processing
     * this decision task. See the docs for the <a>Decision</a> structure for
     * details.</p>
     */
    inline void SetDecisions(const Aws::Vector<Decision>& value) { m_decisionsHasBeenSet = true; m_decisions = value; }

    /**
     * <p>The list of decisions (possibly empty) made by the decider while processing
     * this decision task. See the docs for the <a>Decision</a> structure for
     * details.</p>
     */
    inline void SetDecisions(Aws::Vector<Decision>&& value) { m_decisionsHasBeenSet = true; m_decisions = std::move(value); }

    /**
     * <p>The list of decisions (possibly empty) made by the decider while processing
     * this decision task. See the docs for the <a>Decision</a> structure for
     * details.</p>
     */
    inline RespondDecisionTaskCompletedRequest& WithDecisions(const Aws::Vector<Decision>& value) { SetDecisions(value); return *this;}

    /**
     * <p>The list of decisions (possibly empty) made by the decider while processing
     * this decision task. See the docs for the <a>Decision</a> structure for
     * details.</p>
     */
    inline RespondDecisionTaskCompletedRequest& WithDecisions(Aws::Vector<Decision>&& value) { SetDecisions(std::move(value)); return *this;}

    /**
     * <p>The list of decisions (possibly empty) made by the decider while processing
     * this decision task. See the docs for the <a>Decision</a> structure for
     * details.</p>
     */
    inline RespondDecisionTaskCompletedRequest& AddDecisions(const Decision& value) { m_decisionsHasBeenSet = true; m_decisions.push_back(value); return *this; }

    /**
     * <p>The list of decisions (possibly empty) made by the decider while processing
     * this decision task. See the docs for the <a>Decision</a> structure for
     * details.</p>
     */
    inline RespondDecisionTaskCompletedRequest& AddDecisions(Decision&& value) { m_decisionsHasBeenSet = true; m_decisions.push_back(std::move(value)); return *this; }


    /**
     * <p>User defined context to add to workflow execution.</p>
     */
    inline const Aws::String& GetExecutionContext() const{ return m_executionContext; }

    /**
     * <p>User defined context to add to workflow execution.</p>
     */
    inline bool ExecutionContextHasBeenSet() const { return m_executionContextHasBeenSet; }

    /**
     * <p>User defined context to add to workflow execution.</p>
     */
    inline void SetExecutionContext(const Aws::String& value) { m_executionContextHasBeenSet = true; m_executionContext = value; }

    /**
     * <p>User defined context to add to workflow execution.</p>
     */
    inline void SetExecutionContext(Aws::String&& value) { m_executionContextHasBeenSet = true; m_executionContext = std::move(value); }

    /**
     * <p>User defined context to add to workflow execution.</p>
     */
    inline void SetExecutionContext(const char* value) { m_executionContextHasBeenSet = true; m_executionContext.assign(value); }

    /**
     * <p>User defined context to add to workflow execution.</p>
     */
    inline RespondDecisionTaskCompletedRequest& WithExecutionContext(const Aws::String& value) { SetExecutionContext(value); return *this;}

    /**
     * <p>User defined context to add to workflow execution.</p>
     */
    inline RespondDecisionTaskCompletedRequest& WithExecutionContext(Aws::String&& value) { SetExecutionContext(std::move(value)); return *this;}

    /**
     * <p>User defined context to add to workflow execution.</p>
     */
    inline RespondDecisionTaskCompletedRequest& WithExecutionContext(const char* value) { SetExecutionContext(value); return *this;}

  private:

    Aws::String m_taskToken;
    bool m_taskTokenHasBeenSet = false;

    Aws::Vector<Decision> m_decisions;
    bool m_decisionsHasBeenSet = false;

    Aws::String m_executionContext;
    bool m_executionContextHasBeenSet = false;
  };

} // namespace Model
} // namespace SWF
} // namespace Aws
