/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXPathEvaluator.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertXPathNSResolver.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSNode.h"
#include "JSXPathExpression.h"
#include "JSXPathNSResolver.h"
#include "JSXPathResult.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsXPathEvaluatorPrototypeFunction_createExpression);
static JSC_DECLARE_HOST_FUNCTION(jsXPathEvaluatorPrototypeFunction_createNSResolver);
static JSC_DECLARE_HOST_FUNCTION(jsXPathEvaluatorPrototypeFunction_evaluate);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsXPathEvaluatorConstructor);

class JSXPathEvaluatorPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSXPathEvaluatorPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSXPathEvaluatorPrototype* ptr = new (NotNull, JSC::allocateCell<JSXPathEvaluatorPrototype>(vm)) JSXPathEvaluatorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSXPathEvaluatorPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSXPathEvaluatorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSXPathEvaluatorPrototype, JSXPathEvaluatorPrototype::Base);

using JSXPathEvaluatorDOMConstructor = JSDOMConstructor<JSXPathEvaluator>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSXPathEvaluatorDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSXPathEvaluatorDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto object = XPathEvaluator::create();
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<XPathEvaluator>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<XPathEvaluator>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSXPathEvaluatorDOMConstructorConstruct, JSXPathEvaluatorDOMConstructor::construct);

template<> const ClassInfo JSXPathEvaluatorDOMConstructor::s_info = { "XPathEvaluator"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXPathEvaluatorDOMConstructor) };

template<> JSValue JSXPathEvaluatorDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSXPathEvaluatorDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "XPathEvaluator"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSXPathEvaluator::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSXPathEvaluatorPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsXPathEvaluatorConstructor, 0 } },
    { "createExpression"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsXPathEvaluatorPrototypeFunction_createExpression, 1 } },
    { "createNSResolver"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsXPathEvaluatorPrototypeFunction_createNSResolver, 1 } },
    { "evaluate"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsXPathEvaluatorPrototypeFunction_evaluate, 2 } },
};

const ClassInfo JSXPathEvaluatorPrototype::s_info = { "XPathEvaluator"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXPathEvaluatorPrototype) };

void JSXPathEvaluatorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSXPathEvaluator::info(), JSXPathEvaluatorPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSXPathEvaluator::s_info = { "XPathEvaluator"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXPathEvaluator) };

JSXPathEvaluator::JSXPathEvaluator(Structure* structure, JSDOMGlobalObject& globalObject, Ref<XPathEvaluator>&& impl)
    : JSDOMWrapper<XPathEvaluator>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, XPathEvaluator>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSXPathEvaluator::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSXPathEvaluatorPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSXPathEvaluatorPrototype::create(vm, &globalObject, structure);
}

JSObject* JSXPathEvaluator::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSXPathEvaluator>(vm, globalObject);
}

JSValue JSXPathEvaluator::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXPathEvaluatorDOMConstructor, DOMConstructorID::XPathEvaluator>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSXPathEvaluator::destroy(JSC::JSCell* cell)
{
    JSXPathEvaluator* thisObject = static_cast<JSXPathEvaluator*>(cell);
    thisObject->JSXPathEvaluator::~JSXPathEvaluator();
}

JSC_DEFINE_CUSTOM_GETTER(jsXPathEvaluatorConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSXPathEvaluatorPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSXPathEvaluator::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsXPathEvaluatorPrototypeFunction_createExpressionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXPathEvaluator>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto expression = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto resolver = convert<IDLNullable<IDLInterface<XPathNSResolver>>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "resolver", "XPathEvaluator", "createExpression", "XPathNSResolver"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<XPathExpression>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createExpression(WTFMove(expression), WTFMove(resolver)))));
}

JSC_DEFINE_HOST_FUNCTION(jsXPathEvaluatorPrototypeFunction_createExpression, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSXPathEvaluator>::call<jsXPathEvaluatorPrototypeFunction_createExpressionBody>(*lexicalGlobalObject, *callFrame, "createExpression");
}

static inline JSC::EncodedJSValue jsXPathEvaluatorPrototypeFunction_createNSResolverBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXPathEvaluator>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto nodeResolver = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "nodeResolver", "XPathEvaluator", "createNSResolver", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    invokeFunctorPropagatingExceptionIfNecessary(*lexicalGlobalObject, throwScope, [&] { return impl.createNSResolverForBindings(*nodeResolver); });
    return JSValue::encode(argument0.value());
}

JSC_DEFINE_HOST_FUNCTION(jsXPathEvaluatorPrototypeFunction_createNSResolver, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSXPathEvaluator>::call<jsXPathEvaluatorPrototypeFunction_createNSResolverBody>(*lexicalGlobalObject, *callFrame, "createNSResolver");
}

static inline JSC::EncodedJSValue jsXPathEvaluatorPrototypeFunction_evaluateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXPathEvaluator>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto expression = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto contextNode = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "contextNode", "XPathEvaluator", "evaluate", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto resolver = convert<IDLNullable<IDLInterface<XPathNSResolver>>>(*lexicalGlobalObject, argument2.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "resolver", "XPathEvaluator", "evaluate", "XPathNSResolver"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto type = convert<IDLUnsignedShort>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument4 = callFrame->argument(4);
    auto inResult = convert<IDLNullable<IDLInterface<XPathResult>>>(*lexicalGlobalObject, argument4.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 4, "inResult", "XPathEvaluator", "evaluate", "XPathResult"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<XPathResult>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.evaluate(WTFMove(expression), *contextNode, WTFMove(resolver), WTFMove(type), WTFMove(inResult)))));
}

JSC_DEFINE_HOST_FUNCTION(jsXPathEvaluatorPrototypeFunction_evaluate, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSXPathEvaluator>::call<jsXPathEvaluatorPrototypeFunction_evaluateBody>(*lexicalGlobalObject, *callFrame, "evaluate");
}

JSC::GCClient::IsoSubspace* JSXPathEvaluator::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSXPathEvaluator, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForXPathEvaluator.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForXPathEvaluator = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForXPathEvaluator.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForXPathEvaluator = std::forward<decltype(space)>(space); }
    );
}

void JSXPathEvaluator::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSXPathEvaluator*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSXPathEvaluatorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSXPathEvaluatorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsXPathEvaluator = static_cast<JSXPathEvaluator*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsXPathEvaluator->wrapped(), jsXPathEvaluator);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7XPathEvaluator@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14XPathEvaluatorE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<XPathEvaluator>&& impl)
{

    if constexpr (std::is_polymorphic_v<XPathEvaluator>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7XPathEvaluator@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore14XPathEvaluatorE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // XPathEvaluator has subclasses. If XPathEvaluator has subclasses that get passed
        // to toJS() we currently require XPathEvaluator you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<XPathEvaluator>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, XPathEvaluator& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

XPathEvaluator* JSXPathEvaluator::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSXPathEvaluator*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
