/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGViewSpec.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSSVGAnimatedPreserveAspectRatio.h"
#include "JSSVGAnimatedRect.h"
#include "JSSVGElement.h"
#include "JSSVGTransformList.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSVGViewSpecConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGViewSpec_transform);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGViewSpec_viewTarget);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGViewSpec_viewBoxString);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGViewSpec_preserveAspectRatioString);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGViewSpec_transformString);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGViewSpec_viewTargetString);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGViewSpec_viewBox);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGViewSpec_preserveAspectRatio);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGViewSpec_zoomAndPan);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGViewSpec_zoomAndPan);

class JSSVGViewSpecPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGViewSpecPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGViewSpecPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGViewSpecPrototype>(vm)) JSSVGViewSpecPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGViewSpecPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGViewSpecPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGViewSpecPrototype, JSSVGViewSpecPrototype::Base);

using JSSVGViewSpecDOMConstructor = JSDOMConstructorNotConstructable<JSSVGViewSpec>;

/* Hash table for constructor */

static const HashTableValue JSSVGViewSpecConstructorTableValues[] =
{
    { "SVG_ZOOMANDPAN_UNKNOWN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    { "SVG_ZOOMANDPAN_DISABLE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "SVG_ZOOMANDPAN_MAGNIFY"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
};

static_assert(SVGViewSpec::SVG_ZOOMANDPAN_UNKNOWN == 0, "SVG_ZOOMANDPAN_UNKNOWN in SVGViewSpec does not match value from IDL");
static_assert(SVGViewSpec::SVG_ZOOMANDPAN_DISABLE == 1, "SVG_ZOOMANDPAN_DISABLE in SVGViewSpec does not match value from IDL");
static_assert(SVGViewSpec::SVG_ZOOMANDPAN_MAGNIFY == 2, "SVG_ZOOMANDPAN_MAGNIFY in SVGViewSpec does not match value from IDL");

template<> const ClassInfo JSSVGViewSpecDOMConstructor::s_info = { "SVGViewSpec"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGViewSpecDOMConstructor) };

template<> JSValue JSSVGViewSpecDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGViewSpecDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SVGViewSpec"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSVGViewSpec::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSSVGViewSpec::info(), JSSVGViewSpecConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSSVGViewSpecPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGViewSpecConstructor, 0 } },
    { "transform"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGViewSpec_transform, 0 } },
    { "viewTarget"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGViewSpec_viewTarget, 0 } },
    { "viewBoxString"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGViewSpec_viewBoxString, 0 } },
    { "preserveAspectRatioString"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGViewSpec_preserveAspectRatioString, 0 } },
    { "transformString"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGViewSpec_transformString, 0 } },
    { "viewTargetString"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGViewSpec_viewTargetString, 0 } },
    { "viewBox"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGViewSpec_viewBox, 0 } },
    { "preserveAspectRatio"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGViewSpec_preserveAspectRatio, 0 } },
    { "zoomAndPan"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGViewSpec_zoomAndPan, setJSSVGViewSpec_zoomAndPan } },
    { "SVG_ZOOMANDPAN_UNKNOWN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    { "SVG_ZOOMANDPAN_DISABLE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "SVG_ZOOMANDPAN_MAGNIFY"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
};

const ClassInfo JSSVGViewSpecPrototype::s_info = { "SVGViewSpec"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGViewSpecPrototype) };

void JSSVGViewSpecPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGViewSpec::info(), JSSVGViewSpecPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSVGViewSpec::s_info = { "SVGViewSpec"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGViewSpec) };

JSSVGViewSpec::JSSVGViewSpec(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGViewSpec>&& impl)
    : JSDOMWrapper<SVGViewSpec>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, SVGViewSpec>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSSVGViewSpec::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSVGViewSpecPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSSVGViewSpecPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSVGViewSpec::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGViewSpec>(vm, globalObject);
}

JSValue JSSVGViewSpec::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGViewSpecDOMConstructor, DOMConstructorID::SVGViewSpec>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSVGViewSpec::destroy(JSC::JSCell* cell)
{
    JSSVGViewSpec* thisObject = static_cast<JSSVGViewSpec*>(cell);
    thisObject->JSSVGViewSpec::~JSSVGViewSpec();
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGViewSpecConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGViewSpecPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGViewSpec::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsSVGViewSpec_transformGetter(JSGlobalObject& lexicalGlobalObject, JSSVGViewSpec& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGTransformList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.transform())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGViewSpec_transform, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGViewSpec>::get<jsSVGViewSpec_transformGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGViewSpec_viewTargetGetter(JSGlobalObject& lexicalGlobalObject, JSSVGViewSpec& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGElement>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.viewTarget())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGViewSpec_viewTarget, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGViewSpec>::get<jsSVGViewSpec_viewTargetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGViewSpec_viewBoxStringGetter(JSGlobalObject& lexicalGlobalObject, JSSVGViewSpec& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.viewBoxString())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGViewSpec_viewBoxString, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGViewSpec>::get<jsSVGViewSpec_viewBoxStringGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGViewSpec_preserveAspectRatioStringGetter(JSGlobalObject& lexicalGlobalObject, JSSVGViewSpec& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.preserveAspectRatioString())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGViewSpec_preserveAspectRatioString, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGViewSpec>::get<jsSVGViewSpec_preserveAspectRatioStringGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGViewSpec_transformStringGetter(JSGlobalObject& lexicalGlobalObject, JSSVGViewSpec& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.transformString())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGViewSpec_transformString, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGViewSpec>::get<jsSVGViewSpec_transformStringGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGViewSpec_viewTargetStringGetter(JSGlobalObject& lexicalGlobalObject, JSSVGViewSpec& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.viewTargetString())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGViewSpec_viewTargetString, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGViewSpec>::get<jsSVGViewSpec_viewTargetStringGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGViewSpec_viewBoxGetter(JSGlobalObject& lexicalGlobalObject, JSSVGViewSpec& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedRect>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.viewBoxAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGViewSpec_viewBox, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGViewSpec>::get<jsSVGViewSpec_viewBoxGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGViewSpec_preserveAspectRatioGetter(JSGlobalObject& lexicalGlobalObject, JSSVGViewSpec& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedPreserveAspectRatio>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.preserveAspectRatioAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGViewSpec_preserveAspectRatio, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGViewSpec>::get<jsSVGViewSpec_preserveAspectRatioGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGViewSpec_zoomAndPanGetter(JSGlobalObject& lexicalGlobalObject, JSSVGViewSpec& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.zoomAndPan())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGViewSpec_zoomAndPan, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGViewSpec>::get<jsSVGViewSpec_zoomAndPanGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGViewSpec_zoomAndPanSetter(JSGlobalObject& lexicalGlobalObject, JSSVGViewSpec& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnsignedShort>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setZoomAndPan(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGViewSpec_zoomAndPan, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGViewSpec>::set<setJSSVGViewSpec_zoomAndPanSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSSVGViewSpec::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSVGViewSpec, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSVGViewSpec.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSVGViewSpec = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSVGViewSpec.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSVGViewSpec = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSSVGViewSpec::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSSVGViewSpec*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSSVGViewSpec);

template<typename Visitor>
void JSSVGViewSpec::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSSVGViewSpec*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSSVGViewSpec::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSSVGViewSpec::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSSVGViewSpec::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGViewSpec*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSSVGViewSpecOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSVGViewSpecOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGViewSpec = static_cast<JSSVGViewSpec*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSVGViewSpec->wrapped(), jsSVGViewSpec);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SVGViewSpec@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11SVGViewSpecE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SVGViewSpec>&& impl)
{

    if constexpr (std::is_polymorphic_v<SVGViewSpec>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7SVGViewSpec@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore11SVGViewSpecE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // SVGViewSpec has subclasses. If SVGViewSpec has subclasses that get passed
        // to toJS() we currently require SVGViewSpec you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<SVGViewSpec>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SVGViewSpec& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

SVGViewSpec* JSSVGViewSpec::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGViewSpec*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
