/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSRTCErrorDetailType.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(RTCErrorDetailType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("data-channel-failure"),
        MAKE_STATIC_STRING_IMPL("dtls-failure"),
        MAKE_STATIC_STRING_IMPL("fingerprint-failure"),
        MAKE_STATIC_STRING_IMPL("sctp-failure"),
        MAKE_STATIC_STRING_IMPL("sdp-syntax-error"),
    };
    static_assert(static_cast<size_t>(RTCErrorDetailType::DataChannelFailure) == 0, "RTCErrorDetailType::DataChannelFailure is not 0 as expected");
    static_assert(static_cast<size_t>(RTCErrorDetailType::DtlsFailure) == 1, "RTCErrorDetailType::DtlsFailure is not 1 as expected");
    static_assert(static_cast<size_t>(RTCErrorDetailType::FingerprintFailure) == 2, "RTCErrorDetailType::FingerprintFailure is not 2 as expected");
    static_assert(static_cast<size_t>(RTCErrorDetailType::SctpFailure) == 3, "RTCErrorDetailType::SctpFailure is not 3 as expected");
    static_assert(static_cast<size_t>(RTCErrorDetailType::SdpSyntaxError) == 4, "RTCErrorDetailType::SdpSyntaxError is not 4 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, RTCErrorDetailType enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<RTCErrorDetailType> parseEnumerationFromString<RTCErrorDetailType>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, RTCErrorDetailType> mappings[] = {
        { "data-channel-failure", RTCErrorDetailType::DataChannelFailure },
        { "dtls-failure", RTCErrorDetailType::DtlsFailure },
        { "fingerprint-failure", RTCErrorDetailType::FingerprintFailure },
        { "sctp-failure", RTCErrorDetailType::SctpFailure },
        { "sdp-syntax-error", RTCErrorDetailType::SdpSyntaxError },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<RTCErrorDetailType> parseEnumeration<RTCErrorDetailType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<RTCErrorDetailType>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<RTCErrorDetailType>()
{
    return "\"data-channel-failure\", \"dtls-failure\", \"fingerprint-failure\", \"sctp-failure\", \"sdp-syntax-error\"";
}

} // namespace WebCore
