/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPerformanceTiming.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsPerformanceTimingPrototypeFunction_toJSON);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceTimingConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceTiming_navigationStart);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceTiming_unloadEventStart);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceTiming_unloadEventEnd);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceTiming_redirectStart);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceTiming_redirectEnd);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceTiming_fetchStart);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceTiming_domainLookupStart);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceTiming_domainLookupEnd);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceTiming_connectStart);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceTiming_connectEnd);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceTiming_secureConnectionStart);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceTiming_requestStart);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceTiming_responseStart);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceTiming_responseEnd);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceTiming_domLoading);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceTiming_domInteractive);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceTiming_domContentLoadedEventStart);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceTiming_domContentLoadedEventEnd);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceTiming_domComplete);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceTiming_loadEventStart);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceTiming_loadEventEnd);

class JSPerformanceTimingPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSPerformanceTimingPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPerformanceTimingPrototype* ptr = new (NotNull, JSC::allocateCell<JSPerformanceTimingPrototype>(vm)) JSPerformanceTimingPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPerformanceTimingPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPerformanceTimingPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPerformanceTimingPrototype, JSPerformanceTimingPrototype::Base);

using JSPerformanceTimingDOMConstructor = JSDOMConstructorNotConstructable<JSPerformanceTiming>;

template<> const ClassInfo JSPerformanceTimingDOMConstructor::s_info = { "PerformanceTiming"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPerformanceTimingDOMConstructor) };

template<> JSValue JSPerformanceTimingDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSPerformanceTimingDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "PerformanceTiming"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSPerformanceTiming::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSPerformanceTimingPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceTimingConstructor, 0 } },
    { "navigationStart"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceTiming_navigationStart, 0 } },
    { "unloadEventStart"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceTiming_unloadEventStart, 0 } },
    { "unloadEventEnd"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceTiming_unloadEventEnd, 0 } },
    { "redirectStart"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceTiming_redirectStart, 0 } },
    { "redirectEnd"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceTiming_redirectEnd, 0 } },
    { "fetchStart"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceTiming_fetchStart, 0 } },
    { "domainLookupStart"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceTiming_domainLookupStart, 0 } },
    { "domainLookupEnd"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceTiming_domainLookupEnd, 0 } },
    { "connectStart"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceTiming_connectStart, 0 } },
    { "connectEnd"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceTiming_connectEnd, 0 } },
    { "secureConnectionStart"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceTiming_secureConnectionStart, 0 } },
    { "requestStart"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceTiming_requestStart, 0 } },
    { "responseStart"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceTiming_responseStart, 0 } },
    { "responseEnd"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceTiming_responseEnd, 0 } },
    { "domLoading"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceTiming_domLoading, 0 } },
    { "domInteractive"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceTiming_domInteractive, 0 } },
    { "domContentLoadedEventStart"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceTiming_domContentLoadedEventStart, 0 } },
    { "domContentLoadedEventEnd"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceTiming_domContentLoadedEventEnd, 0 } },
    { "domComplete"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceTiming_domComplete, 0 } },
    { "loadEventStart"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceTiming_loadEventStart, 0 } },
    { "loadEventEnd"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceTiming_loadEventEnd, 0 } },
    { "toJSON"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPerformanceTimingPrototypeFunction_toJSON, 0 } },
};

const ClassInfo JSPerformanceTimingPrototype::s_info = { "PerformanceTiming"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPerformanceTimingPrototype) };

void JSPerformanceTimingPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPerformanceTiming::info(), JSPerformanceTimingPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSPerformanceTiming::s_info = { "PerformanceTiming"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPerformanceTiming) };

JSPerformanceTiming::JSPerformanceTiming(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PerformanceTiming>&& impl)
    : JSDOMWrapper<PerformanceTiming>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, PerformanceTiming>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSPerformanceTiming::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSPerformanceTimingPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSPerformanceTimingPrototype::create(vm, &globalObject, structure);
}

JSObject* JSPerformanceTiming::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSPerformanceTiming>(vm, globalObject);
}

JSValue JSPerformanceTiming::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPerformanceTimingDOMConstructor, DOMConstructorID::PerformanceTiming>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSPerformanceTiming::destroy(JSC::JSCell* cell)
{
    JSPerformanceTiming* thisObject = static_cast<JSPerformanceTiming*>(cell);
    thisObject->JSPerformanceTiming::~JSPerformanceTiming();
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceTimingConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPerformanceTimingPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPerformanceTiming::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsPerformanceTiming_navigationStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.navigationStart())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceTiming_navigationStart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTiming_navigationStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPerformanceTiming_unloadEventStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.unloadEventStart())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceTiming_unloadEventStart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTiming_unloadEventStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPerformanceTiming_unloadEventEndGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.unloadEventEnd())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceTiming_unloadEventEnd, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTiming_unloadEventEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPerformanceTiming_redirectStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.redirectStart())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceTiming_redirectStart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTiming_redirectStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPerformanceTiming_redirectEndGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.redirectEnd())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceTiming_redirectEnd, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTiming_redirectEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPerformanceTiming_fetchStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.fetchStart())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceTiming_fetchStart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTiming_fetchStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPerformanceTiming_domainLookupStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.domainLookupStart())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceTiming_domainLookupStart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTiming_domainLookupStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPerformanceTiming_domainLookupEndGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.domainLookupEnd())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceTiming_domainLookupEnd, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTiming_domainLookupEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPerformanceTiming_connectStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.connectStart())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceTiming_connectStart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTiming_connectStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPerformanceTiming_connectEndGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.connectEnd())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceTiming_connectEnd, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTiming_connectEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPerformanceTiming_secureConnectionStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.secureConnectionStart())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceTiming_secureConnectionStart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTiming_secureConnectionStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPerformanceTiming_requestStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.requestStart())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceTiming_requestStart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTiming_requestStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPerformanceTiming_responseStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.responseStart())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceTiming_responseStart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTiming_responseStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPerformanceTiming_responseEndGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.responseEnd())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceTiming_responseEnd, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTiming_responseEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPerformanceTiming_domLoadingGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.domLoading())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceTiming_domLoading, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTiming_domLoadingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPerformanceTiming_domInteractiveGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.domInteractive())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceTiming_domInteractive, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTiming_domInteractiveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPerformanceTiming_domContentLoadedEventStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.domContentLoadedEventStart())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceTiming_domContentLoadedEventStart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTiming_domContentLoadedEventStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPerformanceTiming_domContentLoadedEventEndGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.domContentLoadedEventEnd())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceTiming_domContentLoadedEventEnd, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTiming_domContentLoadedEventEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPerformanceTiming_domCompleteGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.domComplete())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceTiming_domComplete, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTiming_domCompleteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPerformanceTiming_loadEventStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.loadEventStart())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceTiming_loadEventStart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTiming_loadEventStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPerformanceTiming_loadEventEndGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.loadEventEnd())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceTiming_loadEventEnd, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTiming_loadEventEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline EncodedJSValue jsPerformanceTimingPrototypeFunction_toJSONBody(JSGlobalObject* lexicalGlobalObject, CallFrame*, JSPerformanceTiming* castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto* result = constructEmptyObject(lexicalGlobalObject);
    auto navigationStartValue = toJS<IDLUnsignedLongLong>(*lexicalGlobalObject, throwScope, impl.navigationStart());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "navigationStart"_s), navigationStartValue);
    auto unloadEventStartValue = toJS<IDLUnsignedLongLong>(*lexicalGlobalObject, throwScope, impl.unloadEventStart());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "unloadEventStart"_s), unloadEventStartValue);
    auto unloadEventEndValue = toJS<IDLUnsignedLongLong>(*lexicalGlobalObject, throwScope, impl.unloadEventEnd());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "unloadEventEnd"_s), unloadEventEndValue);
    auto redirectStartValue = toJS<IDLUnsignedLongLong>(*lexicalGlobalObject, throwScope, impl.redirectStart());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "redirectStart"_s), redirectStartValue);
    auto redirectEndValue = toJS<IDLUnsignedLongLong>(*lexicalGlobalObject, throwScope, impl.redirectEnd());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "redirectEnd"_s), redirectEndValue);
    auto fetchStartValue = toJS<IDLUnsignedLongLong>(*lexicalGlobalObject, throwScope, impl.fetchStart());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "fetchStart"_s), fetchStartValue);
    auto domainLookupStartValue = toJS<IDLUnsignedLongLong>(*lexicalGlobalObject, throwScope, impl.domainLookupStart());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "domainLookupStart"_s), domainLookupStartValue);
    auto domainLookupEndValue = toJS<IDLUnsignedLongLong>(*lexicalGlobalObject, throwScope, impl.domainLookupEnd());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "domainLookupEnd"_s), domainLookupEndValue);
    auto connectStartValue = toJS<IDLUnsignedLongLong>(*lexicalGlobalObject, throwScope, impl.connectStart());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "connectStart"_s), connectStartValue);
    auto connectEndValue = toJS<IDLUnsignedLongLong>(*lexicalGlobalObject, throwScope, impl.connectEnd());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "connectEnd"_s), connectEndValue);
    auto secureConnectionStartValue = toJS<IDLUnsignedLongLong>(*lexicalGlobalObject, throwScope, impl.secureConnectionStart());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "secureConnectionStart"_s), secureConnectionStartValue);
    auto requestStartValue = toJS<IDLUnsignedLongLong>(*lexicalGlobalObject, throwScope, impl.requestStart());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "requestStart"_s), requestStartValue);
    auto responseStartValue = toJS<IDLUnsignedLongLong>(*lexicalGlobalObject, throwScope, impl.responseStart());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "responseStart"_s), responseStartValue);
    auto responseEndValue = toJS<IDLUnsignedLongLong>(*lexicalGlobalObject, throwScope, impl.responseEnd());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "responseEnd"_s), responseEndValue);
    auto domLoadingValue = toJS<IDLUnsignedLongLong>(*lexicalGlobalObject, throwScope, impl.domLoading());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "domLoading"_s), domLoadingValue);
    auto domInteractiveValue = toJS<IDLUnsignedLongLong>(*lexicalGlobalObject, throwScope, impl.domInteractive());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "domInteractive"_s), domInteractiveValue);
    auto domContentLoadedEventStartValue = toJS<IDLUnsignedLongLong>(*lexicalGlobalObject, throwScope, impl.domContentLoadedEventStart());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "domContentLoadedEventStart"_s), domContentLoadedEventStartValue);
    auto domContentLoadedEventEndValue = toJS<IDLUnsignedLongLong>(*lexicalGlobalObject, throwScope, impl.domContentLoadedEventEnd());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "domContentLoadedEventEnd"_s), domContentLoadedEventEndValue);
    auto domCompleteValue = toJS<IDLUnsignedLongLong>(*lexicalGlobalObject, throwScope, impl.domComplete());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "domComplete"_s), domCompleteValue);
    auto loadEventStartValue = toJS<IDLUnsignedLongLong>(*lexicalGlobalObject, throwScope, impl.loadEventStart());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "loadEventStart"_s), loadEventStartValue);
    auto loadEventEndValue = toJS<IDLUnsignedLongLong>(*lexicalGlobalObject, throwScope, impl.loadEventEnd());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "loadEventEnd"_s), loadEventEndValue);
    return JSValue::encode(result);
}

JSC_DEFINE_HOST_FUNCTION(jsPerformanceTimingPrototypeFunction_toJSON, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSPerformanceTiming>::call<jsPerformanceTimingPrototypeFunction_toJSONBody>(*lexicalGlobalObject, *callFrame, "toJSON");
}

JSC::GCClient::IsoSubspace* JSPerformanceTiming::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSPerformanceTiming, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForPerformanceTiming.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForPerformanceTiming = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForPerformanceTiming.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForPerformanceTiming = std::forward<decltype(space)>(space); }
    );
}

void JSPerformanceTiming::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPerformanceTiming*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSPerformanceTimingOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSPerformanceTimingOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsPerformanceTiming = static_cast<JSPerformanceTiming*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsPerformanceTiming->wrapped(), jsPerformanceTiming);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7PerformanceTiming@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore17PerformanceTimingE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<PerformanceTiming>&& impl)
{

    if constexpr (std::is_polymorphic_v<PerformanceTiming>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7PerformanceTiming@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore17PerformanceTimingE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // PerformanceTiming has subclasses. If PerformanceTiming has subclasses that get passed
        // to toJS() we currently require PerformanceTiming you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<PerformanceTiming>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, PerformanceTiming& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

PerformanceTiming* JSPerformanceTiming::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSPerformanceTiming*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
