/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSOptionalEffectTiming.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSFillMode.h"
#include "JSPlaybackDirection.h"
#include <JavaScriptCore/JSCInlines.h>
#include <variant>


namespace WebCore {
using namespace JSC;

template<> OptionalEffectTiming convertDictionary<OptionalEffectTiming>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    OptionalEffectTiming result;
    JSValue delayValue;
    if (isNullOrUndefined)
        delayValue = jsUndefined();
    else {
        delayValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "delay"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!delayValue.isUndefined()) {
        result.delay = convert<IDLDouble>(lexicalGlobalObject, delayValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue directionValue;
    if (isNullOrUndefined)
        directionValue = jsUndefined();
    else {
        directionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "direction"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!directionValue.isUndefined()) {
        result.direction = convert<IDLEnumeration<PlaybackDirection>>(lexicalGlobalObject, directionValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue durationValue;
    if (isNullOrUndefined)
        durationValue = jsUndefined();
    else {
        durationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "duration"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!durationValue.isUndefined()) {
        result.duration = convert<IDLUnion<IDLUnrestrictedDouble, IDLDOMString>>(lexicalGlobalObject, durationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue easingValue;
    if (isNullOrUndefined)
        easingValue = jsUndefined();
    else {
        easingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "easing"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!easingValue.isUndefined()) {
        result.easing = convert<IDLDOMString>(lexicalGlobalObject, easingValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue endDelayValue;
    if (isNullOrUndefined)
        endDelayValue = jsUndefined();
    else {
        endDelayValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "endDelay"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!endDelayValue.isUndefined()) {
        result.endDelay = convert<IDLDouble>(lexicalGlobalObject, endDelayValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue fillValue;
    if (isNullOrUndefined)
        fillValue = jsUndefined();
    else {
        fillValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "fill"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!fillValue.isUndefined()) {
        result.fill = convert<IDLEnumeration<FillMode>>(lexicalGlobalObject, fillValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue iterationStartValue;
    if (isNullOrUndefined)
        iterationStartValue = jsUndefined();
    else {
        iterationStartValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "iterationStart"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!iterationStartValue.isUndefined()) {
        result.iterationStart = convert<IDLDouble>(lexicalGlobalObject, iterationStartValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue iterationsValue;
    if (isNullOrUndefined)
        iterationsValue = jsUndefined();
    else {
        iterationsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "iterations"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!iterationsValue.isUndefined()) {
        result.iterations = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, iterationsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

} // namespace WebCore
