/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSOESVertexArrayObject.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSWebGLVertexArrayObjectOES.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsOESVertexArrayObjectPrototypeFunction_createVertexArrayOES);
static JSC_DECLARE_HOST_FUNCTION(jsOESVertexArrayObjectPrototypeFunction_deleteVertexArrayOES);
static JSC_DECLARE_HOST_FUNCTION(jsOESVertexArrayObjectPrototypeFunction_isVertexArrayOES);
static JSC_DECLARE_HOST_FUNCTION(jsOESVertexArrayObjectPrototypeFunction_bindVertexArrayOES);

class JSOESVertexArrayObjectPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSOESVertexArrayObjectPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOESVertexArrayObjectPrototype* ptr = new (NotNull, JSC::allocateCell<JSOESVertexArrayObjectPrototype>(vm)) JSOESVertexArrayObjectPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOESVertexArrayObjectPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOESVertexArrayObjectPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOESVertexArrayObjectPrototype, JSOESVertexArrayObjectPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSOESVertexArrayObjectPrototypeTableValues[] =
{
    { "createVertexArrayOES"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOESVertexArrayObjectPrototypeFunction_createVertexArrayOES, 0 } },
    { "deleteVertexArrayOES"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOESVertexArrayObjectPrototypeFunction_deleteVertexArrayOES, 0 } },
    { "isVertexArrayOES"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOESVertexArrayObjectPrototypeFunction_isVertexArrayOES, 0 } },
    { "bindVertexArrayOES"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOESVertexArrayObjectPrototypeFunction_bindVertexArrayOES, 0 } },
    { "VERTEX_ARRAY_BINDING_OES"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x85B5 } },
};

const ClassInfo JSOESVertexArrayObjectPrototype::s_info = { "OESVertexArrayObject"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESVertexArrayObjectPrototype) };

void JSOESVertexArrayObjectPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSOESVertexArrayObject::info(), JSOESVertexArrayObjectPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSOESVertexArrayObject::s_info = { "OESVertexArrayObject"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESVertexArrayObject) };

JSOESVertexArrayObject::JSOESVertexArrayObject(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OESVertexArrayObject>&& impl)
    : JSDOMWrapper<OESVertexArrayObject>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, OESVertexArrayObject>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSOESVertexArrayObject::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSOESVertexArrayObjectPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSOESVertexArrayObjectPrototype::create(vm, &globalObject, structure);
}

JSObject* JSOESVertexArrayObject::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSOESVertexArrayObject>(vm, globalObject);
}

void JSOESVertexArrayObject::destroy(JSC::JSCell* cell)
{
    JSOESVertexArrayObject* thisObject = static_cast<JSOESVertexArrayObject*>(cell);
    thisObject->JSOESVertexArrayObject::~JSOESVertexArrayObject();
}

static inline JSC::EncodedJSValue jsOESVertexArrayObjectPrototypeFunction_createVertexArrayOESBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOESVertexArrayObject>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<WebGLVertexArrayObjectOES>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createVertexArrayOES())));
}

JSC_DEFINE_HOST_FUNCTION(jsOESVertexArrayObjectPrototypeFunction_createVertexArrayOES, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOESVertexArrayObject>::call<jsOESVertexArrayObjectPrototypeFunction_createVertexArrayOESBody>(*lexicalGlobalObject, *callFrame, "createVertexArrayOES");
}

static inline JSC::EncodedJSValue jsOESVertexArrayObjectPrototypeFunction_deleteVertexArrayOESBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOESVertexArrayObject>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto arrayObject = convert<IDLNullable<IDLInterface<WebGLVertexArrayObjectOES>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "arrayObject", "OESVertexArrayObject", "deleteVertexArrayOES", "WebGLVertexArrayObjectOES"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.deleteVertexArrayOES(WTFMove(arrayObject)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOESVertexArrayObjectPrototypeFunction_deleteVertexArrayOES, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOESVertexArrayObject>::call<jsOESVertexArrayObjectPrototypeFunction_deleteVertexArrayOESBody>(*lexicalGlobalObject, *callFrame, "deleteVertexArrayOES");
}

static inline JSC::EncodedJSValue jsOESVertexArrayObjectPrototypeFunction_isVertexArrayOESBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOESVertexArrayObject>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto arrayObject = convert<IDLNullable<IDLInterface<WebGLVertexArrayObjectOES>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "arrayObject", "OESVertexArrayObject", "isVertexArrayOES", "WebGLVertexArrayObjectOES"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.isVertexArrayOES(WTFMove(arrayObject)))));
}

JSC_DEFINE_HOST_FUNCTION(jsOESVertexArrayObjectPrototypeFunction_isVertexArrayOES, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOESVertexArrayObject>::call<jsOESVertexArrayObjectPrototypeFunction_isVertexArrayOESBody>(*lexicalGlobalObject, *callFrame, "isVertexArrayOES");
}

static inline JSC::EncodedJSValue jsOESVertexArrayObjectPrototypeFunction_bindVertexArrayOESBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOESVertexArrayObject>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto arrayObject = convert<IDLNullable<IDLInterface<WebGLVertexArrayObjectOES>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "arrayObject", "OESVertexArrayObject", "bindVertexArrayOES", "WebGLVertexArrayObjectOES"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.bindVertexArrayOES(WTFMove(arrayObject)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOESVertexArrayObjectPrototypeFunction_bindVertexArrayOES, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOESVertexArrayObject>::call<jsOESVertexArrayObjectPrototypeFunction_bindVertexArrayOESBody>(*lexicalGlobalObject, *callFrame, "bindVertexArrayOES");
}

JSC::GCClient::IsoSubspace* JSOESVertexArrayObject::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSOESVertexArrayObject, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForOESVertexArrayObject.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForOESVertexArrayObject = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForOESVertexArrayObject.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForOESVertexArrayObject = std::forward<decltype(space)>(space); }
    );
}

void JSOESVertexArrayObject::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSOESVertexArrayObject*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSOESVertexArrayObjectOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsOESVertexArrayObject = jsCast<JSOESVertexArrayObject*>(handle.slot()->asCell());
    WebGLRenderingContextBase* owner = WTF::getPtr(jsOESVertexArrayObject->wrapped().context());
    if (UNLIKELY(reason))
        *reason = "Reachable from OESVertexArrayObject";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSOESVertexArrayObjectOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsOESVertexArrayObject = static_cast<JSOESVertexArrayObject*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsOESVertexArrayObject->wrapped(), jsOESVertexArrayObject);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OESVertexArrayObject@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore20OESVertexArrayObjectE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<OESVertexArrayObject>&& impl)
{

    if constexpr (std::is_polymorphic_v<OESVertexArrayObject>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7OESVertexArrayObject@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore20OESVertexArrayObjectE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // OESVertexArrayObject has subclasses. If OESVertexArrayObject has subclasses that get passed
        // to toJS() we currently require OESVertexArrayObject you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<OESVertexArrayObject>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, OESVertexArrayObject& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

OESVertexArrayObject* JSOESVertexArrayObject::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSOESVertexArrayObject*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
