/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSInspectorAuditDOMObject.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSNode.h"
#include "JSVoidCallback.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsInspectorAuditDOMObjectPrototypeFunction_hasEventListeners);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorAuditDOMObjectPrototypeFunction_simulateUserInteraction);

class JSInspectorAuditDOMObjectPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSInspectorAuditDOMObjectPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSInspectorAuditDOMObjectPrototype* ptr = new (NotNull, JSC::allocateCell<JSInspectorAuditDOMObjectPrototype>(vm)) JSInspectorAuditDOMObjectPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSInspectorAuditDOMObjectPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSInspectorAuditDOMObjectPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSInspectorAuditDOMObjectPrototype, JSInspectorAuditDOMObjectPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSInspectorAuditDOMObjectPrototypeTableValues[] =
{
    { "hasEventListeners"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorAuditDOMObjectPrototypeFunction_hasEventListeners, 1 } },
    { "simulateUserInteraction"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorAuditDOMObjectPrototypeFunction_simulateUserInteraction, 1 } },
};

const ClassInfo JSInspectorAuditDOMObjectPrototype::s_info = { "InspectorAuditDOMObject"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSInspectorAuditDOMObjectPrototype) };

void JSInspectorAuditDOMObjectPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSInspectorAuditDOMObject::info(), JSInspectorAuditDOMObjectPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSInspectorAuditDOMObject::s_info = { "InspectorAuditDOMObject"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSInspectorAuditDOMObject) };

JSInspectorAuditDOMObject::JSInspectorAuditDOMObject(Structure* structure, JSDOMGlobalObject& globalObject, Ref<InspectorAuditDOMObject>&& impl)
    : JSDOMWrapper<InspectorAuditDOMObject>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, InspectorAuditDOMObject>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSInspectorAuditDOMObject::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSInspectorAuditDOMObjectPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSInspectorAuditDOMObjectPrototype::create(vm, &globalObject, structure);
}

JSObject* JSInspectorAuditDOMObject::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSInspectorAuditDOMObject>(vm, globalObject);
}

void JSInspectorAuditDOMObject::destroy(JSC::JSCell* cell)
{
    JSInspectorAuditDOMObject* thisObject = static_cast<JSInspectorAuditDOMObject*>(cell);
    thisObject->JSInspectorAuditDOMObject::~JSInspectorAuditDOMObject();
}

static inline JSC::EncodedJSValue jsInspectorAuditDOMObjectPrototypeFunction_hasEventListenersBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorAuditDOMObject>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "InspectorAuditDOMObject", "hasEventListeners", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto type = argument1.value().isUndefined() ? String() : convert<IDLDOMString>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.hasEventListeners(*node, WTFMove(type)))));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorAuditDOMObjectPrototypeFunction_hasEventListeners, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorAuditDOMObject>::call<jsInspectorAuditDOMObjectPrototypeFunction_hasEventListenersBody>(*lexicalGlobalObject, *callFrame, "hasEventListeners");
}

static inline JSC::EncodedJSValue jsInspectorAuditDOMObjectPrototypeFunction_simulateUserInteractionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorAuditDOMObject>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto callback = convert<IDLCallbackFunction<JSVoidCallback>>(*lexicalGlobalObject, argument0.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "callback", "InspectorAuditDOMObject", "simulateUserInteraction"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.simulateUserInteraction(document, callback.releaseNonNull()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorAuditDOMObjectPrototypeFunction_simulateUserInteraction, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorAuditDOMObject>::call<jsInspectorAuditDOMObjectPrototypeFunction_simulateUserInteractionBody>(*lexicalGlobalObject, *callFrame, "simulateUserInteraction");
}

JSC::GCClient::IsoSubspace* JSInspectorAuditDOMObject::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSInspectorAuditDOMObject, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForInspectorAuditDOMObject.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForInspectorAuditDOMObject = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForInspectorAuditDOMObject.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForInspectorAuditDOMObject = std::forward<decltype(space)>(space); }
    );
}

void JSInspectorAuditDOMObject::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSInspectorAuditDOMObject*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSInspectorAuditDOMObjectOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSInspectorAuditDOMObjectOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsInspectorAuditDOMObject = static_cast<JSInspectorAuditDOMObject*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsInspectorAuditDOMObject->wrapped(), jsInspectorAuditDOMObject);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7InspectorAuditDOMObject@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore23InspectorAuditDOMObjectE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<InspectorAuditDOMObject>&& impl)
{

    if constexpr (std::is_polymorphic_v<InspectorAuditDOMObject>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7InspectorAuditDOMObject@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore23InspectorAuditDOMObjectE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // InspectorAuditDOMObject has subclasses. If InspectorAuditDOMObject has subclasses that get passed
        // to toJS() we currently require InspectorAuditDOMObject you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<InspectorAuditDOMObject>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, InspectorAuditDOMObject& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

InspectorAuditDOMObject* JSInspectorAuditDOMObject::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSInspectorAuditDOMObject*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
