/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(GAMEPAD)

#include "JSGamepadEffectParameters.h"

#include "JSDOMConvertNumbers.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(GAMEPAD)

template<> GamepadEffectParameters convertDictionary<GamepadEffectParameters>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GamepadEffectParameters result;
    JSValue durationValue;
    if (isNullOrUndefined)
        durationValue = jsUndefined();
    else {
        durationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "duration"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!durationValue.isUndefined()) {
        result.duration = convert<IDLDouble>(lexicalGlobalObject, durationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.duration = 0.0;
    JSValue leftTriggerValue;
    if (isNullOrUndefined)
        leftTriggerValue = jsUndefined();
    else {
        leftTriggerValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "leftTrigger"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!leftTriggerValue.isUndefined()) {
        result.leftTrigger = convert<IDLDouble>(lexicalGlobalObject, leftTriggerValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.leftTrigger = 0.0;
    JSValue rightTriggerValue;
    if (isNullOrUndefined)
        rightTriggerValue = jsUndefined();
    else {
        rightTriggerValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "rightTrigger"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!rightTriggerValue.isUndefined()) {
        result.rightTrigger = convert<IDLDouble>(lexicalGlobalObject, rightTriggerValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.rightTrigger = 0.0;
    JSValue startDelayValue;
    if (isNullOrUndefined)
        startDelayValue = jsUndefined();
    else {
        startDelayValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "startDelay"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!startDelayValue.isUndefined()) {
        result.startDelay = convert<IDLDouble>(lexicalGlobalObject, startDelayValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.startDelay = 0.0;
    JSValue strongMagnitudeValue;
    if (isNullOrUndefined)
        strongMagnitudeValue = jsUndefined();
    else {
        strongMagnitudeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "strongMagnitude"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!strongMagnitudeValue.isUndefined()) {
        result.strongMagnitude = convert<IDLDouble>(lexicalGlobalObject, strongMagnitudeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.strongMagnitude = 0.0;
    JSValue weakMagnitudeValue;
    if (isNullOrUndefined)
        weakMagnitudeValue = jsUndefined();
    else {
        weakMagnitudeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "weakMagnitude"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!weakMagnitudeValue.isUndefined()) {
        result.weakMagnitude = convert<IDLDouble>(lexicalGlobalObject, weakMagnitudeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.weakMagnitude = 0.0;
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(GAMEPAD)
