/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUColorWrite.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGPUColorWriteConstructor);

class JSGPUColorWritePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGPUColorWritePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGPUColorWritePrototype* ptr = new (NotNull, JSC::allocateCell<JSGPUColorWritePrototype>(vm)) JSGPUColorWritePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUColorWritePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGPUColorWritePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUColorWritePrototype, JSGPUColorWritePrototype::Base);

using JSGPUColorWriteDOMConstructor = JSDOMConstructorNotConstructable<JSGPUColorWrite>;

/* Hash table for constructor */

static const HashTableValue JSGPUColorWriteConstructorTableValues[] =
{
    { "RED"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1 } },
    { "GREEN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x2 } },
    { "BLUE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x4 } },
    { "ALPHA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8 } },
    { "ALL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0xF } },
};

static_assert(GPUColorWrite::RED == 0x1, "RED in GPUColorWrite does not match value from IDL");
static_assert(GPUColorWrite::GREEN == 0x2, "GREEN in GPUColorWrite does not match value from IDL");
static_assert(GPUColorWrite::BLUE == 0x4, "BLUE in GPUColorWrite does not match value from IDL");
static_assert(GPUColorWrite::ALPHA == 0x8, "ALPHA in GPUColorWrite does not match value from IDL");
static_assert(GPUColorWrite::ALL == 0xF, "ALL in GPUColorWrite does not match value from IDL");

template<> const ClassInfo JSGPUColorWriteDOMConstructor::s_info = { "GPUColorWrite"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUColorWriteDOMConstructor) };

template<> JSValue JSGPUColorWriteDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGPUColorWriteDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GPUColorWrite"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGPUColorWrite::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSGPUColorWrite::info(), JSGPUColorWriteConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSGPUColorWritePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUColorWriteConstructor, 0 } },
    { "RED"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1 } },
    { "GREEN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x2 } },
    { "BLUE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x4 } },
    { "ALPHA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8 } },
    { "ALL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0xF } },
};

const ClassInfo JSGPUColorWritePrototype::s_info = { "GPUColorWrite"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUColorWritePrototype) };

void JSGPUColorWritePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGPUColorWrite::info(), JSGPUColorWritePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGPUColorWrite::s_info = { "GPUColorWrite"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUColorWrite) };

JSGPUColorWrite::JSGPUColorWrite(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GPUColorWrite>&& impl)
    : JSDOMWrapper<GPUColorWrite>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, GPUColorWrite>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSGPUColorWrite::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGPUColorWritePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGPUColorWritePrototype::create(vm, &globalObject, structure);
}

JSObject* JSGPUColorWrite::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGPUColorWrite>(vm, globalObject);
}

JSValue JSGPUColorWrite::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGPUColorWriteDOMConstructor, DOMConstructorID::GPUColorWrite>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGPUColorWrite::destroy(JSC::JSCell* cell)
{
    JSGPUColorWrite* thisObject = static_cast<JSGPUColorWrite*>(cell);
    thisObject->JSGPUColorWrite::~JSGPUColorWrite();
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUColorWriteConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPUColorWritePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGPUColorWrite::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

JSC::GCClient::IsoSubspace* JSGPUColorWrite::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGPUColorWrite, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGPUColorWrite.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGPUColorWrite = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGPUColorWrite.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGPUColorWrite = std::forward<decltype(space)>(space); }
    );
}

void JSGPUColorWrite::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGPUColorWrite*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSGPUColorWriteOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGPUColorWriteOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGPUColorWrite = static_cast<JSGPUColorWrite*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsGPUColorWrite->wrapped(), jsGPUColorWrite);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GPUColorWrite@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13GPUColorWriteE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GPUColorWrite>&& impl)
{

    if constexpr (std::is_polymorphic_v<GPUColorWrite>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GPUColorWrite@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore13GPUColorWriteE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GPUColorWrite has subclasses. If GPUColorWrite has subclasses that get passed
        // to toJS() we currently require GPUColorWrite you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<GPUColorWrite>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GPUColorWrite& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GPUColorWrite* JSGPUColorWrite::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGPUColorWrite*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
