/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUBindGroupLayout.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGPUBindGroupLayoutConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUBindGroupLayout_label);
static JSC_DECLARE_CUSTOM_SETTER(setJSGPUBindGroupLayout_label);

class JSGPUBindGroupLayoutPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGPUBindGroupLayoutPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGPUBindGroupLayoutPrototype* ptr = new (NotNull, JSC::allocateCell<JSGPUBindGroupLayoutPrototype>(vm)) JSGPUBindGroupLayoutPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUBindGroupLayoutPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGPUBindGroupLayoutPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUBindGroupLayoutPrototype, JSGPUBindGroupLayoutPrototype::Base);

using JSGPUBindGroupLayoutDOMConstructor = JSDOMConstructorNotConstructable<JSGPUBindGroupLayout>;

template<> const ClassInfo JSGPUBindGroupLayoutDOMConstructor::s_info = { "GPUBindGroupLayout"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUBindGroupLayoutDOMConstructor) };

template<> JSValue JSGPUBindGroupLayoutDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGPUBindGroupLayoutDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GPUBindGroupLayout"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGPUBindGroupLayout::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSGPUBindGroupLayoutPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUBindGroupLayoutConstructor, 0 } },
    { "label"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUBindGroupLayout_label, setJSGPUBindGroupLayout_label } },
};

const ClassInfo JSGPUBindGroupLayoutPrototype::s_info = { "GPUBindGroupLayout"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUBindGroupLayoutPrototype) };

void JSGPUBindGroupLayoutPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGPUBindGroupLayout::info(), JSGPUBindGroupLayoutPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "label"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGPUBindGroupLayout::s_info = { "GPUBindGroupLayout"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUBindGroupLayout) };

JSGPUBindGroupLayout::JSGPUBindGroupLayout(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GPUBindGroupLayout>&& impl)
    : JSDOMWrapper<GPUBindGroupLayout>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, GPUBindGroupLayout>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSGPUBindGroupLayout::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGPUBindGroupLayoutPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGPUBindGroupLayoutPrototype::create(vm, &globalObject, structure);
}

JSObject* JSGPUBindGroupLayout::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGPUBindGroupLayout>(vm, globalObject);
}

JSValue JSGPUBindGroupLayout::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGPUBindGroupLayoutDOMConstructor, DOMConstructorID::GPUBindGroupLayout>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGPUBindGroupLayout::destroy(JSC::JSCell* cell)
{
    JSGPUBindGroupLayout* thisObject = static_cast<JSGPUBindGroupLayout*>(cell);
    thisObject->JSGPUBindGroupLayout::~JSGPUBindGroupLayout();
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUBindGroupLayoutConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPUBindGroupLayoutPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGPUBindGroupLayout::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsGPUBindGroupLayout_labelGetter(JSGlobalObject& lexicalGlobalObject, JSGPUBindGroupLayout& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.label())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUBindGroupLayout_label, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUBindGroupLayout>::get<jsGPUBindGroupLayout_labelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSGPUBindGroupLayout_labelSetter(JSGlobalObject& lexicalGlobalObject, JSGPUBindGroupLayout& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLUSVString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setLabel(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSGPUBindGroupLayout_label, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUBindGroupLayout>::set<setJSGPUBindGroupLayout_labelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSGPUBindGroupLayout::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGPUBindGroupLayout, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGPUBindGroupLayout.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGPUBindGroupLayout = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGPUBindGroupLayout.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGPUBindGroupLayout = std::forward<decltype(space)>(space); }
    );
}

void JSGPUBindGroupLayout::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGPUBindGroupLayout*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSGPUBindGroupLayoutOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGPUBindGroupLayoutOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGPUBindGroupLayout = static_cast<JSGPUBindGroupLayout*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsGPUBindGroupLayout->wrapped(), jsGPUBindGroupLayout);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GPUBindGroupLayout@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore18GPUBindGroupLayoutE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GPUBindGroupLayout>&& impl)
{

    if constexpr (std::is_polymorphic_v<GPUBindGroupLayout>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GPUBindGroupLayout@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore18GPUBindGroupLayoutE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GPUBindGroupLayout has subclasses. If GPUBindGroupLayout has subclasses that get passed
        // to toJS() we currently require GPUBindGroupLayout you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<GPUBindGroupLayout>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GPUBindGroupLayout& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GPUBindGroupLayout* JSGPUBindGroupLayout::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGPUBindGroupLayout*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
