/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSEXTTextureNorm16.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

class JSEXTTextureNorm16Prototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSEXTTextureNorm16Prototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEXTTextureNorm16Prototype* ptr = new (NotNull, JSC::allocateCell<JSEXTTextureNorm16Prototype>(vm)) JSEXTTextureNorm16Prototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTTextureNorm16Prototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSEXTTextureNorm16Prototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTTextureNorm16Prototype, JSEXTTextureNorm16Prototype::Base);

/* Hash table for prototype */

static const HashTableValue JSEXTTextureNorm16PrototypeTableValues[] =
{
    { "R16_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x822A } },
    { "RG16_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x822C } },
    { "RGB16_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8054 } },
    { "RGBA16_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x805B } },
    { "R16_SNORM_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8F98 } },
    { "RG16_SNORM_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8F99 } },
    { "RGB16_SNORM_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8F9A } },
    { "RGBA16_SNORM_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8F9B } },
};

const ClassInfo JSEXTTextureNorm16Prototype::s_info = { "EXTTextureNorm16"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTTextureNorm16Prototype) };

void JSEXTTextureNorm16Prototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSEXTTextureNorm16::info(), JSEXTTextureNorm16PrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSEXTTextureNorm16::s_info = { "EXTTextureNorm16"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTTextureNorm16) };

JSEXTTextureNorm16::JSEXTTextureNorm16(Structure* structure, JSDOMGlobalObject& globalObject, Ref<EXTTextureNorm16>&& impl)
    : JSDOMWrapper<EXTTextureNorm16>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, EXTTextureNorm16>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSEXTTextureNorm16::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSEXTTextureNorm16Prototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSEXTTextureNorm16Prototype::create(vm, &globalObject, structure);
}

JSObject* JSEXTTextureNorm16::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSEXTTextureNorm16>(vm, globalObject);
}

void JSEXTTextureNorm16::destroy(JSC::JSCell* cell)
{
    JSEXTTextureNorm16* thisObject = static_cast<JSEXTTextureNorm16*>(cell);
    thisObject->JSEXTTextureNorm16::~JSEXTTextureNorm16();
}

JSC::GCClient::IsoSubspace* JSEXTTextureNorm16::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSEXTTextureNorm16, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForEXTTextureNorm16.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForEXTTextureNorm16 = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForEXTTextureNorm16.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForEXTTextureNorm16 = std::forward<decltype(space)>(space); }
    );
}

void JSEXTTextureNorm16::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSEXTTextureNorm16*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSEXTTextureNorm16Owner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsEXTTextureNorm16 = jsCast<JSEXTTextureNorm16*>(handle.slot()->asCell());
    WebGLRenderingContextBase* owner = WTF::getPtr(jsEXTTextureNorm16->wrapped().context());
    if (UNLIKELY(reason))
        *reason = "Reachable from EXTTextureNorm16";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSEXTTextureNorm16Owner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsEXTTextureNorm16 = static_cast<JSEXTTextureNorm16*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsEXTTextureNorm16->wrapped(), jsEXTTextureNorm16);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7EXTTextureNorm16@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16EXTTextureNorm16E[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<EXTTextureNorm16>&& impl)
{

    if constexpr (std::is_polymorphic_v<EXTTextureNorm16>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7EXTTextureNorm16@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore16EXTTextureNorm16E[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // EXTTextureNorm16 has subclasses. If EXTTextureNorm16 has subclasses that get passed
        // to toJS() we currently require EXTTextureNorm16 you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<EXTTextureNorm16>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, EXTTextureNorm16& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

EXTTextureNorm16* JSEXTTextureNorm16::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSEXTTextureNorm16*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
