/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCookieListItem.h"

#include "JSCookieSameSite.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMGlobalObject.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

template<> CookieListItem convertDictionary<CookieListItem>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    CookieListItem result;
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().cookieStoreAPIExtendedAttributesEnabled) {
        JSValue domainValue;
        if (isNullOrUndefined)
            domainValue = jsUndefined();
        else {
            domainValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "domain"_s));
            RETURN_IF_EXCEPTION(throwScope, { });
        }
        if (!domainValue.isUndefined()) {
            result.domain = convert<IDLNullable<IDLUSVString>>(lexicalGlobalObject, domainValue);
            RETURN_IF_EXCEPTION(throwScope, { });
        }
    }
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().cookieStoreAPIExtendedAttributesEnabled) {
        JSValue expiresValue;
        if (isNullOrUndefined)
            expiresValue = jsUndefined();
        else {
            expiresValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "expires"_s));
            RETURN_IF_EXCEPTION(throwScope, { });
        }
        if (!expiresValue.isUndefined()) {
            result.expires = convert<IDLNullable<IDLDouble>>(lexicalGlobalObject, expiresValue);
            RETURN_IF_EXCEPTION(throwScope, { });
        }
    }
    JSValue nameValue;
    if (isNullOrUndefined)
        nameValue = jsUndefined();
    else {
        nameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "name"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!nameValue.isUndefined()) {
        result.name = convert<IDLUSVString>(lexicalGlobalObject, nameValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().cookieStoreAPIExtendedAttributesEnabled) {
        JSValue pathValue;
        if (isNullOrUndefined)
            pathValue = jsUndefined();
        else {
            pathValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "path"_s));
            RETURN_IF_EXCEPTION(throwScope, { });
        }
        if (!pathValue.isUndefined()) {
            result.path = convert<IDLUSVString>(lexicalGlobalObject, pathValue);
            RETURN_IF_EXCEPTION(throwScope, { });
        }
    }
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().cookieStoreAPIExtendedAttributesEnabled) {
        JSValue sameSiteValue;
        if (isNullOrUndefined)
            sameSiteValue = jsUndefined();
        else {
            sameSiteValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sameSite"_s));
            RETURN_IF_EXCEPTION(throwScope, { });
        }
        if (!sameSiteValue.isUndefined()) {
            result.sameSite = convert<IDLEnumeration<CookieSameSite>>(lexicalGlobalObject, sameSiteValue);
            RETURN_IF_EXCEPTION(throwScope, { });
        }
    }
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().cookieStoreAPIExtendedAttributesEnabled) {
        JSValue secureValue;
        if (isNullOrUndefined)
            secureValue = jsUndefined();
        else {
            secureValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "secure"_s));
            RETURN_IF_EXCEPTION(throwScope, { });
        }
        if (!secureValue.isUndefined()) {
            result.secure = convert<IDLBoolean>(lexicalGlobalObject, secureValue);
            RETURN_IF_EXCEPTION(throwScope, { });
        }
    }
    JSValue valueValue;
    if (isNullOrUndefined)
        valueValue = jsUndefined();
    else {
        valueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "value"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!valueValue.isUndefined()) {
        result.value = convert<IDLUSVString>(lexicalGlobalObject, valueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const CookieListItem& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext()->settingsValues().cookieStoreAPIExtendedAttributesEnabled) {
        if (!IDLNullable<IDLUSVString>::isNullValue(dictionary.domain)) {
            auto domainValue = toJS<IDLNullable<IDLUSVString>>(lexicalGlobalObject, throwScope, IDLNullable<IDLUSVString>::extractValueFromNullable(dictionary.domain));
            RETURN_IF_EXCEPTION(throwScope, { });
            result->putDirect(vm, JSC::Identifier::fromString(vm, "domain"_s), domainValue);
        }
    }
    if (jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext()->settingsValues().cookieStoreAPIExtendedAttributesEnabled) {
        if (!IDLNullable<IDLDouble>::isNullValue(dictionary.expires)) {
            auto expiresValue = toJS<IDLNullable<IDLDouble>>(lexicalGlobalObject, throwScope, IDLNullable<IDLDouble>::extractValueFromNullable(dictionary.expires));
            RETURN_IF_EXCEPTION(throwScope, { });
            result->putDirect(vm, JSC::Identifier::fromString(vm, "expires"_s), expiresValue);
        }
    }
    if (!IDLUSVString::isNullValue(dictionary.name)) {
        auto nameValue = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, IDLUSVString::extractValueFromNullable(dictionary.name));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "name"_s), nameValue);
    }
    if (jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext()->settingsValues().cookieStoreAPIExtendedAttributesEnabled) {
        if (!IDLUSVString::isNullValue(dictionary.path)) {
            auto pathValue = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, IDLUSVString::extractValueFromNullable(dictionary.path));
            RETURN_IF_EXCEPTION(throwScope, { });
            result->putDirect(vm, JSC::Identifier::fromString(vm, "path"_s), pathValue);
        }
    }
    if (jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext()->settingsValues().cookieStoreAPIExtendedAttributesEnabled) {
        if (!IDLEnumeration<CookieSameSite>::isNullValue(dictionary.sameSite)) {
            auto sameSiteValue = toJS<IDLEnumeration<CookieSameSite>>(lexicalGlobalObject, throwScope, IDLEnumeration<CookieSameSite>::extractValueFromNullable(dictionary.sameSite));
            RETURN_IF_EXCEPTION(throwScope, { });
            result->putDirect(vm, JSC::Identifier::fromString(vm, "sameSite"_s), sameSiteValue);
        }
    }
    if (jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext()->settingsValues().cookieStoreAPIExtendedAttributesEnabled) {
        if (!IDLBoolean::isNullValue(dictionary.secure)) {
            auto secureValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, IDLBoolean::extractValueFromNullable(dictionary.secure));
            RETURN_IF_EXCEPTION(throwScope, { });
            result->putDirect(vm, JSC::Identifier::fromString(vm, "secure"_s), secureValue);
        }
    }
    if (!IDLUSVString::isNullValue(dictionary.value)) {
        auto valueValue = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, IDLUSVString::extractValueFromNullable(dictionary.value));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "value"_s), valueValue);
    }
    return result;
}

} // namespace WebCore
