/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAnalyserOptions.h"

#include "JSChannelCountMode.h"
#include "JSChannelInterpretation.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_AUDIO)

template<> AnalyserOptions convertDictionary<AnalyserOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    AnalyserOptions result;
    JSValue channelCountValue;
    if (isNullOrUndefined)
        channelCountValue = jsUndefined();
    else {
        channelCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelCount"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!channelCountValue.isUndefined()) {
        result.channelCount = convert<IDLUnsignedLong>(lexicalGlobalObject, channelCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue channelCountModeValue;
    if (isNullOrUndefined)
        channelCountModeValue = jsUndefined();
    else {
        channelCountModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelCountMode"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!channelCountModeValue.isUndefined()) {
        result.channelCountMode = convert<IDLEnumeration<ChannelCountMode>>(lexicalGlobalObject, channelCountModeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue channelInterpretationValue;
    if (isNullOrUndefined)
        channelInterpretationValue = jsUndefined();
    else {
        channelInterpretationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelInterpretation"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!channelInterpretationValue.isUndefined()) {
        result.channelInterpretation = convert<IDLEnumeration<ChannelInterpretation>>(lexicalGlobalObject, channelInterpretationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue fftSizeValue;
    if (isNullOrUndefined)
        fftSizeValue = jsUndefined();
    else {
        fftSizeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "fftSize"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!fftSizeValue.isUndefined()) {
        result.fftSize = convert<IDLUnsignedLong>(lexicalGlobalObject, fftSizeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.fftSize = 2048;
    JSValue maxDecibelsValue;
    if (isNullOrUndefined)
        maxDecibelsValue = jsUndefined();
    else {
        maxDecibelsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "maxDecibels"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!maxDecibelsValue.isUndefined()) {
        result.maxDecibels = convert<IDLDouble>(lexicalGlobalObject, maxDecibelsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.maxDecibels = -30;
    JSValue minDecibelsValue;
    if (isNullOrUndefined)
        minDecibelsValue = jsUndefined();
    else {
        minDecibelsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "minDecibels"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!minDecibelsValue.isUndefined()) {
        result.minDecibels = convert<IDLDouble>(lexicalGlobalObject, minDecibelsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.minDecibels = -100;
    JSValue smoothingTimeConstantValue;
    if (isNullOrUndefined)
        smoothingTimeConstantValue = jsUndefined();
    else {
        smoothingTimeConstantValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "smoothingTimeConstant"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!smoothingTimeConstantValue.isUndefined()) {
        result.smoothingTimeConstant = convert<IDLDouble>(lexicalGlobalObject, smoothingTimeConstantValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.smoothingTimeConstant = 0.8;
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_AUDIO)
