/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSANGLEInstancedArrays.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsANGLEInstancedArraysPrototypeFunction_drawArraysInstancedANGLE);
static JSC_DECLARE_HOST_FUNCTION(jsANGLEInstancedArraysPrototypeFunction_drawElementsInstancedANGLE);
static JSC_DECLARE_HOST_FUNCTION(jsANGLEInstancedArraysPrototypeFunction_vertexAttribDivisorANGLE);

class JSANGLEInstancedArraysPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSANGLEInstancedArraysPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSANGLEInstancedArraysPrototype* ptr = new (NotNull, JSC::allocateCell<JSANGLEInstancedArraysPrototype>(vm)) JSANGLEInstancedArraysPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSANGLEInstancedArraysPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSANGLEInstancedArraysPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSANGLEInstancedArraysPrototype, JSANGLEInstancedArraysPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSANGLEInstancedArraysPrototypeTableValues[] =
{
    { "drawArraysInstancedANGLE"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsANGLEInstancedArraysPrototypeFunction_drawArraysInstancedANGLE, 4 } },
    { "drawElementsInstancedANGLE"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsANGLEInstancedArraysPrototypeFunction_drawElementsInstancedANGLE, 5 } },
    { "vertexAttribDivisorANGLE"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsANGLEInstancedArraysPrototypeFunction_vertexAttribDivisorANGLE, 2 } },
    { "VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x88FE } },
};

const ClassInfo JSANGLEInstancedArraysPrototype::s_info = { "ANGLEInstancedArrays"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSANGLEInstancedArraysPrototype) };

void JSANGLEInstancedArraysPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSANGLEInstancedArrays::info(), JSANGLEInstancedArraysPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSANGLEInstancedArrays::s_info = { "ANGLEInstancedArrays"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSANGLEInstancedArrays) };

JSANGLEInstancedArrays::JSANGLEInstancedArrays(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ANGLEInstancedArrays>&& impl)
    : JSDOMWrapper<ANGLEInstancedArrays>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, ANGLEInstancedArrays>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSANGLEInstancedArrays::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSANGLEInstancedArraysPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSANGLEInstancedArraysPrototype::create(vm, &globalObject, structure);
}

JSObject* JSANGLEInstancedArrays::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSANGLEInstancedArrays>(vm, globalObject);
}

void JSANGLEInstancedArrays::destroy(JSC::JSCell* cell)
{
    JSANGLEInstancedArrays* thisObject = static_cast<JSANGLEInstancedArrays*>(cell);
    thisObject->JSANGLEInstancedArrays::~JSANGLEInstancedArrays();
}

static inline JSC::EncodedJSValue jsANGLEInstancedArraysPrototypeFunction_drawArraysInstancedANGLEBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSANGLEInstancedArrays>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto mode = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto first = convert<IDLLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto count = convert<IDLLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto primcount = convert<IDLLong>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.drawArraysInstancedANGLE(WTFMove(mode), WTFMove(first), WTFMove(count), WTFMove(primcount)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsANGLEInstancedArraysPrototypeFunction_drawArraysInstancedANGLE, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSANGLEInstancedArrays>::call<jsANGLEInstancedArraysPrototypeFunction_drawArraysInstancedANGLEBody>(*lexicalGlobalObject, *callFrame, "drawArraysInstancedANGLE");
}

static inline JSC::EncodedJSValue jsANGLEInstancedArraysPrototypeFunction_drawElementsInstancedANGLEBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSANGLEInstancedArrays>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto mode = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto count = convert<IDLLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto offset = convert<IDLLongLong>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto primcount = convert<IDLLong>(*lexicalGlobalObject, argument4.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.drawElementsInstancedANGLE(WTFMove(mode), WTFMove(count), WTFMove(type), WTFMove(offset), WTFMove(primcount)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsANGLEInstancedArraysPrototypeFunction_drawElementsInstancedANGLE, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSANGLEInstancedArrays>::call<jsANGLEInstancedArraysPrototypeFunction_drawElementsInstancedANGLEBody>(*lexicalGlobalObject, *callFrame, "drawElementsInstancedANGLE");
}

static inline JSC::EncodedJSValue jsANGLEInstancedArraysPrototypeFunction_vertexAttribDivisorANGLEBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSANGLEInstancedArrays>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto divisor = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.vertexAttribDivisorANGLE(WTFMove(index), WTFMove(divisor)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsANGLEInstancedArraysPrototypeFunction_vertexAttribDivisorANGLE, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSANGLEInstancedArrays>::call<jsANGLEInstancedArraysPrototypeFunction_vertexAttribDivisorANGLEBody>(*lexicalGlobalObject, *callFrame, "vertexAttribDivisorANGLE");
}

JSC::GCClient::IsoSubspace* JSANGLEInstancedArrays::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSANGLEInstancedArrays, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForANGLEInstancedArrays.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForANGLEInstancedArrays = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForANGLEInstancedArrays.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForANGLEInstancedArrays = std::forward<decltype(space)>(space); }
    );
}

void JSANGLEInstancedArrays::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSANGLEInstancedArrays*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSANGLEInstancedArraysOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsANGLEInstancedArrays = jsCast<JSANGLEInstancedArrays*>(handle.slot()->asCell());
    WebGLRenderingContextBase* owner = WTF::getPtr(jsANGLEInstancedArrays->wrapped().context());
    if (UNLIKELY(reason))
        *reason = "Reachable from ANGLEInstancedArrays";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSANGLEInstancedArraysOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsANGLEInstancedArrays = static_cast<JSANGLEInstancedArrays*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsANGLEInstancedArrays->wrapped(), jsANGLEInstancedArrays);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ANGLEInstancedArrays@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore20ANGLEInstancedArraysE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ANGLEInstancedArrays>&& impl)
{

    if constexpr (std::is_polymorphic_v<ANGLEInstancedArrays>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7ANGLEInstancedArrays@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore20ANGLEInstancedArraysE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // ANGLEInstancedArrays has subclasses. If ANGLEInstancedArrays has subclasses that get passed
        // to toJS() we currently require ANGLEInstancedArrays you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<ANGLEInstancedArrays>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ANGLEInstancedArrays& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

ANGLEInstancedArrays* JSANGLEInstancedArrays::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSANGLEInstancedArrays*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
