/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import com.google.common.collect.Lists;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Optional;
import javafx.animation.PauseTransition;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.embed.swing.JFXPanel;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.TabPane;
import javafx.util.Duration;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import jiconfont.icons.FontAwesome;
import jiconfont.swing.IconFontSwing;
import mediathek.config.Daten;
import mediathek.config.Icons;
import mediathek.config.Konstanten;
import mediathek.config.MVConfig;
import mediathek.controller.history.SeenHistoryController;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenBlacklist;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenPset;
import mediathek.daten.ListeBlacklist;
import mediathek.daten.ListePset;
import mediathek.filmeSuchen.ListenerFilmeLaden;
import mediathek.filmeSuchen.ListenerFilmeLadenEvent;
import mediathek.gui.AGuiTabPanel;
import mediathek.gui.GuiFilmeModelHelper;
import mediathek.gui.TabPaneIndex;
import mediathek.gui.actions.ShowBlacklistDialogAction;
import mediathek.gui.actions.ShowFilmInformationAction;
import mediathek.gui.dialog.DialogAboNoSet;
import mediathek.gui.dialog.DialogAddDownload;
import mediathek.gui.dialog.DialogAddMoreDownload;
import mediathek.gui.dialog.DialogEditAbo;
import mediathek.gui.dialog.DialogMediaDB;
import mediathek.gui.messages.AboListChangedEvent;
import mediathek.gui.messages.ButtonStartEvent;
import mediathek.gui.messages.DownloadListChangedEvent;
import mediathek.gui.messages.PsetNumberOfButtonsChangedEvent;
import mediathek.gui.messages.StartEvent;
import mediathek.gui.messages.UpdateStatusBarLeftDisplayEvent;
import mediathek.gui.messages.history.DownloadHistoryChangedEvent;
import mediathek.gui.tab_film.BeobOpenPlayer;
import mediathek.gui.tab_film.IButtonPanelController;
import mediathek.gui.tab_film.SwingButtonPanelController;
import mediathek.javafx.descriptionPanel.DescriptionPanelController;
import mediathek.javafx.filmtab.FilmTabInfoPane;
import mediathek.javafx.filterpanel.FilmActionPanel;
import mediathek.javafx.tool.JavaFxUtils;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.Datum;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.Listener;
import mediathek.tool.Log;
import mediathek.tool.MVMessageDialog;
import mediathek.tool.NoSelectionErrorDialog;
import mediathek.tool.cellrenderer.CellRendererFilme;
import mediathek.tool.listener.BeobTableHeader;
import mediathek.tool.models.TModelFilm;
import mediathek.tool.table.MVFilmTable;
import net.engio.mbassy.listener.Handler;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.SystemUtils;

public class GuiFilme
extends AGuiTabPanel {
    public static final String NAME = "Filme";
    private static final String ACTION_MAP_KEY_PLAY_FILM = "film_abspielen";
    private static final String ACTION_MAP_KEY_SAVE_FILM = "download_film";
    private static final String ACTION_MAP_KEY_COPY_NORMAL_URL = "copy_url";
    private static final String ACTION_MAP_KEY_COPY_HD_URL = "copy_url_hd";
    private static final String ACTION_MAP_KEY_COPY_KLEIN_URL = "copy_url_klein";
    private static final String ACTION_MAP_KEY_MEDIA_DB = "mediadb";
    private static final String ACTION_MAP_KEY_MARK_SEEN = "seen";
    private static final String ACTION_MAP_KEY_MARK_UNSEEN = "unseen";
    private static final int[] HIDDEN_COLUMNS = new int[]{4, 5};
    public final FilterFilmAction filterFilmAction = new FilterFilmAction();
    public final PlayFilmAction playAction = new PlayFilmAction();
    public final SaveFilmAction saveFilmAction = new SaveFilmAction();
    private final MarkFilmAsSeenAction markFilmAsSeenAction = new MarkFilmAsSeenAction();
    private final MarkFilmAsUnseenAction markFilmAsUnseenAction = new MarkFilmAsUnseenAction();
    private final JScrollPane filmListScrollPane = new JScrollPane();
    private final JPanel descriptionPanel = new JPanel();
    private final JPanel extensionArea = new JPanel();
    private final JCheckBoxMenuItem cbkShowDescription = new JCheckBoxMenuItem("Beschreibung anzeigen");
    public FilmActionPanel fap;
    private final MediensammlungAction mediensammlungAction = new MediensammlungAction();
    private JFXPanel fxFilmActionPanel;
    private boolean stopBeob = false;
    private FilmTabInfoPane filmInfoLabel;
    private JFXPanel fxDescriptionPanel;
    private IButtonPanelController buttonPanelController;

    public GuiFilme(Daten aDaten, MediathekGui mediathekGui) {
        this.daten = aDaten;
        this.mediathekGui = mediathekGui;
        this.setLayout(new BorderLayout());
        this.createFilmListArea();
        this.createExtensionArea();
        this.createFilmActionPanel();
        this.createDescriptionPanel();
        this.setupFilmListTable();
        this.installTabInfoStatusBarControl();
        this.setupFilmSelectionPropertyListener(mediathekGui);
        this.setupButtonPanel();
        this.setupDescriptionPanel();
        this.setupFilmActionPanel();
        this.start_init();
        this.start_addListener();
        this.setupActionListeners();
    }

    private void setupFilmListTable() {
        this.tabelle = new MVFilmTable();
        this.filmListScrollPane.setViewportView(this.tabelle);
    }

    private void createFilmActionPanel() {
        this.fxFilmActionPanel = new JFXPanel();
        this.add((Component)this.fxFilmActionPanel, "North");
    }

    private void setupFilmSelectionPropertyListener(final MediathekGui mediathekGui) {
        this.tabelle.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                int sel = this.tabelle.getSelectedRowCount();
                Platform.runLater(() -> mediathekGui.getSelectedItemsProperty().setValue(sel));
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                int sel = GuiFilme.this.tabelle.getSelectedRowCount();
                Platform.runLater(() -> mediathekGui.getSelectedItemsProperty().setValue(sel));
                GuiFilme.this.onComponentShown();
            }
        });
    }

    private void installTabInfoStatusBarControl() {
        final ObservableList<Node> leftItems = this.mediathekGui.getStatusBarController().getStatusBar().getLeftItems();
        Platform.runLater(() -> {
            this.filmInfoLabel = new FilmTabInfoPane(this.daten, this);
            if (this.isVisible()) {
                leftItems.add(this.filmInfoLabel);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                Platform.runLater(() -> {
                    GuiFilme.this.filmInfoLabel.setVisible(true);
                    leftItems.add(GuiFilme.this.filmInfoLabel);
                });
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                Platform.runLater(() -> {
                    GuiFilme.this.filmInfoLabel.setVisible(false);
                    leftItems.remove(GuiFilme.this.filmInfoLabel);
                });
            }
        });
    }

    private void createFilmListArea() {
        this.add((Component)this.filmListScrollPane, "Center");
    }

    private void createDescriptionPanel() {
        this.descriptionPanel.setLayout(new BorderLayout());
        this.extensionArea.add((Component)this.descriptionPanel, new CC().cell(0, 0));
        this.fxDescriptionPanel = new JFXPanel();
        this.descriptionPanel.add((Component)this.fxDescriptionPanel, "Center");
    }

    private void createExtensionArea() {
        this.extensionArea.setLayout(new MigLayout(new LC().insets("0").hideMode(3).gridGap("0", "0"), new AC().grow().fill(), new AC().grow().fill().gap().grow().fill()));
        this.add((Component)this.extensionArea, "South");
    }

    public void installMenuEntries(JMenu menu) {
        JMenuItem miPlayFilm = new JMenuItem("Film abspielen");
        if (SystemUtils.IS_OS_MAC_OSX) {
            miPlayFilm.setAccelerator(KeyStroke.getKeyStroke(117, 256));
        } else {
            miPlayFilm.setAccelerator(KeyStroke.getKeyStroke(80, 128));
        }
        miPlayFilm.setIcon(IconFontSwing.buildIcon(FontAwesome.PLAY, 16.0f));
        miPlayFilm.addActionListener(this.playAction);
        JMenuItem miRecordFilm = new JMenuItem("Film aufzeichnen");
        if (SystemUtils.IS_OS_MAC_OSX) {
            miRecordFilm.setAccelerator(KeyStroke.getKeyStroke(118, 256));
        } else {
            miRecordFilm.setAccelerator(KeyStroke.getKeyStroke(68, 128));
        }
        miRecordFilm.setIcon(IconFontSwing.buildIcon(FontAwesome.DOWNLOAD, 16.0f));
        miRecordFilm.addActionListener(this.saveFilmAction);
        JMenuItem miOpenBlacklist = new JMenuItem("Blacklist \u00f6ffnen");
        if (SystemUtils.IS_OS_MAC_OSX) {
            miOpenBlacklist.setAccelerator(KeyStroke.getKeyStroke(120, 256));
        } else {
            miOpenBlacklist.setAccelerator(KeyStroke.getKeyStroke(66, 128));
        }
        miOpenBlacklist.setAction(new ShowBlacklistDialogAction(this.mediathekGui, this.daten));
        if (!SystemUtils.IS_OS_MAC_OSX) {
            this.cbkShowDescription.setAccelerator(KeyStroke.getKeyStroke(121, 0));
        }
        JMenuItem miMarkFilmAsSeen = new JMenuItem("Filme als gesehen markieren");
        miMarkFilmAsSeen.setAccelerator(KeyStroke.getKeyStroke(71, 128));
        miMarkFilmAsSeen.setIcon(Icons.ICON_MENUE_HISTORY_ADD);
        miMarkFilmAsSeen.addActionListener(this.markFilmAsSeenAction);
        JMenuItem miMarkFilmAsUnseen = new JMenuItem("Filme als ungesehen markieren");
        miMarkFilmAsUnseen.setAccelerator(KeyStroke.getKeyStroke(78, 128));
        miMarkFilmAsUnseen.setIcon(Icons.ICON_MENUE_HISTORY_REMOVE);
        miMarkFilmAsUnseen.addActionListener(this.markFilmAsUnseenAction);
        JMenuItem miSearchMediaCollection = new JMenuItem("Titel in der Mediensammlung suchen");
        miSearchMediaCollection.setAccelerator(KeyStroke.getKeyStroke(77, 128));
        miSearchMediaCollection.addActionListener(this.mediensammlungAction);
        menu.add(miPlayFilm);
        menu.add(miRecordFilm);
        menu.add(miMarkFilmAsSeen);
        menu.add(miMarkFilmAsUnseen);
        menu.addSeparator();
        menu.add(miOpenBlacklist);
        menu.addSeparator();
        menu.add(this.cbkShowDescription);
        menu.addSeparator();
        menu.add(miSearchMediaCollection);
    }

    private void setupFilmActionPanel() {
        this.fap = new FilmActionPanel(this.daten);
        JavaFxUtils.invokeInFxThreadAndWait(() -> this.fxFilmActionPanel.setScene(this.fap.getFilmActionPanelScene()));
    }

    private void setupDescriptionPanel() {
        JavaFxUtils.invokeInFxThreadAndWait(() -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                loader.setLocation(Konstanten.FXML_FILM_DESCRIPTION_PANEL_URL);
                TabPane descriptionPane = (TabPane)loader.load();
                DescriptionPanelController descriptionPanelController = (DescriptionPanelController)loader.getController();
                descriptionPanelController.setOnCloseRequest(e -> {
                    SwingUtilities.invokeLater(() -> this.descriptionPanel.setVisible(false));
                    e.consume();
                });
                this.fxDescriptionPanel.setScene(new Scene(descriptionPane));
                SwingUtilities.invokeLater(() -> this.tabelle.getSelectionModel().addListSelectionListener(e -> {
                    Optional<DatenFilm> optFilm = this.getCurrentlySelectedFilm();
                    Platform.runLater(() -> descriptionPanelController.showFilmDescription(optFilm));
                }));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    private void showDescriptionPanel() {
        this.descriptionPanel.setVisible(ApplicationConfiguration.getConfiguration().getBoolean("film.show_description", true));
    }

    private void onComponentShown() {
        this.mediathekGui.tabPaneIndexProperty().setValue(TabPaneIndex.FILME);
        this.updateFilmData();
        this.setInfoStatusbar();
    }

    public int getTableRowCount() {
        if (this.tabelle != null) {
            return this.tabelle.getModel().getRowCount();
        }
        return 0;
    }

    private void setupKeyMapping() {
        InputMap focusedWindowMap = this.tabelle.getInputMap();
        focusedWindowMap.put(KeyStroke.getKeyStroke(80, 0), ACTION_MAP_KEY_PLAY_FILM);
        focusedWindowMap.put(KeyStroke.getKeyStroke(10, 0), ACTION_MAP_KEY_PLAY_FILM);
        focusedWindowMap.put(KeyStroke.getKeyStroke(68, 0), ACTION_MAP_KEY_SAVE_FILM);
        focusedWindowMap.put(KeyStroke.getKeyStroke(72, 0), ACTION_MAP_KEY_COPY_HD_URL);
        focusedWindowMap.put(KeyStroke.getKeyStroke(78, 0), ACTION_MAP_KEY_COPY_NORMAL_URL);
        focusedWindowMap.put(KeyStroke.getKeyStroke(75, 0), ACTION_MAP_KEY_COPY_KLEIN_URL);
        focusedWindowMap.put(KeyStroke.getKeyStroke(77, 0), ACTION_MAP_KEY_MEDIA_DB);
        focusedWindowMap.put(KeyStroke.getKeyStroke(71, 0), ACTION_MAP_KEY_MARK_SEEN);
        focusedWindowMap.put(KeyStroke.getKeyStroke(85, 0), ACTION_MAP_KEY_MARK_UNSEEN);
        ActionMap actionMap = this.tabelle.getActionMap();
        actionMap.put(ACTION_MAP_KEY_PLAY_FILM, this.playAction);
        actionMap.put(ACTION_MAP_KEY_SAVE_FILM, this.saveFilmAction);
        actionMap.put(ACTION_MAP_KEY_COPY_NORMAL_URL, new CopyUrlToClipboardAction("normal"));
        actionMap.put(ACTION_MAP_KEY_COPY_HD_URL, new CopyUrlToClipboardAction("hd"));
        actionMap.put(ACTION_MAP_KEY_COPY_KLEIN_URL, new CopyUrlToClipboardAction("klein"));
        actionMap.put(ACTION_MAP_KEY_MEDIA_DB, this.mediensammlungAction);
        actionMap.put(ACTION_MAP_KEY_MARK_SEEN, this.markFilmAsSeenAction);
        actionMap.put(ACTION_MAP_KEY_MARK_UNSEEN, this.markFilmAsUnseenAction);
    }

    private void setupCellRenderer() {
        CellRendererFilme cellRenderer = new CellRendererFilme(this.daten);
        this.tabelle.setDefaultRenderer(Object.class, cellRenderer);
        this.tabelle.setDefaultRenderer(Datum.class, cellRenderer);
        this.tabelle.setDefaultRenderer(Integer.class, cellRenderer);
    }

    private void start_init() {
        this.showDescriptionPanel();
        this.daten.getFilmeLaden().addAdListener(new ListenerFilmeLaden(){

            @Override
            public void start(ListenerFilmeLadenEvent event) {
                GuiFilme.this.loadTable();
            }

            @Override
            public void fertig(ListenerFilmeLadenEvent event) {
                GuiFilme.this.loadTable();
                Platform.runLater(() -> GuiFilme.this.fap.updateThemaBox());
            }
        });
        this.setupKeyMapping();
        this.tabelle.setModel(new TModelFilm());
        this.tabelle.addMouseListener(new BeobMausTabelle());
        this.tabelle.getSelectionModel().addListSelectionListener(event -> {
            ListSelectionModel m3 = (ListSelectionModel)event.getSource();
            if (!(m3.isSelectionEmpty() || m3.getValueIsAdjusting() || this.stopBeob)) {
                this.updateFilmData();
            }
        });
        this.setupCellRenderer();
        this.tabelle.setLineBreak(MVConfig.getBool(MVConfig.Configs.SYSTEM_TAB_FILME_LINEBREAK));
        this.setupHeaderPopupMenu();
        this.setVisFilterPanelAndLoad();
        this.tabelle.initTabelle();
        if (this.tabelle.getRowCount() > 0) {
            this.tabelle.setRowSelectionInterval(0, 0);
        }
    }

    private void setupHeaderPopupMenu() {
        BeobTableHeader headerListener = new BeobTableHeader(this.tabelle, Daten.spaltenAnzeigenFilme, HIDDEN_COLUMNS, new int[]{4, 5}, true, MVConfig.Configs.SYSTEM_TAB_FILME_LINEBREAK);
        this.tabelle.getTableHeader().addMouseListener(headerListener);
    }

    @Handler
    private void handleDownloadHistoryChangedEvent(DownloadHistoryChangedEvent e) {
        SwingUtilities.invokeLater(() -> {
            if (this.fap.showUnseenOnly.getValue().booleanValue()) {
                this.loadTable();
            } else {
                this.tabelle.fireTableDataChanged(true);
            }
        });
    }

    @Handler
    private void handleButtonStart(ButtonStartEvent e) {
        SwingUtilities.invokeLater(() -> {
            this.tabelle.fireTableDataChanged(true);
            this.setInfoStatusbar();
        });
    }

    @Handler
    private void handleAboListChanged(AboListChangedEvent e) {
        SwingUtilities.invokeLater(this::loadTable);
    }

    private void start_addListener() {
        this.daten.getMessageBus().subscribe(this);
        Listener.addListener(new Listener(2, GuiFilme.class.getSimpleName()){

            @Override
            public void ping() {
                GuiFilme.this.buttonPanelController.setupButtons();
                GuiFilme.this.buttonPanelController.setVisible(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_PANEL_VIDEOPLAYER_ANZEIGEN)));
            }
        });
        Listener.addListener(new Listener(39, GuiFilme.class.getSimpleName()){

            @Override
            public void ping() {
                GuiFilme.this.loadTable();
            }
        });
    }

    @Handler
    private void handleStartEvent(StartEvent msg) {
        SwingUtilities.invokeLater(this::setInfoStatusbar);
    }

    private synchronized void saveFilm(DatenPset pSet) {
        if (Daten.listePset.getListeSpeichern().isEmpty()) {
            new DialogAboNoSet(this.mediathekGui).setVisible(true);
            return;
        }
        ArrayList<DatenFilm> liste = this.getSelFilme();
        boolean standard = false;
        String pfad = "";
        boolean info = false;
        boolean subtitle = false;
        if (liste.size() > 1) {
            if (pSet == null) {
                pSet = (DatenPset)Daten.listePset.getListeSpeichern().getFirst();
            }
            DialogAddMoreDownload damd = new DialogAddMoreDownload(this.mediathekGui, pSet);
            damd.setVisible(true);
            standard = damd.addAll;
            pfad = damd.getPath();
            info = damd.info;
            subtitle = damd.subtitle;
            if (damd.cancel) {
                return;
            }
        }
        for (DatenFilm datenFilm : liste) {
            int ret;
            DatenDownload datenDownload = this.daten.getListeDownloads().getDownloadUrlFilm(datenFilm.getUrl());
            if (datenDownload != null && (ret = JOptionPane.showConfirmDialog(this.mediathekGui, "Download f\u00fcr den Film existiert bereits.\nNochmal anlegen?", "Anlegen?", 0)) != 0) continue;
            if (standard) {
                if (pSet == null) {
                    pSet = (DatenPset)Daten.listePset.getListeSpeichern().getFirst();
                }
                datenDownload = new DatenDownload(pSet, datenFilm, 2, null, "", pfad, "");
                datenDownload.arr[35] = Boolean.toString(info);
                datenDownload.arr[37] = Boolean.toString(subtitle);
                this.daten.getListeDownloads().addMitNummer(datenDownload);
                this.daten.getMessageBus().publishAsync(new DownloadListChangedEvent());
                if (!Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD_D_STARTEN))) continue;
                datenDownload.startDownload(this.daten);
                continue;
            }
            String aufloesung = "";
            if (this.fap.showOnlyHd.getValue().booleanValue()) {
                aufloesung = "hd";
            }
            DialogAddDownload dialog = new DialogAddDownload(this.mediathekGui, this.daten, datenFilm, pSet, aufloesung);
            dialog.setVisible(true);
        }
    }

    public void playerStarten(DatenPset pSet) {
        if (this.tabelle.getSelectedRow() == -1) {
            NoSelectionErrorDialog.show();
        } else if (pSet.istSpeichern()) {
            this.saveFilm(pSet);
        } else {
            String aufloesung = this.fap.showOnlyHd.getValue() != false ? "hd" : "";
            Optional<DatenFilm> filmSelection = this.getCurrentlySelectedFilm();
            filmSelection.ifPresent(film -> this.daten.starterClass.urlMitProgrammStarten(pSet, (DatenFilm)film, aufloesung));
        }
    }

    private Optional<DatenFilm> getFilm(int zeileTabelle) {
        if (zeileTabelle >= 0 && zeileTabelle < this.tabelle.getRowCount()) {
            return Optional.of((DatenFilm)this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(zeileTabelle), 17));
        }
        return Optional.empty();
    }

    private Optional<DatenFilm> getCurrentlySelectedFilm() {
        int selectedTableRow = this.tabelle.getSelectedRow();
        if (selectedTableRow >= 0) {
            return Optional.of((DatenFilm)this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(selectedTableRow), 17));
        }
        return Optional.empty();
    }

    private ArrayList<DatenFilm> getSelFilme() {
        ArrayList<DatenFilm> arrayFilme = new ArrayList<DatenFilm>();
        int[] rows = this.tabelle.getSelectedRows();
        if (rows.length > 0) {
            for (int row : rows) {
                DatenFilm datenFilm = (DatenFilm)this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(row), 17);
                arrayFilme.add(datenFilm);
            }
        } else {
            NoSelectionErrorDialog.show();
        }
        return arrayFilme;
    }

    private void updateFilmData() {
        Optional<DatenFilm> filmSelection = this.getCurrentlySelectedFilm();
        filmSelection.ifPresent(this.mediathekGui.getFilmInfoDialog()::updateCurrentFilm);
    }

    private void setInfoStatusbar() {
        this.daten.getMessageBus().publishAsync(new UpdateStatusBarLeftDisplayEvent());
    }

    @Handler
    private void handlePsetButtonChangedEvent(PsetNumberOfButtonsChangedEvent e) {
        SwingUtilities.invokeLater(() -> this.buttonPanelController.setupButtons());
    }

    public IButtonPanelController getButtonPanelController() {
        return this.buttonPanelController;
    }

    private void setupButtonPanel() {
        this.buttonPanelController = new SwingButtonPanelController(this, this.extensionArea);
        this.buttonPanelController.setupButtons();
        this.buttonPanelController.setVisible(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_PANEL_VIDEOPLAYER_ANZEIGEN)));
    }

    private void reloadTable() {
        if (!this.stopBeob) {
            this.loadTable();
        }
    }

    private void setVisFilterPanelAndLoad() {
        this.updateUI();
        this.loadTable();
    }

    private void setupActionListeners() {
        Platform.runLater(() -> {
            ChangeListener<Boolean> reloadTableListener = (observable2, oldValue, newValue) -> SwingUtilities.invokeLater(this::reloadTable);
            this.fap.showOnlyHd.addListener(reloadTableListener);
            this.fap.showSubtitlesOnly.addListener(reloadTableListener);
            this.fap.showNewOnly.addListener(reloadTableListener);
            this.fap.showUnseenOnly.addListener(reloadTableListener);
            this.fap.dontShowAbos.addListener(reloadTableListener);
            this.fap.dontShowTrailers.addListener(reloadTableListener);
            this.fap.dontShowSignLanguage.addListener(reloadTableListener);
            this.fap.dontShowAudioVersions.addListener(reloadTableListener);
            this.fap.showLivestreamsOnly.addListener(reloadTableListener);
            this.fap.filmLengthSlider.lowValueChangingProperty().addListener((observable2, oldValue, newValue) -> {
                if (!newValue.booleanValue()) {
                    SwingUtilities.invokeLater(this::reloadTable);
                }
            });
            this.fap.filmLengthSlider.highValueChangingProperty().addListener((observable2, oldValue, newValue) -> {
                if (!newValue.booleanValue()) {
                    SwingUtilities.invokeLater(this::reloadTable);
                }
            });
            this.fap.searchThroughDescription.addListener((os, o, n) -> {
                if (!this.fap.roSearchStringProperty.getReadOnlyProperty().isEmpty().get()) {
                    SwingUtilities.invokeLater(this::reloadTable);
                }
            });
            this.setupSenderListListeners();
            this.setupZeitraumListener();
            this.fap.themaBox.setOnAction(evt -> SwingUtilities.invokeLater(this::reloadTable));
        });
        this.setupShowFilmDescriptionMenuItem();
    }

    private void setupShowFilmDescriptionMenuItem() {
        this.cbkShowDescription.setSelected(ApplicationConfiguration.getConfiguration().getBoolean("film.show_description", true));
        this.cbkShowDescription.addActionListener(l -> this.descriptionPanel.setVisible(this.cbkShowDescription.isSelected()));
        this.cbkShowDescription.addItemListener(e -> ApplicationConfiguration.getConfiguration().setProperty("film.show_description", this.cbkShowDescription.isSelected()));
        this.descriptionPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                GuiFilme.this.cbkShowDescription.setSelected(true);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                GuiFilme.this.cbkShowDescription.setSelected(false);
            }
        });
    }

    private void setupZeitraumListener() {
        PauseTransition trans = new PauseTransition(Duration.millis(250.0));
        trans.setOnFinished(evt -> {
            this.fap.senderList.getCheckModel().clearChecks();
            SwingUtilities.invokeLater(() -> {
                this.daten.getListeBlacklist().filterListe();
                this.loadTable();
            });
        });
        this.fap.zeitraumProperty.addListener((observable2, oldValue, newValue) -> trans.playFromStart());
    }

    private void setupSenderListListeners() {
        PauseTransition filterSenderDelay = new PauseTransition(Duration.millis(750.0));
        filterSenderDelay.setOnFinished(e -> SwingUtilities.invokeLater(this::reloadTable));
        this.fap.senderList.getCheckModel().getCheckedItems().addListener(c -> filterSenderDelay.playFromStart());
    }

    private synchronized void loadTable() {
        try {
            this.stopBeob = true;
            this.tabelle.getSpalten();
            GuiFilmeModelHelper helper = new GuiFilmeModelHelper(this.fap, this.daten, this.tabelle);
            helper.prepareTableModel();
            this.setInfoStatusbar();
            this.tabelle.setSpalten();
            this.updateFilmData();
            this.stopBeob = false;
        }
        catch (Exception ex) {
            Log.errorLog(558965421, ex);
        }
        this.tabelle.scrollToSelection();
    }

    public class FilterFilmAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFilme.this.loadTable();
        }
    }

    public class PlayFilmAction
    extends AbstractAction {
        @Override
        public synchronized void actionPerformed(ActionEvent e) {
            DatenPset pset = Daten.listePset.getPsetAbspielen();
            if (pset != null) {
                GuiFilme.this.playerStarten(pset);
            } else {
                MVMessageDialog.showMessageDialog(GuiFilme.this.mediathekGui, "Im Men\u00fc unter \"Datei->Einstellungen->Set bearbeiten\" ein Programm zum Abspielen festlegen.", "kein Videoplayer!", 1);
            }
        }
    }

    public class SaveFilmAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFilme.this.saveFilm(null);
        }
    }

    private class MarkFilmAsSeenAction
    extends AbstractAction {
        private MarkFilmAsSeenAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFilme.this.daten.getSeenHistoryController().markAsSeen(GuiFilme.this.getSelFilme());
        }
    }

    private class MarkFilmAsUnseenAction
    extends AbstractAction {
        private MarkFilmAsUnseenAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFilme.this.daten.getSeenHistoryController().markAsUnseen(GuiFilme.this.getSelFilme());
        }
    }

    private class MediensammlungAction
    extends AbstractAction {
        private MediensammlungAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Optional<DatenFilm> filmSelection = GuiFilme.this.getCurrentlySelectedFilm();
            filmSelection.ifPresent(film -> {
                MVConfig.add(MVConfig.Configs.SYSTEM_MEDIA_DB_DIALOG_ANZEIGEN, Boolean.TRUE.toString());
                DialogMediaDB mediaDB = GuiFilme.this.mediathekGui.getMediaDatabaseDialog();
                mediaDB.setVis();
                mediaDB.setFilter(film.getTitle());
            });
        }
    }

    private class CopyUrlToClipboardAction
    extends AbstractAction {
        private final String resolution;

        CopyUrlToClipboardAction(String resolution) {
            this.resolution = resolution;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Optional<DatenFilm> filmSelection = GuiFilme.this.getCurrentlySelectedFilm();
            filmSelection.ifPresent(film -> GuiFunktionen.copyToClipboard(film.getUrlFuerAufloesung(this.resolution)));
        }
    }

    public class BeobMausTabelle
    extends MouseAdapter {
        private final BeobPrint beobPrint = new BeobPrint();
        private final BeobAbo beobAbo = new BeobAbo(false);
        private final BeobAbo beobAboMitTitel = new BeobAbo(true);
        private final BeobBlacklist beobBlacklistSender = new BeobBlacklist(true, false);
        private final BeobBlacklist beobBlacklistSenderThema = new BeobBlacklist(true, true);
        private final BeobBlacklist beobBlacklistThema = new BeobBlacklist(false, true);
        private final JMenuItem miPlay = this.createPlayItem();
        private final JMenuItem miSave = this.createSaveFilmItem();
        private final ShowFilmInformationAction showFilmInformationAction = new ShowFilmInformationAction(false);
        private final ActionListener unseenActionListener = new BeobHistory(false);
        private final ActionListener seenActionListener = new BeobHistory(true);
        private Point p;

        BeobMausTabelle() {
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getButton() == 1) {
                if (arg0.getClickCount() == 1) {
                    this.p = arg0.getPoint();
                    int row = GuiFilme.this.tabelle.rowAtPoint(this.p);
                    int column = GuiFilme.this.tabelle.columnAtPoint(this.p);
                    if (row >= 0) {
                        this.buttonTable(row, column);
                    }
                } else if (arg0.getClickCount() > 1 && !GuiFilme.this.mediathekGui.getFilmInfoDialog().isVisible()) {
                    GuiFilme.this.mediathekGui.getFilmInfoDialog().showInfo();
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        private void buttonTable(int row, int column) {
            if (row != -1) {
                if (GuiFilme.this.tabelle.convertColumnIndexToModel(column) == 4) {
                    Optional<DatenFilm> filmSelection = GuiFilme.this.getCurrentlySelectedFilm();
                    filmSelection.ifPresent(datenFilm -> {
                        boolean stop = false;
                        DatenDownload datenDownload = GuiFilme.this.daten.getListeDownloadsButton().getDownloadUrlFilm(datenFilm.getUrl());
                        if (datenDownload != null && datenDownload.start != null && datenDownload.start.status == 2) {
                            stop = true;
                            GuiFilme.this.daten.getListeDownloadsButton().delDownloadButton(datenFilm.getUrl());
                        }
                        if (!stop) {
                            GuiFilme.this.playAction.actionPerformed(null);
                        }
                    });
                } else if (GuiFilme.this.tabelle.convertColumnIndexToModel(column) == 5) {
                    GuiFilme.this.saveFilm(null);
                }
            }
        }

        private JMenuItem createPlayItem() {
            JMenuItem item = new JMenuItem("Film abspielen");
            item.setIcon(IconFontSwing.buildIcon(FontAwesome.PLAY, 16.0f));
            item.addActionListener(GuiFilme.this.playAction);
            return item;
        }

        private JMenuItem createSaveFilmItem() {
            JMenuItem item = new JMenuItem("Film aufzeichnen");
            item.setIcon(IconFontSwing.buildIcon(FontAwesome.DOWNLOAD, 16.0f));
            item.addActionListener(GuiFilme.this.saveFilmAction);
            return item;
        }

        private void showMenu(MouseEvent evt) {
            this.p = evt.getPoint();
            int nr = GuiFilme.this.tabelle.rowAtPoint(this.p);
            if (nr >= 0) {
                GuiFilme.this.tabelle.setRowSelectionInterval(nr, nr);
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(this.miPlay);
            jPopupMenu.add(this.miSave);
            jPopupMenu.addSeparator();
            JMenu submenueAbo = new JMenu("Abo");
            jPopupMenu.add(submenueAbo);
            JMenuItem itemAboLoeschen = new JMenuItem("Abo L\u00f6schen");
            JMenuItem itemAbo = new JMenuItem("Abo mit Sender und Thema anlegen");
            JMenuItem itemAboMitTitel = new JMenuItem("Abo mit Sender und Thema und Titel anlegen");
            JMenuItem itemChangeAboFilter = new JMenuItem("Abo \u00e4ndern");
            Optional<DatenFilm> res = GuiFilme.this.getFilm(nr);
            res.ifPresent(film -> {
                if (GuiFilme.this.daten.getListeAbo().getAboFuerFilm_schnell((DatenFilm)film, false) != null) {
                    itemAbo.setEnabled(false);
                    itemAboMitTitel.setEnabled(false);
                    itemAboLoeschen.addActionListener(this.beobAbo);
                    itemChangeAboFilter.addActionListener(new BeobChangeAbo());
                } else {
                    itemAboLoeschen.setEnabled(false);
                    itemChangeAboFilter.setEnabled(false);
                    itemAbo.addActionListener(this.beobAbo);
                    itemAboMitTitel.addActionListener(this.beobAboMitTitel);
                }
            });
            submenueAbo.add(itemAboLoeschen);
            submenueAbo.add(itemChangeAboFilter);
            submenueAbo.add(itemAbo);
            submenueAbo.add(itemAboMitTitel);
            JMenu submenue = new JMenu("Film mit Set starten");
            jPopupMenu.add(submenue);
            ListePset liste = Daten.listePset.getListeButton();
            for (DatenPset pset : liste) {
                if (pset.getListeProg().isEmpty() && pset.arr[0].isEmpty()) continue;
                Color col = pset.getFarbe();
                JMenuItem item = new JMenuItem(pset.arr[0]);
                if (pset.getListeProg().isEmpty()) {
                    if (col != null) {
                        item.setForeground(col);
                    }
                } else {
                    item.addActionListener(new BeobOpenPlayer(GuiFilme.this, pset));
                    if (col != null) {
                        item.setBackground(col);
                    }
                }
                submenue.add(item);
            }
            JMenu submenueBlack = new JMenu("Blacklist");
            jPopupMenu.add(submenueBlack);
            JMenuItem itemBlackSender = new JMenuItem("Sender in die Blacklist einf\u00fcgen");
            JMenuItem itemBlackThema = new JMenuItem("Thema in die Blacklist einf\u00fcgen");
            JMenuItem itemBlackSenderThema = new JMenuItem("Sender und Thema in die Blacklist einf\u00fcgen");
            itemBlackSender.addActionListener(this.beobBlacklistSender);
            itemBlackThema.addActionListener(this.beobBlacklistThema);
            itemBlackSenderThema.addActionListener(this.beobBlacklistSenderThema);
            submenueBlack.add(itemBlackSender);
            submenueBlack.add(itemBlackThema);
            submenueBlack.add(itemBlackSenderThema);
            res.ifPresent(film -> {
                JMenuItem item;
                String uNormal = film.getUrlFuerAufloesung("normal");
                String uHd = film.getUrlFuerAufloesung("hd");
                String uLow = film.getUrlFuerAufloesung("klein");
                if (uHd.equals(uNormal)) {
                    uHd = "";
                }
                if (uLow.equals(uNormal)) {
                    uLow = "";
                }
                if (!uNormal.isEmpty()) {
                    jPopupMenu.addSeparator();
                    ActionListener copyNormalUrlListener = e -> GuiFunktionen.copyToClipboard(film.getUrlFuerAufloesung("normal"));
                    if (!uHd.isEmpty() || !uLow.isEmpty()) {
                        JMenu submenueURL = new JMenu("Film-URL kopieren");
                        if (!uHd.isEmpty()) {
                            item = new JMenuItem("in h\u00f6chster/hoher Qualit\u00e4t");
                            item.addActionListener(e -> GuiFunktionen.copyToClipboard(film.getUrlFuerAufloesung("hd")));
                            submenueURL.add(item);
                        }
                        item = new JMenuItem("in mittlerer Qualit\u00e4t");
                        item.addActionListener(copyNormalUrlListener);
                        submenueURL.add(item);
                        if (!uLow.isEmpty()) {
                            item = new JMenuItem("in niedriger Qualit\u00e4t");
                            item.addActionListener(e -> GuiFunktionen.copyToClipboard(film.getUrlFuerAufloesung("klein")));
                            submenueURL.add(item);
                        }
                        jPopupMenu.add(submenueURL);
                    } else {
                        item = new JMenuItem("Film-URL kopieren");
                        item.addActionListener(copyNormalUrlListener);
                        jPopupMenu.add(item);
                    }
                }
                if (!film.getUrlSubtitle().isEmpty()) {
                    item = new JMenuItem("Untertitel-URL kopieren");
                    item.addActionListener(e -> GuiFunktionen.copyToClipboard(film.getUrlSubtitle()));
                    jPopupMenu.add(item);
                }
            });
            jPopupMenu.addSeparator();
            res.ifPresent(film -> {
                JMenuItem itemDb = new JMenuItem("Titel in der Mediensammlung suchen");
                itemDb.addActionListener(GuiFilme.this.mediensammlungAction);
                jPopupMenu.add(itemDb);
            });
            JMenuItem item = new JMenuItem("Tabelle drucken");
            item.addActionListener(this.beobPrint);
            jPopupMenu.add(item);
            jPopupMenu.add(this.showFilmInformationAction);
            res.ifPresent(film -> {
                JMenuItem miHistory;
                if (GuiFilme.this.daten.getSeenHistoryController().urlPruefen(film.getUrl())) {
                    miHistory = new JMenuItem("Film als ungesehen markieren");
                    miHistory.addActionListener(this.unseenActionListener);
                } else {
                    miHistory = new JMenuItem("Film als gesehen markieren");
                    miHistory.addActionListener(this.seenActionListener);
                }
                jPopupMenu.add(miHistory);
            });
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }

        private class BeobPrint
        implements ActionListener {
            private BeobPrint() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GuiFilme.this.tabelle.print();
                }
                catch (PrinterException ex) {
                    Log.errorLog(688542239, ex);
                }
            }
        }

        private class BeobAbo
        implements ActionListener {
            private final boolean mitTitel;

            BeobAbo(boolean mmitTitel) {
                this.mitTitel = mmitTitel;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Daten.listePset.getListeAbo().isEmpty()) {
                    new DialogAboNoSet(GuiFilme.this.mediathekGui).setVisible(true);
                } else {
                    int nr = GuiFilme.this.tabelle.rowAtPoint(BeobMausTabelle.this.p);
                    if (nr >= 0) {
                        GuiFilme.this.stopBeob = true;
                        Optional<DatenFilm> res = GuiFilme.this.getFilm(nr);
                        res.ifPresent(film -> {
                            DatenAbo datenAbo = GuiFilme.this.daten.getListeAbo().getAboFuerFilm_schnell((DatenFilm)film, false);
                            if (datenAbo != null) {
                                GuiFilme.this.daten.getListeAbo().aboLoeschen(datenAbo);
                            } else if (this.mitTitel) {
                                GuiFilme.this.daten.getListeAbo().addAbo(film.getThema(), film.getSender(), film.getThema(), film.getTitle());
                            } else {
                                GuiFilme.this.daten.getListeAbo().addAbo(film.getThema(), film.getSender(), film.getThema(), "");
                            }
                        });
                        GuiFilme.this.stopBeob = false;
                    }
                }
            }
        }

        private final class BeobBlacklist
        implements ActionListener {
            private final boolean sender;
            private final boolean thema;

            BeobBlacklist(boolean ssender, boolean tthema) {
                this.sender = ssender;
                this.thema = tthema;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.tabelle.rowAtPoint(BeobMausTabelle.this.p);
                if (nr >= 0) {
                    Optional<DatenFilm> res = GuiFilme.this.getFilm(nr);
                    res.ifPresent(film -> {
                        String th = film.getThema();
                        String se = film.getSender();
                        MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_ON, Boolean.TRUE.toString());
                        ListeBlacklist listeBlacklist = GuiFilme.this.daten.getListeBlacklist();
                        if (!this.sender) {
                            listeBlacklist.add(new DatenBlacklist("", th, "", ""));
                        } else if (!this.thema) {
                            listeBlacklist.add(new DatenBlacklist(se, "", "", ""));
                        } else {
                            listeBlacklist.add(new DatenBlacklist(se, th, "", ""));
                        }
                    });
                }
            }
        }

        private class BeobHistory
        implements ActionListener {
            private final boolean eintragen;

            BeobHistory(boolean eeintragen) {
                this.eintragen = eeintragen;
            }

            private void updateHistory(DatenFilm film) {
                ArrayList<DatenFilm> list = Lists.newArrayList(film);
                SeenHistoryController history = GuiFilme.this.daten.getSeenHistoryController();
                if (this.eintragen) {
                    history.markAsSeen(list);
                } else {
                    history.markAsUnseen(list);
                }
                list.clear();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.tabelle.rowAtPoint(BeobMausTabelle.this.p);
                if (nr != -1) {
                    Optional<DatenFilm> res = GuiFilme.this.getFilm(nr);
                    res.ifPresent(this::updateHistory);
                }
            }
        }

        private class BeobChangeAbo
        implements ActionListener {
            private BeobChangeAbo() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Daten.listePset.getListeAbo().isEmpty()) {
                    new DialogAboNoSet(GuiFilme.this.mediathekGui).setVisible(true);
                } else {
                    int nr = GuiFilme.this.tabelle.rowAtPoint(BeobMausTabelle.this.p);
                    if (nr >= 0) {
                        GuiFilme.this.stopBeob = true;
                        Optional<DatenFilm> res = GuiFilme.this.getFilm(nr);
                        res.ifPresent(film -> {
                            DatenAbo datenAbo = GuiFilme.this.daten.getListeAbo().getAboFuerFilm_schnell((DatenFilm)film, false);
                            if (datenAbo != null) {
                                DialogEditAbo dialog = new DialogEditAbo(GuiFilme.this.mediathekGui, true, GuiFilme.this.daten, datenAbo, false);
                                dialog.setVisible(true);
                                if (dialog.ok) {
                                    GuiFilme.this.daten.getListeAbo().aenderungMelden();
                                }
                            }
                        });
                        GuiFilme.this.stopBeob = false;
                    }
                }
            }
        }
    }
}

