# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.image_algorithm import ImageAlgorithm


class RasterReprojectionFilter(ImageAlgorithm):
    """
    RasterReprojectionFilter - Transform a VTK image data to a
    different projection.
    
    Superclass: ImageAlgorithm
    
    Applies map reprojection to UniformGrid or ImageData.
    Internally uses GDAL/Proj4 for the reprojection calculations.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkRasterReprojectionFilter, obj, update, **traits)
    
    input_projection = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        """
        Set the map-projection string for the input image data. This
        should *only* be used for nonstandard image inputs, when the
        MAP_PROJECTION is not embedded as field data. Can be specified
        using any string formats supported by GDAL, such as "well known
        text" (WKT) formats (GEOGS[]), or shorter "user string" formats,
        such as EPSG:3857.
        """
    )

    def _input_projection_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInputProjection,
                        self.input_projection)

    max_error = traits.Trait(0.0, traits.Range(0.0, 1e+299, enter_set=True, auto_set=False), desc=\
        """
        Set the maximum error, measured in input pixels, that is allowed
        in approximating the GDAL reprojection transformation. The
        default is 0.0, for exact calculations.
        """
    )

    def _max_error_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaxError,
                        self.max_error)

    no_data_value = traits.Float(nan, enter_set=True, auto_set=False, desc=\
        """
        The data value to use internally to represent blank points in
        GDAL datasets. By default, this will be set to the minimum value
        for the input data type.
        """
    )

    def _no_data_value_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNoDataValue,
                        self.no_data_value)

    output_dimensions = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="int", value=(0, 0), cols=2, desc=\
        """
        
        """
    )

    def _output_dimensions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputDimensions,
                        self.output_dimensions)

    output_projection = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        """
        Set the map-projection string for the output image data.
        """
    )

    def _output_projection_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputProjection,
                        self.output_projection)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        Get a data object for one of the input port connections.  The use
        of this method is strongly discouraged, but some filters that
        were written a long time ago still use this method.
        """
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_resampling_algorithm_max_value(self):
        return self._vtk_obj.GetResamplingAlgorithmMaxValue()
    resampling_algorithm_max_value = traits.Property(_get_resampling_algorithm_max_value, desc=\
        """
        Set the pixel resampling algorithm. Choices range between 0 and
        6: 0 = Nearest Neighbor (default) 1 = Bilinear 2 = Cubic 3 =
        cubic_spline 4 = Lanczos 5 = Average 6 = Mode
        """
    )

    def _get_resampling_algorithm_min_value(self):
        return self._vtk_obj.GetResamplingAlgorithmMinValue()
    resampling_algorithm_min_value = traits.Property(_get_resampling_algorithm_min_value, desc=\
        """
        Set the pixel resampling algorithm. Choices range between 0 and
        6: 0 = Nearest Neighbor (default) 1 = Bilinear 2 = Cubic 3 =
        cubic_spline 4 = Lanczos 5 = Average 6 = Mode
        """
    )

    def set_resampling_algorithm(self, *args):
        """
        V.set_resampling_algorithm(int)
        C++: virtual void SetResamplingAlgorithm(int _arg)
        Set the pixel resampling algorithm. Choices range between 0 and
        6: 0 = Nearest Neighbor (default) 1 = Bilinear 2 = Cubic 3 =
        cubic_spline 4 = Lanczos 5 = Average 6 = Mode
        """
        ret = self._wrap_call(self._vtk_obj.SetResamplingAlgorithm, *args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('input_projection', 'GetInputProjection'), ('max_error',
    'GetMaxError'), ('no_data_value', 'GetNoDataValue'),
    ('output_dimensions', 'GetOutputDimensions'), ('output_projection',
    'GetOutputProjection'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'input_projection', 'max_error', 'no_data_value',
    'output_dimensions', 'output_projection', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(RasterReprojectionFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit RasterReprojectionFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['input_projection', 'max_error', 'no_data_value',
            'output_dimensions', 'output_projection']),
            title='Edit RasterReprojectionFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit RasterReprojectionFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

