/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.backtrace;

import com.headius.backport9.stack.StackWalker;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.PrintStream;
import java.util.stream.Stream;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyString;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.Exception;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.backtrace.BacktraceData;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.TypeConverter;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class TraceType {
    private static final Logger LOG = LoggerFactory.getLogger(TraceType.class);
    private static final StackWalker WALKER = ThreadContext.WALKER;
    private static final String[] FULL_MESSAGE_KEYS = new String[]{"highlight", "order"};
    private final Gather gather;
    private final Format format;
    private static final String FIRST_COLOR = "\u001b[0;31m";
    private static final String KERNEL_COLOR = "\u001b[0;36m";
    private static final String EVAL_COLOR = "\u001b[0;33m";
    private static final String CLEAR_COLOR = "\u001b[0m";

    public TraceType(Gather gather, Format format) {
        this.gather = gather;
        this.format = format;
    }

    public Gather getGather() {
        return this.gather;
    }

    public Format getFormat() {
        return this.format;
    }

    public BacktraceData getBacktrace(ThreadContext context) {
        return this.gather.getBacktraceData(context);
    }

    public BacktraceData getIntegratedBacktrace(ThreadContext context, StackTraceElement[] javaTrace) {
        return this.gather.getIntegratedBacktraceData(context, javaTrace);
    }

    public String printBacktrace(RubyException exception2, boolean console) {
        return this.format.printBacktrace(exception2, console);
    }

    public static void logBacktrace(Ruby runtime2, RubyStackTraceElement[] trace2) {
        if (trace2 == null) {
            trace2 = RubyStackTraceElement.EMPTY_ARRAY;
        }
        StringBuilder buffer = new StringBuilder(64 + trace2.length * 48);
        buffer.append("Backtrace generated:\n");
        TraceType.renderBacktraceJRuby(runtime2, trace2, buffer, false);
        LOG.info(buffer.toString(), new Object[0]);
    }

    public static void logException(RubyException exception2) {
        LOG.info("Exception raised: {} : {}", exception2.getMetaClass(), exception2);
    }

    public static void dumpException(RubyException exception2) {
        TraceType.logException(exception2);
    }

    public static void dumpBacktrace(RubyException exception2) {
        Ruby runtime2 = exception2.getRuntime();
        System.err.println("Backtrace generated:\n" + TraceType.printBacktraceJRuby(exception2, runtime2.getPosix().isatty(FileDescriptor.err)));
    }

    public static void logCaller(RubyArray trace2) {
        StringBuilder buffer = new StringBuilder(64 + trace2.size() * 48);
        buffer.append("Caller backtrace generated:\n");
        for (int i2 = 0; i2 < trace2.size(); ++i2) {
            buffer.append("  ").append(trace2.eltInternal(i2)).append('\n');
        }
        LOG.info(buffer.toString(), new Object[0]);
    }

    public static void dumpCaller(RubyArray trace2) {
        TraceType.logCaller(trace2);
    }

    public static void logCaller(RubyStackTraceElement[] trace2) {
        if (trace2 == null) {
            trace2 = RubyStackTraceElement.EMPTY_ARRAY;
        }
        LOG.info(TraceType.formatWithMRIBacktrace("Caller backtrace generated:\n", trace2).toString(), new Object[0]);
    }

    private static StringBuilder formatWithMRIBacktrace(String message2, RubyStackTraceElement[] trace2) {
        StringBuilder buffer = new StringBuilder(64 + trace2.length * 48);
        buffer.append(message2);
        TraceType.renderBacktraceMRI(trace2, "  ", buffer, false);
        return buffer;
    }

    public static void dumpCaller(RubyStackTraceElement[] trace2) {
        TraceType.logCaller(trace2);
    }

    public static void logWarning(RubyStackTraceElement[] trace2) {
        if (trace2 == null) {
            trace2 = RubyStackTraceElement.EMPTY_ARRAY;
        }
        LOG.info(TraceType.formatWithMRIBacktrace("Warning backtrace generated:\n", trace2).toString(), new Object[0]);
    }

    public static void dumpWarning(RubyStackTraceElement[] trace2) {
        TraceType.logWarning(trace2);
    }

    public static TraceType traceTypeFor(String style) {
        if (style.equalsIgnoreCase("raw")) {
            return new TraceType(Gather.RAW, Format.JRUBY);
        }
        if (style.equalsIgnoreCase("ruby_framed")) {
            return new TraceType(Gather.NORMAL, Format.JRUBY);
        }
        if (style.equalsIgnoreCase("normal")) {
            return new TraceType(Gather.NORMAL, Format.JRUBY);
        }
        if (style.equalsIgnoreCase("full")) {
            return new TraceType(Gather.FULL, Format.JRUBY);
        }
        if (style.equalsIgnoreCase("mri")) {
            return new TraceType(Gather.NORMAL, Format.MRI);
        }
        return new TraceType(Gather.NORMAL, Format.JRUBY);
    }

    public static String printFullMessage(ThreadContext context, IRubyObject exception2, IRubyObject opts) {
        Ruby runtime2 = context.runtime;
        IRubyObject optArg = ArgsUtil.getOptionsArg(runtime2, opts);
        boolean highlight = false;
        boolean reverse2 = false;
        if (!optArg.isNil()) {
            IRubyObject[] highlightOrder = ArgsUtil.extractKeywordArgs(context, (RubyHash)optArg, FULL_MESSAGE_KEYS);
            IRubyObject vHigh = highlightOrder[0];
            if (vHigh == null) {
                vHigh = context.nil;
            }
            if (vHigh != context.nil && vHigh != context.fals && vHigh != context.tru) {
                throw runtime2.newArgumentError("expected true or false as highlight: " + vHigh);
            }
            highlight = vHigh.isTrue();
            IRubyObject vOrder = highlightOrder[1];
            if (vOrder != null) {
                if ((vOrder = TypeConverter.checkID(vOrder)) == runtime2.newSymbol("bottom")) {
                    reverse2 = true;
                } else if (vOrder == runtime2.newSymbol("top")) {
                    reverse2 = false;
                } else {
                    throw runtime2.newArgumentError("expected :top or :bottom as order: " + vOrder);
                }
            }
        }
        return TraceType.printBacktraceMRI(exception2, highlight);
    }

    private static String printBacktraceMRI(IRubyObject exception2, boolean console) {
        Ruby runtime2 = exception2.getRuntime();
        ThreadContext context = runtime2.getCurrentContext();
        IRubyObject backtrace2 = exception2.callMethod(context, "backtrace");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream errorStream = new PrintStream(baos);
        boolean printedPosition = false;
        if (backtrace2.isNil() || !(backtrace2 instanceof RubyArray)) {
            if (context.getFile() != null && context.getFile().length() > 0) {
                errorStream.print(context.getFile() + ':' + context.getLine());
                printedPosition = true;
            } else {
                errorStream.print(context.getLine());
                printedPosition = true;
            }
        } else if (((RubyArray)backtrace2).getLength() == 0) {
            TraceType.printErrorPos(context, errorStream);
        } else {
            IRubyObject mesg = ((RubyArray)backtrace2).first();
            if (mesg.isNil()) {
                TraceType.printErrorPos(context, errorStream);
            } else {
                errorStream.print(mesg);
                printedPosition = true;
            }
        }
        RubyClass type2 = exception2.getMetaClass();
        String info = exception2.toString();
        if (type2 == runtime2.getRuntimeError() && (info == null || info.length() == 0)) {
            errorStream.print(": unhandled exception\n");
        } else {
            if (printedPosition) {
                errorStream.print(": ");
            }
            String path2 = type2.getName();
            if (info.length() == 0) {
                errorStream.print(path2 + '\n');
            } else {
                if (path2.startsWith("#")) {
                    path2 = null;
                }
                String tail = null;
                int idx = info.indexOf(10);
                if (idx != -1) {
                    tail = info.substring(idx + 1);
                    info = info.substring(0, idx);
                }
                errorStream.print(info);
                if (path2 != null) {
                    errorStream.print(" (" + path2 + ")\n");
                } else {
                    errorStream.print('\n');
                }
                if (tail != null) {
                    errorStream.print(tail + '\n');
                }
            }
        }
        TraceType.printBacktraceToStream(backtrace2, errorStream, 1);
        return baos.toString();
    }

    public static String printBacktraceJRuby(Ruby runtime2, RubyStackTraceElement[] frames, String type2, String message2, boolean color) {
        if (frames == null) {
            frames = RubyStackTraceElement.EMPTY_ARRAY;
        }
        StringBuilder buffer = new StringBuilder(64 + frames.length * 48);
        buffer.append(type2).append(": ").append(message2).append('\n');
        TraceType.renderBacktraceJRuby(runtime2, frames, buffer, color);
        return buffer.toString();
    }

    protected static String printBacktraceJRuby(RubyException exception2, boolean console) {
        String message2;
        Ruby runtime2 = exception2.getRuntime();
        ThreadContext context = runtime2.getCurrentContext();
        boolean color = console && runtime2.getInstanceConfig().getBacktraceColor();
        try {
            message2 = exception2.callMethod(context, "message").toString();
        }
        catch (Exception unused2) {
            message2 = exception2.message(context).toString();
        }
        if (exception2.getMetaClass() == runtime2.getRuntimeError() && message2.length() == 0) {
            message2 = "No current exception";
        }
        String type2 = exception2.getMetaClass().getName();
        return TraceType.printBacktraceJRuby(exception2.getRuntime(), exception2.getBacktraceElements(), type2, message2, color);
    }

    private static void renderBacktraceJRuby(Ruby runtime2, RubyStackTraceElement[] frames, StringBuilder buffer, boolean color) {
        int longestMethod = 0;
        for (RubyStackTraceElement frame : frames) {
            longestMethod = Math.max(longestMethod, frame.getMethodName().length());
        }
        boolean first2 = true;
        for (RubyStackTraceElement frame : frames) {
            if (color) {
                if (first2) {
                    buffer.append(FIRST_COLOR);
                } else if (frame.isBinding() || frame.getFileName().equals("(eval)")) {
                    buffer.append(EVAL_COLOR);
                } else if (frame.getFileName().indexOf(".java") != -1) {
                    buffer.append(KERNEL_COLOR);
                }
                first2 = false;
            }
            buffer.append("  ");
            String methodName = runtime2 == null ? frame.getMethodName() : runtime2.newSymbol(frame.getMethodName()).idString();
            for (int j = 0; j < longestMethod - methodName.length(); ++j) {
                buffer.append(' ');
            }
            buffer.append(methodName).append(" at ").append(frame.getFileName()).append(':').append(frame.getLineNumber());
            if (color) {
                buffer.append(CLEAR_COLOR);
            }
            buffer.append('\n');
        }
    }

    private static void renderBacktraceMRI(RubyStackTraceElement[] trace2, StringBuilder buffer, boolean color) {
        TraceType.renderBacktraceMRI(trace2, "", buffer, color);
    }

    private static void renderBacktraceMRI(RubyStackTraceElement[] trace2, String linePrefix, StringBuilder buffer, boolean color) {
        for (int i2 = 0; i2 < trace2.length; ++i2) {
            RubyStackTraceElement element = trace2[i2];
            buffer.append(linePrefix).append(element.getFileName()).append(':').append(element.getLineNumber()).append(":in `").append(element.getMethodName()).append("'\n");
        }
    }

    private static void printErrorPos(ThreadContext context, PrintStream errorStream) {
        if (context.getFile() != null && context.getFile().length() > 0) {
            if (context.getFrameName() != null) {
                errorStream.print(context.getFile() + ':' + context.getLine());
                errorStream.print(":in '" + context.getFrameName() + '\'');
            } else if (context.getLine() != 0) {
                errorStream.print(context.getFile() + ':' + context.getLine());
            } else {
                errorStream.print(context.getFile());
            }
        }
    }

    public static void printBacktraceToStream(IRubyObject backtrace2, PrintStream errorStream, int skip2) {
        if (backtrace2.isNil()) {
            return;
        }
        if (backtrace2 instanceof RubyArray) {
            IRubyObject[] elements = ((RubyArray)backtrace2).toJavaArrayMaybeUnsafe();
            for (int i2 = skip2; i2 < elements.length; ++i2) {
                IRubyObject stackTraceLine = elements[i2];
                if (stackTraceLine instanceof RubyString) {
                    errorStream.println("\tfrom " + stackTraceLine);
                    continue;
                }
                errorStream.println("\t" + stackTraceLine);
            }
        }
    }

    @Deprecated
    public static IRubyObject generateMRIBacktrace(Ruby runtime2, RubyStackTraceElement[] trace2) {
        if (trace2 == null) {
            return runtime2.getNil();
        }
        ThreadContext context = runtime2.getCurrentContext();
        IRubyObject[] traceArray = new IRubyObject[trace2.length];
        for (int i2 = 0; i2 < trace2.length; ++i2) {
            traceArray[i2] = RubyStackTraceElement.to_s_mri(context, trace2[i2]);
        }
        return RubyArray.newArrayMayCopy(runtime2, traceArray);
    }

    @Deprecated
    public RubyStackTraceElement getBacktraceElement(ThreadContext context, int uplevel) {
        RubyStackTraceElement[] elements = this.getBacktrace(context).getBacktrace(context.runtime);
        if (elements.length <= uplevel + 1) {
            uplevel = -1;
        }
        return elements[uplevel + 1];
    }

    public static enum Format {
        MRI{

            @Override
            public String printBacktrace(RubyException exception2, boolean console) {
                return TraceType.printBacktraceMRI(exception2, console);
            }

            @Override
            public void renderBacktrace(RubyStackTraceElement[] elts, StringBuilder buffer, boolean color) {
                TraceType.renderBacktraceMRI(elts, buffer, color);
            }
        }
        ,
        JRUBY{

            @Override
            public String printBacktrace(RubyException exception2, boolean console) {
                return TraceType.printBacktraceJRuby(exception2, console);
            }

            @Override
            public void renderBacktrace(RubyStackTraceElement[] elts, StringBuilder buffer, boolean color) {
                TraceType.renderBacktraceJRuby(null, elts, buffer, color);
            }
        };


        public abstract String printBacktrace(RubyException var1, boolean var2);

        public abstract void renderBacktrace(RubyStackTraceElement[] var1, StringBuilder var2, boolean var3);
    }

    public static enum Gather {
        RAW{

            @Override
            public BacktraceData getBacktraceData(ThreadContext context, Stream<StackWalker.StackFrame> stackStream) {
                return new BacktraceData(stackStream, Stream.empty(), true, false, false);
            }
        }
        ,
        FULL{

            @Override
            public BacktraceData getBacktraceData(ThreadContext context, Stream<StackWalker.StackFrame> stackStream) {
                return new BacktraceData(stackStream, context.getBacktrace(), true, false, false);
            }
        }
        ,
        INTEGRATED{

            @Override
            public BacktraceData getBacktraceData(ThreadContext context, Stream<StackWalker.StackFrame> stackStream) {
                return new BacktraceData(stackStream, context.getBacktrace(), false, false, true);
            }
        }
        ,
        NORMAL{

            @Override
            public BacktraceData getBacktraceData(ThreadContext context, Stream<StackWalker.StackFrame> stackStream) {
                return new BacktraceData(stackStream, context.getBacktrace(), false, context.runtime.getInstanceConfig().getBacktraceMask(), false);
            }
        }
        ,
        CALLER{

            @Override
            public BacktraceData getBacktraceData(ThreadContext context, Stream<StackWalker.StackFrame> stackStream) {
                return new BacktraceData(stackStream, context.getBacktrace(), false, true, false);
            }
        };


        public BacktraceData getBacktraceData(ThreadContext context) {
            return WALKER.walk(Thread.currentThread().getStackTrace(), stream -> {
                BacktraceData data2 = this.getBacktraceData(context, (Stream<StackWalker.StackFrame>)stream);
                context.runtime.incrementBacktraceCount();
                if (RubyInstanceConfig.LOG_BACKTRACES) {
                    TraceType.logBacktrace(context.runtime, data2.getBacktrace(context.runtime));
                }
                return data2;
            });
        }

        public BacktraceData getIntegratedBacktraceData(ThreadContext context, StackTraceElement[] javaTrace) {
            Gather useGather = this == NORMAL ? INTEGRATED : this;
            return WALKER.walk(javaTrace, stream -> {
                BacktraceData data2 = useGather.getBacktraceData(context, (Stream<StackWalker.StackFrame>)stream);
                context.runtime.incrementBacktraceCount();
                if (RubyInstanceConfig.LOG_BACKTRACES) {
                    TraceType.logBacktrace(context.runtime, data2.getBacktrace(context.runtime));
                }
                return data2;
            });
        }

        public abstract BacktraceData getBacktraceData(ThreadContext var1, Stream<StackWalker.StackFrame> var2);
    }
}

