"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var constants_1 = require("../../../../scales/constants");
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var get_computed_scales_1 = require("./get_computed_scales");
exports.isBrushAvailableSelector = re_reselect_1.default([get_settings_specs_1.getSettingsSpecSelector, get_computed_scales_1.getComputedScalesSelector], function (settingsSpec, scales) {
    if (!scales.xScale) {
        return false;
    }
    return scales.xScale.type !== constants_1.ScaleType.Ordinal && Boolean(settingsSpec.onBrushEnd);
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=is_brush_available.js.map