/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.security;

import java.util.AbstractList;
import java.util.List;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.security.SaslInit;
import org.apache.qpid.proton.codec.AbstractDescribedType;
import org.apache.qpid.proton.codec.DecodeException;
import org.apache.qpid.proton.codec.Decoder;
import org.apache.qpid.proton.codec.DescribedTypeConstructor;
import org.apache.qpid.proton.codec.EncoderImpl;

public class SaslInitType
extends AbstractDescribedType<SaslInit, List>
implements DescribedTypeConstructor<SaslInit> {
    private static final Object[] DESCRIPTORS = new Object[]{UnsignedLong.valueOf(65L), Symbol.valueOf("amqp:sasl-init:list")};
    private static final UnsignedLong DESCRIPTOR = UnsignedLong.valueOf(65L);

    private SaslInitType(EncoderImpl encoder) {
        super(encoder);
    }

    @Override
    public UnsignedLong getDescriptor() {
        return DESCRIPTOR;
    }

    @Override
    protected List wrap(SaslInit val) {
        return new SaslInitWrapper(val);
    }

    @Override
    public SaslInit newInstance(Object described) {
        List l = (List)described;
        SaslInit o = new SaslInit();
        if (l.size() <= 0) {
            throw new DecodeException("The mechanism field cannot be omitted");
        }
        switch (3 - l.size()) {
            case 0: {
                o.setHostname((String)l.get(2));
            }
            case 1: {
                o.setInitialResponse((Binary)l.get(1));
            }
            case 2: {
                o.setMechanism((Symbol)l.get(0));
            }
        }
        return o;
    }

    @Override
    public Class<SaslInit> getTypeClass() {
        return SaslInit.class;
    }

    public static void register(Decoder decoder, EncoderImpl encoder) {
        SaslInitType type = new SaslInitType(encoder);
        for (Object descriptor : DESCRIPTORS) {
            decoder.register(descriptor, type);
        }
        encoder.register(type);
    }

    public static class SaslInitWrapper
    extends AbstractList {
        private SaslInit _saslInit;

        public SaslInitWrapper(SaslInit saslInit) {
            this._saslInit = saslInit;
        }

        @Override
        public Object get(int index) {
            switch (index) {
                case 0: {
                    return this._saslInit.getMechanism();
                }
                case 1: {
                    return this._saslInit.getInitialResponse();
                }
                case 2: {
                    return this._saslInit.getHostname();
                }
            }
            throw new IllegalStateException("Unknown index " + index);
        }

        @Override
        public int size() {
            return this._saslInit.getHostname() != null ? 3 : (this._saslInit.getInitialResponse() != null ? 2 : 1);
        }
    }
}

