/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa.recovery;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;
import javax.transaction.xa.Xid;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.Util;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.recovery.RecoveryManager;

public class InDoubtTxInfoImpl
implements RecoveryManager.InDoubtTxInfo {
    private Xid xid;
    private Long internalId;
    private IntSet status;
    private transient Set<Address> owners = new HashSet<Address>();
    private transient boolean isLocal;

    public InDoubtTxInfoImpl(Xid xid, Long internalId, Integer status) {
        this.xid = xid;
        this.internalId = internalId;
        this.status = status == null ? IntSets.immutableEmptySet() : IntSets.immutableSet((int)status);
    }

    public InDoubtTxInfoImpl(Xid xid, long internalId, IntSet status) {
        this.xid = xid;
        this.internalId = internalId;
        this.status = status;
    }

    public InDoubtTxInfoImpl(Xid xid, long internalId) {
        this(xid, internalId, IntSets.immutableEmptySet());
    }

    @Override
    public Xid getXid() {
        return this.xid;
    }

    @Override
    public Long getInternalId() {
        return this.internalId;
    }

    @Override
    public Set<Integer> getStatus() {
        return this.status;
    }

    @Override
    public Set<Address> getOwners() {
        return this.owners;
    }

    public void addStatus(Set<Integer> statusSet) {
        this.status.addAll(statusSet);
    }

    public void addOwner(Address owner) {
        this.owners.add(owner);
    }

    @Override
    public boolean isLocal() {
        return this.isLocal;
    }

    public void setLocal(boolean local) {
        this.isLocal = local;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InDoubtTxInfoImpl that = (InDoubtTxInfoImpl)o;
        if (this.isLocal != that.isLocal) {
            return false;
        }
        if (this.internalId != null ? !this.internalId.equals(that.internalId) : that.internalId != null) {
            return false;
        }
        if (this.owners != null ? !this.owners.equals(that.owners) : that.owners != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        return !(this.xid != null ? !this.xid.equals(that.xid) : that.xid != null);
    }

    public int hashCode() {
        int result = this.xid != null ? this.xid.hashCode() : 0;
        result = 31 * result + (this.internalId != null ? this.internalId.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.owners != null ? this.owners.hashCode() : 0);
        result = 31 * result + (this.isLocal ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{xid=" + this.xid + ", internalId=" + this.internalId + ", status=" + this.status + ", owners=" + this.owners + ", isLocal=" + this.isLocal + '}';
    }

    public static class Externalizer
    extends AbstractExternalizer<InDoubtTxInfoImpl> {
        public void writeObject(ObjectOutput output, InDoubtTxInfoImpl inDoubtTxInfoImpl) throws IOException {
            output.writeObject(inDoubtTxInfoImpl.getXid());
            output.writeLong(inDoubtTxInfoImpl.getInternalId());
            output.writeObject(inDoubtTxInfoImpl.status);
        }

        public InDoubtTxInfoImpl readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new InDoubtTxInfoImpl((Xid)input.readObject(), input.readLong(), (IntSet)input.readObject());
        }

        public Integer getId() {
            return 35;
        }

        public Set<Class<? extends InDoubtTxInfoImpl>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{InDoubtTxInfoImpl.class});
        }
    }
}

