/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class PropertiesConfigSource
implements ConfigSource,
Serializable {
    private static final String CONFIG_ORDINAL_KEY = "config_ordinal";
    private static final String CONFIG_ORDINAL_DEFAULT_VALUE = "100";
    private final Map<String, String> properties;
    private final String source;
    private final int ordinal;

    public PropertiesConfigSource(URL url) throws IOException {
        this.source = url.toString();
        try (InputStream in = url.openStream();){
            Properties p = new Properties();
            p.load(in);
            this.properties = new HashMap<Object, Object>(p);
        }
        this.ordinal = Integer.valueOf(this.properties.getOrDefault(CONFIG_ORDINAL_KEY, CONFIG_ORDINAL_DEFAULT_VALUE));
    }

    public PropertiesConfigSource(Properties properties, String source) {
        this.properties = new HashMap<Object, Object>(properties);
        this.source = source;
        this.ordinal = Integer.valueOf(properties.getProperty(CONFIG_ORDINAL_KEY, CONFIG_ORDINAL_DEFAULT_VALUE));
    }

    public PropertiesConfigSource(Map<String, String> properties, String source, int ordinal) {
        this.properties = new HashMap<String, String>(properties);
        this.source = source;
        this.ordinal = properties.containsKey(CONFIG_ORDINAL_KEY) ? Integer.valueOf(properties.getOrDefault(CONFIG_ORDINAL_KEY, CONFIG_ORDINAL_DEFAULT_VALUE)) : ordinal;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getValue(String s) {
        return this.properties.get(s);
    }

    public String getName() {
        return "PropertiesConfigSource[source=" + this.source + "]";
    }

    public String toString() {
        return this.getName();
    }
}

