/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.subsystem;

import java.util.HashMap;
import java.util.Map;

enum Element {
    UNKNOWN(null),
    BLOCK_SIZE("block-size"),
    CREATE_TABLE("create-table"),
    CREATE_TABLE_DDL("create-table-ddl"),
    DATA_SOURCE("data-source"),
    DROP_TABLE("drop-table"),
    HILO("hilo"),
    ID_COLUMN("id-column"),
    KEY_GENERATORS("key-generators"),
    SELECT_HI_DDL("select-hi-ddl"),
    SEQUENCE_COLUMN("sequence-column"),
    SEQUENCE_NAME("sequence-name"),
    TABLE_NAME("table-name"),
    UUID("uuid");

    private final String name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

