/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public final class DefaultDeploymentMappingProvider {
    private static DefaultDeploymentMappingProvider INSTANCE = new DefaultDeploymentMappingProvider();
    private final ConcurrentHashMap<String, Map.Entry<String, String>> mappings = new ConcurrentHashMap();

    public static DefaultDeploymentMappingProvider instance() {
        return INSTANCE;
    }

    private DefaultDeploymentMappingProvider() {
    }

    public Map.Entry<String, String> getMapping(String deploymentName) {
        return this.mappings.get(deploymentName);
    }

    public void removeMapping(String deploymentName) {
        this.mappings.remove(deploymentName);
    }

    public void addMapping(String deploymentName, String serverName, String hostName) {
        if (this.mappings.putIfAbsent(deploymentName, new AbstractMap.SimpleEntry<String, String>(serverName, hostName)) != null) {
            throw UndertowLogger.ROOT_LOGGER.duplicateDefaultWebModuleMapping(deploymentName, serverName, hostName);
        }
    }

    public void clear() {
        this.mappings.clear();
    }
}

