/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import javax.xml.ws.spi.Provider;
import org.jboss.wsf.stack.cxf.tools.JavaFileObjectImpl;

class CustomJavaFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private ClassLoader classLoader = new ClassLoader(Provider.provider().getClass().getClassLoader()){};

    protected CustomJavaFileManager(JavaFileManager fileManager) {
        super(fileManager);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.classLoader;
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        return super.getFileForInput(location, packageName, relativeName);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location loc, JavaFileObject file) {
        String result = file instanceof JavaFileObjectImpl ? file.getName() : super.inferBinaryName(loc, file);
        return result;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        Iterable<JavaFileObject> result = super.list(location, packageName, kinds, recurse);
        ArrayList<JavaFileObject> files = new ArrayList<JavaFileObject>();
        if (location == StandardLocation.PLATFORM_CLASS_PATH && kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
            ArrayList<JavaFileObject> resultFiltered = new ArrayList<JavaFileObject>();
            for (JavaFileObject obj : result) {
                ClassLoader loader;
                String objName = obj.getName();
                Class<?> clazz = null;
                String className = CustomJavaFileManager.getFullClassName(packageName, objName);
                try {
                    clazz = this.classLoader.loadClass(className);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                boolean added = false;
                if (clazz != null && (loader = clazz.getClassLoader()) != null) {
                    files.add(new JavaFileObjectImpl(className, loader));
                    added = true;
                }
                if (added) continue;
                resultFiltered.add(obj);
            }
            for (JavaFileObject file : resultFiltered) {
                files.add(file);
            }
        } else {
            for (JavaFileObject file : result) {
                files.add(file);
            }
        }
        return files;
    }

    private static String getFullClassName(String packageName, String objName) {
        String cn = objName.substring(0, objName.indexOf(".class"));
        int startIdx = Math.max(cn.lastIndexOf("."), cn.lastIndexOf("/"));
        if (startIdx > 0) {
            cn = cn.substring(startIdx + 1);
        }
        return packageName + "." + cn;
    }
}

