/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.TP;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.Util;
import org.w3c.dom.Node;

public abstract class Protocol {
    protected Protocol up_prot;
    protected Protocol down_prot;
    protected ProtocolStack stack;
    @Property(description="Determines whether to collect statistics (and expose them via JMX). Default is true")
    protected boolean stats = true;
    @Property(description="Enables ergonomics: dynamically find the best values for properties at runtime")
    protected boolean ergonomics = true;
    @Property(description="Fully qualified name of a class implementing ProtocolHook, will be called after creation of the protocol (before init())", writable=false)
    protected String after_creation_hook;
    @Property(description="Give the protocol a different ID if needed so we can have multiple instances of it in the same stack", writable=false)
    protected short id = ClassConfigurator.getProtocolId(this.getClass());
    protected final Log log = LogFactory.getLog(this.getClass());

    @Property(name="level", description="Sets the level")
    public <T extends Protocol> T setLevel(String level) {
        this.log.setLevel(level);
        return (T)this;
    }

    @Property(name="level", description="logger level (see javadocs)")
    public String getLevel() {
        return this.log.getLevel();
    }

    public <T extends Protocol> T level(String level) {
        return this.setLevel(level);
    }

    public boolean isErgonomics() {
        return this.ergonomics;
    }

    public <T extends Protocol> T setErgonomics(boolean ergonomics) {
        this.ergonomics = ergonomics;
        return (T)this;
    }

    public ProtocolStack getProtocolStack() {
        return this.stack;
    }

    public boolean statsEnabled() {
        return this.stats;
    }

    public void enableStats(boolean flag) {
        this.stats = flag;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public short getId() {
        return this.id;
    }

    public <T extends Protocol> T setId(short id) {
        this.id = id;
        return (T)this;
    }

    public <T extends Protocol> T getUpProtocol() {
        return (T)this.up_prot;
    }

    public <T extends Protocol> T getDownProtocol() {
        return (T)this.down_prot;
    }

    public <T extends Protocol> T setUpProtocol(Protocol prot) {
        this.up_prot = prot;
        return (T)this;
    }

    public <T extends Protocol> T setDownProtocol(Protocol prot) {
        this.down_prot = prot;
        return (T)this;
    }

    public <T extends Protocol> T setProtocolStack(ProtocolStack s) {
        this.stack = s;
        return (T)this;
    }

    public String afterCreationHook() {
        return this.after_creation_hook;
    }

    public Log getLog() {
        return this.log;
    }

    public Object getValue(String name) {
        if (name == null) {
            return null;
        }
        Field field = Util.getField(this.getClass(), name);
        if (field == null) {
            throw new IllegalArgumentException("field \"" + name + "\n not found");
        }
        return Util.getField(field, this);
    }

    public <T extends Protocol> T setValue(String name, Object value) {
        String deprecated_msg;
        if (name == null || value == null) {
            return (T)this;
        }
        Field field = Util.getField(this.getClass(), name);
        if (field == null) {
            throw new IllegalArgumentException("field " + name + " not found");
        }
        Property prop = field.getAnnotation(Property.class);
        if (prop != null && (deprecated_msg = prop.deprecatedMessage()) != null && !deprecated_msg.isEmpty()) {
            this.log.warn("Field " + this.getName() + "." + name + " is deprecated: " + deprecated_msg);
        }
        Util.setField(field, this, value);
        return (T)this;
    }

    public List<Object> getConfigurableObjects() {
        return null;
    }

    public void parse(Node node) throws Exception {
    }

    public short[] getIdsAbove() {
        ArrayList<Short> ids = new ArrayList<Short>();
        Protocol current = this.up_prot;
        while (current != null) {
            ids.add(current.getId());
            current = current.up_prot;
        }
        short[] retval = new short[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            retval[i] = (Short)ids.get(i);
        }
        return retval;
    }

    protected TP getTransport() {
        Protocol retval = this;
        while (retval != null && retval.down_prot != null) {
            retval = retval.down_prot;
        }
        return (TP)retval;
    }

    public ThreadFactory getThreadFactory() {
        return this.down_prot != null ? this.down_prot.getThreadFactory() : null;
    }

    public SocketFactory getSocketFactory() {
        return this.down_prot != null ? this.down_prot.getSocketFactory() : null;
    }

    public void setSocketFactory(SocketFactory factory) {
        if (this.down_prot != null) {
            this.down_prot.setSocketFactory(factory);
        }
    }

    @ManagedOperation(description="Resets all stats")
    public void resetStatistics() {
        this.resetStats();
    }

    public void resetStats() {
    }

    public void init() throws Exception {
    }

    public void start() throws Exception {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public List<Integer> requiredUpServices() {
        return null;
    }

    public List<Integer> requiredDownServices() {
        return null;
    }

    public List<Integer> providedUpServices() {
        return null;
    }

    public List<Integer> providedDownServices() {
        return null;
    }

    public final List<Integer> getDownServices() {
        ArrayList<Integer> retval = new ArrayList<Integer>();
        Protocol prot = this.down_prot;
        while (prot != null) {
            List<Integer> tmp = prot.providedUpServices();
            if (tmp != null && !tmp.isEmpty()) {
                retval.addAll(tmp);
            }
            prot = prot.down_prot;
        }
        return retval;
    }

    public final List<Integer> getUpServices() {
        ArrayList<Integer> retval = new ArrayList<Integer>();
        Protocol prot = this.up_prot;
        while (prot != null) {
            List<Integer> tmp = prot.providedDownServices();
            if (tmp != null && !tmp.isEmpty()) {
                retval.addAll(tmp);
            }
            prot = prot.up_prot;
        }
        return retval;
    }

    public Object down(Event evt) {
        return this.down_prot.down(evt);
    }

    public Object down(Message msg) {
        return this.down_prot.down(msg);
    }

    public Object up(Event evt) {
        return this.up_prot.up(evt);
    }

    public Object up(Message msg) {
        return this.up_prot.up(msg);
    }

    public void up(MessageBatch batch) {
        Iterator<Message> it = batch.iterator();
        while (it.hasNext()) {
            Message msg = it.next();
            if (msg == null || !this.accept(msg)) continue;
            it.remove();
            try {
                this.up(msg);
            }
            catch (Throwable t) {
                this.log.error(Util.getMessage("PassUpFailure"), t);
            }
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    protected boolean accept(Message msg) {
        short tmp_id = this.getId();
        return tmp_id > 0 && msg.getHeader(tmp_id) != null;
    }
}

