#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 crypto-api-tests
version:              0.3
visibility:           public
id:                   crypto-api-tests-0.3-S42AN2OChlqiXu0SBH9m
key:                  crypto-api-tests-0.3-S42AN2OChlqiXu0SBH9m
license:              BSD-3-Clause
copyright:            Thomas DuBuisson <thomas.dubuisson@gmail.com>
maintainer:           Thomas DuBuisson <thomas.dubuisson@gmail.com>
author:               Thomas DuBuisson <thomas.dubuisson@gmail.com>
stability:            stable
homepage:             http://trac.haskell.org/crypto-api/wiki
synopsis:             A test framework and KATs for cryptographic operations.
description:
    A test framework for hash and cipher operations using
    the crypto-api interface.  Known answer tests (KATs)
    for common cryptographic algorithms are included.
    Patches welcome (both adding KATs for more algorithms
    or property tests for classes of algorithms).

category:             Data, Cryptography
abi:                  70186aebd7a5864b9912407499a0bfaf
exposed:              True
exposed-modules:
    Test.AES Test.Crypto Test.HMAC Test.MD5 Test.ParseNistKATs Test.SHA
    Test.TwoFish

hidden-modules:       Paths_crypto_api_tests
import-dirs:          /usr/lib/ghc-8.10.5/site-local/crypto-api-tests-0.3
library-dirs:         /usr/lib/ghc-8.10.5/site-local/crypto-api-tests-0.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/crypto-api-tests-0.3
hs-libraries:         HScrypto-api-tests-0.3-S42AN2OChlqiXu0SBH9m
depends:
    HUnit-1.6.2.0-8FsjWfKzSV74wDnwnuEJe4
    QuickCheck-2.14.2-LYkEXWaccd95SoKseYSYTk base-4.14.2.0
    bytestring-0.10.12.0 cereal-0.5.8.1-4r85zOZIbEW4fo8WFnBuTl
    crypto-api-0.13.3-8kK7ehsYBxqIrjHyd9ebTX directory-1.3.6.0
    filepath-1.4.2.1 test-framework-0.8.2.0-5eYG3NRKVE7L7pW0FKysaQ
    test-framework-hunit-0.3.0.2-6EN5DaB9gXBAvhheezcely
    test-framework-quickcheck2-0.3.0.5-Et0vRefXi5ZCLdEv0og4sD

haddock-interfaces:
    /usr/share/doc/haskell-crypto-api-tests/html/crypto-api-tests.haddock

haddock-html:         /usr/share/doc/haskell-crypto-api-tests/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

