/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.IndexTemplateV2;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class IndexTemplateV2Metadata
implements MetaData.Custom {
    public static final String TYPE = "index_template";
    private static final ParseField INDEX_TEMPLATE = new ParseField("index_template", new String[0]);
    private static final ConstructingObjectParser<IndexTemplateV2Metadata, Void> PARSER = new ConstructingObjectParser("index_template", false, a -> new IndexTemplateV2Metadata((Map)a[0]));
    private final Map<String, IndexTemplateV2> indexTemplates;

    public IndexTemplateV2Metadata(Map<String, IndexTemplateV2> templates) {
        this.indexTemplates = templates;
    }

    public IndexTemplateV2Metadata(StreamInput in) throws IOException {
        this.indexTemplates = in.readMap(StreamInput::readString, IndexTemplateV2::new);
    }

    public static IndexTemplateV2Metadata fromXContent(XContentParser parser) throws IOException {
        return (IndexTemplateV2Metadata)PARSER.parse(parser, null);
    }

    public Map<String, IndexTemplateV2> indexTemplates() {
        return this.indexTemplates;
    }

    @Override
    public EnumSet<MetaData.XContentContext> context() {
        return MetaData.ALL_CONTEXTS;
    }

    @Override
    public Diff<MetaData.Custom> diff(MetaData.Custom before) {
        return new IndexTemplateV2MetadataDiff((IndexTemplateV2Metadata)before, this);
    }

    public static NamedDiff<MetaData.Custom> readDiffFrom(StreamInput in) throws IOException {
        return new IndexTemplateV2MetadataDiff(in);
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.V_7_7_0;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.indexTemplates, StreamOutput::writeString, (outstream, val) -> val.writeTo(outstream));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(INDEX_TEMPLATE.getPreferredName());
        for (Map.Entry<String, IndexTemplateV2> template : this.indexTemplates.entrySet()) {
            builder.field(template.getKey(), (ToXContent)template.getValue());
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.indexTemplates);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexTemplateV2Metadata other = (IndexTemplateV2Metadata)obj;
        return Objects.equals(this.indexTemplates, other.indexTemplates);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> {
            HashMap<String, IndexTemplateV2> templates = new HashMap<String, IndexTemplateV2>();
            while (p.nextToken() != XContentParser.Token.END_OBJECT) {
                String name = p.currentName();
                templates.put(name, IndexTemplateV2.parse(p));
            }
            return templates;
        }, INDEX_TEMPLATE);
    }

    static class IndexTemplateV2MetadataDiff
    implements NamedDiff<MetaData.Custom> {
        final Diff<Map<String, IndexTemplateV2>> indexTemplateDiff;

        IndexTemplateV2MetadataDiff(IndexTemplateV2Metadata before, IndexTemplateV2Metadata after) {
            this.indexTemplateDiff = DiffableUtils.diff(before.indexTemplates, after.indexTemplates, DiffableUtils.getStringKeySerializer());
        }

        IndexTemplateV2MetadataDiff(StreamInput in) throws IOException {
            this.indexTemplateDiff = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), IndexTemplateV2::new, IndexTemplateV2::readITV2DiffFrom);
        }

        @Override
        public MetaData.Custom apply(MetaData.Custom part) {
            return new IndexTemplateV2Metadata(this.indexTemplateDiff.apply(((IndexTemplateV2Metadata)part).indexTemplates));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.indexTemplateDiff.writeTo(out);
        }

        @Override
        public String getWriteableName() {
            return IndexTemplateV2Metadata.TYPE;
        }
    }
}

