'From Squeak3.8 of ''5 May 2005'' [latest update: #6665] on 18 January 2007 at 10:50:10 am'!
SmartSyntaxInterpreterPlugin subclass: #PrintJobPlugin
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'VMConstruction-Plugins'!

!PrintJobPlugin methodsFor: 'system primitives' stamp: 'JMM 2/7/2002 23:41'!
primitivePagePostProcessing: aSessionHandle
	| printJobData status |
	self var: #printJobData declareC: 'PrintingLogic *printJobData'.
	self primitive: 'primitivePagePostProcessing'
		parameters: #(Oop).
	printJobData _ self printingLogicValueOf: aSessionHandle.
	printJobData = nil ifTrue: [interpreterProxy success: false. ^-1].
	self cCode: 'status = ioPagePostProcessing(printJobData)'.
	^status asSmallIntegerObj.
! !

!PrintJobPlugin methodsFor: 'system primitives' stamp: 'JMM 2/7/2002 23:41'!
primitivePagePreProcessing: aSessionHandle
	| printJobData status |
	self var: #printJobData declareC: 'PrintingLogic *printJobData'.
	self primitive: 'primitivePagePreProcessing'
		parameters: #(Oop).

	printJobData _ self printingLogicValueOf: aSessionHandle.
	printJobData = nil ifTrue: [interpreterProxy success: false. ^-1].
	self cCode: 'status = ioPagePreProcessing(printJobData)'.
	^status asSmallIntegerObj.
! !

!PrintJobPlugin methodsFor: 'system primitives' stamp: 'pe 12/7/2006 17:05'!
primitivePageSetForm: aSessionHandle bits: aBitMap bitmapHeight: bh bitmapWidth: bw bitmapDepth: bd printHeight: ph printWidth: pw offsetH: oh offsetW: ow
	| printJobData status bitMap |
	self var: #printJobData declareC: 'PrintingLogic *printJobData'.
	self var: #bitMap declareC: 'char *bitMap'.
	self primitive: 'primitivePageSetFormPrint'
		parameters: #(Oop Oop SmallInteger SmallInteger SmallInteger SmallInteger SmallInteger SmallInteger SmallInteger).
	printJobData _ self printingLogicValueOf: aSessionHandle.
	printJobData = nil ifTrue: [interpreterProxy success: false. ^-1].
	bitMap _ self cCoerce: (interpreterProxy firstIndexableField: aBitMap)
						to: 'char *'.
	self cCode: 'status = ioPageFormPrint(printJobData,bitMap,bh,bw,bd,ph,pw,oh,ow)'.
	^status asSmallIntegerObj.
! !

!PrintJobPlugin methodsFor: 'system primitives' stamp: 'pe 12/7/2006 17:04'!
primitivePageSetForm: aSessionHandle bits: aBitMap  height: h width: w depth: d scaleH: sh scaleW: sw offsetH: oh offsetW: ow
	| printJobData status bitMap |
	self var: #printJobData declareC: 'PrintingLogic *printJobData'.
	self var: #bitMap declareC: 'char *bitMap'.
	self primitive: 'primitivePageSetForm'
		parameters: #(Oop Oop SmallInteger SmallInteger SmallInteger Float Float SmallInteger SmallInteger).
	printJobData _ self printingLogicValueOf: aSessionHandle.
	printJobData = nil ifTrue: [interpreterProxy success: false. ^-1].
	bitMap _ self cCoerce: (interpreterProxy firstIndexableField: aBitMap)
						to: 'char *'.
	self cCode: 'status = ioPageFormScale(printJobData,bitMap,h,w,d,sh,sw,oh,ow)'.
	^status asSmallIntegerObj.
! !

!PrintJobPlugin methodsFor: 'system primitives' stamp: 'JMM 2/8/2002 00:06'!
primitivePageSetPostscript: aSessionHandle postscript: aText
	| printJobData status sz |
	self var: #printJobData declareC: 'PrintingLogic *printJobData'.
	self primitive: 'primitivePageSetPostscript'
		parameters: #(Oop String).
	printJobData _ self printingLogicValueOf: aSessionHandle.
	printJobData = nil ifTrue: [interpreterProxy success: false. ^-1].
	sz _ interpreterProxy byteSizeOf: aText cPtrAsOop.
	self cCode: 'status = ioPagePostscript(printJobData,aText,sz)'.
	^status asSmallIntegerObj.
! !

!PrintJobPlugin methodsFor: 'system primitives' stamp: 'JMM 2/9/2002 01:12'!
primitivePrintCleanup: aSessionHandle
	| printJobData status printJobData2 |
	self var: #printJobData declareC: 'PrintingLogic *printJobData'.
	self var: #printJobData2 declareC: 'PrintingLogic **printJobData2'.
	self primitive: 'primitivePrintCleanup'
		parameters: #(Oop).
	printJobData _ self printingLogicValueOf: aSessionHandle.
	printJobData = nil ifTrue: [interpreterProxy success: false. ^-1].
	printJobData2 _ self cCoerce: (interpreterProxy firstIndexableField: aSessionHandle)
						to: 'PrintingLogic **'.
	self cCode: 'status = ioPrintCleanup(printJobData2)'.
	^status asSmallIntegerObj.
! !

!PrintJobPlugin methodsFor: 'system primitives' stamp: 'JMM 2/9/2002 12:07'!
primitivePrintGetFirstPageNumber: aSessionHandle
	| printJobData firstPage |

	self var: #printJobData declareC: 'PrintingLogic *printJobData'.
	self primitive: 'primitivePrintGetFirstPageNumber'
		parameters: #(Oop).
	printJobData _ self printingLogicValueOf: aSessionHandle.
	printJobData = nil ifTrue: [interpreterProxy success: false. ^0].
	self cCode: 'firstPage = ioPrintGetFirstPageNumber(printJobData)'.
	^firstPage asSmallIntegerObj.
! !

!PrintJobPlugin methodsFor: 'system primitives' stamp: 'JMM 2/9/2002 12:19'!
primitivePrintGetLastPageNumber: aSessionHandle
	| printJobData lastPage |

	self var: #printJobData declareC: 'PrintingLogic *printJobData'.
	self primitive: 'primitivePrintGetLastPageNumber'
		parameters: #(Oop).
	printJobData _ self printingLogicValueOf: aSessionHandle.
	printJobData = nil ifTrue: [interpreterProxy success: false. ^0].
	self cCode: 'lastPage = ioPrintGetLastPageNumber(printJobData)'.
	^lastPage asSmallIntegerObj.
! !

!PrintJobPlugin methodsFor: 'system primitives' stamp: 'JMM 2/7/2002 23:14'!
primitivePrintPostProcessing: aSessionHandle
	| printJobData status |
	self var: #printJobData declareC: 'PrintingLogic *printJobData'.
	self primitive: 'primitivePrintPostProcessing'
		parameters: #(Oop).
	printJobData _ self printingLogicValueOf: aSessionHandle.
	printJobData = nil ifTrue: [interpreterProxy success: false. ^-1].
	self cCode: 'status = ioPrintPostProcessing(printJobData)'.
	^status asSmallIntegerObj.
! !

!PrintJobPlugin methodsFor: 'system primitives' stamp: 'JMM 2/7/2002 23:15'!
primitivePrintPreProcessing: aSessionHandle pages: aNumber
	| printJobData status |
	self var: #printJobData declareC: 'PrintingLogic *printJobData'.
	self primitive: 'primitivePrintPreProcessing'
		parameters: #(Oop SmallInteger).

	printJobData _ self printingLogicValueOf: aSessionHandle.
	printJobData = nil ifTrue: [interpreterProxy success: false. ^-1].
	aNumber < 0 ifTrue: [interpreterProxy success: false. ^-1].
	self cCode: 'status = ioPrintPreProcessing(printJobData,aNumber)'.
	^status asSmallIntegerObj.
! !

!PrintJobPlugin methodsFor: 'system primitives' stamp: 'pe 12/16/2006 16:43'!
primitivePrintPreProcessing: aSessionHandle pages: aNumber pageRectangle: pageRectangle paperRectangle: paperRectangle dpi: dpiPoint
	| printJobData printResolution validPageFormat status tempVal originPageOop cornerPageOop originPaperOop cornerPaperOop |
	self var: #printJobData declareC: 'PrintingLogic *printJobData'.
	self var: #printResolution declareC: 'PMResolution printResolution'.
	self var: #validPageFormat declareC: 'Boolean validPageFormat = FALSE'.

	self primitive: 'primitivePrintPreProcessingPageRectanglePaperRectangleDpi'
		parameters: #(Oop SmallInteger Rectangle Rectangle Point).

	printJobData _ self printingLogicValueOf: aSessionHandle.
	printJobData = nil ifTrue: [interpreterProxy success: false. ^-1].
	aNumber < 0 ifTrue: [interpreterProxy success: false. ^-1].

	tempVal := interpreterProxy fetchInteger: 0 ofObject: dpiPoint.
	self cCode: 'printResolution.hRes = tempVal'.
	tempVal := interpreterProxy fetchInteger: 1 ofObject: dpiPoint.
	self cCode: 'printResolution.vRes = tempVal'.

	self cCode: 'status = ioPrintPreProcessingRes(printJobData, aNumber, &printResolution)'.
	status ~= 0 ifTrue: [interpreterProxy success: false. ^nil].
	"Get the page and paper size"
	self cCode: 'Validate(printJobData)'.
	self cCode: 'PMGetAdjustedPageRect(printJobData->pageFormat, &printJobData->pageRect)'.
	self cCode: 'PMGetAdjustedPaperRect(printJobData->pageFormat, &printJobData->paperRect)'.

	"save resolution"
	self cCode: 'tempVal = (int)printResolution.hRes'.
	interpreterProxy storeInteger: 0 ofObject: dpiPoint withValue: tempVal.
	self cCode: 'tempVal = (int)printResolution.vRes'.
	interpreterProxy storeInteger: 1 ofObject: dpiPoint withValue: tempVal.

	"Save paper and page size"
	originPageOop := interpreterProxy fetchPointer: 0 ofObject: pageRectangle.
	cornerPageOop := interpreterProxy fetchPointer: 1 ofObject: pageRectangle.
	originPaperOop := interpreterProxy fetchPointer: 0 ofObject: paperRectangle.
	cornerPaperOop := interpreterProxy fetchPointer: 1 ofObject: paperRectangle.

	self cCode: 'tempVal = (int)printJobData->pageRect.left'.
	interpreterProxy storeInteger: 0 ofObject: originPageOop withValue: tempVal.
	self cCode: 'tempVal = (int)printJobData->pageRect.top'.
	interpreterProxy storeInteger: 1 ofObject: originPageOop withValue: tempVal.
	self cCode: 'tempVal = (int)printJobData->pageRect.right'.	
	interpreterProxy storeInteger: 0 ofObject: cornerPageOop withValue: tempVal.
	self cCode: 'tempVal = (int)printJobData->pageRect.bottom'.
	interpreterProxy storeInteger: 1 ofObject: cornerPageOop withValue: tempVal.

	self cCode: 'tempVal = (int)printJobData->paperRect.left'.
	interpreterProxy storeInteger: 0 ofObject: originPaperOop withValue: tempVal.
	self cCode: 'tempVal = (int)printJobData->paperRect.top'.
	interpreterProxy storeInteger: 1 ofObject: originPaperOop withValue: tempVal.
	self cCode: 'tempVal = (int)printJobData->paperRect.right'.	
	interpreterProxy storeInteger: 0 ofObject: cornerPaperOop withValue: tempVal.
	self cCode: 'tempVal = (int)printJobData->paperRect.bottom'.
	interpreterProxy storeInteger: 1 ofObject: cornerPaperOop withValue: tempVal.

	status ~= 0 ifTrue: [interpreterProxy success: false. ^nil].

	^status asSmallIntegerObj.
! !

!PrintJobPlugin methodsFor: 'system primitives' stamp: 'pe 12/6/2006 12:22'!
primitivePrintSetup
	| printingLogicOop printJobData status |

	self var: #printJobData declareC: 'PrintingLogic **printJobData'.
	self primitive: 'primitivePrintSetup'.
	printingLogicOop _ interpreterProxy instantiateClass: interpreterProxy classByteArray
					indexableSize: 4.	
	printJobData _ self cCoerce: (interpreterProxy firstIndexableField: printingLogicOop)
						to: 'PrintingLogic **'.
	self cCode: 'status = ioPrintSetup(printJobData)'.
	status ~= 0 ifTrue: [interpreterProxy success: false. ^nil].
	^printingLogicOop.
! !

!PrintJobPlugin methodsFor: 'system primitives' stamp: 'pe 12/8/2006 19:35'!
primitivePrintSetupOnRectangle: aRectangle
	| printingLogicOop printJobData status originOop cornerOop tempVal |

	self var: #printJobData declareC: 'PrintingLogic **printJobData'.
	self
		primitive: 'primitivePrintSetupOnRectangle'
		parameters: #(Rectangle).

	printingLogicOop _ interpreterProxy instantiateClass: interpreterProxy classByteArray
					indexableSize: 4.	
	printJobData _ self cCoerce: (interpreterProxy firstIndexableField: printingLogicOop)
						to: 'PrintingLogic **'.

	status := self ioPrintSetup: printJobData.
	self cCode: 'PrintingLogicPtr printJob = *printJobData'.
	self cCode: 'PMGetAdjustedPageRect(printJob->pageFormat, &printJob->pageRect)'.
	originOop := interpreterProxy fetchPointer: 0 ofObject: aRectangle.
	cornerOop := interpreterProxy fetchPointer: 1 ofObject: aRectangle.

	self cCode: 'tempVal = (int)printJob->pageRect.left'.
	interpreterProxy storeInteger: 0 ofObject: originOop  withValue: tempVal.
	self cCode: 'tempVal = (int)printJob->pageRect.top'.
	interpreterProxy storeInteger: 1 ofObject: originOop  withValue: tempVal.
	self cCode: 'tempVal = (int)printJob->pageRect.right'.	
	interpreterProxy storeInteger: 0 ofObject: cornerOop  withValue: tempVal.
	self cCode: 'tempVal = (int)printJob->pageRect.bottom'.
	interpreterProxy storeInteger: 1 ofObject: cornerOop  withValue: tempVal.

	status ~= 0 ifTrue: [interpreterProxy success: false. ^nil].
	^printingLogicOop.

! !

!PrintJobPlugin methodsFor: 'support' stamp: 'JMM 2/7/2002 21:58'!
initialiseModule
	self export: true.
	^self cCode: 'ioInitPrintJob()' inSmalltalk:[true]! !

!PrintJobPlugin methodsFor: 'support' stamp: 'JMM 2/7/2002 17:44'!
printingLogicValueOf: handle 
	"Return a pointer to the first byte of of the PrintingLogic record within the  
	given Smalltalk object, or nil if handle is not a PrintingLogic record."
	| index |

	self returnTypeC: 'PrintingLogic *'.
	self var: #index declareC: 'PrintingLogic ** index'.
	interpreterProxy success: ((interpreterProxy isBytes: handle)
			and: [(interpreterProxy byteSizeOf: handle)
					= 4]).
	interpreterProxy failed
		ifTrue: [^ nil]
		ifFalse: 
			[index _ self cCoerce: (interpreterProxy firstIndexableField: handle) 
				to: 'PrintingLogic **'.
			index = 0 ifTrue: [^nil]. 
			^ self cCode: '*index']! !

!PrintJobPlugin methodsFor: 'support' stamp: 'JMM 2/7/2002 21:59'!
shutdownModule
	self export: true.
	^self cCode: 'ioShutdownPrintJob()' inSmalltalk:[true]! !


!PrintJobPlugin class methodsFor: 'translation' stamp: 'JMM 8/7/2002 17:59'!
hasHeaderFile
	"If there is a single intrinsic header file to be associated with the plugin, here is where you want to flag"
	^true! !

!PrintJobPlugin class methodsFor: 'translation' stamp: 'JMM 8/7/2002 18:00'!
requiresPlatformFiles
	"default is ok for most, any plugin needing platform specific files must say so"
	^true! !

