/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.freedesktop.cairo;

import org.gnu.glib.Enum;

/**
 *
 * @deprecated This class is part of the java-gnome 2.x family of libraries,
 *             which, due to their inefficiency and complexity, are no longer
 *             being maintained and have been abandoned by the java-gnome
 *             project. This class may exist in java-gnome 4.0; look out for
 *             <code>org.freedesktop.cairo.Extend</code>.
 *             As this package was never correctly implemented in java-gnome 2.x,
 *             any new code written will likely have a considerably different
 *             public API.
 */
public class Extend extends Enum {

    static final private int _NONE = 0;

    /**
     * pixels outside of the source pattern are fully transparent
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    static final public Extend NONE = new Extend(_NONE);

    static final private int _REPEAT = 1;

    /**
     * the pattern is tiled by repeating
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    static final public Extend REPEAT = new Extend(_REPEAT);

    static final private int _REFLECT = 2;

    /**
     * the pattern is tiled by reflecting at the edges
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    static final public Extend REFLECT = new Extend(_REFLECT);

    static final private int _PAD = 3;

    /**
     * pixels outside of the pattern copy the closest pixel from the source
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    static final public Extend PAD = new Extend(_PAD);

    static final private Extend[] theInterned = new Extend[] { NONE, REPEAT,
            REFLECT, PAD };

    static private java.util.Hashtable theInternedExtras;

    static final private Extend theSacrificialOne = new Extend(0);

    static public Extend intern(int value) {
        if (value < theInterned.length) {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) {
            theInternedExtras = new java.util.Hashtable();
        }
        Extend already = (Extend) theInternedExtras.get(theSacrificialOne);
        if (already == null) {
            already = new Extend(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private Extend(int value) {
        value_ = value;
    }

    public boolean test(Extend other) {
        return (value_ & other.value_) == other.value_;
    }
}
