
/*
 * Copyright (C) 2010-2024 Oracle and/or its affiliates.
 *
 * This file is part of a free software library; you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General
 * Public License version 2.1 as published by the Free Software
 * Foundation and shipped in the \"COPYING.LIB\" file with this library.
 * The library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY of any kind.
 *
 * Oracle LGPL Disclaimer: For the avoidance of doubt, except that if
 * any license choice other than GPL or LGPL is available it will
 * apply instead, Oracle elects to use only the Lesser General Public
 * License version 2.1 (LGPLv2) at this time for any software where
 * a choice of LGPL license versions is made available with the
 * language indicating that LGPLv2 or any later version may be used,
 * or where a choice of which version of the LGPL is applied is
 * otherwise unspecified.

 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * SPDX-License-Identifier: LGPL-2.1-only
 */

/*
 * ProcessInputStatus.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_7_1;

import org.virtualbox_7_1.jaxws.*;
import javax.xml.ws.*;

/**
Process input statuses.
Interface ID: <code>{A4A0EF9C-29CC-4805-9803-C8215AE9DA6C}</code>
*/
public enum ProcessInputStatus
{

/**
Undefined state.
*/
    Undefined(0),

/**
Input pipe is broken.
*/
    Broken(1),

/**
Input pipe became available for writing.
*/
    Available(10),

/**
Data has been successfully written.
*/
    Written(50),

/**
Too much input data supplied, data overflow.
*/
    Overflow(100);

    private final int value;

    ProcessInputStatus(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static ProcessInputStatus fromValue(long v)
    {
        for (ProcessInputStatus c: ProcessInputStatus.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static ProcessInputStatus fromValue(String v)
    {
        return valueOf(ProcessInputStatus.class, v);
    }
}

