/**
 * CIMSetQualifierTypeOp.java
 *
 * (C) Copyright IBM Corp. 2005, 2006
 *
 * THIS FILE IS PROVIDED UNDER THE TERMS OF THE COMMON PUBLIC LICENSE 
 * ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE 
 * CONSTITUTES RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
 *
 * You can obtain a current copy of the Common Public License from
 * http://www.opensource.org/licenses/cpl1.0.php
 *
 * @author: Roberto Pineiro, IBM, roberto.pineiro@us.ibm.com  
 * @author: Chung-hao Tan, IBM ,chungtan@us.ibm.com
 * 
 * 
 * Change History
 * Flag       Date        Prog         Description
 *------------------------------------------------------------------------------- 
 * 1535756    2006-08-07  lupusalex    Make code warning free
 *
 */

package org.sblim.wbem.client.operations;

import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMQualifierType;

public class CIMSetQualifierTypeOp extends CIMOperation {

	protected CIMQualifierType iQualifierType;

	public CIMSetQualifierTypeOp(CIMObjectPath objectName, CIMQualifierType qualifierType) {
		iMethodCall = "SetQualifierTypeOp";
		iObjectName = objectName;
		iQualifierType = qualifierType;
	}

	
	/**
	 * Returns qualifierType
	 *
	 * @return The value of qualifierType.
	 */
	public CIMQualifierType getQualifierType() {
		return iQualifierType;
	}

}
