/*
 * nm_to_device.c  - Convert device nmemonic to device type.
 *
 *	Description:
 *		Convert two character device nmemonic to device type.
 *
 *	On entry:
 *		nm		= The nmemonic name for the device.
 *
 *	Returns:
 *		The device type or a -1 if the nmemonic is not recognized.
 *
 */

/*
 *    SAM-QFS_notice_begin
 *
 *      Solaris 2.x Sun Storage & Archiving Management File System
 *
 *		Copyright (c) 2007 Sun Microsystems, Inc. All Rights Reserved.
 *
 *		U.S. Government Rights - Commercial software. Government users are
 *	subject to the Sun Microsystems, Inc. standard license agreement and applicable
 *	provisions of the FAR and its supplements.
 *
 *      	Use is subject to license terms. Sun, Sun Microsystems and the Sun logo
 *	are trademarks or registered trademarks of Sun Microsystems, Inc. in the U.S.
 *	and other countries.
 *
 *    SAM-QFS_notice_end
 */

/*
 *	LGPL NOTICE
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License as published by the Free Software Foundation; either
 *	version 2.1 of the License, or (at your option) any later version.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#pragma ident "$Revision$"


#ifdef LIBS_64
#define	DEC_INIT
#endif	/* LIBS_64 */

#include <string.h>
#include <sys/types.h>
#include <pub/devstat.h>
#include <sam/types.h>
#include <sam/param.h>

#include "sam/devnm.h"


int
nm_to_device(
char *nm)		/* Device mnemonic */
{
	int		i;

	/* For third party, or in the second character */
	if (*nm == 'z') {
		return (DT_THIRD_PARTY | *(nm + 1));
	}

	for (i = 0; i >= 0; i++) {
		if (dev_nm2dt[i].nm == NULL) {
			return (-1);
		}
		if (strcmp(nm, dev_nm2dt[i].nm) == 0) {
			return (dev_nm2dt[i].dt);
		}
	}
	/* NOTREACHED */
}
