/*
 * sam_labels.h - common label processing
 *
 * Description:
 * Contains structs and types common to both tape and optical label
 * processing.
 */

/*
 *    SAM-QFS_notice_begin
 *
 *      Solaris 2.x Sun Storage & Archiving Management File System
 *
 *		Copyright (c) 2007 Sun Microsystems, Inc. All Rights Reserved.
 *
 *		U.S. Government Rights - Commercial software. Government users are
 *	subject to the Sun Microsystems, Inc. standard license agreement and applicable
 *	provisions of the FAR and its supplements.
 *
 *      	Use is subject to license terms. Sun, Sun Microsystems and the Sun logo
 *	are trademarks or registered trademarks of Sun Microsystems, Inc. in the U.S.
 *	and other countries.
 *
 *    SAM-QFS_notice_end
 */

/*
 *	LGPL NOTICE
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License as published by the Free Software Foundation; either
 *	version 2.1 of the License, or (at your option) any later version.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#if !defined(_AML_LABELS_H)
#define	_AML_LABELS_H

#pragma ident "$Revision$"

#define	LEN_TAPE_VSN   6		/* length of tape vsn */
#define	LEN_OPTIC_VSN  31		/* length of optical vsn */

/*
 * flags for label processing
 */

#define	LABEL_ERASE    	0x01		/* erase media during labeling */
#define	LABEL_RELABEL  	0x02		/* relabel */
#define	LABEL_SLOT	0x04		/* slot request to robot */
#define	LABEL_BARCODE  	(0x08 | 0x04)	/* label with bar code */

typedef struct {
	int	eq;			/* equipment to label, or robot */
	int	block_size;		/* block size for this label */
	u_int	slot;			/* slot within robot to label */
	u_int	flags;			/* flag bits */
	int	part;			/* D2 partition id */
	char	*vsn;			/* vsn */
	char	*info;			/* information */
}label_req_t;

typedef struct {
	int	eq;
	int	block_size;
	int 	ea;
	u_int 	flags;
	int 	Asize;
	int 	Bsize;
	int 	Acount;
	int 	Bcount;
	int 	format;
	int 	layout;
	char 	*vsn;
	char 	*info;
}format_req_t;


#endif  /* !defined(_AML_LABELS_H) */
