#include "xcin.h"

void
debugPrintLangIM (langim *langIM) {

    if(!isDebugMode()) return;
    
    imnodes *node;
    
    if(langIM->lang)
        printf("lang: %s\n", langIM->lang);
    if(langIM->path)
        printf("path: %s\n", langIM->path);

    node = langIM->first;
    while ( node != langIM->last) {
        if(node->id)
            printf("id: %s\n", node->id);
        if(node->name)
            printf("  name: %s\n", node->name);
        if(node->file)
            printf("  file: %s\n", node->file);
        if(node->n_preedit)
            printf("  n_preddit: %d\n", node->n_preedit);
        node = node->next;
    }
}

void
parseIMSingle (xmlDocPtr doc, xmlNodePtr cur, langim *langIM) {

	imnodes *node;
	node = calloc(1, sizeof(imnodes));

	node->id = xmlGetProp(cur, "name");
	cur = cur->xmlChildrenNode;
	while (cur != NULL) {
	    if ((!xmlStrcmp(cur->name, "name"))) {
		    node->name = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
 	    }
	    else if ((!xmlStrcmp(cur->name, "path"))) {
		    node->file = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
 	    }
	    else if ((!xmlStrcmp(cur->name, "preeditnum"))) {
		    node->n_preedit = atoi((const char *)xmlNodeListGetString(doc, cur->xmlChildrenNode, 1));
 	    }
	cur = cur->next; }

	if(langIM->last != NULL){
		langIM->last->next = node;
                langIM->last->next->parent = langIM;
	} else {
		langIM->first = node;
                langIM->first->parent = langIM;
	}
	langIM->last = node;
    return;
}


void
parseIMs (xmlDocPtr doc, xmlNodePtr cur, langim *langIM) {
    xmlNodePtr childcur;

    childcur = cur->xmlChildrenNode;
    while (childcur != NULL) {
        if ((!xmlStrcmp(childcur->name, (const xmlChar *)"supportedlang"))){
            langIM->lang = xmlNodeListGetString(doc, childcur->xmlChildrenNode, 1);
        }
        else if ((!xmlStrcmp(childcur->name, (const xmlChar *)"path"))
                && !xmlStrcmp(xmlGetProp(childcur, "default"), (const xmlChar *)"yes") ){
            langIM->path = xmlNodeListGetString(doc, childcur->xmlChildrenNode, 1);
        }
        else if ((!xmlStrcmp(childcur->name, (const xmlChar *)"inputmethod"))){
            parseIMSingle (doc, childcur, langIM);
        }
         
    childcur = childcur->next;
    }
}

imnodes*
fetchIMpos (langim *langIM, int n) {
    int i;
    imnodes *node;

    node = langIM->first;
    for(i=1; i<=n; i++){
        if(node->next == NULL)
            return NULL;
	node = node->next;
    }

    return node;
}

void
parseConf(langim *langIM) {

	xmlDocPtr doc;
	xmlNodePtr cur;

	doc = xmlParseFile("/usr/lib/im/locale/zh_TW/xcin/xcin.xml.conf");
	
	if (doc == NULL ) {
		fprintf(stderr,"Document not parsed successfully. \n");
		return;
	}
	
	cur = xmlDocGetRootElement(doc);
	
	if (cur == NULL) {
		fprintf(stderr,"empty document\n");
		xmlFreeDoc(doc);
		return;
	}
	
	if (xmlStrcmp(cur->name, (const xmlChar *) "xcin")) {
		fprintf(stderr,"document is not a xcin xml");
		xmlFreeDoc(doc);
		return;
	}
	
	cur = cur->xmlChildrenNode;
    /* test to parse single <lang> */
	while (cur != NULL){
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"inputmethods"))){
            parseIMs (doc, cur, langIM);
        }
		cur = cur->next;
	}
	
	xmlFreeDoc(doc);

    /* test print out */
    debugPrintLangIM (langIM);
}

void freeConf(langim *inputstyles)
{
    if (inputstyles){
        imnodes *node = inputstyles->first;
        imnodes *nextnode;
        while( node != inputstyles->last ){
            nextnode = node->next;
            free(node);
            node = nextnode;
        }
        free((langim*) inputstyles);
    }
}
